#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import shutil
import tests
import tempfile
import unittest

class FunctionalTestCase(unittest.TestCase):

    def setUp(self):
        import pybaz

        self.tempdir = tempfile.mkdtemp()
        os.environ['HOME'] = self.tempdir
        pybaz.set_my_id("<demo@example.com>")
        archive = pybaz.make_archive('anarchive@example.com',
                                     os.path.join(self.tempdir, 'archive'))
        import_tree = os.path.join (self.tempdir, 'import')
        os.mkdir(import_tree)
        tree = pybaz.init_tree(import_tree,
                               'anarchive@example.com/foo--0')
        tree.import_()
        print >>open(os.path.join(import_tree, "proof"), "w"), "yo" 
        tree.add_tag("proof")
        log=tree.log_message()
        log["summary"]="add proof file"
        tree.commit(log=log)
        
        self.bzr_tree = os.path.join(self.tempdir, 'bzr')
        os.mkdir(self.bzr_tree)
        print >>open(os.path.join(self.bzr_tree, "broom"), "w"), "stick" 
        from bzrlib.branch import Branch
        from bzrlib.add import smart_add
        branch = Branch.initialize(self.bzr_tree)
        smart_add([self.bzr_tree], False)
        branch.commit("a message", verbose=False)

        os.mkdir(os.path.join(self.tempdir, "build1"))

    def tearDown(self):
        from config_manager import fake_builds, fake_updates
        shutil.rmtree(self.tempdir, ignore_errors=True)
        while fake_builds: fake_builds.pop()
        while fake_updates: fake_updates.pop()

def test_suite():
    import test_config 
    import test_config_entry
    import test_main
    result = tests.TestSuite()
    result.addTest(test_config.test_suite())
    result.addTest(test_config_entry.test_suite())
    result.addTest(test_main.test_suite())
    return result
