##  Lots of code based on code of Pycasaweb by:
##    Copyright (C) 2006 manatlan manatlan[at]gmail(dot)com
##
##  Changes to use new gdata api by:
##    Copyright (C) 2007 thomas.vanmachelen@gmail.com
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
import sys,os
import urllib,urllib2,urlparse,mimetypes,mimetools
from datetime import datetime
from xml.dom.minidom import parseString


# time format
FORMAT_STRING = "%Y-%m-%dT%H:%M:%S"

#===============================================================================
# functions helpers ...
#===============================================================================
def getText(x):
    """ get textual content of the node 'x' """
    r=""
    for i in x.childNodes:
        if i.nodeType == x.TEXT_NODE:
            r+=i.nodeValue
    return r

def utf8(v):
    """ ensure to get 'v' in an UTF8 encoding (respect None) """
    if v!=None:
        if type(v)!=unicode:
            v=unicode(v,"utf_8","replace")
        v=v.encode("utf_8")
    return v

def mkRequest(url,data=None,headers={}):
    """ create a urlib2.Request """
    if data:
        data = urllib.urlencode(data)
    return urllib2.Request(url,data,headers)

def encode_multipart_formdata(fields, files):
    """
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return (content_type, body) ready for httplib.HTTP instance
    """
    #mimetools._prefix = "some-random-string-you-like"    # vincent patch : http://mail.python.org/pipermail/python-list/2006-December/420360.html
    BOUNDARY = "END_OF_PART" #mimetools.choose_boundary()
    CRLF = '\r\n'
    L = []
    for (key, value) in fields:
        # prepend MediaMultipart posting
        if L == []:
            L.append ("Media multipart posting")
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"' % key)
        L.append('Content-Type: application/atom+xml')
        L.append('')
        L.append(value)
    for (key, filename, mimeType, value) in files:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="filename"; filename="%s"' % (filename))
        L.append('Content-Type: %s' % mimeType)
        L.append('')
        L.append(value)
    L.append('--' + BOUNDARY + '--')
    L.append('')
    body = CRLF.join(L)

    content_type = 'multipart/related; boundary="%s"' % BOUNDARY

    return content_type, body

#-------------------------------------------------------------------------------


# classes
##########################################################################
class PicasaHTTPErrorProcessor(urllib2.HTTPErrorProcessor):
##########################################################################
    """
    Special error processor to pass 201 return code, as that
    is the return code generated by create album
    """
    def http_response(self, request, response):
        # album created
        if response.code == 201:
            return response

        # otherwise: just pass on
        return urllib2.HTTPErrorProcessor.http_response (self, request, response)

    https_response = http_response

# init the opener...
opener = urllib2.build_opener (PicasaHTTPErrorProcessor())
urllib2.install_opener(opener)

###########################################
class PicasaDeleteRequest(urllib2.Request):
###########################################
    def get_method(self):
        return "DELETE"

#####################################
class PicasaWebException(Exception):
#####################################
    """
    Web exception
    """
    pass

#####################################
class GDataApi:
#####################################
    """
    Url factory for doing various picasa operations
    """
    feed = "http://picasaweb.google.com/data/feed/api/"
    entry = "http://picasaweb.google.com/data/entry/api/"
    gallery = "user/%(userid)s?kind=album"
    album_by_id = "user/%(userid)s/albumid/%(aid)s?kind=photo"
    picture_by_id = "user/%(userid)s/albumid/%(aid)s/photoid/%(pid)s"
    delete_picture = entry + "user/%(userid)s/albumid/%(aid)s/photoid/%(pid)s/%(version)s" 
    post_url = feed + "user/%(userid)s"
    post_picture = feed + "user/%(userid)s/albumid/%(aid)s"

    def _getgalleryfeed (userid):
        return GDataApi.feed + GDataApi.gallery % {"userid" : userid}

    def _getalbumfeedbyid (userid, aid):
        return GDataApi.feed + GDataApi.album_by_id % {"userid" : userid, "aid" : aid }

    def _getpicturefeed (userid, aid, pid):
        return GDataApi.feed + GDataApi.picture_by_id % {"userid" : userid, "aid" : aid, "pid" : pid }

    def _getposturl (userid):
        return GDataApi.post_url % {"userid" : userid }

    def _getposturlforupload (userid, aid):
        return GDataApi.post_picture % {"userid" : userid, "aid" : aid }

    def _getphotodeleteurl (userid, aid, pid, version):
        return GDataApi.delete_picture % {"userid" : userid, "aid" : aid, "pid" : pid, "version" : version }

    # create the static methods
    getalbumfeedbyid = staticmethod (_getalbumfeedbyid)
    getgalleryfeed = staticmethod (_getgalleryfeed)
    getpicturefeed = staticmethod (_getpicturefeed)
    getposturl = staticmethod (_getposturl)
    getposturlforupload = staticmethod (_getposturlforupload)
    getphotodeleteurl = staticmethod (_getphotodeleteurl)

###############################################################################
class GoogleConnection(object):
###############################################################################
    __LOGINURL = "https://www.google.com/accounts/ClientLogin"

    __user=None
    __auth=None
    user=property(lambda s: s.__user)
    auth=property (lambda s: s.__auth)

    def getauthheaders (self, headers={}):
        headers['Authorization'] = 'GoogleLogin auth=' + self.auth
        return headers

    def __init__(self,u,p):
        u=utf8(u)
        p=utf8(p)
        self.__user = u

        headers = {"Content-type": "application/x-www-form-urlencoded",}
        data =    { "null":"Sign in",
                    "Email":u,
                    "Passwd":p,
                    "service":"lh2",
                    "passive":"true",
                    "continue":"http://picasaweb.google.com/",
        }

        request = mkRequest(GoogleConnection.__LOGINURL,data,headers)   # POST
        response = opener.open(request)
        buf=response.read()

        # split response
        for line in buf.split ("\n"):
            if not line.startswith("Auth="):
                continue
            self.__auth = line[5:] # get out the authentication key
            break

        response.close()

        # check auth
        if self.__auth == None:
            raise PicasaWebException("Unable to connect (bad account ?)")


###############################################################################
class PicasaWeb:
###############################################################################
    def __init__(self, user,password):
        """ Create a PicasaWeb instance for the account user/password """
        self.__gc=GoogleConnection(user,password)

    def getAlbums(self):
        """
        Get a dictionary of PicasaAlbum available on this account
        accessible by album name
        """
        l={}

        request = mkRequest (GDataApi.getgalleryfeed (self.__gc.user), headers=self.__gc.getauthheaders())
        response = opener.open(request)
        xml=response.read()
        response.close()

        root=parseString(xml).documentElement

        for i in root.getElementsByTagName("entry"):
            alb = self.createAlbumFromXml(i)
            l[alb.name] = alb

        return l

    def createAlbum(self,name,description="",date=None, public=True):
        """
        Create an Album on picasaweb, return the PicasaAlbum instance
        """
        name=utf8(name)
        description=utf8(description)

        body="""<entry xmlns='http://www.w3.org/2005/Atom' xmlns:media='http://search.yahoo.com/mrss/' xmlns:gphoto='http://schemas.google.com/photos/2007'>
  <title type='text'>%s</title>
  <summary type='text'>%s</summary>
  <gphoto:access>%s</gphoto:access>
  <category scheme='http://schemas.google.com/g/2005#kind'
    term='http://schemas.google.com/photos/2007#album'></category>
</entry>
""" % (
                name,
                description,
                public and "public" or "private"
            )

        content_type = "application/atom+xml; charset=UTF-8"

        headers = {'Content-Type': content_type,
                   'Content-Length': str(len(body)),
                   'Authorization' : 'GoogleLogin auth=' + self.__gc.auth
                  }

        request = urllib2.Request(GDataApi.getposturl(self.__gc.user), body, headers)

        response = opener.open(request)
        xml = response.read()
        response.close ()

        # get root
        root = parseString(xml).documentElement

        return self.createAlbumFromXml (root)

    def createAlbumFromXml (self, element):
        name = getText(element.getElementsByTagName("title")[0]) # title
        id = getText(element.getElementsByTagName("gphoto:id")[0])  # gphoto:id

        return PicasaAlbum (self.__gc, id, name)


###############################################################################
class PicasaAlbum(object):
###############################################################################
    __name=None
    name=property(lambda s: s.__name)
    id=property(lambda s: s.__id)

    __id=None
    __gc=None

    def __init__(self,gc,id,name):
        """ should be only called by PicasaWeb """
        self.__gc = gc
        self.__name = name
        self.__id = utf8(id)

    def getPhotos(self):
        feed = GDataApi.getalbumfeedbyid (self.__gc.user, self.__id)

        request = mkRequest(feed, headers=self.__gc.getauthheaders())
        response = opener.open(request)
        xml=response.read()
        response.close()

        root=parseString(xml).documentElement

        l = {}

        for i in root.getElementsByTagName("entry"):
            photo = self.createPhotoFromXml(i)
            l[photo.id] = photo

        return l

    def uploadPhoto(self,filename,mimeType,description=""):
        """ Upload a picture on this album, return the ID of the new picture """
        filename=utf8(filename)
        description=utf8(description)

        if os.path.isfile(filename):
            uid=abs(id(filename))
            name = os.path.basename(filename)

            xml="""<entry xmlns='http://www.w3.org/2005/Atom'>
  <title>%s</title>
  <summary>%s</summary>
  <category scheme="http://schemas.google.com/g/2005#kind"
    term="http://schemas.google.com/photos/2007#photo"/>
</entry>""" % (name,description)

            content_type, body = encode_multipart_formdata([("xml",xml)], [(uid,filename,mimeType,open(filename,"rb").read() )])

            headers = {'Content-Type': content_type,
                       'Content-Length': str(len(body)),
                       'MIME-version': '1.0',
                       'Authorization' : 'GoogleLogin auth=' + self.__gc.auth
                       }

            request = urllib2.Request(GDataApi.getposturlforupload(self.__gc.user, self.id), body, headers)
            response = opener.open(request)
            xml =response.read()
            response.close()

            root = parseString (xml).documentElement

            return self.createPhotoFromXml (root)
        else:
            raise PicasaWebException("File doesn't exist")

    def deletePhoto (self, photo):
        url = GDataApi.getphotodeleteurl (self.__gc.user, self.id, photo.id, photo.version)

        request = PicasaDeleteRequest (url, headers=self.__gc.getauthheaders())
        response = opener.open(request)
        xml = response.read ()
        response.close()

    def createPhotoFromXml (self, element):
        id = getText(element.getElementsByTagName("gphoto:id")[0])  # gphoto:id
        title = getText(element.getElementsByTagName("title")[0]) # title
        url = element.getElementsByTagName("media:content")[0].getAttribute('url')
        # we use the update tag as picasa doesn't return the real photo date
        timestamp = self.__datetime_from_timestamp(getText(element.getElementsByTagName("updated")[0]))
        version = getText(element.getElementsByTagName("gphoto:version")[0]) # gphoto.version

        return PicasaPhoto (self.__gc, self.id, id, title, url, timestamp, version)

    def __repr__(self):
        return "<album %s : %s>" % (self.__id,self.__name)

    @classmethod
    def __datetime_from_timestamp(cls, timestamp):
        """
        Chops off the millisecond part of a datestring, parses it
        """
        timestamp = timestamp[0:-5]
        try:
            return datetime.strptime(timestamp, FORMAT_STRING)
        except AttributeError:
            import time
            return datetime(*(time.strptime(timestamp, FORMAT_STRING)[0:6]))

###############################################################################
class PicasaPhoto (object):
###############################################################################
    __albumId=None
    __id=None
    __title=None
    __url=None
    __timestamp=None
    __version=None

    __gc=None

    title = property (lambda s : s.__title)
    albumId = property (lambda s : s.__albumId)
    id = property (lambda s : s.__id)
    url = property(lambda s : s.__url)
    timestamp = property(lambda s : s.__timestamp)
    version = property(lambda s: s.__version)

    def __init__ (self, gc, albumId, id, title, url, timestamp, version):
        self.__gc = gc
        self.__albumId = albumId
        self.__id = id
        self.__title = title
        self.__url = url
        self.__timestamp = timestamp
        self.__version = version

    def addTag (self, tag):
        body = """<entry xmlns='http://www.w3.org/2005/Atom'>
  <title>%s</title>
  <category scheme="http://schemas.google.com/g/2005#kind"
    term="http://schemas.google.com/photos/2007#tag"/>
</entry>""" % tag
        
        content_type = "application/atom+xml; charset=UTF-8"

        headers = {'Content-Type': content_type,
                   'Content-Length': str(len(body)),
                   'Authorization' : 'GoogleLogin auth=' + self.__gc.auth
                  }

        request = urllib2.Request(GDataApi.getpicturefeed (self.__gc.user, self.albumId, self.id), body, headers)
        response = opener.open(request)
        xml = response.read()
        response.close ()

