/*
 * Author: Matthew Farrellee <matt@cs.wisc.edu>
 */
package birdbath;

import condor.ClassAdStructAttr;
import condor.CondorCollectorLocator;
import condor.CondorCollectorPortType;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

public class Collector
{
	private CondorCollectorPortType port;

	public Collector(URL endpoint)
	throws ServiceException
	{
		CondorCollectorLocator locator = new CondorCollectorLocator();
		port = locator.getcondorCollector(endpoint);
	}

	public CondorCollectorPortType getPort()
	{
		return port;
	}

	public ClassAdStructAttr[][] queryAnyAds(String constraint)
	throws RemoteException
	{
		return port.queryAnyAds(constraint);
	}

	public ClassAdStructAttr[][] queryLicenseAds(String constraint)
	throws RemoteException
	{
		return port.queryLicenseAds(constraint);
	}

	public ClassAdStructAttr[][] queryMasterAds(String constraint)
	throws RemoteException
	{
		return port.queryMasterAds(constraint);
	}

	public ClassAdStructAttr[][] queryScheddAds(String constraint)
	throws RemoteException
	{
		return port.queryScheddAds(constraint);
	}

	public ClassAdStructAttr[][] queryStartdAds(String constraint)
	throws RemoteException
	{
		return port.queryStartdAds(constraint);
	}

	public ClassAdStructAttr[][] queryStorageAds(String constraint)
	throws RemoteException
	{
		return port.queryStorageAds(constraint);
	}

	public ClassAdStructAttr[][] querySubmittorAds(String constraint)
	throws RemoteException
	{
		return port.querySubmittorAds(constraint);
	}
}
