
import birdbath.Transaction;
import condor.UniverseType;
import java.io.File;
import java.io.FileOutputStream;
import junit.framework.AssertionFailedError;

public class ScheddSingleJobTestCase1
	extends AbstractScheddSingleJobTestCase
{
	private File sourceFile;
	private File destinationFile;

	protected void setUp()
		throws Exception
	{
		super.setUp();

		destinationFile = File.createTempFile("Destination", "SingleJobTestCase1");
		sourceFile = File.createTempFile("Source", "SingleJobTestCase1");

		FileOutputStream output = new FileOutputStream(sourceFile);
		output.write("Hello Condor!".getBytes());
		output.close();
	}

	protected void tearDown()
		throws Exception
	{
		assertTrue(sourceFile.delete());
		assertTrue(destinationFile.delete());
	}

	protected void submitJob(Transaction transaction,
							 int cluster,
							 int job,
							 String owner)
		throws Throwable
	{
		File[] files = {sourceFile};

		transaction.submit(cluster,
						   job,
						   owner,
						   UniverseType.VANILLA,
						   "/bin/cp",
						   sourceFile.getName() + " " + destinationFile.getName(),
						   "OpSys != \"WINNT50\"",
						   null,
						   files);
	}

	protected void jobFinished(Transaction transaction,
							   int cluster,
							   int job)
		throws Throwable
	{
		transaction.getFile(cluster,
							job,
							destinationFile.getName(),
								(int) sourceFile.length(),
							destinationFile);

		AbstractScheddSpoolFileTestCase.compareFiles(sourceFile, destinationFile);
	}
}
