import birdbath.ClassAd;
import birdbath.Transaction;
import junit.framework.AssertionFailedError;

public abstract class AbstractScheddSingleJobTestCase
	extends AbstractScheddTestCase
{
	protected abstract void submitJob(Transaction transaction,
									  int cluster,
									  int job,
									  String owner)
		throws Throwable;

	protected abstract void jobFinished(Transaction transaction,
										int cluster,
										int job)
		throws Throwable;

	protected void runTest()
		throws Throwable
	{
		String owner = System.getProperty("JOB_OWNER");

		if (null == owner)
		{
			throw new AssertionFailedError("Please set JOB_OWNER.");
		}

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		int cluster;
		int job;
		try
		{
			cluster = transaction.createCluster();
			job = transaction.createJob(cluster);

			submitJob(transaction, cluster, job, owner);
		}
		finally
		{
			transaction.commit();
		}

		schedd.requestReschedule();

		ClassAd ad;
		int status;
		do
		{
			Thread.sleep(10 * 1000);

			//            JobStatus
			//            : Integer which indicates the current status of the job, where
			//            1 = Idle, 2 = Running, 3 = Removed, 4 = Completed, and 5 = Held.

			status = Integer.valueOf(new ClassAd(schedd.getJobAd(cluster, job)).get("JobStatus")).intValue();
		}
		while (4 != status);

		transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			jobFinished(transaction, cluster, job);

			transaction.closeSpool(cluster, job);
		}
		finally
		{
			transaction.commit();
		}
	}
}
