/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp;

import condor.gahp.CleanupStep;
import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.CommandResultQueue;
import condor.gahp.CommandsHandler;
import condor.gahp.GahpInterface;
import condor.gahp.IOUtils;
import condor.gahp.QuitHandler;
import condor.gahp.VersionHandler;
import condor.gahp.gt42.CacheProxyFromFileHandler;
import condor.gahp.gt42.DelegateCredentialHandler;
import condor.gahp.gt42.Gt42GenerateSubmitIdHandler;
import condor.gahp.gt42.Gt42GramCallbackAllowHandler;
import condor.gahp.gt42.Gt42GramJobCallbackRegisterHandler;
import condor.gahp.gt42.Gt42GramJobCancelHandler;
import condor.gahp.gt42.Gt42GramJobStartHandler;
import condor.gahp.gt42.Gt42GramJobStatusHandler;
import condor.gahp.gt42.Gt42GramJobSubmitHandler;
import condor.gahp.gt42.Gt42GramPingHandler;
import condor.gahp.gt42.Gt42SetTerminationTimeHandler;
import condor.gahp.gt42.RefreshCredentialHandler;
import condor.gahp.gt42.RefreshProxyFromFileHandler;
import condor.gahp.gt42.UncacheProxyHandler;
import condor.gahp.gt42.UseCachedProxyHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Gahp
implements GahpInterface {
    public static final String VERSION = "GT42 GAHP (GT-4.2.0)";
    protected Hashtable commandDispatchTable = new Hashtable();
    protected CommandResultQueue resultQueue = new CommandResultQueue();
    protected Vector cleanupSteps = new Vector();
    protected static int uniqueIdSeed = 0;
    protected Hashtable commonObjectTable = new Hashtable();
    protected PrintStream stdout;
    protected boolean isAsyncMode = false;
    protected boolean hasNewResults = false;
    protected boolean quitSignaled = false;
    private String printPrefix = "";
    private String newPrintPrefix = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Gahp gahp = new Gahp();
        gahp.stdout = System.out;
        System.setOut(System.err);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String[] stringArray2 = gahp.processCommand("VERSION");
        Object object = gahp.stdout;
        synchronized (object) {
            gahp.stdout.println(stringArray2[0].substring(2));
        }
        while (!gahp.quitSignaled) {
            PrintStream printStream;
            object = null;
            try {
                object = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                printStream = gahp.stdout;
                synchronized (printStream) {
                    gahp.stdout.println(gahp.printPrefix + "E");
                    continue;
                }
            }
            if (object == null) {
                gahp.requestExit();
                continue;
            }
            String[] stringArray3 = gahp.processCommand((String)object);
            printStream = gahp.stdout;
            synchronized (printStream) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    gahp.stdout.println(gahp.printPrefix + stringArray3[i]);
                }
                if (gahp.newPrintPrefix != null) {
                    gahp.printPrefix = gahp.newPrintPrefix;
                    gahp.newPrintPrefix = null;
                }
            }
        }
        gahp.shutdown();
    }

    public Gahp() {
        this.commandDispatchTable.put("RESULTS", new ResultsHandler());
        this.commandDispatchTable.put("QUIT", new QuitHandler());
        this.commandDispatchTable.put("VERSION", new VersionHandler());
        this.commandDispatchTable.put("COMMANDS", new CommandsHandler());
        this.commandDispatchTable.put("GT4_GRAM_CALLBACK_ALLOW", new Gt42GramCallbackAllowHandler());
        this.commandDispatchTable.put("GT4_GRAM_JOB_SUBMIT", new Gt42GramJobSubmitHandler());
        this.commandDispatchTable.put("GT4_GRAM_JOB_START", new Gt42GramJobStartHandler());
        this.commandDispatchTable.put("GT4_GRAM_JOB_STATUS", new Gt42GramJobStatusHandler());
        this.commandDispatchTable.put("GT4_GRAM_JOB_DESTROY", new Gt42GramJobCancelHandler());
        this.commandDispatchTable.put("GT4_GRAM_CALLBACK_ALLOW", new Gt42GramCallbackAllowHandler());
        this.commandDispatchTable.put("GT4_GRAM_JOB_CALLBACK_REGISTER", new Gt42GramJobCallbackRegisterHandler());
        this.commandDispatchTable.put("GT4_GENERATE_SUBMIT_ID", new Gt42GenerateSubmitIdHandler());
        this.commandDispatchTable.put("GT4_DELEGATE_CREDENTIAL", new DelegateCredentialHandler());
        this.commandDispatchTable.put("GT4_REFRESH_CREDENTIAL", new RefreshCredentialHandler());
        this.commandDispatchTable.put("GT4_DELEGATE_CREDENTIAL_2", new DelegateCredentialHandler());
        this.commandDispatchTable.put("GT4_REFRESH_CREDENTIAL_2", new RefreshCredentialHandler());
        this.commandDispatchTable.put("GT4_SET_TERMINATION_TIME", new Gt42SetTerminationTimeHandler());
        this.commandDispatchTable.put("GT4_SET_TERMINATION_TIME_2", new Gt42SetTerminationTimeHandler());
        this.commandDispatchTable.put("GT4_GRAM_PING", new Gt42GramPingHandler());
        this.commandDispatchTable.put("ASYNC_MODE_ON", new AsyncModeOnHandler());
        this.commandDispatchTable.put("ASYNC_MODE_OFF", new AsyncModeOnHandler());
        this.commandDispatchTable.put("CACHE_PROXY_FROM_FILE", new CacheProxyFromFileHandler());
        this.commandDispatchTable.put("UNCACHE_PROXY", new UncacheProxyHandler());
        this.commandDispatchTable.put("USE_CACHED_PROXY", new UseCachedProxyHandler());
        this.commandDispatchTable.put("REFRESH_PROXY_FROM_FILE", new RefreshProxyFromFileHandler());
        this.commandDispatchTable.put("RESPONSE_PREFIX", new ResponsePrefixHandler());
        Iterator iterator = this.commandDispatchTable.values().iterator();
        while (iterator.hasNext()) {
            ((CommandHandler)iterator.next()).setGahp(this);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                Gahp.this.doCleanupSteps();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setAsyncMode(boolean bl) {
        CommandResultQueue commandResultQueue = this.resultQueue;
        synchronized (commandResultQueue) {
            this.isAsyncMode = bl;
            if (this.isAsyncMode) {
                this.hasNewResults = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(int n, String[] stringArray) {
        CommandResultQueue commandResultQueue = this.resultQueue;
        synchronized (commandResultQueue) {
            if (!this.hasNewResults && this.isAsyncMode) {
                PrintStream printStream = this.stdout;
                synchronized (printStream) {
                    this.stdout.println(this.printPrefix + "R");
                }
            }
            this.hasNewResults = true;
            this.resultQueue.addResult(n, stringArray);
        }
    }

    public String getVersion() {
        return VERSION;
    }

    protected void setPrintPrefix(String string) {
        this.newPrintPrefix = string;
    }

    protected String[] processCommand(String string) {
        String[] stringArray = this.parseCommand(string);
        if (stringArray == null || stringArray.length == 0) {
            return CommandHandlerResponse.SYNTAX_ERROR.returnLine;
        }
        CommandHandler commandHandler = null;
        if (stringArray != null) {
            stringArray[0] = stringArray[0].toUpperCase();
            commandHandler = (CommandHandler)this.commandDispatchTable.get(stringArray[0]);
        }
        if (commandHandler == null) {
            return CommandHandlerResponse.SYNTAX_ERROR.returnLine;
        }
        CommandHandlerResponse commandHandlerResponse = commandHandler.handleCommand(stringArray);
        if (commandHandlerResponse.toRun != null) {
            new Thread(commandHandlerResponse.toRun).start();
        }
        return commandHandlerResponse.returnLine;
    }

    protected String[] parseCommand(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1 && (string.charAt(i + 1) == ' ' || string.charAt(i + 1) == '\n' || string.charAt(i + 1) == '\r')) {
                stringBuffer.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r') {
                vector.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            vector.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupSteps() {
        Vector vector = this.cleanupSteps;
        synchronized (vector) {
            for (int i = 0; i < this.cleanupSteps.size(); ++i) {
                CleanupStep cleanupStep = (CleanupStep)this.cleanupSteps.get(i);
                cleanupStep.doCleanup();
            }
            this.cleanupSteps.clear();
        }
    }

    private void shutdown() {
        this.doCleanupSteps();
        if (this.quitSignaled) {
            System.exit(0);
        }
    }

    public void requestExit() {
        this.quitSignaled = true;
    }

    public String[] getCommands() {
        Vector vector = new Vector();
        vector.addAll(this.commandDispatchTable.keySet());
        Collections.sort(vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCleanupStep(CleanupStep cleanupStep) {
        Vector vector = this.cleanupSteps;
        synchronized (vector) {
            this.cleanupSteps.add(cleanupStep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string) {
        Hashtable hashtable = this.commonObjectTable;
        synchronized (hashtable) {
            return this.commonObjectTable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object storeObject(String string, Object object) {
        Hashtable hashtable = this.commonObjectTable;
        synchronized (hashtable) {
            Object v = this.commonObjectTable.get(string);
            this.commonObjectTable.put(string, object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeObject(String string) {
        Hashtable hashtable = this.commonObjectTable;
        synchronized (hashtable) {
            return this.commonObjectTable.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateUniqueId() {
        String string;
        Gahp gahp = this;
        synchronized (gahp) {
            string = "" + ++uniqueIdSeed;
        }
        return string;
    }

    class ResultsHandler
    implements CommandHandler {
        ResultsHandler() {
        }

        public void setGahp(GahpInterface gahpInterface) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandHandlerResponse handleCommand(String[] stringArray) {
            if (stringArray.length != 1 && stringArray[0].equals("RESULTS")) {
                return CommandHandlerResponse.SYNTAX_ERROR;
            }
            Vector<String> vector = new Vector<String>();
            CommandResultQueue.CommandResult[] commandResultArray = null;
            CommandResultQueue commandResultQueue = Gahp.this.resultQueue;
            synchronized (commandResultQueue) {
                commandResultArray = Gahp.this.resultQueue.flushResultList();
                Gahp.this.hasNewResults = false;
            }
            vector.add("S " + commandResultArray.length);
            for (int i = 0; i < commandResultArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(commandResultArray[i].requestID);
                for (int j = 0; j < commandResultArray[i].result.length; ++j) {
                    stringBuffer.append(' ');
                    stringBuffer.append(IOUtils.escapeWord(commandResultArray[i].result[j]));
                }
                vector.add(stringBuffer.toString());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return new CommandHandlerResponse((String[])objectArray, null);
        }
    }

    class ResponsePrefixHandler
    implements CommandHandler {
        ResponsePrefixHandler() {
        }

        public void setGahp(GahpInterface gahpInterface) {
        }

        public CommandHandlerResponse handleCommand(String[] stringArray) {
            if (stringArray.length != 2 || !stringArray[0].equals("RESPONSE_PREFIX")) {
                return CommandHandlerResponse.SYNTAX_ERROR;
            }
            Gahp.this.setPrintPrefix(stringArray[1]);
            return new CommandHandlerResponse("S");
        }
    }

    class AsyncModeOnHandler
    implements CommandHandler {
        AsyncModeOnHandler() {
        }

        public void setGahp(GahpInterface gahpInterface) {
        }

        public CommandHandlerResponse handleCommand(String[] stringArray) {
            Gahp.this.setAsyncMode(true);
            return new CommandHandlerResponse("S");
        }
    }

    class AsyncModeOffHandler
    implements CommandHandler {
        AsyncModeOffHandler() {
        }

        public void setGahp(GahpInterface gahpInterface) {
        }

        public CommandHandlerResponse handleCommand(String[] stringArray) {
            Gahp.this.setAsyncMode(false);
            return new CommandHandlerResponse("S");
        }
    }

    class NOOP_Handler
    implements CommandHandler {
        NOOP_Handler() {
        }

        public void setGahp(GahpInterface gahpInterface) {
        }

        public CommandHandlerResponse handleCommand(String[] stringArray) {
            return new CommandHandlerResponse("S", null);
        }
    }
}

