/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt4;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt4.GSIUtils;
import condor.gahp.gt4.GramJobUtils;
import org.globus.exec.client.GramJob;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.StateEnumeration;
import org.ietf.jgss.GSSCredential;

public class Gt4GramJobStatusHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n = null;
        String string = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        return new CommandHandlerResponse("S", (Runnable)new JobStatusRunnable(n, string, this.gahp, gSSCredential));
    }

    class JobStatusRunnable
    implements Runnable {
        private int requestId;
        private String jobHandle;
        private GahpInterface gahp;
        private GSSCredential proxy;

        public JobStatusRunnable(int n, String string, GahpInterface gahpInterface, GSSCredential gSSCredential) {
            this.requestId = n;
            this.jobHandle = string;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
        }

        public void run() {
            String[] stringArray;
            String string = null;
            String string2 = null;
            int n = -1;
            try {
                stringArray = new GramJob();
                stringArray.setHandle(this.jobHandle);
                GramJobUtils.setDefaultJobAttributes((GramJob)stringArray, this.proxy);
                stringArray.refreshStatus();
                StateEnumeration stateEnumeration = stringArray.getState();
                string = stateEnumeration.getValue();
                if (stateEnumeration.equals((Object)StateEnumeration.Failed)) {
                    FaultType faultType = stringArray.getFault();
                    string2 = faultType != null ? faultType.getDescription()[0].toString() : "NULL";
                }
                n = stringArray.getExitCode();
            }
            catch (Exception exception) {
                System.err.println("status failed: ");
                exception.printStackTrace(System.err);
                String string3 = exception.getMessage() == null ? "unknown" : exception.getMessage();
                String[] stringArray2 = new String[]{"1", "NULL", "NULL", "NULL", string3};
                this.gahp.addResult(this.requestId, stringArray2);
                return;
            }
            stringArray = new String[]{"0", string, string2, "" + n, "NULL"};
            this.gahp.addResult(this.requestId, stringArray);
        }
    }
}

