/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt4;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt4.CallbackSink;
import condor.gahp.gt4.GSIUtils;
import condor.gahp.gt4.GramJobUtils;
import org.globus.exec.client.GramJob;
import org.ietf.jgss.GSSCredential;

public class Gt4GramJobCancelHandler
implements CommandHandler {
    private GahpInterface gahp = null;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n = null;
        String string = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        return new CommandHandlerResponse("S", (Runnable)new JobCancelRunnable(n, string, this.gahp, gSSCredential));
    }

    class JobCancelRunnable
    implements Runnable {
        private int requestId;
        private String jobHandle;
        private GahpInterface gahp;
        private GSSCredential proxy;

        public JobCancelRunnable(int n, String string, GahpInterface gahpInterface, GSSCredential gSSCredential) {
            this.requestId = n;
            this.jobHandle = string;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
        }

        public void run() {
            String[] stringArray;
            try {
                stringArray = CallbackSink.getAllCallbackSinks(this.gahp);
                GramJob gramJob = stringArray.iterator();
                while (gramJob.hasNext()) {
                    ((CallbackSink)gramJob.next()).removeJobListener(this.jobHandle);
                }
                gramJob = new GramJob();
                gramJob.setHandle(this.jobHandle);
                GramJobUtils.setDefaultJobAttributes(gramJob, this.proxy);
                gramJob.setDelegationEnabled(false);
                gramJob.cancel();
            }
            catch (Exception exception) {
                System.err.println("cancel failed: ");
                exception.printStackTrace(System.err);
                String string = exception.getMessage() == null ? "unknown" : exception.getMessage();
                String[] stringArray2 = new String[]{"1", string};
                this.gahp.addResult(this.requestId, stringArray2);
                return;
            }
            stringArray = new String[]{"0", "NULL"};
            this.gahp.addResult(this.requestId, stringArray);
        }
    }
}

