/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt4;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt4.GSIUtils;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.axis.util.Util;
import org.globus.delegation.DelegationConstants;
import org.globus.delegation.DelegationUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.ietf.jgss.GSSCredential;

public class DelegateCredentialHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n;
        String string = null;
        Date date = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
            if (stringArray[0].equals("GT4_DELEGATE_CREDENTIAL_2")) {
                long l = Long.parseLong(stringArray[3]);
                if (l > 0L) {
                    date = new Date(l * 1000L);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(10, 12);
                date = calendar.getTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        return new CommandHandlerResponse("S", (Runnable)new DelegateCredentialRunnable(n, string, this.gahp, gSSCredential, date));
    }

    static class DelegateCredentialRunnable
    implements Runnable {
        private int requestId;
        private String jobHandle;
        private GahpInterface gahp;
        private GSSCredential proxy;
        private Date credTermTime;

        public DelegateCredentialRunnable(int n, String string, GahpInterface gahpInterface, GSSCredential gSSCredential, Date date) {
            this.requestId = n;
            this.jobHandle = string;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
            this.credTermTime = date;
        }

        public void run() {
            String string = null;
            try {
                int n;
                URL uRL = new URL(this.jobHandle);
                URL uRL2 = new URL("https", uRL.getHost(), uRL.getPort(), "/wsrf/services/DelegationFactoryService");
                ClientSecurityDescriptor clientSecurityDescriptor = new ClientSecurityDescriptor();
                clientSecurityDescriptor.setGSITransport(GSIConstants.SIGNATURE);
                Util.registerTransport();
                clientSecurityDescriptor.setAuthz((Authorization)HostAuthorization.getInstance());
                X509Certificate x509Certificate = GSIUtils.getCertificateToSign(uRL2.toString(), clientSecurityDescriptor);
                GlobusCredential globusCredential = ((GlobusGSSCredentialImpl)this.proxy).getGlobusCredential();
                if (this.credTermTime == null) {
                    n = new Long(globusCredential.getTimeLeft()).intValue();
                } else {
                    long l = (this.credTermTime.getTime() - new Date().getTime()) / 1000L;
                    n = new Long(l).intValue();
                }
                EndpointReferenceType endpointReferenceType = DelegationUtil.delegate((String)uRL2.toString(), (GlobusCredential)globusCredential, (X509Certificate)x509Certificate, (int)n, (boolean)true, (ClientSecurityDescriptor)clientSecurityDescriptor);
                QName qName = new QName(DelegationConstants.NS, "DelegationKey");
                String string2 = endpointReferenceType.getAddress().toString();
                MessageElement messageElement = endpointReferenceType.getProperties().get(qName);
                String string3 = messageElement.getValue();
                String string4 = string2 + "?" + string3;
                string = string2 + "?" + string3;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                String string5 = exception.toString();
                if (string5 == null) {
                    string5 = "unknown";
                }
                this.gahp.addResult(this.requestId, new String[]{"1", "NULL", string5});
                return;
            }
            this.gahp.addResult(this.requestId, new String[]{"0", string, "NULL"});
        }
    }
}

