cd "${PREFIX}"
umask 022

mkdir -p bin lib libexec share/terminfo

echo -e '#/bin/sh\necho hello world' > bin/hello-1.0
chmod a+x bin/hello-1.0


# Tests for various symlink types
pushd bin >/dev/null
ln -sn hello-1.0 hello                  # ...to file in same dir
popd >/dev/null

pushd libexec >/dev/null
ln -sn ../bin/hello greetings           # ...to file in another dir
popd >/dev/null

pushd share >/dev/null
echo -n "" >terminfo/xterm.dat
chmod a+r terminfo/xterm.dat
ln -sn terminfo termcap                 # ...to subdir in same dir
popd >/dev/null

pushd lib >/dev/null
ln -sn libdangle.lib.1 libdangle.lib    # ...dangling link to file
ln -sn ../share/terminfo terminfo       # ...to subdir of another dir
popd >/dev/null
