/*
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla Communicator client code, released
# March 31, 1998.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998-1999
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Joachim Herb <joachim.herb@gmx.de>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
*/

if(!org) var org={};
if(!org.mozdev) org.mozdev={};
if(!org.mozdev.customizeHeaderToolbar) org.mozdev.customizeHeaderToolbar = {};

org.mozdev.customizeHeaderToolbar.messenger = function(){
  var pub = {};
  
  pub.init = function () {
    var onLoadFkt = document.getElementById("messengerWindow").getAttribute("onload");
    if (onLoadFkt) {
      var strTest = new RegExp('OnLoadMessenger', 'g');;
      onLoadFkt = onLoadFkt.replace(strTest, 
        "org.mozdev.customizeHeaderToolbar.messenger.CHTLoadMessenger");
      document.getElementById("messengerWindow").setAttribute("onload", onLoadFkt);
    }
  }
  
  pub.saveToolboxData = function() {
    var hdrToolbox = document.getElementById("header-view-toolbox");
    var hdrToolbar = document.getElementById("header-view-toolbar");
    var saveToolbox = document.getElementById("CHTSaveToolboxData");
    var saveToolbar = document.getElementById("CHTSaveToolbarData");
    if (hdrToolbox && hdrToolbar && saveToolbox && saveToolbar) {
      saveToolbar.firstPermanentChild = hdrToolbar.firstPermanentChild;
      saveToolbar.lastPermanentChild  = hdrToolbar.lastPermanentChild;
      if (hdrToolbox.palette) {
        saveToolbox.palette    = hdrToolbox.palette.cloneNode(true);
      }
      if (hdrToolbox.toolbarset) {
        saveToolbox.toolbarset = hdrToolbox.toolbarset.cloneNode(true);
      }
      saveToolbox.setAttribute("gotData", "true");
    }
    else {
      saveToolbox.setAttribute("gotData", "false");
    }
  }
  
  pub.loadToolboxData = function() {
    var hdrToolbox = document.getElementById("header-view-toolbox");
    var hdrToolbar = document.getElementById("header-view-toolbar");
    var saveToolbox = document.getElementById("CHTSaveToolboxData");
    var saveToolbar = document.getElementById("CHTSaveToolbarData");
    if (hdrToolbox && hdrToolbar && saveToolbox && saveToolbar && saveToolbox.getAttribute("gotData") == "true") {
      hdrToolbar.firstPermanentChild = saveToolbar.firstPermanentChild;
      hdrToolbar.lastPermanentChild = saveToolbar.lastPermanentChild;
      if (saveToolbox.palette) {
        hdrToolbox.palette = saveToolbox.palette.cloneNode(true);
      } else {
      }
      if (saveToolbox.toolbarset) {
        hdrToolbox.toolbarset = saveToolbox.toolbarset.cloneNode(true);
      } else {
      }
    } 
  }
  
  pub.UpdateMailPaneConfig = function(aMsgWindowInitialized) {
    const dynamicIds = ["messagesBox", "mailContent", "threadPaneBox"];
    const layouts = ["standard", "wide", "vertical"];
    var layoutView = gPrefBranch.getIntPref("mail.pane_config.dynamic");
    var desiredId = dynamicIds[layoutView];
    document.getElementById("mailContent")
            .setAttribute("layout", layouts[layoutView]);
    var messagePane = GetMessagePane();
    if (messagePane.parentNode.id != desiredId) {
      ClearAttachmentList();
      var hdrToolbox = document.getElementById("header-view-toolbox");
      var hdrToolbar = document.getElementById("header-view-toolbar");
      var firstPermanentChild = hdrToolbar.firstPermanentChild;
      var lastPermanentChild = hdrToolbar.lastPermanentChild;
      var messagePaneSplitter = GetThreadAndMessagePaneSplitter();
      var desiredParent = document.getElementById(desiredId);
  
      // Here the message pane including the header pane is moved to the
      // new layout by the appendChild() method below.  As described in bug
      // 519956 only elements in the DOM tree are copied to the new place
      // whereas javascript class variables of DOM tree elements get lost.
      // In this case the ToolboxPalette, Toolbarset first/lastPermanentChild
      // are removed which results in the message header pane not being
      // customizable any more.  A workaround for this problem is to clone
      // them first and add them to the DOM tree after the message pane has
      // been moved.
      var cloneToolboxPalette;
      var cloneToolbarset;
      if (hdrToolbox.palette) {
        cloneToolboxPalette = hdrToolbox.palette.cloneNode(true);
      }
      if (hdrToolbox.toolbarset) {
        cloneToolbarset = hdrToolbox.toolbarset.cloneNode(true);
      }
  
      // See Bug 381992. The ctor for the browser element will fire again when we
      // re-insert the messagePaneBox back into the document.  But the dtor
      // doesn't fire when the element is removed from the document.  Manually
      // call destroy here to avoid a nasty leak.
      document.getElementById("messagepane").destroy();
      desiredParent.appendChild(messagePaneSplitter);
      desiredParent.appendChild(messagePane);
      hdrToolbox.palette  = cloneToolboxPalette;
      hdrToolbox.toolbarset = cloneToolbarset;
      hdrToolbar = document.getElementById("header-view-toolbar");
      hdrToolbar.firstPermanentChild = firstPermanentChild;
      hdrToolbar.lastPermanentChild = lastPermanentChild;
      messagePaneSplitter.orient = desiredParent.orient;
      if (aMsgWindowInitialized)
      {
        messenger.setWindow(null, null);
        messenger.setWindow(window, msgWindow);
        if (gDBView && GetNumSelectedMessages() == 1)
          gDBView.reloadMessage();
      }
    }
  }

  const CHTMailPrefObserver = {
    observe: function(subject, topic, prefName) {
      // verify that we're changing the mail pane config pref
      if (topic == "nsPref:changed")
      {
        if (prefName == "mail.pane_config.dynamic")
          pub.UpdateMailPaneConfig(true);
      }
    }
  }
    
  pub.CHTLoadMessenger = function () {   
    // update the pane config before we exit onload otherwise the user may see a flicker if we poke the document   
    // in delayedOnLoadMessenger...
    pub.UpdateMailPaneConfig(false);
    document.loadBindingDocument('chrome://global/content/bindings/textbox.xml');

    // Set a sane starting width/height for all resolutions on new profiles.
    // Do this before the window loads.
    if (!document.documentElement.hasAttribute("width"))
    {
      // Prefer 1024xfull height.
      let defaultHeight = screen.availHeight;
      let defaultWidth = (screen.availWidth <= 1024) ? screen.availWidth : 1024;

      // On small screens, default to maximized state.
      if (defaultHeight <= 600)
        document.documentElement.setAttribute("sizemode", "maximized");
      document.documentElement.setAttribute("width", defaultWidth);
      document.documentElement.setAttribute("height", defaultHeight);
      // Make sure we're safe at the left/top edge of screen
      document.documentElement.setAttribute("screenX", screen.availLeft);
      document.documentElement.setAttribute("screenY", screen.availTop);
    }
    
    gPrefBranch.QueryInterface(Components.interfaces.nsIPrefBranch2);
    gPrefBranch.addObserver("mail.pane_config.dynamic", CHTMailPrefObserver, false);
    
    MailOfflineMgr.init();
    CreateMailWindowGlobals();
    GetMessagePane().collapsed = true;
    
    // - initialize tabmail system
    // Do this before LoadPostAccountWizard since that code selects the first
    //  folder for display, and we want gFolderDisplay setup and ready to handle
    //  that event chain.
    // Also, we definitely need to register the tab type prior to the call to
    //  specialTabs.openSpecialTabsOnStartup below.
    let tabmail = document.getElementById('tabmail');
    if (tabmail)
    {
      // mailTabType is defined in mailWindowOverlay.js
      tabmail.registerTabType(mailTabType);
      // glodaFacetTab* in glodaFacetTab.js
      tabmail.registerTabType(glodaFacetTabType);
      tabmail.registerTabMonitor(QuickSearchTabMonitor);
      tabmail.registerTabMonitor(statusMessageCountsMonitor);
      tabmail.openFirstTab();
    }
    
    // verifyAccounts returns true if the callback won't be called
    // We also don't want the account wizard to open if any sort of account exists
    if (verifyAccounts(LoadPostAccountWizard, false, AutoConfigWizard))
      LoadPostAccountWizard();
    
    // This also registers the contentTabType ("contentTab")
    specialTabs.openSpecialTabsOnStartup();
    
    window.addEventListener("AppCommand", HandleAppCommandEvent, true);
  } 
  
  return pub;
}();

org.mozdev.customizeHeaderToolbar.messenger.init();
