/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SOPERSPECTIVECAMERA_H
#define COIN_SOPERSPECTIVECAMERA_H

#include <Inventor/nodes/SoSubNode.h>
#include <Inventor/nodes/SoCamera.h>


class COIN_DLL_API SoPerspectiveCamera : public SoCamera {
  typedef SoCamera inherited;

  SO_NODE_HEADER(SoPerspectiveCamera);

public:
  static void initClass(void);
  SoPerspectiveCamera(void);

  SoSFFloat heightAngle;

  virtual void scaleHeight(float scalefactor);
  virtual SbViewVolume getViewVolume(float useaspectratio = 0.0f) const;

protected:
  virtual ~SoPerspectiveCamera();

  virtual void viewBoundingBox(const SbBox3f & box, float aspect, float slack);
};

#endif // !COIN_SOPERSPECTIVECAMERA_H
