import struct
#import marshal

# ___________________________________________________________________________
#
# Messages
# ___________________________________________________________________________
# the size of a number on the wire
numsize = struct.calcsize("!i")

class Message:
    """ encapsulates Messages and their wire protocol. """
    _types = {}
    def __init__(self, channelid=0, data=''):
        self.channelid = channelid
        self.data = data

    def writeto(self, io):
        # big XXX and all this
        #     data = marshal.dumps(self.data)
        # doesn't work for exchanging data across Python version :-(((
        data = repr(self.data)  # argh

        header = struct.pack("!iii", self.msgtype, self.channelid, len(data))
        io.write(header)
        io.write(data)

    def readfrom(cls, io):
        header = io.read(numsize*3)
        msgtype, senderid, stringlen = struct.unpack("!iii", header)
        if stringlen:
            string = io.read(stringlen)
            # same big XXX as in writeto()
            #     string = marshal.loads(string)
            string = eval(string, {})
        else:
            string = ''
        msg = cls._types[msgtype](senderid, string)
        return msg
    readfrom = classmethod(readfrom)

    def post_sent(self, gateway, excinfo=None):
        pass

    def __repr__(self):
        r = repr(self.data)
        if len(r) > 50:
            return "<Message.%s channelid=%d len=%d>" %(self.__class__.__name__,
                        self.channelid, len(r))
        else:
            return "<Message.%s channelid=%d %r>" %(self.__class__.__name__,
                        self.channelid, self.data)


def _setupmessages():
    #
    # EXIT_GATEWAY and STOP_RECEIVING are messages to cleanly
    # bring down the IO and gateway connection
    #
    # First an EXIT_GATEWAY message is send which results
    # on the other side's receive_handle to send 
    # a STOP_RECEIVING message
    class EXIT_GATEWAY(Message):
        def received(self, gateway):
            # executes in receiver thread 
            for x in gateway.channelfactory.values():
                x._local_close()
            gateway._outgoing.put(self.STOP_RECEIVING())
            gateway._local_trystopexec()
            raise SystemExit
        def post_sent(self, gateway, excinfo=None):
            # executes in sender thread 
            gateway._local_trystopexec()
            gateway.io.close_write()
            raise SystemExit

    class STOP_RECEIVING(Message):
        def received(self, gateway):
            # note that we don't need to close io.close_read()
            # as the sender side will have closed the io
            # already. With sockets closing it would raise
            # a Transport Not Connected exception
            for x in gateway.channelfactory.values():
                x._local_close()
            raise SystemExit
        def post_sent(self, gateway, excinfo=None):
            # after we sent STOP_RECEIVING we don't
            # want to write anything more anymore. 
            gateway.io.close_write()
            raise SystemExit

    class CHANNEL_OPEN(Message):
        def received(self, gateway):
            channel = gateway.channelfactory.new(self.channelid)
            channel._local_schedulexec(self.data) 

    class CHANNEL_NEW(Message):
        def received(self, gateway):
            newid = self.data
            channel = gateway.channelfactory[self.channelid]
            channel._local_receivechannel(newid)

    class CHANNEL_DATA(Message):
        def received(self, gateway):
            channel = gateway.channelfactory[self.channelid]
            channel._local_receivedata(self.data) 

    class CHANNEL_CLOSE(Message):
        def received(self, gateway):
            channel = gateway.channelfactory[self.channelid]
            channel._local_close()

    class CHANNEL_CLOSE_ERROR(Message):
        def received(self, gateway):
            channel = gateway.channelfactory[self.channelid]
            channel._local_close(channel.RemoteError(self.data))

    classes = [x for x in locals().values() if hasattr(x, '__bases__')]
    classes.sort(lambda x,y : cmp(x.__name__, y.__name__))
    i = 0
    for cls in classes:
        Message._types[i] = cls
        cls.msgtype = i
        setattr(Message, cls.__name__, cls)
        i+=1

_setupmessages()

