from __future__ import generators
import py
from py.__.misc import rest 

Option = py.test.Config.Option 
option = py.test.Config.addoptions("documentation check options", 
        Option('-R', '--checkremote',
               action="store_true", dest="checkremote", default=False,
               help="check remote links in ReST files"
        )
) 

def checkdocutils(): 
    try:
        import docutils
    except ImportError:
        py.test.skip("docutils not importable")

def restcheck(path):
    checkdocutils() 
    import docutils.utils

    try: 
        confrest = path.localpath.dirpath('confrest.py')
        if confrest.check(file=1): 
            confrest = confrest.pyimport() 
            confrest.process(path) 
        else: 
            # defer to default processor 
            rest.process(path) 
    except KeyboardInterrupt: 
        raise 
    except docutils.utils.SystemMessage: 
        # we assume docutils printed info on stdout 
        py.test.fail("docutils processing failed, see captured stderr") 

class ReSTSyntaxTest(py.test.Item): 
    def run(self): 
        mypath = self.fspath 
        restcheck(py.path.svnwc(mypath))

class DoctestText(py.test.Item): 
    def run(self): 
        s = self.fspath.read()
        l = []
        prefix = '.. >>> '
        mod = py.std.types.ModuleType(self.fspath.purebasename) 
        for line in s.split('\n'): 
            if line.startswith(prefix): 
                exec py.code.Source(line[len(prefix):]).compile() in mod.__dict__ 
                line = ""
            else: 
                l.append(line)
        docstring = "\n".join(l) 
        self.execute(mod, docstring) 

    def execute(self, mod, docstring): 
        mod.__doc__ = docstring 
        failed, tot = py.compat.doctest.testmod(mod, verbose=1)
        if failed: 
            py.test.fail("doctest %s: %s failed out of %s" %(
                         self.fspath, failed, tot))
        
class LinkCheckerMaker(py.test.collect.Collector): 
    def run(self): 
        l = []
        for call, tryfn, path, lineno in genlinkchecks(self.fspath): 
            l.append(tryfn) 
        return l
        
    def join(self, name): 
        for call, tryfn, path, lineno in genlinkchecks(self.fspath): 
            if tryfn == name: 
                return CheckLink(name, parent=self, args=(tryfn, path, lineno), obj=call)
      
class CheckLink(py.test.Function): 
    def setup(self): 
        pass 
    def teardown(self): 
        pass 

class ReSTChecker(py.test.collect.Module): 
    DoctestText = DoctestText
    def __repr__(self): 
        return py.test.collect.Collector.__repr__(self) 

    def setup(self): 
        pass 
    def teardown(self): 
        pass 
    def run(self): 
        return [self.fspath.basename, 'checklinks', 'doctest']
    def join(self, name): 
        if name == self.fspath.basename: 
            return ReSTSyntaxTest(name, parent=self) 
        elif name == 'checklinks': 
            return LinkCheckerMaker(name, self) 
        elif name == 'doctest': 
            return self.DoctestText(name, self) 

# generating functions + args as single tests 
def genlinkchecks(path): 
    for lineno, line in py.builtin.enumerate(path.readlines()): 
        line = line.strip()
        if line.startswith('.. _'): 
            l = line.split(':', 1)
            if len(l) != 2: 
                continue
            tryfn = l[1].strip() 
            if tryfn.startswith('http:') or tryfn.startswith('https'): 
                if option.checkremote: 
                    yield urlcheck, tryfn, path, lineno 
            else: 
                i = tryfn.find('#') 
                if i != -1: 
                    checkfn = tryfn[:i]
                else: 
                    checkfn = tryfn 
                if checkfn.strip() and (1 or checkfn.endswith('.html')): 
                    yield localrefcheck, tryfn, path, lineno 

def urlcheck(tryfn, path, lineno): 
    try: 
        print "trying remote", tryfn
        py.std.urllib2.urlopen(tryfn)
    except (py.std.urllib2.URLError, py.std.urllib2.HTTPError), e: 
        if e.code in (401, 403): # authorization required, forbidden
            py.test.skip("%s: %s" %(tryfn, str(e)))
        else:
            py.test.fail("remote reference error %r in %s:%d\n%s" %(
                         tryfn, path.basename, lineno+1, e))

def localrefcheck(tryfn, path, lineno): 
    # assume it should be a file 
    i = tryfn.find('#')
    if i != -1: 
        anchor = tryfn[i+1:]
        tryfn = tryfn[:i]
    else: 
        anchor = ''
    fn = path.dirpath(tryfn) 
    ishtml = fn.ext == '.html' 
    fn = fn.new(ext='.txt')
    if not ishtml or not fn.check(file=1): 
        py.test.fail("reference error %r in %s:%d" %(
                      tryfn, path.basename, lineno+1))
    if anchor: 
        source = unicode(fn.read(), 'latin1')
        source = source.lower().replace('-', ' ') # aehem

        anchor = anchor.replace('-', ' ') 
        match2 = ".. _`%s`:" % anchor 
        match3 = ".. _%s:" % anchor 
        candidates = (anchor, match2, match3)
        print "candidates", repr(candidates)
        for line in source.split('\n'): 
            line = line.strip()
            if line in candidates: 
                break 
        else: 
            py.test.fail("anchor reference error %s#%s in %s:%d" %(
                tryfn, anchor, path.basename, lineno+1))


# ___________________________________________________________
# 
# hooking into py.test collector's chain ... 
# because we generate subtests for all link checks 
# it is a bit more convoluted than is strictly neccessary 
# to perform the tests 

class DocDirectory(py.test.collect.Directory): 
    ReSTChecker = ReSTChecker 

    def run(self): 
        results = super(DocDirectory, self).run() 
        for x in self.fspath.listdir('*.txt', sort=True): 
            results.append(x.basename) 
        return results 

    def join(self, name): 
        if not name.endswith('.txt'): 
            return super(DocDirectory, self).join(name) 
        p = self.fspath.join(name) 
        if p.check(file=1): 
            return self.ReSTChecker(p, parent=self) 
Directory = DocDirectory
