/*
 * Copyright 2009 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.rule.logging

import org.codenarc.rule.AbstractAstVisitor
import org.codenarc.rule.AbstractAstVisitorRule
import org.codehaus.groovy.ast.FieldNode
import java.lang.reflect.Modifier

/**
 * Logger objects should be declared private, static, and final. This rule find loggers that are not declared with these modifiers. 
 *
 * @author 'Hamlet D'Arcy'
 * @version $Revision: 523 $ - $Date: 2011-01-14 19:24:59 -0500 (Fri, 14 Jan 2011) $
 */
class LoggerWithWrongModifiersRule extends AbstractAstVisitorRule {
    String name = 'LoggerWithWrongModifiers'
    int priority = 2
    Class astVisitorClass = LoggerWithWrongModifiersAstVisitor
}

class LoggerWithWrongModifiersAstVisitor extends AbstractAstVisitor {
    @Override
    void visitFieldEx(FieldNode fieldNode) {
        if (LogUtil.isMatchingLoggerDefinition(fieldNode.getInitialExpression())) {
            int modifiers = fieldNode.modifiers
            if (!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) {
                addViolation(fieldNode, "The Logger field $fieldNode.name should be private, static, and final")
            }
        }
        super.visitFieldEx(fieldNode)
    }
}
