//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : ps_custom_build_page.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __ps_custom_build_page__
#define __ps_custom_build_page__

#include "globals.h"
/**
@file
Subclass of PSCustomBuildBasePage, which is generated by wxFormBuilder.
*/

#include "project_settings_base_dlg.h"
#include "project_settings_dlg.h"

//// end generated include
class ProjectSettingsDlg;

/** Implementing PSCustomBuildBasePage */
class PSCustomBuildPage : public PSCustomBuildBasePage, public IProjectSettingsPage
{
    wxString            m_projectName;
    long                m_selecteCustomTaregt;

    ProjectSettingsDlg *m_dlg;
    StringManager m_stringManager;
protected:
    virtual void OnProjectEnabledUI(wxUpdateUIEvent& event);
    // Handlers for PSCustomBuildBasePage events.
    void OnCustomBuildEnabled( wxCommandEvent& event );
    void OnCustomBuildEnabledUI( wxUpdateUIEvent& event );
    void OnCmdEvtVModified( wxCommandEvent& event );
    void OnBrowseCustomBuildWD( wxCommandEvent& event );
    void OnItemActivated( wxListEvent& event );
    void OnItemSelected( wxListEvent& event );
    void OnNewTarget( wxCommandEvent& event );
    void OnEditTarget( wxCommandEvent& event );
    void OnEditTargetUI( wxUpdateUIEvent& event );
    void OnDeleteTarget( wxCommandEvent& event );
    void OnDeleteTargetUI( wxUpdateUIEvent& event );
    void OnCustomBuildCBEnabledUI(wxUpdateUIEvent& event);

public:
    /** Constructor */
    PSCustomBuildPage( wxWindow* parent, const wxString &projectName, ProjectSettingsDlg *dlg );
    //// end generated class members

    virtual void Load(BuildConfigPtr buildConf);
    virtual void Save(BuildConfigPtr buildConf, ProjectSettingsPtr projSettingsPtr);
    virtual void Clear();

protected:
    void                DoEditTarget(long item);
    void                DoUpdateTarget(long item, const wxString &target, const wxString &cmd);
    wxString            GetTargetCommand(const wxString& target);
    ProjectSettingsDlg* GetDlg();
};

#endif // __ps_custom_build_page__
