//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : debuggersettingsdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 #ifndef __debuggersettingsdlg__
#define __debuggersettingsdlg__

/**
@file
Subclass of DebuggerSettingsBaseDlg, which is generated by wxFormBuilder.
@todo Add your event handlers directly to this file.
*/

#include "debuggersettingsbasedlg.h"
#include "filepicker.h"
#include "debuggersettings.h"

class DebuggerSettingsDlg;
class wxCheckBox;
class DebuggerPageBase;

class DebuggerPage : public DebuggerPageBase
{
	friend class DebuggerSettingsDlg;
	wxString m_title;

protected:
	void OnBrowse     (wxCommandEvent &e);
	void OnDebugAssert(wxCommandEvent &e);
public:
	DebuggerPage(wxWindow *parent, wxString title);
	virtual ~DebuggerPage();
};

/** Implementing DebuggerSettingsBaseDlg */
class DebuggerSettingsDlg : public DebuggerSettingsBaseDlg
{
	long m_selectedItem;
	DebuggerSettingsData m_data;

protected:
	void Initialize();
	void OnOk(wxCommandEvent &e);
	void OnNewShortcut(wxCommandEvent &e);
	void OnDeleteShortcut(wxCommandEvent &e);
	void OnEditShortcut(wxCommandEvent &e);
	void OnItemSelected(wxListEvent &e);
	void OnItemDeselected(wxListEvent &e);
	void OnItemActivated(wxListEvent &e);
	void OnButtonCancel(wxCommandEvent &e);

private:
	void DoEditItem();
	void DoDeleteItem();

public:
	/** Constructor */
	DebuggerSettingsDlg( wxWindow* parent );
	virtual ~DebuggerSettingsDlg();
};

#endif // __debuggersettingsdlg__
