//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : replaceinfilespanel.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#ifndef __replaceinfilespanel__
#define __replaceinfilespanel__

#include "findresultstab.h"


class ReplaceInFilesPanel : public FindResultsTab
{
    wxComboBox *m_replaceWith;
	wxGauge    *m_progress;

	void DoSaveResults(wxScintilla *sci, std::map<int,SearchResult>::iterator begin,
                                         std::map<int,SearchResult>::iterator end);

    wxScintilla *DoGetEditor(const wxString &fileName);

	// Event handlers
    virtual void OnSearchStart(wxCommandEvent   &e);
    virtual void OnSearchMatch(wxCommandEvent   &e);
    virtual void OnSearchEnded(wxCommandEvent   &e);
	virtual void OnMarginClick(wxScintillaEvent &e);
    
	virtual void OnMarkAll    (wxCommandEvent   &e);
	virtual void OnUnmarkAll  (wxCommandEvent   &e);
	virtual void OnReplace    (wxCommandEvent   &e);

	virtual void OnMarkAllUI  (wxUpdateUIEvent  &e);
	virtual void OnUnmarkAllUI(wxUpdateUIEvent  &e);
	virtual void OnReplaceUI  (wxUpdateUIEvent  &e);
    
    DECLARE_EVENT_TABLE()
    
public:
	ReplaceInFilesPanel(wxWindow* parent, wxWindowID id, const wxString &name);
};

#endif // __replaceinfilespanel__
