/*---------------------------------------------------------------------------*\
                                                                             
  FILE........: modem_stats.h
  AUTHOR......: David Rowe
  DATE CREATED: June 2015
                                                                             
  Common structure for returning demod stats from fdmdv and cohpsk modems.

\*---------------------------------------------------------------------------*/

/*
  Copyright (C) 2015 David Rowe

  All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License version 2.1, as
  published by the Free Software Foundation.  This program is
  distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

#ifdef __cplusplus
  extern "C" {
#endif

#ifndef __MODEM_STATS__
#define __MODEM_STATS__

#include "comp.h"
#include "kiss_fft.h"

#define MODEM_STATS_NC_MAX 20
#define MODEM_STATS_NR_MAX 6
#define MODEM_STATS_NSPEC            512
#define MODEM_STATS_MAX_F_HZ         4000

struct MODEM_STATS {
    int    Nc;
    float  snr_est;                          /* estimated SNR of rx signal in dB (3 kHz noise BW)  */
    COMP   rx_symbols[MODEM_STATS_NR_MAX][MODEM_STATS_NC_MAX+1]; 
                                             /* latest received symbols, for scatter plot          */ 
    int    nr;                               /* number of rows in rx_symbols                       */
    int    sync;                             /* demod sync state                                   */ 
    float  foff;                             /* estimated freq offset in Hz                        */       
    float  rx_timing;                        /* estimated optimum timing offset in samples         */
    float  clock_offset;                     /* Estimated tx/rx sample clock offset in ppm         */

    /* Buf for FFT/waterfall */

    float        fft_buf[2*MODEM_STATS_NSPEC];
    kiss_fft_cfg fft_cfg;  
};

void modem_stats_open(struct MODEM_STATS *f);
void modem_stats_close(struct MODEM_STATS *f); 
void modem_stats_get_rx_spectrum(struct MODEM_STATS *f, float mag_spec_dB[], COMP rx_fdm[], int nin);

#endif

#ifdef __cplusplus
}
#endif
