/*
 * This file is part of the Code::Blocks IDE and licensed under the GNU General Public License, version 3
 * http://www.gnu.org/licenses/gpl-3.0.html
 *
 * $Revision: 4918 $
 * $Id: appglobals.cpp 4918 2008-02-27 19:55:16Z mandrav $
 * $HeadURL: svn://svn.berlios.de/codeblocks/tags/8.02/src/src/appglobals.cpp $
 */

#include <sdk.h>
#ifndef CB_PRECOMP
#include <wx/utils.h>
#include <wx/intl.h>
#include "configmanager.h"
#endif
#include "appglobals.h"

namespace appglobals
{
    const wxString AppVendor              = _T("Code::Blocks");
    const wxString AppName			    = _T("Code::Blocks");

    #if SVN_BUILD
        const wxString AppVersion				= _T("svn build");
        const wxString AppActualVersionVerb	= _T("svn build  rev ") +  ConfigManager::GetRevisionString();
        const wxString AppActualVersion		= _T("svn-r") +  ConfigManager::GetRevisionString();
    #else
        const wxString AppVersion				= _T(RELEASE);
        const wxString AppActualVersionVerb	= _T("Release " RELEASE);
        const wxString AppActualVersion		= _T(RELEASE);
    #endif

    const wxString AppUrl					= _T("http://www.codeblocks.org");
    const wxString AppContactEmail		= _T("info@codeblocks.org");

    #if defined(__WXMSW__)
      const wxString AppPlatform = _T("Windows");
    #elif defined(__WXOS2__)
      const wxString AppPlatform = _T("OS/2");
    #elif defined(__WXMAC__) || defined(__WXCOCOA__)
      const wxString AppPlatform = _T("Mac OS X");
    #elif defined(__APPLE__)
      const wxString AppPlatform = _T("Darwin");
    #elif defined(__FreeBSD__)
      const wxString AppPlatform = _T("FreeBSD");
    #elif defined(__UNIX__)
      const wxString AppPlatform = _T("Linux");
    #else
      const wxString AppPlatform = _T("Unknown");
    #endif

    const wxString AppWXAnsiUnicode = platform::unicode ? _T("unicode") : wxT("ANSI");

    const wxString AppBuildTimestamp = (wxString(wxT(__DATE__)) + wxT(", ") + wxT(__TIME__) + wxT(" - wx") + wxString(wxT(wxVERSION_NUM_DOT_STRING)) + wxT(" (") + AppPlatform + wxT(", ") + AppWXAnsiUnicode + wxT(")") );

    const wxString DefaultBatchBuildArgs = _T("-na -nd -ns --batch-build-notify");
};



