%define _svnrev		
%define req_wxgtk	2.8.0
%define _fedora		%(if [ -f /etc/fedora-release ]; then echo 1; else echo 0; fi)
%define _redhat		%(if [ -f /etc/redhat-release ]; then echo 1; else echo 0; fi)
%define _mandrake       %(if [ -f /etc/mandrake-release ]; then echo 1; else echo 0; fi)
%define _version        1.0_0.svn.%{_svnrev}
%define _rel		0
%define _release	%{_rel}
%define jobs		%(if [ -e /usr/bin/getconf ]; then echo $(( `/usr/bin/getconf _NPROCESSORS_ONLN` + 1 )); else echo 1; fi)

%if 0%{?suse_version}
%define _release	%{_rel}.suse%{suse_version}
%endif
%if 0%{?mandriva_version}
%define _release            %{_rel}.mdk%{mandrake_version}
%define _redhat 0
%endif
%if 0%{?fedora_version}
%define _release            %{_rel}.fc%{fedora_version}
%define _redhat 0
%endif
%if 0%{?_redhat}
%define _redhat_prefix      %(grep -q "Red Hat Linux" /etc/redhat-release && echo rhl || echo el)
%define _redhat_vernum      %(rpm -qf --queryformat %{VERSION} /etc/redhat-release|tr -d '.')
%define _release            %{_rel}.%{_redhat_prefix}%{_redhat_vernum}
%endif

%if 0%{?suse_version} >= 930
%define debugrpm	    1
%endif

%if 0%{?mandriva_version}
%define debugrpm            1
%endif

%define automake17	    0

%if 0%{?_redhat}
%if 0%{?_redhat_vernum} < 4
%define automake17	    1
%endif
%endif

Name:			codeblocks
Version:		%{_version}
Release:		%{_release}
Summary:		OpenSource Cross Platform Free C++ IDE
Group:			Development/Tools/IDE
License:		GPL
URL:			http://www.codeblocks.org/
Packager:		TheTuxKeeper <thetuxkeeper@googlemail.com>
Source:			%{name}-10.05-release.tar.bz2
BuildRoot:		%{_tmppath}/%{name}-%{version}-buildroot

%if 0%{?mandriva_version}
Requires:               wxgtk2.8 >= %{req_wxgtk}
BuildRequires:          wxgtk2.8 >= %{req_wxgtk}, libwxgtku2.8-devel >= %{req_wxgtk}
%else
%if 0%{?suse_version}
%if 0%{?suse_version} < 1030
Requires:               wxWidgets >= %{req_wxgtk}
BuildRequires:          wxWidgets >= %{req_wxgtk}, wxWidgets-devel >= %{req_wxgtk}
%else
Requires:               wxGTK >= %{req_wxgtk}
BuildRequires:  	wxGTK >= %{req_wxgtk}, wxGTK-devel >= %{req_wxgtk}
%endif
%else
Requires:               wxGTK >= %{req_wxgtk}
BuildRequires:  	wxGTK >= %{req_wxgtk}, wxGTK-devel >= %{req_wxgtk}
%endif
%endif

%if ! 0%{?automake17}
BuildRequires:          intltool, gcc-c++, make, gettext, autoconf >= 2.5, automake >= 1.7, libtool >= 1.4, m4
%else
BuildRequires:          intltool, gcc-c++, make, gettext, autoconf >= 2.5, automake17, libtool >= 1.4, m4
%endif
BuildRequires:  	libstdc++, libstdc++-devel, gtk2-devel, libjpeg-devel, libtiff-devel
BuildRequires:  	zip, pkgconfig

%if 0%{?suse_version}
BuildRequires:		update-desktop-files
%endif

%if 0%{?fedora_version}
#BuildRequires:  	lynx
%endif

#{?_distribution:Distribution:%_distribution}

%define pkgdata		%{_datadir}/%{name}
%define	pkglib		%{_libdir}/%{name}

%description
Code::Blocks is a free C++ IDE built specifically to meet the most demanding needs of its users. It was designed, right from the start, to be extensible and configurable.

%package contrib
Summary:                        Code::Blocks contrib plugins
Group:                  Development/Tools/IDE
Requires:               codeblocks = %{version}

%description contrib
Additional Code::Blocks plugins

%package devel
Summary:                        Code::Blocks SDK
Group:                  Development/Tools/IDE
Requires:               codeblocks = %{version}

%description devel
Code::Blocks SDK to develop your own plugins.

%{?debugrpm:%debug_package}

%prep

%setup -n codeblocks-10.05-release

%{?suse_update_libdir:%{suse_update_libdir}}
%{?suse_update_config:%{suse_update_config -f}}

%build
  %if ! %{automake17}
     ./bootstrap
  %else
     AUTOMAKE=automake-1.7 ACLOCAL=aclocal-1.7 ACLOCAL_FLAGS="-I %{_datadir}/aclocal" ./bootstrap
  %endif
  %if 0%{?suse_version}
  %if 0%{?suse_version} > 1020
  %configure \
      --with-wx-config="%{_bindir}/wx-config" \
      --with-contrib-plugins=all $CONF_OPTS
  %else
  %configure \
      --with-wx-config="%{_bindir}/wx-config-2.8" \
      --with-contrib-plugins=all $CONF_OPTS
  %endif
  %else
  %configure \
      --with-wx-config="%{_bindir}/wx-config" \
      --with-contrib-plugins=all $CONF_OPTS
  %endif

  %{__make} %{?jobs:-j %{jobs}}

%install
  %__make DESTDIR=$RPM_BUILD_ROOT install

%post
  if [ -x /usr/bin/update-mime-database ]; then
  	/usr/bin/update-mime-database "%{_datadir}/mime"
  fi
  test -x /sbin/ldconfig && /sbin/ldconfig

%preun
  if [ -x /usr/bin/update-mime-database ]; then
     /usr/bin/update-mime-database "%{_datadir}/mime"
  fi

%clean
  test -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != "/" && %{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README COPYING AUTHORS BUGS COMPILERS TODO NEWS ChangeLog

%{_bindir}/codeblocks
%{_bindir}/cb_console_runner
%{_libdir}/libcodeblocks.so
%{_libdir}/libcodeblocks.la
%{_libdir}/libcodeblocks.so.*
%{_datadir}/applications/codeblocks.desktop
%{_datadir}/icons/hicolor/48x48/mimetypes/*
%{_datadir}/mime/packages/codeblocks.xml
%{_datadir}/pixmaps/codeblocks.png
%{pkgdata}/astyle.zip
%{pkgdata}/autosave.zip
%{pkgdata}/classwizard.zip
%{pkgdata}/codecompletion.zip
%{pkgdata}/compiler.zip
%{pkgdata}/debugger.zip
%{pkgdata}/defaultmimehandler.zip
%{pkgdata}/manager_resources.zip
%{pkgdata}/openfileslist.zip
%{pkgdata}/projectsimporter.zip
%{pkgdata}/resources.zip
%{pkgdata}/scriptedwizard.zip
%{pkgdata}/start_here.zip
%{pkgdata}/tips.txt
%{pkgdata}/todo.zip
%{pkgdata}/icons/*
%{pkgdata}/images/*.png
%{pkgdata}/images/16x16/*
%{pkgdata}/images/codecompletion/*
%{pkgdata}/images/settings/*
%{pkgdata}/lexers/*
%{pkglib}/plugins/libastyle.*
%{pkglib}/plugins/libautosave.*
%{pkglib}/plugins/libclasswizard.*
%{pkglib}/plugins/libcodecompletion.*
%{pkglib}/plugins/libcompiler.*
%{pkglib}/plugins/libdebugger.*
%{pkglib}/plugins/libdefaultmimehandler.*
%{pkglib}/plugins/libopenfileslist.*
%{pkglib}/plugins/libprojectsimporter.*
%{pkglib}/plugins/libscriptedwizard.*
%{pkglib}/plugins/libtodo.*
%{pkgdata}/scripts/*
%{pkgdata}/templates/*
%{_mandir}/*

%files contrib
%defattr(-,root,root)
%{_bindir}/cb_share_config
%{_bindir}/codesnippets
%{pkgdata}/AutoVersioning.zip
%{pkgdata}/BrowseTracker.zip
%{pkgdata}/byogames.zip
%{pkgdata}/Cccc.zip
%{pkgdata}/CppCheck.zip
%{pkgdata}/cb_koders.zip
%{pkgdata}/codesnippets.zip
%{pkgdata}/codestat.zip
%{pkgdata}/copystrings.zip
%{pkgdata}/dragscroll.zip
%{pkgdata}/envvars.zip
%{pkgdata}/exporter.zip
%{pkgdata}/headerfixup.zip
%{pkgdata}/help_plugin.zip
%{pkgdata}/keybinder.zip
%{pkgdata}/lib_finder.zip
%{pkgdata}/Profiler.zip
%{pkgdata}/RegExTestbed.zip
%{pkgdata}/SymTab.zip
%{pkgdata}/ThreadSearch.zip
%{pkgdata}/Valgrind.zip
%{pkgdata}/wxsmith.zip
%{pkgdata}/wxsmithcontribitems.zip
%{pkgdata}/wxSmithAui.zip
%{pkgdata}/HexEditor.zip
%{pkgdata}/IncrementalSearch.zip
%{pkgdata}/MouseSap.zip
%{pkgdata}/images/wxsmith/*
%{pkgdata}/images/codesnippets/*
%{pkgdata}/images/ThreadSearch/*
%{pkgdata}/lib_finder/*
%{pkglib}/plugins/libAutoVersioning.*
%{pkglib}/plugins/libBrowseTracker.*
%{pkglib}/plugins/libbyogames.*
%{pkglib}/plugins/libCccc.*
%{pkglib}/plugins/libCppCheck.*
%{pkglib}/plugins/libcb_koders.*
%{pkglib}/plugins/libcodesnippets.*
%{pkglib}/plugins/libcodestat.*
%{pkglib}/plugins/libcopystrings.*
%{pkglib}/plugins/libdragscroll.*
%{pkglib}/plugins/libenvvars.*
%{pkglib}/plugins/libexporter.*
%{pkglib}/plugins/libheaderfixup.*
%{pkglib}/plugins/libhelp_plugin.*
%{pkglib}/plugins/libHexEditor.*
%{pkglib}/plugins/libIncrementalSearch.*
%{pkglib}/plugins/libkeybinder.*
%{pkglib}/plugins/liblib_finder.*
%{pkglib}/plugins/libProfiler.*
%{pkglib}/plugins/libRegExTestbed.*
%{pkglib}/plugins/libSymTab.*
%{pkglib}/plugins/libThreadSearch.*
%{pkglib}/plugins/libValgrind.*
%{pkglib}/plugins/libMouseSap.*
%{pkglib}/plugins/libwxsmith.*
%{_libdir}/libwxsmithlib.so
%{_libdir}/libwxsmithlib.la
%{_libdir}/wxSmithContribItems/*
%{pkglib}/plugins/libwxsmithcontribitems.*
%{pkglib}/plugins/libwxSmithAui.*
%{_libdir}/libwxsmithlib.so.*

%files devel
%defattr(-,root,root)
%{_libdir}/pkgconfig/codeblocks.pc
%{_libdir}/pkgconfig/wxsmith.pc
%{_libdir}/pkgconfig/wxsmith-contrib.pc
%{_libdir}/pkgconfig/wxsmithaui.pc
%{_includedir}/%{name}/*
%{_includedir}/wxsmith/*
%{_includedir}/wxSmithContribItems/*

%changelog
* Sun Feb 20 2010 Biplab <bkmodak@gmail.com>
- Fixed typos: In wxSmithAui generated files.
- Fixed: RPM build error due to inclusion of contrib plugins twice.
- Fixed: Copystrings plugin was not included properly in rpm.
- Fixed: Pkgconfig macros of wxsmithaui and wxsmith-contrib were not included.
- Moved: libwxsmithlib.so to contrib package.
- Removed: 'lynx' as a dependency.
* Thu Feb 18 2010 Biplab <bkmodak@gmail.com>
- Changed source tarball extension to .bz2
- Fixed: broken rpm build due to path change from icons/gnome/* to icons/hicolor/*
* Sun Dec 14 2008 TheTuxKeeper <thetuxkeeper@googlemail.com>
- some fixes for changes in rev 5334
* Sat Jul 26 2008 TheTuxKeeper <thetuxkeeper@googlemail.com>
- moved libwxsmithlib.so and .la into devel package
- removed selfprovide codeblocks
- removed subversion dependency
- changed release and version tag (version now only contains version + revision)
- added libValgrind.* to file list
* Thu Jan 03 2008 TheTuxKeeper <thetuxkeeper@googlemail.com>
- added missing files to file list (libfinder)
- changed dependencies for mandriva
- some clean-ups
* Wed Nov 14 2007 TheTuxKeeper <thetuxkeeper@googlemail.com>
- added new plugin to file list
- added make job number "detection"
* Sun Oct 14 2007 TheTuxKeeper <thetuxkeeper@googlemail.com>
- applied changes made on opensuse buildservice
* Mon Apr 16 2007 TheTuxKeeper <thetuxkeeper@googlemail.com>
- added wxsmithcontribitems files to filelist
* Fri Jan  5 2007 TheTuxKeeper <thetuxkeeper@googlemail.com>
- changed prefix on suse to default (from /opt/gnome to /usr)
* Sun Dec  2 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- Added RegExTestbed plugin to filelist
* Sun Nov  5 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- applied patch #1605
- renamed _mandriva to _mandrake
* Wed Oct 11 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- Added cb_share_config to filelist
* Sun Aug 20 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- Added missing files to filelist
* Sat Jul 22 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- adapted versioning to autotools
* Fri Jul 14 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- added man pages to filelist
* Tue Jul 11 2006 Yiannis Mandravellos <mandrav@codeblocks.org>
- removed pluginwizard files
- replaced libprojectwizard by libscriptedwizard (renamed)
* Tue Jul 11 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- removed libwxscintilla from filelist
* Mon Jul 10 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- fixed wrong path of fedora-release file
- fixed mixed cases in one description macro call
- removed and added finally again libwxscintilla from/to filelist
- added versions to some buildrequires
- added byogames plugin to filelist
* Sun Mar  5 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- rewrite of release tag setting
* Mon Jan  5 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- had to add Mandriva specific requires
* Mon Jan  2 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- simplified the changes made before
* Sun Jan  1 2006 TheTuxKeeper <thetuxkeeper@googlemail.com>
- added distribution check (SuSE, Fedora, Mandriva/Mandrake)
- added distribution specific Requires and BuildRequires
- added run of update-mime-database if installed
