/*============================================================================
 * Code_Saturne documentation page
 *============================================================================*/

/*
  This file is part of Code_Saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2018 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------*/

/*!
  \page cs_user_examples User examples

Here is a list of user examples. Thorougly documented snippets are provided.

   - \subpage cs_user_mesh
   - \subpage user_initialization "Physical fields user initialization"
   - \subpage cs_user_boundary_conditions_examples "User boundary condition definitions"
   - \subpage les_inflow "Inflow Boundary conditions for LES"
   - \subpage f_parameters
   - \subpage parameters
   - \subpage turbomachinery
   - \subpage cavit
   - \subpage physical_properties
   - \subpage cs_user_postprocess
   - \subpage cs_user_postprocess_var
   - \subpage drift_coal_scalars
   - \subpage drift_scalars
   - \subpage cs_porosity
   - \subpage cs_head_losses
   - \subpage cs_lagrangian_particle_tracking_module
   - \subpage cs_user_source_terms
   - \subpage cs_user_mass_source_terms
   - \subpage condens
   - \subpage cs_user_boundary_conditions_ale
   - \subpage cs_user_radiative_transfer
   - \subpage cs_user_extra_operations_examples "User extra operations"
   - \subpage cs_user_extra_operations-nusselt_calculation
   - \subpage cs_user_source_terms-scalar_in_a_channel
   - \subpage richards
   - \subpage cs_user_gwf_cdo
   - \subpage cs_user_fluid_structure_interaction
   - \subpage user_coupling
   - \subpage cs_user_performance_tuning
   - \subpage cs_user_electric_scaling
   - \subpage cs_user_atmospheric_model
   - \subpage cs_user_modules
   - \subpage user_solver
   - \subpage cs_user_cooling_towers "Cooling towers definition"
   - \subpage us_thht
   - \subpage us_vosy
   - \subpage us_pt1d
   - \subpage us_vort
*/
