#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MANAGE='src/lib/perl5/COD/CIF/Tags/Manage.pm'
INPUT_PRINT='src/lib/perl5/COD/CIF/Tags/Print.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-07-30 19:52:52 +0300 (Fri, 30 Jul 2021) $ 
#$Revision: 8840 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.9.0/tests/shtests/print_cif_003.sh $
#------------------------------------------------------------------------------
#*
#  Unit test for the COD::CIF::Tags::Print::print_cif() subroutine.
#**

use strict;
use warnings;

use COD::CIF::Tags::Manage qw( new_datablock );
use COD::CIF::Tags::Print qw( print_cif );

# Test the way a properly formed loop is printed
my $data_block  = new_datablock( 'data',  '2.0' );
my $save_block  = new_datablock( 'save',  '2.0' );
my $inner_block = new_datablock( 'inner', '2.0' );

push @{$data_block->{save_blocks}}, $save_block;
push @{$save_block->{save_blocks}}, $inner_block;

print_cif( $data_block );

END_SCRIPT
