#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/DDL/DDLm.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-11-03 04:31:59 +0200 (Wed, 03 Nov 2021) $ 
#$Revision: 8921 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.9.0/tests/shtests/canonicalise_ddlm_value_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::DDL::DDLm::canonicalise_ddlm_value subroutine.
#* Tests the way the subroutine behaves when the input value is a special
#* type of number (inf, NaN).
#**

use strict;
use warnings;

use COD::CIF::DDL::DDLm qw( canonicalise_ddlm_value );

my @sanity_values = (
    42,
    42.000,
    42.000,
);

my @test_values = (
    'test',
    'inf',
    '+inf',
    '-inf',
    'infinity',
    '+infiNity',
    '-infinity',
    'NaN',
    '+nan',
    '-naN'
);

print "Sanity values:\n";
for my $value (@sanity_values) {
    print canonicalise_ddlm_value( $value, 'integer'), "\n";
}

print "Test values:\n";
for my $value (@test_values) {
    print canonicalise_ddlm_value( $value, 'integer'), "\n";
}

END_SCRIPT
