#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE='src/lib/perl5/COD/AtomNeighbours.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: andrius $
#$Date: 2022-01-31 16:23:29 +0200 (Mon, 31 Jan 2022) $ 
#$Revision: 9146 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.8.0/tests/shtests/neighbour_list_to_chemistry_mol_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::AtomNeighbours::neighbour_list_to_chemistry_mol
#* subroutine. The output may be imprecise, but represents "best effort".
#**

use strict;
use warnings;

use Chemistry::File::SMILES;
use Chemistry::Mol;
use COD::AtomNeighbours qw(
    neighbour_list_from_chemistry_mol
    neighbour_list_to_chemistry_mol
);

my $mol1 = Chemistry::Mol->parse( "C1cc1(=O)[O-]", format => "smiles" );
my $neighbours = neighbour_list_from_chemistry_mol( $mol1 );
my $mol2 = neighbour_list_to_chemistry_mol( $neighbours );
$mol2->write( "/dev/stdout", format => "smiles" );
print "\n";

END_SCRIPT
