#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Merge.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-07-30 19:52:52 +0300 (Fri, 30 Jul 2021) $ 
#$Revision: 8840 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.8.0/tests/shtests/merge_datablocks_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Merge::merge_datablocks() subroutine.
#* Tests overwriting a looped data item with a non-looped one.
#**

use strict;
use warnings;

use COD::CIF::Tags::Manage qw( new_datablock set_loop_tag set_tag );
use COD::CIF::Tags::Merge qw( merge_datablocks );
use COD::CIF::Tags::Print qw( print_cif );

my $data_block_single = new_datablock( 'single' );
my $data_block_loop = new_datablock( 'loop' );

set_tag( $data_block_single, '_data_name', 'value' );
set_loop_tag( $data_block_loop, '_data_name', undef, [ 1, 2, 3 ] );

merge_datablocks( $data_block_single, $data_block_loop, { override_all => 1 } );
print_cif( $data_block_loop );

END_SCRIPT
