/*---------------------------------------------------------------------------*\
**$Author: antanas $
**$Date: 2020-07-20 16:43:00 +0300 (Mon, 20 Jul 2020) $ 
**$Revision: 8230 $
**$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.8.0/src/components/codcif/cif_lex_buffer.h $
\*---------------------------------------------------------------------------*/

#ifndef __CIF_LEX_BUFFER_H
#define __CIF_LEX_BUFFER_H

#include <stdio.h>
#include <unistd.h> /* for ssize_t */
#include <cif_compiler.h>
#include <cexceptions.h>

void cif_lexer_cleanup( void );
void cif_flex_reset_counters( void );

int cif_lexer_set_report_long_lines( int flag );
int cif_lexer_report_long_lines( void );
size_t cif_lexer_set_line_length_limit( size_t max_length );

void advance_mark( void );
void backstep_mark( void );

void pushchar( size_t pos, int ch );
void ungetlinec( int ch, FILE *in );
int getlinec( FILE *in, CIF_COMPILER *cif_cc, cexception_t *ex );

int cif_flex_current_line_number( void );
void cif_flex_set_current_line_number( ssize_t line );
int cif_flex_current_position( void );
void cif_flex_set_current_position( ssize_t pos );
const char *cif_flex_current_line( void );
int cif_flex_current_mark_position( void );

int cif_flex_previous_line_number( void );
int cif_flex_previous_position( void );
const char *cif_flex_previous_line( void );

char *cif_flex_token( void );

#endif
