#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Print.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-09-20 14:31:40 +0300 (Mon, 20 Sep 2021) $
#$Revision: 8883 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.6.0/tests/shtests/get_line_start_delimiter_003.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Print::get_line_start_delimiter()
#* subroutine. Tests the way the subroutine escapes CIF 1.1 values that
#* are prefixed with a semicolon and contain various CIF 1.1 and CIF 2.0
#* delimiters.
#**

use strict;
use warnings;

use COD::CIF::Tags::Print;

my $cif_version = '2';

my @feature_sets;
for my $i (0..15) {
    my $binary = sprintf "%04b", $i;
    push @feature_sets, [ split '', $binary ];
}

for my $feature (@feature_sets) {
    my $value = ';start';
    $value .= "-'"   if $feature->[3];
    $value .= '-"'   if $feature->[2];
    $value .= "-'''" if $feature->[1];
    $value .= '-"""' if $feature->[0];
    $value .= '-end';
    print "# sq:  $feature->[3]\n";
    print "# dq:  $feature->[2]\n";
    print "# tsq: $feature->[1]\n";
    print "# tdq: $feature->[0]\n";
    my $q = COD::CIF::Tags::Print::get_line_start_delimiter($value, $cif_version);
    if ($q eq ';') {
        print $q . $value . "\n" . $q . "\n";
    } else {
        print $q . $value . $q . "\n";
    }
}

END_SCRIPT
