#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/DDL/DDLm.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-10-29 01:11:58 +0300 (Fri, 29 Oct 2021) $ 
#$Revision: 8920 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.5.0/tests/shtests/canonicalise_ddlm_complex_value_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::DDL::DDLm::canonicalise_ddlm_complex_value()
#* subroutine. Tests the way correctly formatted complex values are handled.
#**

use strict;
use warnings;

use COD::CIF::DDL::DDLm;

my @test_values = (
    '10+7j',
    '10 + 7j',
    '100(5) - 1.7j',
    '10.0 - 5(1)j',
    '10.15(1)+300.0(100)j'
);

for my $value (@test_values) {
    print "'$value'";
    print ' -> ';
    print "'", COD::CIF::DDL::DDLm::canonicalise_ddlm_complex_value($value), "'";
    print "\n";
}

END_SCRIPT
