#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/ChangeLog.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-12-07 02:02:09 +0200 (Tue, 07 Dec 2021) $ 
#$Revision: 9015 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.5.0/tests/shtests/append_changelog_to_single_item_002.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::ChangeLog::append_changelog_to_single_item()
#* subroutine. Tests the way the subroutine behaves when the input changelog
#* data item already exists in the processed data block. The subroutine should
#* append to the existing changelog value.
#**

use strict;
use warnings;

use COD::CIF::ChangeLog qw( append_changelog_to_single_item );

my $changelog_item = '_cod_depositor_comments';

my $data_block =
{
    'name'   => 'existing_changelog',
    'tags'   => [
                  $changelog_item
                ],
    'loops'  => [
                ],
    'inloop' => {
                },
    'values' => {
                  $changelog_item => [
                    (
                      "\nThis is previous changelog message.\n" .
                      "It contains important information.\n" .
                      "\n" .
                      "Name Surname"
                    )
                  ]
                },
    'precisions' => {},
    'types'  => {
                }
};

append_changelog_to_single_item(
    $data_block,
    [ 'This is a new changelog message.' ],
    {
      'data_name' => $changelog_item,
    }
);

print "# Tags:\n";
print join "\n", @{$data_block->{'tags'}};

print "\n\n";

print "# Changelog value:\n";
print join "\n", @{$data_block->{'values'}{$changelog_item}};

print "\n";

END_SCRIPT
