#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Manage.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-07-30 19:52:52 +0300 (Fri, 30 Jul 2021) $ 
#$Revision: 8840 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.3.0/tests/shtests/has_inapplicable_value_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Manage::has_inapplicable_value() subroutine.
#* Tests the way the subroutine considers the value of the 'values' hash.
#**

use strict;
use warnings;

use COD::CIF::Tags::Manage;
use COD::Serialise qw( serialiseRef );

##
#data_test
#_value inapplicable
##
my $data_block =
{
  'tags'   => [ '_value' ],
  'loops'  => [ ],
  'inloop' => {},
  'values' => { '_value' => [ 'inapplicable' ] },
  'precisions' => {},
  'types'  => { '_value' => [ 'UQSTRING' ]},
};

my $data_name = '_value';

my $inapplicable = COD::CIF::Tags::Manage::has_inapplicable_value(
                    $data_block,
                    $data_name,
                    0 );

print "Value is " . ($inapplicable ? 'inapplicable' : 'applicable') . ".\n";

END_SCRIPT
