#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/UserMessage.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2020-07-20 16:43:00 +0300 (Mon, 20 Jul 2020) $ 
#$Revision: 8230 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.2.0/tests/shtests/sprint_message_001.sh $
#------------------------------------------------------------------------------
#**
#* Unit test for the COD::UserMessage::sprint_message() subroutine.
#* Tests the way the subroutine escapes various symbols that may
#* interfere with the parsing of the error message.
#**

use strict;
use warnings;

use COD::UserMessage qw( sprint_message parse_message );

my @test_symbols = ( ' ', "\n", "\t", '(', ')', '{', '}', '[', ']' );

my $message;
for my $test_symbol ( @test_symbols ) {
    $message = sprint_message( {
        'program'      => "program${test_symbol}",
        'filename'     => "filename${test_symbol}",
        'add_pos'      => "data_block${test_symbol}",
        'err_level'    => 'WARNING',
        'message'      => 'message',
        'line_no'      => 1,
        'column_no'    => 2,
        'line_content' => 'an error line'
    } );
    print "# Contains the '$test_symbol' symbol:\n";
    print $message;
}

END_SCRIPT
