#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Data/CODNumbers.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2017-11-10 03:39:41 +0200 (Fri, 10 Nov 2017) $ 
#$Revision: 5755 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.0.1/tests/shtests/have_equiv_lattices_009.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::CODNumbers::are_equiv_lattices()
#* subroutine. Tests the way the subroutine behaves when both of the
#* lattices are missing some of the length and angle values. Even
#* though some values are missing, the missmatching ones cause the
#* lattices to be treated as not equivalent.
#**

use strict;
use warnings;

use COD::CIF::Data::CODNumbers;

my $entry_1 = {
    'cell' => {
        '_cell_length_a'    => 5,
        '_cell_length_b'    => undef,
        '_cell_length_c'    => 5,
        '_cell_angle_alpha' => 90,
        '_cell_angle_beta'  => undef,
        '_cell_angle_gamma' => undef,
    },
    'sigcell' => {
        '_cell_length_a'    => undef,
        '_cell_length_b'    => undef,
        '_cell_length_c'    => undef,
        '_cell_angle_alpha' => undef,
        '_cell_angle_beta'  => undef,
        '_cell_angle_gamma' => undef,
    },
};

my $entry_2 = {
    'cell' => {
        '_cell_length_a'    => undef,
        '_cell_length_b'    => 5,
        '_cell_length_c'    => 10,
        '_cell_angle_alpha' => undef,
        '_cell_angle_beta'  => 90,
        '_cell_angle_gamma' => undef,
    },
    'sigcell' => {
        '_cell_length_a'    => undef,
        '_cell_length_b'    => undef,
        '_cell_length_c'    => undef,
        '_cell_angle_alpha' => undef,
        '_cell_angle_beta'  => undef,
        '_cell_angle_gamma' => undef,
    },
};

my $equivalent = COD::CIF::Data::CODNumbers::have_equiv_lattices(
    $entry_1,
    $entry_2,
);

if ( $equivalent ) {
    print "Lattices were treated as equivalent.\n";
} else {
    print "Lattices were treated as not equivalent.\n";
}

END_SCRIPT
