#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2015-11-09 12:17:48 +0200 (Mon, 09 Nov 2015) $ 
#$Revision: 4237 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.0.1/src/lib/perl5/COD/Spacegroups/Lookup.pm $
#------------------------------------------------------------------------
#*
#  Basic functions for space group look up.
#**

package COD::Spacegroups::Lookup;

use strict;
use warnings;
use COD::Spacegroups::Lookup::COD;
use COD::Spacegroups::Symop::Parse qw( symop_string_canonical_form );

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    make_symop_key
    make_symop_hash
);

sub make_symop_key
{
    my ( $symops ) = @_;
    return join ";", sort map {symop_string_canonical_form($_)} @$symops;
}

sub make_symop_hash
{
    my ( $space_group_sets ) = @_;

    return map { (make_symop_key($_->{symops}), $_) }
               map { @$_ } @$space_group_sets;
}

1;
