#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Data/CODNumbers.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2017-12-22 17:35:43 +0200 (Fri, 22 Dec 2017) $ 
#$Revision: 5896 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.9/tests/shtests/have_equiv_timestamps_009.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::CODNumbers::timestamps_are_the_same()
#* subroutine. Tests the way the subroutine handles situations when both of
#* the values are datetime timestamps and point to different moments in time.
#**

use strict;
use warnings;

use COD::CIF::Data::CODNumbers;

my $value_1 = '2017-01-01T23:00:00.00-03:00';
my $value_2 = '2017-01-01T23:00:00.00-02:00';

my $data_name = '_raman_measurement.datetime_initiated';
my $entry_1 = {
    'timestamp' => {
        $data_name => $value_1,
    }
};

my $entry_2 = {
    'timestamp' => {
        $data_name => $value_2,
    }
};

if ( COD::CIF::Data::CODNumbers::have_equiv_timestamps($entry_1, $entry_2, $data_name) ) {
    print "Values are treated as being the same.\n";
} else {
    print "Values are treated as being different.\n";
}

if ( COD::CIF::Data::CODNumbers::have_equiv_timestamps($entry_2, $entry_1, $data_name) ) {
    print "Values are treated as being the same.\n";
} else {
    print "Values are treated as being different.\n";
}

END_SCRIPT
