#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Manage.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2018-05-25 06:05:43 +0300 (Fri, 25 May 2018) $ 
#$Revision: 6185 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.7/tests/shtests/has_numeric_value_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Manage::has_numeric_value() subroutine.
#* Tests the way the subroutine considers the value of the 'values' hash.
#**

use strict;
use warnings;

use COD::CIF::Tags::Manage;
use COD::Serialise qw( serialiseRef );

##
#data_test
#loop_
#_value
#text
#5
#5(5)
#5.5
#5.5(5)
#'12'
#"12(5)"
#;42
#;
##
my $data_block =
{
  'tags'   => [ '_value' ],
  'loops'  => [ ],
  'inloop' => {},
  'values' => { '_value' => [ 'text', '5', '5(5)', '5.5', '5.5(5)', 12, '12(5)', 42, 30 ] },
  'precisions' => {},
  'types'  => {
    '_value' => [ 'UQSTRING', 'INT', 'INT', 'FLOAT', 'FLOAT', 'SQSTRING', 'DQSTRING', 'TEXTFIELD', undef ]
   },
};

my $data_name = '_value';

for (my $i = 0; $i < @{$data_block->{'values'}{$data_name}}; $i++) {
    my $numeric = COD::CIF::Tags::Manage::has_numeric_value(
                $data_block,
                $data_name,
                $i
    );
    print "Value at position $i is " .
           ($numeric ? 'numeric' : 'not numeric') . ".\n";
}

END_SCRIPT
