#!/usr/bin/python
# -*- coding: utf-8 -*-
#------------------------------------------------------------------------------
#$Author: antanas $
#$Revision: 7423 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.7/src/components/pycodcif/tests/shtests/build_cif_002.sh $
#$Date: 2019-11-15 20:02:19 +0200 (Fri, 15 Nov 2019) $
#$Id: build_cif_002.sh 7423 2019-11-15 18:02:19Z antanas $
#------------------------------------------------------------------------------
#*
#  Test driver for pycodcif module.
#**
import sys
from pycodcif import CifFile, CifDatablock, CifUnknownValue, CifInapplicableValue

datablock = CifDatablock("new")

datablock.add_loop( [ '_a', '_b' ], [[1, 2], [3, 4]] )
datablock.add_loop( [ '_c', '_d', '_e' ], [[1, 2, 3], [3, 4, 4], ['c', 'd', 'e']] )

cif = CifFile()
cif.append( datablock )
print cif

# This should cause an error
try:
    datablock.add_loop( [ '_a', '_f' ], [[ 1, 1 ]] )
except KeyError as e:
    print e

datablock['_overwritten'] = 'first'
print cif

datablock['_overwritten'] = 'second'
print cif

datablock['_simple_loop'] = [ 10, 12, 13 ]
datablock['_unknown']      = CifUnknownValue()
datablock['_inapplicable'] = CifInapplicableValue()
print cif
