#!/usr/bin/python
# -*- coding: utf-8 -*-
#------------------------------------------------------------------------------
#$Author: andrius $
#$Revision: 5820 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.2/src/components/pycodcif/tests/shtests/build_cif_002.sh $
#$Date: 2017-11-16 13:15:40 +0200 (Thu, 16 Nov 2017) $
#$Id: build_cif_002.sh 5820 2017-11-16 11:15:40Z andrius $
#------------------------------------------------------------------------------
#*
#  Test driver for pycodcif module.
#**
import sys
from pycodcif import CifFile, CifDatablock, CifUnknownValue, CifInapplicableValue

datablock = CifDatablock("new")

datablock.add_loop( [ '_a', '_b' ], [[1, 2], [3, 4]] )
datablock.add_loop( [ '_c', '_d', '_e' ], [[1, 2, 3], [3, 4, 4], ['c', 'd', 'e']] )

cif = CifFile()
cif.append( datablock )
print cif

# This should cause an error
try:
    datablock.add_loop( [ '_a', '_f' ], [[ 1, 1 ]] )
except KeyError as e:
    print e

datablock['_overwritten'] = 'first'
print cif

datablock['_overwritten'] = 'second'
print cif

datablock['_simple_loop'] = [ 10, 12, 13 ]
datablock['_unknown']      = CifUnknownValue()
datablock['_inapplicable'] = CifInapplicableValue()
print cif
