#Descrp: Primary source of core atom information.
#Source: elements.xml file from BlueObelisk 'bodr' git repository.
#Descrp: Primary source of covalent radii information.
#Source: 'Molecular Double-Bond Covalent Radii for Elements Li–E112', 2009, Pyykkö and Atsumi, doi: 10.1002/chem.200901472
#Descrp: Primary source of van der Waals radii information.
#Source: 'A cartography of the van der Waals territories', 2012, Alvarez, doi: 10.1039/c3dt50599e
#Descrp: Primary source of spin-state related distances.
#Source: 'Covalent radii revisited', 2008, Cordero et al., doi: 10.1039/b801115j
#Descrp: Primary source of charges and common charges.
#Source: http://en.wikipedia.org/wiki/List_of_oxidation_states_of_the_elements 
#Descrp: Primary source of atom valence information.
#Source: http://en.wikipedia.org/wiki/List_of_oxidation_states_of_the_elements
package COD::AtomProperties;

use strict;

require Exporter;
@COD::AtomProperties::ISA = qw(Exporter);
@COD::AtomProperties::EXPORT = qw( ok );

%COD::AtomProperties::atoms = (
     "." => {
             "atomic_number" => "0",
             "name" => "Dummy",
             "family" => "Dummy",
             "period" => "0",
             "group" => "0",
             "block" => "0",
             "atomic_weight" => "0",
             "atomic_mass" => "0",
             "covalent_radius" => "0.75",
             "vdw_radius" => "1.77",
             "valence" => ['0'],
             "covalent_radii" => {
                 "single" => "0.75"
             },
           },
     "D" => {
             "atomic_number" => "1",
             "name" => "Deuterium",
             "family" => "Non-Metal",
             "period" => "1",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "2.01410178",
             "atomic_mass" => "2.014101778",
             "covalent_radius" => "0.32",
             "vdw_radius" => "1.20",
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "0.32"
             },
           },
     "H" => {
             "atomic_number" => "1",
             "name" => "Hydrogen",
             "family" => "Non-Metal",
             "period" => "1",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "1.008",
             "atomic_mass" => "1.007825032",
             "covalent_radius" => "0.32",
             "vdw_radius" => "1.20",
             "charge" => ['-1', '0', '+1'],
             "common_charge" => ['-1', '+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "0.32"
             },
           },
     "He" => {
             "atomic_number" => "2",
             "name" => "Helium",
             "family" => "Noblegas",
             "period" => "1",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "4.002602",
             "atomic_mass" => "4.002603254",
             "covalent_radius" => "0.46",
             "vdw_radius" => "1.43",
             "charge" => ['0'],
             "common_charge" => ['0'],
             "valence" => ['0'],
             "covalent_radii" => {
                 "single" => "0.46"
             },
           },
     "Li" => {
             "atomic_number" => "3",
             "name" => "Lithium",
             "family" => "Alkali_Earth",
             "period" => "2",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "6.94",
             "atomic_mass" => "7.01600455",
             "covalent_radius" => "1.33",
             "vdw_radius" => "2.12",
             "charge" => ['0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "1.33",
                 "double" => "1.24"
             },
           },
     "Be" => {
             "atomic_number" => "4",
             "name" => "Beryllium",
             "family" => "Alkaline_Earth",
             "period" => "2",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "9.012182",
             "atomic_mass" => "9.0121822",
             "covalent_radius" => "1.02",
             "vdw_radius" => "1.98",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.02",
                 "double" => "0.9",
                 "triple" => "0.85"
             },
           },
     "B" => {
             "atomic_number" => "5",
             "name" => "Boron",
             "family" => "Metalloids",
             "period" => "2",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "10.81",
             "atomic_mass" => "11.0093054",
             "covalent_radius" => "0.85",
             "vdw_radius" => "1.91",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "0.85",
                 "double" => "0.78",
                 "triple" => "0.73"
             },
           },
     "C" => {
             "atomic_number" => "6",
             "name" => "Carbon",
             "family" => "Non-Metal",
             "period" => "2",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "12.011",
             "atomic_mass" => "12",
             "covalent_radius" => "0.75",
             "vdw_radius" => "1.77",
             "charge" => ['-4', '-3', '-2', '-1', '0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+2', '+4'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "0.75",
                 "double" => "0.67",
                 "triple" => "0.6"
             },
           },
     "N" => {
             "atomic_number" => "7",
             "name" => "Nitrogen",
             "family" => "Non-Metal",
             "period" => "2",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "14.007",
             "atomic_mass" => "14.003074",
             "covalent_radius" => "0.71",
             "vdw_radius" => "1.66",
             "charge" => ['-3', '-2', '-1', '0', '+1', '+2', '+3', '+4', '+5'],
             "common_charge" => ['-3', '+3', '+5'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "0.71",
                 "double" => "0.6",
                 "triple" => "0.54"
             },
           },
     "O" => {
             "atomic_number" => "8",
             "name" => "Oxygen",
             "family" => "Non-Metal",
             "period" => "2",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "15.999",
             "atomic_mass" => "15.99491462",
             "covalent_radius" => "0.63",
             "vdw_radius" => "1.50",
             "charge" => ['-2', '-1', '0', '+1', '+2'],
             "common_charge" => ['-2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "0.63",
                 "double" => "0.57",
                 "triple" => "0.53"
             },
           },
     "F" => {
             "atomic_number" => "9",
             "name" => "Fluorine",
             "family" => "Halogen",
             "period" => "2",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "18.9984032",
             "atomic_mass" => "18.99840322",
             "covalent_radius" => "0.64",
             "vdw_radius" => "1.46",
             "charge" => ['-1', '0'],
             "common_charge" => ['-1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "0.64",
                 "double" => "0.59",
                 "triple" => "0.53"
             },
           },
     "Ne" => {
             "atomic_number" => "10",
             "name" => "Neon",
             "family" => "Noblegas",
             "period" => "2",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "20.1797",
             "atomic_mass" => "19.99244018",
             "covalent_radius" => "0.96",
             "vdw_radius" => "1.58",
             "charge" => ['0'],
             "common_charge" => ['0'],
             "valence" => ['0'],
             "covalent_radii" => {
                 "single" => "0.67",
                 "double" => "0.96"
             },
           },
     "Na" => {
             "atomic_number" => "11",
             "name" => "Sodium",
             "family" => "Alkali_Earth",
             "period" => "3",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "22.98976928",
             "atomic_mass" => "22.98976928",
             "covalent_radius" => "1.6",
             "vdw_radius" => "2.50",
             "charge" => ['-1', '0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "1.55",
                 "double" => "1.6"
             },
           },
     "Mg" => {
             "atomic_number" => "12",
             "name" => "Magnesium",
             "family" => "Alkaline_Earth",
             "period" => "3",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "24.305",
             "atomic_mass" => "23.9850417",
             "covalent_radius" => "1.39",
             "vdw_radius" => "2.51",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.39",
                 "double" => "1.32",
                 "triple" => "1.27"
             },
           },
     "Al" => {
             "atomic_number" => "13",
             "name" => "Aluminium",
             "family" => "Other_Metal",
             "period" => "3",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "26.9815386",
             "atomic_mass" => "26.98153863",
             "covalent_radius" => "1.26",
             "vdw_radius" => "2.25",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.26",
                 "double" => "1.13",
                 "triple" => "1.11"
             },
           },
     "Si" => {
             "atomic_number" => "14",
             "name" => "Silicon",
             "family" => "Metalloids",
             "period" => "3",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "28.085",
             "atomic_mass" => "27.97692653",
             "covalent_radius" => "1.16",
             "vdw_radius" => "2.19",
             "charge" => ['-4', '-3', '-2', '-1', '0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['-4', '+4'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.16",
                 "double" => "1.07",
                 "triple" => "1.02"
             },
           },
     "P" => {
             "atomic_number" => "15",
             "name" => "Phosphorus",
             "family" => "Non-Metal",
             "period" => "3",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "30.973762",
             "atomic_mass" => "30.97376163",
             "covalent_radius" => "1.11",
             "vdw_radius" => "1.90",
             "charge" => ['-3', '-2', '-1', '0', '+1', '+2', '+3', '+4', '+5'],
             "common_charge" => ['-3', '+3', '+5'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.11",
                 "double" => "1.02",
                 "triple" => "0.94"
             },
           },
     "S" => {
             "atomic_number" => "16",
             "name" => "Sulfur",
             "family" => "Non-Metal",
             "period" => "3",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "32.06",
             "atomic_mass" => "31.972071",
             "covalent_radius" => "1.03",
             "vdw_radius" => "1.89",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['-2', '+2', '+4', '+6'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.03",
                 "double" => "0.94",
                 "triple" => "0.95"
             },
           },
     "Cl" => {
             "atomic_number" => "17",
             "name" => "Chlorine",
             "family" => "Halogen",
             "period" => "3",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "35.45",
             "atomic_mass" => "34.96885268",
             "covalent_radius" => "0.99",
             "vdw_radius" => "1.82",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['-1', '+1', '+3', '+5', '+7'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "0.99",
                 "double" => "0.95",
                 "triple" => "0.93"
             },
           },
     "Ar" => {
             "atomic_number" => "18",
             "name" => "Argon",
             "family" => "Noblegas",
             "period" => "3",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "39.948",
             "atomic_mass" => "39.96238312",
             "covalent_radius" => "1.07",
             "vdw_radius" => "1.83",
             "charge" => ['0'],
             "common_charge" => ['0'],
             "valence" => ['0'],
             "covalent_radii" => {
                 "single" => "0.96",
                 "double" => "1.07",
                 "triple" => "0.96"
             },
           },
     "K" => {
             "atomic_number" => "19",
             "name" => "Potassium",
             "family" => "Alkali_Earth",
             "period" => "4",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "39.0983",
             "atomic_mass" => "38.96370668",
             "covalent_radius" => "1.96",
             "vdw_radius" => "2.73",
             "charge" => ['-1', '0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "1.96",
                 "double" => "1.93"
             },
           },
     "Ca" => {
             "atomic_number" => "20",
             "name" => "Calcium",
             "family" => "Alkaline_Earth",
             "period" => "4",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "40.078",
             "atomic_mass" => "39.96259098",
             "covalent_radius" => "1.71",
             "vdw_radius" => "2.62",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.71",
                 "double" => "1.47",
                 "triple" => "1.33"
             },
           },
     "Sc" => {
             "atomic_number" => "21",
             "name" => "Scandium",
             "family" => "Transition",
             "period" => "4",
             "group" => "3",
             "block" => "d",
             "atomic_weight" => "44.955912",
             "atomic_mass" => "44.9559119",
             "covalent_radius" => "1.48",
             "vdw_radius" => "2.58",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.48",
                 "double" => "1.16",
                 "triple" => "1.14"
             },
           },
     "Ti" => {
             "atomic_number" => "22",
             "name" => "Titanium",
             "family" => "Transition",
             "period" => "4",
             "group" => "4",
             "block" => "d",
             "atomic_weight" => "47.867",
             "atomic_mass" => "47.9479463",
             "covalent_radius" => "1.36",
             "vdw_radius" => "2.46",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+4'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.36",
                 "double" => "1.17",
                 "triple" => "1.08"
             },
           },
     "V" => {
             "atomic_number" => "23",
             "name" => "Vanadium",
             "family" => "Transition",
             "period" => "4",
             "group" => "5",
             "block" => "d",
             "atomic_weight" => "50.9415",
             "atomic_mass" => "50.9439595",
             "covalent_radius" => "1.34",
             "vdw_radius" => "2.42",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5'],
             "common_charge" => ['+5'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.34",
                 "double" => "1.12",
                 "triple" => "1.06"
             },
           },
     "Cr" => {
             "atomic_number" => "24",
             "name" => "Chromium",
             "family" => "Transition",
             "period" => "4",
             "group" => "6",
             "block" => "d",
             "atomic_weight" => "51.9961",
             "atomic_mass" => "51.9405075",
             "covalent_radius" => "1.22",
             "vdw_radius" => "2.45",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+3', '+6'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.22",
                 "double" => "1.11",
                 "triple" => "1.03"
             },
           },
     "Mn" => {
             "atomic_number" => "25",
             "name" => "Manganese",
             "family" => "Transition",
             "period" => "4",
             "group" => "7",
             "block" => "d",
             "atomic_weight" => "54.938045",
             "atomic_mass" => "54.9380451",
             "covalent_radius" => "1.19",
             "vdw_radius" => "2.45",
             "charge" => ['-3', '-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['+2', '+4', '+7'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "1.19",
                 "double" => "1.05",
                 "triple" => "1.03"
             },
             "spin_state_radii" => {
                 "l.s." => "1.39",
                 "h.s." => "1.61"
             },
           },
     "Fe" => {
             "atomic_number" => "26",
             "name" => "Iron",
             "family" => "Transition",
             "period" => "4",
             "group" => "8",
             "block" => "d",
             "atomic_weight" => "55.845",
             "atomic_mass" => "55.9349375",
             "covalent_radius" => "1.16",
             "vdw_radius" => "2.44",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+2', '+3', '+6'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.16",
                 "double" => "1.09",
                 "triple" => "1.02"
             },
             "spin_state_radii" => {
                 "l.s." => "1.32",
                 "h.s." => "1.52"
             },
           },
     "Co" => {
             "atomic_number" => "27",
             "name" => "Cobalt",
             "family" => "Transition",
             "period" => "4",
             "group" => "9",
             "block" => "d",
             "atomic_weight" => "58.933195",
             "atomic_mass" => "58.933195",
             "covalent_radius" => "1.11",
             "vdw_radius" => "2.40",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5'],
             "common_charge" => ['+2', '+3'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.11",
                 "double" => "1.03",
                 "triple" => "0.96"
             },
             "spin_state_radii" => {
                 "l.s." => "1.26",
                 "h.s." => "1.50"
             },
           },
     "Ni" => {
             "atomic_number" => "28",
             "name" => "Nickel",
             "family" => "Transition",
             "period" => "4",
             "group" => "10",
             "block" => "d",
             "atomic_weight" => "58.6934",
             "atomic_mass" => "57.9353429",
             "covalent_radius" => "1.1",
             "vdw_radius" => "2.40",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.1",
                 "double" => "1.01",
                 "triple" => "1.01"
             },
           },
     "Cu" => {
             "atomic_number" => "29",
             "name" => "Copper",
             "family" => "Transition",
             "period" => "4",
             "group" => "11",
             "block" => "d",
             "atomic_weight" => "63.546",
             "atomic_mass" => "62.9295975",
             "covalent_radius" => "1.2",
             "vdw_radius" => "2.38",
             "charge" => ['0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.12",
                 "double" => "1.15",
                 "triple" => "1.2"
             },
           },
     "Zn" => {
             "atomic_number" => "30",
             "name" => "Zinc",
             "family" => "Transition",
             "period" => "4",
             "group" => "12",
             "block" => "d",
             "atomic_weight" => "65.38",
             "atomic_mass" => "63.9291422",
             "covalent_radius" => "1.2",
             "vdw_radius" => "2.39",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.18",
                 "double" => "1.2"
             },
           },
     "Ga" => {
             "atomic_number" => "31",
             "name" => "Gallium",
             "family" => "Other_Metal",
             "period" => "4",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "69.723",
             "atomic_mass" => "68.9255736",
             "covalent_radius" => "1.24",
             "vdw_radius" => "2.32",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.24",
                 "double" => "1.17",
                 "triple" => "1.21"
             },
           },
     "Ge" => {
             "atomic_number" => "32",
             "name" => "Germanium",
             "family" => "Metalloids",
             "period" => "4",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "72.630",
             "atomic_mass" => "73.9211778",
             "covalent_radius" => "1.21",
             "vdw_radius" => "2.29",
             "charge" => ['-4', '-3', '-2', '-1', '0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['-4', '+2', '+4'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.21",
                 "double" => "1.11",
                 "triple" => "1.14"
             },
           },
     "As" => {
             "atomic_number" => "33",
             "name" => "Arsenic",
             "family" => "Metalloids",
             "period" => "4",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "74.92160",
             "atomic_mass" => "74.9215965",
             "covalent_radius" => "1.21",
             "vdw_radius" => "1.88",
             "charge" => ['-3', '0', '+1', '+2', '+3', '+5'],
             "common_charge" => ['-3', '+3', '+5'],
             "valence" => ['1', '2', '3', '5'],
             "covalent_radii" => {
                 "single" => "1.21",
                 "double" => "1.14",
                 "triple" => "1.06"
             },
           },
     "Se" => {
             "atomic_number" => "34",
             "name" => "Selenium",
             "family" => "Non-Metal",
             "period" => "4",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "78.96",
             "atomic_mass" => "79.9165213",
             "covalent_radius" => "1.16",
             "vdw_radius" => "1.82",
             "charge" => ['-2', '0', '+1', '+2', '+4', '+6'],
             "common_charge" => ['-2', '+2', '+4', '+6'],
             "valence" => ['1', '2', '4', '6'],
             "covalent_radii" => {
                 "single" => "1.16",
                 "double" => "1.07",
                 "triple" => "1.07"
             },
           },
     "Br" => {
             "atomic_number" => "35",
             "name" => "Bromine",
             "family" => "Halogen",
             "period" => "4",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "79.904",
             "atomic_mass" => "78.9183371",
             "covalent_radius" => "1.14",
             "vdw_radius" => "1.86",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5', '+7'],
             "common_charge" => ['-1', '+1', '+2', '+3', '+5', '+7'],
             "valence" => ['1', '2', '3', '4', '5', '7'],
             "covalent_radii" => {
                 "single" => "1.14",
                 "double" => "1.09",
                 "triple" => "1.1"
             },
           },
     "Kr" => {
             "atomic_number" => "36",
             "name" => "Krypton",
             "family" => "Noblegas",
             "period" => "4",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "83.798",
             "atomic_mass" => "83.911507",
             "covalent_radius" => "1.21",
             "vdw_radius" => "2.25",
             "charge" => ['0', '+2'],
             "common_charge" => ['0', '+2'],
             "valence" => ['0', '2'],
             "covalent_radii" => {
                 "single" => "1.17",
                 "double" => "1.21",
                 "triple" => "1.08"
             },
           },
     "Rb" => {
             "atomic_number" => "37",
             "name" => "Rubidium",
             "family" => "Alkali_Earth",
             "period" => "5",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "85.4678",
             "atomic_mass" => "84.91178974",
             "covalent_radius" => "2.1",
             "vdw_radius" => "3.21",
             "charge" => ['-1', '0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "2.1",
                 "double" => "2.02"
             },
           },
     "Sr" => {
             "atomic_number" => "38",
             "name" => "Strontium",
             "family" => "Alkaline_Earth",
             "period" => "5",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "87.62",
             "atomic_mass" => "87.9056121",
             "covalent_radius" => "1.85",
             "vdw_radius" => "2.84",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.85",
                 "double" => "1.57",
                 "triple" => "1.39"
             },
           },
     "Y" => {
             "atomic_number" => "39",
             "name" => "Yttrium",
             "family" => "Transition",
             "period" => "5",
             "group" => "3",
             "block" => "d",
             "atomic_weight" => "88.90585",
             "atomic_mass" => "88.9058483",
             "covalent_radius" => "1.63",
             "vdw_radius" => "2.75",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.63",
                 "double" => "1.3",
                 "triple" => "1.24"
             },
           },
     "Zr" => {
             "atomic_number" => "40",
             "name" => "Zirconium",
             "family" => "Transition",
             "period" => "5",
             "group" => "4",
             "block" => "d",
             "atomic_weight" => "91.224",
             "atomic_mass" => "89.9047044",
             "covalent_radius" => "1.54",
             "vdw_radius" => "2.52",
             "charge" => ['0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+4'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.54",
                 "double" => "1.27",
                 "triple" => "1.21"
             },
           },
     "Nb" => {
             "atomic_number" => "41",
             "name" => "Niobium",
             "family" => "Transition",
             "period" => "5",
             "group" => "5",
             "block" => "d",
             "atomic_weight" => "92.90638",
             "atomic_mass" => "92.9063781",
             "covalent_radius" => "1.47",
             "vdw_radius" => "2.56",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5'],
             "common_charge" => ['+5'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.47",
                 "double" => "1.25",
                 "triple" => "1.16"
             },
           },
     "Mo" => {
             "atomic_number" => "42",
             "name" => "Molybdenum",
             "family" => "Transition",
             "period" => "5",
             "group" => "6",
             "block" => "d",
             "atomic_weight" => "95.96",
             "atomic_mass" => "97.9054082",
             "covalent_radius" => "1.38",
             "vdw_radius" => "2.45",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+4', '+6'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.38",
                 "double" => "1.21",
                 "triple" => "1.13"
             },
           },
     "Tc" => {
             "atomic_number" => "43",
             "name" => "Technetium",
             "family" => "Transition",
             "period" => "5",
             "group" => "7",
             "block" => "d",
             "atomic_weight" => "97",
             "atomic_mass" => "97.907216",
             "covalent_radius" => "1.28",
             "vdw_radius" => "2.44",
             "charge" => ['-3', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['+4', '+7'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "1.28",
                 "double" => "1.2",
                 "triple" => "1.1"
             },
           },
     "Ru" => {
             "atomic_number" => "44",
             "name" => "Ruthenium",
             "family" => "Transition",
             "period" => "5",
             "group" => "8",
             "block" => "d",
             "atomic_weight" => "101.07",
             "atomic_mass" => "101.9043493",
             "covalent_radius" => "1.25",
             "vdw_radius" => "2.46",
             "charge" => ['-2', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7', '+8'],
             "common_charge" => ['+3', '+4'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7', '8'],
             "covalent_radii" => {
                 "single" => "1.25",
                 "double" => "1.14",
                 "triple" => "1.03"
             },
           },
     "Rh" => {
             "atomic_number" => "45",
             "name" => "Rhodium",
             "family" => "Transition",
             "period" => "5",
             "group" => "9",
             "block" => "d",
             "atomic_weight" => "102.90550",
             "atomic_mass" => "102.905504",
             "covalent_radius" => "1.25",
             "vdw_radius" => "2.44",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.25",
                 "double" => "1.1",
                 "triple" => "1.06"
             },
           },
     "Pd" => {
             "atomic_number" => "46",
             "name" => "Palladium",
             "family" => "Transition",
             "period" => "5",
             "group" => "10",
             "block" => "d",
             "atomic_weight" => "106.42",
             "atomic_mass" => "105.903486",
             "covalent_radius" => "1.2",
             "vdw_radius" => "2.15",
             "charge" => ['0', '+1', '+2', '+4', '+6'],
             "common_charge" => ['+2', '+4'],
             "valence" => ['1', '2', '4', '6'],
             "covalent_radii" => {
                 "single" => "1.2",
                 "double" => "1.17",
                 "triple" => "1.12"
             },
           },
     "Ag" => {
             "atomic_number" => "47",
             "name" => "Silver",
             "family" => "Transition",
             "period" => "5",
             "group" => "11",
             "block" => "d",
             "atomic_weight" => "107.8682",
             "atomic_mass" => "106.905097",
             "covalent_radius" => "1.39",
             "vdw_radius" => "2.53",
             "charge" => ['0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+1'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.28",
                 "double" => "1.39",
                 "triple" => "1.37"
             },
           },
     "Cd" => {
             "atomic_number" => "48",
             "name" => "Cadmium",
             "family" => "Transition",
             "period" => "5",
             "group" => "12",
             "block" => "d",
             "atomic_weight" => "112.411",
             "atomic_mass" => "113.9033585",
             "covalent_radius" => "1.44",
             "vdw_radius" => "2.49",
             "charge" => ['0', '+1', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['1', '2'],
             "covalent_radii" => {
                 "single" => "1.36",
                 "double" => "1.44"
             },
           },
     "In" => {
             "atomic_number" => "49",
             "name" => "Indium",
             "family" => "Other_Metal",
             "period" => "5",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "114.818",
             "atomic_mass" => "114.903878",
             "covalent_radius" => "1.46",
             "vdw_radius" => "2.43",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.42",
                 "double" => "1.36",
                 "triple" => "1.46"
             },
           },
     "Sn" => {
             "atomic_number" => "50",
             "name" => "Tin",
             "family" => "Other_Metal",
             "period" => "5",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "118.710",
             "atomic_mass" => "119.9021947",
             "covalent_radius" => "1.4",
             "vdw_radius" => "2.42",
             "charge" => ['-4', '0', '+2', '+4'],
             "common_charge" => ['-4', '+2', '+4'],
             "valence" => ['2', '4'],
             "covalent_radii" => {
                 "single" => "1.4",
                 "double" => "1.3",
                 "triple" => "1.32"
             },
           },
     "Sb" => {
             "atomic_number" => "51",
             "name" => "Antimony",
             "family" => "Metalloids",
             "period" => "5",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "121.760",
             "atomic_mass" => "120.9038157",
             "covalent_radius" => "1.4",
             "vdw_radius" => "2.47",
             "charge" => ['-3', '0', '+3', '+5'],
             "common_charge" => ['-3', '+3', '+5'],
             "valence" => ['3', '5'],
             "covalent_radii" => {
                 "single" => "1.4",
                 "double" => "1.33",
                 "triple" => "1.27"
             },
           },
     "Te" => {
             "atomic_number" => "52",
             "name" => "Tellurium",
             "family" => "Metalloids",
             "period" => "5",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "127.60",
             "atomic_mass" => "129.9062244",
             "covalent_radius" => "1.36",
             "vdw_radius" => "1.99",
             "charge" => ['-2', '0', '+2', '+4', '+5', '+6'],
             "common_charge" => ['-2', '+2', '+4', '+6'],
             "valence" => ['2', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.36",
                 "double" => "1.28",
                 "triple" => "1.21"
             },
           },
     "I" => {
             "atomic_number" => "53",
             "name" => "Iodine",
             "family" => "Halogen",
             "period" => "5",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "126.90447",
             "atomic_mass" => "126.904473",
             "covalent_radius" => "1.33",
             "vdw_radius" => "2.04",
             "charge" => ['-1', '0', '+1', '+3', '+4', '+5', '+7'],
             "common_charge" => ['-1', '+1', '+3', '+5', '+7'],
             "valence" => ['1', '3', '4', '5', '7'],
             "covalent_radii" => {
                 "single" => "1.33",
                 "double" => "1.29",
                 "triple" => "1.25"
             },
           },
     "Xe" => {
             "atomic_number" => "54",
             "name" => "Xenon",
             "family" => "Noblegas",
             "period" => "5",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "131.293",
             "atomic_mass" => "131.9041535",
             "covalent_radius" => "1.35",
             "vdw_radius" => "2.06",
             "charge" => ['0', '+1', '+2', '+4', '+6', '+8'],
             "common_charge" => ['0', '+2', '+4', '+6'],
             "valence" => ['0', '1', '2', '4', '6', '8'],
             "covalent_radii" => {
                 "single" => "1.31",
                 "double" => "1.35",
                 "triple" => "1.22"
             },
           },
     "Cs" => {
             "atomic_number" => "55",
             "name" => "Caesium",
             "family" => "Alkali_Earth",
             "period" => "6",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "132.9054519",
             "atomic_mass" => "132.9054519",
             "covalent_radius" => "2.32",
             "vdw_radius" => "3.48",
             "charge" => ['-1', '0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "2.32",
                 "double" => "2.09"
             },
           },
     "Ba" => {
             "atomic_number" => "56",
             "name" => "Barium",
             "family" => "Alkaline_Earth",
             "period" => "6",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "137.327",
             "atomic_mass" => "137.9052472",
             "covalent_radius" => "1.96",
             "vdw_radius" => "3.03",
             "charge" => ['0', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['2'],
             "covalent_radii" => {
                 "single" => "1.96",
                 "double" => "1.61",
                 "triple" => "1.49"
             },
           },
     "La" => {
             "atomic_number" => "57",
             "name" => "Lanthanum",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "138.90547",
             "atomic_mass" => "138.9063533",
             "covalent_radius" => "1.8",
             "vdw_radius" => "2.98",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.8",
                 "double" => "1.39",
                 "triple" => "1.39"
             },
           },
     "Ce" => {
             "atomic_number" => "58",
             "name" => "Cerium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "140.116",
             "atomic_mass" => "139.9054387",
             "covalent_radius" => "1.63",
             "vdw_radius" => "2.88",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3', '+4'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.63",
                 "double" => "1.37",
                 "triple" => "1.31"
             },
           },
     "Pr" => {
             "atomic_number" => "59",
             "name" => "Praseodymium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "140.90765",
             "atomic_mass" => "140.9076528",
             "covalent_radius" => "1.76",
             "vdw_radius" => "2.92",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.76",
                 "double" => "1.38",
                 "triple" => "1.28"
             },
           },
     "Nd" => {
             "atomic_number" => "60",
             "name" => "Neodymium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "144.242",
             "atomic_mass" => "141.9077233",
             "covalent_radius" => "1.74",
             "vdw_radius" => "2.95",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.74",
                 "double" => "1.37"
             },
           },
     "Pm" => {
             "atomic_number" => "61",
             "name" => "Promethium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "145",
             "atomic_mass" => "144.912749",
             "covalent_radius" => "1.73",
             "vdw_radius" => "2.36",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.73",
                 "double" => "1.35"
             },
           },
     "Sm" => {
             "atomic_number" => "62",
             "name" => "Samarium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "150.36",
             "atomic_mass" => "151.9197324",
             "covalent_radius" => "1.72",
             "vdw_radius" => "2.90",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.72",
                 "double" => "1.34"
             },
           },
     "Eu" => {
             "atomic_number" => "63",
             "name" => "Europium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "151.964",
             "atomic_mass" => "152.9212303",
             "covalent_radius" => "1.68",
             "vdw_radius" => "2.87",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+2', '+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.68",
                 "double" => "1.34"
             },
           },
     "Gd" => {
             "atomic_number" => "64",
             "name" => "Gadolinium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "157.25",
             "atomic_mass" => "157.9241039",
             "covalent_radius" => "1.69",
             "vdw_radius" => "2.83",
             "charge" => ['0', '+1', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3'],
             "covalent_radii" => {
                 "single" => "1.69",
                 "double" => "1.35",
                 "triple" => "1.32"
             },
           },
     "Tb" => {
             "atomic_number" => "65",
             "name" => "Terbium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "158.92535",
             "atomic_mass" => "158.9253468",
             "covalent_radius" => "1.68",
             "vdw_radius" => "2.79",
             "charge" => ['0', '+1', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.68",
                 "double" => "1.35"
             },
           },
     "Dy" => {
             "atomic_number" => "66",
             "name" => "Dysprosium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "162.500",
             "atomic_mass" => "163.9291748",
             "covalent_radius" => "1.67",
             "vdw_radius" => "2.87",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.67",
                 "double" => "1.33"
             },
           },
     "Ho" => {
             "atomic_number" => "67",
             "name" => "Holmium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "164.93032",
             "atomic_mass" => "164.9303221",
             "covalent_radius" => "1.66",
             "vdw_radius" => "2.81",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.66",
                 "double" => "1.33"
             },
           },
     "Er" => {
             "atomic_number" => "68",
             "name" => "Erbium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "167.259",
             "atomic_mass" => "165.9302931",
             "covalent_radius" => "1.65",
             "vdw_radius" => "2.83",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.65",
                 "double" => "1.33"
             },
           },
     "Tm" => {
             "atomic_number" => "69",
             "name" => "Thulium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "168.93421",
             "atomic_mass" => "168.9342133",
             "covalent_radius" => "1.64",
             "vdw_radius" => "2.79",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.64",
                 "double" => "1.31"
             },
           },
     "Yb" => {
             "atomic_number" => "70",
             "name" => "Ytterbium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "173.054",
             "atomic_mass" => "173.9388621",
             "covalent_radius" => "1.7",
             "vdw_radius" => "2.80",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.7",
                 "double" => "1.29"
             },
           },
     "Lu" => {
             "atomic_number" => "71",
             "name" => "Lutetium",
             "family" => "Rare_Earth",
             "period" => "6",
             "group" => "19",
             "block" => "f",
             "atomic_weight" => "174.9668",
             "atomic_mass" => "174.9407718",
             "covalent_radius" => "1.62",
             "vdw_radius" => "2.74",
             "charge" => ['0', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['3'],
             "covalent_radii" => {
                 "single" => "1.62",
                 "double" => "1.31",
                 "triple" => "1.31"
             },
           },
     "Hf" => {
             "atomic_number" => "72",
             "name" => "Hafnium",
             "family" => "Transition",
             "period" => "6",
             "group" => "4",
             "block" => "d",
             "atomic_weight" => "178.49",
             "atomic_mass" => "179.94655",
             "covalent_radius" => "1.52",
             "vdw_radius" => "2.63",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+4'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.52",
                 "double" => "1.28",
                 "triple" => "1.22"
             },
           },
     "Ta" => {
             "atomic_number" => "73",
             "name" => "Tantalum",
             "family" => "Transition",
             "period" => "6",
             "group" => "5",
             "block" => "d",
             "atomic_weight" => "180.94788",
             "atomic_mass" => "180.9479958",
             "covalent_radius" => "1.46",
             "vdw_radius" => "2.53",
             "charge" => ['-1', '0', '+2', '+3', '+4', '+5'],
             "common_charge" => ['+5'],
             "valence" => ['1', '2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.46",
                 "double" => "1.26",
                 "triple" => "1.19"
             },
           },
     "W" => {
             "atomic_number" => "74",
             "name" => "Tungsten",
             "family" => "Transition",
             "period" => "6",
             "group" => "6",
             "block" => "d",
             "atomic_weight" => "183.84",
             "atomic_mass" => "183.9509312",
             "covalent_radius" => "1.37",
             "vdw_radius" => "2.57",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+4', '+6'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.37",
                 "double" => "1.2",
                 "triple" => "1.15"
             },
           },
     "Re" => {
             "atomic_number" => "75",
             "name" => "Rhenium",
             "family" => "Transition",
             "period" => "6",
             "group" => "7",
             "block" => "d",
             "atomic_weight" => "186.207",
             "atomic_mass" => "186.9557531",
             "covalent_radius" => "1.31",
             "vdw_radius" => "2.49",
             "charge" => ['-3', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['+4'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "1.31",
                 "double" => "1.19",
                 "triple" => "1.1"
             },
           },
     "Os" => {
             "atomic_number" => "76",
             "name" => "Osmium",
             "family" => "Transition",
             "period" => "6",
             "group" => "8",
             "block" => "d",
             "atomic_weight" => "190.23",
             "atomic_mass" => "191.9614807",
             "covalent_radius" => "1.29",
             "vdw_radius" => "2.48",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7', '+8'],
             "common_charge" => ['+4'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7', '8'],
             "covalent_radii" => {
                 "single" => "1.29",
                 "double" => "1.16",
                 "triple" => "1.09"
             },
           },
     "Ir" => {
             "atomic_number" => "77",
             "name" => "Iridium",
             "family" => "Transition",
             "period" => "6",
             "group" => "9",
             "block" => "d",
             "atomic_weight" => "192.217",
             "atomic_mass" => "192.9629264",
             "covalent_radius" => "1.22",
             "vdw_radius" => "2.41",
             "charge" => ['-3', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6', '+7', '+8'],
             "common_charge" => ['+3', '+4'],
             "valence" => ['1', '2', '3', '4', '5', '6', '7', '8'],
             "covalent_radii" => {
                 "single" => "1.22",
                 "double" => "1.15",
                 "triple" => "1.07"
             },
           },
     "Pt" => {
             "atomic_number" => "78",
             "name" => "Platinum",
             "family" => "Transition",
             "period" => "6",
             "group" => "10",
             "block" => "d",
             "atomic_weight" => "195.084",
             "atomic_mass" => "194.9647911",
             "covalent_radius" => "1.23",
             "vdw_radius" => "2.29",
             "charge" => ['-2', '-1', '0', '+1', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+2', '+3', '+4'],
             "valence" => ['1', '2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.23",
                 "double" => "1.12",
                 "triple" => "1.1"
             },
           },
     "Au" => {
             "atomic_number" => "79",
             "name" => "Gold",
             "family" => "Transition",
             "period" => "6",
             "group" => "11",
             "block" => "d",
             "atomic_weight" => "196.966569",
             "atomic_mass" => "196.9665687",
             "covalent_radius" => "1.24",
             "vdw_radius" => "2.32",
             "charge" => ['-1', '0', '+1', '+2', '+3', '+5'],
             "common_charge" => ['+3'],
             "valence" => ['1', '2', '3', '5'],
             "covalent_radii" => {
                 "single" => "1.24",
                 "double" => "1.21",
                 "triple" => "1.23"
             },
           },
     "Hg" => {
             "atomic_number" => "80",
             "name" => "Mercury",
             "family" => "Transition",
             "period" => "6",
             "group" => "12",
             "block" => "d",
             "atomic_weight" => "200.592",
             "atomic_mass" => "201.970643",
             "covalent_radius" => "1.42",
             "vdw_radius" => "2.45",
             "charge" => ['0', '+1', '+2', '+4'],
             "common_charge" => ['+1', '+2'],
             "valence" => ['1', '2', '4'],
             "covalent_radii" => {
                 "single" => "1.33",
                 "double" => "1.42"
             },
           },
     "Tl" => {
             "atomic_number" => "81",
             "name" => "Thallium",
             "family" => "Other_Metal",
             "period" => "6",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "204.38",
             "atomic_mass" => "204.9744275",
             "covalent_radius" => "1.5",
             "vdw_radius" => "2.47",
             "charge" => ['-1', '0', '+1', '+3'],
             "common_charge" => ['+1', '+3'],
             "valence" => ['1', '3'],
             "covalent_radii" => {
                 "single" => "1.44",
                 "double" => "1.42",
                 "triple" => "1.5"
             },
           },
     "Pb" => {
             "atomic_number" => "82",
             "name" => "Lead",
             "family" => "Other_Metal",
             "period" => "6",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "207.2",
             "atomic_mass" => "207.9766521",
             "covalent_radius" => "1.44",
             "vdw_radius" => "2.60",
             "charge" => ['-4', '0', '+2', '+4'],
             "common_charge" => ['+2', '+4'],
             "valence" => ['2', '4'],
             "covalent_radii" => {
                 "single" => "1.44",
                 "double" => "1.35",
                 "triple" => "1.37"
             },
           },
     "Bi" => {
             "atomic_number" => "83",
             "name" => "Bismuth",
             "family" => "Other_Metal",
             "period" => "6",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "208.98040",
             "atomic_mass" => "208.9803987",
             "covalent_radius" => "1.51",
             "vdw_radius" => "2.54",
             "charge" => ['-3', '0', '+1', '+3', '+5'],
             "common_charge" => ['+3'],
             "valence" => ['1', '3', '5'],
             "covalent_radii" => {
                 "single" => "1.51",
                 "double" => "1.41",
                 "triple" => "1.35"
             },
           },
     "Po" => {
             "atomic_number" => "84",
             "name" => "Polonium",
             "family" => "Metalloids",
             "period" => "6",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "209",
             "atomic_mass" => "208.9824304",
             "covalent_radius" => "1.45",
             "vdw_radius" => "1.97",
             "charge" => ['-2', '0', '+2', '+4', '+5', '+6'],
             "common_charge" => ['-2', '+2', '+4'],
             "valence" => ['2', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.45",
                 "double" => "1.35",
                 "triple" => "1.29"
             },
           },
     "At" => {
             "atomic_number" => "85",
             "name" => "Astatine",
             "family" => "Halogen",
             "period" => "6",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "210",
             "atomic_mass" => "209.987148",
             "covalent_radius" => "1.47",
             "vdw_radius" => "2.02",
             "charge" => ['-1', '0', '+1', '+3', '+5', '+7'],
             "common_charge" => ['-1', '+1'],
             "valence" => ['1', '3', '5', '7'],
             "covalent_radii" => {
                 "single" => "1.47",
                 "double" => "1.38",
                 "triple" => "1.38"
             },
           },
     "Rn" => {
             "atomic_number" => "86",
             "name" => "Radon",
             "family" => "Noblegas",
             "period" => "6",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "222",
             "atomic_mass" => "222.0175777",
             "covalent_radius" => "1.45",
             "vdw_radius" => "2.2",
             "charge" => ['0', '+2', '+6'],
             "common_charge" => ['0', '+2'],
             "valence" => ['0', '2', '6'],
             "covalent_radii" => {
                 "single" => "1.42",
                 "double" => "1.45",
                 "triple" => "1.33"
             },
           },
     "Fr" => {
             "atomic_number" => "87",
             "name" => "Francium",
             "family" => "Alkali_Earth",
             "period" => "7",
             "group" => "1",
             "block" => "s",
             "atomic_weight" => "223",
             "atomic_mass" => "223.0197359",
             "covalent_radius" => "2.23",
             "vdw_radius" => "3.48",
             "charge" => ['0', '+1'],
             "common_charge" => ['+1'],
             "valence" => ['1'],
             "covalent_radii" => {
                 "single" => "2.23",
                 "double" => "2.18"
             },
           },
     "Ra" => {
             "atomic_number" => "88",
             "name" => "Radium",
             "family" => "Alkaline_Earth",
             "period" => "7",
             "group" => "2",
             "block" => "s",
             "atomic_weight" => "226",
             "atomic_mass" => "226.0254098",
             "covalent_radius" => "2.01",
             "vdw_radius" => "2.83",
             "charge" => ['0', '+2'],
             "common_charge" => ['+2'],
             "valence" => ['2'],
             "covalent_radii" => {
                 "single" => "2.01",
                 "double" => "1.73",
                 "triple" => "1.59"
             },
           },
     "Ac" => {
             "atomic_number" => "89",
             "name" => "Actinium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "227",
             "atomic_mass" => "227.0277521",
             "covalent_radius" => "1.86",
             "vdw_radius" => "2.8",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.86",
                 "double" => "1.53",
                 "triple" => "1.4"
             },
           },
     "Th" => {
             "atomic_number" => "90",
             "name" => "Thorium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "232.03806",
             "atomic_mass" => "232.0380553",
             "covalent_radius" => "1.75",
             "vdw_radius" => "2.93",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+4'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.75",
                 "double" => "1.43",
                 "triple" => "1.36"
             },
           },
     "Pa" => {
             "atomic_number" => "91",
             "name" => "Protactinium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "231.03588",
             "atomic_mass" => "231.035884",
             "covalent_radius" => "1.69",
             "vdw_radius" => "2.88",
             "charge" => ['0', '+2', '+3', '+4', '+5'],
             "common_charge" => ['+5'],
             "valence" => ['2', '3', '4', '5'],
             "covalent_radii" => {
                 "single" => "1.69",
                 "double" => "1.38",
                 "triple" => "1.29"
             },
           },
     "U" => {
             "atomic_number" => "92",
             "name" => "Uranium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "238.02891",
             "atomic_mass" => "238.0507882",
             "covalent_radius" => "1.7",
             "vdw_radius" => "2.71",
             "charge" => ['0', '+2', '+3', '+4', '+5', '+6'],
             "common_charge" => ['+6'],
             "valence" => ['2', '3', '4', '5', '6'],
             "covalent_radii" => {
                 "single" => "1.7",
                 "double" => "1.34",
                 "triple" => "1.18"
             },
           },
     "Np" => {
             "atomic_number" => "93",
             "name" => "Neptunium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "237",
             "atomic_mass" => "237.0481734",
             "covalent_radius" => "1.71",
             "vdw_radius" => "2.82",
             "charge" => ['0', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['+5'],
             "valence" => ['3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "1.71",
                 "double" => "1.36",
                 "triple" => "1.16"
             },
           },
     "Pu" => {
             "atomic_number" => "94",
             "name" => "Plutonium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "244",
             "atomic_mass" => "244.064204",
             "covalent_radius" => "1.72",
             "vdw_radius" => "2.81",
             "charge" => ['0', '+3', '+4', '+5', '+6', '+7', '+8'],
             "common_charge" => ['+4'],
             "valence" => ['3', '4', '5', '6', '7', '8'],
             "covalent_radii" => {
                 "single" => "1.72",
                 "double" => "1.35"
             },
           },
     "Am" => {
             "atomic_number" => "95",
             "name" => "Americium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "243",
             "atomic_mass" => "243.0613811",
             "covalent_radius" => "1.66",
             "vdw_radius" => "2.83",
             "charge" => ['0', '+2', '+3', '+4', '+5', '+6', '+7'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4', '5', '6', '7'],
             "covalent_radii" => {
                 "single" => "1.66",
                 "double" => "1.35"
             },
           },
     "Cm" => {
             "atomic_number" => "96",
             "name" => "Curium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "247",
             "atomic_mass" => "247.070354",
             "covalent_radius" => "1.66",
             "vdw_radius" => "3.05",
             "charge" => ['0', '+2', '+3', '+4', '+6', '+8'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4', '6', '8'],
             "covalent_radii" => {
                 "single" => "1.66",
                 "double" => "1.36"
             },
           },
     "Bk" => {
             "atomic_number" => "97",
             "name" => "Berkelium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "247",
             "atomic_mass" => "247.070307",
             "covalent_radius" => "1.68",
             "vdw_radius" => "3.4",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.68",
                 "double" => "1.39"
             },
           },
     "Cf" => {
             "atomic_number" => "98",
             "name" => "Californium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "251",
             "atomic_mass" => "251.079587",
             "covalent_radius" => "1.68",
             "vdw_radius" => "3.05",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.68",
                 "double" => "1.4"
             },
           },
     "Es" => {
             "atomic_number" => "99",
             "name" => "Einsteinium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "252",
             "atomic_mass" => "252.08298",
             "covalent_radius" => "1.65",
             "vdw_radius" => "2.7",
             "charge" => ['0', '+2', '+3', '+4'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3', '4'],
             "covalent_radii" => {
                 "single" => "1.65",
                 "double" => "1.4"
             },
           },
     "Fm" => {
             "atomic_number" => "100",
             "name" => "Fermium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "257",
             "atomic_mass" => "257.095105",
             "covalent_radius" => "1.67",
             "vdw_radius" => "2.45",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.67"
             },
           },
     "Md" => {
             "atomic_number" => "101",
             "name" => "Mendelevium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "258",
             "atomic_mass" => "258.098431",
             "covalent_radius" => "1.73",
             "vdw_radius" => "2.46",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.73",
                 "double" => "1.39"
             },
           },
     "No" => {
             "atomic_number" => "102",
             "name" => "Nobelium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "259",
             "atomic_mass" => "259.10103",
             "covalent_radius" => "1.76",
             "vdw_radius" => "2.46",
             "charge" => ['0', '+2', '+3'],
             "common_charge" => ['+2'],
             "valence" => ['2', '3'],
             "covalent_radii" => {
                 "single" => "1.76"
             },
           },
     "Lr" => {
             "atomic_number" => "103",
             "name" => "Lawrencium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "20",
             "block" => "f",
             "atomic_weight" => "262",
             "atomic_mass" => "262.10963",
             "covalent_radius" => "1.61",
             "vdw_radius" => "2.46",
             "charge" => ['0', '+3'],
             "common_charge" => ['+3'],
             "valence" => ['3'],
             "covalent_radii" => {
                 "single" => "1.61",
                 "double" => "1.41"
             },
           },
     "Rf" => {
             "atomic_number" => "104",
             "name" => "Rutherfordium",
             "family" => "Transition",
             "period" => "7",
             "group" => "4",
             "block" => "d",
             "atomic_weight" => "267",
             "atomic_mass" => "261.10877",
             "covalent_radius" => "1.57",
             "charge" => ['0', '+4'],
             "common_charge" => ['+4'],
             "valence" => ['4'],
             "covalent_radii" => {
                 "single" => "1.57",
                 "double" => "1.4",
                 "triple" => "1.31"
             },
           },
     "Db" => {
             "atomic_number" => "105",
             "name" => "Dubnium",
             "family" => "Transition",
             "period" => "7",
             "group" => "5",
             "block" => "d",
             "atomic_weight" => "270",
             "atomic_mass" => "262.11408",
             "covalent_radius" => "1.49",
             "charge" => ['0', '+5'],
             "common_charge" => ['+5'],
             "valence" => ['5'],
             "covalent_radii" => {
                 "single" => "1.49",
                 "double" => "1.36",
                 "triple" => "1.26"
             },
           },
     "Sg" => {
             "atomic_number" => "106",
             "name" => "Seaborgium",
             "family" => "Transition",
             "period" => "7",
             "group" => "6",
             "block" => "d",
             "atomic_weight" => "271",
             "atomic_mass" => "263.11832",
             "covalent_radius" => "1.43",
             "charge" => ['0', '+6'],
             "common_charge" => ['+6'],
             "valence" => ['6'],
             "covalent_radii" => {
                 "single" => "1.43",
                 "double" => "1.28",
                 "triple" => "1.21"
             },
           },
     "Bh" => {
             "atomic_number" => "107",
             "name" => "Bohrium",
             "family" => "Transition",
             "period" => "7",
             "group" => "7",
             "block" => "d",
             "atomic_weight" => "270",
             "atomic_mass" => "264.1246",
             "covalent_radius" => "1.41",
             "charge" => ['0', '+7'],
             "common_charge" => ['+7'],
             "valence" => ['7'],
             "covalent_radii" => {
                 "single" => "1.41",
                 "double" => "1.28",
                 "triple" => "1.19"
             },
           },
     "Hs" => {
             "atomic_number" => "108",
             "name" => "Hassium",
             "family" => "Transition",
             "period" => "7",
             "group" => "8",
             "block" => "d",
             "atomic_weight" => "277",
             "atomic_mass" => "265.13009",
             "covalent_radius" => "1.34",
             "charge" => ['0', '+8'],
             "common_charge" => ['+8'],
             "valence" => ['8'],
             "covalent_radii" => {
                 "single" => "1.34",
                 "double" => "1.25",
                 "triple" => "1.18"
             },
           },
     "Mt" => {
             "atomic_number" => "109",
             "name" => "Meitnerium",
             "family" => "Transition",
             "period" => "7",
             "group" => "9",
             "block" => "d",
             "atomic_weight" => "276",
             "atomic_mass" => "268.13873",
             "covalent_radius" => "1.29",
             "covalent_radii" => {
                 "single" => "1.29",
                 "double" => "1.25",
                 "triple" => "1.13"
             },
           },
     "Ds" => {
             "atomic_number" => "110",
             "name" => "Darmstadtium",
             "family" => "Transition",
             "period" => "7",
             "group" => "10",
             "block" => "d",
             "atomic_weight" => "281",
             "atomic_mass" => "271.14606",
             "covalent_radius" => "1.28",
             "covalent_radii" => {
                 "single" => "1.28",
                 "double" => "1.16",
                 "triple" => "1.12"
             },
           },
     "Rg" => {
             "atomic_number" => "111",
             "name" => "Roentgenium",
             "family" => "Transition",
             "period" => "7",
             "group" => "11",
             "block" => "d",
             "atomic_weight" => "282",
             "atomic_mass" => "272.15362",
             "covalent_radius" => "1.21",
             "covalent_radii" => {
                 "single" => "1.21",
                 "double" => "1.16",
                 "triple" => "1.18"
             },
           },
     "Cn" => {
             "atomic_number" => "112",
             "name" => "Copernicium",
             "family" => "Transition",
             "period" => "7",
             "group" => "12",
             "block" => "d",
             "atomic_weight" => "285",
             "atomic_mass" => "285.17411",
             "covalent_radius" => "1.37",
             "covalent_radii" => {
                 "single" => "1.22",
                 "double" => "1.37",
                 "triple" => "1.3"
             },
           },
     "Uut" => {
             "atomic_number" => "113",
             "name" => "Ununtrium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "13",
             "block" => "p",
             "atomic_weight" => "285",
             "atomic_mass" => "284.17808",
             "covalent_radius" => "1.36",
             "covalent_radii" => {
                 "single" => "1.36"
             },
           },
     "Fl" => {
             "atomic_number" => "114",
             "name" => "Flerovium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "14",
             "block" => "p",
             "atomic_weight" => "289",
             "atomic_mass" => "289.18728",
             "covalent_radius" => "1.43",
             "covalent_radii" => {
                 "single" => "1.43"
             },
           },
     "Uup" => {
             "atomic_number" => "115",
             "name" => "Ununpentium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "15",
             "block" => "p",
             "atomic_weight" => "289",
             "atomic_mass" => "288.19249",
             "covalent_radius" => "1.62",
             "covalent_radii" => {
                 "single" => "1.62"
             },
           },
     "Lv" => {
             "atomic_number" => "116",
             "name" => "Livermorium",
             "family" => "Other_Metal",
             "period" => "7",
             "group" => "16",
             "block" => "p",
             "atomic_weight" => "293",
             "atomic_mass" => "292.19979",
             "covalent_radius" => "1.75",
             "covalent_radii" => {
                 "single" => "1.75"
             },
           },
     "Uus" => {
             "atomic_number" => "117",
             "name" => "Ununseptium",
             "family" => "Halogen",
             "period" => "7",
             "group" => "17",
             "block" => "p",
             "atomic_weight" => "294",
             "covalent_radius" => "1.65",
             "covalent_radii" => {
                 "single" => "1.65"
             },
           },
     "Uuo" => {
             "atomic_number" => "118",
             "name" => "Ununoctium",
             "family" => "Noblegas",
             "period" => "7",
             "group" => "18",
             "block" => "p",
             "atomic_weight" => "294",
             "covalent_radius" => "1.57",
             "covalent_radii" => {
                 "single" => "1.57"
             },
           },
);

1;
