/* Patch IE to support forEach on NodeLists, used in show/hide */
if (window.NodeList && !NodeList.prototype.forEach) NodeList.prototype.forEach = Array.prototype.forEach;

(function(s) {
    var a;
    /* Some browsers fail localStorage access due to corruption, preventing Cockpit login */    try {
        a = window.localStorage;
        window.localStorage.removeItem("url-root");
        window.localStorage.removeItem("standard-login");
    } catch (e) {
        a = window.sessionStorage;
        s.warn(String(e));
    }
    var r;
    var l = window.environment || {};
    var u = l.OAuth || null;
    if (u) {
        if (!u.TokenParam) u.TokenParam = "access_token";
        if (!u.ErrorParam) u.ErrorParam = "error_description";
    }
    var t = /\$\{([^}]+)\}|\$([a-zA-Z0-9_]+)/g;
    function c(e /* ... */) {
        var o = Array.prototype.slice.call(arguments, 1);
        return e.replace(t, function(e, t, n) {
            return o[t || n] || "";
        });
    }
    function n(e) {
        if (window.cockpit_po) {
            var t = window.cockpit_po[e];
            if (t && t[1]) return t[1];
        }
        return e;
    }
    function i() {
        if (!document.querySelectorAll) return;
        var e = document.querySelectorAll("[translate]");
        for (var t = 0; t < e.length; t++) e[t].textContent = n(e[t].textContent);
    }
    var d = n;
    var f, p, w, g;
    var o = /[?&]?([^=]+)=([^&]*)/g;
    var v = null;
    function m(e) {
        e = e.split("+").join(" ");
        var t = {};
        var n;
        for (;;) {
            n = o.exec(e);
            if (!n) break;
            t[decodeURIComponent(n[1])] = decodeURIComponent(n[2]);
        }
        return t;
    }
    if (!s) s = function() {};
    function h(e) {
        return document.getElementById(e);
    }
    // Hide an element (or set of elements) based on a boolean
    // true: element is hidden, false: element is shown
        function x(e, t) {
        var n;
        // If it's a single selector, convert it to an array for the loop
                if (typeof e === "string") e = [ e ];
        // >= 1 arguments (of type element or string (for CSS selectors))
        // (passed in "arguments" isn't a a true array, so forEach wouldn't always work)
                for (var o = 0; o < e.length; o++) {
            if (typeof e[o] === "string") {
                // Support CSS selectors as a string
                n = document.querySelectorAll(e[o]);
                if (n) n.forEach(function(e) {
                    if (e.hidden !== !!t) e.hidden = !!t;
                });
            } else {
                // Hide specific elements
                if (e[o].hidden !== !!t) e[o].hidden = !!t;
            }
        }
    }
    // Show >=1 arguments (element or CSS selector)
        function y() {
        x(arguments, false);
    }
    // Hide >=1 arguments (element or CSS selector)
        function b() {
        x(arguments, true);
    }
    function k(e) {
        if (window.console) s.warn("fatal:", e);
        b("#login-again", "#login-wait-validating");
        if (v) {
            h("login-again").href = v;
            y("#login-again");
        }
        b("#login", "#login-details");
        y("#login-fatal");
        var t = h("login-fatal-message");
        t.textContent = "";
        t.appendChild(document.createTextNode(e));
    }
    function S(e, t) {
        var n;
        var o = h(e);
        if (o && window.getComputedStyle) n = window.getComputedStyle(o, ":before");
        if (!n) return;
        var i;
        var r = n.content;
        if (r && r != "none" && r != "normal") {
            i = r.length;
            if ((r[0] === '"' || r[0] === "'") && i > 2 && r[i - 1] === r[0]) r = r.substr(1, i - 2);
            o.innerHTML = r || t;
        } else {
            o.removeAttribute("class");
        }
    }
    function C() {
        function o(e) {
            if (e === "supports") e = "@supports API";
            var t = c(d("This web browser is too old to run the Web Console (missing $0)"), e);
            if (window.console) s.warn(t);
            h("login-error-message").textContent = t;
            b("#login", "#login-details");
            y("#unsupported-browser", "#error-group");
            document.body.classList.add("brand-unsupported-browser");
        }
        function e(t, e) {
            var n;
            try {
                n = e && e[t];
            } catch (e) {
                k(c(d("The web browser configuration prevents Cockpit from running (inaccessible $0)"), t));
                throw e;
            }
            if (n === undefined) {
                o(t);
                return false;
            }
            return true;
        }
        function t() {
            /*
             * Be certain to use parenthesis when checking CSS strings
             * as Edge is oddly particular.
             *
             * Instead of "display: inline", use:
             * "(display: inline)"
             *        or
             * "display", "inline"
             */
            var e = [].join.call(arguments, ": ");
            if (!window.CSS || !window.CSS.supports.apply(this, arguments)) {
                o(e);
                return false;
            }
            return true;
        }
        return ("MozWebSocket" in window || e("WebSocket", window)) && e("XMLHttpRequest", window) && e("sessionStorage", window) && e("JSON", window) && e("defineProperty", Object) && e("console", window) && e("pushState", window.history) && e("textContent", document) && e("supports", window.CSS) && t("display", "flex") && t("display", "grid");
    }
    function T(e) {
        return e.replace(/^\s+|\s+$/g, "");
    }
    /* Sets values for application, url_root and login_path */    function I(e) {
        var t = document.createElement("a");
        var n = document.baseURI;
        var o;
        /* Some IEs don't support baseURI */        if (!n) {
            o = document.getElementsByTagName("base");
            if (o.length > 0) n = o[0].href; else n = "/";
        }
        e = e || "/";
        t.href = n;
        if (t.pathname != "/") {
            r = t.pathname.replace(/^\/+|\/+$/g, "");
            a.setItem("url-root", r);
            if (r && e.indexOf("/" + r) === 0) e = e.replace("/" + r, "") || "/";
        }
        if (e.indexOf("/=") === 0) {
            l.hostname = e.substring(2);
            e = "/cockpit+" + e.split("/")[1];
        } else if (e.indexOf("/cockpit/") !== 0 && e.indexOf("/cockpit+") !== 0) {
            e = "/cockpit";
        }
        p = e.split("/")[1];
        f = "/" + p + "/login";
        if (r) f = "/" + r + f;
        g = p;
        w = f;
    }
    function L(e, t) {
        // On keypress, only accept spacebar (enter acts as a click)
        if (e && e.type === "keypress" && e.key !== " ") return;
        // Stop the <a>'s click handler, otherwise it causes a page reload
                if (e && e.type === "click") e.preventDefault();
        if (t === undefined) t = h("server-group").hidden;
        x("#server-group", !t);
        h("option-group").setAttribute("data-state", t);
        if (t) {
            h("option-caret").classList.add("caret-down");
            h("option-caret").classList.remove("caret-right");
        } else {
            h("option-caret").classList.add("caret-right");
            h("option-caret").classList.remove("caret-down");
        }
    }
    function e() {
        window.onload = null;
        b(".noscript");
        i();
        if (window.cockpit_po && window.cockpit_po[""]) document.documentElement.lang = window.cockpit_po[""].language || "en-us";
        I(window.location.pathname);
        /* Determine if we are nested or not, and switch styles */        if (window.location.pathname.indexOf("/" + r + "/cockpit/") === 0 || window.location.pathname.indexOf("/" + r + "/cockpit+") === 0) document.documentElement.setAttribute("class", "inline");
        // Setup title
                var e = l.page.title;
        if (!e || p.indexOf("cockpit+=") === 0) e = l.hostname;
        document.title = e;
        if (p.indexOf("cockpit+=") === 0) {
            b("#brand", "#badge");
        } else {
            S("badge", "");
            S("brand", "Cockpit");
        }
        if (!C()) return;
        if (l.banner) {
            y("#banner");
            h("banner-message").textContent = l.banner.trimEnd();
        }
        h("show-other-login-options").addEventListener("click", L);
        h("show-other-login-options").addEventListener("keypress", L);
        h("server-clear").addEventListener("click", function() {
            var e = h("server-field");
            e.value = "";
            e.focus();
        });
        var t = l["os-release"];
        if (t) a.setItem("os-release", JSON.stringify(t));
        var n = window.sessionStorage.getItem("logout-intent") == "explicit";
        if (n) window.sessionStorage.removeItem("logout-intent");
        var o = window.sessionStorage.getItem("logout-reason");
        if (o) window.sessionStorage.removeItem("logout-reason");
        /* Try automatic/kerberos authentication? */        if (u) {
            b("#login-details", "#login");
            if (n) {
                O();
                h("login-again").textContent = d("Login again");
                k(d("Logout successful"));
            } else {
                A();
            }
        } else if (n) {
            $(o);
        } else {
            E();
        }
    }
    function E() {
        var e = new XMLHttpRequest();
        e.open("GET", f, true);
        e.onreadystatechange = function() {
            if (e.readyState == 4) {
                if (e.status == 200) {
                    K(JSON.parse(e.responseText));
                } else if (e.status == 401) {
                    $();
                } else if (e.statusText) {
                    k(decodeURIComponent(e.statusText));
                } else if (e.status === 0) {
                    $();
                } else {
                    k(c(d("$0 error"), e.status));
                }
            }
        };
        e.send();
    }
    function O() {
        var e = window.location.href.split("#", 2);
        v = u.URL;
        if (u.URL.indexOf("?") > -1) v += "&"; else v += "?";
        v += "redirect_uri=" + encodeURIComponent(e[0]);
    }
    function A() {
        var e = document.createElement("a");
        if (!u.URL) return k(d("Cockpit authentication is configured incorrectly."));
        var t = m(window.location.search);
        if (!window.location.search && window.location.hash) t = m(window.location.hash.slice(1));
        /* Not all providers allow hashes in redirect urls */        var n, o, i;
        O();
        if (t[u.TokenParam]) {
            if (window.sessionStorage.getItem("login-wanted")) {
                e.href = window.sessionStorage.getItem("login-wanted");
                I(e.pathname);
            }
            n = t[u.TokenParam];
            y("#login-wait-validating");
            i = new XMLHttpRequest();
            i.open("GET", f, true);
            i.setRequestHeader("Authorization", "Bearer " + n);
            i.onreadystatechange = function() {
                if (i.readyState == 4) {
                    if (i.status == 200) {
                        K(JSON.parse(i.responseText));
                    } else {
                        o = G(i.getResponseHeader("WWW-Authenticate"), i.responseText);
                        if (o) M(o); else k(decodeURIComponent(i.statusText));
                    }
                }
            };
            i.send();
        } else if (t[u.ErrorParam]) {
            k(t[u.ErrorParam]);
        } else {
            /* Store url we originally wanted in case we
             * had to strip a hash or query params
             */
            window.sessionStorage.setItem("login-wanted", window.location.href);
            window.location = v;
        }
    }
    function R() {
        b("#error-group");
        h("login-error-message").textContent = "";
    }
    function U() {
        b("#info-group");
        h("login-info-message").textContent = "";
    }
    function H(e, t) {
        R();
        if (e) {
            /* OAuth failures are always fatal */
            if (u) {
                k(e);
            } else {
                J(t);
                h("login-error-message").textContent = e;
                y("#error-group");
            }
        }
    }
    function N(e) {
        U();
        if (e) {
            h("login-info-message").textContent = e;
            y("#info-group");
        }
    }
    function P(e) {
        var t = h("server-field").value;
        if (!t) {
            H(e, false);
        } else {
            R();
            h("login-error-message").textContent = e;
            y("#error-group");
            L(null, true);
            J();
        }
    }
    function q(e) {
        var t = h("login-note");
        if (e) {
            y(t);
            t.textContent = e;
        } else {
            t.innerHTML = "&nbsp;";
        }
    }
    function W() {
        return l.page.require_host && g.indexOf("cockpit+=") === -1;
    }
    function _() {
        H(null);
        var e;
        var t = T(h("login-user-input").value);
        if (t === "") {
            H(d("User name cannot be empty"));
        } else if (W() && h("server-field").value === "") {
            H(d("Please specify the host to connect to"));
        } else {
            e = h("server-field").value;
            if (e) {
                p = "cockpit+=" + e;
                f = w.replace("/" + g + "/", "/" + p + "/");
            } else {
                p = g;
                f = w;
            }
            h("server-name").textContent = e || l.hostname;
            h("login-button").removeEventListener("click", _);
            var n = h("login-password-input").value;
            var o = "superuser:" + t + (e ? ":" + e : "");
            var i = a.getItem(o) || "any";
            a.setItem("superuser-key", o);
            a.setItem(o, i);
            /* Keep information if login page was used */            a.setItem("standard-login", true);
            var r = {
                Authorization: "Basic " + window.btoa(X(t + ":" + n)),
                "X-Superuser": i
            };
            // allow unknown remote hosts with interactive logins with "Connect to:"
                        if (e) r["X-SSH-Connect-Unknown-Hosts"] = "yes";
            z("GET", r, false);
        }
    }
    function J(e) {
        var t = l.page.connect;
        var n = h("option-group").getAttribute("data-state");
        b("#login-wait-validating");
        y("#login", "#login-details");
        x([ "#user-group", "#password-group" ], e);
        x("#conversation-group", !e);
        h("login-button-text").textContent = d("Log in");
        h("login-password-input").value = "";
        if (W()) {
            b("#option-group");
            n = true;
        } else {
            x("#option-group", !t || e);
        }
        if (!t || e) {
            b("#server-group");
        } else {
            x("#server-group", !n);
        }
        h("login-button").removeAttribute("disabled");
        if (!e) h("login-button").addEventListener("click", _);
    }
    function $(e) {
        /* Show the login screen */
        N(e);
        h("server-name").textContent = document.title;
        q(d("Log in with your server user account."));
        h("login-user-input").addEventListener("keydown", function(e) {
            H(null);
            U();
            if (e.which == 13) h("login-password-input").focus();
        }, false);
        var t = function(e) {
            H(null);
            if (e.which == 13) _();
        };
        h("login-password-input").addEventListener("keydown", t);
        J();
        h("login-user-input").focus();
    }
    function M(e) {
        var t = e.echo ? "text" : "password";
        h("conversation-prompt").textContent = e.prompt;
        var n = h("conversation-message");
        var o = e.error || e.message;
        if (o) {
            n.textContent = o;
            y(n);
        } else {
            b(n);
        }
        var i = h("conversation-input");
        i.value = "";
        if (e.default) i.value = e.default;
        i.setAttribute("type", t);
        H("");
        function r() {
            h("conversation-input").removeEventListener("keydown", a);
            h("login-button").removeEventListener("click", r);
            H(null, true);
            j(e.id, h("conversation-input").value);
        }
        function a(e) {
            H(null, true);
            if (e.which == 13) {
                r();
            }
        }
        h("conversation-input").addEventListener("keydown", a);
        h("login-button").addEventListener("click", r);
        J(true);
        i.focus();
    }
    function X(e) {
        return window.unescape(encodeURIComponent(e));
    }
    function G(e, t) {
        var n;
        var o;
        var i;
        var r;
        if (!e) return null;
        n = e.split(" ");
        if (n[0].toLowerCase() !== "x-conversation" && n.length != 3) return null;
        r = n[1];
        try {
            o = window.atob(n[2]);
        } catch (e) {
            if (window.console) s.error("Invalid prompt data", e);
            return null;
        }
        try {
            i = JSON.parse(t);
        } catch (e) {
            if (window.console) s.log("Got invalid JSON response for prompt data", e);
            i = {};
        }
        i.id = r;
        i.prompt = o;
        return i;
    }
    function z(e, t, n) {
        h("login-button").setAttribute("disabled", "true");
        var o = new XMLHttpRequest();
        o.open("GET", f, true);
        var i;
        var r;
        var a;
        for (a in t) o.setRequestHeader(a, t[a]);
        o.onreadystatechange = function() {
            if (o.readyState != 4) {
                return;
            } else if (o.status == 200) {
                var e = JSON.parse(o.responseText);
                K(e);
            } else if (o.status == 401) {
                r = o.getResponseHeader("WWW-Authenticate");
                if (r && r.toLowerCase().indexOf("x-conversation") === 0) {
                    i = G(r, o.responseText);
                    if (i) M(i); else k(d("Internal error: Invalid challenge header"));
                } else {
                    if (window.console) s.log(o.statusText);
                    if (o.statusText.indexOf("authentication-not-supported") > -1) {
                        var t = T(h("login-user-input").value);
                        k(c(d("The server refused to authenticate '$0' using password authentication, and no other supported authentication methods are available."), t));
                    } else if (o.statusText.indexOf("terminated") > -1) {
                        H(d("Authentication failed: Server closed connection"));
                    } else if (o.statusText.indexOf("no-host") > -1) {
                        P(d("Unable to connect to that address"));
                    } else if (o.statusText.indexOf("unknown-hostkey") > -1) {
                        P(d("Refusing to connect. Hostkey is unknown"));
                    } else if (o.statusText.indexOf("unknown-host") > -1) {
                        P(d("Refusing to connect. Host is unknown"));
                    } else if (o.statusText.indexOf("invalid-hostkey") > -1) {
                        P(d("Refusing to connect. Hostkey does not match"));
                    } else if (n) {
                        H(d("Authentication failed"));
                    } else {
                        H(d("Wrong user name or password"));
                    }
                }
            } else if (o.status == 403) {
                H(decodeURIComponent(o.statusText) || d("Permission denied"));
            } else if (o.statusText) {
                k(decodeURIComponent(o.statusText));
            } else {
                k(c(d("$0 error"), o.status));
            }
            h("login-button").removeAttribute("disabled");
        };
        o.send();
    }
    function j(e, t) {
        var n = {
            Authorization: "X-Conversation " + e + " " + window.btoa(X(t))
        };
        z("GET", n, true);
    }
    function B(e) {
        // Force a reload if not triggered below
        // because only the hash part of the url
        // changed
        var t = window.setTimeout(function() {
            t = null;
            window.location.reload(true);
        }, 100);
        if (e && e != window.location.href) window.location = e;
        // cancel forced reload if we are reloading
                window.onbeforeunload = function() {
            if (t) window.clearTimeout(t);
            t = null;
        };
    }
    function D(n) {
        var e = "/" + p + "/@localhost/";
        if (r) e = "/" + r + e;
        var o = e + "shell/index.html";
        var i = new XMLHttpRequest();
        i.open("GET", e + "manifests.json", true);
        i.onreadystatechange = function() {
            if (i.readyState == 4) {
                if (i.status == 200) {
                    var e = JSON.parse(i.responseText);
                    var t = e ? e.base1 : {};
                    if (!t.version || t.version < "119.x") {
                        B(o);
                    } else B(n);
                } else {
                    B(o);
                }
            }
        };
        i.send();
    }
    function Z(e, t, n) {
        var o = 0;
        while (o < e.length) {
            var i = e.key(o);
            if (n && i.indexOf("cockpit") !== 0) e.removeItem(i); else if (i.indexOf(t) === 0) e.removeItem(i); else o++;
        }
    }
    function F(e) {
        /* Clear anything not prefixed with
         * different application from sessionStorage
         */
        Z(window.sessionStorage, p, true);
        /* Clear anything prefixed with our application
         * and login-data, but not other non-application values.
         */        a.removeItem("login-data");
        Z(a, p, false);
        var t;
        if (e && e["login-data"]) {
            t = JSON.stringify(e["login-data"]);
            /* login-data is tied to the auth cookie, since
             * cookies are available after the page
             * session ends login-data should be too.
             */            a.setItem(p + "login-data", t);
            /* Backwards compatibility for packages that aren't application prefixed */            a.setItem("login-data", t);
        }
        /* URL Root is set by cockpit ws and shouldn't be prefixed
         * by application
         */        if (r) a.setItem("url-root", r);
        var n = l.CACertUrl;
        if (n) window.sessionStorage.setItem("CACertUrl", n);
    }
    function K(e) {
        var t = window.sessionStorage.getItem("login-wanted");
        var n = h("server-field").value;
        if (n && p != g) {
            t = "/=" + n;
            if (r) t = "/" + r + t;
        }
        /* clean up sessionStorage. clear anything that isn't prefixed
         * with an application and anything prefixed with our application.
         */        Z(window.sessionStorage, p, false);
        F(e);
        /* Make sure that the base1 version is new enough to handle
         * urls that reference machines.
         */        if (p.indexOf("cockpit+=") === 0) {
            D(t);
        } else {
            B(t);
        }
    }
    window.onload = e;
})(window.console);
//# sourceMappingURL=login.min.js.map