/* global XMLHttpRequest */
(function(a) {
    var l;
    /* Some browsers fail localStorage access due to corruption, preventing Cockpit login */    try {
        l = window.localStorage;
        window.localStorage.removeItem("url-root");
        window.localStorage.removeItem("standard-login");
    } catch (e) {
        l = window.sessionStorage;
        a.warn(String(e));
    }
    var r;
    var u = window.environment || {};
    var s = u.OAuth || null;
    if (s) {
        if (!s.TokenParam) s.TokenParam = "access_token";
        if (!s.ErrorParam) s.ErrorParam = "error_description";
    }
    var t = /\$\{([^}]+)\}|\$([a-zA-Z0-9_]+)/g;
    function d(e /* ... */) {
        var o = Array.prototype.slice.call(arguments, 1);
        return e.replace(t, function(e, t, n) {
            return o[t || n] || "";
        });
    }
    function n(e) {
        if (window.cockpit_po) {
            var t = window.cockpit_po[e];
            if (t && t[1]) return t[1];
        }
        return e;
    }
    function c() {
        if (!document.querySelectorAll) return;
        var e = document.querySelectorAll("[translate]");
        for (var t = 0; t < e.length; t++) e[t].textContent = n(e[t].textContent);
    }
    var f = n;
    var p, w, g, v;
    var o = /[?&]?([^=]+)=([^&]*)/g;
    var m = null;
    function y(e) {
        e = e.split("+").join(" ");
        var t = {};
        var n;
        for (;;) {
            n = o.exec(e);
            if (!n) break;
            t[decodeURIComponent(n[1])] = decodeURIComponent(n[2]);
        }
        return t;
    }
    if (!a) a = function() {};
    function h(e) {
        return document.getElementById(e);
    }
    function b(e) {
        if (window.console) a.warn("fatal:", e);
        h("login-again").style.display = "none";
        h("login-wait-validating").style.display = "none";
        if (m) {
            h("login-again").href = m;
            h("login-again").style.display = "block";
        }
        h("login").style.display = "none";
        h("login-details").style.display = "none";
        h("login-fatal").style.display = "block";
        var t = h("login-fatal-message");
        t.textContent = "";
        t.appendChild(document.createTextNode(e));
    }
    function k(e, t) {
        var n;
        var o = h(e);
        if (o && window.getComputedStyle) n = window.getComputedStyle(o, ":before");
        if (!n) return;
        var i;
        var r = n.content;
        if (r && r != "none" && r != "normal") {
            i = r.length;
            if ((r[0] === '"' || r[0] === "'") && i > 2 && r[i - 1] === r[0]) r = r.substr(1, i - 2);
            o.innerHTML = r || t;
        } else {
            o.removeAttribute("class");
        }
    }
    function x() {
        function o(e) {
            if (window.console) a.warn(d(f("This web browser is too old to run Cockpit (missing $0)"), e));
            h("login").style.display = "none";
            h("login-details").style.display = "none";
            h("unsupported-browser").style.display = "block";
            document.body.className += " brand-unsupported-browser";
        }
        function e(t, e) {
            var n;
            try {
                n = e[t];
            } catch (e) {
                b(d(f("The web browser configuration prevents Cockpit from running (inaccessible $0)"), t));
                throw e;
            }
            if (n === undefined) {
                o(t);
                return false;
            }
            return true;
        }
        function t() {
            /*
             * Be certain to use parenthesis when checking CSS strings
             * as Edge is oddly particular.
             *
             * Instead of "display: inline", use:
             * "(display: inline)"
             *        or
             * "display", "inline"
             */
            var e = [].join.call(arguments, ": ");
            if (!window.CSS.supports.apply(this, arguments)) {
                b(d(f("The web browser configuration prevents Cockpit from running (inaccessible $0)"), e));
                o(e);
                return false;
            }
            return true;
        }
        return ("MozWebSocket" in window || e("WebSocket", window)) && e("XMLHttpRequest", window) && e("sessionStorage", window) && e("JSON", window) && e("defineProperty", Object) && e("console", window) && e("pushState", window.history) && e("textContent", document) && e("CSS", window) && e("supports", window.CSS) && t("display", "flex") && t("display", "grid");
    }
    function S(e) {
        return e.replace(/^\s+|\s+$/g, "");
    }
    /* Sets values for application, url_root and login_path */    function C(e) {
        var t = document.createElement("a");
        var n = document.baseURI;
        var o;
        /* Some IEs don't support baseURI */        if (!n) {
            o = document.getElementsByTagName("base");
            if (o.length > 0) n = o[0].href; else n = "/";
        }
        e = e || "/";
        t.href = n;
        if (t.pathname != "/") {
            r = t.pathname.replace(/^\/+|\/+$/g, "");
            l.setItem("url-root", r);
            if (r && e.indexOf("/" + r) === 0) e = e.replace("/" + r, "") || "/";
        }
        if (e.indexOf("/=") === 0) {
            u.hostname = e.substring(2);
            e = "/cockpit+" + e.split("/")[1];
        } else if (e.indexOf("/cockpit/") !== 0 && e.indexOf("/cockpit+") !== 0) {
            e = "/cockpit";
        }
        w = e.split("/")[1];
        p = "/" + w + "/login";
        if (r) p = "/" + r + p;
        v = w;
        g = p;
    }
    function I(e, t) {
        // On keypress, only accept spacebar (enter acts as a click)
        if (e && e.type === "keypress" && e.key !== " ") return;
        // Stop the <a>'s click handler, otherwise it causes a page reload
                if (e && e.type === "click") e.preventDefault();
        if (t === undefined) t = h("server-group").style.display === "none";
        h("option-group").setAttribute("data-state", t);
        if (t) {
            h("server-group").style.display = "block";
            h("option-caret").setAttribute("class", "caret caret-down");
            h("option-caret").setAttribute("className", "caret caret-down");
        } else {
            h("server-group").style.display = "none";
            h("option-caret").setAttribute("class", "caret caret-right");
            h("option-caret").setAttribute("className", "caret caret-right");
        }
    }
    function e() {
        window.onload = null;
        c();
        if (window.cockpit_po && window.cockpit_po[""]) document.documentElement.lang = window.cockpit_po[""].language || "en-us";
        C(window.location.pathname);
        /* Determine if we are nested or not, and switch styles */        if (window.location.pathname.indexOf("/" + r + "/cockpit/") === 0 || window.location.pathname.indexOf("/" + r + "/cockpit+") === 0) document.documentElement.setAttribute("class", "inline");
        // Setup title
                var e = u.page.title;
        if (!e || w.indexOf("cockpit+=") === 0) e = u.hostname;
        document.title = e;
        if (w.indexOf("cockpit+=") === 0) {
            h("brand").style.display = "none";
            h("badge").style.visibility = "hidden";
        } else {
            k("badge", "");
            k("brand", "Cockpit");
        }
        if (!x()) return;
        if (u.banner) {
            h("banner").classList.remove("group-hidden");
            h("banner-message").textContent = u.banner.trimEnd();
        }
        h("show-other-login-options").addEventListener("click", I);
        h("show-other-login-options").addEventListener("keypress", I);
        h("server-clear").addEventListener("click", function() {
            var e = h("server-field");
            e.value = "";
            e.focus();
        });
        /* Setup the user's last choice about the authorized button */        var t = l.getItem("authorized-default");
        if (t === null || t.indexOf("password") !== -1) h("authorized-input").checked = true;
        var n = u["os-release"];
        if (n) l.setItem("os-release", JSON.stringify(n));
        var o = window.sessionStorage.getItem("logout-intent") == "explicit";
        if (o) window.sessionStorage.removeItem("logout-intent");
        var i = window.sessionStorage.getItem("logout-reason");
        if (i) window.sessionStorage.removeItem("logout-reason");
        /* Try automatic/kerberos authentication? */        if (s) {
            h("login-details").style.display = "none";
            h("login").style.display = "none";
            if (o) {
                L();
                h("login-again").textContent = f("Login Again");
                b(f("Logout Successful"));
            } else {
                O();
            }
        } else if (o) {
            q(i);
        } else {
            T();
        }
    }
    function T() {
        var e = new XMLHttpRequest();
        e.open("GET", p, true);
        e.onreadystatechange = function() {
            if (e.readyState == 4) {
                if (e.status == 200) {
                    D(JSON.parse(e.responseText));
                } else if (e.status == 401) {
                    q();
                } else if (e.statusText) {
                    b(decodeURIComponent(e.statusText));
                } else if (e.status === 0) {
                    q();
                } else {
                    b(d(f("$0 error"), e.status));
                }
            }
        };
        e.send();
    }
    function L() {
        var e = window.location.href.split("#", 2);
        m = s.URL;
        if (s.URL.indexOf("?") > -1) m += "&"; else m += "?";
        m += "redirect_uri=" + encodeURIComponent(e[0]);
    }
    function O() {
        var e = document.createElement("a");
        if (!s.URL) return b(f("Cockpit authentication is configured incorrectly."));
        var t = y(window.location.search);
        if (!window.location.search && window.location.hash) t = y(window.location.hash.slice(1));
        /* Not all providers allow hashes in redirect urls */        var n, o, i;
        L();
        if (t[s.TokenParam]) {
            if (window.sessionStorage.getItem("login-wanted")) {
                e.href = window.sessionStorage.getItem("login-wanted");
                C(e.pathname);
            }
            n = t[s.TokenParam];
            h("login-wait-validating").style.display = "block";
            i = new XMLHttpRequest();
            i.open("GET", p, true);
            i.setRequestHeader("Authorization", "Bearer " + n);
            i.onreadystatechange = function() {
                if (i.readyState == 4) {
                    if (i.status == 200) {
                        D(JSON.parse(i.responseText));
                    } else {
                        o = J(i.getResponseHeader("WWW-Authenticate"), i.responseText);
                        if (o) $(o); else b(decodeURIComponent(i.statusText));
                    }
                }
            };
            i.send();
        } else if (t[s.ErrorParam]) {
            b(t[s.ErrorParam]);
        } else {
            /* Store url we originally wanted in case we
             * had to strip a hash or query params
             */
            window.sessionStorage.setItem("login-wanted", window.location.href);
            window.location = m;
        }
    }
    function i() {
        h("error-group").classList.add("group-hidden");
        h("login-error-message").textContent = "";
    }
    function E() {
        h("info-group").classList.add("group-hidden");
        h("login-info-message").textContent = "";
    }
    function A(e, t) {
        i();
        if (e) {
            /* OAuth failures are always fatal */
            if (s) {
                b(e);
            } else {
                P(t);
                h("login-error-message").textContent = e;
                h("error-group").classList.remove("group-hidden");
            }
        }
    }
    function R(e) {
        E();
        if (e) {
            h("login-info-message").textContent = e;
            h("info-group").classList.remove("group-hidden");
        }
    }
    function U(e) {
        var t = h("server-field").value;
        if (!t) {
            A(e, false);
        } else {
            i();
            h("login-error-message").textContent = e;
            h("error-group").classList.remove("group-hidden");
            I(null, true);
            P();
        }
    }
    function H(e) {
        var t = h("login-note");
        if (e) {
            t.style.display = "block";
            t.textContent = e;
        } else {
            t.innerHTML = "&nbsp;";
        }
    }
    function N() {
        return u.page.require_host && v.indexOf("cockpit+=") === -1;
    }
    function z() {
        A(null);
        var e;
        var t = S(h("login-user-input").value);
        if (t === "") {
            A(f("User name cannot be empty"));
        } else if (N() && h("server-field").value === "") {
            A(f("Please specify the host to connect to"));
        } else {
            e = h("server-field").value;
            if (e) {
                w = "cockpit+=" + e;
                p = g.replace("/" + v + "/", "/" + w + "/");
            } else {
                w = v;
                p = g;
            }
            h("server-name").textContent = e || u.hostname;
            h("login-button").removeEventListener("click", z);
            /* When checked we tell the server to keep authentication */            var n = h("authorized-input").checked ? "password" : "";
            var o = h("login-password-input").value;
            l.setItem("authorized-default", n);
            var i = "superuser:" + t + (e ? ":" + e : "");
            var r = l.getItem(i) || "any";
            l.setItem("superuser-key", i);
            l.setItem(i, r);
            /* Keep information if login page was used */            l.setItem("standard-login", true);
            var s = {
                Authorization: "Basic " + window.btoa(_(t + ":" + o)),
                "X-Authorize": n,
                "X-Superuser": r
            };
            // allow unknown remote hosts with interactive logins with "Connect to:"
                        if (e) s["X-SSH-Connect-Unknown-Hosts"] = "yes";
            W("GET", s, false);
        }
    }
    function P(e) {
        var t = u.page.connect;
        var n = h("option-group").getAttribute("data-state");
        h("login-wait-validating").style.display = "none";
        h("login").style.visibility = "visible";
        h("login").style.display = "block";
        h("user-group").style.display = e ? "none" : "block";
        h("password-group").style.display = e ? "none" : "block";
        h("conversation-group").style.display = e ? "block" : "none";
        h("login-button-text").textContent = f("Log In");
        h("login-password-input").value = "";
        if (N()) {
            h("option-group").style.display = "none";
            n = true;
        } else {
            h("option-group").style.display = !t || e ? "none" : "block";
        }
        if (!t || e) {
            h("server-group").style.display = "none";
        } else {
            h("server-group").style.display = n ? "block" : "none";
        }
        h("login-button").removeAttribute("disabled");
        if (!e) h("login-button").addEventListener("click", z);
    }
    function q(e) {
        /* Show the login screen */
        R(e);
        h("server-name").textContent = document.title;
        H(f("Log in with your server user account."));
        h("login-user-input").addEventListener("keydown", function(e) {
            A(null);
            E();
            if (e.which == 13) h("login-password-input").focus();
        }, false);
        var t = function(e) {
            A(null);
            if (e.which == 13) z();
        };
        h("login-password-input").addEventListener("keydown", t);
        h("authorized-input").addEventListener("keydown", t);
        P();
        h("login-user-input").focus();
    }
    function $(e) {
        var t = e.echo ? "text" : "password";
        h("conversation-prompt").textContent = e.prompt;
        var n = h("conversation-message");
        var o = e.error || e.message;
        if (o) {
            n.textContent = o;
            n.style.display = "block";
        } else {
            n.style.display = "none";
        }
        var i = h("conversation-input");
        i.value = "";
        if (e.default) i.value = e.default;
        i.setAttribute("type", t);
        A("");
        function r() {
            h("conversation-input").removeEventListener("keydown", s);
            h("login-button").removeEventListener("click", r);
            A(null, true);
            X(e.id, h("conversation-input").value);
        }
        function s(e) {
            A(null, true);
            if (e.which == 13) {
                r();
            }
        }
        h("conversation-input").addEventListener("keydown", s);
        h("login-button").addEventListener("click", r);
        P(true);
        i.focus();
    }
    function _(e) {
        return window.unescape(encodeURIComponent(e));
    }
    function J(e, t) {
        var n;
        var o;
        var i;
        var r;
        if (!e) return null;
        n = e.split(" ");
        if (n[0].toLowerCase() !== "x-conversation" && n.length != 3) return null;
        r = n[1];
        try {
            o = window.atob(n[2]);
        } catch (e) {
            if (window.console) a.error("Invalid prompt data", e);
            return null;
        }
        try {
            i = JSON.parse(t);
        } catch (e) {
            if (window.console) a.log("Got invalid JSON response for prompt data", e);
            i = {};
        }
        i.id = r;
        i.prompt = o;
        return i;
    }
    function W(e, t, n) {
        h("login-button").setAttribute("disabled", "true");
        var o = new XMLHttpRequest();
        o.open("GET", p, true);
        var i;
        var r;
        var s;
        for (s in t) o.setRequestHeader(s, t[s]);
        o.onreadystatechange = function() {
            if (o.readyState != 4) {
                return;
            } else if (o.status == 200) {
                var e = JSON.parse(o.responseText);
                D(e);
            } else if (o.status == 401) {
                r = o.getResponseHeader("WWW-Authenticate");
                if (r && r.toLowerCase().indexOf("x-conversation") === 0) {
                    i = J(r, o.responseText);
                    if (i) $(i); else b(f("Internal Error: Invalid challenge header"));
                } else {
                    if (window.console) a.log(o.statusText);
                    if (o.statusText.indexOf("authentication-not-supported") > -1) {
                        var t = S(h("login-user-input").value);
                        b(d(f("The server refused to authenticate '$0' using password authentication, and no other supported authentication methods are available."), t));
                    } else if (o.statusText.indexOf("terminated") > -1) {
                        A(f("Authentication Failed: Server closed connection"));
                    } else if (o.statusText.indexOf("no-host") > -1) {
                        U(f("Unable to connect to that address"));
                    } else if (o.statusText.indexOf("unknown-hostkey") > -1) {
                        U(f("Refusing to connect. Hostkey is unknown"));
                    } else if (o.statusText.indexOf("unknown-host") > -1) {
                        U(f("Refusing to connect. Host is unknown"));
                    } else if (o.statusText.indexOf("invalid-hostkey") > -1) {
                        U(f("Refusing to connect. Hostkey does not match"));
                    } else if (n) {
                        A(f("Authentication failed"));
                    } else {
                        A(f("Wrong user name or password"));
                    }
                }
            } else if (o.status == 403) {
                A(decodeURIComponent(o.statusText) || f("Permission denied"));
            } else if (o.statusText) {
                b(decodeURIComponent(o.statusText));
            } else {
                b(d(f("$0 error"), o.status));
            }
            h("login-button").removeAttribute("disabled");
        };
        o.send();
    }
    function X(e, t) {
        var n = {
            Authorization: "X-Conversation " + e + " " + window.btoa(_(t))
        };
        W("GET", n, true);
    }
    function M(e) {
        // Force a reload if not triggered below
        // because only the hash part of the url
        // changed
        var t = window.setTimeout(function() {
            t = null;
            window.location.reload(true);
        }, 100);
        if (e && e != window.location.href) window.location = e;
        // cancel forced reload if we are reloading
                window.onbeforeunload = function() {
            if (t) window.clearTimeout(t);
            t = null;
        };
    }
    function G(n) {
        var e = "/" + w + "/@localhost/";
        if (r) e = "/" + r + e;
        var o = e + "shell/index.html";
        var i = new XMLHttpRequest();
        i.open("GET", e + "manifests.json", true);
        i.onreadystatechange = function() {
            if (i.readyState == 4) {
                if (i.status == 200) {
                    var e = JSON.parse(i.responseText);
                    var t = e ? e.base1 : {};
                    if (!t.version || t.version < "119.x") {
                        M(o);
                    } else M(n);
                } else {
                    M(o);
                }
            }
        };
        i.send();
    }
    function j(e, t, n) {
        var o = 0;
        while (o < e.length) {
            var i = e.key(o);
            if (n && i.indexOf("cockpit") !== 0) e.removeItem(i); else if (i.indexOf(t) === 0) e.removeItem(i); else o++;
        }
    }
    function B(e) {
        /* Clear anything not prefixed with
         * different application from sessionStorage
         */
        j(window.sessionStorage, w, true);
        /* Clear anything prefixed with our application
         * and login-data, but not other non-application values.
         */        l.removeItem("login-data");
        j(l, w, false);
        var t;
        if (e && e["login-data"]) {
            t = JSON.stringify(e["login-data"]);
            /* login-data is tied to the auth cookie, since
             * cookies are available after the page
             * session ends login-data should be too.
             */            l.setItem(w + "login-data", t);
            /* Backwards compatibility for packages that aren't application prefixed */            l.setItem("login-data", t);
        }
        /* URL Root is set by cockpit ws and shouldn't be prefixed
         * by application
         */        if (r) l.setItem("url-root", r);
        var n = u.CACertUrl;
        if (n) window.sessionStorage.setItem("CACertUrl", n);
    }
    function D(e) {
        var t = window.sessionStorage.getItem("login-wanted");
        var n = h("server-field").value;
        if (n && w != v) {
            t = "/=" + n;
            if (r) t = "/" + r + t;
        }
        /* clean up sessionStorage. clear anything that isn't prefixed
         * with an application and anything prefixed with our application.
         */        j(window.sessionStorage, w, false);
        B(e);
        /* Make sure that the base1 version is new enough to handle
         * urls that reference machines.
         */        if (w.indexOf("cockpit+=") === 0) {
            G(t);
        } else {
            M(t);
        }
    }
    window.onload = e;
})(window.console);
//# sourceMappingURL=login.min.js.map