/*
 * This file is part of Cockpit.
 *
 * Copyright (C) 2014 Red Hat, Inc.
 *
 * Cockpit is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * Cockpit is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Cockpit; If not, see <http://www.gnu.org/licenses/>.
 */
/* eslint-disable indent,no-empty */
var url_root;

try {
    // Sometimes this throws a SecurityError such as during testing
    url_root = window.localStorage.getItem("url-root");
} catch (e) {}

/* injected by tests */ var mock = mock || {};

// eslint-disable-line no-use-before-define
(function() {
    var X = {};
    ke(X, {});
    if (typeof window.debugging === "undefined") {
        try {
            // Sometimes this throws a SecurityError such as during testing
            window.debugging = window.sessionStorage.debugging || window.localStorage.debugging;
        } catch (e) {}
    }
    function ee(e, n) {
        var t = e.length;
        for (var r = 0; r < t; r++) {
            if (n === e[r]) return true;
        }
        return false;
    }
    /* HACK: http://web.mit.edu/jwalden/www/isArray.html */    function ne(e) {
        return Object.prototype.toString.call(e) === "[object Array]";
    }
    function te(e) {
        return typeof e === "function";
    }
    function re(e) {
        return e !== null && typeof e === "object";
    }
    function ie(e) {
        return re(e) && Object.prototype.toString.call(e) === "[object Object]";
    }
    /* Also works for negative zero */    function oe(e) {
        return ((e = +e) || 1 / e) < 0;
    }
    /* Object.assign() workalike */    function ae(e /* , from ... */) {
        var n, t, r, i;
        for (n = 1, t = arguments.length; n < t; n++) {
            i = arguments[n];
            if (i) {
                for (r in i) {
                    if (i[r] !== undefined) e[r] = i[r];
                }
            }
        }
        return e;
    }
    function se(e, n, t) {
        var r = e ? e.length : 0;
        for (var i = 0; i < r; i++) {
            if (e[i]) e[i].apply(n, t);
        }
    }
    /* -------------------------------------------------------------------------
 * Channels
 *
 * Public: https://cockpit-project.org/guide/latest/api-base1.html
 */    var fe = null;
    var le = null;
    var ue = false;
    var h = false;
    var ce = null;
    var de = null;
    var ve = null;
    var pe = null;
    var he = null;
    var me = window.location.origin;
    if (!me) {
        me = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ":" + window.location.port : "");
    }
    function ge(e, n) {
        var t = e.length;
        var r = new (n || Array)(t);
        for (var i = 0; i < t; i++) r[i] = e.charCodeAt(i) & 255;
        return r;
    }
    function we(e) {
        var n = e.length;
        var t = "";
        for (var r = 0; r < n; r++) t += String.fromCharCode(e[r]);
        return t;
    }
    /*
 * These are the polyfills from Mozilla. It's pretty nasty that
 * these weren't in the typed array standardization.
 *
 * https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding
 */    function a(e) {
        return e < 26 ? e + 65 : e < 52 ? e + 71 : e < 62 ? e - 4 : e === 62 ? 43 : e === 63 ? 47 : 65;
    }
    function be(e) {
        if (typeof e === "string") return window.btoa(e);
        /* For when the caller has chosen to use ArrayBuffer */        if (e instanceof window.ArrayBuffer) e = new window.Uint8Array(e);
        var n = e.length;
        var t = 2;
        var r = "";
        for (var i = 0, o = 0; o < n; o++) {
            t = o % 3;
            i |= e[o] << (16 >>> t & 24);
            if (t === 2 || n - o === 1) {
                r += String.fromCharCode(a(i >>> 18 & 63), a(i >>> 12 & 63), a(i >>> 6 & 63), a(i & 63));
                i = 0;
            }
        }
        return r.substr(0, r.length - 2 + t) + (t === 2 ? "" : t === 1 ? "=" : "==");
    }
    function c(e) {
        return e > 64 && e < 91 ? e - 65 : e > 96 && e < 123 ? e - 71 : e > 47 && e < 58 ? e + 4 : e === 43 ? 62 : e === 47 ? 63 : 0;
    }
    function ye(e, n) {
        if (n === String) return window.atob(e);
        var t = e.length;
        for (var r = 0; r < 3; r++) {
            if (e[t - (r + 1)] != "=") break;
        }
        var i = (t * 3 + 1 >> 2) - r;
        var o = new (n || Array)(i);
        for (var a, s, f = 0, l = 0, u = 0; u < t; u++) {
            s = u & 3;
            f |= c(e.charCodeAt(u)) << 18 - 6 * s;
            if (s === 3 || t - u === 1) {
                for (a = 0; a < 3 && l < i; a++, l++) o[l] = f >>> (16 >>> a & 24) & 255;
                f = 0;
            }
        }
        return o;
    }
    window.addEventListener("beforeunload", function() {
        h = true;
    }, false);
    function m() {
        if (window.debugging == "all" || window.debugging == "channel") console.debug.apply(console, arguments);
    }
    /*
 * Extends an object to have the standard DOM style addEventListener
 * removeEventListener and dispatchEvent methods. The dispatchEvent
 * method has the additional capability to create a new event from a type
 * string and arguments.
 */    function ke(o, a) {
        Object.defineProperties(o, {
            addEventListener: {
                enumerable: false,
                value: function e(n, t) {
                    if (a[n] === undefined) a[n] = [];
                    a[n].push(t);
                }
            },
            removeEventListener: {
                enumerable: false,
                value: function e(n, t) {
                    var r = a[n] ? a[n].length : 0;
                    for (var i = 0; i < r; i++) {
                        if (a[n][i] === t) {
                            a[n][i] = null;
                            break;
                        }
                    }
                }
            },
            dispatchEvent: {
                enumerable: false,
                value: function e(n) {
                    var t, r;
                    if (typeof n === "string") {
                        t = n;
                        r = Array.prototype.slice.call(arguments, 1);
                        var i = null;
                        if (arguments.length == 2) i = arguments[1]; else if (arguments.length > 2) i = r;
                        n = new CustomEvent(t, {
                            bubbles: false,
                            cancelable: false,
                            detail: i
                        });
                        r.unshift(n);
                    } else {
                        t = n.type;
                        r = arguments;
                    }
                    if (te(o["on" + t])) o["on" + t].apply(o, r);
                    se(a[t], o, r);
                }
            }
        });
    }
    function _e() {
        var e = window.location.pathname || "/";
        var n = url_root;
        if (window.mock && window.mock.pathname) e = window.mock.pathname;
        if (window.mock && window.mock.url_root) n = window.mock.url_root;
        if (n && e.indexOf("/" + n) === 0) e = e.replace("/" + n, "") || "/";
        if (e.indexOf("/cockpit/") !== 0 && e.indexOf("/cockpit+") !== 0) {
            if (e.indexOf("/=") === 0) e = "/cockpit+" + e.split("/")[1]; else e = "/cockpit";
        }
        return e.split("/")[1];
    }
    function Ee(e) {
        if (!e) e = "socket";
        var n = window.location.toString();
        var t = url_root;
        if (window.mock && window.mock.url) return window.mock.url;
        if (window.mock && window.mock.url_root) t = window.mock.url_root;
        var r = _e();
        if (t) r = t + "/" + r;
        if (n.indexOf("http:") === 0) {
            return "ws://" + window.location.host + "/" + r + "/" + e;
        } else if (n.indexOf("https:") === 0) {
            return "wss://" + window.location.host + "/" + r + "/" + e;
        } else {
            m("Cockpit must be used over http or https");
            return null;
        }
    }
    function Se(e, n) {
        if (!n) return e.join("");
        var t;
        var r, i, o;
        var a = 0;
        var s = e.length;
        for (r = 0; r < s; r++) a += e[r].length;
        if (window.Uint8Array) t = new window.Uint8Array(a); else t = new Array(a);
        if (t.set) {
            for (i = 0, r = 0; r < s; r++) {
                t.set(e[r], i);
                i += e[r].length;
            }
        } else {
            for (i = 0, r = 0; r < s; r++) {
                for (o = 0; o < e[r].length; o++) t[r + i] = e[r][o];
                i += e[r].length;
            }
        }
        return t;
    }
    /*
 * A WebSocket that connects to parent frame. The mechanism
 * for doing this will eventually be documented publicly,
 * but for now:
 *
 *  * Forward raw cockpit1 string protocol messages via window.postMessage
 *  * Listen for cockpit1 string protocol messages via window.onmessage
 *  * Never accept or send messages to another origin
 *  * An empty string message means "close" (not completely used yet)
 */    function g(r) {
        var i = this;
        i.readyState = 0;
        window.addEventListener("message", function e(n) {
            if (n.origin !== me || n.source !== r) return;
            var t = n.data;
            if (t === undefined || t.length === undefined && t.byteLength === undefined) return;
            if (t.length === 0) {
                i.readyState = 3;
                i.onclose();
            } else {
                i.onmessage(n);
            }
        }, false);
        i.send = function e(n) {
            r.postMessage(n, me);
        };
        i.close = function e() {
            i.readyState = 3;
            r.postMessage("", me);
            i.onclose();
        };
        window.setTimeout(function() {
            i.readyState = 1;
            i.onopen();
        }, 0);
    }
    function w(e) {
        var n, t, r, i;
        /* A binary message, split out the channel */        if (e instanceof window.ArrayBuffer) {
            n = new window.Uint8Array(e);
            t = n.length;
            for (r = 0; r < t; r++) {
                if (n[r] == 10) /* new line */
                break;
            }
            if (r === t) {
                console.warn("binary message without channel");
                return null;
            } else if (r === 0) {
                console.warn("binary control message");
                return null;
            } else {
                i = String.fromCharCode.apply(null, n.subarray(0, r));
            }
            /* A textual message */        } else {
            r = e.indexOf("\n");
            if (r === -1) {
                console.warn("text message without channel");
                return null;
            }
            i = e.substring(0, r);
        }
        return i;
    }
    /* Private Transport class */    function t() {
        var o = this;
        o.application = _e();
        /* We can trigger events */        ke(o, {});
        var n = 0;
        var t = "";
        if (window.mock) window.mock.last_transport = o;
        var a;
        var i;
        var r = false;
        var s = false;
        /* See if we should communicate via parent */        if (window.parent !== window && window.name.indexOf("cockpit1:") === 0) a = new g(window.parent);
        /* HACK: Compatibility if we're hosted by older Cockpit versions */        try {
            /* See if we should communicate via parent */
            if (!a && window.parent !== window && window.parent.options && window.parent.options.protocol == "cockpit1") {
                a = new g(window.parent);
            }
        } catch (e) {
            /* permission access errors */}
        if (!a) {
            var e = Ee();
            m("connecting to " + e);
            if (e) {
                if ("WebSocket" in window) {
                    a = new window.WebSocket(e, "cockpit1");
                } else if ("MozWebSocket" in window) {
                    // Firefox 6
                    a = new window.MozWebSocket(e);
                } else {
                    console.error("WebSocket not supported, application will not work!");
                }
            }
            i = window.setInterval(function() {
                if (o.ready) a.send('\n{ "command": "ping" }');
                if (!s) {
                    if (r) {
                        console.log("health check failure ignored");
                    } else {
                        console.log("health check failed");
                        o.close({
                            problem: "timeout"
                        });
                    }
                }
                s = false;
            }, 3e4);
        }
        if (!a) {
            a = {
                close: function() {}
            };
            window.setTimeout(function() {
                o.close({
                    problem: "no-cockpit"
                });
            }, 50);
        }
        var f = {};
        var l = {};
        var u = true;
        o.ready = false;
        /* Called when ready for channels to interact */        function c() {
            if (!o.ready) {
                o.ready = true;
                o.dispatchEvent("ready");
            }
        }
        a.onopen = function() {
            if (a) {
                if (typeof a.binaryType !== "undefined") a.binaryType = "arraybuffer";
                a.send('\n{ "command": "init", "version": 1 }');
            }
        };
        a.onclose = function() {
            m("WebSocket onclose");
            a = null;
            if (ue) {
                h = true;
                window.location.reload(true);
            }
            o.close();
        };
        a.onmessage = o.dispatch_data = function(e) {
            s = true;
            /* The first line of a message is the channel */            var n = e.data;
            var t = w(n);
            if (t === null) return false;
            var r, i;
            if (n instanceof window.ArrayBuffer) r = new window.Uint8Array(n, t.length + 1); else r = n.substring(t.length + 1);
            /* A control message, always string */            if (!t) {
                m("recv control:", r);
                i = JSON.parse(r);
            } else {
                m("recv " + t + ":", r);
            }
            var o;
            var a = pe ? pe.length : 0;
            for (o = 0; o < a; o++) {
                if (pe[o](n, t, i) === false) return false;
            }
            if (!t) v(i); else p(t, r);
            return true;
        };
        o.close = function e(n) {
            if (!n) n = {
                problem: "disconnected"
            };
            n.command = "close";
            window.clearInterval(i);
            var t = a;
            a = null;
            if (t) t.close();
            if (h) return;
            c();
 /* ready to fail */
            /* Broadcast to everyone */            for (var r in f) f[r].apply(null, [ n ]);
        };
        o.next_channel = function e() {
            n++;
            return t + String(n);
        };
        function d(e) {
            if (e.problem) {
                o.close({
                    problem: e.problem
                });
                return;
            }
            if (e.version !== 1) {
                console.error("received unsupported version in init message: " + e.version);
                o.close({
                    problem: "not-supported"
                });
                return;
            }
            if (e["channel-seed"]) t = String(e["channel-seed"]);
            if (e.host) de = e.host;
            if (le) {
                le.options = e;
                le.csrf_token = e["csrf-token"];
                le.host = de;
            }
            if (ce) ce(e);
            if (u) {
                u = false;
                c();
            }
        }
        function v(e) {
            var n = e.channel;
            var t;
            /* Init message received */            if (e.command == "init") {
                d(e);
            } else if (u) {
                u = false;
                if (e.command != "close" || n) {
                    console.error("received message before init: ", e.command);
                    e = {
                        problem: "protocol-error"
                    };
                }
                o.close(e);
                /* Any pings get sent back as pongs */            } else if (e.command == "ping") {
                e.command = "pong";
                o.send_control(e);
            } else if (e.command == "pong") {
                /* Any pong commands are ignored */} else if (e.command == "hint") {
                if (ve) ve(e);
            } else if (n !== undefined) {
                t = f[n];
                if (t) t(e);
            }
        }
        function p(e, n) {
            var t = l[e];
            if (t) t(n);
        }
        /* The channel/control arguments is used by filters, and auto-populated if necessary */        o.send_data = function e(n, t, r) {
            if (!a) {
                return false;
            }
            var i;
            var o = he ? he.length : 0;
            for (i = 0; i < o; i++) {
                if (t === undefined) t = w(n);
                if (!t && r === undefined) r = JSON.parse(n);
                if (he[i](n, t, r) === false) return false;
            }
            a.send(n);
            return true;
        };
        /* The control arguments is used by filters, and auto populated if necessary */        o.send_message = function e(n, t, r) {
            if (t) m("send " + t, n); else m("send control:", n);
            /* A binary message */            if (n.byteLength || ne(n)) {
                if (n instanceof window.ArrayBuffer) n = new window.Uint8Array(n);
                var i = Se([ ge(t), [ 10 ], n ], true);
                return o.send_data(i.buffer, t, r);
                /* A string message */            } else {
                return o.send_data(t.toString() + "\n" + n, t, r);
            }
        };
        o.send_control = function e(n) {
            if (!a && (n.command == "close" || n.command == "kill")) return;
 /* don't complain if closed and closing */            if (i && n.command == "hint" && n.hint == "ignore_transport_health_check") {
                /* This is for us, process it directly. */
                r = n.data;
                return;
            }
            return o.send_message(JSON.stringify(n), "", n);
        };
        o.register = function e(n, t, r) {
            f[n] = t;
            l[n] = r;
        };
        o.unregister = function e(n) {
            delete f[n];
            delete l[n];
        };
    }
    function xe(e) {
        var n;
        if (!fe) fe = new t();
        n = fe;
        if (n.ready) {
            e(n);
        } else {
            n.addEventListener("ready", function() {
                e(n);
            });
        }
    }
    /* Always close the transport explicitly: allows parent windows to track us */    window.addEventListener("unload", function() {
        if (fe) fe.close();
    });
    function je(i) {
        var o = this;
        /* We can trigger events */        ke(o, {});
        var a;
        var r = null;
        var s = null;
        var f = null;
        var t = false;
        var l = false;
        var u = null;
        var c = i.binary === true;
        /*
     * Queue while waiting for transport, items are tuples:
     * [is_control ? true : false, payload]
     */        var d = [];
        /* Handy for callers, but not used by us */        o.valid = true;
        o.options = i;
        o.binary = c;
        o.id = u;
        function v(e) {
            if (t) {
                console.warn("received message after done");
                o.close("protocol-error");
            } else {
                o.dispatchEvent("message", e);
            }
        }
        function p(e) {
            s = e;
            o.valid = false;
            if (a && u) a.unregister(u);
            if (s.message) console.warn(s.message);
            o.dispatchEvent("close", s);
            if (f) f.resolve(s);
        }
        function h(e) {
            r = e;
            o.dispatchEvent("ready", r);
        }
        function m(e) {
            if (e.command == "close") {
                p(e);
                return;
            } else if (e.command == "ready") {
                h(e);
            }
            var n = e.command === "done";
            if (n && t) {
                console.warn("received two done commands on channel");
                o.close("protocol-error");
            } else {
                if (n) t = true;
                o.dispatchEvent("control", e);
            }
        }
        function g(e) {
            if (!c) {
                if (typeof e !== "string") e = String(e);
            }
            a.send_message(e, u);
        }
        xe(function(e) {
            a = e;
            if (s) return;
            u = a.next_channel();
            o.id = u;
            /* Register channel handlers */            a.register(u, m, v);
            /* Now open the channel */            var n = {};
            for (var t in i) n[t] = i[t];
            n.command = "open";
            n.channel = u;
            if (!n.host) {
                if (de) n.host = de;
            }
            if (c) n.binary = "raw"; else delete n.binary;
            n["flow-control"] = true;
            a.send_control(n);
            /* Now drain the queue */            while (d.length > 0) {
                var r = d.shift();
                if (r[0]) {
                    r[1].channel = u;
                    a.send_control(r[1]);
                } else {
                    g(r[1]);
                }
            }
        });
        o.send = function e(n) {
            if (s) console.warn("sending message on closed channel"); else if (l) console.warn("sending message after done"); else if (!a) d.push([ false, n ]); else g(n);
        };
        o.control = function e(n) {
            n = n || {};
            if (!n.command) n.command = "options";
            if (n.command === "done") l = true;
            n.channel = u;
            if (!a) d.push([ true, n ]); else a.send_control(n);
        };
        o.wait = function e(n) {
            if (!f) {
                f = X.defer();
                if (s) {
                    f.reject(s);
                } else if (r) {
                    f.resolve(r);
                } else {
                    o.addEventListener("ready", function(e, n) {
                        f.resolve(n);
                    });
                    o.addEventListener("close", function(e, n) {
                        f.reject(n);
                    });
                }
            }
            var t = f.promise;
            if (n) t.then(n, n);
            return t;
        };
        o.close = function e(n) {
            if (s) return;
            if (!n) n = {}; else if (typeof n == "string") n = {
                problem: n
            };
            n.command = "close";
            n.channel = u;
            if (!a) d.push([ true, n ]); else a.send_control(n);
            p(n);
        };
        o.buffer = function e(n) {
            var i = [];
            i.callback = n;
            i.squash = function e() {
                return Se(i, c);
            };
            function t(e, n) {
                var t, r;
                i.push(n);
                if (i.callback) {
                    r = Se(i, c);
                    if (r.length > 0) {
                        t = i.callback.call(o, r);
                        if (typeof t !== "number" || t === r.length) {
                            i.length = 0;
                        } else if (t === 0) {
                            i.length = 1;
                            i[0] = r;
                        } else if (t !== 0) {
                            i.length = 1;
                            if (r.subarray) i[0] = r.subarray(t); else if (r.substring) i[0] = r.substring(t); else i[0] = r.slice(t);
                        }
                    }
                }
            }
            function r() {
                o.removeEventListener("message", t);
                o.removeEventListener("close", r);
            }
            o.addEventListener("message", t);
            o.addEventListener("close", r);
            return i;
        };
        o.toString = function e() {
            var n = i.host || "localhost";
            return "[Channel " + (o.valid ? u : "<invalid>") + " -> " + n + "]";
        };
    }
    /* Resolve dots and double dots */    function Oe(e) {
        var n = [];
        var t = e.length;
        for (var r = 0; r < t; r++) {
            var i = e[r];
            if (i === "" || i == ".") {
                continue;
            } else if (i == "..") {
                if (n.length === 0) return null;
                n.pop();
            } else {
                n.push(i);
            }
        }
        return n;
    }
    function e() {
        X.channel = function e(n) {
            return new je(n);
        };
        X.event_target = function e(n) {
            ke(n, {});
            return n;
        };
        X.extend = ae;
        /* These can be filled in by loading ../manifests.js */        X.manifests = {};
        /* ------------------------------------------------------------
     * Text Encoding
     */        function t(i) {
            var e = this;
            e.encoding = "utf-8";
            e.encode = function e(n, t) {
                var r = window.unescape(encodeURIComponent(n));
                if (i === String) return r;
                return ge(r, i);
            };
        }
        function r(d) {
            var e = this;
            var v = null;
            e.encoding = "utf-8";
            e.decode = function e(n, t) {
                var r = t && t.stream;
                if (n === null || n === undefined) n = "";
                if (typeof n !== "string") n = we(n);
                if (v) {
                    n = v + n;
                    v = null;
                }
                /* We have to scan to do non-fatal and streaming */                var i = 0;
                var o = 0;
                var a = n.length;
                var s, f, l, u;
                var c = "";
                while (o < a) {
                    s = n.charCodeAt(o);
                    f = s == 255 ? 0 : s > 251 && s < 254 ? 6 : s > 247 && s < 252 ? 5 : s > 239 && s < 248 ? 4 : s > 223 && s < 240 ? 3 : s > 191 && s < 224 ? 2 : s < 128 ? 1 : 0;
                    u = o + f <= a;
                    if (!u && r) {
                        v = n.substring(o);
                        break;
                    }
                    if (f === 0) u = false;
                    for (l = 1; u && l < f; l++) u = (n.charCodeAt(o + l) & 128) !== 0;
                    if (!u) {
                        if (d) {
                            o = a;
                            break;
                        }
                        c += decodeURIComponent(window.escape(n.substring(i, o)));
                        c += "�";
                        o++;
                        i = o;
                    } else {
                        o += f;
                    }
                }
                c += decodeURIComponent(window.escape(n.substring(i, o)));
                return c;
            };
        }
        X.utf8_encoder = function e(n) {
            return new t(n);
        };
        X.utf8_decoder = function e(n) {
            return new r(!!n);
        };
        X.base64_encode = be;
        X.base64_decode = ye;
        X.kill = function e(n, t) {
            var r = {};
            if (n) r.host = n;
            if (t) r.group = t;
            X.transport.control("kill", r);
        };
        /* Not public API ... yet? */        X.hint = function e(n, t) {
            if (!fe) return;
            if (!t) t = de;
            if (typeof t == "string") t = {
                host: t
            };
            t.hint = n;
            X.transport.control("hint", t);
        };
        X.transport = le = {
            wait: xe,
            inject: function e(n, t) {
                if (!fe) return false;
                if (t === undefined || t) return fe.send_data(n); else return fe.dispatch_data({
                    data: n
                });
            },
            filter: function e(n, t) {
                if (t) {
                    if (!he) he = [];
                    he.push(n);
                } else {
                    if (!pe) pe = [];
                    pe.push(n);
                }
            },
            close: function e(n) {
                var t;
                if (n) t = {
                    problem: n
                };
                if (fe) fe.close(t);
                fe = null;
                this.options = {};
            },
            origin: me,
            options: {},
            uri: Ee,
            control: function(e, n) {
                n = ae({}, n);
                n.command = e;
                xe(function(e) {
                    e.send_control(n);
                });
            },
            application: function() {
                if (!fe || window.mock) return _e();
                return fe.application;
            }
        };
        /* ------------------------------------------------------------------------------------
     * An ordered queue of functions that should be called later.
     */        var i = [];
        var o = null;
        function n() {
            var e;
            var n = i;
            o = null;
            i = [];
            for (;;) {
                e = n.shift();
                if (!e) break;
                e();
            }
        }
        function L(e) {
            if (e) i.push(e);
            if (o === null) o = window.setTimeout(n, 0);
        }
        /* ------------------------------------------------------------------------------------
     * Promises.
     * Based on Q and angular promises, with some jQuery compatibility. See the angular
     * license in COPYING.node for license lineage. There are some key differences with
     * both Q and jQuery.
     *
     *  * Exceptions thrown in handlers are not treated as rejections or failures.
     *    Exceptions remain actual exceptions.
     *  * Unlike jQuery callbacks added to an already completed promise don't execute
     *    immediately. Wait until control is returned to the browser.
     */        function a(e, n, t, r) {
            if (n === undefined && t === undefined && r === undefined) return null;
            var i = new d();
            e.pending = e.pending || [];
            e.pending.push([ i, n, t, r ]);
            if (e.status > 0) f(e);
            return i.promise;
        }
        function e(i) {
            /* Like jQuery the promise object is callable */
            var o = function e(n) {
                if (n) {
                    ae(n, o);
                    return n;
                }
                return o;
            };
            i.status = 0;
            o.then = function e(n, t, r) {
                return a(i, n, t, r) || o;
            };
            o.catch = function e(n) {
                return a(i, null, n) || o;
            };
            o.finally = function e(n, t) {
                return a(i, function() {
                    return p(arguments, true, n);
                }, function() {
                    return p(arguments, false, n);
                }, t) || o;
            };
            /* Basic jQuery Promise compatibility */            o.done = function e(n) {
                a(i, n);
                return o;
            };
            o.fail = function e(n) {
                a(i, null, n);
                return o;
            };
            o.always = function e(n) {
                a(i, n, n);
                return o;
            };
            o.progress = function e(n) {
                a(i, null, null, n);
                return o;
            };
            o.state = function e() {
                if (i.status == 1) return "resolved";
                if (i.status == 2) return "rejected";
                return "pending";
            };
            /* Promises are recursive like jQuery */            o.promise = o;
            return o;
        }
        function s(e) {
            var n, t, r;
            r = e.pending;
            e.process_scheduled = false;
            e.pending = undefined;
            for (var i = 0, o = r.length; i < o; ++i) {
                e.pur = true;
                t = r[i][0];
                n = r[i][e.status];
                if (te(n)) {
                    t.resolve(n.apply(e.promise, e.values));
                } else if (e.status === 1) {
                    t.resolve.apply(t.resolve, e.values);
                } else {
                    t.reject.apply(t.reject, e.values);
                }
            }
        }
        function f(e) {
            if (e.process_scheduled || !e.pending) return;
            e.process_scheduled = true;
            L(function() {
                s(e);
            });
        }
        function l(e, n) {
            var t;
            var r = false;
            if (re(n[0]) || te(n[0])) t = n[0] && n[0].then;
            if (te(t)) {
                e.status = -1;
                t.call(n[0], function() {
                    if (r) return;
                    r = true;
                    l(e, arguments);
                }, function() {
                    if (r) return;
                    r = true;
                    u(e, arguments);
                }, function() {
                    c(e, arguments);
                });
            } else {
                e.values = n;
                e.status = 1;
                f(e);
            }
        }
        function u(e, n) {
            e.values = n;
            e.status = 2;
            f(e);
        }
        function c(i, o) {
            var a = i.pending;
            if (i.status <= 0 && a && a.length) {
                L(function() {
                    var e, n;
                    for (var t = 0, r = a.length; t < r; t++) {
                        n = a[t][0];
                        e = a[t][3];
                        if (te(e)) n.notify(e.apply(i.promise, o)); else n.notify.apply(n, o);
                    }
                });
            }
        }
        function d() {
            var n = this;
            var t = {};
            n.promise = t.promise = e(t);
            n.resolve = function e() {
                if (arguments[0] === t.promise) throw new Error("Expected promise to be resolved with other value than itself");
                if (!t.status) l(t, arguments);
                return n;
            };
            n.reject = function e() {
                if (t.status) return;
                u(t, arguments);
                return n;
            };
            n.notify = function e() {
                c(t, arguments);
                return n;
            };
        }
        function v(e, n) {
            var t = X.defer();
            if (n) t.resolve.apply(t, e); else t.reject.apply(t, e);
            return t.promise;
        }
        function p(e, n, t) {
            var r = null;
            if (te(t)) r = t();
            if (r && te(r.then)) {
                return r.then(function() {
                    return v(e, n);
                }, function() {
                    return v(arguments, false);
                });
            } else {
                return v(e, n);
            }
        }
        X.when = function e(n, t, r, i) {
            var o = X.defer();
            o.resolve(n);
            return o.promise.then(t, r, i);
        };
        X.all = function e(n) {
            // eslint-disable-line cockpit/no-cockpit-all
            var t = X.defer();
            var r = 0;
            var i = [];
            if (arguments.length != 1 && !ne(n)) n = Array.prototype.slice.call(arguments);
            n.forEach(function(e, n) {
                r++;
                X.when(e).then(function(e) {
                    i[n] = e;
                    if (!--r) t.resolve.apply(t, i);
                }, function() {
                    t.reject.apply(t, arguments);
                });
            });
            if (r === 0) t.resolve(i);
            return t.promise;
        };
        X.resolve = function e(n) {
            return X.defer().resolve(n).promise;
        };
        X.reject = function e(n) {
            return X.defer().reject(n).promise;
        };
        X.defer = function() {
            return new d();
        };
        /* ---------------------------------------------------------------------
     * Utilities
     */        var h = /\$\{([^}]+)\}|\$([a-zA-Z0-9_]+)/g;
        X.format = function e(n, i) {
            if (arguments.length != 2 || !re(i) || i === null) i = Array.prototype.slice.call(arguments, 1);
            function t(e, n, t) {
                var r = i[n || t];
                /* Special-case 0 (also catches 0.0). All other falsy values return
             * the empty string.
             */                if (r === 0) return "0";
                return r || "";
            }
            return n.replace(h, t);
        };
        X.format_number = function e(n) {
            /* We show 3 digits of precison but avoid scientific notation.
         * We also show integers without digits after the comma.
         *
         * We want to localise the decimal place, but we never want to
         * show thousands separators (to avoid ambiguity).  For this
         * reason, for integers and large enough numbers, we use
         * non-localised conversions (and in both cases, show no
         * fractional part).
         */
            var t = X.language === undefined ? undefined : X.language.replace("_", "-");
            if (!n && n !== 0) return ""; else if (n % 1 === 0) return n.toString(); else if (n > 0 && n <= .001) return .001.toLocaleString(t); else if (n < 0 && n >= -.001) return (-.001).toLocaleString(t); else if (n > 999 || n < -999) return n.toFixed(0); else return n.toLocaleString(t, {
                maximumSignificantDigits: 3,
                minimumSignificantDigits: 3
            });
        };
        function m(e, n, t, r) {
            var i;
            var o = null;
            var a, s;
            var f;
            var l, u, c;
            /* Find that factor string */            if (!e && e !== 0) {
                o = null;
            } else if (typeof t === "string") {
                /* Prefer larger factors */
                s = [];
                for (a in n) s.push(a);
                s.sort().reverse();
                for (l = 0; l < s.length; l++) {
                    for (u = 0; u < n[s[l]].length; u++) {
                        if (t == n[s[l]][u]) {
                            e = e / Math.pow(s[l], u);
                            o = t;
                            break;
                        }
                    }
                    if (o) break;
                }
                /* @factor is a number */            } else if (t in n) {
                f = 1;
                for (c = 0; c < n[t].length; c++) {
                    i = e / f;
                    if (i < t) {
                        e = i;
                        o = n[t][c];
                        break;
                    }
                    f *= t;
                }
            }
            var d = X.format_number(e);
            var v;
            if (d && o) v = [ d, o ]; else v = [ d ];
            if (!r) v = v.join(" ");
            return v;
        }
        var g = {
            1e3: [ null, "KB", "MB", "GB", "TB", "PB", "EB", "ZB" ],
            1024: [ null, "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB" ]
        };
        X.format_bytes = function e(n, t, r) {
            if (t === undefined) t = 1024;
            return m(n, g, t, r);
        };
        X.get_byte_units = function e(n, t) {
            if (t === undefined || !(t in g)) t = 1024;
            function r(e) {
                return {
                    name: g[t][e],
                    factor: Math.pow(t, e)
                };
            }
            var i = [ r(2), r(3), r(4) ];
            // The default unit is the largest one that gives us at least
            // two decimal digits in front of the comma.
                        for (var o = i.length - 1; o >= 0; o--) {
                if (o === 0 || n / i[o].factor >= 10) {
                    i[o].selected = true;
                    break;
                }
            }
            return i;
        };
        var w = {
            1024: [ "B/s", "KiB/s", "MiB/s", "GiB/s", "TiB/s", "PiB/s", "EiB/s", "ZiB/s" ]
        };
        X.format_bytes_per_sec = function e(n, t, r) {
            if (t === undefined) t = 1024;
            return m(n, w, t, r);
        };
        var b = {
            1e3: [ "bps", "Kbps", "Mbps", "Gbps", "Tbps", "Pbps", "Ebps", "Zbps" ]
        };
        X.format_bits_per_sec = function e(n, t, r) {
            if (t === undefined) t = 1e3;
            return m(n, b, t, r);
        };
        /* ---------------------------------------------------------------------
     * Storage Helper.
     *
     * Use application to prefix data stored in browser storage
     * with helpers for compatibility.
     */        function y(e) {
            var r = this;
            var i;
            try {
                i = window[e];
            } catch (e) {}
            r.prefixedKey = function(e) {
                return X.transport.application() + ":" + e;
            };
            r.getItem = function(e, n) {
                var t = i.getItem(r.prefixedKey(e));
                if (!t && n) t = i.getItem(e);
                return t;
            };
            r.setItem = function(e, n, t) {
                i.setItem(r.prefixedKey(e), n);
                if (t) i.setItem(e, n);
            };
            r.removeItem = function(e, n) {
                i.removeItem(r.prefixedKey(e));
                if (n) i.removeItem(e);
            };
            /* Instead of clearing, purge anything that isn't prefixed with an application
         * and anything prefixed with our application.
         */            r.clear = function(e) {
                var n = 0;
                while (n < i.length) {
                    var t = i.key(n);
                    if (e && t.indexOf("cockpit") !== 0) i.removeItem(t); else if (t.indexOf(X.transport.application()) === 0) i.removeItem(t); else n++;
                }
            };
        }
        X.localStorage = new y("localStorage");
        X.sessionStorage = new y("sessionStorage");
        /* ---------------------------------------------------------------------
     * Shared data cache.
     *
     * We cannot use sessionStorage when keeping lots of data in memory and
     * sharing it between frames. It has a rather paltry limit on the amount
     * of data it can hold ... so we use window properties instead.
     */        function _(e) {
            var n;
            if (e.parent && e.parent !== e) n = _(e.parent);
            if (!n) {
                try {
                    n = e["cv1-storage"];
                    if (!n) e["cv1-storage"] = n = {};
                } catch (e) {}
            }
            return n;
        }
        function k(r, i, n) {
            var o = this;
            var a = X.transport.application() + ":" + r;
            /* For triggering events and ownership */            var s = window.sessionStorage;
            var f;
            var l = _(window);
            var u = false;
            var c;
            function t() {
                var e;
                /* Only run the callback if we have a result */                if (l[a] !== undefined) {
                    e = l[a];
                    window.setTimeout(function() {
                        if (n(e, r) === false) o.close();
                    });
                }
            }
            function d(e) {
                if (c && !u) u = true;
                if (!u) return;
                // use a random number to avoid races by separate instances
                                var n = Math.floor(Math.random() * 1e7) + 1;
                /* Event for the local window */                var t = document.createEvent("StorageEvent");
                t.initStorageEvent("storage", false, false, a, null, n, window.location, s);
                l[a] = e;
                s.setItem(a, n);
                t.self = o;
                window.dispatchEvent(t);
            }
            o.claim = function e() {
                if (c) return;
                /* In case we're unclaimed during the callback */                var n = {
                    close: function() {}
                };
                c = n;
                var t = i(d, r);
                if (c === n) c = t; else t.close();
            };
            function v() {
                if (c && c.close) c.close();
                c = null;
                if (!u) return;
                u = false;
                var e = s.getItem(a);
                if (e) e = parseInt(e, 10); else e = null;
                if (f && f === e) {
                    var n = document.createEvent("StorageEvent");
                    var t = s[a];
                    n.initStorageEvent("storage", false, false, a, t, null, window.location, s);
                    delete l[a];
                    s.removeItem(a);
                    n.self = o;
                    window.dispatchEvent(n);
                }
            }
            function e(e) {
                if (e.key !== a) return;
                /* check where the event came from
               - it came from someone else:
                   if it notifies their unclaim (new value null) and we haven't already claimed, do so
               - it came from ourselves:
                   if the new value doesn't match the actual value in the cache, and
                   we tried to claim (from null to a number), cancel our claim
             */                if (e.self !== o) {
                    if (!e.newValue && !u) {
                        o.claim();
                        return;
                    }
                } else if (u && !e.oldValue && e.newValue !== s.getItem(a)) {
                    v();
                }
                var n = null;
                if (e.newValue) n = parseInt(e.newValue, 10);
                if (f !== n) {
                    f = n;
                    t();
                }
            }
            o.close = function() {
                window.removeEventListener("storage", e, true);
                v();
            };
            window.addEventListener("storage", e, true);
            /* Always clear this data on unload */            window.addEventListener("beforeunload", function() {
                o.close();
            });
            window.addEventListener("unload", function() {
                o.close();
            });
            if (s.getItem(a)) t(); else o.claim();
        }
        X.cache = function e(n, t, r) {
            return new k(n, t, r);
        };
        /* ---------------------------------------------------------------------
     * Metrics
     *
     * Implements the cockpit.series and cockpit.grid. Part of the metrics
     * implementations that do not require jquery.
     */        function E(i, e, r) {
            var v = this;
            v.interval = i;
            v.limit = e ? 64 * 1024 : 1024;
            /*
         * The cache sits on a window, either our own or a parent
         * window whichever we can access properly.
         *
         * Entries in the index are:
         *
         * { beg: N, items: [], mapping: { }, next: item }
         */            var p = n(e);
            /*
         * A linked list through the index, that we use for expiry
         * of the cache.
         */            var h = 0;
            var m = null;
            var g = null;
            function n(e) {
                if (!e) return [];
                /* Try and find a good place to cache data */                var n = _(window);
                var t = n[e];
                if (!t) n[e] = t = [];
                return t;
            }
            function w(e, n) {
                var t = 0;
                var r = e.length - 1;
                var i, o;
                while (t <= r) {
                    i = (t + r) / 2 | 0;
                    o = e[i].beg;
                    if (o < n) t = i + 1; else if (o > n) r = i - 1; else return i;
 /* key found */                }
                return t;
            }
            function b(e, n, t) {
                if (r) {
                    if (!t) {
                        /* Stash some fake data synchronously so that we don't ask
                     * again for the same range while they are still fetching
                     * it asynchronously.
                     */
                        o(e, new Array(n - e), {});
                    }
                    r(e, n, t);
                }
            }
            v.load = function e(n, t, r) {
                if (t <= n) return;
                var i = w(p, n);
                var o;
                var a, s, f, l, u;
                var c = p.length;
                var d = n;
                /* We do this in two phases: First, we walk the index to
             * process what we already have and at the same time make
             * notes about what we need to fetch.  Then we go over the
             * notes and actually fetch what we need.  That way, the
             * fetch callbacks in the second phase can modify the
             * index data structure without disturbing the walk in the
             * first phase.
             */                var v = [];
                /* Data relevant to this range can be at the found index, or earlier */                for (u = i > 0 ? i - 1 : i; u < c; u++) {
                    o = p[u];
                    l = o.items.length;
                    if (!l) continue;
                    f = o.beg;
                    a = Math.max(f, n);
                    s = Math.min(f + l, t);
                    if (a < s) {
                        if (a > d) v.push([ d, a ]);
                        y(a, o.items.slice(a - f, s - f), o.mapping);
                        d = s;
                    } else if (u >= i) {
                        break;
 /* no further intersections */                    }
                }
                for (u = 0; u < v.length; u++) b(v[u][0], v[u][1], r);
                if (d != t) b(d, t, r);
            };
            function o(e, n, t) {
                if (!n.length) return;
                var r = w(p, e);
                var i = e + n.length;
                var o;
                var a;
                var s, f, l, u, c;
                var d = p.length;
                for (c = r > 0 ? r - 1 : r; c < d; c++) {
                    o = p[c];
                    u = o.items.length;
                    if (!u) continue;
                    l = o.beg;
                    s = Math.max(l, e);
                    f = Math.min(l + u, i);
                    /*
                 * We truncate blocks that intersect with this one
                 *
                 * We could adjust them, but in general the loaders are
                 * intelligent enough to only load the required data, so
                 * not doing this optimization yet.
                 */                    if (s < f) {
                        a = f - s;
                        o.items.splice(s - l, a);
                        h -= a;
                        if (s - l === 0) o.beg += f - l;
                    } else if (c >= r) {
                        break;
 /* no further intersections */                    }
                }
                /* Insert our item into the array */                o = {
                    beg: e,
                    items: n,
                    mapping: t
                };
                if (!m) m = o;
                if (g) g.next = o;
                g = o;
                h += n.length;
                p.splice(r, 0, o);
                /* Remove any items with zero length around insertion point */                for (r--; r <= c; r++) {
                    o = p[r];
                    if (o && !o.items.length) {
                        p.splice(r, 1);
                        r--;
                    }
                }
                /* If our index has gotten too big, expire entries */                while (m && h > v.limit) {
                    h -= m.items.length;
                    m.items = [];
                    m.mapping = null;
                    m = m.next || null;
                }
                /* Remove any entries with zero length at beginning */                d = p.length;
                for (c = 0; c < d; c++) {
                    if (p[c].items.length > 0) break;
                }
                p.splice(0, c);
            }
            /*
         * Used to populate grids, the keys are grid ids and
         * the values are objects: { grid, rows, notify }
         *
         * The rows field is an object indexed by paths
         * container aliases, and the values are: [ row, path ]
         */            var k = {};
            /* An undocumented function called by DataGrid */            v._register = function e(n, t) {
                if (n.interval != i) throw Error("mismatched metric interval between grid and sink");
                var r = k[t];
                if (!r) {
                    r = k[t] = {
                        grid: n,
                        links: []
                    };
                    r.links.remove = function e() {
                        delete k[t];
                    };
                }
                return r.links;
            };
            function y(e, n, t) {
                var r, i, o, a, s;
                var f, l, u, c;
                var d, v, p;
                var h, m, g, w, b;
                var y = e + n.length;
                for (d in k) {
                    v = k[d];
                    p = v.grid;
                    w = Math.max(e, p.beg);
                    b = Math.min(y, p.end);
                    /* Does this grid overlap the bounds of item? */                    if (w < b) {
                        /* Where in the items to take from */
                        h = w - e;
                        /* Where and how many to place */                        m = w - p.beg;
                        /* How many to process */                        g = b - w;
                        for (r = 0; r < g; r++) {
                            s = v.links.length;
                            for (a = 0; a < s; a++) {
                                l = v.links[a][0];
                                u = v.links[a][1];
                                /* Calulate the data field to fill in */                                f = n[h + r];
                                c = t;
                                o = l.length;
                                for (i = 0; f !== undefined && i < o; i++) {
                                    if (!f) {
                                        f = undefined;
                                    } else if (c !== undefined && c !== null) {
                                        c = c[l[i]];
                                        if (c) f = f[c[""]]; else f = f[l[i]];
                                    } else {
                                        f = f[l[i]];
                                    }
                                }
                                u[m + r] = f;
                            }
                        }
                        /* Notify the grid, so it can call any functions */                        p.notify(m, g);
                    }
                }
            }
            v.input = function e(n, t, r) {
                y(n, t, r);
                o(n, t, r);
            };
            v.close = function() {
                var e, n;
                for (n in k) {
                    e = k[n];
                    if (e && e.grid) e.grid.remove_sink(v);
                }
            };
        }
        X.series = function e(n, t, r) {
            return new E(n, t, r);
        };
        var S = 1;
        function x(e, n, t) {
            var s = this;
            /* We can trigger events */            ke(s, {});
            var a = [];
            s.interval = e;
            s.beg = 0;
            s.end = 0;
            /*
         * Used to populate table data, the values are:
         * [ callback, row ]
         */            var f = [];
            var l = [];
            var u = 0;
            var c = "g1-" + S;
            S += 1;
            /* Used while walking */            var r = null;
            var i = null;
            s.notify = function e(n, t) {
                if (u) return;
                if (n + t > s.end - s.beg) t = s.end - s.beg - n;
                if (t <= 0) return;
                var r;
                var i = f.length;
                var o, a;
                for (r = 0; r < i; r++) {
                    o = f[r][0];
                    a = f[r][1];
                    o.call(s, a, n, t);
                }
                s.dispatchEvent("notify", n, t);
            };
            s.add = function e() {
                var n = [];
                a.push(n);
                var t, r, i, o;
                /* Called as add(sink, path) */                if (re(arguments[0])) {
                    t = arguments[0];
                    t = t.series || t;
                    /* The path argument can be an array, or a dot separated string */                    r = arguments[1];
                    if (!r) r = []; else if (typeof r === "string") r = r.split(".");
                    i = t._register(s, c);
                    if (!i.length) l.push({
                        sink: t,
                        links: i
                    });
                    i.push([ r, n ]);
                    /* Called as add(callback) */                } else if (te(arguments[0])) {
                    o = [ arguments[0], n ];
                    if (arguments[1] === true) f.unshift(o); else f.push(o);
                    /* Not called as add() */                } else if (arguments.length !== 0) {
                    throw Error("invalid args to grid.add()");
                }
                return n;
            };
            s.remove = function e(n) {
                var t, r, i, o;
                /* Remove from the sinks */                i = l.length;
                for (r = 0; r < i; r++) {
                    o = l[r].links.length;
                    for (t = 0; t < o; t++) {
                        if (l[r].links[t][1] === n) {
                            l[r].links.splice(t, 1);
                            break;
                        }
                    }
                }
                /* Remove from our list of rows */                i = a.length;
                for (r = 0; r < i; r++) {
                    if (a[r] === n) {
                        a.splice(r, 1);
                        break;
                    }
                }
            };
            s.remove_sink = function e(n) {
                var t;
                var r = l.length;
                for (t = 0; t < r; t++) {
                    if (l[t].sink === n) {
                        l[t].links.remove();
                        l.splice(t, 1);
                        break;
                    }
                }
            };
            s.sync = function e(n) {
                /* Suppress notifications */
                u++;
                /* Ask all sinks to load data */                var t, r;
                var i = l.length;
                for (r = 0; r < i; r++) {
                    t = l[r].sink;
                    t.load(s.beg, s.end, n);
                }
                u--;
                /* Notify for all rows */                s.notify(0, s.end - s.beg);
            };
            function o(e, n, t) {
                if (n === undefined) n = e + (s.end - s.beg);
                if (n < e) e = n;
                s.beg = e;
                s.end = n;
                if (!a.length) return;
                a.forEach(function(e) {
                    e.length = 0;
                });
                s.sync(t);
            }
            function d() {
                window.clearInterval(r);
                r = null;
                i = null;
            }
            s.move = function e(n, t) {
                d();
                /* Some code paths use now twice.
             * They should use the same value.
             */                var r = null;
                /* Treat negative numbers relative to now */                if (n === undefined) {
                    n = 0;
                } else if (oe(n)) {
                    r = Date.now();
                    n = Math.floor(r / s.interval) + n;
                }
                if (t !== undefined && oe(t)) {
                    if (r === null) r = Date.now();
                    t = Math.floor(r / s.interval) + t;
                }
                o(n, t, false);
            };
            s.walk = function e() {
                /* Don't overflow 32 signed bits with the interval since
             * many browsers will mishandle it.  This means that plots
             * that would make about one step every month don't walk
             * at all, but I guess that is ok.
             *
             * For example,
             * https://developer.mozilla.org/en-US/docs/Web/API/WindowTimers/setTimeout
             * says:
             *
             *    Browsers including Internet Explorer, Chrome,
             *    Safari, and Firefox store the delay as a 32-bit
             *    signed Integer internally. This causes an Integer
             *    overflow when using delays larger than 2147483647,
             *    resulting in the timeout being executed immediately.
             */
                var n = Date.now();
                if (s.interval > 2e9) return;
                d();
                i = n - s.beg * s.interval;
                r = window.setInterval(function() {
                    var e = Date.now();
                    o(Math.floor((e - i) / s.interval), undefined, true);
                }, s.interval);
            };
            s.close = function e() {
                d();
                while (l.length) l.pop().links.remove();
            };
            s.move(n, t);
        }
        X.grid = function e(n, t, r) {
            return new x(n, t, r);
        };
        /* --------------------------------------------------------------------
     * Basic utilities.
     */        function j(e, n) {
            this.problem = e;
            this.message = n || X.message(e);
            this.toString = function() {
                return this.message;
            };
        }
        X.logout = function e(n) {
            /* fully clear session storage */
            X.sessionStorage.clear(true);
            /* Only clean application data from localStorage,
         * except for login-data. Clear that completely */            X.localStorage.removeItem("login-data", true);
            X.localStorage.clear(false);
            if (n !== false) ue = true;
            xe(function(e) {
                if (!e.send_control({
                    command: "logout",
                    disconnect: true
                })) window.location.reload(ue);
            });
            window.sessionStorage.setItem("logout-intent", "explicit");
        };
        /* Not public API ... yet? */        X.drop_privileges = function e() {
            xe(function(e) {
                e.send_control({
                    command: "logout",
                    disconnect: false
                });
            });
        };
        /* ---------------------------------------------------------------------
     * User and system information
     */        X.info = {};
        ke(X.info, {});
        ce = function(e) {
            if (e.system) ae(X.info, e.system);
            if (e.system) X.info.dispatchEvent("changed");
        };
        var O = null;
        X.user = function() {
            var t = X.defer();
            var e;
            if (!O) {
                e = X.dbus(null, {
                    bus: "internal"
                });
                e.call("/user", "org.freedesktop.DBus.Properties", "GetAll", [ "cockpit.User" ], {
                    type: "s"
                }).done(function(e) {
                    var n = e[0];
                    t.resolve({
                        id: n.Id.v,
                        name: n.Name.v,
                        full_name: n.Full.v,
                        groups: n.Groups.v,
                        home: n.Home.v,
                        shell: n.Shell.v
                    });
                }).fail(function(e) {
                    t.reject(e);
                }).always(function() {
                    e.close();
                });
            } else {
                t.resolve(O);
            }
            return t.promise;
        };
        /* ------------------------------------------------------------------------
     * Override for broken browser behavior
     */        document.addEventListener("click", function(e) {
            if (e.target.classList && ee(e.target.classList, "disabled")) e.stopPropagation();
        }, true);
        /* ------------------------------------------------------------------------
     * Cockpit location
     */
        /* HACK: Mozilla will unescape 'window.location.hash' before returning
     * it, which is broken.
     *
     * https://bugzilla.mozilla.org/show_bug.cgi?id=135309
     */        var I = null;
        function C() {
            return window.location.href.split("#")[1] || "";
        }
        function A() {
            var f = this;
            var e = X.transport.application();
            f.url_root = url_root || "";
            if (e.indexOf("cockpit+=") === 0) {
                if (f.url_root) f.url_root += "/";
                f.url_root = f.url_root + e.replace("cockpit+", "");
            }
            var n = C();
            var t = {};
            var o = i(n, t);
            function l(e) {
                var n = e.split("/").map(decodeURIComponent);
                var t, r;
                var i = [];
                if (f.url_root) i = f.url_root.split("/").map(decodeURIComponent);
                if (e && e[0] !== "/") {
                    t = [].concat(o);
                    t.pop();
                    t = t.concat(n);
                } else {
                    t = n;
                }
                t = Oe(t);
                for (r = 0; r < i.length; r++) {
                    if (i[r] !== t[r]) break;
                }
                if (r == i.length) t.splice(0, i.length);
                return t;
            }
            function r(e, n, t) {
                if (typeof e == "string") e = l(e, f.path);
                var r = "/" + e.map(encodeURIComponent).join("/");
                if (t && f.url_root && r.indexOf("/" + f.url_root + "/" !== 0)) r = "/" + f.url_root + r;
                /* Undo unnecessary encoding of these */                r = r.replace("%40", "@");
                r = r.replace("%3D", "=");
                r = r.replace(/%2B/g, "+");
                var i, o;
                var a = [];
                function s(e) {
                    a.push(encodeURIComponent(i) + "=" + encodeURIComponent(e));
                }
                if (n) {
                    for (i in n) {
                        o = n[i];
                        if (!ne(o)) o = [ o ];
                        o.forEach(s);
                    }
                    if (a.length > 0) r += "?" + a.join("&");
                }
                return r;
            }
            function i(e, o) {
                if (e[0] == "#") e = e.substr(1);
                var n = e.indexOf("?");
                var t = e;
                if (n === -1) t = e; else t = e.substr(0, n);
                var r = l(t);
                if (n !== -1 && o) {
                    e.substring(n + 1).split("&").forEach(function(e) {
                        var n;
                        var t = e.split("=");
                        var r = decodeURIComponent(t[0]);
                        var i = decodeURIComponent(t[1]);
                        if (o[r]) {
                            n = o[r];
                            if (!ne(i)) n = o[r] = [ n ];
                            n.push(i);
                        } else {
                            o[r] = i;
                        }
                    });
                }
                return r;
            }
            function a() {
                var e;
                if (arguments.length == 1 && arguments[0] instanceof A) {
                    e = String(arguments[0]);
                } else if (typeof arguments[0] == "string") {
                    var n = arguments[1] || {};
                    e = r(i(arguments[0], n), n);
                } else {
                    e = r.apply(f, arguments);
                }
                return e;
            }
            function s() {
                if (f !== I) return;
                var e = a.apply(f, arguments);
                window.location.replace(window.location.pathname + "#" + e);
            }
            function u() {
                if (f !== I) return;
                var e = a.apply(f, arguments);
                window.location.hash = "#" + e;
            }
            Object.defineProperties(f, {
                path: {
                    enumerable: true,
                    writable: false,
                    value: o
                },
                options: {
                    enumerable: true,
                    writable: false,
                    value: t
                },
                href: {
                    enumerable: true,
                    value: n
                },
                go: {
                    value: u
                },
                replace: {
                    value: s
                },
                encode: {
                    value: r
                },
                decode: {
                    value: i
                },
                toString: {
                    value: function() {
                        return n;
                    }
                }
            });
        }
        Object.defineProperty(X, "location", {
            enumerable: true,
            get: function() {
                if (!I || I.href !== C()) I = new A();
                return I;
            },
            set: function(e) {
                X.location.go(e);
            }
        });
        window.addEventListener("hashchange", function() {
            I = null;
            var e = window.location.hash;
            if (e.indexOf("#") === 0) e = e.substring(1);
            X.hint("location", {
                hash: e
            });
            X.dispatchEvent("locationchanged");
        });
        /* ------------------------------------------------------------------------
     * Cockpit jump
     */        X.jump = function e(n, t) {
            if (ne(n)) n = "/" + n.map(encodeURIComponent).join("/").replace("%40", "@").replace("%3D", "=").replace(/%2B/g, "+"); else n = "" + n;
            /* When host is not given (undefined), use current transport's host. If
         * it is null, use localhost.
         */            if (t === undefined) t = X.transport.host;
            var r = {
                command: "jump",
                location: n,
                host: t
            };
            X.transport.inject("\n" + JSON.stringify(r));
        };
        /* ---------------------------------------------------------------------
     * Cockpit Page Visibility
     */
        (function() {
            var n;
            var t = false;
            function r() {
                var e = document[n];
                if (!n || typeof e === "undefined") e = false;
                if (e === false) e = t;
                if (X.hidden !== e) {
                    X.hidden = e;
                    X.dispatchEvent("visibilitychange");
                }
            }
            if (typeof document.hidden !== "undefined") {
                n = "hidden";
                document.addEventListener("visibilitychange", r);
            } else if (typeof document.mozHidden !== "undefined") {
                n = "mozHidden";
                document.addEventListener("mozvisibilitychange", r);
            } else if (typeof document.msHidden !== "undefined") {
                n = "msHidden";
                document.addEventListener("msvisibilitychange", r);
            } else if (typeof document.webkitHidden !== "undefined") {
                n = "webkitHidden";
                document.addEventListener("webkitvisibilitychange", r);
            }
            /*
         * Wait for changes in visibility of just our iframe. These are delivered
         * via a hint message from the parent. For now we are the only handler of
         * hint messages, so this is implemented rather simply on purpose.
         */            ve = function(e) {
                if ("hidden" in e) {
                    t = e.hidden;
                    r();
                }
            };
            /* The first time */            r();
        })();
        /* ---------------------------------------------------------------------
     * Spawning
     */        function B(e, n) {
            this.problem = e.problem || null;
            this.exit_status = e["exit-status"];
            if (this.exit_status === undefined) this.exit_status = null;
            this.exit_signal = e["exit-signal"];
            if (this.exit_signal === undefined) this.exit_signal = null;
            this.message = e.message;
            if (this.message === undefined) {
                if (this.problem) this.message = X.message(e.problem); else if (this.exit_signal !== null) this.message = X.format(H("$0 killed with signal $1"), n, this.exit_signal); else if (this.exit_status !== undefined) this.message = X.format(H("$0 exited with code $1"), n, this.exit_status); else this.message = X.format(H("$0 failed"), n);
            } else {
                this.message = this.message.trim();
            }
            this.toString = function() {
                return this.message;
            };
        }
        function M() {
            if (window.debugging == "all" || window.debugging == "spawn") console.debug.apply(console, arguments);
        }
        /* public */        X.spawn = function(e, n) {
            var r = X.defer();
            var t = {
                payload: "stream",
                spawn: []
            };
            if (e instanceof Array) {
                for (var i = 0; i < e.length; i++) t.spawn.push(String(e[i]));
            } else {
                t.spawn.push(String(e));
            }
            if (n !== undefined) ae(t, n);
            var o = t.spawn[0] || "process";
            var a = X.channel(t);
            /* Callback that wants a stream response, see below */            var s = a.buffer(null);
            a.addEventListener("close", function(e, n) {
                var t = s.squash();
                M("process closed:", JSON.stringify(n));
                if (t) M("process output:", t);
                if (n.message !== undefined) M("process error:", n.message);
                if (n.problem) r.reject(new B(n, o)); else if (n["exit-status"] || n["exit-signal"]) r.reject(new B(n, o), t); else if (n.message !== undefined) r.resolve(t, n.message); else r.resolve(t);
            });
            var f = r.promise;
            f.stream = function(e) {
                s.callback = e.bind(f);
                return this;
            };
            f.input = function(e, n) {
                if (e !== null && e !== undefined) {
                    M("process input:", e);
                    a.send(e);
                }
                if (!n) a.control({
                    command: "done"
                });
                return this;
            };
            f.close = function(e) {
                M("process closing:", e);
                if (a.valid) a.close(e);
                return this;
            };
            return f;
        };
        /* public */        X.script = function(e, n, t) {
            if (!t && ie(n)) {
                t = n;
                n = [];
            }
            var r = [ "/bin/sh", "-c", e, "--" ];
            r.push.apply(r, n);
            return X.spawn(r, t);
        };
        function N() {
            if (window.debugging == "all" || window.debugging == "dbus") console.debug.apply(console, arguments);
        }
        function U(e, n) {
            if (typeof e == "string") {
                this.problem = e;
                this.name = null;
                this.message = n || X.message(e);
            } else {
                this.problem = null;
                this.name = e[0];
                this.message = e[1][0] || e[0];
            }
            this.toString = function() {
                return this.message;
            };
        }
        function J() {
            var o = this;
            var s = [];
            o.data = {};
            o.meta = {};
            o.connect = function e(i, o, a, n) {
                var t = [ i, o, a ];
                if (n) s.unshift(t); else s.push(t);
                return {
                    remove: function e() {
                        var n;
                        var t = s.length;
                        for (n = 0; n < t; n++) {
                            var r = s[n];
                            if (r[0] === i && r[1] === o && r[2] === a) {
                                delete r[n];
                                break;
                            }
                        }
                    }
                };
            };
            function i(e, n, t) {
                var r = s.slice();
                var i;
                var o = r.length;
                for (i = 0; i < o; i++) {
                    var a = r[i];
                    if ((!a[0] || a[0] === e) && (!a[1] || a[1] === n)) {
                        a[2](t, e);
                    }
                }
            }
            o.update = function e(n, t, r) {
                if (!o.data[n]) o.data[n] = {};
                if (!o.data[n][t]) o.data[n][t] = r; else r = ae(o.data[n][t], r);
                i(n, t, r);
            };
            o.remove = function e(n, t) {
                if (o.data[n]) {
                    delete o.data[n][t];
                    i(n, t, null);
                }
            };
            o.lookup = function e(n, t) {
                if (o.data[n]) return o.data[n][t];
                return undefined;
            };
            o.each = function e(n, t) {
                var r, i;
                for (r in o.data) {
                    for (n in o.data[r]) {
                        if (i == n) t(o.data[r][n], r);
                    }
                }
            };
            o.close = function e() {
                o.data = {};
                var n = s;
                s = [];
                var t;
                var r = n.length;
                for (t = 0; t < r; t++) n[t].callback();
            };
        }
        function T(i, e, o, a, n) {
            var s = this;
            ke(s, {});
            var t = false;
            var f = false;
            var r = X.defer();
            /* No enumeration on these properties */            Object.defineProperties(s, {
                client: {
                    value: i,
                    enumerable: false,
                    writable: false
                },
                path: {
                    value: a,
                    enumerable: false,
                    writable: false
                },
                iface: {
                    value: o,
                    enumerable: false,
                    writable: false
                },
                valid: {
                    get: function() {
                        return t;
                    },
                    enumerable: false
                },
                wait: {
                    enumerable: false,
                    writable: false,
                    value: function(e) {
                        if (e) r.promise.always(e);
                        return r.promise;
                    }
                },
                call: {
                    value: function(e, n, t) {
                        return i.call(a, o, e, n, t);
                    },
                    enumerable: false,
                    writable: false
                },
                data: {
                    value: {},
                    enumerable: false
                }
            });
            if (typeof window.$ === "function") {
                Object.defineProperty(s, window.$.expando, {
                    value: {},
                    writable: true,
                    enumerable: false
                });
            }
            if (!n) n = {};
            function l() {
                if (!e.meta[o]) return;
                var r = e.meta[o];
                f = true;
                Object.keys(r.methods || {}).forEach(function(e) {
                    if (e[0].toLowerCase() == e[0]) return;
 /* Only map upper case */
                    /* Again, make sure these don't show up in enumerations */                    Object.defineProperty(s, e, {
                        enumerable: false,
                        value: function() {
                            var n = X.defer();
                            i.call(a, o, e, Array.prototype.slice.call(arguments)).done(function(e) {
                                n.resolve.apply(n, e);
                            }).fail(function(e) {
                                n.reject(e);
                            });
                            return n.promise;
                        }
                    });
                });
                Object.keys(r.properties || {}).forEach(function(n) {
                    if (n[0].toLowerCase() == n[0]) return;
 /* Only map upper case */                    var e = {
                        enumerable: true,
                        get: function() {
                            return s.data[n];
                        },
                        set: function(e) {
                            throw Error(n + "is not writable");
                        }
                    };
                    var t = r.properties[n];
                    if (t.flags && t.flags.indexOf("w") !== -1) {
                        e.set = function(e) {
                            i.call(a, "org.freedesktop.DBus.Properties", "Set", [ o, n, X.variant(t.type, e) ]).fail(function(e) {
                                console.log("Couldn't set " + o + " " + n + " at " + a + ": " + e);
                            });
                        };
                    }
                    /* Again, make sure these don't show up in enumerations */                    Object.defineProperty(s, n, e);
                });
            }
            function u(e) {
                if (e) {
                    ae(s.data, e);
                    if (!f) l();
                    t = true;
                } else {
                    t = false;
                }
                s.dispatchEvent("changed", e);
            }
            e.connect(a, o, u, true);
            u(e.lookup(a, o));
            function c(e, n, t, r) {
                s.dispatchEvent("signal", t, r);
                if (t[0].toLowerCase() != t[0]) {
                    r = r.slice();
                    r.unshift(t);
                    s.dispatchEvent.apply(s, r);
                }
            }
            i.subscribe({
                path: a,
                interface: o
            }, c, n.subscribe !== false);
            function d(e) {
                if (t) r.resolve(); else r.reject(e);
            }
            /* If watching then do a proper watch, otherwise object is done */            if (n.watch !== false) i.watch({
                path: a,
                interface: o
            }).always(d); else d();
        }
        function P(r, e, i, n, o) {
            var a = this;
            ke(a, {});
            var t;
            Object.defineProperties(a, {
                client: {
                    value: r,
                    enumerable: false,
                    writable: false
                },
                iface: {
                    value: i,
                    enumerable: false,
                    writable: false
                },
                path_namespace: {
                    value: n,
                    enumerable: false,
                    writable: false
                },
                wait: {
                    enumerable: false,
                    writable: false,
                    value: function(e) {
                        if (e) t.always(e);
                        return t;
                    }
                }
            });
            if (typeof window.$ === "function") {
                Object.defineProperty(a, window.$.expando, {
                    value: {},
                    writable: true,
                    enumerable: false
                });
            }
            /* Subscribe to signals once for all proxies */            var s = {
                interface: i,
                path_namespace: n
            };
            /* Callbacks added by proxies */            r.subscribe(s);
            /* Watch for property changes */            if (o.watch !== false) {
                t = r.watch(s);
            } else {
                t = X.defer().resolve().promise;
            }
            /* Already added watch/subscribe, tell proxies not to */            o = ae({
                watch: false,
                subscribe: false
            }, o);
            function f(e, n) {
                var t = a[n];
                if (n) {
                    if (!e && t) {
                        delete a[n];
                        a.dispatchEvent("removed", t);
                    } else if (e) {
                        if (!t) {
                            t = a[n] = r.proxy(i, n, o);
                            a.dispatchEvent("added", t);
                        }
                        a.dispatchEvent("changed", t);
                    }
                }
            }
            e.connect(null, i, f, false);
            e.each(i, f);
        }
        function D(o, t) {
            var a = this;
            ke(a, {});
            var e = {};
            var s = false;
            var f = null;
            if (t) {
                if (t.track) s = true;
                delete t.track;
                ae(e, t);
            }
            e.payload = "dbus-json3";
            if (o) e.name = o;
            a.options = t;
            a.unique_name = null;
            N("dbus open: ", e);
            var l = X.channel(e);
            var u = {};
            var c = {};
            var d = {};
            var v;
            /* The problem we closed with */            var p;
            a.constructors = {
                "*": T
            };
            /* Allows waiting on the channel if necessary */            a.wait = l.wait;
            function h() {
                if (!v) v = new J();
            }
            function m(e) {
                if (l && l.valid) {
                    N("dbus:", e);
                    l.send(e);
                    return true;
                }
                return false;
            }
            function g(e, n) {
                if (n.path && e[0] !== n.path) return false;
                if (n.path_namespace && e[0].indexOf(n.path_namespace) !== 0) return false;
                if (n.interface && e[1] !== n.interface) return false;
                if (n.member && e[2] !== n.member) return false;
                if (n.arg0 && (!e[3] || e[3][0] !== n.arg0)) return false;
                return true;
            }
            function r(e, t) {
                N("dbus:", t);
                var r;
                try {
                    r = JSON.parse(t);
                } catch (e) {
                    console.warn("received invalid dbus json message:", e);
                }
                if (r === undefined) {
                    l.close({
                        problem: "protocol-error"
                    });
                    return;
                }
                var n, i;
                if (r.id !== undefined) n = d[r.id];
                if (r.reply) {
                    if (n) {
                        i = {};
                        if (r.type) i.type = r.type;
                        if (r.flags) i.flags = r.flags;
                        n.resolve(r.reply[0] || [], i);
                        delete d[r.id];
                    }
                    return;
                } else if (r.error) {
                    if (n) {
                        n.reject(new U(r.error));
                        delete d[r.id];
                    }
                    return;
                }
                /*
             * The above promise resolutions or failures are triggered via
             * later_invoke(). In order to preserve ordering guarantees we
             * also have to process other events that way too.
             */                L(function() {
                    var e, n;
                    if (r.signal) {
                        for (e in u) {
                            n = u[e];
                            if (n.callback) {
                                if (g(r.signal, n.match)) n.callback.apply(a, r.signal);
                            }
                        }
                    } else if (r.call) {
                        O(r.call, r.id);
                    } else if (r.notify) {
                        b(r.notify);
                    } else if (r.meta) {
                        w(r.meta);
                    } else if (r.owner !== undefined) {
                        a.dispatchEvent("owner", r.owner);
                        /*
                     * We won't get this signal with the same
                     * owner twice so if we've seen an owner
                     * before that means it has changed.
                     */                        if (s && f) a.close();
                        f = r.owner;
                    } else {
                        N("received unexpected dbus json message:", t);
                    }
                });
            }
            function w(e) {
                h();
                ae(v.meta, e);
                a.dispatchEvent("meta", e);
            }
            a.meta = function(e, n) {
                if (!l || !l.valid) return;
                var t = ae({}, n, {
                    meta: e
                });
                m(JSON.stringify(t));
                w(e);
            };
            function b(e) {
                h();
                var n, t, r;
                for (n in e) {
                    for (t in e[n]) {
                        r = e[n][t];
                        if (!r) v.remove(n, t); else v.update(n, t, r);
                    }
                }
                a.dispatchEvent("notify", e);
            }
            this.notify = b;
            function i(e) {
                p = e.problem || "disconnected";
                var n;
                var t = d;
                d = {};
                for (n in t) {
                    t[n].reject(new U(p, e.message));
                }
                a.dispatchEvent("close", e);
            }
            this.close = function e(n) {
                if (typeof n == "string") n = {
                    problem: n
                };
                if (!n) n = {};
                if (l) l.close(n); else i(n);
            };
            function y(e, n) {
                N("dbus ready:", t);
                a.unique_name = n["unique-name"];
            }
            function k(e, n) {
                N("dbus close:", n);
                l.removeEventListener("ready", y);
                l.removeEventListener("message", r);
                l.removeEventListener("close", k);
                l = null;
                i(n);
            }
            l.addEventListener("ready", y);
            l.addEventListener("message", r);
            l.addEventListener("close", k);
            var _ = 1;
            this.call = function e(n, t, r, i, o) {
                var a = X.defer();
                var s = String(_);
                _++;
                var f = ae({}, o, {
                    call: [ n, t, r, i || [] ],
                    id: s
                });
                var l = JSON.stringify(f);
                if (m(l)) d[s] = a; else a.reject(new U(p));
                return a.promise;
            };
            a.signal = function e(n, t, r, i, o) {
                if (!l || !l.valid) return;
                var a = ae({}, o, {
                    signal: [ n, t, r, i || [] ]
                });
                m(JSON.stringify(a));
            };
            this.subscribe = function e(n, t, r) {
                var i = {
                    match: ae({}, n),
                    callback: t
                };
                if (r !== false) m(JSON.stringify({
                    "add-match": i.match
                }));
                var o;
                if (t) {
                    o = String(_);
                    _++;
                    u[o] = i;
                }
                return {
                    remove: function() {
                        var e;
                        if (o) {
                            e = u[o];
                            if (e) delete u[o];
                        }
                        if (r !== false && e) m(JSON.stringify({
                            "remove-match": e.match
                        }));
                    }
                };
            };
            a.watch = function e(n) {
                var t;
                if (ie(n)) t = ae({}, n); else t = {
                    path: String(n)
                };
                var r = String(_);
                _++;
                var i = X.defer();
                var o = JSON.stringify({
                    watch: t,
                    id: r
                });
                if (m(o)) d[r] = i; else i.reject(new U(p));
                var a = i.promise;
                a.remove = function e() {
                    if (r in d) {
                        i.reject(new U("cancelled"));
                        delete d[r];
                    }
                    m(JSON.stringify({
                        unwatch: t
                    }));
                };
                return a;
            };
            function E(e, n) {
                var t = "DBus interface " + n + " not available at " + e;
                return X.reject(new U([ "org.freedesktop.DBus.Error.UnknownInterface", [ t ] ]));
            }
            function S(e, n, t) {
                var r = "DBus method " + n + " " + t + " not available at " + e;
                return X.reject(new U([ "org.freedesktop.DBus.Error.UnknownMethod", [ r ] ]));
            }
            function x(e, n, t) {
                console.warn("method is not implemented properly: ", e, n, t);
                return S(e, n, t);
            }
            function j(e) {
                var n = e[0];
                var t = e[1];
                var r = e[2];
                var i = c[n + "\n" + t];
                var o = v.meta[t];
                if (!i || !o) return E(n, t);
                if (!o.methods || !(r in o.methods)) return S(n, t, r);
                if (typeof i[r] != "function") return x(n, t, r);
                return i[r].apply(i, e[3]);
            }
            function O(e, t) {
                var n = j(e);
                if (!t) return;
 /* Discard result */                X.when(n).then(function() {
                    var e = Array.prototype.slice.call(arguments, 0);
                    if (e.length == 1 && typeof e[0] == "undefined") e = [];
                    m(JSON.stringify({
                        reply: [ e ],
                        id: t
                    }));
                }, function(e) {
                    var n = [];
                    n[0] = e.name || " org.freedesktop.DBus.Error.Failed";
                    n[1] = [ X.message(e) || n[0] ];
                    m(JSON.stringify({
                        error: n,
                        id: t
                    }));
                });
            }
            a.publish = function(e, n, t, r) {
                var i = [ e, n ];
                var o = String(_);
                _++;
                var a = d[o] = X.defer();
                var s = JSON.stringify(ae({}, r, {
                    publish: i,
                    id: o
                }));
                if (m(s)) d[o] = a; else a.reject(new U(p));
                var f = e + "\n" + n;
                a.promise.then(function() {
                    c[f] = t;
                });
                /* Return a way to remove this object */                var l = a.promise;
                l.remove = function e() {
                    if (o in d) {
                        a.reject(new U("cancelled"));
                        delete d[o];
                    }
                    delete c[f];
                    m(JSON.stringify({
                        unpublish: i
                    }));
                };
                return l;
            };
            a.proxy = function e(n, t, r) {
                if (!n) n = o;
                n = String(n);
                if (!t) t = "/" + n.replace(/\./g, "/");
                var i = a.constructors[n];
                if (!i) i = a.constructors["*"];
                if (!r) r = {};
                h();
                return new i(a, v, n, String(t), r);
            };
            a.proxies = function e(n, t, r) {
                if (!n) n = o;
                if (!t) t = "/";
                if (!r) r = {};
                h();
                return new P(a, v, String(n), String(t), r);
            };
        }
        /* Well known busses */        var q = {
            internal: null,
            session: null,
            system: null
        };
        /* public */        X.dbus = function e(n, t) {
            if (!t) t = {
                bus: "system"
            };
            /*
         * Figure out if this we should use a shared bus.
         *
         * This is only the case if a null name *and* the
         * options are just a simple { "bus": "xxxx" }
         */            var r = Object.keys(t);
            var i = t.bus;
            var o = !n && r.length == 1 && i in q;
            if (o && q[i]) return q[i];
            var a = new D(n, t);
            /*
         * Store the shared bus for next time. Override the
         * close function to only work when a problem is
         * indicated.
         */            var s;
            if (o) {
                a.close = function() {
                    if (arguments.length > 0) s.apply(a, arguments);
                };
                a.addEventListener("close", function() {
                    if (q[i] == a) q[i] = null;
                });
                q[i] = a;
            }
            return a;
        };
        X.variant = function e(n, t) {
            return {
                v: t,
                t: n
            };
        };
        X.byte_array = function e(n) {
            return window.btoa(n);
        };
        /* File access
     */        X.file = function e(u, n) {
            n = n || {};
            var s = n.binary;
            var t = {
                path: u,
                read: a,
                replace: h,
                modify: r,
                watch: y,
                close: k
            };
            var c = ae({}, n);
            delete c.syntax;
            function f(e) {
                if (n.syntax && n.syntax.parse) return n.syntax.parse(e); else return e;
            }
            function d(e) {
                if (n.syntax && n.syntax.stringify) return n.syntax.stringify(e); else return e;
            }
            var l = null;
            var v;
            function a() {
                if (l) return l;
                var o = X.defer();
                var e = ae({}, c, {
                    payload: "fsread1",
                    path: u
                });
                function a() {
                    v = X.channel(e);
                    var i = [];
                    v.addEventListener("message", function(e, n) {
                        i.push(n);
                    });
                    v.addEventListener("close", function(e, n) {
                        v = null;
                        if (n.problem == "change-conflict") {
                            a();
                            return;
                        }
                        l = null;
                        if (n.problem) {
                            var t = new j(n.problem, n.message);
                            b(null, null, t);
                            o.reject(t);
                            return;
                        }
                        var r;
                        if (n.tag == "-") r = null; else {
                            try {
                                r = f(Se(i, s));
                            } catch (e) {
                                b(null, null, e);
                                o.reject(e);
                                return;
                            }
                        }
                        b(r, n.tag);
                        o.resolve(r, n.tag);
                    });
                }
                a();
                l = o.promise;
                return l;
            }
            var p = null;
            function h(t, e) {
                var r = X.defer();
                var n;
                try {
                    if (t === null) n = null; else n = d(t);
                } catch (e) {
                    r.reject(e);
                    return r.promise;
                }
                if (p) p.close("abort");
                var i = ae({}, c, {
                    payload: "fsreplace1",
                    path: u,
                    tag: e
                });
                p = X.channel(i);
                p.addEventListener("close", function(e, n) {
                    p = null;
                    if (n.problem) {
                        r.reject(new j(n.problem, n.message));
                    } else {
                        b(t, n.tag);
                        r.resolve(n.tag);
                    }
                });
                var o = 0;
                var a = false;
                if (n) {
                    if (n.byteLength) {
                        o = n.byteLength;
                        a = true;
                    } else if (n.length) {
                        o = n.length;
                    }
                }
                var s, f;
                var l = 16 * 1024;
                for (s = 0; s < o; s += l) {
                    f = Math.min(o - s, l);
                    if (a) p.send(new window.Uint8Array(n.buffer, s, f)); else p.send(n.substr(s, f));
                }
                p.control({
                    command: "done"
                });
                return r.promise;
            }
            function r(r, e, n) {
                var i = X.defer();
                function t(e, n) {
                    var t = r(e);
                    if (t === undefined) t = e;
                    h(t, n).done(function(e) {
                        i.resolve(t, e);
                    }).fail(function(e) {
                        if (e.problem == "change-conflict") o(); else i.reject(e);
                    });
                }
                function o() {
                    a().done(t).fail(function(e) {
                        i.reject(e);
                    });
                }
                if (e === undefined) o(); else t(e, n);
                return i.promise;
            }
            var i = [];
            var o = 0;
            var m = null;
            var g;
            function w() {
                if (o > 0) {
                    if (m) return;
                    var e = ae({}, c, {
                        payload: "fswatch1",
                        path: u
                    });
                    m = X.channel(e);
                    m.addEventListener("message", function(e, n) {
                        var t;
                        try {
                            t = JSON.parse(n);
                        } catch (e) {
                            t = null;
                        }
                        if (t && t.path == u && t.tag && t.tag != g) a();
                    });
                } else {
                    if (m) {
                        m.close();
                        m = null;
                    }
                }
            }
            function b() {
                g = arguments[1] || null;
                se(i, t, arguments);
            }
            function y(n) {
                if (n) i.push(n);
                o += 1;
                w();
                g = null;
                a();
                return {
                    remove: function() {
                        var e;
                        if (n) {
                            e = i.indexOf(n);
                            if (e > -1) i[e] = null;
                        }
                        o -= 1;
                        w();
                    }
                };
            }
            function k() {
                if (v) v.close("cancelled");
                if (p) p.close("cancelled");
                if (m) m.close("cancelled");
            }
            return t;
        };
        /* ---------------------------------------------------------------------
     * Localization
     */        var R = {};
        var $;
        X.language = undefined;
        X.locale = function e(n) {
            var t = X.language || "en";
            var r;
            if (n) {
                ae(R, n);
                r = n[""];
            } else if (n === null) {
                R = {};
            }
            if (r) {
                if (r["plural-forms"]) $ = r["plural-forms"];
                if (r.language) t = r.language;
            }
            X.language = t;
        };
        X.translate = function e() {
            var n;
            /* Called without arguments, entire document */            if (arguments.length === 0) n = [ document ];
            /* Called with a single array like argument */ else if (arguments.length === 1 && arguments[0].length) n = arguments[0];
            /* Called with 1 or more element arguments */ else n = arguments;
            /* Translate all the things */            var t, r, i, o, a, s, f, l, u, c;
            for (t = 0, r = n.length; t < r; t++) {
                /* The list of things to translate */
                l = null;
                if (n[t].querySelectorAll) l = n[t].querySelectorAll("[translatable], [translate]");
                if (!l) continue;
                /* Each element */                for (o = 0, a = l.length; o < a; o++) {
                    c = l[o];
                    i = c.getAttribute("translate") || c.getAttribute("translatable") || "yes";
                    if (i == "no") continue;
                    /* Each thing to translate */                    u = i.split(" ");
                    i = c.getAttribute("translate-context") || c.getAttribute("context");
                    for (s = 0, f = u.length; s < f; s++) {
                        if (u[s] == "yes" || u[s] == "translate") c.textContent = X.gettext(i, c.textContent); else if (u[s]) c.setAttribute(u[s], X.gettext(i, c.getAttribute(u[s]) || ""));
                    }
                    /* Mark this thing as translated */                    c.removeAttribute("translatable");
                    c.removeAttribute("translate");
                }
            }
        };
        X.gettext = function e(n, t) {
            /* Missing first parameter */
            if (arguments.length == 1) {
                t = n;
                n = undefined;
            }
            var r = n ? n + "" + t : t;
            if (R) {
                var i = R[r];
                if (i && i[1]) return i[1];
            }
            return t;
        };
        function G(e) {
            return e === true ? 1 : e || 0;
        }
        X.ngettext = function e(n, t, r, i) {
            /* Missing first parameter */
            if (arguments.length == 3) {
                i = r;
                r = t;
                t = n;
                n = undefined;
            }
            var o = n ? n + "" + t : t;
            if (R && $) {
                var a = R[o];
                if (a) {
                    var s = G($(i)) + 1;
                    if (a[s]) return a[s];
                }
            }
            if (i == 1) return t;
            return r;
        };
        X.noop = function e(n, t) {
            return arguments[arguments.length - 1];
        };
        /* Only for _() calls here in the cockpit code */        var H = X.gettext;
        X.message = function e(n) {
            if (n.message) return n.message;
            var t = null;
            if (n.problem) t = n.problem; else t = n + "";
            if (t == "terminated") return H("Your session has been terminated."); else if (t == "no-session") return H("Your session has expired. Please log in again."); else if (t == "access-denied") return H("Not permitted to perform this action."); else if (t == "authentication-failed") return H("Login failed"); else if (t == "authentication-not-supported") return H("The server refused to authenticate using any supported methods."); else if (t == "unknown-hostkey") return H("Untrusted host"); else if (t == "unknown-host") return H("Untrusted host"); else if (t == "invalid-hostkey") return H("Host key is incorrect"); else if (t == "internal-error") return H("Internal error"); else if (t == "timeout") return H("Connection has timed out."); else if (t == "no-cockpit") return H("Cockpit is not installed on the system."); else if (t == "no-forwarding") return H("Cannot forward login credentials"); else if (t == "disconnected") return H("Server has closed the connection."); else if (t == "not-supported") return H("Cockpit is not compatible with the software on the system."); else if (t == "no-host") return H("Cockpit could not contact the given host."); else if (t == "too-large") return H("Too much data"); else return t;
        };
        function K(e, n, t) {
            this.status = parseInt(e, 10);
            this.reason = n;
            this.message = t || n;
            this.problem = null;
            this.valueOf = function() {
                return this.status;
            };
            this.toString = function() {
                return this.status + " " + this.message;
            };
        }
        function z() {
            if (window.debugging == "all" || window.debugging == "http") console.debug.apply(console, arguments);
        }
        function W(e, n) {
            if (!e) return undefined;
            n = n.toLowerCase();
            for (var t in e) {
                if (t.toLowerCase() == n) return e[t];
            }
            return undefined;
        }
        function V(e, v) {
            var i = this;
            i.options = v;
            v.payload = "http-stream2";
            var p = [];
            if (e !== undefined) {
                if (e.indexOf && e.indexOf("/") === 0) {
                    v.unix = e;
                } else {
                    var n = parseInt(e, 10);
                    if (!isNaN(n)) v.port = n; else throw Error("The endpoint must be either a unix path or port number");
                }
            }
            if (v.address) {
                if (!v.capabilities) v.capabilities = [];
                v.capabilities.push("address");
            }
            function h(n) {
                return Object.keys(n).map(function(e) {
                    return encodeURIComponent(e) + "=" + encodeURIComponent(n[e]);
                }).join("&").split("%20").join("+");
 /* split/join because phantomjs */            }
            i.request = function e(n) {
                var a = X.defer();
                var s = a.promise;
                if (!n.path) n.path = "/";
                if (!n.method) n.method = "GET";
                if (n.params) {
                    if (n.path.indexOf("?") === -1) n.path += "?" + h(n.params); else n.path += "&" + h(n.params);
                }
                delete n.params;
                var t = n.body;
                delete n.body;
                var r = n.headers;
                delete n.headers;
                ae(n, v);
                /* Combine the headers */                if (v.headers && r) n.headers = ae({}, v.headers, r); else if (v.headers) n.headers = v.headers; else n.headers = r;
                z("http request:", JSON.stringify(n));
                /* We need a channel for the request */                var f = X.channel(n);
                if (t !== undefined) {
                    if (t !== "") {
                        z("http input:", t);
                        f.send(t);
                    }
                    z("http done");
                    f.control({
                        command: "done"
                    });
                }
                /* Callbacks that want to stream or get headers */                var i = null;
                var o = null;
                var l = null;
                var u = f.buffer(function(e) {
                    /* Fire any streamers */
                    if (l && l.status >= 200 && l.status <= 299 && i) return i.call(s, e);
                    return 0;
                });
                function c(e, n) {
                    /* Anyone looking for response details? */
                    if (n.command == "response") {
                        l = n;
                        if (o) {
                            l.headers = l.headers || {};
                            se(o, s, [ l.status, l.headers ]);
                        }
                    }
                }
                function d(e, n) {
                    var t = p.indexOf(s);
                    if (t >= 0) p.splice(t, 1);
                    if (n.problem) {
                        z("http problem: ", n.problem);
                        a.reject(new j(n.problem));
                    } else {
                        var r = u.squash();
                        /* An error, fail here */                        if (l && (l.status < 200 || l.status > 299)) {
                            var i;
                            var o = W(l.headers, "Content-Type");
                            if (o && !f.binary) {
                                if (o.indexOf("text/plain") === 0) i = r;
                            }
                            z("http status: ", l.status);
                            a.reject(new K(l.status, l.reason, i), r);
                        } else {
                            z("http done");
                            a.resolve(r);
                        }
                    }
                    f.removeEventListener("control", c);
                    f.removeEventListener("close", d);
                }
                f.addEventListener("control", c);
                f.addEventListener("close", d);
                s.stream = function(e) {
                    i = e;
                    return s;
                };
                s.response = function(e) {
                    if (o === null) o = [];
                    o.push(e);
                    return s;
                };
                s.input = function(e, n) {
                    if (e !== null && e !== undefined) {
                        z("http input:", e);
                        f.send(e);
                    }
                    if (!n) {
                        z("http done");
                        f.control({
                            command: "done"
                        });
                    }
                    return s;
                };
                s.close = function(e) {
                    z("http closing:", e);
                    f.close(e);
                    return s;
                };
                p.push(s);
                return s;
            };
            i.get = function e(n, t, r) {
                return i.request({
                    method: "GET",
                    params: t,
                    path: n,
                    body: "",
                    headers: r
                });
            };
            i.post = function e(n, t, r) {
                r = r || {};
                if (ie(t) || ne(t)) {
                    t = JSON.stringify(t);
                    if (W(r, "Content-Type") === undefined) r["Content-Type"] = "application/json";
                } else if (t === undefined || t === null) {
                    t = "";
                } else if (typeof t !== "string") {
                    t = String(t);
                }
                return i.request({
                    method: "POST",
                    path: n,
                    body: t,
                    headers: r
                });
            };
            i.close = function e(n) {
                var t = p.slice();
                for (var r = 0; r < t.length; r++) t[r].close(n);
            };
        }
        /* public */        X.http = function(e, n) {
            if (ie(e) && n === undefined) {
                n = e;
                e = undefined;
            }
            return new V(e, n || {});
        };
        /* ---------------------------------------------------------------------
     * Permission
     */        function Z() {
            var e = X.defer();
            var n = X.channel({
                payload: "null",
                superuser: "require"
            });
            n.wait().then(function() {
                e.resolve(true);
            }).fail(function() {
                e.resolve(false);
            }).always(function() {
                n.close();
            });
            return e.promise();
        }
        function F(e) {
            var r = this;
            ke(r, {});
            r.allowed = null;
            r.user = e ? e.user : null;
 // pre-fill for unit tests
                        r.is_superuser = e ? e._is_superuser : null;
 // pre-fill for unit tests
                        var n = null;
            var t = false;
            if (e) n = e.group;
            if (e && e.admin) t = true;
            function i(e) {
                if (e.id === 0) return true;
                if (n) return !!(e.groups || []).includes(n);
                if (t) return r.is_superuser;
                if (e.id === undefined) return null;
                return false;
            }
            if (r.user && r.is_superuser !== null) {
                r.allowed = i(r.user);
            } else {
                // eslint-disable-next-line cockpit/no-cockpit-all
                X.all(X.user(), Z()).done(function(e, n) {
                    r.user = e;
                    r.is_superuser = n;
                    var t = i(e);
                    if (r.allowed !== t) {
                        r.allowed = t;
                        r.dispatchEvent("changed");
                    }
                });
            }
            r.close = function e() {
                /* no-op for now */};
        }
        X.permission = function e(n) {
            return new F(n);
        };
        /* ---------------------------------------------------------------------
     * Metrics
     *
     */        function Y(b, s, e) {
            var y = this;
            ke(y, {});
            if (s.length === undefined) s = [ s ];
            var i = [];
            var r = false;
            y.series = X.series(b, e, n);
            y.archives = null;
            y.meta = null;
            function n(e, n, t) {
                if (!t) y.fetch(e, n); else y.follow();
            }
            function f(p, h, t) {
                if (p.length === 0) return;
                if (!t) {
                    if (r) return;
                    r = true;
                }
                var e = ae({
                    payload: "metrics1",
                    interval: b,
                    source: "internal"
                }, p[0]);
                delete e.archive_source;
                var n = X.channel(e);
                i.push(n);
                var m = null;
                var g = null;
                var w;
                n.addEventListener("close", function(e, n) {
                    if (!t) r = false;
                    if (p.length > 1 && (n.problem == "not-supported" || n.problem == "not-found")) {
                        f(p.slice(1), h);
                    } else if (n.problem) {
                        if (n.problem != "terminated" && n.problem != "disconnected" && n.problem != "authentication-failed" && (n.problem != "not-found" || !t) && (n.problem != "not-supported" || !t)) {
                            console.warn("metrics channel failed: " + n.problem);
                        }
                    } else if (t) {
                        if (!y.archives) {
                            y.archives = true;
                            y.dispatchEvent("changed");
                        }
                    }
                });
                n.addEventListener("message", function(e, n) {
                    var t = JSON.parse(n);
                    var r, i, o, a, s, f;
                    var l, u, c;
                    var d;
                    /* A meta message? */                    var v = t.length;
                    if (v === undefined) {
                        m = t;
                        d = 0;
                        if (m.now && m.timestamp) d = m.timestamp + (Date.now() - m.now);
                        w = Math.floor(d / b);
                        h(w, m, null, p[0]);
                        /* Trigger to outside interest that meta changed */                        y.meta = m;
                        y.dispatchEvent("changed");
                        /* A data message */                    } else if (m) {
                        /* Data decompression */
                        for (l = 0; l < v; l++) {
                            r = t[l];
                            if (g) {
                                i = g.length;
                                for (u = 0; u < i; u++) {
                                    o = r[u];
                                    if (o === null || o === undefined) {
                                        r[u] = g[u];
                                    } else {
                                        a = o.length;
                                        if (a !== undefined) {
                                            s = g[u];
                                            f = g[u].length;
                                            for (c = 0; c < a; c++) {
                                                if (o[c] === null) o[c] = s[c];
                                            }
                                            for (;c < f; c++) o[c] = s[c];
                                        }
                                    }
                                }
                            }
                            g = r;
                        }
                        /* Return the data */                        h(w, m, t, p[0]);
                        /* Bump timestamp for the next message */                        w += v;
                        m.timestamp += b * v;
                    }
                });
            }
            function l(e, n, t, r) {
                var i, o, a;
                /* Generate a mapping object if necessary */                i = n.mapping;
                if (!i) {
                    i = {};
                    n.metrics.forEach(function(e, n) {
                        o = {
                            "": n
                        };
                        if (r.metrics_path_names) a = r.metrics_path_names[n]; else a = e.name;
                        i[a] = o;
                        if (e.instances) {
                            e.instances.forEach(function(e, n) {
                                if (e === "") e = "/";
                                o[e] = {
                                    "": n
                                };
                            });
                        }
                    });
                    n.mapping = i;
                }
                if (t) y.series.input(e, t, i);
            }
            y.fetch = function e(n, t) {
                var r = n * b - Date.now();
                var i = t - n;
                var o = [];
                for (var a = 0; a < s.length; a++) {
                    if (s[a].archive_source) {
                        o.push(ae({}, s[a], {
                            source: s[a].archive_source,
                            timestamp: r,
                            limit: i
                        }));
                    }
                }
                f(o, l, true);
            };
            y.follow = function e() {
                f(s, l);
            };
            y.close = function e(n) {
                var t;
                var r = i.length;
                if (y.series) y.series.close();
                for (t = 0; t < r; t++) i[t].close(n);
            };
        }
        X.metrics = function e(n, t) {
            return new Y(n, t);
        };
        /* ---------------------------------------------------------------------
     * Ooops handling.
     *
     * If we're embedded, send oops to parent frame. Since everything
     * could be broken at this point, just do it manually, without
     * involving cockpit.transport or any of that logic.
     */        X.oops = function e() {
            if (window.parent !== window && window.name.indexOf("cockpit1:") === 0) window.parent.postMessage('\n{ "command": "oops" }', me);
        };
        var Q = window.onerror;
        window.onerror = function(e, n, t) {
            X.oops();
            if (Q) return Q(e, n, t);
            return false;
        };
        return X;
    }
 /* scope end */
    /*
 * Register this script as a module and/or with globals
 */    var n;
    /* Check how we're being loaded */    var r = document.scripts[document.scripts.length - 1].src || "";
    var i = r.indexOf("/cockpit.js");
    if (i === -1) i = r.indexOf("/cockpit.min.js");
    if (i !== -1) i = r.substring(0, i).lastIndexOf("/");
    /* cockpit.js is being loaded as a <script>  and no other loader around? */    if (i !== -1) {
        n = r.substring(i + 1, r.indexOf(".", i + 1));
        window.cockpit = e();
    }
    /* Cockpit loaded via AMD loader */    if (te(window.define) && window.define.amd) {
        if (n) define(n, [], window.cockpit); // eslint-disable-line no-undef
         else define([], e);
 // eslint-disable-line no-undef
        }
})();
//# sourceMappingURL=cockpit.min.js.map