'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _LoginCardInput = require('./LoginCardInput');

var _LoginCardInput2 = _interopRequireDefault(_LoginCardInput);

var _LoginCardSettings = require('./LoginCardSettings');

var _LoginCardSettings2 = _interopRequireDefault(_LoginCardSettings);

var _LoginCardSubmitButton = require('./LoginCardSubmitButton');

var _LoginCardSubmitButton2 = _interopRequireDefault(_LoginCardSubmitButton);

var _LoginFormError = require('./LoginFormError');

var _LoginFormError2 = _interopRequireDefault(_LoginFormError);

var _index = require('../../../../index');

var _helpers = require('../../../../common/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LoginCardForm = function LoginCardForm(_ref) {
  var usernameField = _ref.usernameField,
      passwordField = _ref.passwordField,
      additionalFields = _ref.additionalFields,
      submitText = _ref.submitText,
      disableSubmit = _ref.disableSubmit,
      onSubmit = _ref.onSubmit,
      forgotPassword = _ref.forgotPassword,
      rememberMe = _ref.rememberMe,
      submitError = _ref.submitError,
      showError = _ref.showError,
      attributes = _ref.attributes,
      isSubmitting = _ref.isSubmitting;
  return _react2.default.createElement(
    _index.Form,
    _extends({ onSubmit: onSubmit, noValidate: true }, attributes),
    _react2.default.createElement(
      _LoginFormError2.default,
      { show: showError },
      submitError
    ),
    _react2.default.createElement(_LoginCardInput2.default, usernameField),
    _react2.default.createElement(_LoginCardInput2.default, passwordField),
    additionalFields,
    _react2.default.createElement(_LoginCardSettings2.default, { rememberMe: rememberMe, forgotPassword: forgotPassword }),
    _react2.default.createElement(
      _LoginCardSubmitButton2.default,
      { isDisabled: disableSubmit, isLoading: isSubmitting },
      submitText
    )
  );
};

LoginCardForm.propTypes = {
  usernameField: _propTypes2.default.shape(_extends({}, _LoginCardInput2.default.propTypes)),
  passwordField: _propTypes2.default.shape(_extends({}, _LoginCardInput2.default.propTypes)),
  additionalFields: _propTypes2.default.node,
  submitText: _propTypes2.default.string,
  disableSubmit: _propTypes2.default.bool,
  onSubmit: _propTypes2.default.func,
  forgotPassword: _propTypes2.default.object,
  rememberMe: _propTypes2.default.object,
  submitError: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.node]),
  showError: _propTypes2.default.bool,
  attributes: _propTypes2.default.object,
  isSubmitting: _propTypes2.default.bool
};

LoginCardForm.defaultProps = {
  usernameField: _extends({}, _LoginCardInput2.default.defaultProps, {
    id: 'card_email',
    type: 'email',
    placeholder: 'Email Address'
  }),
  passwordField: _extends({}, _LoginCardInput2.default.defaultProps, {
    id: 'card_password',
    type: 'password',
    placeholder: 'Password',
    minLength: 8
  }),
  additionalFields: null,
  submitText: null,
  disableSubmit: false,
  onSubmit: _helpers.noop,
  forgotPassword: {
    label: null,
    href: '#',
    onClick: _helpers.noop
  },
  rememberMe: { label: null },
  submitError: null,
  showError: false,
  attributes: null,
  isSubmitting: false
};

exports.default = LoginCardForm;