"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _SafeAnchor = _interopRequireDefault(require("./SafeAnchor"));

var _createChainedFunction = _interopRequireDefault(require("./utils/createChainedFunction"));

var propTypes = {
  disabled: _propTypes.default.bool,
  previous: _propTypes.default.bool,
  next: _propTypes.default.bool,
  onClick: _propTypes.default.func,
  onSelect: _propTypes.default.func,
  eventKey: _propTypes.default.any
};
var defaultProps = {
  disabled: false,
  previous: false,
  next: false
};

var PagerItem =
/*#__PURE__*/
function (_React$Component) {
  (0, _inheritsLoose2.default)(PagerItem, _React$Component);

  function PagerItem(props, context) {
    var _this;

    _this = _React$Component.call(this, props, context) || this;
    _this.handleSelect = _this.handleSelect.bind((0, _assertThisInitialized2.default)(_this));
    return _this;
  }

  var _proto = PagerItem.prototype;

  _proto.handleSelect = function handleSelect(e) {
    var _props = this.props,
        disabled = _props.disabled,
        onSelect = _props.onSelect,
        eventKey = _props.eventKey;

    if (disabled) {
      e.preventDefault();
      return;
    }

    if (onSelect) {
      onSelect(eventKey, e);
    }
  };

  _proto.render = function render() {
    var _props2 = this.props,
        disabled = _props2.disabled,
        previous = _props2.previous,
        next = _props2.next,
        onClick = _props2.onClick,
        className = _props2.className,
        style = _props2.style,
        props = (0, _objectWithoutProperties2.default)(_props2, ["disabled", "previous", "next", "onClick", "className", "style"]);
    delete props.onSelect;
    delete props.eventKey;
    return _react.default.createElement("li", {
      className: (0, _classnames.default)(className, {
        disabled: disabled,
        previous: previous,
        next: next
      }),
      style: style
    }, _react.default.createElement(_SafeAnchor.default, (0, _extends2.default)({}, props, {
      disabled: disabled,
      onClick: (0, _createChainedFunction.default)(onClick, this.handleSelect)
    })));
  };

  return PagerItem;
}(_react.default.Component);

PagerItem.propTypes = propTypes;
PagerItem.defaultProps = defaultProps;
var _default = PagerItem;
exports.default = _default;
module.exports = exports["default"];