!function(e) {
    function t(a) {
        if (n[a]) return n[a].exports;
        var i = n[a] = {
            exports: {},
            id: a,
            loaded: !1
        };
        return e[a].call(i.exports, i, i.exports, t), i.loaded = !0, i.exports;
    }
    var n = {};
    return t.m = e, t.c = n, t.p = "", t(0);
}([ function(e, t, n) {
    "use strict";
    function a(e) {
        function t(e, t, i, s) {
            r.test(e, function() {
                a.expect(t), n([ "kubeLoader", function(e) {
                    e.reset(!0), i && e.handle(i);
                } ]), n(s);
            });
        }
        var n, a = r, s = i.module("registry.images.tests", [ "kubeClient", "registry.images" ]);
        t("filter containsTagImage", 7, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().containsTagImage("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.equal(n.length, 2, "number ofstreams"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n, "matched busybee"), 
            a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "matched juggs"), 
            n = e().containsTagImage("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.equal(n.length, 1, "one stream matched"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "other stream matched juggs"), 
            a.ok(!("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n), "other stream not busybee"), 
            n = e().containsTagImage("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.equal(n.length, 0, "no streams selected");
        } ]), t("filter taggedBy", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, i = e().kind("Image").taggedBy(n);
            a.equal(i.length, 2, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in i, "matched busybee"), 
            a.ok("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in i, "matched juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, i = e().kind("Image").taggedBy(n), a.equal(i.length, 0, "no images matched");
        } ]), t("filter taggedFirst", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, i = e().kind("Image").taggedFirst(n);
            a.equal(i.length, 1, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in i, "matched busybee"), 
            a.ok(!("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in i), "didn't match juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, i = e().kind("Image").taggedFirst(n), a.equal(i.length, 0, "no images matched");
        } ]), t("filter listTagNames", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().listTagNames("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.deepEqual(n, [ "marmalade/busybee:latest", "marmalade/juggs:extratag" ], "got right names"), 
            n = e().listTagNames("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.deepEqual(n, [ "marmalade/juggs:latest" ], "got another image tag name"), n = e().listTagNames("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.deepEqual(n, [], "no names returned");
        } ]), t("split dockerImageManifest", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("DockerImageManifest").name("sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7");
            a.equal(n.length, 1, "only manifest returned");
            var i = n["/internal/manifests/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.ok(!!i, "got right manifest"), a.equal(i.manifest.history[0].v1Compatibility.config.Hostname, "13709f13afe1", "parsed manifest and compat");
        } ]), t("filter dockerConfigLabels", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.equal(n.length, 1, "got one set of labels");
            var i = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.strictEqual(n, i, "cached results");
            var r = n["/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.deepEqual(r, {
                Test: "Value",
                version: "1.0"
            }, "got right labels");
        } ]), i.module("exceptionOverride", []).factory("$exceptionHandler", function() {
            return function(e, t) {
                throw e.message += ' (caused by "' + t + '")', e;
            };
        }), s.run([ "$injector", function(e) {
            n = function(t) {
                return e.invoke(t);
            }, r.start();
        } ]), i.bootstrap(document, [ "registry.images.tests" ]);
    }
    var i = n(32), r = n(246);
    n(235), a([ {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "busybee",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/busybee",
            uid: "4612c052-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/busybee",
            tags: [ {
                tag: "0.x",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "juggs",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/juggs",
            uid: "84e3a672-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/juggs",
            tags: [ {
                tag: "2.11",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
                    image: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
                } ]
            }, {
                tag: "2.5",
                items: [ {
                    created: "2016-01-06T08:21:46Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe",
                    image: "sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, {
                tag: "extratag",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "origin",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/origin",
            uid: "94813e0a-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/origin",
            tags: [ {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:22:10Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
                    image: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
                } ]
            } ]
        }
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
            selfLink: "/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
            selfLink: "/oapi/v1/images/sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
            selfLink: "/oapi/v1/images/sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
            selfLink: "/oapi/v1/images/sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
            selfLink: "/oapi/v1/images/sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
            selfLink: "/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
            selfLink: "/oapi/v1/images/sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            selfLink: "/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            annotations: {
                "openshift.io/image.managed": "true"
            }
        },
        dockerImageReference: "172.30.198.253:5000/marmalade/juggs@sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d",
            Parent: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
            Created: "2016-03-04T16:50:11Z",
            Container: "7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d",
            ContainerConfig: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "/bin/sh", "-c", "#(nop) LABEL version=1.0" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            DockerVersion: "1.9.1",
            Config: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "-c" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            Architecture: "amd64",
            Size: 126388696
        },
        dockerImageMetadataVersion: "1.0",
        dockerImageManifest: '{\n   "schemaVersion": 1,\n   "name": "marmalade/juggs",\n   "tag": "2.8",\n   "architecture": "amd64",\n   "fsLayers": [\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:74fc2669b7664c1705ea18d946fb92111a2904fdc69c24dc25db546923663c4b"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:8cbbdaf3178f15e3e23f5eb59c754d16511edf100ba0e57557e47c8a5924d422"\n      },\n      {\n         "blobSum": "sha256:bc66c3b5709234727e260b55c5553c2bf9608084419271b08bca484914624d84"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:f810322bba2c5f0a6dd58ba31eba0543baabb4533e479ab2db376aaa8064be55"\n      }\n   ],\n   "history": [\n      {\n         "v1Compatibility": "{\\"id\\":\\"fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d\\",\\"parent\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"created\\":\\"2016-03-04T16:50:11.993242911Z\\",\\"container\\":\\"7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL version=1.0\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"parent\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"created\\":\\"2016-03-04T16:50:06.235447946Z\\",\\"container\\":\\"a13a641996f5d0425de27a7fd80d30174e165acd7bf913432f899ab2f57e0154\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL Test=Value\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"parent\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"created\\":\\"2016-03-04T16:50:00.89289203Z\\",\\"container\\":\\"2a9474018a32f776c8470897e6600b6a62503a734ae2775a5fbedd9ba9b28307\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG simple\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"parent\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"created\\":\\"2016-03-04T16:49:55.64958347Z\\",\\"container\\":\\"6fc564cbd8a2f53f81e1be0cf8b2752448c9b51d69787706bd1a40efc4b53870\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG hello=test\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"parent\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"created\\":\\"2016-03-04T16:49:50.274796262Z\\",\\"container\\":\\"90360222ef8c7a4978c0a27542d78175b16cf1b559ea3a0c344c21d6596f8878\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ONBUILD ADD . /app/src\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"parent\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"created\\":\\"2016-03-04T16:49:43.316816134Z\\",\\"container\\":\\"ada3ba6c28f4d40ad447384f990d4a2075abf86b821cbd5b1f3b339aae2bda7b\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) STOPSIGNAL [SIGKILL]\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"parent\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"created\\":\\"2016-03-04T16:49:36.966840962Z\\",\\"container\\":\\"75a79bb684c3ff1a8b9bccd1f046e87f84b9da4722b8b45853602f0a69f4cb27\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"-c\\\\\\"]\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"parent\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"created\\":\\"2016-03-04T16:49:32.056781057Z\\",\\"container\\":\\"076b707ed7bf04602d56b714deb3270998c5b145520b925fc9d8029b28e1484e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ENTRYPOINT \\\\u0026{[\\\\\\"top\\\\\\" \\\\\\"-b\\\\\\"]}\\"],\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":null,\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"parent\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"created\\":\\"2016-03-04T16:49:27.230310779Z\\",\\"container\\":\\"b1fff8a998363845efbbc77e64e58a2ef8cd422896a40816fe5016a0d66c8804\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) USER [nobody:wheel]\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"parent\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"created\\":\\"2016-03-04T16:49:19.278707045Z\\",\\"container\\":\\"a9ec15a2ac6c962d3f7141f789e0a703f68b1b35386b226485a470fdc297c921\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:32d397773a81df8feb5d5baf04619f65e2a1e4fddf24bbceb85157ff7f0db752 in /usr/bin\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":125275044}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"parent\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"created\\":\\"2016-03-04T16:48:53.085321054Z\\",\\"container\\":\\"7749a20ab52bd8714b5cc2823d3c09767f574b8f2d4bd4393b37f0a4964f3376\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"/bin/sh\\\\\\" \\\\\\"-c\\\\\\" \\\\\\"\\\\\\\\\\\\\\"/echo-script\\\\\\\\\\\\\\"\\\\\\"]\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"parent\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"created\\":\\"2016-03-04T16:48:47.790555865Z\\",\\"container\\":\\"ab835892b5519c2d0ffd84e22fe3d971a4a80d9d3e31757c7dce5379b947887e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"chmod +x /echo-script\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"parent\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"created\\":\\"2016-03-04T16:48:42.037533681Z\\",\\"container\\":\\"e16228a90ccf6d29c214833ba202b94b467979f5db03797d0a27da8430509966\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:b35fc316562d0e29fa7ae1e767f3597811f4349e30aa74122b67965a103f817a in /\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"parent\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"created\\":\\"2016-03-04T16:48:36.879318282Z\\",\\"container\\":\\"a759048c873ac86cef61a9aec0ac72734cfe53feb7acd81a2b4975473675ed20\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) EXPOSE 8888/tcp\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"parent\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"created\\":\\"2016-03-04T16:48:31.254943299Z\\",\\"container\\":\\"0484d0202032d11f48613463684f344ddc4f238635dcb640774e00828251f57d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) MAINTAINER cockpit@example.com\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"parent\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:37.407805421Z\\",\\"container\\":\\"d23509cd0189de02bef382544ebfab515f29094f3c0e2f161fa7ce09afa8974e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"sh\\\\\\"]\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:36.792440427Z\\",\\"container\\":\\"13709f13afe11b7d4a007d2866afd20c5b783f0a89f4e6792a28102a4c12c473\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:7cdf7a89f6a004b2e9501317bd72bd863d93a51255d8f83b2ed3058d385a4938 in /\\"],\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":null,\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":1113554}"\n      }\n   ],\n   "signatures": [\n      {\n         "header": {\n            "jwk": {\n               "crv": "P-256",\n               "kid": "VQO7:TVYU:FARI:VIFC:P2YU:W23P:AC7V:7ZXR:I5RO:DTY4:NRES:MGXE",\n               "kty": "EC",\n               "x": "EsCEZHIfgzZDBsbCzgCng884FdTcwyQ8dZbhap2cpgo",\n               "y": "9Hlp74n2G2aMwzyvvM9G-8BbrXDp2dl9rt2RGbidQ8I"\n            },\n            "alg": "ES256"\n         },\n         "signature": "MFqsTUp-ci7Th-1r02bHj8eDh5xRg_WtjpN7WD4dI2Tuvg96fyGH6rf5bYKIjEVKz1_3Z42Ma06DDw8hSsMOGw",\n         "protected": "eyJmb3JtYXRMZW5ndGgiOjI3NjU1LCJmb3JtYXRUYWlsIjoiQ24wIiwidGltZSI6IjIwMTYtMDMtMDRUMTY6NTA6MzJaIn0"\n      }\n   ]\n}'
    } ]);
}, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    /**
	 * @license AngularJS v1.3.14
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a(e, t) {
            return t = t || Error, function() {
                var n, a, i = arguments[0], r = "[" + (e ? e + ":" : "") + i + "] ", s = arguments[1], o = arguments;
                for (n = r + s.replace(/\{\d+\}/g, function(e) {
                    var t = +e.slice(1, -1);
                    return t + 2 < o.length ? fe(o[t + 2]) : e;
                }), n = n + "\nhttp://errors.angularjs.org/1.3.14/" + (e ? e + "/" : "") + i, a = 2; a < arguments.length; a++) n = n + (2 == a ? "?" : "&") + "p" + (a - 2) + "=" + encodeURIComponent(fe(arguments[a]));
                return new t(n);
            };
        }
        function i(e) {
            if (null == e || L(e)) return !1;
            var t = e.length;
            return !(e.nodeType !== _a || !t) || (y(e) || ca(e) || 0 === t || "number" == typeof t && t > 0 && t - 1 in e);
        }
        function r(e, t, n) {
            var a, s;
            if (e) if (k(e)) for (a in e) "prototype" == a || "length" == a || "name" == a || e.hasOwnProperty && !e.hasOwnProperty(a) || t.call(n, e[a], a, e); else if (ca(e) || i(e)) {
                var o = "object" != typeof e;
                for (a = 0, s = e.length; a < s; a++) (o || a in e) && t.call(n, e[a], a, e);
            } else if (e.forEach && e.forEach !== r) e.forEach(t, n, e); else for (a in e) e.hasOwnProperty(a) && t.call(n, e[a], a, e);
            return e;
        }
        function s(e) {
            return Object.keys(e).sort();
        }
        function o(e, t, n) {
            for (var a = s(e), i = 0; i < a.length; i++) t.call(n, e[a[i]], a[i]);
            return a;
        }
        function u(e) {
            return function(t, n) {
                e(n, t);
            };
        }
        function l() {
            return ++ua;
        }
        function c(e, t) {
            t ? e.$$hashKey = t : delete e.$$hashKey;
        }
        function d(e) {
            for (var t = e.$$hashKey, n = 1, a = arguments.length; n < a; n++) {
                var i = arguments[n];
                if (i) for (var r = Object.keys(i), s = 0, o = r.length; s < o; s++) {
                    var u = r[s];
                    e[u] = i[u];
                }
            }
            return c(e, t), e;
        }
        function f(e) {
            return parseInt(e, 10);
        }
        function m(e, t) {
            return d(Object.create(e), t);
        }
        function p() {}
        function h(e) {
            return e;
        }
        function g(e) {
            return function() {
                return e;
            };
        }
        function _(e) {
            return "undefined" == typeof e;
        }
        function v(e) {
            return "undefined" != typeof e;
        }
        function b(e) {
            return null !== e && "object" == typeof e;
        }
        function y(e) {
            return "string" == typeof e;
        }
        function M(e) {
            return "number" == typeof e;
        }
        function $(e) {
            return "[object Date]" === ra.call(e);
        }
        function k(e) {
            return "function" == typeof e;
        }
        function w(e) {
            return "[object RegExp]" === ra.call(e);
        }
        function L(e) {
            return e && e.window === e;
        }
        function D(e) {
            return e && e.$evalAsync && e.$watch;
        }
        function Y(e) {
            return "[object File]" === ra.call(e);
        }
        function T(e) {
            return "[object FormData]" === ra.call(e);
        }
        function S(e) {
            return "[object Blob]" === ra.call(e);
        }
        function x(e) {
            return "boolean" == typeof e;
        }
        function C(e) {
            return e && k(e.then);
        }
        function E(e) {
            return !(!e || !(e.nodeName || e.prop && e.attr && e.find));
        }
        function H(e) {
            var t, n = {}, a = e.split(",");
            for (t = 0; t < a.length; t++) n[a[t]] = !0;
            return n;
        }
        function j(e) {
            return Bn(e.nodeName || e[0] && e[0].nodeName);
        }
        function A(e, t) {
            var n = e.indexOf(t);
            return n >= 0 && e.splice(n, 1), t;
        }
        function O(e, t, n, a) {
            if (L(e) || D(e)) throw sa("cpws", "Can't copy! Making copies of Window or Scope instances is not supported.");
            if (t) {
                if (e === t) throw sa("cpi", "Can't copy! Source and destination are identical.");
                if (n = n || [], a = a || [], b(e)) {
                    var i = n.indexOf(e);
                    if (i !== -1) return a[i];
                    n.push(e), a.push(t);
                }
                var s;
                if (ca(e)) {
                    t.length = 0;
                    for (var o = 0; o < e.length; o++) s = O(e[o], null, n, a), b(e[o]) && (n.push(e[o]), 
                    a.push(s)), t.push(s);
                } else {
                    var u = t.$$hashKey;
                    ca(t) ? t.length = 0 : r(t, function(e, n) {
                        delete t[n];
                    });
                    for (var l in e) e.hasOwnProperty(l) && (s = O(e[l], null, n, a), b(e[l]) && (n.push(e[l]), 
                    a.push(s)), t[l] = s);
                    c(t, u);
                }
            } else if (t = e, e) if (ca(e)) t = O(e, [], n, a); else if ($(e)) t = new Date(e.getTime()); else if (w(e)) t = new RegExp(e.source, e.toString().match(/[^\/]*$/)[0]), 
            t.lastIndex = e.lastIndex; else if (b(e)) {
                var d = Object.create(Object.getPrototypeOf(e));
                t = O(e, d, n, a);
            }
            return t;
        }
        function I(e, t) {
            if (ca(e)) {
                t = t || [];
                for (var n = 0, a = e.length; n < a; n++) t[n] = e[n];
            } else if (b(e)) {
                t = t || {};
                for (var i in e) "$" === i.charAt(0) && "$" === i.charAt(1) || (t[i] = e[i]);
            }
            return t || e;
        }
        function P(e, t) {
            if (e === t) return !0;
            if (null === e || null === t) return !1;
            if (e !== e && t !== t) return !0;
            var a, i, r, s = typeof e, o = typeof t;
            if (s == o && "object" == s) {
                if (!ca(e)) {
                    if ($(e)) return !!$(t) && P(e.getTime(), t.getTime());
                    if (w(e) && w(t)) return e.toString() == t.toString();
                    if (D(e) || D(t) || L(e) || L(t) || ca(t)) return !1;
                    r = {};
                    for (i in e) if ("$" !== i.charAt(0) && !k(e[i])) {
                        if (!P(e[i], t[i])) return !1;
                        r[i] = !0;
                    }
                    for (i in t) if (!r.hasOwnProperty(i) && "$" !== i.charAt(0) && t[i] !== n && !k(t[i])) return !1;
                    return !0;
                }
                if (!ca(t)) return !1;
                if ((a = e.length) == t.length) {
                    for (i = 0; i < a; i++) if (!P(e[i], t[i])) return !1;
                    return !0;
                }
            }
            return !1;
        }
        function F(e, t, n) {
            return e.concat(na.call(t, n));
        }
        function U(e, t) {
            return na.call(e, t || 0);
        }
        function N(e, t) {
            var n = arguments.length > 2 ? U(arguments, 2) : [];
            return !k(t) || t instanceof RegExp ? t : n.length ? function() {
                return arguments.length ? t.apply(e, F(n, arguments, 0)) : t.apply(e, n);
            } : function() {
                return arguments.length ? t.apply(e, arguments) : t.call(e);
            };
        }
        function V(e, a) {
            var i = a;
            return "string" == typeof e && "$" === e.charAt(0) && "$" === e.charAt(1) ? i = n : L(a) ? i = "$WINDOW" : a && t === a ? i = "$DOCUMENT" : D(a) && (i = "$SCOPE"), 
            i;
        }
        function W(e, t) {
            return "undefined" == typeof e ? n : (M(t) || (t = t ? 2 : null), JSON.stringify(e, V, t));
        }
        function q(e) {
            return y(e) ? JSON.parse(e) : e;
        }
        function R(e) {
            e = Xn(e).clone();
            try {
                e.empty();
            } catch (e) {}
            var t = Xn("<div>").append(e).html();
            try {
                return e[0].nodeType === va ? Bn(t) : t.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/, function(e, t) {
                    return "<" + Bn(t);
                });
            } catch (e) {
                return Bn(t);
            }
        }
        function z(e) {
            try {
                return decodeURIComponent(e);
            } catch (e) {}
        }
        function B(e) {
            var t, n, a = {};
            return r((e || "").split("&"), function(e) {
                if (e && (t = e.replace(/\+/g, "%20").split("="), n = z(t[0]), v(n))) {
                    var i = !v(t[1]) || z(t[1]);
                    Gn.call(a, n) ? ca(a[n]) ? a[n].push(i) : a[n] = [ a[n], i ] : a[n] = i;
                }
            }), a;
        }
        function G(e) {
            var t = [];
            return r(e, function(e, n) {
                ca(e) ? r(e, function(e) {
                    t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
                }) : t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
            }), t.length ? t.join("&") : "";
        }
        function J(e) {
            return K(e, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+");
        }
        function K(e, t) {
            return encodeURIComponent(e).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%3B/gi, ";").replace(/%20/g, t ? "%20" : "+");
        }
        function Q(e, t) {
            var n, a, i = pa.length;
            for (e = Xn(e), a = 0; a < i; ++a) if (n = pa[a] + t, y(n = e.attr(n))) return n;
            return null;
        }
        function Z(e, t) {
            var n, a, i = {};
            r(pa, function(t) {
                var i = t + "app";
                !n && e.hasAttribute && e.hasAttribute(i) && (n = e, a = e.getAttribute(i));
            }), r(pa, function(t) {
                var i, r = t + "app";
                !n && (i = e.querySelector("[" + r.replace(":", "\\:") + "]")) && (n = i, a = i.getAttribute(r));
            }), n && (i.strictDi = null !== Q(n, "strict-di"), t(n, a ? [ a ] : [], i));
        }
        function X(n, a, i) {
            b(i) || (i = {});
            var s = {
                strictDi: !1
            };
            i = d(s, i);
            var o = function() {
                if (n = Xn(n), n.injector()) {
                    var e = n[0] === t ? "document" : R(n);
                    throw sa("btstrpd", "App Already Bootstrapped with this Element '{0}'", e.replace(/</, "&lt;").replace(/>/, "&gt;"));
                }
                a = a || [], a.unshift([ "$provide", function(e) {
                    e.value("$rootElement", n);
                } ]), i.debugInfoEnabled && a.push([ "$compileProvider", function(e) {
                    e.debugInfoEnabled(!0);
                } ]), a.unshift("ng");
                var r = qe(a, i.strictDi);
                return r.invoke([ "$rootScope", "$rootElement", "$compile", "$injector", function(e, t, n, a) {
                    e.$apply(function() {
                        t.data("$injector", a), n(t)(e);
                    });
                } ]), r;
            }, u = /^NG_ENABLE_DEBUG_INFO!/, l = /^NG_DEFER_BOOTSTRAP!/;
            return e && u.test(e.name) && (i.debugInfoEnabled = !0, e.name = e.name.replace(u, "")), 
            e && !l.test(e.name) ? o() : (e.name = e.name.replace(l, ""), oa.resumeBootstrap = function(e) {
                return r(e, function(e) {
                    a.push(e);
                }), o();
            }, void (k(oa.resumeDeferredBootstrap) && oa.resumeDeferredBootstrap()));
        }
        function ee() {
            e.name = "NG_ENABLE_DEBUG_INFO!" + e.name, e.location.reload();
        }
        function te(e) {
            var t = oa.element(e).injector();
            if (!t) throw sa("test", "no injector found for element argument to getTestability");
            return t.get("$$testability");
        }
        function ne(e, t) {
            return t = t || "_", e.replace(ha, function(e, n) {
                return (n ? t : "") + e.toLowerCase();
            });
        }
        function ae() {
            var t;
            ga || (ea = e.jQuery, ea && ea.fn.on ? (Xn = ea, d(ea.fn, {
                scope: Oa.scope,
                isolateScope: Oa.isolateScope,
                controller: Oa.controller,
                injector: Oa.injector,
                inheritedData: Oa.inheritedData
            }), t = ea.cleanData, ea.cleanData = function(e) {
                var n;
                if (la) la = !1; else for (var a, i = 0; null != (a = e[i]); i++) n = ea._data(a, "events"), 
                n && n.$destroy && ea(a).triggerHandler("$destroy");
                t(e);
            }) : Xn = ye, oa.element = Xn, ga = !0);
        }
        function ie(e, t, n) {
            if (!e) throw sa("areq", "Argument '{0}' is {1}", t || "?", n || "required");
            return e;
        }
        function re(e, t, n) {
            return n && ca(e) && (e = e[e.length - 1]), ie(k(e), t, "not a function, got " + (e && "object" == typeof e ? e.constructor.name || "Object" : typeof e)), 
            e;
        }
        function se(e, t) {
            if ("hasOwnProperty" === e) throw sa("badname", "hasOwnProperty is not a valid {0} name", t);
        }
        function oe(e, t, n) {
            if (!t) return e;
            for (var a, i = t.split("."), r = e, s = i.length, o = 0; o < s; o++) a = i[o], 
            e && (e = (r = e)[a]);
            return !n && k(e) ? N(r, e) : e;
        }
        function ue(e) {
            var t = e[0], n = e[e.length - 1], a = [ t ];
            do {
                if (t = t.nextSibling, !t) break;
                a.push(t);
            } while (t !== n);
            return Xn(a);
        }
        function le() {
            return Object.create(null);
        }
        function ce(e) {
            function t(e, t, n) {
                return e[t] || (e[t] = n());
            }
            var n = a("$injector"), i = a("ng"), r = t(e, "angular", Object);
            return r.$$minErr = r.$$minErr || a, t(r, "module", function() {
                var e = {};
                return function(a, r, s) {
                    var o = function(e, t) {
                        if ("hasOwnProperty" === e) throw i("badname", "hasOwnProperty is not a valid {0} name", t);
                    };
                    return o(a, "module"), r && e.hasOwnProperty(a) && (e[a] = null), t(e, a, function() {
                        function e(e, n, a, i) {
                            return i || (i = t), function() {
                                return i[a || "push"]([ e, n, arguments ]), l;
                            };
                        }
                        if (!r) throw n("nomod", "Module '{0}' is not available! You either misspelled the module name or forgot to load it. If registering a module ensure that you specify the dependencies as the second argument.", a);
                        var t = [], i = [], o = [], u = e("$injector", "invoke", "push", i), l = {
                            _invokeQueue: t,
                            _configBlocks: i,
                            _runBlocks: o,
                            requires: r,
                            name: a,
                            provider: e("$provide", "provider"),
                            factory: e("$provide", "factory"),
                            service: e("$provide", "service"),
                            value: e("$provide", "value"),
                            constant: e("$provide", "constant", "unshift"),
                            animation: e("$animateProvider", "register"),
                            filter: e("$filterProvider", "register"),
                            controller: e("$controllerProvider", "register"),
                            directive: e("$compileProvider", "directive"),
                            config: u,
                            run: function(e) {
                                return o.push(e), this;
                            }
                        };
                        return s && u(s), l;
                    });
                };
            });
        }
        function de(e) {
            var t = [];
            return JSON.stringify(e, function(e, n) {
                if (n = V(e, n), b(n)) {
                    if (t.indexOf(n) >= 0) return "<<already seen>>";
                    t.push(n);
                }
                return n;
            });
        }
        function fe(e) {
            return "function" == typeof e ? e.toString().replace(/ \{[\s\S]*$/, "") : "undefined" == typeof e ? "undefined" : "string" != typeof e ? de(e) : e;
        }
        function me(t) {
            d(t, {
                bootstrap: X,
                copy: O,
                extend: d,
                equals: P,
                element: Xn,
                forEach: r,
                injector: qe,
                noop: p,
                bind: N,
                toJson: W,
                fromJson: q,
                identity: h,
                isUndefined: _,
                isDefined: v,
                isString: y,
                isFunction: k,
                isObject: b,
                isNumber: M,
                isElement: E,
                isArray: ca,
                version: $a,
                isDate: $,
                lowercase: Bn,
                uppercase: Jn,
                callbacks: {
                    counter: 0
                },
                getTestability: te,
                $$minErr: a,
                $$csp: ma,
                reloadWithDebugInfo: ee
            }), ta = ce(e);
            try {
                ta("ngLocale");
            } catch (e) {
                ta("ngLocale", []).provider("$locale", gt);
            }
            ta("ng", [ "ngLocale" ], [ "$provide", function(e) {
                e.provider({
                    $$sanitizeUri: Gt
                }), e.provider("$compile", Qe).directive({
                    a: Ti,
                    input: Ri,
                    textarea: Ri,
                    form: Hi,
                    script: jr,
                    select: Ir,
                    style: Fr,
                    option: Pr,
                    ngBind: Gi,
                    ngBindHtml: Ki,
                    ngBindTemplate: Ji,
                    ngClass: Zi,
                    ngClassEven: er,
                    ngClassOdd: Xi,
                    ngCloak: tr,
                    ngController: nr,
                    ngForm: ji,
                    ngHide: Tr,
                    ngIf: rr,
                    ngInclude: sr,
                    ngInit: ur,
                    ngNonBindable: $r,
                    ngPluralize: kr,
                    ngRepeat: wr,
                    ngShow: Yr,
                    ngStyle: Sr,
                    ngSwitch: xr,
                    ngSwitchWhen: Cr,
                    ngSwitchDefault: Er,
                    ngOptions: Or,
                    ngTransclude: Hr,
                    ngModel: br,
                    ngList: lr,
                    ngChange: Qi,
                    pattern: Nr,
                    ngPattern: Nr,
                    required: Ur,
                    ngRequired: Ur,
                    minlength: Wr,
                    ngMinlength: Wr,
                    maxlength: Vr,
                    ngMaxlength: Vr,
                    ngValue: Bi,
                    ngModelOptions: Mr
                }).directive({
                    ngInclude: or
                }).directive(Si).directive(ar), e.provider({
                    $anchorScroll: Re,
                    $animate: za,
                    $browser: Ge,
                    $cacheFactory: Je,
                    $controller: tt,
                    $document: nt,
                    $exceptionHandler: at,
                    $filter: on,
                    $interpolate: pt,
                    $interval: ht,
                    $http: ct,
                    $httpBackend: ft,
                    $location: xt,
                    $log: Ct,
                    $parse: Vt,
                    $rootScope: Bt,
                    $q: Wt,
                    $$q: qt,
                    $sce: Zt,
                    $sceDelegate: Qt,
                    $sniffer: Xt,
                    $templateCache: Ke,
                    $templateRequest: en,
                    $$testability: tn,
                    $timeout: nn,
                    $window: sn,
                    $$rAF: zt,
                    $$asyncCallback: ze,
                    $$jqLite: Fe
                });
            } ]);
        }
        function pe() {
            return ++wa;
        }
        function he(e) {
            return e.replace(Ya, function(e, t, n, a) {
                return a ? n.toUpperCase() : n;
            }).replace(Ta, "Moz$1");
        }
        function ge(e) {
            return !Ea.test(e);
        }
        function _e(e) {
            var t = e.nodeType;
            return t === _a || !t || t === ya;
        }
        function ve(e, t) {
            var n, a, i, s, o = t.createDocumentFragment(), u = [];
            if (ge(e)) u.push(t.createTextNode(e)); else {
                for (n = n || o.appendChild(t.createElement("div")), a = (Ha.exec(e) || [ "", "" ])[1].toLowerCase(), 
                i = Aa[a] || Aa._default, n.innerHTML = i[1] + e.replace(ja, "<$1></$2>") + i[2], 
                s = i[0]; s--; ) n = n.lastChild;
                u = F(u, n.childNodes), n = o.firstChild, n.textContent = "";
            }
            return o.textContent = "", o.innerHTML = "", r(u, function(e) {
                o.appendChild(e);
            }), o;
        }
        function be(e, n) {
            n = n || t;
            var a;
            return (a = Ca.exec(e)) ? [ n.createElement(a[1]) ] : (a = ve(e, n)) ? a.childNodes : [];
        }
        function ye(e) {
            if (e instanceof ye) return e;
            var t;
            if (y(e) && (e = da(e), t = !0), !(this instanceof ye)) {
                if (t && "<" != e.charAt(0)) throw xa("nosel", "Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element");
                return new ye(e);
            }
            t ? xe(this, be(e)) : xe(this, e);
        }
        function Me(e) {
            return e.cloneNode(!0);
        }
        function $e(e, t) {
            if (t || we(e), e.querySelectorAll) for (var n = e.querySelectorAll("*"), a = 0, i = n.length; a < i; a++) we(n[a]);
        }
        function ke(e, t, n, a) {
            if (v(a)) throw xa("offargs", "jqLite#off() does not support the `selector` argument");
            var i = Le(e), s = i && i.events, o = i && i.handle;
            if (o) if (t) r(t.split(" "), function(t) {
                if (v(n)) {
                    var a = s[t];
                    if (A(a || [], n), a && a.length > 0) return;
                }
                Da(e, t, o), delete s[t];
            }); else for (t in s) "$destroy" !== t && Da(e, t, o), delete s[t];
        }
        function we(e, t) {
            var a = e.ng339, i = a && ka[a];
            if (i) {
                if (t) return void delete i.data[t];
                i.handle && (i.events.$destroy && i.handle({}, "$destroy"), ke(e)), delete ka[a], 
                e.ng339 = n;
            }
        }
        function Le(e, t) {
            var a = e.ng339, i = a && ka[a];
            return t && !i && (e.ng339 = a = pe(), i = ka[a] = {
                events: {},
                data: {},
                handle: n
            }), i;
        }
        function De(e, t, n) {
            if (_e(e)) {
                var a = v(n), i = !a && t && !b(t), r = !t, s = Le(e, !i), o = s && s.data;
                if (a) o[t] = n; else {
                    if (r) return o;
                    if (i) return o && o[t];
                    d(o, t);
                }
            }
        }
        function Ye(e, t) {
            return !!e.getAttribute && (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").indexOf(" " + t + " ") > -1;
        }
        function Te(e, t) {
            t && e.setAttribute && r(t.split(" "), function(t) {
                e.setAttribute("class", da((" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").replace(" " + da(t) + " ", " ")));
            });
        }
        function Se(e, t) {
            if (t && e.setAttribute) {
                var n = (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ");
                r(t.split(" "), function(e) {
                    e = da(e), n.indexOf(" " + e + " ") === -1 && (n += e + " ");
                }), e.setAttribute("class", da(n));
            }
        }
        function xe(e, t) {
            if (t) if (t.nodeType) e[e.length++] = t; else {
                var n = t.length;
                if ("number" == typeof n && t.window !== t) {
                    if (n) for (var a = 0; a < n; a++) e[e.length++] = t[a];
                } else e[e.length++] = t;
            }
        }
        function Ce(e, t) {
            return Ee(e, "$" + (t || "ngController") + "Controller");
        }
        function Ee(e, t, a) {
            e.nodeType == ya && (e = e.documentElement);
            for (var i = ca(t) ? t : [ t ]; e; ) {
                for (var r = 0, s = i.length; r < s; r++) if ((a = Xn.data(e, i[r])) !== n) return a;
                e = e.parentNode || e.nodeType === Ma && e.host;
            }
        }
        function He(e) {
            for ($e(e, !0); e.firstChild; ) e.removeChild(e.firstChild);
        }
        function je(e, t) {
            t || $e(e);
            var n = e.parentNode;
            n && n.removeChild(e);
        }
        function Ae(t, n) {
            n = n || e, "complete" === n.document.readyState ? n.setTimeout(t) : Xn(n).on("load", t);
        }
        function Oe(e, t) {
            var n = Ia[t.toLowerCase()];
            return n && Pa[j(e)] && n;
        }
        function Ie(e, t) {
            var n = e.nodeName;
            return ("INPUT" === n || "TEXTAREA" === n) && Fa[t];
        }
        function Pe(e, t) {
            var n = function(n, a) {
                n.isDefaultPrevented = function() {
                    return n.defaultPrevented;
                };
                var i = t[a || n.type], r = i ? i.length : 0;
                if (r) {
                    if (_(n.immediatePropagationStopped)) {
                        var s = n.stopImmediatePropagation;
                        n.stopImmediatePropagation = function() {
                            n.immediatePropagationStopped = !0, n.stopPropagation && n.stopPropagation(), s && s.call(n);
                        };
                    }
                    n.isImmediatePropagationStopped = function() {
                        return n.immediatePropagationStopped === !0;
                    }, r > 1 && (i = I(i));
                    for (var o = 0; o < r; o++) n.isImmediatePropagationStopped() || i[o].call(e, n);
                }
            };
            return n.elem = e, n;
        }
        function Fe() {
            this.$get = function() {
                return d(ye, {
                    hasClass: function(e, t) {
                        return e.attr && (e = e[0]), Ye(e, t);
                    },
                    addClass: function(e, t) {
                        return e.attr && (e = e[0]), Se(e, t);
                    },
                    removeClass: function(e, t) {
                        return e.attr && (e = e[0]), Te(e, t);
                    }
                });
            };
        }
        function Ue(e, t) {
            var n = e && e.$$hashKey;
            if (n) return "function" == typeof n && (n = e.$$hashKey()), n;
            var a = typeof e;
            return n = "function" == a || "object" == a && null !== e ? e.$$hashKey = a + ":" + (t || l)() : a + ":" + e;
        }
        function Ne(e, t) {
            if (t) {
                var n = 0;
                this.nextUid = function() {
                    return ++n;
                };
            }
            r(e, this.put, this);
        }
        function Ve(e) {
            var t = e.toString().replace(Wa, ""), n = t.match(Ua);
            return n ? "function(" + (n[1] || "").replace(/[\s\r\n]+/, " ") + ")" : "fn";
        }
        function We(e, t, n) {
            var a, i, s, o;
            if ("function" == typeof e) {
                if (!(a = e.$inject)) {
                    if (a = [], e.length) {
                        if (t) throw y(n) && n || (n = e.name || Ve(e)), qa("strictdi", "{0} is not using explicit annotation and cannot be invoked in strict mode", n);
                        i = e.toString().replace(Wa, ""), s = i.match(Ua), r(s[1].split(Na), function(e) {
                            e.replace(Va, function(e, t, n) {
                                a.push(n);
                            });
                        });
                    }
                    e.$inject = a;
                }
            } else ca(e) ? (o = e.length - 1, re(e[o], "fn"), a = e.slice(0, o)) : re(e, "fn", !0);
            return a;
        }
        function qe(e, t) {
            function a(e) {
                return function(t, n) {
                    return b(t) ? void r(t, u(e)) : e(t, n);
                };
            }
            function i(e, t) {
                if (se(e, "service"), (k(t) || ca(t)) && (t = D.instantiate(t)), !t.$get) throw qa("pget", "Provider '{0}' must define $get factory method.", e);
                return L[e + M] = t;
            }
            function s(e, t) {
                return function() {
                    var n = T.invoke(t, this);
                    if (_(n)) throw qa("undef", "Provider '{0}' must return a value from $get factory method.", e);
                    return n;
                };
            }
            function o(e, t, n) {
                return i(e, {
                    $get: n !== !1 ? s(e, t) : t
                });
            }
            function l(e, t) {
                return o(e, [ "$injector", function(e) {
                    return e.instantiate(t);
                } ]);
            }
            function c(e, t) {
                return o(e, g(t), !1);
            }
            function d(e, t) {
                se(e, "constant"), L[e] = t, Y[e] = t;
            }
            function f(e, t) {
                var n = D.get(e + M), a = n.$get;
                n.$get = function() {
                    var e = T.invoke(a, n);
                    return T.invoke(t, null, {
                        $delegate: e
                    });
                };
            }
            function m(e) {
                var t, n = [];
                return r(e, function(e) {
                    function a(e) {
                        var t, n;
                        for (t = 0, n = e.length; t < n; t++) {
                            var a = e[t], i = D.get(a[0]);
                            i[a[1]].apply(i, a[2]);
                        }
                    }
                    if (!w.get(e)) {
                        w.put(e, !0);
                        try {
                            y(e) ? (t = ta(e), n = n.concat(m(t.requires)).concat(t._runBlocks), a(t._invokeQueue), 
                            a(t._configBlocks)) : k(e) ? n.push(D.invoke(e)) : ca(e) ? n.push(D.invoke(e)) : re(e, "module");
                        } catch (t) {
                            throw ca(e) && (e = e[e.length - 1]), t.message && t.stack && t.stack.indexOf(t.message) == -1 && (t = t.message + "\n" + t.stack), 
                            qa("modulerr", "Failed to instantiate module {0} due to:\n{1}", e, t.stack || t.message || t);
                        }
                    }
                }), n;
            }
            function h(e, n) {
                function a(t, a) {
                    if (e.hasOwnProperty(t)) {
                        if (e[t] === v) throw qa("cdep", "Circular dependency found: {0}", t + " <- " + $.join(" <- "));
                        return e[t];
                    }
                    try {
                        return $.unshift(t), e[t] = v, e[t] = n(t, a);
                    } catch (n) {
                        throw e[t] === v && delete e[t], n;
                    } finally {
                        $.shift();
                    }
                }
                function i(e, n, i, r) {
                    "string" == typeof i && (r = i, i = null);
                    var s, o, u, l = [], c = qe.$$annotate(e, t, r);
                    for (o = 0, s = c.length; o < s; o++) {
                        if (u = c[o], "string" != typeof u) throw qa("itkn", "Incorrect injection token! Expected service name as string, got {0}", u);
                        l.push(i && i.hasOwnProperty(u) ? i[u] : a(u, r));
                    }
                    return ca(e) && (e = e[s]), e.apply(n, l);
                }
                function r(e, t, n) {
                    var a = Object.create((ca(e) ? e[e.length - 1] : e).prototype || null), r = i(e, a, t, n);
                    return b(r) || k(r) ? r : a;
                }
                return {
                    invoke: i,
                    instantiate: r,
                    get: a,
                    annotate: qe.$$annotate,
                    has: function(t) {
                        return L.hasOwnProperty(t + M) || e.hasOwnProperty(t);
                    }
                };
            }
            t = t === !0;
            var v = {}, M = "Provider", $ = [], w = new Ne([], !0), L = {
                $provide: {
                    provider: a(i),
                    factory: a(o),
                    service: a(l),
                    value: a(c),
                    constant: a(d),
                    decorator: f
                }
            }, D = L.$injector = h(L, function(e, t) {
                throw oa.isString(t) && $.push(t), qa("unpr", "Unknown provider: {0}", $.join(" <- "));
            }), Y = {}, T = Y.$injector = h(Y, function(e, t) {
                var a = D.get(e + M, t);
                return T.invoke(a.$get, a, n, e);
            });
            return r(m(e), function(e) {
                T.invoke(e || p);
            }), T;
        }
        function Re() {
            var e = !0;
            this.disableAutoScrolling = function() {
                e = !1;
            }, this.$get = [ "$window", "$location", "$rootScope", function(t, n, a) {
                function i(e) {
                    var t = null;
                    return Array.prototype.some.call(e, function(e) {
                        if ("a" === j(e)) return t = e, !0;
                    }), t;
                }
                function r() {
                    var e = o.yOffset;
                    if (k(e)) e = e(); else if (E(e)) {
                        var n = e[0], a = t.getComputedStyle(n);
                        e = "fixed" !== a.position ? 0 : n.getBoundingClientRect().bottom;
                    } else M(e) || (e = 0);
                    return e;
                }
                function s(e) {
                    if (e) {
                        e.scrollIntoView();
                        var n = r();
                        if (n) {
                            var a = e.getBoundingClientRect().top;
                            t.scrollBy(0, a - n);
                        }
                    } else t.scrollTo(0, 0);
                }
                function o() {
                    var e, t = n.hash();
                    t ? (e = u.getElementById(t)) ? s(e) : (e = i(u.getElementsByName(t))) ? s(e) : "top" === t && s(null) : s(null);
                }
                var u = t.document;
                return e && a.$watch(function() {
                    return n.hash();
                }, function(e, t) {
                    e === t && "" === e || Ae(function() {
                        a.$evalAsync(o);
                    });
                }), o;
            } ];
        }
        function ze() {
            this.$get = [ "$$rAF", "$timeout", function(e, t) {
                return e.supported ? function(t) {
                    return e(t);
                } : function(e) {
                    return t(e, 0, !1);
                };
            } ];
        }
        function Be(e, t, a, i) {
            function s(e) {
                try {
                    e.apply(null, U(arguments, 1));
                } finally {
                    if (k--, 0 === k) for (;w.length; ) try {
                        w.pop()();
                    } catch (e) {
                        a.error(e);
                    }
                }
            }
            function o(e) {
                var t = e.indexOf("#");
                return t === -1 ? "" : e.substr(t + 1);
            }
            function u(e, t) {
                !function n() {
                    r(D, function(e) {
                        e();
                    }), L = t(n, e);
                }();
            }
            function l() {
                c(), d();
            }
            function c() {
                Y = e.history.state, Y = _(Y) ? null : Y, P(Y, j) && (Y = j), j = Y;
            }
            function d() {
                S === m.url() && T === Y || (S = m.url(), T = Y, r(E, function(e) {
                    e(m.url(), Y);
                }));
            }
            function f(e) {
                try {
                    return decodeURIComponent(e);
                } catch (t) {
                    return e;
                }
            }
            var m = this, h = t[0], g = e.location, v = e.history, b = e.setTimeout, M = e.clearTimeout, $ = {};
            m.isMock = !1;
            var k = 0, w = [];
            m.$$completeOutstandingRequest = s, m.$$incOutstandingRequestCount = function() {
                k++;
            }, m.notifyWhenNoOutstandingRequests = function(e) {
                r(D, function(e) {
                    e();
                }), 0 === k ? e() : w.push(e);
            };
            var L, D = [];
            m.addPollFn = function(e) {
                return _(L) && u(100, b), D.push(e), e;
            };
            var Y, T, S = g.href, x = t.find("base"), C = null;
            c(), T = Y, m.url = function(t, n, a) {
                if (_(a) && (a = null), g !== e.location && (g = e.location), v !== e.history && (v = e.history), 
                t) {
                    var r = T === a;
                    if (S === t && (!i.history || r)) return m;
                    var s = S && Mt(S) === Mt(t);
                    return S = t, T = a, !i.history || s && r ? (s || (C = t), n ? g.replace(t) : s ? g.hash = o(t) : g.href = t) : (v[n ? "replaceState" : "pushState"](a, "", t), 
                    c(), T = Y), m;
                }
                return C || g.href.replace(/%27/g, "'");
            }, m.state = function() {
                return Y;
            };
            var E = [], H = !1, j = null;
            m.onUrlChange = function(t) {
                return H || (i.history && Xn(e).on("popstate", l), Xn(e).on("hashchange", l), H = !0), 
                E.push(t), t;
            }, m.$$checkUrlChange = d, m.baseHref = function() {
                var e = x.attr("href");
                return e ? e.replace(/^(https?\:)?\/\/[^\/]*/, "") : "";
            };
            var A = {}, O = "", I = m.baseHref();
            m.cookies = function(e, t) {
                var i, r, s, o, u;
                if (!e) {
                    if (h.cookie !== O) for (O = h.cookie, r = O.split("; "), A = {}, o = 0; o < r.length; o++) s = r[o], 
                    u = s.indexOf("="), u > 0 && (e = f(s.substring(0, u)), A[e] === n && (A[e] = f(s.substring(u + 1))));
                    return A;
                }
                t === n ? h.cookie = encodeURIComponent(e) + "=;path=" + I + ";expires=Thu, 01 Jan 1970 00:00:00 GMT" : y(t) && (i = (h.cookie = encodeURIComponent(e) + "=" + encodeURIComponent(t) + ";path=" + I).length + 1, 
                i > 4096 && a.warn("Cookie '" + e + "' possibly not set or overflowed because it was too large (" + i + " > 4096 bytes)!"));
            }, m.defer = function(e, t) {
                var n;
                return k++, n = b(function() {
                    delete $[n], s(e);
                }, t || 0), $[n] = !0, n;
            }, m.defer.cancel = function(e) {
                return !!$[e] && (delete $[e], M(e), s(p), !0);
            };
        }
        function Ge() {
            this.$get = [ "$window", "$log", "$sniffer", "$document", function(e, t, n, a) {
                return new Be(e, a, t, n);
            } ];
        }
        function Je() {
            this.$get = function() {
                function e(e, n) {
                    function i(e) {
                        e != f && (m ? m == e && (m = e.n) : m = e, r(e.n, e.p), r(e, f), f = e, f.n = null);
                    }
                    function r(e, t) {
                        e != t && (e && (e.p = t), t && (t.n = e));
                    }
                    if (e in t) throw a("$cacheFactory")("iid", "CacheId '{0}' is already taken!", e);
                    var s = 0, o = d({}, n, {
                        id: e
                    }), u = {}, l = n && n.capacity || Number.MAX_VALUE, c = {}, f = null, m = null;
                    return t[e] = {
                        put: function(e, t) {
                            if (l < Number.MAX_VALUE) {
                                var n = c[e] || (c[e] = {
                                    key: e
                                });
                                i(n);
                            }
                            if (!_(t)) return e in u || s++, u[e] = t, s > l && this.remove(m.key), t;
                        },
                        get: function(e) {
                            if (l < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                i(t);
                            }
                            return u[e];
                        },
                        remove: function(e) {
                            if (l < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                t == f && (f = t.p), t == m && (m = t.n), r(t.n, t.p), delete c[e];
                            }
                            delete u[e], s--;
                        },
                        removeAll: function() {
                            u = {}, s = 0, c = {}, f = m = null;
                        },
                        destroy: function() {
                            u = null, o = null, c = null, delete t[e];
                        },
                        info: function() {
                            return d({}, o, {
                                size: s
                            });
                        }
                    };
                }
                var t = {};
                return e.info = function() {
                    var e = {};
                    return r(t, function(t, n) {
                        e[n] = t.info();
                    }), e;
                }, e.get = function(e) {
                    return t[e];
                }, e;
            };
        }
        function Ke() {
            this.$get = [ "$cacheFactory", function(e) {
                return e("templates");
            } ];
        }
        function Qe(e, a) {
            function i(e, t) {
                var n = /^\s*([@&]|=(\*?))(\??)\s*(\w*)\s*$/, a = {};
                return r(e, function(e, i) {
                    var r = e.match(n);
                    if (!r) throw Ba("iscp", "Invalid isolate scope definition for directive '{0}'. Definition: {... {1}: '{2}' ...}", t, i, e);
                    a[i] = {
                        mode: r[1][0],
                        collection: "*" === r[2],
                        optional: "?" === r[3],
                        attrName: r[4] || i
                    };
                }), a;
            }
            var s = {}, o = "Directive", l = /^\s*directive\:\s*([\w\-]+)\s+(.*)$/, c = /(([\w\-]+)(?:\:([^;]+))?;?)/, f = H("ngSrc,ngSrcset,src,srcset"), _ = /^(?:(\^\^?)?(\?)?(\^\^?)?)?/, M = /^(on[a-z]+|formaction)$/;
            this.directive = function t(n, a) {
                return se(n, "directive"), y(n) ? (ie(a, "directiveFactory"), s.hasOwnProperty(n) || (s[n] = [], 
                e.factory(n + o, [ "$injector", "$exceptionHandler", function(e, t) {
                    var a = [];
                    return r(s[n], function(r, s) {
                        try {
                            var o = e.invoke(r);
                            k(o) ? o = {
                                compile: g(o)
                            } : !o.compile && o.link && (o.compile = g(o.link)), o.priority = o.priority || 0, 
                            o.index = s, o.name = o.name || n, o.require = o.require || o.controller && o.name, 
                            o.restrict = o.restrict || "EA", b(o.scope) && (o.$$isolateBindings = i(o.scope, o.name)), 
                            a.push(o);
                        } catch (e) {
                            t(e);
                        }
                    }), a;
                } ])), s[n].push(a)) : r(n, u(t)), this;
            }, this.aHrefSanitizationWhitelist = function(e) {
                return v(e) ? (a.aHrefSanitizationWhitelist(e), this) : a.aHrefSanitizationWhitelist();
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (a.imgSrcSanitizationWhitelist(e), this) : a.imgSrcSanitizationWhitelist();
            };
            var $ = !0;
            this.debugInfoEnabled = function(e) {
                return v(e) ? ($ = e, this) : $;
            }, this.$get = [ "$injector", "$interpolate", "$exceptionHandler", "$templateRequest", "$parse", "$controller", "$rootScope", "$document", "$sce", "$animate", "$$sanitizeUri", function(e, a, i, u, g, v, w, L, Y, T, S) {
                function x(e, t) {
                    try {
                        e.addClass(t);
                    } catch (e) {}
                }
                function C(e, t, n, a, i) {
                    e instanceof Xn || (e = Xn(e)), r(e, function(t, n) {
                        t.nodeType == va && t.nodeValue.match(/\S+/) && (e[n] = Xn(t).wrap("<span></span>").parent()[0]);
                    });
                    var s = H(e, t, e, n, a, i);
                    C.$$addScopeClass(e);
                    var o = null;
                    return function(t, n, a) {
                        ie(t, "scope"), a = a || {};
                        var i = a.parentBoundTranscludeFn, r = a.transcludeControllers, u = a.futureParentElement;
                        i && i.$$boundTransclude && (i = i.$$boundTransclude), o || (o = E(u));
                        var l;
                        if (l = "html" !== o ? Xn(Z(o, Xn("<div>").append(e).html())) : n ? Oa.clone.call(e) : e, 
                        r) for (var c in r) l.data("$" + c + "Controller", r[c].instance);
                        return C.$$addScopeInfo(l, t), n && n(l, t), s && s(t, l, l, i), l;
                    };
                }
                function E(e) {
                    var t = e && e[0];
                    return t && "foreignobject" !== j(t) && t.toString().match(/SVG/) ? "svg" : "html";
                }
                function H(e, t, a, i, r, s) {
                    function o(e, a, i, r) {
                        var s, o, u, l, c, d, f, m, g;
                        if (p) {
                            var _ = a.length;
                            for (g = new Array(_), c = 0; c < h.length; c += 3) f = h[c], g[f] = a[f];
                        } else g = a;
                        for (c = 0, d = h.length; c < d; ) u = g[h[c++]], s = h[c++], o = h[c++], s ? (s.scope ? (l = e.$new(), 
                        C.$$addScopeInfo(Xn(u), l)) : l = e, m = s.transcludeOnThisElement ? O(e, s.transclude, r, s.elementTranscludeOnThisElement) : !s.templateOnThisElement && r ? r : !r && t ? O(e, t) : null, 
                        s(o, l, u, i, m)) : o && o(e, u.childNodes, n, r);
                    }
                    for (var u, l, c, d, f, m, p, h = [], g = 0; g < e.length; g++) u = new se(), l = I(e[g], [], u, 0 === g ? i : n, r), 
                    c = l.length ? V(l, e[g], u, t, a, null, [], [], s) : null, c && c.scope && C.$$addScopeClass(u.$$element), 
                    f = c && c.terminal || !(d = e[g].childNodes) || !d.length ? null : H(d, c ? (c.transcludeOnThisElement || !c.templateOnThisElement) && c.transclude : t), 
                    (c || f) && (h.push(g, c, f), m = !0, p = p || c), s = null;
                    return m ? o : null;
                }
                function O(e, t, n, a) {
                    var i = function(a, i, r, s, o) {
                        return a || (a = e.$new(!1, o), a.$$transcluded = !0), t(a, i, {
                            parentBoundTranscludeFn: n,
                            transcludeControllers: r,
                            futureParentElement: s
                        });
                    };
                    return i;
                }
                function I(e, t, n, a, i) {
                    var r, s, o = e.nodeType, u = n.$attr;
                    switch (o) {
                      case _a:
                        q(t, Ze(j(e)), "E", a, i);
                        for (var d, f, m, p, h, g, _ = e.attributes, v = 0, M = _ && _.length; v < M; v++) {
                            var $ = !1, k = !1;
                            d = _[v], f = d.name, h = da(d.value), p = Ze(f), (g = de.test(p)) && (f = f.replace(Ga, "").substr(8).replace(/_(.)/g, function(e, t) {
                                return t.toUpperCase();
                            }));
                            var w = p.replace(/(Start|End)$/, "");
                            z(w) && p === w + "Start" && ($ = f, k = f.substr(0, f.length - 5) + "end", f = f.substr(0, f.length - 6)), 
                            m = Ze(f.toLowerCase()), u[m] = f, !g && n.hasOwnProperty(m) || (n[m] = h, Oe(e, m) && (n[m] = !0)), 
                            ee(e, t, h, m, g), q(t, m, "A", a, i, $, k);
                        }
                        if (s = e.className, b(s) && (s = s.animVal), y(s) && "" !== s) for (;r = c.exec(s); ) m = Ze(r[2]), 
                        q(t, m, "C", a, i) && (n[m] = da(r[3])), s = s.substr(r.index + r[0].length);
                        break;

                      case va:
                        Q(t, e.nodeValue);
                        break;

                      case ba:
                        try {
                            r = l.exec(e.nodeValue), r && (m = Ze(r[1]), q(t, m, "M", a, i) && (n[m] = da(r[2])));
                        } catch (e) {}
                    }
                    return t.sort(J), t;
                }
                function F(e, t, n) {
                    var a = [], i = 0;
                    if (t && e.hasAttribute && e.hasAttribute(t)) {
                        do {
                            if (!e) throw Ba("uterdir", "Unterminated attribute, found '{0}' but no matching '{1}' found.", t, n);
                            e.nodeType == _a && (e.hasAttribute(t) && i++, e.hasAttribute(n) && i--), a.push(e), 
                            e = e.nextSibling;
                        } while (i > 0);
                    } else a.push(e);
                    return Xn(a);
                }
                function N(e, t, n) {
                    return function(a, i, r, s, o) {
                        return i = F(i[0], t, n), e(a, i, r, s, o);
                    };
                }
                function V(e, s, o, u, l, c, d, f, m) {
                    function p(e, t, n, a) {
                        e && (n && (e = N(e, n, a)), e.require = L.require, e.directiveName = Y, (j === L || L.$$isolateScope) && (e = ae(e, {
                            isolateScope: !0
                        })), d.push(e)), t && (n && (t = N(t, n, a)), t.require = L.require, t.directiveName = Y, 
                        (j === L || L.$$isolateScope) && (t = ae(t, {
                            isolateScope: !0
                        })), f.push(t));
                    }
                    function h(e, t, n, a) {
                        var i, s, o = "data", u = !1, l = n;
                        if (y(t)) {
                            if (s = t.match(_), t = t.substring(s[0].length), s[3] && (s[1] ? s[3] = null : s[1] = s[3]), 
                            "^" === s[1] ? o = "inheritedData" : "^^" === s[1] && (o = "inheritedData", l = n.parent()), 
                            "?" === s[2] && (u = !0), i = null, a && "data" === o && (i = a[t]) && (i = i.instance), 
                            i = i || l[o]("$" + t + "Controller"), !i && !u) throw Ba("ctreq", "Controller '{0}', required by directive '{1}', can't be found!", t, e);
                            return i || null;
                        }
                        return ca(t) && (i = [], r(t, function(t) {
                            i.push(h(e, t, n, a));
                        })), i;
                    }
                    function M(e, t, i, u, l) {
                        function c(e, t, a) {
                            var i;
                            return D(e) || (a = t, t = e, e = n), z && (i = M), a || (a = z ? k.parent() : k), 
                            l(e, t, i, a, S);
                        }
                        var m, p, _, b, y, M, $, k, L;
                        if (s === i ? (L = o, k = o.$$element) : (k = Xn(i), L = new se(k, o)), j && (y = t.$new(!0)), 
                        l && ($ = c, $.$$boundTransclude = l), H && (w = {}, M = {}, r(H, function(e) {
                            var n, a = {
                                $scope: e === j || e.$$isolateScope ? y : t,
                                $element: k,
                                $attrs: L,
                                $transclude: $
                            };
                            b = e.controller, "@" == b && (b = L[e.name]), n = v(b, a, !0, e.controllerAs), 
                            M[e.name] = n, z || k.data("$" + e.name + "Controller", n.instance), w[e.name] = n;
                        })), j) {
                            C.$$addScopeInfo(k, y, !0, !(A && (A === j || A === j.$$originalDirective))), C.$$addScopeClass(k, !0);
                            var Y = w && w[j.name], T = y;
                            Y && Y.identifier && j.bindToController === !0 && (T = Y.instance), r(y.$$isolateBindings = j.$$isolateBindings, function(e, n) {
                                var i, r, s, o, u = e.attrName, l = e.optional, c = e.mode;
                                switch (c) {
                                  case "@":
                                    L.$observe(u, function(e) {
                                        T[n] = e;
                                    }), L.$$observers[u].$$scope = t, L[u] && (T[n] = a(L[u])(t));
                                    break;

                                  case "=":
                                    if (l && !L[u]) return;
                                    r = g(L[u]), o = r.literal ? P : function(e, t) {
                                        return e === t || e !== e && t !== t;
                                    }, s = r.assign || function() {
                                        throw i = T[n] = r(t), Ba("nonassign", "Expression '{0}' used with directive '{1}' is non-assignable!", L[u], j.name);
                                    }, i = T[n] = r(t);
                                    var d = function(e) {
                                        return o(e, T[n]) || (o(e, i) ? s(t, e = T[n]) : T[n] = e), i = e;
                                    };
                                    d.$stateful = !0;
                                    var f;
                                    f = e.collection ? t.$watchCollection(L[u], d) : t.$watch(g(L[u], d), null, r.literal), 
                                    y.$on("$destroy", f);
                                    break;

                                  case "&":
                                    r = g(L[u]), T[n] = function(e) {
                                        return r(t, e);
                                    };
                                }
                            });
                        }
                        for (w && (r(w, function(e) {
                            e();
                        }), w = null), m = 0, p = d.length; m < p; m++) _ = d[m], re(_, _.isolateScope ? y : t, k, L, _.require && h(_.directiveName, _.require, k, M), $);
                        var S = t;
                        for (j && (j.template || null === j.templateUrl) && (S = y), e && e(S, i.childNodes, n, l), 
                        m = f.length - 1; m >= 0; m--) _ = f[m], re(_, _.isolateScope ? y : t, k, L, _.require && h(_.directiveName, _.require, k, M), $);
                    }
                    m = m || {};
                    for (var $, w, L, Y, T, S, x, E = -Number.MAX_VALUE, H = m.controllerDirectives, j = m.newIsolateScopeDirective, A = m.templateDirective, O = m.nonTlbTranscludeDirective, V = !1, q = !1, z = m.hasElementTranscludeDirective, J = o.$$element = Xn(s), Q = c, X = u, ee = 0, ne = e.length; ee < ne; ee++) {
                        L = e[ee];
                        var ie = L.$$start, oe = L.$$end;
                        if (ie && (J = F(s, ie, oe)), T = n, E > L.priority) break;
                        if ((x = L.scope) && (L.templateUrl || (b(x) ? (K("new/isolated scope", j || $, L, J), 
                        j = L) : K("new/isolated scope", j, L, J)), $ = $ || L), Y = L.name, !L.templateUrl && L.controller && (x = L.controller, 
                        H = H || {}, K("'" + Y + "' controller", H[Y], L, J), H[Y] = L), (x = L.transclude) && (V = !0, 
                        L.$$tlb || (K("transclusion", O, L, J), O = L), "element" == x ? (z = !0, E = L.priority, 
                        T = J, J = o.$$element = Xn(t.createComment(" " + Y + ": " + o[Y] + " ")), s = J[0], 
                        te(l, U(T), s), X = C(T, u, E, Q && Q.name, {
                            nonTlbTranscludeDirective: O
                        })) : (T = Xn(Me(s)).contents(), J.empty(), X = C(T, u))), L.template) if (q = !0, 
                        K("template", A, L, J), A = L, x = k(L.template) ? L.template(J, o) : L.template, 
                        x = ce(x), L.replace) {
                            if (Q = L, T = ge(x) ? [] : et(Z(L.templateNamespace, da(x))), s = T[0], 1 != T.length || s.nodeType !== _a) throw Ba("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", Y, "");
                            te(l, J, s);
                            var ue = {
                                $attr: {}
                            }, le = I(s, [], ue), de = e.splice(ee + 1, e.length - (ee + 1));
                            j && W(le), e = e.concat(le).concat(de), B(o, ue), ne = e.length;
                        } else J.html(x);
                        if (L.templateUrl) q = !0, K("template", A, L, J), A = L, L.replace && (Q = L), 
                        M = G(e.splice(ee, e.length - ee), J, o, l, V && X, d, f, {
                            controllerDirectives: H,
                            newIsolateScopeDirective: j,
                            templateDirective: A,
                            nonTlbTranscludeDirective: O
                        }), ne = e.length; else if (L.compile) try {
                            S = L.compile(J, o, X), k(S) ? p(null, S, ie, oe) : S && p(S.pre, S.post, ie, oe);
                        } catch (e) {
                            i(e, R(J));
                        }
                        L.terminal && (M.terminal = !0, E = Math.max(E, L.priority));
                    }
                    return M.scope = $ && $.scope === !0, M.transcludeOnThisElement = V, M.elementTranscludeOnThisElement = z, 
                    M.templateOnThisElement = q, M.transclude = X, m.hasElementTranscludeDirective = z, 
                    M;
                }
                function W(e) {
                    for (var t = 0, n = e.length; t < n; t++) e[t] = m(e[t], {
                        $$isolateScope: !0
                    });
                }
                function q(t, a, r, u, l, c, d) {
                    if (a === l) return null;
                    var f = null;
                    if (s.hasOwnProperty(a)) for (var p, h = e.get(a + o), g = 0, _ = h.length; g < _; g++) try {
                        p = h[g], (u === n || u > p.priority) && p.restrict.indexOf(r) != -1 && (c && (p = m(p, {
                            $$start: c,
                            $$end: d
                        })), t.push(p), f = p);
                    } catch (e) {
                        i(e);
                    }
                    return f;
                }
                function z(t) {
                    if (s.hasOwnProperty(t)) for (var n, a = e.get(t + o), i = 0, r = a.length; i < r; i++) if (n = a[i], 
                    n.multiElement) return !0;
                    return !1;
                }
                function B(e, t) {
                    var n = t.$attr, a = e.$attr, i = e.$$element;
                    r(e, function(a, i) {
                        "$" != i.charAt(0) && (t[i] && t[i] !== a && (a += ("style" === i ? ";" : " ") + t[i]), 
                        e.$set(i, a, !0, n[i]));
                    }), r(t, function(t, r) {
                        "class" == r ? (x(i, t), e.class = (e.class ? e.class + " " : "") + t) : "style" == r ? (i.attr("style", i.attr("style") + ";" + t), 
                        e.style = (e.style ? e.style + ";" : "") + t) : "$" == r.charAt(0) || e.hasOwnProperty(r) || (e[r] = t, 
                        a[r] = n[r]);
                    });
                }
                function G(e, t, n, a, i, s, o, l) {
                    var c, d, f = [], p = t[0], h = e.shift(), g = m(h, {
                        templateUrl: null,
                        transclude: null,
                        replace: null,
                        $$originalDirective: h
                    }), _ = k(h.templateUrl) ? h.templateUrl(t, n) : h.templateUrl, v = h.templateNamespace;
                    return t.empty(), u(Y.getTrustedResourceUrl(_)).then(function(u) {
                        var m, y, M, $;
                        if (u = ce(u), h.replace) {
                            if (M = ge(u) ? [] : et(Z(v, da(u))), m = M[0], 1 != M.length || m.nodeType !== _a) throw Ba("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", h.name, _);
                            y = {
                                $attr: {}
                            }, te(a, t, m);
                            var k = I(m, [], y);
                            b(h.scope) && W(k), e = k.concat(e), B(n, y);
                        } else m = p, t.html(u);
                        for (e.unshift(g), c = V(e, m, n, i, t, h, s, o, l), r(a, function(e, n) {
                            e == m && (a[n] = t[0]);
                        }), d = H(t[0].childNodes, i); f.length; ) {
                            var w = f.shift(), L = f.shift(), D = f.shift(), Y = f.shift(), T = t[0];
                            if (!w.$$destroyed) {
                                if (L !== p) {
                                    var S = L.className;
                                    l.hasElementTranscludeDirective && h.replace || (T = Me(m)), te(D, Xn(L), T), x(Xn(T), S);
                                }
                                $ = c.transcludeOnThisElement ? O(w, c.transclude, Y) : Y, c(d, w, T, a, $);
                            }
                        }
                        f = null;
                    }), function(e, t, n, a, i) {
                        var r = i;
                        t.$$destroyed || (f ? f.push(t, n, a, r) : (c.transcludeOnThisElement && (r = O(t, c.transclude, i)), 
                        c(d, t, n, a, r)));
                    };
                }
                function J(e, t) {
                    var n = t.priority - e.priority;
                    return 0 !== n ? n : e.name !== t.name ? e.name < t.name ? -1 : 1 : e.index - t.index;
                }
                function K(e, t, n, a) {
                    if (t) throw Ba("multidir", "Multiple directives [{0}, {1}] asking for {2} on: {3}", t.name, n.name, e, R(a));
                }
                function Q(e, t) {
                    var n = a(t, !0);
                    n && e.push({
                        priority: 0,
                        compile: function(e) {
                            var t = e.parent(), a = !!t.length;
                            return a && C.$$addBindingClass(t), function(e, t) {
                                var i = t.parent();
                                a || C.$$addBindingClass(i), C.$$addBindingInfo(i, n.expressions), e.$watch(n, function(e) {
                                    t[0].nodeValue = e;
                                });
                            };
                        }
                    });
                }
                function Z(e, n) {
                    switch (e = Bn(e || "html")) {
                      case "svg":
                      case "math":
                        var a = t.createElement("div");
                        return a.innerHTML = "<" + e + ">" + n + "</" + e + ">", a.childNodes[0].childNodes;

                      default:
                        return n;
                    }
                }
                function X(e, t) {
                    if ("srcdoc" == t) return Y.HTML;
                    var n = j(e);
                    return "xlinkHref" == t || "form" == n && "action" == t || "img" != n && ("src" == t || "ngSrc" == t) ? Y.RESOURCE_URL : void 0;
                }
                function ee(e, t, n, i, r) {
                    var s = X(e, i);
                    r = f[i] || r;
                    var o = a(n, !0, s, r);
                    if (o) {
                        if ("multiple" === i && "select" === j(e)) throw Ba("selmulti", "Binding to the 'multiple' attribute is not supported. Element: {0}", R(e));
                        t.push({
                            priority: 100,
                            compile: function() {
                                return {
                                    pre: function(e, t, u) {
                                        var l = u.$$observers || (u.$$observers = {});
                                        if (M.test(i)) throw Ba("nodomevents", "Interpolations for HTML DOM event attributes are disallowed.  Please use the ng- versions (such as ng-click instead of onclick) instead.");
                                        var c = u[i];
                                        c !== n && (o = c && a(c, !0, s, r), n = c), o && (u[i] = o(e), (l[i] || (l[i] = [])).$$inter = !0, 
                                        (u.$$observers && u.$$observers[i].$$scope || e).$watch(o, function(e, t) {
                                            "class" === i && e != t ? u.$updateClass(e, t) : u.$set(i, e);
                                        }));
                                    }
                                };
                            }
                        });
                    }
                }
                function te(e, n, a) {
                    var i, r, s = n[0], o = n.length, u = s.parentNode;
                    if (e) for (i = 0, r = e.length; i < r; i++) if (e[i] == s) {
                        e[i++] = a;
                        for (var l = i, c = l + o - 1, d = e.length; l < d; l++, c++) c < d ? e[l] = e[c] : delete e[l];
                        e.length -= o - 1, e.context === s && (e.context = a);
                        break;
                    }
                    u && u.replaceChild(a, s);
                    var f = t.createDocumentFragment();
                    f.appendChild(s), Xn(a).data(Xn(s).data()), ea ? (la = !0, ea.cleanData([ s ])) : delete Xn.cache[s[Xn.expando]];
                    for (var m = 1, p = n.length; m < p; m++) {
                        var h = n[m];
                        Xn(h).remove(), f.appendChild(h), delete n[m];
                    }
                    n[0] = a, n.length = 1;
                }
                function ae(e, t) {
                    return d(function() {
                        return e.apply(null, arguments);
                    }, e, t);
                }
                function re(e, t, n, a, r, s) {
                    try {
                        e(t, n, a, r, s);
                    } catch (e) {
                        i(e, R(n));
                    }
                }
                var se = function(e, t) {
                    if (t) {
                        var n, a, i, r = Object.keys(t);
                        for (n = 0, a = r.length; n < a; n++) i = r[n], this[i] = t[i];
                    } else this.$attr = {};
                    this.$$element = e;
                };
                se.prototype = {
                    $normalize: Ze,
                    $addClass: function(e) {
                        e && e.length > 0 && T.addClass(this.$$element, e);
                    },
                    $removeClass: function(e) {
                        e && e.length > 0 && T.removeClass(this.$$element, e);
                    },
                    $updateClass: function(e, t) {
                        var n = Xe(e, t);
                        n && n.length && T.addClass(this.$$element, n);
                        var a = Xe(t, e);
                        a && a.length && T.removeClass(this.$$element, a);
                    },
                    $set: function(e, t, a, s) {
                        var o, u = this.$$element[0], l = Oe(u, e), c = Ie(u, e), d = e;
                        if (l ? (this.$$element.prop(e, t), s = l) : c && (this[c] = t, d = c), this[e] = t, 
                        s ? this.$attr[e] = s : (s = this.$attr[e], s || (this.$attr[e] = s = ne(e, "-"))), 
                        o = j(this.$$element), "a" === o && "href" === e || "img" === o && "src" === e) this[e] = t = S(t, "src" === e); else if ("img" === o && "srcset" === e) {
                            for (var f = "", m = da(t), p = /(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/, h = /\s/.test(m) ? p : /(,)/, g = m.split(h), _ = Math.floor(g.length / 2), v = 0; v < _; v++) {
                                var b = 2 * v;
                                f += S(da(g[b]), !0), f += " " + da(g[b + 1]);
                            }
                            var y = da(g[2 * v]).split(/\s/);
                            f += S(da(y[0]), !0), 2 === y.length && (f += " " + da(y[1])), this[e] = t = f;
                        }
                        a !== !1 && (null === t || t === n ? this.$$element.removeAttr(s) : this.$$element.attr(s, t));
                        var M = this.$$observers;
                        M && r(M[d], function(e) {
                            try {
                                e(t);
                            } catch (e) {
                                i(e);
                            }
                        });
                    },
                    $observe: function(e, t) {
                        var n = this, a = n.$$observers || (n.$$observers = le()), i = a[e] || (a[e] = []);
                        return i.push(t), w.$evalAsync(function() {
                            !i.$$inter && n.hasOwnProperty(e) && t(n[e]);
                        }), function() {
                            A(i, t);
                        };
                    }
                };
                var oe = a.startSymbol(), ue = a.endSymbol(), ce = "{{" == oe || "}}" == ue ? h : function(e) {
                    return e.replace(/\{\{/g, oe).replace(/}}/g, ue);
                }, de = /^ngAttr[A-Z]/;
                return C.$$addBindingInfo = $ ? function(e, t) {
                    var n = e.data("$binding") || [];
                    ca(t) ? n = n.concat(t) : n.push(t), e.data("$binding", n);
                } : p, C.$$addBindingClass = $ ? function(e) {
                    x(e, "ng-binding");
                } : p, C.$$addScopeInfo = $ ? function(e, t, n, a) {
                    var i = n ? a ? "$isolateScopeNoTemplate" : "$isolateScope" : "$scope";
                    e.data(i, t);
                } : p, C.$$addScopeClass = $ ? function(e, t) {
                    x(e, t ? "ng-isolate-scope" : "ng-scope");
                } : p, C;
            } ];
        }
        function Ze(e) {
            return he(e.replace(Ga, ""));
        }
        function Xe(e, t) {
            var n = "", a = e.split(/\s+/), i = t.split(/\s+/);
            e: for (var r = 0; r < a.length; r++) {
                for (var s = a[r], o = 0; o < i.length; o++) if (s == i[o]) continue e;
                n += (n.length > 0 ? " " : "") + s;
            }
            return n;
        }
        function et(e) {
            e = Xn(e);
            var t = e.length;
            if (t <= 1) return e;
            for (;t--; ) {
                var n = e[t];
                n.nodeType === ba && aa.call(e, t, 1);
            }
            return e;
        }
        function tt() {
            var e = {}, t = !1, i = /^(\S+)(\s+as\s+(\w+))?$/;
            this.register = function(t, n) {
                se(t, "controller"), b(t) ? d(e, t) : e[t] = n;
            }, this.allowGlobals = function() {
                t = !0;
            }, this.$get = [ "$injector", "$window", function(r, s) {
                function o(e, t, n, i) {
                    if (!e || !b(e.$scope)) throw a("$controller")("noscp", "Cannot export controller '{0}' as '{1}'! No $scope object provided via `locals`.", i, t);
                    e.$scope[t] = n;
                }
                return function(a, u, l, c) {
                    var f, m, p, h;
                    if (l = l === !0, c && y(c) && (h = c), y(a)) {
                        if (m = a.match(i), !m) throw Ja("ctrlfmt", "Badly formed controller string '{0}'. Must match `__name__ as __id__` or `__name__`.", a);
                        p = m[1], h = h || m[3], a = e.hasOwnProperty(p) ? e[p] : oe(u.$scope, p, !0) || (t ? oe(s, p, !0) : n), 
                        re(a, p, !0);
                    }
                    if (l) {
                        var g = (ca(a) ? a[a.length - 1] : a).prototype;
                        return f = Object.create(g || null), h && o(u, h, f, p || a.name), d(function() {
                            return r.invoke(a, f, u, p), f;
                        }, {
                            instance: f,
                            identifier: h
                        });
                    }
                    return f = r.instantiate(a, u, p), h && o(u, h, f, p || a.name), f;
                };
            } ];
        }
        function nt() {
            this.$get = [ "$window", function(e) {
                return Xn(e.document);
            } ];
        }
        function at() {
            this.$get = [ "$log", function(e) {
                return function(t, n) {
                    e.error.apply(e, arguments);
                };
            } ];
        }
        function it(e, t) {
            if (y(e)) {
                var n = e.replace(ei, "").trim();
                if (n) {
                    var a = t("Content-Type");
                    (a && 0 === a.indexOf(Ka) || rt(n)) && (e = q(n));
                }
            }
            return e;
        }
        function rt(e) {
            var t = e.match(Za);
            return t && Xa[t[0]].test(e);
        }
        function st(e) {
            var t, n, a, i = le();
            return e ? (r(e.split("\n"), function(e) {
                a = e.indexOf(":"), t = Bn(da(e.substr(0, a))), n = da(e.substr(a + 1)), t && (i[t] = i[t] ? i[t] + ", " + n : n);
            }), i) : i;
        }
        function ot(e) {
            var t = b(e) ? e : n;
            return function(n) {
                if (t || (t = st(e)), n) {
                    var a = t[Bn(n)];
                    return void 0 === a && (a = null), a;
                }
                return t;
            };
        }
        function ut(e, t, n, a) {
            return k(a) ? a(e, t, n) : (r(a, function(a) {
                e = a(e, t, n);
            }), e);
        }
        function lt(e) {
            return 200 <= e && e < 300;
        }
        function ct() {
            var e = this.defaults = {
                transformResponse: [ it ],
                transformRequest: [ function(e) {
                    return !b(e) || Y(e) || S(e) || T(e) ? e : W(e);
                } ],
                headers: {
                    common: {
                        Accept: "application/json, text/plain, */*"
                    },
                    post: I(Qa),
                    put: I(Qa),
                    patch: I(Qa)
                },
                xsrfCookieName: "XSRF-TOKEN",
                xsrfHeaderName: "X-XSRF-TOKEN"
            }, t = !1;
            this.useApplyAsync = function(e) {
                return v(e) ? (t = !!e, this) : t;
            };
            var i = this.interceptors = [];
            this.$get = [ "$httpBackend", "$browser", "$cacheFactory", "$rootScope", "$q", "$injector", function(s, u, l, c, f, m) {
                function p(t) {
                    function i(e) {
                        var t = d({}, e);
                        return e.data ? t.data = ut(e.data, e.headers, e.status, u.transformResponse) : t.data = e.data, 
                        lt(e.status) ? t : f.reject(t);
                    }
                    function s(e) {
                        var t, n = {};
                        return r(e, function(e, a) {
                            k(e) ? (t = e(), null != t && (n[a] = t)) : n[a] = e;
                        }), n;
                    }
                    function o(t) {
                        var n, a, i, r = e.headers, o = d({}, t.headers);
                        r = d({}, r.common, r[Bn(t.method)]);
                        e: for (n in r) {
                            a = Bn(n);
                            for (i in o) if (Bn(i) === a) continue e;
                            o[n] = r[n];
                        }
                        return s(o);
                    }
                    if (!oa.isObject(t)) throw a("$http")("badreq", "Http request configuration must be an object.  Received: {0}", t);
                    var u = d({
                        method: "get",
                        transformRequest: e.transformRequest,
                        transformResponse: e.transformResponse
                    }, t);
                    u.headers = o(t), u.method = Jn(u.method);
                    var l = function(t) {
                        var a = t.headers, s = ut(t.data, ot(a), n, t.transformRequest);
                        return _(s) && r(a, function(e, t) {
                            "content-type" === Bn(t) && delete a[t];
                        }), _(t.withCredentials) && !_(e.withCredentials) && (t.withCredentials = e.withCredentials), 
                        M(t, s).then(i, i);
                    }, c = [ l, n ], m = f.when(u);
                    for (r(D, function(e) {
                        (e.request || e.requestError) && c.unshift(e.request, e.requestError), (e.response || e.responseError) && c.push(e.response, e.responseError);
                    }); c.length; ) {
                        var p = c.shift(), h = c.shift();
                        m = m.then(p, h);
                    }
                    return m.success = function(e) {
                        return m.then(function(t) {
                            e(t.data, t.status, t.headers, u);
                        }), m;
                    }, m.error = function(e) {
                        return m.then(null, function(t) {
                            e(t.data, t.status, t.headers, u);
                        }), m;
                    }, m;
                }
                function h(e) {
                    r(arguments, function(e) {
                        p[e] = function(t, n) {
                            return p(d(n || {}, {
                                method: e,
                                url: t
                            }));
                        };
                    });
                }
                function g(e) {
                    r(arguments, function(e) {
                        p[e] = function(t, n, a) {
                            return p(d(a || {}, {
                                method: e,
                                url: t,
                                data: n
                            }));
                        };
                    });
                }
                function M(a, i) {
                    function r(e, n, a, i) {
                        function r() {
                            o(n, e, a, i);
                        }
                        m && (lt(e) ? m.put($, [ e, n, st(a), i ]) : m.remove($)), t ? c.$applyAsync(r) : (r(), 
                        c.$$phase || c.$apply());
                    }
                    function o(e, t, n, i) {
                        t = Math.max(t, 0), (lt(t) ? g.resolve : g.reject)({
                            data: e,
                            status: t,
                            headers: ot(n),
                            config: a,
                            statusText: i
                        });
                    }
                    function l(e) {
                        o(e.data, e.status, I(e.headers()), e.statusText);
                    }
                    function d() {
                        var e = p.pendingRequests.indexOf(a);
                        e !== -1 && p.pendingRequests.splice(e, 1);
                    }
                    var m, h, g = f.defer(), y = g.promise, M = a.headers, $ = w(a.url, a.params);
                    if (p.pendingRequests.push(a), y.then(d, d), !a.cache && !e.cache || a.cache === !1 || "GET" !== a.method && "JSONP" !== a.method || (m = b(a.cache) ? a.cache : b(e.cache) ? e.cache : L), 
                    m && (h = m.get($), v(h) ? C(h) ? h.then(l, l) : ca(h) ? o(h[1], h[0], I(h[2]), h[3]) : o(h, 200, {}, "OK") : m.put($, y)), 
                    _(h)) {
                        var k = rn(a.url) ? u.cookies()[a.xsrfCookieName || e.xsrfCookieName] : n;
                        k && (M[a.xsrfHeaderName || e.xsrfHeaderName] = k), s(a.method, $, i, r, M, a.timeout, a.withCredentials, a.responseType);
                    }
                    return y;
                }
                function w(e, t) {
                    if (!t) return e;
                    var n = [];
                    return o(t, function(e, t) {
                        null === e || _(e) || (ca(e) || (e = [ e ]), r(e, function(e) {
                            b(e) && (e = $(e) ? e.toISOString() : W(e)), n.push(K(t) + "=" + K(e));
                        }));
                    }), n.length > 0 && (e += (e.indexOf("?") == -1 ? "?" : "&") + n.join("&")), e;
                }
                var L = l("$http"), D = [];
                return r(i, function(e) {
                    D.unshift(y(e) ? m.get(e) : m.invoke(e));
                }), p.pendingRequests = [], h("get", "delete", "head", "jsonp"), g("post", "put", "patch"), 
                p.defaults = e, p;
            } ];
        }
        function dt() {
            return new e.XMLHttpRequest();
        }
        function ft() {
            this.$get = [ "$browser", "$window", "$document", function(e, t, n) {
                return mt(e, dt, e.defer, t.angular.callbacks, n[0]);
            } ];
        }
        function mt(e, t, a, i, s) {
            function o(e, t, n) {
                var a = s.createElement("script"), r = null;
                return a.type = "text/javascript", a.src = e, a.async = !0, r = function(e) {
                    Da(a, "load", r), Da(a, "error", r), s.body.removeChild(a), a = null;
                    var o = -1, u = "unknown";
                    e && ("load" !== e.type || i[t].called || (e = {
                        type: "error"
                    }), u = e.type, o = "error" === e.type ? 404 : 200), n && n(o, u);
                }, La(a, "load", r), La(a, "error", r), s.body.appendChild(a), r;
            }
            return function(s, u, l, c, d, f, m, h) {
                function g() {
                    y && y(), M && M.abort();
                }
                function _(t, i, r, s, o) {
                    k !== n && a.cancel(k), y = M = null, t(i, r, s, o), e.$$completeOutstandingRequest(p);
                }
                if (e.$$incOutstandingRequestCount(), u = u || e.url(), "jsonp" == Bn(s)) {
                    var b = "_" + (i.counter++).toString(36);
                    i[b] = function(e) {
                        i[b].data = e, i[b].called = !0;
                    };
                    var y = o(u.replace("JSON_CALLBACK", "angular.callbacks." + b), b, function(e, t) {
                        _(c, e, i[b].data, "", t), i[b] = p;
                    });
                } else {
                    var M = t();
                    M.open(s, u, !0), r(d, function(e, t) {
                        v(e) && M.setRequestHeader(t, e);
                    }), M.onload = function() {
                        var e = M.statusText || "", t = "response" in M ? M.response : M.responseText, n = 1223 === M.status ? 204 : M.status;
                        0 === n && (n = t ? 200 : "file" == an(u).protocol ? 404 : 0), _(c, n, t, M.getAllResponseHeaders(), e);
                    };
                    var $ = function() {
                        _(c, -1, null, null, "");
                    };
                    if (M.onerror = $, M.onabort = $, m && (M.withCredentials = !0), h) try {
                        M.responseType = h;
                    } catch (e) {
                        if ("json" !== h) throw e;
                    }
                    M.send(l || null);
                }
                if (f > 0) var k = a(g, f); else C(f) && f.then(g);
            };
        }
        function pt() {
            var e = "{{", t = "}}";
            this.startSymbol = function(t) {
                return t ? (e = t, this) : e;
            }, this.endSymbol = function(e) {
                return e ? (t = e, this) : t;
            }, this.$get = [ "$parse", "$exceptionHandler", "$sce", function(n, a, i) {
                function r(e) {
                    return "\\\\\\" + e;
                }
                function s(r, s, f, m) {
                    function p(n) {
                        return n.replace(l, e).replace(c, t);
                    }
                    function h(e) {
                        try {
                            return e = S(e), m && !v(e) ? e : x(e);
                        } catch (e) {
                            var t = ti("interr", "Can't interpolate: {0}\n{1}", r, e.toString());
                            a(t);
                        }
                    }
                    m = !!m;
                    for (var g, b, y, M = 0, $ = [], w = [], L = r.length, D = [], Y = []; M < L; ) {
                        if ((g = r.indexOf(e, M)) == -1 || (b = r.indexOf(t, g + o)) == -1) {
                            M !== L && D.push(p(r.substring(M)));
                            break;
                        }
                        M !== g && D.push(p(r.substring(M, g))), y = r.substring(g + o, b), $.push(y), w.push(n(y, h)), 
                        M = b + u, Y.push(D.length), D.push("");
                    }
                    if (f && D.length > 1) throw ti("noconcat", "Error while interpolating: {0}\nStrict Contextual Escaping disallows interpolations that concatenate multiple expressions when a trusted value is required.  See http://docs.angularjs.org/api/ng.$sce", r);
                    if (!s || $.length) {
                        var T = function(e) {
                            for (var t = 0, n = $.length; t < n; t++) {
                                if (m && _(e[t])) return;
                                D[Y[t]] = e[t];
                            }
                            return D.join("");
                        }, S = function(e) {
                            return f ? i.getTrusted(f, e) : i.valueOf(e);
                        }, x = function(e) {
                            if (null == e) return "";
                            switch (typeof e) {
                              case "string":
                                break;

                              case "number":
                                e = "" + e;
                                break;

                              default:
                                e = W(e);
                            }
                            return e;
                        };
                        return d(function(e) {
                            var t = 0, n = $.length, i = new Array(n);
                            try {
                                for (;t < n; t++) i[t] = w[t](e);
                                return T(i);
                            } catch (e) {
                                var s = ti("interr", "Can't interpolate: {0}\n{1}", r, e.toString());
                                a(s);
                            }
                        }, {
                            exp: r,
                            expressions: $,
                            $$watchDelegate: function(e, t, n) {
                                var a;
                                return e.$watchGroup(w, function(n, i) {
                                    var r = T(n);
                                    k(t) && t.call(this, r, n !== i ? a : r, e), a = r;
                                }, n);
                            }
                        });
                    }
                }
                var o = e.length, u = t.length, l = new RegExp(e.replace(/./g, r), "g"), c = new RegExp(t.replace(/./g, r), "g");
                return s.startSymbol = function() {
                    return e;
                }, s.endSymbol = function() {
                    return t;
                }, s;
            } ];
        }
        function ht() {
            this.$get = [ "$rootScope", "$window", "$q", "$$q", function(e, t, n, a) {
                function i(i, s, o, u) {
                    var l = t.setInterval, c = t.clearInterval, d = 0, f = v(u) && !u, m = (f ? a : n).defer(), p = m.promise;
                    return o = v(o) ? o : 0, p.then(null, null, i), p.$$intervalId = l(function() {
                        m.notify(d++), o > 0 && d >= o && (m.resolve(d), c(p.$$intervalId), delete r[p.$$intervalId]), 
                        f || e.$apply();
                    }, s), r[p.$$intervalId] = m, p;
                }
                var r = {};
                return i.cancel = function(e) {
                    return !!(e && e.$$intervalId in r) && (r[e.$$intervalId].reject("canceled"), t.clearInterval(e.$$intervalId), 
                    delete r[e.$$intervalId], !0);
                }, i;
            } ];
        }
        function gt() {
            this.$get = function() {
                return {
                    id: "en-us",
                    NUMBER_FORMATS: {
                        DECIMAL_SEP: ".",
                        GROUP_SEP: ",",
                        PATTERNS: [ {
                            minInt: 1,
                            minFrac: 0,
                            maxFrac: 3,
                            posPre: "",
                            posSuf: "",
                            negPre: "-",
                            negSuf: "",
                            gSize: 3,
                            lgSize: 3
                        }, {
                            minInt: 1,
                            minFrac: 2,
                            maxFrac: 2,
                            posPre: "¤",
                            posSuf: "",
                            negPre: "(¤",
                            negSuf: ")",
                            gSize: 3,
                            lgSize: 3
                        } ],
                        CURRENCY_SYM: "$"
                    },
                    DATETIME_FORMATS: {
                        MONTH: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
                        SHORTMONTH: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
                        DAY: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
                        SHORTDAY: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(","),
                        AMPMS: [ "AM", "PM" ],
                        medium: "MMM d, y h:mm:ss a",
                        short: "M/d/yy h:mm a",
                        fullDate: "EEEE, MMMM d, y",
                        longDate: "MMMM d, y",
                        mediumDate: "MMM d, y",
                        shortDate: "M/d/yy",
                        mediumTime: "h:mm:ss a",
                        shortTime: "h:mm a"
                    },
                    pluralCat: function(e) {
                        return 1 === e ? "one" : "other";
                    }
                };
            };
        }
        function _t(e) {
            for (var t = e.split("/"), n = t.length; n--; ) t[n] = J(t[n]);
            return t.join("/");
        }
        function vt(e, t) {
            var n = an(e);
            t.$$protocol = n.protocol, t.$$host = n.hostname, t.$$port = f(n.port) || ai[n.protocol] || null;
        }
        function bt(e, t) {
            var n = "/" !== e.charAt(0);
            n && (e = "/" + e);
            var a = an(e);
            t.$$path = decodeURIComponent(n && "/" === a.pathname.charAt(0) ? a.pathname.substring(1) : a.pathname), 
            t.$$search = B(a.search), t.$$hash = decodeURIComponent(a.hash), t.$$path && "/" != t.$$path.charAt(0) && (t.$$path = "/" + t.$$path);
        }
        function yt(e, t) {
            if (0 === t.indexOf(e)) return t.substr(e.length);
        }
        function Mt(e) {
            var t = e.indexOf("#");
            return t == -1 ? e : e.substr(0, t);
        }
        function $t(e) {
            return e.replace(/(#.+)|#$/, "$1");
        }
        function kt(e) {
            return e.substr(0, Mt(e).lastIndexOf("/") + 1);
        }
        function wt(e) {
            return e.substring(0, e.indexOf("/", e.indexOf("//") + 2));
        }
        function Lt(e, t) {
            this.$$html5 = !0, t = t || "";
            var a = kt(e);
            vt(e, this), this.$$parse = function(e) {
                var t = yt(a, e);
                if (!y(t)) throw ii("ipthprfx", 'Invalid url "{0}", missing path prefix "{1}".', e, a);
                bt(t, this), this.$$path || (this.$$path = "/"), this.$$compose();
            }, this.$$compose = function() {
                var e = G(this.$$search), t = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (e ? "?" + e : "") + t, this.$$absUrl = a + this.$$url.substr(1);
            }, this.$$parseLinkUrl = function(i, r) {
                if (r && "#" === r[0]) return this.hash(r.slice(1)), !0;
                var s, o, u;
                return (s = yt(e, i)) !== n ? (o = s, u = (s = yt(t, s)) !== n ? a + (yt("/", s) || s) : e + o) : (s = yt(a, i)) !== n ? u = a + s : a == i + "/" && (u = a), 
                u && this.$$parse(u), !!u;
            };
        }
        function Dt(e, t) {
            var n = kt(e);
            vt(e, this), this.$$parse = function(a) {
                function i(e, t, n) {
                    var a, i = /^\/[A-Z]:(\/.*)/;
                    return 0 === t.indexOf(n) && (t = t.replace(n, "")), i.exec(t) ? e : (a = i.exec(e), 
                    a ? a[1] : e);
                }
                var r, s = yt(e, a) || yt(n, a);
                "#" === s.charAt(0) ? (r = yt(t, s), _(r) && (r = s)) : r = this.$$html5 ? s : "", 
                bt(r, this), this.$$path = i(this.$$path, r, e), this.$$compose();
            }, this.$$compose = function() {
                var n = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (n ? "?" + n : "") + a, this.$$absUrl = e + (this.$$url ? t + this.$$url : "");
            }, this.$$parseLinkUrl = function(t, n) {
                return Mt(e) == Mt(t) && (this.$$parse(t), !0);
            };
        }
        function Yt(e, t) {
            this.$$html5 = !0, Dt.apply(this, arguments);
            var n = kt(e);
            this.$$parseLinkUrl = function(a, i) {
                if (i && "#" === i[0]) return this.hash(i.slice(1)), !0;
                var r, s;
                return e == Mt(a) ? r = a : (s = yt(n, a)) ? r = e + t + s : n === a + "/" && (r = n), 
                r && this.$$parse(r), !!r;
            }, this.$$compose = function() {
                var n = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (n ? "?" + n : "") + a, this.$$absUrl = e + t + this.$$url;
            };
        }
        function Tt(e) {
            return function() {
                return this[e];
            };
        }
        function St(e, t) {
            return function(n) {
                return _(n) ? this[e] : (this[e] = t(n), this.$$compose(), this);
            };
        }
        function xt() {
            var e = "", t = {
                enabled: !1,
                requireBase: !0,
                rewriteLinks: !0
            };
            this.hashPrefix = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.html5Mode = function(e) {
                return x(e) ? (t.enabled = e, this) : b(e) ? (x(e.enabled) && (t.enabled = e.enabled), 
                x(e.requireBase) && (t.requireBase = e.requireBase), x(e.rewriteLinks) && (t.rewriteLinks = e.rewriteLinks), 
                this) : t;
            }, this.$get = [ "$rootScope", "$browser", "$sniffer", "$rootElement", "$window", function(n, a, i, r, s) {
                function o(e, t, n) {
                    var i = l.url(), r = l.$$state;
                    try {
                        a.url(e, t, n), l.$$state = a.state();
                    } catch (e) {
                        throw l.url(i), l.$$state = r, e;
                    }
                }
                function u(e, t) {
                    n.$broadcast("$locationChangeSuccess", l.absUrl(), e, l.$$state, t);
                }
                var l, c, d, f = a.baseHref(), m = a.url();
                if (t.enabled) {
                    if (!f && t.requireBase) throw ii("nobase", "$location in HTML5 mode requires a <base> tag to be present!");
                    d = wt(m) + (f || "/"), c = i.history ? Lt : Yt;
                } else d = Mt(m), c = Dt;
                l = new c(d, "#" + e), l.$$parseLinkUrl(m, m), l.$$state = a.state();
                var p = /^\s*(javascript|mailto):/i;
                r.on("click", function(e) {
                    if (t.rewriteLinks && !e.ctrlKey && !e.metaKey && !e.shiftKey && 2 != e.which && 2 != e.button) {
                        for (var i = Xn(e.target); "a" !== j(i[0]); ) if (i[0] === r[0] || !(i = i.parent())[0]) return;
                        var o = i.prop("href"), u = i.attr("href") || i.attr("xlink:href");
                        b(o) && "[object SVGAnimatedString]" === o.toString() && (o = an(o.animVal).href), 
                        p.test(o) || !o || i.attr("target") || e.isDefaultPrevented() || l.$$parseLinkUrl(o, u) && (e.preventDefault(), 
                        l.absUrl() != a.url() && (n.$apply(), s.angular["ff-684208-preventDefault"] = !0));
                    }
                }), $t(l.absUrl()) != $t(m) && a.url(l.absUrl(), !0);
                var h = !0;
                return a.onUrlChange(function(e, t) {
                    n.$evalAsync(function() {
                        var a, i = l.absUrl(), r = l.$$state;
                        l.$$parse(e), l.$$state = t, a = n.$broadcast("$locationChangeStart", e, i, t, r).defaultPrevented, 
                        l.absUrl() === e && (a ? (l.$$parse(i), l.$$state = r, o(i, !1, r)) : (h = !1, u(i, r)));
                    }), n.$$phase || n.$digest();
                }), n.$watch(function() {
                    var e = $t(a.url()), t = $t(l.absUrl()), r = a.state(), s = l.$$replace, c = e !== t || l.$$html5 && i.history && r !== l.$$state;
                    (h || c) && (h = !1, n.$evalAsync(function() {
                        var t = l.absUrl(), a = n.$broadcast("$locationChangeStart", t, e, l.$$state, r).defaultPrevented;
                        l.absUrl() === t && (a ? (l.$$parse(e), l.$$state = r) : (c && o(t, s, r === l.$$state ? null : l.$$state), 
                        u(e, r)));
                    })), l.$$replace = !1;
                }), l;
            } ];
        }
        function Ct() {
            var e = !0, t = this;
            this.debugEnabled = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.$get = [ "$window", function(n) {
                function a(e) {
                    return e instanceof Error && (e.stack ? e = e.message && e.stack.indexOf(e.message) === -1 ? "Error: " + e.message + "\n" + e.stack : e.stack : e.sourceURL && (e = e.message + "\n" + e.sourceURL + ":" + e.line)), 
                    e;
                }
                function i(e) {
                    var t = n.console || {}, i = t[e] || t.log || p, s = !1;
                    try {
                        s = !!i.apply;
                    } catch (e) {}
                    return s ? function() {
                        var e = [];
                        return r(arguments, function(t) {
                            e.push(a(t));
                        }), i.apply(t, e);
                    } : function(e, t) {
                        i(e, null == t ? "" : t);
                    };
                }
                return {
                    log: i("log"),
                    info: i("info"),
                    warn: i("warn"),
                    error: i("error"),
                    debug: function() {
                        var n = i("debug");
                        return function() {
                            e && n.apply(t, arguments);
                        };
                    }()
                };
            } ];
        }
        function Et(e, t) {
            if ("__defineGetter__" === e || "__defineSetter__" === e || "__lookupGetter__" === e || "__lookupSetter__" === e || "__proto__" === e) throw si("isecfld", "Attempting to access a disallowed field in Angular expressions! Expression: {0}", t);
            return e;
        }
        function Ht(e, t) {
            if (e) {
                if (e.constructor === e) throw si("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e.window === e) throw si("isecwindow", "Referencing the Window in Angular expressions is disallowed! Expression: {0}", t);
                if (e.children && (e.nodeName || e.prop && e.attr && e.find)) throw si("isecdom", "Referencing DOM nodes in Angular expressions is disallowed! Expression: {0}", t);
                if (e === Object) throw si("isecobj", "Referencing Object in Angular expressions is disallowed! Expression: {0}", t);
            }
            return e;
        }
        function jt(e, t) {
            if (e) {
                if (e.constructor === e) throw si("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e === oi || e === ui || e === li) throw si("isecff", "Referencing call, apply or bind in Angular expressions is disallowed! Expression: {0}", t);
            }
        }
        function At(e) {
            return e.constant;
        }
        function Ot(e, t, n, a, i) {
            Ht(e, i), Ht(t, i);
            for (var r, s = n.split("."), o = 0; s.length > 1; o++) {
                r = Et(s.shift(), i);
                var u = 0 === o && t && t[r] || e[r];
                u || (u = {}, e[r] = u), e = Ht(u, i);
            }
            return r = Et(s.shift(), i), Ht(e[r], i), e[r] = a, a;
        }
        function It(e) {
            return "constructor" == e;
        }
        function Pt(e, t, a, i, r, s, o) {
            Et(e, s), Et(t, s), Et(a, s), Et(i, s), Et(r, s);
            var u = function(e) {
                return Ht(e, s);
            }, l = o || It(e) ? u : h, c = o || It(t) ? u : h, d = o || It(a) ? u : h, f = o || It(i) ? u : h, m = o || It(r) ? u : h;
            return function(s, o) {
                var u = o && o.hasOwnProperty(e) ? o : s;
                return null == u ? u : (u = l(u[e]), t ? null == u ? n : (u = c(u[t]), a ? null == u ? n : (u = d(u[a]), 
                i ? null == u ? n : (u = f(u[i]), r ? null == u ? n : u = m(u[r]) : u) : u) : u) : u);
            };
        }
        function Ft(e, t) {
            return function(n, a) {
                return e(n, a, Ht, t);
            };
        }
        function Ut(e, t, a) {
            var i = t.expensiveChecks, s = i ? gi : hi, o = s[e];
            if (o) return o;
            var u = e.split("."), l = u.length;
            if (t.csp) o = l < 6 ? Pt(u[0], u[1], u[2], u[3], u[4], a, i) : function(e, t) {
                var r, s = 0;
                do r = Pt(u[s++], u[s++], u[s++], u[s++], u[s++], a, i)(e, t), t = n, e = r; while (s < l);
                return r;
            }; else {
                var c = "";
                i && (c += "s = eso(s, fe);\nl = eso(l, fe);\n");
                var d = i;
                r(u, function(e, t) {
                    Et(e, a);
                    var n = (t ? "s" : '((l&&l.hasOwnProperty("' + e + '"))?l:s)') + "." + e;
                    (i || It(e)) && (n = "eso(" + n + ", fe)", d = !0), c += "if(s == null) return undefined;\ns=" + n + ";\n";
                }), c += "return s;";
                var f = new Function("s", "l", "eso", "fe", c);
                f.toString = g(c), d && (f = Ft(f, a)), o = f;
            }
            return o.sharedGetter = !0, o.assign = function(t, n, a) {
                return Ot(t, a, e, n, e);
            }, s[e] = o, o;
        }
        function Nt(e) {
            return k(e.valueOf) ? e.valueOf() : _i.call(e);
        }
        function Vt() {
            var e = le(), t = le();
            this.$get = [ "$filter", "$sniffer", function(n, a) {
                function i(e) {
                    var t = e;
                    return e.sharedGetter && (t = function(t, n) {
                        return e(t, n);
                    }, t.literal = e.literal, t.constant = e.constant, t.assign = e.assign), t;
                }
                function s(e, t) {
                    for (var n = 0, a = e.length; n < a; n++) {
                        var i = e[n];
                        i.constant || (i.inputs ? s(i.inputs, t) : t.indexOf(i) === -1 && t.push(i));
                    }
                    return t;
                }
                function o(e, t) {
                    return null == e || null == t ? e === t : ("object" != typeof e || (e = Nt(e), "object" != typeof e)) && (e === t || e !== e && t !== t);
                }
                function u(e, t, n, a) {
                    var i, r = a.$$inputs || (a.$$inputs = s(a.inputs, []));
                    if (1 === r.length) {
                        var u = o;
                        return r = r[0], e.$watch(function(e) {
                            var t = r(e);
                            return o(t, u) || (i = a(e), u = t && Nt(t)), i;
                        }, t, n);
                    }
                    for (var l = [], c = 0, d = r.length; c < d; c++) l[c] = o;
                    return e.$watch(function(e) {
                        for (var t = !1, n = 0, s = r.length; n < s; n++) {
                            var u = r[n](e);
                            (t || (t = !o(u, l[n]))) && (l[n] = u && Nt(u));
                        }
                        return t && (i = a(e)), i;
                    }, t, n);
                }
                function l(e, t, n, a) {
                    var i, r;
                    return i = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        r = e, k(t) && t.apply(this, arguments), v(e) && a.$$postDigest(function() {
                            v(r) && i();
                        });
                    }, n);
                }
                function c(e, t, n, a) {
                    function i(e) {
                        var t = !0;
                        return r(e, function(e) {
                            v(e) || (t = !1);
                        }), t;
                    }
                    var s, o;
                    return s = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        o = e, k(t) && t.call(this, e, n, a), i(e) && a.$$postDigest(function() {
                            i(o) && s();
                        });
                    }, n);
                }
                function d(e, t, n, a) {
                    var i;
                    return i = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        k(t) && t.apply(this, arguments), i();
                    }, n);
                }
                function f(e, t) {
                    if (!t) return e;
                    var n = e.$$watchDelegate, a = n !== c && n !== l, i = a ? function(n, a) {
                        var i = e(n, a);
                        return t(i, n, a);
                    } : function(n, a) {
                        var i = e(n, a), r = t(i, n, a);
                        return v(i) ? r : i;
                    };
                    return e.$$watchDelegate && e.$$watchDelegate !== u ? i.$$watchDelegate = e.$$watchDelegate : t.$stateful || (i.$$watchDelegate = u, 
                    i.inputs = [ e ]), i;
                }
                var m = {
                    csp: a.csp,
                    expensiveChecks: !1
                }, h = {
                    csp: a.csp,
                    expensiveChecks: !0
                };
                return function(a, r, s) {
                    var o, g, _;
                    switch (typeof a) {
                      case "string":
                        _ = a = a.trim();
                        var v = s ? t : e;
                        if (o = v[_], !o) {
                            ":" === a.charAt(0) && ":" === a.charAt(1) && (g = !0, a = a.substring(2));
                            var b = s ? h : m, y = new mi(b), M = new pi(y, n, b);
                            o = M.parse(a), o.constant ? o.$$watchDelegate = d : g ? (o = i(o), o.$$watchDelegate = o.literal ? c : l) : o.inputs && (o.$$watchDelegate = u), 
                            v[_] = o;
                        }
                        return f(o, r);

                      case "function":
                        return f(a, r);

                      default:
                        return f(p, r);
                    }
                };
            } ];
        }
        function Wt() {
            this.$get = [ "$rootScope", "$exceptionHandler", function(e, t) {
                return Rt(function(t) {
                    e.$evalAsync(t);
                }, t);
            } ];
        }
        function qt() {
            this.$get = [ "$browser", "$exceptionHandler", function(e, t) {
                return Rt(function(t) {
                    e.defer(t);
                }, t);
            } ];
        }
        function Rt(e, t) {
            function i(e, t, n) {
                function a(t) {
                    return function(n) {
                        i || (i = !0, t.call(e, n));
                    };
                }
                var i = !1;
                return [ a(t), a(n) ];
            }
            function s() {
                this.$$state = {
                    status: 0
                };
            }
            function o(e, t) {
                return function(n) {
                    t.call(e, n);
                };
            }
            function u(e) {
                var a, i, r;
                r = e.pending, e.processScheduled = !1, e.pending = n;
                for (var s = 0, o = r.length; s < o; ++s) {
                    i = r[s][0], a = r[s][e.status];
                    try {
                        k(a) ? i.resolve(a(e.value)) : 1 === e.status ? i.resolve(e.value) : i.reject(e.value);
                    } catch (e) {
                        i.reject(e), t(e);
                    }
                }
            }
            function l(t) {
                !t.processScheduled && t.pending && (t.processScheduled = !0, e(function() {
                    u(t);
                }));
            }
            function c() {
                this.promise = new s(), this.resolve = o(this, this.resolve), this.reject = o(this, this.reject), 
                this.notify = o(this, this.notify);
            }
            function d(e) {
                var t = new c(), n = 0, a = ca(e) ? [] : {};
                return r(e, function(e, i) {
                    n++, _(e).then(function(e) {
                        a.hasOwnProperty(i) || (a[i] = e, --n || t.resolve(a));
                    }, function(e) {
                        a.hasOwnProperty(i) || t.reject(e);
                    });
                }), 0 === n && t.resolve(a), t.promise;
            }
            var f = a("$q", TypeError), m = function() {
                return new c();
            };
            s.prototype = {
                then: function(e, t, n) {
                    var a = new c();
                    return this.$$state.pending = this.$$state.pending || [], this.$$state.pending.push([ a, e, t, n ]), 
                    this.$$state.status > 0 && l(this.$$state), a.promise;
                },
                catch: function(e) {
                    return this.then(null, e);
                },
                finally: function(e, t) {
                    return this.then(function(t) {
                        return g(t, !0, e);
                    }, function(t) {
                        return g(t, !1, e);
                    }, t);
                }
            }, c.prototype = {
                resolve: function(e) {
                    this.promise.$$state.status || (e === this.promise ? this.$$reject(f("qcycle", "Expected promise to be resolved with value other than itself '{0}'", e)) : this.$$resolve(e));
                },
                $$resolve: function(e) {
                    var n, a;
                    a = i(this, this.$$resolve, this.$$reject);
                    try {
                        (b(e) || k(e)) && (n = e && e.then), k(n) ? (this.promise.$$state.status = -1, n.call(e, a[0], a[1], this.notify)) : (this.promise.$$state.value = e, 
                        this.promise.$$state.status = 1, l(this.promise.$$state));
                    } catch (e) {
                        a[1](e), t(e);
                    }
                },
                reject: function(e) {
                    this.promise.$$state.status || this.$$reject(e);
                },
                $$reject: function(e) {
                    this.promise.$$state.value = e, this.promise.$$state.status = 2, l(this.promise.$$state);
                },
                notify: function(n) {
                    var a = this.promise.$$state.pending;
                    this.promise.$$state.status <= 0 && a && a.length && e(function() {
                        for (var e, i, r = 0, s = a.length; r < s; r++) {
                            i = a[r][0], e = a[r][3];
                            try {
                                i.notify(k(e) ? e(n) : n);
                            } catch (e) {
                                t(e);
                            }
                        }
                    });
                }
            };
            var p = function(e) {
                var t = new c();
                return t.reject(e), t.promise;
            }, h = function(e, t) {
                var n = new c();
                return t ? n.resolve(e) : n.reject(e), n.promise;
            }, g = function(e, t, n) {
                var a = null;
                try {
                    k(n) && (a = n());
                } catch (e) {
                    return h(e, !1);
                }
                return C(a) ? a.then(function() {
                    return h(e, t);
                }, function(e) {
                    return h(e, !1);
                }) : h(e, t);
            }, _ = function(e, t, n, a) {
                var i = new c();
                return i.resolve(e), i.promise.then(t, n, a);
            }, v = function e(t) {
                function n(e) {
                    i.resolve(e);
                }
                function a(e) {
                    i.reject(e);
                }
                if (!k(t)) throw f("norslvr", "Expected resolverFn, got '{0}'", t);
                if (!(this instanceof e)) return new e(t);
                var i = new c();
                return t(n, a), i.promise;
            };
            return v.defer = m, v.reject = p, v.when = _, v.all = d, v;
        }
        function zt() {
            this.$get = [ "$window", "$timeout", function(e, t) {
                var n = e.requestAnimationFrame || e.webkitRequestAnimationFrame, a = e.cancelAnimationFrame || e.webkitCancelAnimationFrame || e.webkitCancelRequestAnimationFrame, i = !!n, r = i ? function(e) {
                    var t = n(e);
                    return function() {
                        a(t);
                    };
                } : function(e) {
                    var n = t(e, 16.66, !1);
                    return function() {
                        t.cancel(n);
                    };
                };
                return r.supported = i, r;
            } ];
        }
        function Bt() {
            var e = 10, t = a("$rootScope"), n = null, s = null;
            this.digestTtl = function(t) {
                return arguments.length && (e = t), e;
            }, this.$get = [ "$injector", "$exceptionHandler", "$parse", "$browser", function(a, o, u, c) {
                function d() {
                    this.$id = l(), this.$$phase = this.$parent = this.$$watchers = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = null, 
                    this.$root = this, this.$$destroyed = !1, this.$$listeners = {}, this.$$listenerCount = {}, 
                    this.$$isolateBindings = null;
                }
                function f(e) {
                    if (M.$$phase) throw t("inprog", "{0} already in progress", M.$$phase);
                    M.$$phase = e;
                }
                function m() {
                    M.$$phase = null;
                }
                function h(e, t, n) {
                    do e.$$listenerCount[n] -= t, 0 === e.$$listenerCount[n] && delete e.$$listenerCount[n]; while (e = e.$parent);
                }
                function g() {}
                function v() {
                    for (;L.length; ) try {
                        L.shift()();
                    } catch (e) {
                        o(e);
                    }
                    s = null;
                }
                function y() {
                    null === s && (s = c.defer(function() {
                        M.$apply(v);
                    }));
                }
                d.prototype = {
                    constructor: d,
                    $new: function(e, t) {
                        function n() {
                            a.$$destroyed = !0;
                        }
                        var a;
                        return t = t || this, e ? (a = new d(), a.$root = this.$root) : (this.$$ChildScope || (this.$$ChildScope = function() {
                            this.$$watchers = this.$$nextSibling = this.$$childHead = this.$$childTail = null, 
                            this.$$listeners = {}, this.$$listenerCount = {}, this.$id = l(), this.$$ChildScope = null;
                        }, this.$$ChildScope.prototype = this), a = new this.$$ChildScope()), a.$parent = t, 
                        a.$$prevSibling = t.$$childTail, t.$$childHead ? (t.$$childTail.$$nextSibling = a, 
                        t.$$childTail = a) : t.$$childHead = t.$$childTail = a, (e || t != this) && a.$on("$destroy", n), 
                        a;
                    },
                    $watch: function(e, t, a) {
                        var i = u(e);
                        if (i.$$watchDelegate) return i.$$watchDelegate(this, t, a, i);
                        var r = this, s = r.$$watchers, o = {
                            fn: t,
                            last: g,
                            get: i,
                            exp: e,
                            eq: !!a
                        };
                        return n = null, k(t) || (o.fn = p), s || (s = r.$$watchers = []), s.unshift(o), 
                        function() {
                            A(s, o), n = null;
                        };
                    },
                    $watchGroup: function(e, t) {
                        function n() {
                            u = !1, l ? (l = !1, t(i, i, o)) : t(i, a, o);
                        }
                        var a = new Array(e.length), i = new Array(e.length), s = [], o = this, u = !1, l = !0;
                        if (!e.length) {
                            var c = !0;
                            return o.$evalAsync(function() {
                                c && t(i, i, o);
                            }), function() {
                                c = !1;
                            };
                        }
                        return 1 === e.length ? this.$watch(e[0], function(e, n, r) {
                            i[0] = e, a[0] = n, t(i, e === n ? i : a, r);
                        }) : (r(e, function(e, t) {
                            var r = o.$watch(e, function(e, r) {
                                i[t] = e, a[t] = r, u || (u = !0, o.$evalAsync(n));
                            });
                            s.push(r);
                        }), function() {
                            for (;s.length; ) s.shift()();
                        });
                    },
                    $watchCollection: function(e, t) {
                        function n(e) {
                            r = e;
                            var t, n, a, o, u;
                            if (!_(r)) {
                                if (b(r)) if (i(r)) {
                                    s !== m && (s = m, g = s.length = 0, d++), t = r.length, g !== t && (d++, s.length = g = t);
                                    for (var l = 0; l < t; l++) u = s[l], o = r[l], a = u !== u && o !== o, a || u === o || (d++, 
                                    s[l] = o);
                                } else {
                                    s !== p && (s = p = {}, g = 0, d++), t = 0;
                                    for (n in r) r.hasOwnProperty(n) && (t++, o = r[n], u = s[n], n in s ? (a = u !== u && o !== o, 
                                    a || u === o || (d++, s[n] = o)) : (g++, s[n] = o, d++));
                                    if (g > t) {
                                        d++;
                                        for (n in s) r.hasOwnProperty(n) || (g--, delete s[n]);
                                    }
                                } else s !== r && (s = r, d++);
                                return d;
                            }
                        }
                        function a() {
                            if (h ? (h = !1, t(r, r, l)) : t(r, o, l), c) if (b(r)) if (i(r)) {
                                o = new Array(r.length);
                                for (var e = 0; e < r.length; e++) o[e] = r[e];
                            } else {
                                o = {};
                                for (var n in r) Gn.call(r, n) && (o[n] = r[n]);
                            } else o = r;
                        }
                        n.$stateful = !0;
                        var r, s, o, l = this, c = t.length > 1, d = 0, f = u(e, n), m = [], p = {}, h = !0, g = 0;
                        return this.$watch(f, a);
                    },
                    $digest: function() {
                        var a, i, r, u, l, d, p, h, _, b, y = e, L = this, D = [];
                        f("$digest"), c.$$checkUrlChange(), this === M && null !== s && (c.defer.cancel(s), 
                        v()), n = null;
                        do {
                            for (d = !1, h = L; $.length; ) {
                                try {
                                    b = $.shift(), b.scope.$eval(b.expression, b.locals);
                                } catch (e) {
                                    o(e);
                                }
                                n = null;
                            }
                            e: do {
                                if (u = h.$$watchers) for (l = u.length; l--; ) try {
                                    if (a = u[l]) if ((i = a.get(h)) === (r = a.last) || (a.eq ? P(i, r) : "number" == typeof i && "number" == typeof r && isNaN(i) && isNaN(r))) {
                                        if (a === n) {
                                            d = !1;
                                            break e;
                                        }
                                    } else d = !0, n = a, a.last = a.eq ? O(i, null) : i, a.fn(i, r === g ? i : r, h), 
                                    y < 5 && (_ = 4 - y, D[_] || (D[_] = []), D[_].push({
                                        msg: k(a.exp) ? "fn: " + (a.exp.name || a.exp.toString()) : a.exp,
                                        newVal: i,
                                        oldVal: r
                                    }));
                                } catch (e) {
                                    o(e);
                                }
                                if (!(p = h.$$childHead || h !== L && h.$$nextSibling)) for (;h !== L && !(p = h.$$nextSibling); ) h = h.$parent;
                            } while (h = p);
                            if ((d || $.length) && !y--) throw m(), t("infdig", "{0} $digest() iterations reached. Aborting!\nWatchers fired in the last 5 iterations: {1}", e, D);
                        } while (d || $.length);
                        for (m(); w.length; ) try {
                            w.shift()();
                        } catch (e) {
                            o(e);
                        }
                    },
                    $destroy: function() {
                        if (!this.$$destroyed) {
                            var e = this.$parent;
                            if (this.$broadcast("$destroy"), this.$$destroyed = !0, this !== M) {
                                for (var t in this.$$listenerCount) h(this, this.$$listenerCount[t], t);
                                e.$$childHead == this && (e.$$childHead = this.$$nextSibling), e.$$childTail == this && (e.$$childTail = this.$$prevSibling), 
                                this.$$prevSibling && (this.$$prevSibling.$$nextSibling = this.$$nextSibling), this.$$nextSibling && (this.$$nextSibling.$$prevSibling = this.$$prevSibling), 
                                this.$destroy = this.$digest = this.$apply = this.$evalAsync = this.$applyAsync = p, 
                                this.$on = this.$watch = this.$watchGroup = function() {
                                    return p;
                                }, this.$$listeners = {}, this.$parent = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = this.$root = this.$$watchers = null;
                            }
                        }
                    },
                    $eval: function(e, t) {
                        return u(e)(this, t);
                    },
                    $evalAsync: function(e, t) {
                        M.$$phase || $.length || c.defer(function() {
                            $.length && M.$digest();
                        }), $.push({
                            scope: this,
                            expression: e,
                            locals: t
                        });
                    },
                    $$postDigest: function(e) {
                        w.push(e);
                    },
                    $apply: function(e) {
                        try {
                            return f("$apply"), this.$eval(e);
                        } catch (e) {
                            o(e);
                        } finally {
                            m();
                            try {
                                M.$digest();
                            } catch (e) {
                                throw o(e), e;
                            }
                        }
                    },
                    $applyAsync: function(e) {
                        function t() {
                            n.$eval(e);
                        }
                        var n = this;
                        e && L.push(t), y();
                    },
                    $on: function(e, t) {
                        var n = this.$$listeners[e];
                        n || (this.$$listeners[e] = n = []), n.push(t);
                        var a = this;
                        do a.$$listenerCount[e] || (a.$$listenerCount[e] = 0), a.$$listenerCount[e]++; while (a = a.$parent);
                        var i = this;
                        return function() {
                            var a = n.indexOf(t);
                            a !== -1 && (n[a] = null, h(i, 1, e));
                        };
                    },
                    $emit: function(e, t) {
                        var n, a, i, r = [], s = this, u = !1, l = {
                            name: e,
                            targetScope: s,
                            stopPropagation: function() {
                                u = !0;
                            },
                            preventDefault: function() {
                                l.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        }, c = F([ l ], arguments, 1);
                        do {
                            for (n = s.$$listeners[e] || r, l.currentScope = s, a = 0, i = n.length; a < i; a++) if (n[a]) try {
                                n[a].apply(null, c);
                            } catch (e) {
                                o(e);
                            } else n.splice(a, 1), a--, i--;
                            if (u) return l.currentScope = null, l;
                            s = s.$parent;
                        } while (s);
                        return l.currentScope = null, l;
                    },
                    $broadcast: function(e, t) {
                        var n = this, a = n, i = n, r = {
                            name: e,
                            targetScope: n,
                            preventDefault: function() {
                                r.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        };
                        if (!n.$$listenerCount[e]) return r;
                        for (var s, u, l, c = F([ r ], arguments, 1); a = i; ) {
                            for (r.currentScope = a, s = a.$$listeners[e] || [], u = 0, l = s.length; u < l; u++) if (s[u]) try {
                                s[u].apply(null, c);
                            } catch (e) {
                                o(e);
                            } else s.splice(u, 1), u--, l--;
                            if (!(i = a.$$listenerCount[e] && a.$$childHead || a !== n && a.$$nextSibling)) for (;a !== n && !(i = a.$$nextSibling); ) a = a.$parent;
                        }
                        return r.currentScope = null, r;
                    }
                };
                var M = new d(), $ = M.$$asyncQueue = [], w = M.$$postDigestQueue = [], L = M.$$applyAsyncQueue = [];
                return M;
            } ];
        }
        function Gt() {
            var e = /^\s*(https?|ftp|mailto|tel|file):/, t = /^\s*((https?|ftp|file|blob):|data:image\/)/;
            this.aHrefSanitizationWhitelist = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (t = e, this) : t;
            }, this.$get = function() {
                return function(n, a) {
                    var i, r = a ? t : e;
                    return i = an(n).href, "" === i || i.match(r) ? n : "unsafe:" + i;
                };
            };
        }
        function Jt(e) {
            if ("self" === e) return e;
            if (y(e)) {
                if (e.indexOf("***") > -1) throw vi("iwcard", "Illegal sequence *** in string matcher.  String: {0}", e);
                return e = fa(e).replace("\\*\\*", ".*").replace("\\*", "[^:/.?&;]*"), new RegExp("^" + e + "$");
            }
            if (w(e)) return new RegExp("^" + e.source + "$");
            throw vi("imatcher", 'Matchers may only be "self", string patterns or RegExp objects');
        }
        function Kt(e) {
            var t = [];
            return v(e) && r(e, function(e) {
                t.push(Jt(e));
            }), t;
        }
        function Qt() {
            this.SCE_CONTEXTS = bi;
            var e = [ "self" ], t = [];
            this.resourceUrlWhitelist = function(t) {
                return arguments.length && (e = Kt(t)), e;
            }, this.resourceUrlBlacklist = function(e) {
                return arguments.length && (t = Kt(e)), t;
            }, this.$get = [ "$injector", function(a) {
                function i(e, t) {
                    return "self" === e ? rn(t) : !!e.exec(t.href);
                }
                function r(n) {
                    var a, r, s = an(n.toString()), o = !1;
                    for (a = 0, r = e.length; a < r; a++) if (i(e[a], s)) {
                        o = !0;
                        break;
                    }
                    if (o) for (a = 0, r = t.length; a < r; a++) if (i(t[a], s)) {
                        o = !1;
                        break;
                    }
                    return o;
                }
                function s(e) {
                    var t = function(e) {
                        this.$$unwrapTrustedValue = function() {
                            return e;
                        };
                    };
                    return e && (t.prototype = new e()), t.prototype.valueOf = function() {
                        return this.$$unwrapTrustedValue();
                    }, t.prototype.toString = function() {
                        return this.$$unwrapTrustedValue().toString();
                    }, t;
                }
                function o(e, t) {
                    var a = f.hasOwnProperty(e) ? f[e] : null;
                    if (!a) throw vi("icontext", "Attempted to trust a value in invalid context. Context: {0}; Value: {1}", e, t);
                    if (null === t || t === n || "" === t) return t;
                    if ("string" != typeof t) throw vi("itype", "Attempted to trust a non-string value in a content requiring a string: Context: {0}", e);
                    return new a(t);
                }
                function u(e) {
                    return e instanceof d ? e.$$unwrapTrustedValue() : e;
                }
                function l(e, t) {
                    if (null === t || t === n || "" === t) return t;
                    var a = f.hasOwnProperty(e) ? f[e] : null;
                    if (a && t instanceof a) return t.$$unwrapTrustedValue();
                    if (e === bi.RESOURCE_URL) {
                        if (r(t)) return t;
                        throw vi("insecurl", "Blocked loading resource from url not allowed by $sceDelegate policy.  URL: {0}", t.toString());
                    }
                    if (e === bi.HTML) return c(t);
                    throw vi("unsafe", "Attempting to use an unsafe value in a safe context.");
                }
                var c = function(e) {
                    throw vi("unsafe", "Attempting to use an unsafe value in a safe context.");
                };
                a.has("$sanitize") && (c = a.get("$sanitize"));
                var d = s(), f = {};
                return f[bi.HTML] = s(d), f[bi.CSS] = s(d), f[bi.URL] = s(d), f[bi.JS] = s(d), f[bi.RESOURCE_URL] = s(f[bi.URL]), 
                {
                    trustAs: o,
                    getTrusted: l,
                    valueOf: u
                };
            } ];
        }
        function Zt() {
            var e = !0;
            this.enabled = function(t) {
                return arguments.length && (e = !!t), e;
            }, this.$get = [ "$parse", "$sceDelegate", function(t, n) {
                if (e && Zn < 8) throw vi("iequirks", "Strict Contextual Escaping does not support Internet Explorer version < 11 in quirks mode.  You can fix this by adding the text <!doctype html> to the top of your HTML document.  See http://docs.angularjs.org/api/ng.$sce for more information.");
                var a = I(bi);
                a.isEnabled = function() {
                    return e;
                }, a.trustAs = n.trustAs, a.getTrusted = n.getTrusted, a.valueOf = n.valueOf, e || (a.trustAs = a.getTrusted = function(e, t) {
                    return t;
                }, a.valueOf = h), a.parseAs = function(e, n) {
                    var i = t(n);
                    return i.literal && i.constant ? i : t(n, function(t) {
                        return a.getTrusted(e, t);
                    });
                };
                var i = a.parseAs, s = a.getTrusted, o = a.trustAs;
                return r(bi, function(e, t) {
                    var n = Bn(t);
                    a[he("parse_as_" + n)] = function(t) {
                        return i(e, t);
                    }, a[he("get_trusted_" + n)] = function(t) {
                        return s(e, t);
                    }, a[he("trust_as_" + n)] = function(t) {
                        return o(e, t);
                    };
                }), a;
            } ];
        }
        function Xt() {
            this.$get = [ "$window", "$document", function(e, t) {
                var n, a, i = {}, r = f((/android (\d+)/.exec(Bn((e.navigator || {}).userAgent)) || [])[1]), s = /Boxee/i.test((e.navigator || {}).userAgent), o = t[0] || {}, u = /^(Moz|webkit|ms)(?=[A-Z])/, l = o.body && o.body.style, c = !1, d = !1;
                if (l) {
                    for (var m in l) if (a = u.exec(m)) {
                        n = a[0], n = n.substr(0, 1).toUpperCase() + n.substr(1);
                        break;
                    }
                    n || (n = "WebkitOpacity" in l && "webkit"), c = !!("transition" in l || n + "Transition" in l), 
                    d = !!("animation" in l || n + "Animation" in l), !r || c && d || (c = y(o.body.style.webkitTransition), 
                    d = y(o.body.style.webkitAnimation));
                }
                return {
                    history: !(!e.history || !e.history.pushState || r < 4 || s),
                    hasEvent: function(e) {
                        if ("input" === e && Zn <= 11) return !1;
                        if (_(i[e])) {
                            var t = o.createElement("div");
                            i[e] = "on" + e in t;
                        }
                        return i[e];
                    },
                    csp: ma(),
                    vendorPrefix: n,
                    transitions: c,
                    animations: d,
                    android: r
                };
            } ];
        }
        function en() {
            this.$get = [ "$templateCache", "$http", "$q", function(e, t, n) {
                function a(i, r) {
                    function s(e) {
                        if (!r) throw Ba("tpload", "Failed to load template: {0}", i);
                        return n.reject(e);
                    }
                    a.totalPendingRequests++;
                    var o = t.defaults && t.defaults.transformResponse;
                    ca(o) ? o = o.filter(function(e) {
                        return e !== it;
                    }) : o === it && (o = null);
                    var u = {
                        cache: e,
                        transformResponse: o
                    };
                    return t.get(i, u).finally(function() {
                        a.totalPendingRequests--;
                    }).then(function(e) {
                        return e.data;
                    }, s);
                }
                return a.totalPendingRequests = 0, a;
            } ];
        }
        function tn() {
            this.$get = [ "$rootScope", "$browser", "$location", function(e, t, n) {
                var a = {};
                return a.findBindings = function(e, t, n) {
                    var a = e.getElementsByClassName("ng-binding"), i = [];
                    return r(a, function(e) {
                        var a = oa.element(e).data("$binding");
                        a && r(a, function(a) {
                            if (n) {
                                var r = new RegExp("(^|\\s)" + fa(t) + "(\\s|\\||$)");
                                r.test(a) && i.push(e);
                            } else a.indexOf(t) != -1 && i.push(e);
                        });
                    }), i;
                }, a.findModels = function(e, t, n) {
                    for (var a = [ "ng-", "data-ng-", "ng\\:" ], i = 0; i < a.length; ++i) {
                        var r = n ? "=" : "*=", s = "[" + a[i] + "model" + r + '"' + t + '"]', o = e.querySelectorAll(s);
                        if (o.length) return o;
                    }
                }, a.getLocation = function() {
                    return n.url();
                }, a.setLocation = function(t) {
                    t !== n.url() && (n.url(t), e.$digest());
                }, a.whenStable = function(e) {
                    t.notifyWhenNoOutstandingRequests(e);
                }, a;
            } ];
        }
        function nn() {
            this.$get = [ "$rootScope", "$browser", "$q", "$$q", "$exceptionHandler", function(e, t, n, a, i) {
                function r(r, o, u) {
                    var l, c = v(u) && !u, d = (c ? a : n).defer(), f = d.promise;
                    return l = t.defer(function() {
                        try {
                            d.resolve(r());
                        } catch (e) {
                            d.reject(e), i(e);
                        } finally {
                            delete s[f.$$timeoutId];
                        }
                        c || e.$apply();
                    }, o), f.$$timeoutId = l, s[l] = d, f;
                }
                var s = {};
                return r.cancel = function(e) {
                    return !!(e && e.$$timeoutId in s) && (s[e.$$timeoutId].reject("canceled"), delete s[e.$$timeoutId], 
                    t.defer.cancel(e.$$timeoutId));
                }, r;
            } ];
        }
        function an(e) {
            var t = e;
            return Zn && (yi.setAttribute("href", t), t = yi.href), yi.setAttribute("href", t), 
            {
                href: yi.href,
                protocol: yi.protocol ? yi.protocol.replace(/:$/, "") : "",
                host: yi.host,
                search: yi.search ? yi.search.replace(/^\?/, "") : "",
                hash: yi.hash ? yi.hash.replace(/^#/, "") : "",
                hostname: yi.hostname,
                port: yi.port,
                pathname: "/" === yi.pathname.charAt(0) ? yi.pathname : "/" + yi.pathname
            };
        }
        function rn(e) {
            var t = y(e) ? an(e) : e;
            return t.protocol === Mi.protocol && t.host === Mi.host;
        }
        function sn() {
            this.$get = g(e);
        }
        function on(e) {
            function t(a, i) {
                if (b(a)) {
                    var s = {};
                    return r(a, function(e, n) {
                        s[n] = t(n, e);
                    }), s;
                }
                return e.factory(a + n, i);
            }
            var n = "Filter";
            this.register = t, this.$get = [ "$injector", function(e) {
                return function(t) {
                    return e.get(t + n);
                };
            } ], t("currency", dn), t("date", $n), t("filter", un), t("json", kn), t("limitTo", wn), 
            t("lowercase", Di), t("number", fn), t("orderBy", Ln), t("uppercase", Yi);
        }
        function un() {
            return function(e, t, n) {
                if (!ca(e)) return e;
                var a, i;
                switch (typeof t) {
                  case "function":
                    a = t;
                    break;

                  case "boolean":
                  case "number":
                  case "string":
                    i = !0;

                  case "object":
                    a = ln(t, n, i);
                    break;

                  default:
                    return e;
                }
                return e.filter(a);
            };
        }
        function ln(e, t, n) {
            var a, i = b(e) && "$" in e;
            return t === !0 ? t = P : k(t) || (t = function(e, t) {
                return !b(e) && !b(t) && (e = Bn("" + e), t = Bn("" + t), e.indexOf(t) !== -1);
            }), a = function(a) {
                return i && !b(a) ? cn(a, e.$, t, !1) : cn(a, e, t, n);
            };
        }
        function cn(e, t, n, a, i) {
            var r = typeof e, s = typeof t;
            if ("string" === s && "!" === t.charAt(0)) return !cn(e, t.substring(1), n, a);
            if (ca(e)) return e.some(function(e) {
                return cn(e, t, n, a);
            });
            switch (r) {
              case "object":
                var o;
                if (a) {
                    for (o in e) if ("$" !== o.charAt(0) && cn(e[o], t, n, !0)) return !0;
                    return !i && cn(e, t, n, !1);
                }
                if ("object" === s) {
                    for (o in t) {
                        var u = t[o];
                        if (!k(u)) {
                            var l = "$" === o, c = l ? e : e[o];
                            if (!cn(c, u, n, l, l)) return !1;
                        }
                    }
                    return !0;
                }
                return n(e, t);

              case "function":
                return !1;

              default:
                return n(e, t);
            }
        }
        function dn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n, a) {
                return _(n) && (n = t.CURRENCY_SYM), _(a) && (a = t.PATTERNS[1].maxFrac), null == e ? e : mn(e, t.PATTERNS[1], t.GROUP_SEP, t.DECIMAL_SEP, a).replace(/\u00A4/g, n);
            };
        }
        function fn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n) {
                return null == e ? e : mn(e, t.PATTERNS[0], t.GROUP_SEP, t.DECIMAL_SEP, n);
            };
        }
        function mn(e, t, n, a, i) {
            if (!isFinite(e) || b(e)) return "";
            var r = e < 0;
            e = Math.abs(e);
            var s = e + "", o = "", u = [], l = !1;
            if (s.indexOf("e") !== -1) {
                var c = s.match(/([\d\.]+)e(-?)(\d+)/);
                c && "-" == c[2] && c[3] > i + 1 ? e = 0 : (o = s, l = !0);
            }
            if (l) i > 0 && e < 1 && (o = e.toFixed(i), e = parseFloat(o)); else {
                var d = (s.split($i)[1] || "").length;
                _(i) && (i = Math.min(Math.max(t.minFrac, d), t.maxFrac)), e = +(Math.round(+(e.toString() + "e" + i)).toString() + "e" + -i);
                var f = ("" + e).split($i), m = f[0];
                f = f[1] || "";
                var p, h = 0, g = t.lgSize, v = t.gSize;
                if (m.length >= g + v) for (h = m.length - g, p = 0; p < h; p++) (h - p) % v === 0 && 0 !== p && (o += n), 
                o += m.charAt(p);
                for (p = h; p < m.length; p++) (m.length - p) % g === 0 && 0 !== p && (o += n), 
                o += m.charAt(p);
                for (;f.length < i; ) f += "0";
                i && "0" !== i && (o += a + f.substr(0, i));
            }
            return 0 === e && (r = !1), u.push(r ? t.negPre : t.posPre, o, r ? t.negSuf : t.posSuf), 
            u.join("");
        }
        function pn(e, t, n) {
            var a = "";
            for (e < 0 && (a = "-", e = -e), e = "" + e; e.length < t; ) e = "0" + e;
            return n && (e = e.substr(e.length - t)), a + e;
        }
        function hn(e, t, n, a) {
            return n = n || 0, function(i) {
                var r = i["get" + e]();
                return (n > 0 || r > -n) && (r += n), 0 === r && n == -12 && (r = 12), pn(r, t, a);
            };
        }
        function gn(e, t) {
            return function(n, a) {
                var i = n["get" + e](), r = Jn(t ? "SHORT" + e : e);
                return a[r][i];
            };
        }
        function _n(e) {
            var t = -1 * e.getTimezoneOffset(), n = t >= 0 ? "+" : "";
            return n += pn(Math[t > 0 ? "floor" : "ceil"](t / 60), 2) + pn(Math.abs(t % 60), 2);
        }
        function vn(e) {
            var t = new Date(e, 0, 1).getDay();
            return new Date(e, 0, (t <= 4 ? 5 : 12) - t);
        }
        function bn(e) {
            return new Date(e.getFullYear(), e.getMonth(), e.getDate() + (4 - e.getDay()));
        }
        function yn(e) {
            return function(t) {
                var n = vn(t.getFullYear()), a = bn(t), i = +a - +n, r = 1 + Math.round(i / 6048e5);
                return pn(r, e);
            };
        }
        function Mn(e, t) {
            return e.getHours() < 12 ? t.AMPMS[0] : t.AMPMS[1];
        }
        function $n(e) {
            function t(e) {
                var t;
                if (t = e.match(n)) {
                    var a = new Date(0), i = 0, r = 0, s = t[8] ? a.setUTCFullYear : a.setFullYear, o = t[8] ? a.setUTCHours : a.setHours;
                    t[9] && (i = f(t[9] + t[10]), r = f(t[9] + t[11])), s.call(a, f(t[1]), f(t[2]) - 1, f(t[3]));
                    var u = f(t[4] || 0) - i, l = f(t[5] || 0) - r, c = f(t[6] || 0), d = Math.round(1e3 * parseFloat("0." + (t[7] || 0)));
                    return o.call(a, u, l, c, d), a;
                }
                return e;
            }
            var n = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;
            return function(n, a, i) {
                var s, o, u = "", l = [];
                if (a = a || "mediumDate", a = e.DATETIME_FORMATS[a] || a, y(n) && (n = Li.test(n) ? f(n) : t(n)), 
                M(n) && (n = new Date(n)), !$(n)) return n;
                for (;a; ) o = wi.exec(a), o ? (l = F(l, o, 1), a = l.pop()) : (l.push(a), a = null);
                return i && "UTC" === i && (n = new Date(n.getTime()), n.setMinutes(n.getMinutes() + n.getTimezoneOffset())), 
                r(l, function(t) {
                    s = ki[t], u += s ? s(n, e.DATETIME_FORMATS) : t.replace(/(^'|'$)/g, "").replace(/''/g, "'");
                }), u;
            };
        }
        function kn() {
            return function(e, t) {
                return _(t) && (t = 2), W(e, t);
            };
        }
        function wn() {
            return function(e, t) {
                return M(e) && (e = e.toString()), ca(e) || y(e) ? (t = Math.abs(Number(t)) === 1 / 0 ? Number(t) : f(t), 
                t ? t > 0 ? e.slice(0, t) : e.slice(t) : y(e) ? "" : []) : e;
            };
        }
        function Ln(e) {
            return function(t, n, a) {
                function r(e, t) {
                    for (var a = 0; a < n.length; a++) {
                        var i = n[a](e, t);
                        if (0 !== i) return i;
                    }
                    return 0;
                }
                function s(e, t) {
                    return t ? function(t, n) {
                        return e(n, t);
                    } : e;
                }
                function o(e) {
                    switch (typeof e) {
                      case "number":
                      case "boolean":
                      case "string":
                        return !0;

                      default:
                        return !1;
                    }
                }
                function u(e) {
                    return null === e ? "null" : "function" == typeof e.valueOf && (e = e.valueOf(), 
                    o(e)) ? e : "function" == typeof e.toString && (e = e.toString(), o(e)) ? e : "";
                }
                function l(e, t) {
                    var n = typeof e, a = typeof t;
                    return n === a && "object" === n && (e = u(e), t = u(t)), n === a ? ("string" === n && (e = e.toLowerCase(), 
                    t = t.toLowerCase()), e === t ? 0 : e < t ? -1 : 1) : n < a ? -1 : 1;
                }
                return i(t) ? (n = ca(n) ? n : [ n ], 0 === n.length && (n = [ "+" ]), n = n.map(function(t) {
                    var n = !1, a = t || h;
                    if (y(t)) {
                        if ("+" != t.charAt(0) && "-" != t.charAt(0) || (n = "-" == t.charAt(0), t = t.substring(1)), 
                        "" === t) return s(l, n);
                        if (a = e(t), a.constant) {
                            var i = a();
                            return s(function(e, t) {
                                return l(e[i], t[i]);
                            }, n);
                        }
                    }
                    return s(function(e, t) {
                        return l(a(e), a(t));
                    }, n);
                }), na.call(t).sort(s(r, a))) : t;
            };
        }
        function Dn(e) {
            return k(e) && (e = {
                link: e
            }), e.restrict = e.restrict || "AC", g(e);
        }
        function Yn(e, t) {
            e.$name = t;
        }
        function Tn(e, t, a, i, s) {
            var o = this, u = [], l = o.$$parentForm = e.parent().controller("form") || xi;
            o.$error = {}, o.$$success = {}, o.$pending = n, o.$name = s(t.name || t.ngForm || "")(a), 
            o.$dirty = !1, o.$pristine = !0, o.$valid = !0, o.$invalid = !1, o.$submitted = !1, 
            l.$addControl(o), o.$rollbackViewValue = function() {
                r(u, function(e) {
                    e.$rollbackViewValue();
                });
            }, o.$commitViewValue = function() {
                r(u, function(e) {
                    e.$commitViewValue();
                });
            }, o.$addControl = function(e) {
                se(e.$name, "input"), u.push(e), e.$name && (o[e.$name] = e);
            }, o.$$renameControl = function(e, t) {
                var n = e.$name;
                o[n] === e && delete o[n], o[t] = e, e.$name = t;
            }, o.$removeControl = function(e) {
                e.$name && o[e.$name] === e && delete o[e.$name], r(o.$pending, function(t, n) {
                    o.$setValidity(n, null, e);
                }), r(o.$error, function(t, n) {
                    o.$setValidity(n, null, e);
                }), r(o.$$success, function(t, n) {
                    o.$setValidity(n, null, e);
                }), A(u, e);
            }, Wn({
                ctrl: this,
                $element: e,
                set: function(e, t, n) {
                    var a = e[t];
                    if (a) {
                        var i = a.indexOf(n);
                        i === -1 && a.push(n);
                    } else e[t] = [ n ];
                },
                unset: function(e, t, n) {
                    var a = e[t];
                    a && (A(a, n), 0 === a.length && delete e[t]);
                },
                parentForm: l,
                $animate: i
            }), o.$setDirty = function() {
                i.removeClass(e, fr), i.addClass(e, mr), o.$dirty = !0, o.$pristine = !1, l.$setDirty();
            }, o.$setPristine = function() {
                i.setClass(e, fr, mr + " " + Ci), o.$dirty = !1, o.$pristine = !0, o.$submitted = !1, 
                r(u, function(e) {
                    e.$setPristine();
                });
            }, o.$setUntouched = function() {
                r(u, function(e) {
                    e.$setUntouched();
                });
            }, o.$setSubmitted = function() {
                i.addClass(e, Ci), o.$submitted = !0, l.$setSubmitted();
            };
        }
        function Sn(e) {
            e.$formatters.push(function(t) {
                return e.$isEmpty(t) ? t : t.toString();
            });
        }
        function xn(e, t, n, a, i, r) {
            Cn(e, t, n, a, i, r), Sn(a);
        }
        function Cn(e, t, n, a, i, r) {
            var s = Bn(t[0].type);
            if (!i.android) {
                var o = !1;
                t.on("compositionstart", function(e) {
                    o = !0;
                }), t.on("compositionend", function() {
                    o = !1, u();
                });
            }
            var u = function(e) {
                if (l && (r.defer.cancel(l), l = null), !o) {
                    var i = t.val(), u = e && e.type;
                    "password" === s || n.ngTrim && "false" === n.ngTrim || (i = da(i)), (a.$viewValue !== i || "" === i && a.$$hasNativeValidators) && a.$setViewValue(i, u);
                }
            };
            if (i.hasEvent("input")) t.on("input", u); else {
                var l, c = function(e, t, n) {
                    l || (l = r.defer(function() {
                        l = null, t && t.value === n || u(e);
                    }));
                };
                t.on("keydown", function(e) {
                    var t = e.keyCode;
                    91 === t || 15 < t && t < 19 || 37 <= t && t <= 40 || c(e, this, this.value);
                }), i.hasEvent("paste") && t.on("paste cut", c);
            }
            t.on("change", u), a.$render = function() {
                t.val(a.$isEmpty(a.$viewValue) ? "" : a.$viewValue);
            };
        }
        function En(e, t) {
            if ($(e)) return e;
            if (y(e)) {
                Ni.lastIndex = 0;
                var n = Ni.exec(e);
                if (n) {
                    var a = +n[1], i = +n[2], r = 0, s = 0, o = 0, u = 0, l = vn(a), c = 7 * (i - 1);
                    return t && (r = t.getHours(), s = t.getMinutes(), o = t.getSeconds(), u = t.getMilliseconds()), 
                    new Date(a, 0, l.getDate() + c, r, s, o, u);
                }
            }
            return NaN;
        }
        function Hn(e, t) {
            return function(n, a) {
                var i, s;
                if ($(n)) return n;
                if (y(n)) {
                    if ('"' == n.charAt(0) && '"' == n.charAt(n.length - 1) && (n = n.substring(1, n.length - 1)), 
                    Ai.test(n)) return new Date(n);
                    if (e.lastIndex = 0, i = e.exec(n)) return i.shift(), s = a ? {
                        yyyy: a.getFullYear(),
                        MM: a.getMonth() + 1,
                        dd: a.getDate(),
                        HH: a.getHours(),
                        mm: a.getMinutes(),
                        ss: a.getSeconds(),
                        sss: a.getMilliseconds() / 1e3
                    } : {
                        yyyy: 1970,
                        MM: 1,
                        dd: 1,
                        HH: 0,
                        mm: 0,
                        ss: 0,
                        sss: 0
                    }, r(i, function(e, n) {
                        n < t.length && (s[t[n]] = +e);
                    }), new Date(s.yyyy, s.MM - 1, s.dd, s.HH, s.mm, s.ss || 0, 1e3 * s.sss || 0);
                }
                return NaN;
            };
        }
        function jn(e, t, a, i) {
            return function(r, s, o, u, l, c, d) {
                function f(e) {
                    return e && !(e.getTime && e.getTime() !== e.getTime());
                }
                function m(e) {
                    return v(e) ? $(e) ? e : a(e) : n;
                }
                An(r, s, o, u), Cn(r, s, o, u, l, c);
                var p, h = u && u.$options && u.$options.timezone;
                if (u.$$parserName = e, u.$parsers.push(function(e) {
                    if (u.$isEmpty(e)) return null;
                    if (t.test(e)) {
                        var i = a(e, p);
                        return "UTC" === h && i.setMinutes(i.getMinutes() - i.getTimezoneOffset()), i;
                    }
                    return n;
                }), u.$formatters.push(function(e) {
                    if (e && !$(e)) throw _r("datefmt", "Expected `{0}` to be a date", e);
                    if (f(e)) {
                        if (p = e, p && "UTC" === h) {
                            var t = 6e4 * p.getTimezoneOffset();
                            p = new Date(p.getTime() + t);
                        }
                        return d("date")(e, i, h);
                    }
                    return p = null, "";
                }), v(o.min) || o.ngMin) {
                    var g;
                    u.$validators.min = function(e) {
                        return !f(e) || _(g) || a(e) >= g;
                    }, o.$observe("min", function(e) {
                        g = m(e), u.$validate();
                    });
                }
                if (v(o.max) || o.ngMax) {
                    var b;
                    u.$validators.max = function(e) {
                        return !f(e) || _(b) || a(e) <= b;
                    }, o.$observe("max", function(e) {
                        b = m(e), u.$validate();
                    });
                }
            };
        }
        function An(e, t, a, i) {
            var r = t[0], s = i.$$hasNativeValidators = b(r.validity);
            s && i.$parsers.push(function(e) {
                var a = t.prop(zn) || {};
                return a.badInput && !a.typeMismatch ? n : e;
            });
        }
        function On(e, t, a, i, r, s) {
            if (An(e, t, a, i), Cn(e, t, a, i, r, s), i.$$parserName = "number", i.$parsers.push(function(e) {
                return i.$isEmpty(e) ? null : Pi.test(e) ? parseFloat(e) : n;
            }), i.$formatters.push(function(e) {
                if (!i.$isEmpty(e)) {
                    if (!M(e)) throw _r("numfmt", "Expected `{0}` to be a number", e);
                    e = e.toString();
                }
                return e;
            }), v(a.min) || a.ngMin) {
                var o;
                i.$validators.min = function(e) {
                    return i.$isEmpty(e) || _(o) || e >= o;
                }, a.$observe("min", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), o = M(e) && !isNaN(e) ? e : n, i.$validate();
                });
            }
            if (v(a.max) || a.ngMax) {
                var u;
                i.$validators.max = function(e) {
                    return i.$isEmpty(e) || _(u) || e <= u;
                }, a.$observe("max", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), u = M(e) && !isNaN(e) ? e : n, i.$validate();
                });
            }
        }
        function In(e, t, n, a, i, r) {
            Cn(e, t, n, a, i, r), Sn(a), a.$$parserName = "url", a.$validators.url = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Oi.test(n);
            };
        }
        function Pn(e, t, n, a, i, r) {
            Cn(e, t, n, a, i, r), Sn(a), a.$$parserName = "email", a.$validators.email = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Ii.test(n);
            };
        }
        function Fn(e, t, n, a) {
            _(n.name) && t.attr("name", l());
            var i = function(e) {
                t[0].checked && a.$setViewValue(n.value, e && e.type);
            };
            t.on("click", i), a.$render = function() {
                var e = n.value;
                t[0].checked = e == a.$viewValue;
            }, n.$observe("value", a.$render);
        }
        function Un(e, t, n, i, r) {
            var s;
            if (v(i)) {
                if (s = e(i), !s.constant) throw a("ngModel")("constexpr", "Expected constant expression for `{0}`, but saw `{1}`.", n, i);
                return s(t);
            }
            return r;
        }
        function Nn(e, t, n, a, i, r, s, o) {
            var u = Un(o, e, "ngTrueValue", n.ngTrueValue, !0), l = Un(o, e, "ngFalseValue", n.ngFalseValue, !1), c = function(e) {
                a.$setViewValue(t[0].checked, e && e.type);
            };
            t.on("click", c), a.$render = function() {
                t[0].checked = a.$viewValue;
            }, a.$isEmpty = function(e) {
                return e === !1;
            }, a.$formatters.push(function(e) {
                return P(e, u);
            }), a.$parsers.push(function(e) {
                return e ? u : l;
            });
        }
        function Vn(e, t) {
            return e = "ngClass" + e, [ "$animate", function(n) {
                function a(e, t) {
                    var n = [];
                    e: for (var a = 0; a < e.length; a++) {
                        for (var i = e[a], r = 0; r < t.length; r++) if (i == t[r]) continue e;
                        n.push(i);
                    }
                    return n;
                }
                function i(e) {
                    if (ca(e)) return e;
                    if (y(e)) return e.split(" ");
                    if (b(e)) {
                        var t = [];
                        return r(e, function(e, n) {
                            e && (t = t.concat(n.split(" ")));
                        }), t;
                    }
                    return e;
                }
                return {
                    restrict: "AC",
                    link: function(s, o, u) {
                        function l(e) {
                            var t = d(e, 1);
                            u.$addClass(t);
                        }
                        function c(e) {
                            var t = d(e, -1);
                            u.$removeClass(t);
                        }
                        function d(e, t) {
                            var n = o.data("$classCounts") || {}, a = [];
                            return r(e, function(e) {
                                (t > 0 || n[e]) && (n[e] = (n[e] || 0) + t, n[e] === +(t > 0) && a.push(e));
                            }), o.data("$classCounts", n), a.join(" ");
                        }
                        function f(e, t) {
                            var i = a(t, e), r = a(e, t);
                            i = d(i, 1), r = d(r, -1), i && i.length && n.addClass(o, i), r && r.length && n.removeClass(o, r);
                        }
                        function m(e) {
                            if (t === !0 || s.$index % 2 === t) {
                                var n = i(e || []);
                                if (p) {
                                    if (!P(e, p)) {
                                        var a = i(p);
                                        f(a, n);
                                    }
                                } else l(n);
                            }
                            p = I(e);
                        }
                        var p;
                        s.$watch(u[e], m, !0), u.$observe("class", function(t) {
                            m(s.$eval(u[e]));
                        }), "ngClass" !== e && s.$watch("$index", function(n, a) {
                            var r = 1 & n;
                            if (r !== (1 & a)) {
                                var o = i(s.$eval(u[e]));
                                r === t ? l(o) : c(o);
                            }
                        });
                    }
                };
            } ];
        }
        function Wn(e) {
            function t(e, t, u) {
                t === n ? a("$pending", e, u) : i("$pending", e, u), x(t) ? t ? (d(o.$error, e, u), 
                c(o.$$success, e, u)) : (c(o.$error, e, u), d(o.$$success, e, u)) : (d(o.$error, e, u), 
                d(o.$$success, e, u)), o.$pending ? (r(gr, !0), o.$valid = o.$invalid = n, s("", null)) : (r(gr, !1), 
                o.$valid = qn(o.$error), o.$invalid = !o.$valid, s("", o.$valid));
                var l;
                l = o.$pending && o.$pending[e] ? n : !o.$error[e] && (!!o.$$success[e] || null), 
                s(e, l), f.$setValidity(e, l, o);
            }
            function a(e, t, n) {
                o[e] || (o[e] = {}), c(o[e], t, n);
            }
            function i(e, t, a) {
                o[e] && d(o[e], t, a), qn(o[e]) && (o[e] = n);
            }
            function r(e, t) {
                t && !l[e] ? (m.addClass(u, e), l[e] = !0) : !t && l[e] && (m.removeClass(u, e), 
                l[e] = !1);
            }
            function s(e, t) {
                e = e ? "-" + ne(e, "-") : "", r(cr + e, t === !0), r(dr + e, t === !1);
            }
            var o = e.ctrl, u = e.$element, l = {}, c = e.set, d = e.unset, f = e.parentForm, m = e.$animate;
            l[dr] = !(l[cr] = u.hasClass(cr)), o.$setValidity = t;
        }
        function qn(e) {
            if (e) for (var t in e) return !1;
            return !0;
        }
        var Rn = /^\/(.+)\/([a-z]*)$/, zn = "validity", Bn = function(e) {
            return y(e) ? e.toLowerCase() : e;
        }, Gn = Object.prototype.hasOwnProperty, Jn = function(e) {
            return y(e) ? e.toUpperCase() : e;
        }, Kn = function(e) {
            return y(e) ? e.replace(/[A-Z]/g, function(e) {
                return String.fromCharCode(32 | e.charCodeAt(0));
            }) : e;
        }, Qn = function(e) {
            return y(e) ? e.replace(/[a-z]/g, function(e) {
                return String.fromCharCode(e.charCodeAt(0) & -33);
            }) : e;
        };
        "i" !== "I".toLowerCase() && (Bn = Kn, Jn = Qn);
        var Zn, Xn, ea, ta, na = [].slice, aa = [].splice, ia = [].push, ra = Object.prototype.toString, sa = a("ng"), oa = e.angular || (e.angular = {}), ua = 0;
        Zn = t.documentMode, p.$inject = [], h.$inject = [];
        var la, ca = Array.isArray, da = function(e) {
            return y(e) ? e.trim() : e;
        }, fa = function(e) {
            return e.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
        }, ma = function() {
            if (v(ma.isActive_)) return ma.isActive_;
            var e = !(!t.querySelector("[ng-csp]") && !t.querySelector("[data-ng-csp]"));
            if (!e) try {
                new Function("");
            } catch (t) {
                e = !0;
            }
            return ma.isActive_ = e;
        }, pa = [ "ng-", "data-ng-", "ng:", "x-ng-" ], ha = /[A-Z]/g, ga = !1, _a = 1, va = 3, ba = 8, ya = 9, Ma = 11, $a = {
            full: "1.3.14",
            major: 1,
            minor: 3,
            dot: 14,
            codeName: "instantaneous-browserification"
        };
        ye.expando = "ng339";
        var ka = ye.cache = {}, wa = 1, La = function(e, t, n) {
            e.addEventListener(t, n, !1);
        }, Da = function(e, t, n) {
            e.removeEventListener(t, n, !1);
        };
        ye._data = function(e) {
            return this.cache[e[this.expando]] || {};
        };
        var Ya = /([\:\-\_]+(.))/g, Ta = /^moz([A-Z])/, Sa = {
            mouseleave: "mouseout",
            mouseenter: "mouseover"
        }, xa = a("jqLite"), Ca = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, Ea = /<|&#?\w+;/, Ha = /<([\w:]+)/, ja = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, Aa = {
            option: [ 1, '<select multiple="multiple">', "</select>" ],
            thead: [ 1, "<table>", "</table>" ],
            col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
            tr: [ 2, "<table><tbody>", "</tbody></table>" ],
            td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
            _default: [ 0, "", "" ]
        };
        Aa.optgroup = Aa.option, Aa.tbody = Aa.tfoot = Aa.colgroup = Aa.caption = Aa.thead, 
        Aa.th = Aa.td;
        var Oa = ye.prototype = {
            ready: function(n) {
                function a() {
                    i || (i = !0, n());
                }
                var i = !1;
                "complete" === t.readyState ? setTimeout(a) : (this.on("DOMContentLoaded", a), ye(e).on("load", a));
            },
            toString: function() {
                var e = [];
                return r(this, function(t) {
                    e.push("" + t);
                }), "[" + e.join(", ") + "]";
            },
            eq: function(e) {
                return Xn(e >= 0 ? this[e] : this[this.length + e]);
            },
            length: 0,
            push: ia,
            sort: [].sort,
            splice: [].splice
        }, Ia = {};
        r("multiple,selected,checked,disabled,readOnly,required,open".split(","), function(e) {
            Ia[Bn(e)] = e;
        });
        var Pa = {};
        r("input,select,option,textarea,button,form,details".split(","), function(e) {
            Pa[e] = !0;
        });
        var Fa = {
            ngMinlength: "minlength",
            ngMaxlength: "maxlength",
            ngMin: "min",
            ngMax: "max",
            ngPattern: "pattern"
        };
        r({
            data: De,
            removeData: we
        }, function(e, t) {
            ye[t] = e;
        }), r({
            data: De,
            inheritedData: Ee,
            scope: function(e) {
                return Xn.data(e, "$scope") || Ee(e.parentNode || e, [ "$isolateScope", "$scope" ]);
            },
            isolateScope: function(e) {
                return Xn.data(e, "$isolateScope") || Xn.data(e, "$isolateScopeNoTemplate");
            },
            controller: Ce,
            injector: function(e) {
                return Ee(e, "$injector");
            },
            removeAttr: function(e, t) {
                e.removeAttribute(t);
            },
            hasClass: Ye,
            css: function(e, t, n) {
                return t = he(t), v(n) ? void (e.style[t] = n) : e.style[t];
            },
            attr: function(e, t, a) {
                var i = Bn(t);
                if (Ia[i]) {
                    if (!v(a)) return e[t] || (e.attributes.getNamedItem(t) || p).specified ? i : n;
                    a ? (e[t] = !0, e.setAttribute(t, i)) : (e[t] = !1, e.removeAttribute(i));
                } else if (v(a)) e.setAttribute(t, a); else if (e.getAttribute) {
                    var r = e.getAttribute(t, 2);
                    return null === r ? n : r;
                }
            },
            prop: function(e, t, n) {
                return v(n) ? void (e[t] = n) : e[t];
            },
            text: function() {
                function e(e, t) {
                    if (_(t)) {
                        var n = e.nodeType;
                        return n === _a || n === va ? e.textContent : "";
                    }
                    e.textContent = t;
                }
                return e.$dv = "", e;
            }(),
            val: function(e, t) {
                if (_(t)) {
                    if (e.multiple && "select" === j(e)) {
                        var n = [];
                        return r(e.options, function(e) {
                            e.selected && n.push(e.value || e.text);
                        }), 0 === n.length ? null : n;
                    }
                    return e.value;
                }
                e.value = t;
            },
            html: function(e, t) {
                return _(t) ? e.innerHTML : ($e(e, !0), void (e.innerHTML = t));
            },
            empty: He
        }, function(e, t) {
            ye.prototype[t] = function(t, a) {
                var i, r, s = this.length;
                if (e !== He && (2 == e.length && e !== Ye && e !== Ce ? t : a) === n) {
                    if (b(t)) {
                        for (i = 0; i < s; i++) if (e === De) e(this[i], t); else for (r in t) e(this[i], r, t[r]);
                        return this;
                    }
                    for (var o = e.$dv, u = o === n ? Math.min(s, 1) : s, l = 0; l < u; l++) {
                        var c = e(this[l], t, a);
                        o = o ? o + c : c;
                    }
                    return o;
                }
                for (i = 0; i < s; i++) e(this[i], t, a);
                return this;
            };
        }), r({
            removeData: we,
            on: function e(t, n, a, i) {
                if (v(i)) throw xa("onargs", "jqLite#on() does not support the `selector` or `eventData` parameters");
                if (_e(t)) {
                    var r = Le(t, !0), s = r.events, o = r.handle;
                    o || (o = r.handle = Pe(t, s));
                    for (var u = n.indexOf(" ") >= 0 ? n.split(" ") : [ n ], l = u.length; l--; ) {
                        n = u[l];
                        var c = s[n];
                        c || (s[n] = [], "mouseenter" === n || "mouseleave" === n ? e(t, Sa[n], function(e) {
                            var t = this, a = e.relatedTarget;
                            a && (a === t || t.contains(a)) || o(e, n);
                        }) : "$destroy" !== n && La(t, n, o), c = s[n]), c.push(a);
                    }
                }
            },
            off: ke,
            one: function(e, t, n) {
                e = Xn(e), e.on(t, function a() {
                    e.off(t, n), e.off(t, a);
                }), e.on(t, n);
            },
            replaceWith: function(e, t) {
                var n, a = e.parentNode;
                $e(e), r(new ye(t), function(t) {
                    n ? a.insertBefore(t, n.nextSibling) : a.replaceChild(t, e), n = t;
                });
            },
            children: function(e) {
                var t = [];
                return r(e.childNodes, function(e) {
                    e.nodeType === _a && t.push(e);
                }), t;
            },
            contents: function(e) {
                return e.contentDocument || e.childNodes || [];
            },
            append: function(e, t) {
                var n = e.nodeType;
                if (n === _a || n === Ma) {
                    t = new ye(t);
                    for (var a = 0, i = t.length; a < i; a++) {
                        var r = t[a];
                        e.appendChild(r);
                    }
                }
            },
            prepend: function(e, t) {
                if (e.nodeType === _a) {
                    var n = e.firstChild;
                    r(new ye(t), function(t) {
                        e.insertBefore(t, n);
                    });
                }
            },
            wrap: function(e, t) {
                t = Xn(t).eq(0).clone()[0];
                var n = e.parentNode;
                n && n.replaceChild(t, e), t.appendChild(e);
            },
            remove: je,
            detach: function(e) {
                je(e, !0);
            },
            after: function(e, t) {
                var n = e, a = e.parentNode;
                t = new ye(t);
                for (var i = 0, r = t.length; i < r; i++) {
                    var s = t[i];
                    a.insertBefore(s, n.nextSibling), n = s;
                }
            },
            addClass: Se,
            removeClass: Te,
            toggleClass: function(e, t, n) {
                t && r(t.split(" "), function(t) {
                    var a = n;
                    _(a) && (a = !Ye(e, t)), (a ? Se : Te)(e, t);
                });
            },
            parent: function(e) {
                var t = e.parentNode;
                return t && t.nodeType !== Ma ? t : null;
            },
            next: function(e) {
                return e.nextElementSibling;
            },
            find: function(e, t) {
                return e.getElementsByTagName ? e.getElementsByTagName(t) : [];
            },
            clone: Me,
            triggerHandler: function(e, t, n) {
                var a, i, s, o = t.type || t, u = Le(e), l = u && u.events, c = l && l[o];
                c && (a = {
                    preventDefault: function() {
                        this.defaultPrevented = !0;
                    },
                    isDefaultPrevented: function() {
                        return this.defaultPrevented === !0;
                    },
                    stopImmediatePropagation: function() {
                        this.immediatePropagationStopped = !0;
                    },
                    isImmediatePropagationStopped: function() {
                        return this.immediatePropagationStopped === !0;
                    },
                    stopPropagation: p,
                    type: o,
                    target: e
                }, t.type && (a = d(a, t)), i = I(c), s = n ? [ a ].concat(n) : [ a ], r(i, function(t) {
                    a.isImmediatePropagationStopped() || t.apply(e, s);
                }));
            }
        }, function(e, t) {
            ye.prototype[t] = function(t, n, a) {
                for (var i, r = 0, s = this.length; r < s; r++) _(i) ? (i = e(this[r], t, n, a), 
                v(i) && (i = Xn(i))) : xe(i, e(this[r], t, n, a));
                return v(i) ? i : this;
            }, ye.prototype.bind = ye.prototype.on, ye.prototype.unbind = ye.prototype.off;
        }), Ne.prototype = {
            put: function(e, t) {
                this[Ue(e, this.nextUid)] = t;
            },
            get: function(e) {
                return this[Ue(e, this.nextUid)];
            },
            remove: function(e) {
                var t = this[e = Ue(e, this.nextUid)];
                return delete this[e], t;
            }
        };
        var Ua = /^function\s*[^\(]*\(\s*([^\)]*)\)/m, Na = /,/, Va = /^\s*(_?)(\S+?)\1\s*$/, Wa = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm, qa = a("$injector");
        qe.$$annotate = We;
        var Ra = a("$animate"), za = [ "$provide", function(e) {
            this.$$selectors = {}, this.register = function(t, n) {
                var a = t + "-animation";
                if (t && "." != t.charAt(0)) throw Ra("notcsel", "Expecting class selector starting with '.' got '{0}'.", t);
                this.$$selectors[t.substr(1)] = a, e.factory(a, n);
            }, this.classNameFilter = function(e) {
                return 1 === arguments.length && (this.$$classNameFilter = e instanceof RegExp ? e : null), 
                this.$$classNameFilter;
            }, this.$get = [ "$$q", "$$asyncCallback", "$rootScope", function(e, t, n) {
                function a(t) {
                    var a, i = e.defer();
                    return i.promise.$$cancelFn = function() {
                        a && a();
                    }, n.$$postDigest(function() {
                        a = t(function() {
                            i.resolve();
                        });
                    }), i.promise;
                }
                function i(e, t) {
                    var n = [], a = [], i = le();
                    return r((e.attr("class") || "").split(/\s+/), function(e) {
                        i[e] = !0;
                    }), r(t, function(e, t) {
                        var r = i[t];
                        e === !1 && r ? a.push(t) : e !== !0 || r || n.push(t);
                    }), n.length + a.length > 0 && [ n.length ? n : null, a.length ? a : null ];
                }
                function s(e, t, n) {
                    for (var a = 0, i = t.length; a < i; ++a) {
                        var r = t[a];
                        e[r] = n;
                    }
                }
                function o() {
                    return l || (l = e.defer(), t(function() {
                        l.resolve(), l = null;
                    })), l.promise;
                }
                function u(e, t) {
                    if (oa.isObject(t)) {
                        var n = d(t.from || {}, t.to || {});
                        e.css(n);
                    }
                }
                var l;
                return {
                    animate: function(e, t, n) {
                        return u(e, {
                            from: t,
                            to: n
                        }), o();
                    },
                    enter: function(e, t, n, a) {
                        return u(e, a), n ? n.after(e) : t.prepend(e), o();
                    },
                    leave: function(e, t) {
                        return e.remove(), o();
                    },
                    move: function(e, t, n, a) {
                        return this.enter(e, t, n, a);
                    },
                    addClass: function(e, t, n) {
                        return this.setClass(e, t, [], n);
                    },
                    $$addClassImmediately: function(e, t, n) {
                        return e = Xn(e), t = y(t) ? t : ca(t) ? t.join(" ") : "", r(e, function(e) {
                            Se(e, t);
                        }), u(e, n), o();
                    },
                    removeClass: function(e, t, n) {
                        return this.setClass(e, [], t, n);
                    },
                    $$removeClassImmediately: function(e, t, n) {
                        return e = Xn(e), t = y(t) ? t : ca(t) ? t.join(" ") : "", r(e, function(e) {
                            Te(e, t);
                        }), u(e, n), o();
                    },
                    setClass: function(e, t, n, r) {
                        var o = this, u = "$$animateClasses", l = !1;
                        e = Xn(e);
                        var c = e.data(u);
                        c ? r && c.options && (c.options = oa.extend(c.options || {}, r)) : (c = {
                            classes: {},
                            options: r
                        }, l = !0);
                        var d = c.classes;
                        return t = ca(t) ? t : t.split(" "), n = ca(n) ? n : n.split(" "), s(d, t, !0), 
                        s(d, n, !1), l && (c.promise = a(function(t) {
                            var n = e.data(u);
                            if (e.removeData(u), n) {
                                var a = i(e, n.classes);
                                a && o.$$setClassImmediately(e, a[0], a[1], n.options);
                            }
                            t();
                        }), e.data(u, c)), c.promise;
                    },
                    $$setClassImmediately: function(e, t, n, a) {
                        return t && this.$$addClassImmediately(e, t), n && this.$$removeClassImmediately(e, n), 
                        u(e, a), o();
                    },
                    enabled: p,
                    cancel: p
                };
            } ];
        } ], Ba = a("$compile");
        Qe.$inject = [ "$provide", "$$sanitizeUriProvider" ];
        var Ga = /^((?:x|data)[\:\-_])/i, Ja = a("$controller"), Ka = "application/json", Qa = {
            "Content-Type": Ka + ";charset=utf-8"
        }, Za = /^\[|^\{(?!\{)/, Xa = {
            "[": /]$/,
            "{": /}$/
        }, ei = /^\)\]\}',?\n/, ti = a("$interpolate"), ni = /^([^\?#]*)(\?([^#]*))?(#(.*))?$/, ai = {
            http: 80,
            https: 443,
            ftp: 21
        }, ii = a("$location"), ri = {
            $$html5: !1,
            $$replace: !1,
            absUrl: Tt("$$absUrl"),
            url: function(e) {
                if (_(e)) return this.$$url;
                var t = ni.exec(e);
                return (t[1] || "" === e) && this.path(decodeURIComponent(t[1])), (t[2] || t[1] || "" === e) && this.search(t[3] || ""), 
                this.hash(t[5] || ""), this;
            },
            protocol: Tt("$$protocol"),
            host: Tt("$$host"),
            port: Tt("$$port"),
            path: St("$$path", function(e) {
                return e = null !== e ? e.toString() : "", "/" == e.charAt(0) ? e : "/" + e;
            }),
            search: function(e, t) {
                switch (arguments.length) {
                  case 0:
                    return this.$$search;

                  case 1:
                    if (y(e) || M(e)) e = e.toString(), this.$$search = B(e); else {
                        if (!b(e)) throw ii("isrcharg", "The first argument of the `$location#search()` call must be a string or an object.");
                        e = O(e, {}), r(e, function(t, n) {
                            null == t && delete e[n];
                        }), this.$$search = e;
                    }
                    break;

                  default:
                    _(t) || null === t ? delete this.$$search[e] : this.$$search[e] = t;
                }
                return this.$$compose(), this;
            },
            hash: St("$$hash", function(e) {
                return null !== e ? e.toString() : "";
            }),
            replace: function() {
                return this.$$replace = !0, this;
            }
        };
        r([ Yt, Dt, Lt ], function(e) {
            e.prototype = Object.create(ri), e.prototype.state = function(t) {
                if (!arguments.length) return this.$$state;
                if (e !== Lt || !this.$$html5) throw ii("nostate", "History API state support is available only in HTML5 mode and only in browsers supporting HTML5 History API");
                return this.$$state = _(t) ? null : t, this;
            };
        });
        var si = a("$parse"), oi = Function.prototype.call, ui = Function.prototype.apply, li = Function.prototype.bind, ci = le();
        r({
            null: function() {
                return null;
            },
            true: function() {
                return !0;
            },
            false: function() {
                return !1;
            },
            undefined: function() {}
        }, function(e, t) {
            e.constant = e.literal = e.sharedGetter = !0, ci[t] = e;
        }), ci.this = function(e) {
            return e;
        }, ci.this.sharedGetter = !0;
        var di = d(le(), {
            "+": function(e, t, a, i) {
                return a = a(e, t), i = i(e, t), v(a) ? v(i) ? a + i : a : v(i) ? i : n;
            },
            "-": function(e, t, n, a) {
                return n = n(e, t), a = a(e, t), (v(n) ? n : 0) - (v(a) ? a : 0);
            },
            "*": function(e, t, n, a) {
                return n(e, t) * a(e, t);
            },
            "/": function(e, t, n, a) {
                return n(e, t) / a(e, t);
            },
            "%": function(e, t, n, a) {
                return n(e, t) % a(e, t);
            },
            "===": function(e, t, n, a) {
                return n(e, t) === a(e, t);
            },
            "!==": function(e, t, n, a) {
                return n(e, t) !== a(e, t);
            },
            "==": function(e, t, n, a) {
                return n(e, t) == a(e, t);
            },
            "!=": function(e, t, n, a) {
                return n(e, t) != a(e, t);
            },
            "<": function(e, t, n, a) {
                return n(e, t) < a(e, t);
            },
            ">": function(e, t, n, a) {
                return n(e, t) > a(e, t);
            },
            "<=": function(e, t, n, a) {
                return n(e, t) <= a(e, t);
            },
            ">=": function(e, t, n, a) {
                return n(e, t) >= a(e, t);
            },
            "&&": function(e, t, n, a) {
                return n(e, t) && a(e, t);
            },
            "||": function(e, t, n, a) {
                return n(e, t) || a(e, t);
            },
            "!": function(e, t, n) {
                return !n(e, t);
            },
            "=": !0,
            "|": !0
        }), fi = {
            n: "\n",
            f: "\f",
            r: "\r",
            t: "\t",
            v: "\v",
            "'": "'",
            '"': '"'
        }, mi = function(e) {
            this.options = e;
        };
        mi.prototype = {
            constructor: mi,
            lex: function(e) {
                for (this.text = e, this.index = 0, this.tokens = []; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if ('"' === t || "'" === t) this.readString(t); else if (this.isNumber(t) || "." === t && this.isNumber(this.peek())) this.readNumber(); else if (this.isIdent(t)) this.readIdent(); else if (this.is(t, "(){}[].,;:?")) this.tokens.push({
                        index: this.index,
                        text: t
                    }), this.index++; else if (this.isWhitespace(t)) this.index++; else {
                        var n = t + this.peek(), a = n + this.peek(2), i = di[t], r = di[n], s = di[a];
                        if (i || r || s) {
                            var o = s ? a : r ? n : t;
                            this.tokens.push({
                                index: this.index,
                                text: o,
                                operator: !0
                            }), this.index += o.length;
                        } else this.throwError("Unexpected next character ", this.index, this.index + 1);
                    }
                }
                return this.tokens;
            },
            is: function(e, t) {
                return t.indexOf(e) !== -1;
            },
            peek: function(e) {
                var t = e || 1;
                return this.index + t < this.text.length && this.text.charAt(this.index + t);
            },
            isNumber: function(e) {
                return "0" <= e && e <= "9" && "string" == typeof e;
            },
            isWhitespace: function(e) {
                return " " === e || "\r" === e || "\t" === e || "\n" === e || "\v" === e || " " === e;
            },
            isIdent: function(e) {
                return "a" <= e && e <= "z" || "A" <= e && e <= "Z" || "_" === e || "$" === e;
            },
            isExpOperator: function(e) {
                return "-" === e || "+" === e || this.isNumber(e);
            },
            throwError: function(e, t, n) {
                n = n || this.index;
                var a = v(t) ? "s " + t + "-" + this.index + " [" + this.text.substring(t, n) + "]" : " " + n;
                throw si("lexerr", "Lexer Error: {0} at column{1} in expression [{2}].", e, a, this.text);
            },
            readNumber: function() {
                for (var e = "", t = this.index; this.index < this.text.length; ) {
                    var n = Bn(this.text.charAt(this.index));
                    if ("." == n || this.isNumber(n)) e += n; else {
                        var a = this.peek();
                        if ("e" == n && this.isExpOperator(a)) e += n; else if (this.isExpOperator(n) && a && this.isNumber(a) && "e" == e.charAt(e.length - 1)) e += n; else {
                            if (!this.isExpOperator(n) || a && this.isNumber(a) || "e" != e.charAt(e.length - 1)) break;
                            this.throwError("Invalid exponent");
                        }
                    }
                    this.index++;
                }
                this.tokens.push({
                    index: t,
                    text: e,
                    constant: !0,
                    value: Number(e)
                });
            },
            readIdent: function() {
                for (var e = this.index; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if (!this.isIdent(t) && !this.isNumber(t)) break;
                    this.index++;
                }
                this.tokens.push({
                    index: e,
                    text: this.text.slice(e, this.index),
                    identifier: !0
                });
            },
            readString: function(e) {
                var t = this.index;
                this.index++;
                for (var n = "", a = e, i = !1; this.index < this.text.length; ) {
                    var r = this.text.charAt(this.index);
                    if (a += r, i) {
                        if ("u" === r) {
                            var s = this.text.substring(this.index + 1, this.index + 5);
                            s.match(/[\da-f]{4}/i) || this.throwError("Invalid unicode escape [\\u" + s + "]"), 
                            this.index += 4, n += String.fromCharCode(parseInt(s, 16));
                        } else {
                            var o = fi[r];
                            n += o || r;
                        }
                        i = !1;
                    } else if ("\\" === r) i = !0; else {
                        if (r === e) return this.index++, void this.tokens.push({
                            index: t,
                            text: a,
                            constant: !0,
                            value: n
                        });
                        n += r;
                    }
                    this.index++;
                }
                this.throwError("Unterminated quote", t);
            }
        };
        var pi = function(e, t, n) {
            this.lexer = e, this.$filter = t, this.options = n;
        };
        pi.ZERO = d(function() {
            return 0;
        }, {
            sharedGetter: !0,
            constant: !0
        }), pi.prototype = {
            constructor: pi,
            parse: function(e) {
                this.text = e, this.tokens = this.lexer.lex(e);
                var t = this.statements();
                return 0 !== this.tokens.length && this.throwError("is an unexpected token", this.tokens[0]), 
                t.literal = !!t.literal, t.constant = !!t.constant, t;
            },
            primary: function() {
                var e;
                this.expect("(") ? (e = this.filterChain(), this.consume(")")) : this.expect("[") ? e = this.arrayDeclaration() : this.expect("{") ? e = this.object() : this.peek().identifier && this.peek().text in ci ? e = ci[this.consume().text] : this.peek().identifier ? e = this.identifier() : this.peek().constant ? e = this.constant() : this.throwError("not a primary expression", this.peek());
                for (var t, n; t = this.expect("(", "[", "."); ) "(" === t.text ? (e = this.functionCall(e, n), 
                n = null) : "[" === t.text ? (n = e, e = this.objectIndex(e)) : "." === t.text ? (n = e, 
                e = this.fieldAccess(e)) : this.throwError("IMPOSSIBLE");
                return e;
            },
            throwError: function(e, t) {
                throw si("syntax", "Syntax Error: Token '{0}' {1} at column {2} of the expression [{3}] starting at [{4}].", t.text, e, t.index + 1, this.text, this.text.substring(t.index));
            },
            peekToken: function() {
                if (0 === this.tokens.length) throw si("ueoe", "Unexpected end of expression: {0}", this.text);
                return this.tokens[0];
            },
            peek: function(e, t, n, a) {
                return this.peekAhead(0, e, t, n, a);
            },
            peekAhead: function(e, t, n, a, i) {
                if (this.tokens.length > e) {
                    var r = this.tokens[e], s = r.text;
                    if (s === t || s === n || s === a || s === i || !t && !n && !a && !i) return r;
                }
                return !1;
            },
            expect: function(e, t, n, a) {
                var i = this.peek(e, t, n, a);
                return !!i && (this.tokens.shift(), i);
            },
            consume: function(e) {
                if (0 === this.tokens.length) throw si("ueoe", "Unexpected end of expression: {0}", this.text);
                var t = this.expect(e);
                return t || this.throwError("is unexpected, expecting [" + e + "]", this.peek()), 
                t;
            },
            unaryFn: function(e, t) {
                var n = di[e];
                return d(function(e, a) {
                    return n(e, a, t);
                }, {
                    constant: t.constant,
                    inputs: [ t ]
                });
            },
            binaryFn: function(e, t, n, a) {
                var i = di[t];
                return d(function(t, a) {
                    return i(t, a, e, n);
                }, {
                    constant: e.constant && n.constant,
                    inputs: !a && [ e, n ]
                });
            },
            identifier: function() {
                for (var e = this.consume().text; this.peek(".") && this.peekAhead(1).identifier && !this.peekAhead(2, "("); ) e += this.consume().text + this.consume().text;
                return Ut(e, this.options, this.text);
            },
            constant: function() {
                var e = this.consume().value;
                return d(function() {
                    return e;
                }, {
                    constant: !0,
                    literal: !0
                });
            },
            statements: function() {
                for (var e = []; ;) if (this.tokens.length > 0 && !this.peek("}", ")", ";", "]") && e.push(this.filterChain()), 
                !this.expect(";")) return 1 === e.length ? e[0] : function(t, n) {
                    for (var a, i = 0, r = e.length; i < r; i++) a = e[i](t, n);
                    return a;
                };
            },
            filterChain: function() {
                for (var e, t = this.expression(); e = this.expect("|"); ) t = this.filter(t);
                return t;
            },
            filter: function(e) {
                var t, a, i = this.$filter(this.consume().text);
                if (this.peek(":")) for (t = [], a = []; this.expect(":"); ) t.push(this.expression());
                var r = [ e ].concat(t || []);
                return d(function(r, s) {
                    var o = e(r, s);
                    if (a) {
                        a[0] = o;
                        for (var u = t.length; u--; ) a[u + 1] = t[u](r, s);
                        return i.apply(n, a);
                    }
                    return i(o);
                }, {
                    constant: !i.$stateful && r.every(At),
                    inputs: !i.$stateful && r
                });
            },
            expression: function() {
                return this.assignment();
            },
            assignment: function() {
                var e, t, n = this.ternary();
                return (t = this.expect("=")) ? (n.assign || this.throwError("implies assignment but [" + this.text.substring(0, t.index) + "] can not be assigned to", t), 
                e = this.ternary(), d(function(t, a) {
                    return n.assign(t, e(t, a), a);
                }, {
                    inputs: [ n, e ]
                })) : n;
            },
            ternary: function() {
                var e, t, n = this.logicalOR();
                if ((t = this.expect("?")) && (e = this.assignment(), this.consume(":"))) {
                    var a = this.assignment();
                    return d(function(t, i) {
                        return n(t, i) ? e(t, i) : a(t, i);
                    }, {
                        constant: n.constant && e.constant && a.constant
                    });
                }
                return n;
            },
            logicalOR: function() {
                for (var e, t = this.logicalAND(); e = this.expect("||"); ) t = this.binaryFn(t, e.text, this.logicalAND(), !0);
                return t;
            },
            logicalAND: function() {
                for (var e, t = this.equality(); e = this.expect("&&"); ) t = this.binaryFn(t, e.text, this.equality(), !0);
                return t;
            },
            equality: function() {
                for (var e, t = this.relational(); e = this.expect("==", "!=", "===", "!=="); ) t = this.binaryFn(t, e.text, this.relational());
                return t;
            },
            relational: function() {
                for (var e, t = this.additive(); e = this.expect("<", ">", "<=", ">="); ) t = this.binaryFn(t, e.text, this.additive());
                return t;
            },
            additive: function() {
                for (var e, t = this.multiplicative(); e = this.expect("+", "-"); ) t = this.binaryFn(t, e.text, this.multiplicative());
                return t;
            },
            multiplicative: function() {
                for (var e, t = this.unary(); e = this.expect("*", "/", "%"); ) t = this.binaryFn(t, e.text, this.unary());
                return t;
            },
            unary: function() {
                var e;
                return this.expect("+") ? this.primary() : (e = this.expect("-")) ? this.binaryFn(pi.ZERO, e.text, this.unary()) : (e = this.expect("!")) ? this.unaryFn(e.text, this.unary()) : this.primary();
            },
            fieldAccess: function(e) {
                var t = this.identifier();
                return d(function(a, i, r) {
                    var s = r || e(a, i);
                    return null == s ? n : t(s);
                }, {
                    assign: function(n, a, i) {
                        var r = e(n, i);
                        return r || e.assign(n, r = {}, i), t.assign(r, a);
                    }
                });
            },
            objectIndex: function(e) {
                var t = this.text, a = this.expression();
                return this.consume("]"), d(function(i, r) {
                    var s, o = e(i, r), u = a(i, r);
                    return Et(u, t), o ? s = Ht(o[u], t) : n;
                }, {
                    assign: function(n, i, r) {
                        var s = Et(a(n, r), t), o = Ht(e(n, r), t);
                        return o || e.assign(n, o = {}, r), o[s] = i;
                    }
                });
            },
            functionCall: function(e, t) {
                var a = [];
                if (")" !== this.peekToken().text) do a.push(this.expression()); while (this.expect(","));
                this.consume(")");
                var i = this.text, r = a.length ? [] : null;
                return function(s, o) {
                    var u = t ? t(s, o) : v(t) ? n : s, l = e(s, o, u) || p;
                    if (r) for (var c = a.length; c--; ) r[c] = Ht(a[c](s, o), i);
                    Ht(u, i), jt(l, i);
                    var d = l.apply ? l.apply(u, r) : l(r[0], r[1], r[2], r[3], r[4]);
                    return r && (r.length = 0), Ht(d, i);
                };
            },
            arrayDeclaration: function() {
                var e = [];
                if ("]" !== this.peekToken().text) do {
                    if (this.peek("]")) break;
                    e.push(this.expression());
                } while (this.expect(","));
                return this.consume("]"), d(function(t, n) {
                    for (var a = [], i = 0, r = e.length; i < r; i++) a.push(e[i](t, n));
                    return a;
                }, {
                    literal: !0,
                    constant: e.every(At),
                    inputs: e
                });
            },
            object: function() {
                var e = [], t = [];
                if ("}" !== this.peekToken().text) do {
                    if (this.peek("}")) break;
                    var n = this.consume();
                    n.constant ? e.push(n.value) : n.identifier ? e.push(n.text) : this.throwError("invalid key", n), 
                    this.consume(":"), t.push(this.expression());
                } while (this.expect(","));
                return this.consume("}"), d(function(n, a) {
                    for (var i = {}, r = 0, s = t.length; r < s; r++) i[e[r]] = t[r](n, a);
                    return i;
                }, {
                    literal: !0,
                    constant: t.every(At),
                    inputs: t
                });
            }
        };
        var hi = le(), gi = le(), _i = Object.prototype.valueOf, vi = a("$sce"), bi = {
            HTML: "html",
            CSS: "css",
            URL: "url",
            RESOURCE_URL: "resourceUrl",
            JS: "js"
        }, Ba = a("$compile"), yi = t.createElement("a"), Mi = an(e.location.href);
        on.$inject = [ "$provide" ], dn.$inject = [ "$locale" ], fn.$inject = [ "$locale" ];
        var $i = ".", ki = {
            yyyy: hn("FullYear", 4),
            yy: hn("FullYear", 2, 0, !0),
            y: hn("FullYear", 1),
            MMMM: gn("Month"),
            MMM: gn("Month", !0),
            MM: hn("Month", 2, 1),
            M: hn("Month", 1, 1),
            dd: hn("Date", 2),
            d: hn("Date", 1),
            HH: hn("Hours", 2),
            H: hn("Hours", 1),
            hh: hn("Hours", 2, -12),
            h: hn("Hours", 1, -12),
            mm: hn("Minutes", 2),
            m: hn("Minutes", 1),
            ss: hn("Seconds", 2),
            s: hn("Seconds", 1),
            sss: hn("Milliseconds", 3),
            EEEE: gn("Day"),
            EEE: gn("Day", !0),
            a: Mn,
            Z: _n,
            ww: yn(2),
            w: yn(1)
        }, wi = /((?:[^yMdHhmsaZEw']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z|w+))(.*)/, Li = /^\-?\d+$/;
        $n.$inject = [ "$locale" ];
        var Di = g(Bn), Yi = g(Jn);
        Ln.$inject = [ "$parse" ];
        var Ti = g({
            restrict: "E",
            compile: function(e, t) {
                if (!t.href && !t.xlinkHref && !t.name) return function(e, t) {
                    if ("a" === t[0].nodeName.toLowerCase()) {
                        var n = "[object SVGAnimatedString]" === ra.call(t.prop("href")) ? "xlink:href" : "href";
                        t.on("click", function(e) {
                            t.attr(n) || e.preventDefault();
                        });
                    }
                };
            }
        }), Si = {};
        r(Ia, function(e, t) {
            if ("multiple" != e) {
                var n = Ze("ng-" + t);
                Si[n] = function() {
                    return {
                        restrict: "A",
                        priority: 100,
                        link: function(e, a, i) {
                            e.$watch(i[n], function(e) {
                                i.$set(t, !!e);
                            });
                        }
                    };
                };
            }
        }), r(Fa, function(e, t) {
            Si[t] = function() {
                return {
                    priority: 100,
                    link: function(e, n, a) {
                        if ("ngPattern" === t && "/" == a.ngPattern.charAt(0)) {
                            var i = a.ngPattern.match(Rn);
                            if (i) return void a.$set("ngPattern", new RegExp(i[1], i[2]));
                        }
                        e.$watch(a[t], function(e) {
                            a.$set(t, e);
                        });
                    }
                };
            };
        }), r([ "src", "srcset", "href" ], function(e) {
            var t = Ze("ng-" + e);
            Si[t] = function() {
                return {
                    priority: 99,
                    link: function(n, a, i) {
                        var r = e, s = e;
                        "href" === e && "[object SVGAnimatedString]" === ra.call(a.prop("href")) && (s = "xlinkHref", 
                        i.$attr[s] = "xlink:href", r = null), i.$observe(t, function(t) {
                            return t ? (i.$set(s, t), void (Zn && r && a.prop(r, i[s]))) : void ("href" === e && i.$set(s, null));
                        });
                    }
                };
            };
        });
        var xi = {
            $addControl: p,
            $$renameControl: Yn,
            $removeControl: p,
            $setValidity: p,
            $setDirty: p,
            $setPristine: p,
            $setSubmitted: p
        }, Ci = "ng-submitted";
        Tn.$inject = [ "$element", "$attrs", "$scope", "$animate", "$interpolate" ];
        var Ei = function(e) {
            return [ "$timeout", function(t) {
                var a = {
                    name: "form",
                    restrict: e ? "EAC" : "E",
                    controller: Tn,
                    compile: function(e) {
                        return e.addClass(fr).addClass(cr), {
                            pre: function(e, a, i, r) {
                                if (!("action" in i)) {
                                    var s = function(t) {
                                        e.$apply(function() {
                                            r.$commitViewValue(), r.$setSubmitted();
                                        }), t.preventDefault();
                                    };
                                    La(a[0], "submit", s), a.on("$destroy", function() {
                                        t(function() {
                                            Da(a[0], "submit", s);
                                        }, 0, !1);
                                    });
                                }
                                var o = r.$$parentForm, u = r.$name;
                                u && (Ot(e, null, u, r, u), i.$observe(i.name ? "name" : "ngForm", function(t) {
                                    u !== t && (Ot(e, null, u, n, u), u = t, Ot(e, null, u, r, u), o.$$renameControl(r, u));
                                })), a.on("$destroy", function() {
                                    o.$removeControl(r), u && Ot(e, null, u, n, u), d(r, xi);
                                });
                            }
                        };
                    }
                };
                return a;
            } ];
        }, Hi = Ei(), ji = Ei(!0), Ai = /\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z)/, Oi = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/, Ii = /^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i, Pi = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/, Fi = /^(\d{4})-(\d{2})-(\d{2})$/, Ui = /^(\d{4})-(\d\d)-(\d\d)T(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, Ni = /^(\d{4})-W(\d\d)$/, Vi = /^(\d{4})-(\d\d)$/, Wi = /^(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, qi = {
            text: xn,
            date: jn("date", Fi, Hn(Fi, [ "yyyy", "MM", "dd" ]), "yyyy-MM-dd"),
            "datetime-local": jn("datetimelocal", Ui, Hn(Ui, [ "yyyy", "MM", "dd", "HH", "mm", "ss", "sss" ]), "yyyy-MM-ddTHH:mm:ss.sss"),
            time: jn("time", Wi, Hn(Wi, [ "HH", "mm", "ss", "sss" ]), "HH:mm:ss.sss"),
            week: jn("week", Ni, En, "yyyy-Www"),
            month: jn("month", Vi, Hn(Vi, [ "yyyy", "MM" ]), "yyyy-MM"),
            number: On,
            url: In,
            email: Pn,
            radio: Fn,
            checkbox: Nn,
            hidden: p,
            button: p,
            submit: p,
            reset: p,
            file: p
        }, Ri = [ "$browser", "$sniffer", "$filter", "$parse", function(e, t, n, a) {
            return {
                restrict: "E",
                require: [ "?ngModel" ],
                link: {
                    pre: function(i, r, s, o) {
                        o[0] && (qi[Bn(s.type)] || qi.text)(i, r, s, o[0], t, e, n, a);
                    }
                }
            };
        } ], zi = /^(true|false|\d+)$/, Bi = function() {
            return {
                restrict: "A",
                priority: 100,
                compile: function(e, t) {
                    return zi.test(t.ngValue) ? function(e, t, n) {
                        n.$set("value", e.$eval(n.ngValue));
                    } : function(e, t, n) {
                        e.$watch(n.ngValue, function(e) {
                            n.$set("value", e);
                        });
                    };
                }
            };
        }, Gi = [ "$compile", function(e) {
            return {
                restrict: "AC",
                compile: function(t) {
                    return e.$$addBindingClass(t), function(t, a, i) {
                        e.$$addBindingInfo(a, i.ngBind), a = a[0], t.$watch(i.ngBind, function(e) {
                            a.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], Ji = [ "$interpolate", "$compile", function(e, t) {
            return {
                compile: function(a) {
                    return t.$$addBindingClass(a), function(a, i, r) {
                        var s = e(i.attr(r.$attr.ngBindTemplate));
                        t.$$addBindingInfo(i, s.expressions), i = i[0], r.$observe("ngBindTemplate", function(e) {
                            i.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], Ki = [ "$sce", "$parse", "$compile", function(e, t, n) {
            return {
                restrict: "A",
                compile: function(a, i) {
                    var r = t(i.ngBindHtml), s = t(i.ngBindHtml, function(e) {
                        return (e || "").toString();
                    });
                    return n.$$addBindingClass(a), function(t, a, i) {
                        n.$$addBindingInfo(a, i.ngBindHtml), t.$watch(s, function() {
                            a.html(e.getTrustedHtml(r(t)) || "");
                        });
                    };
                }
            };
        } ], Qi = g({
            restrict: "A",
            require: "ngModel",
            link: function(e, t, n, a) {
                a.$viewChangeListeners.push(function() {
                    e.$eval(n.ngChange);
                });
            }
        }), Zi = Vn("", !0), Xi = Vn("Odd", 0), er = Vn("Even", 1), tr = Dn({
            compile: function(e, t) {
                t.$set("ngCloak", n), e.removeClass("ng-cloak");
            }
        }), nr = [ function() {
            return {
                restrict: "A",
                scope: !0,
                controller: "@",
                priority: 500
            };
        } ], ar = {}, ir = {
            blur: !0,
            focus: !0
        };
        r("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "), function(e) {
            var t = Ze("ng-" + e);
            ar[t] = [ "$parse", "$rootScope", function(n, a) {
                return {
                    restrict: "A",
                    compile: function(i, r) {
                        var s = n(r[t], null, !0);
                        return function(t, n) {
                            n.on(e, function(n) {
                                var i = function() {
                                    s(t, {
                                        $event: n
                                    });
                                };
                                ir[e] && a.$$phase ? t.$evalAsync(i) : t.$apply(i);
                            });
                        };
                    }
                };
            } ];
        });
        var rr = [ "$animate", function(e) {
            return {
                multiElement: !0,
                transclude: "element",
                priority: 600,
                terminal: !0,
                restrict: "A",
                $$tlb: !0,
                link: function(n, a, i, r, s) {
                    var o, u, l;
                    n.$watch(i.ngIf, function(n) {
                        n ? u || s(function(n, r) {
                            u = r, n[n.length++] = t.createComment(" end ngIf: " + i.ngIf + " "), o = {
                                clone: n
                            }, e.enter(n, a.parent(), a);
                        }) : (l && (l.remove(), l = null), u && (u.$destroy(), u = null), o && (l = ue(o.clone), 
                        e.leave(l).then(function() {
                            l = null;
                        }), o = null));
                    });
                }
            };
        } ], sr = [ "$templateRequest", "$anchorScroll", "$animate", "$sce", function(e, t, n, a) {
            return {
                restrict: "ECA",
                priority: 400,
                terminal: !0,
                transclude: "element",
                controller: oa.noop,
                compile: function(i, r) {
                    var s = r.ngInclude || r.src, o = r.onload || "", u = r.autoscroll;
                    return function(i, r, l, c, d) {
                        var f, m, p, h = 0, g = function() {
                            m && (m.remove(), m = null), f && (f.$destroy(), f = null), p && (n.leave(p).then(function() {
                                m = null;
                            }), m = p, p = null);
                        };
                        i.$watch(a.parseAsResourceUrl(s), function(a) {
                            var s = function() {
                                !v(u) || u && !i.$eval(u) || t();
                            }, l = ++h;
                            a ? (e(a, !0).then(function(e) {
                                if (l === h) {
                                    var t = i.$new();
                                    c.template = e;
                                    var u = d(t, function(e) {
                                        g(), n.enter(e, null, r).then(s);
                                    });
                                    f = t, p = u, f.$emit("$includeContentLoaded", a), i.$eval(o);
                                }
                            }, function() {
                                l === h && (g(), i.$emit("$includeContentError", a));
                            }), i.$emit("$includeContentRequested", a)) : (g(), c.template = null);
                        });
                    };
                }
            };
        } ], or = [ "$compile", function(e) {
            return {
                restrict: "ECA",
                priority: -400,
                require: "ngInclude",
                link: function(n, a, i, r) {
                    return /SVG/.test(a[0].toString()) ? (a.empty(), void e(ve(r.template, t).childNodes)(n, function(e) {
                        a.append(e);
                    }, {
                        futureParentElement: a
                    })) : (a.html(r.template), void e(a.contents())(n));
                }
            };
        } ], ur = Dn({
            priority: 450,
            compile: function() {
                return {
                    pre: function(e, t, n) {
                        e.$eval(n.ngInit);
                    }
                };
            }
        }), lr = function() {
            return {
                restrict: "A",
                priority: 100,
                require: "ngModel",
                link: function(e, t, a, i) {
                    var s = t.attr(a.$attr.ngList) || ", ", o = "false" !== a.ngTrim, u = o ? da(s) : s, l = function(e) {
                        if (!_(e)) {
                            var t = [];
                            return e && r(e.split(u), function(e) {
                                e && t.push(o ? da(e) : e);
                            }), t;
                        }
                    };
                    i.$parsers.push(l), i.$formatters.push(function(e) {
                        return ca(e) ? e.join(s) : n;
                    }), i.$isEmpty = function(e) {
                        return !e || !e.length;
                    };
                }
            };
        }, cr = "ng-valid", dr = "ng-invalid", fr = "ng-pristine", mr = "ng-dirty", pr = "ng-untouched", hr = "ng-touched", gr = "ng-pending", _r = new a("ngModel"), vr = [ "$scope", "$exceptionHandler", "$attrs", "$element", "$parse", "$animate", "$timeout", "$rootScope", "$q", "$interpolate", function(e, t, a, i, s, o, u, l, c, d) {
            this.$viewValue = Number.NaN, this.$modelValue = Number.NaN, this.$$rawModelValue = n, 
            this.$validators = {}, this.$asyncValidators = {}, this.$parsers = [], this.$formatters = [], 
            this.$viewChangeListeners = [], this.$untouched = !0, this.$touched = !1, this.$pristine = !0, 
            this.$dirty = !1, this.$valid = !0, this.$invalid = !1, this.$error = {}, this.$$success = {}, 
            this.$pending = n, this.$name = d(a.name || "", !1)(e);
            var f, m = s(a.ngModel), h = m.assign, g = m, b = h, y = null, $ = this;
            this.$$setOptions = function(e) {
                if ($.$options = e, e && e.getterSetter) {
                    var t = s(a.ngModel + "()"), n = s(a.ngModel + "($$$p)");
                    g = function(e) {
                        var n = m(e);
                        return k(n) && (n = t(e)), n;
                    }, b = function(e, t) {
                        k(m(e)) ? n(e, {
                            $$$p: $.$modelValue
                        }) : h(e, $.$modelValue);
                    };
                } else if (!m.assign) throw _r("nonassign", "Expression '{0}' is non-assignable. Element: {1}", a.ngModel, R(i));
            }, this.$render = p, this.$isEmpty = function(e) {
                return _(e) || "" === e || null === e || e !== e;
            };
            var w = i.inheritedData("$formController") || xi, L = 0;
            Wn({
                ctrl: this,
                $element: i,
                set: function(e, t) {
                    e[t] = !0;
                },
                unset: function(e, t) {
                    delete e[t];
                },
                parentForm: w,
                $animate: o
            }), this.$setPristine = function() {
                $.$dirty = !1, $.$pristine = !0, o.removeClass(i, mr), o.addClass(i, fr);
            }, this.$setDirty = function() {
                $.$dirty = !0, $.$pristine = !1, o.removeClass(i, fr), o.addClass(i, mr), w.$setDirty();
            }, this.$setUntouched = function() {
                $.$touched = !1, $.$untouched = !0, o.setClass(i, pr, hr);
            }, this.$setTouched = function() {
                $.$touched = !0, $.$untouched = !1, o.setClass(i, hr, pr);
            }, this.$rollbackViewValue = function() {
                u.cancel(y), $.$viewValue = $.$$lastCommittedViewValue, $.$render();
            }, this.$validate = function() {
                if (!M($.$modelValue) || !isNaN($.$modelValue)) {
                    var e = $.$$lastCommittedViewValue, t = $.$$rawModelValue, a = $.$valid, i = $.$modelValue, r = $.$options && $.$options.allowInvalid;
                    $.$$runValidators(t, e, function(e) {
                        r || a === e || ($.$modelValue = e ? t : n, $.$modelValue !== i && $.$$writeModelToScope());
                    });
                }
            }, this.$$runValidators = function(e, t, a) {
                function i() {
                    var e = $.$$parserName || "parse";
                    return f !== n ? (f || (r($.$validators, function(e, t) {
                        u(t, null);
                    }), r($.$asyncValidators, function(e, t) {
                        u(t, null);
                    })), u(e, f), f) : (u(e, null), !0);
                }
                function s() {
                    var n = !0;
                    return r($.$validators, function(a, i) {
                        var r = a(e, t);
                        n = n && r, u(i, r);
                    }), !!n || (r($.$asyncValidators, function(e, t) {
                        u(t, null);
                    }), !1);
                }
                function o() {
                    var a = [], i = !0;
                    r($.$asyncValidators, function(r, s) {
                        var o = r(e, t);
                        if (!C(o)) throw _r("$asyncValidators", "Expected asynchronous validator to return a promise but got '{0}' instead.", o);
                        u(s, n), a.push(o.then(function() {
                            u(s, !0);
                        }, function(e) {
                            i = !1, u(s, !1);
                        }));
                    }), a.length ? c.all(a).then(function() {
                        l(i);
                    }, p) : l(!0);
                }
                function u(e, t) {
                    d === L && $.$setValidity(e, t);
                }
                function l(e) {
                    d === L && a(e);
                }
                L++;
                var d = L;
                return i() && s() ? void o() : void l(!1);
            }, this.$commitViewValue = function() {
                var e = $.$viewValue;
                u.cancel(y), ($.$$lastCommittedViewValue !== e || "" === e && $.$$hasNativeValidators) && ($.$$lastCommittedViewValue = e, 
                $.$pristine && this.$setDirty(), this.$$parseAndValidate());
            }, this.$$parseAndValidate = function() {
                function t() {
                    $.$modelValue !== s && $.$$writeModelToScope();
                }
                var a = $.$$lastCommittedViewValue, i = a;
                if (f = !_(i) || n) for (var r = 0; r < $.$parsers.length; r++) if (i = $.$parsers[r](i), 
                _(i)) {
                    f = !1;
                    break;
                }
                M($.$modelValue) && isNaN($.$modelValue) && ($.$modelValue = g(e));
                var s = $.$modelValue, o = $.$options && $.$options.allowInvalid;
                $.$$rawModelValue = i, o && ($.$modelValue = i, t()), $.$$runValidators(i, $.$$lastCommittedViewValue, function(e) {
                    o || ($.$modelValue = e ? i : n, t());
                });
            }, this.$$writeModelToScope = function() {
                b(e, $.$modelValue), r($.$viewChangeListeners, function(e) {
                    try {
                        e();
                    } catch (e) {
                        t(e);
                    }
                });
            }, this.$setViewValue = function(e, t) {
                $.$viewValue = e, $.$options && !$.$options.updateOnDefault || $.$$debounceViewValueCommit(t);
            }, this.$$debounceViewValueCommit = function(t) {
                var n, a = 0, i = $.$options;
                i && v(i.debounce) && (n = i.debounce, M(n) ? a = n : M(n[t]) ? a = n[t] : M(n.default) && (a = n.default)), 
                u.cancel(y), a ? y = u(function() {
                    $.$commitViewValue();
                }, a) : l.$$phase ? $.$commitViewValue() : e.$apply(function() {
                    $.$commitViewValue();
                });
            }, e.$watch(function() {
                var t = g(e);
                if (t !== $.$modelValue) {
                    $.$modelValue = $.$$rawModelValue = t, f = n;
                    for (var a = $.$formatters, i = a.length, r = t; i--; ) r = a[i](r);
                    $.$viewValue !== r && ($.$viewValue = $.$$lastCommittedViewValue = r, $.$render(), 
                    $.$$runValidators(t, r, p));
                }
                return t;
            });
        } ], br = [ "$rootScope", function(e) {
            return {
                restrict: "A",
                require: [ "ngModel", "^?form", "^?ngModelOptions" ],
                controller: vr,
                priority: 1,
                compile: function(t) {
                    return t.addClass(fr).addClass(pr).addClass(cr), {
                        pre: function(e, t, n, a) {
                            var i = a[0], r = a[1] || xi;
                            i.$$setOptions(a[2] && a[2].$options), r.$addControl(i), n.$observe("name", function(e) {
                                i.$name !== e && r.$$renameControl(i, e);
                            }), e.$on("$destroy", function() {
                                r.$removeControl(i);
                            });
                        },
                        post: function(t, n, a, i) {
                            var r = i[0];
                            r.$options && r.$options.updateOn && n.on(r.$options.updateOn, function(e) {
                                r.$$debounceViewValueCommit(e && e.type);
                            }), n.on("blur", function(n) {
                                r.$touched || (e.$$phase ? t.$evalAsync(r.$setTouched) : t.$apply(r.$setTouched));
                            });
                        }
                    };
                }
            };
        } ], yr = /(\s+|^)default(\s+|$)/, Mr = function() {
            return {
                restrict: "A",
                controller: [ "$scope", "$attrs", function(e, t) {
                    var a = this;
                    this.$options = e.$eval(t.ngModelOptions), this.$options.updateOn !== n ? (this.$options.updateOnDefault = !1, 
                    this.$options.updateOn = da(this.$options.updateOn.replace(yr, function() {
                        return a.$options.updateOnDefault = !0, " ";
                    }))) : this.$options.updateOnDefault = !0;
                } ]
            };
        }, $r = Dn({
            terminal: !0,
            priority: 1e3
        }), kr = [ "$locale", "$interpolate", function(e, t) {
            var n = /{}/g, a = /^when(Minus)?(.+)$/;
            return {
                restrict: "EA",
                link: function(i, s, o) {
                    function u(e) {
                        s.text(e || "");
                    }
                    var l, c = o.count, d = o.$attr.when && s.attr(o.$attr.when), f = o.offset || 0, m = i.$eval(d) || {}, p = {}, h = t.startSymbol(), g = t.endSymbol(), _ = h + c + "-" + f + g, v = oa.noop;
                    r(o, function(e, t) {
                        var n = a.exec(t);
                        if (n) {
                            var i = (n[1] ? "-" : "") + Bn(n[2]);
                            m[i] = s.attr(o.$attr[t]);
                        }
                    }), r(m, function(e, a) {
                        p[a] = t(e.replace(n, _));
                    }), i.$watch(c, function(t) {
                        var n = parseFloat(t), a = isNaN(n);
                        a || n in m || (n = e.pluralCat(n - f)), n === l || a && isNaN(l) || (v(), v = i.$watch(p[n], u), 
                        l = n);
                    });
                }
            };
        } ], wr = [ "$parse", "$animate", function(e, s) {
            var o = "$$NG_REMOVED", u = a("ngRepeat"), l = function(e, t, n, a, i, r, s) {
                e[n] = a, i && (e[i] = r), e.$index = t, e.$first = 0 === t, e.$last = t === s - 1, 
                e.$middle = !(e.$first || e.$last), e.$odd = !(e.$even = 0 === (1 & t));
            }, c = function(e) {
                return e.clone[0];
            }, d = function(e) {
                return e.clone[e.clone.length - 1];
            };
            return {
                restrict: "A",
                multiElement: !0,
                transclude: "element",
                priority: 1e3,
                terminal: !0,
                $$tlb: !0,
                compile: function(a, f) {
                    var m = f.ngRepeat, p = t.createComment(" end ngRepeat: " + m + " "), h = m.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);
                    if (!h) throw u("iexp", "Expected expression in form of '_item_ in _collection_[ track by _id_]' but got '{0}'.", m);
                    var g = h[1], _ = h[2], v = h[3], b = h[4];
                    if (h = g.match(/^(?:(\s*[\$\w]+)|\(\s*([\$\w]+)\s*,\s*([\$\w]+)\s*\))$/), !h) throw u("iidexp", "'_item_' in '_item_ in _collection_' should be an identifier or '(_key_, _value_)' expression, but got '{0}'.", g);
                    var y = h[3] || h[1], M = h[2];
                    if (v && (!/^[$a-zA-Z_][$a-zA-Z0-9_]*$/.test(v) || /^(null|undefined|this|\$index|\$first|\$middle|\$last|\$even|\$odd|\$parent|\$root|\$id)$/.test(v))) throw u("badident", "alias '{0}' is invalid --- must be a valid JS identifier which is not a reserved name.", v);
                    var $, k, w, L, D = {
                        $id: Ue
                    };
                    return b ? $ = e(b) : (w = function(e, t) {
                        return Ue(t);
                    }, L = function(e) {
                        return e;
                    }), function(e, t, a, f, h) {
                        $ && (k = function(t, n, a) {
                            return M && (D[M] = t), D[y] = n, D.$index = a, $(e, D);
                        });
                        var g = le();
                        e.$watchCollection(_, function(a) {
                            var f, _, b, $, D, Y, T, S, x, C, E, H, j = t[0], A = le();
                            if (v && (e[v] = a), i(a)) x = a, S = k || w; else {
                                S = k || L, x = [];
                                for (var O in a) a.hasOwnProperty(O) && "$" != O.charAt(0) && x.push(O);
                                x.sort();
                            }
                            for ($ = x.length, E = new Array($), f = 0; f < $; f++) if (D = a === x ? f : x[f], 
                            Y = a[D], T = S(D, Y, f), g[T]) C = g[T], delete g[T], A[T] = C, E[f] = C; else {
                                if (A[T]) throw r(E, function(e) {
                                    e && e.scope && (g[e.id] = e);
                                }), u("dupes", "Duplicates in a repeater are not allowed. Use 'track by' expression to specify unique keys. Repeater: {0}, Duplicate key: {1}, Duplicate value: {2}", m, T, Y);
                                E[f] = {
                                    id: T,
                                    scope: n,
                                    clone: n
                                }, A[T] = !0;
                            }
                            for (var I in g) {
                                if (C = g[I], H = ue(C.clone), s.leave(H), H[0].parentNode) for (f = 0, _ = H.length; f < _; f++) H[f][o] = !0;
                                C.scope.$destroy();
                            }
                            for (f = 0; f < $; f++) if (D = a === x ? f : x[f], Y = a[D], C = E[f], C.scope) {
                                b = j;
                                do b = b.nextSibling; while (b && b[o]);
                                c(C) != b && s.move(ue(C.clone), null, Xn(j)), j = d(C), l(C.scope, f, y, Y, M, D, $);
                            } else h(function(e, t) {
                                C.scope = t;
                                var n = p.cloneNode(!1);
                                e[e.length++] = n, s.enter(e, null, Xn(j)), j = n, C.clone = e, A[C.id] = C, l(C.scope, f, y, Y, M, D, $);
                            });
                            g = A;
                        });
                    };
                }
            };
        } ], Lr = "ng-hide", Dr = "ng-hide-animate", Yr = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngShow, function(t) {
                        e[t ? "removeClass" : "addClass"](n, Lr, {
                            tempClasses: Dr
                        });
                    });
                }
            };
        } ], Tr = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngHide, function(t) {
                        e[t ? "addClass" : "removeClass"](n, Lr, {
                            tempClasses: Dr
                        });
                    });
                }
            };
        } ], Sr = Dn(function(e, t, n) {
            e.$watchCollection(n.ngStyle, function(e, n) {
                n && e !== n && r(n, function(e, n) {
                    t.css(n, "");
                }), e && t.css(e);
            });
        }), xr = [ "$animate", function(e) {
            return {
                restrict: "EA",
                require: "ngSwitch",
                controller: [ "$scope", function() {
                    this.cases = {};
                } ],
                link: function(n, a, i, s) {
                    var o = i.ngSwitch || i.on, u = [], l = [], c = [], d = [], f = function(e, t) {
                        return function() {
                            e.splice(t, 1);
                        };
                    };
                    n.$watch(o, function(n) {
                        var a, i;
                        for (a = 0, i = c.length; a < i; ++a) e.cancel(c[a]);
                        for (c.length = 0, a = 0, i = d.length; a < i; ++a) {
                            var o = ue(l[a].clone);
                            d[a].$destroy();
                            var m = c[a] = e.leave(o);
                            m.then(f(c, a));
                        }
                        l.length = 0, d.length = 0, (u = s.cases["!" + n] || s.cases["?"]) && r(u, function(n) {
                            n.transclude(function(a, i) {
                                d.push(i);
                                var r = n.element;
                                a[a.length++] = t.createComment(" end ngSwitchWhen: ");
                                var s = {
                                    clone: a
                                };
                                l.push(s), e.enter(a, r.parent(), r);
                            });
                        });
                    });
                }
            };
        } ], Cr = Dn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, i) {
                a.cases["!" + n.ngSwitchWhen] = a.cases["!" + n.ngSwitchWhen] || [], a.cases["!" + n.ngSwitchWhen].push({
                    transclude: i,
                    element: t
                });
            }
        }), Er = Dn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, i) {
                a.cases["?"] = a.cases["?"] || [], a.cases["?"].push({
                    transclude: i,
                    element: t
                });
            }
        }), Hr = Dn({
            restrict: "EAC",
            link: function(e, t, n, i, r) {
                if (!r) throw a("ngTransclude")("orphan", "Illegal use of ngTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}", R(t));
                r(function(e) {
                    t.empty(), t.append(e);
                });
            }
        }), jr = [ "$templateCache", function(e) {
            return {
                restrict: "E",
                terminal: !0,
                compile: function(t, n) {
                    if ("text/ng-template" == n.type) {
                        var a = n.id, i = t[0].text;
                        e.put(a, i);
                    }
                }
            };
        } ], Ar = a("ngOptions"), Or = g({
            restrict: "A",
            terminal: !0
        }), Ir = [ "$compile", "$parse", function(e, a) {
            var i = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/, o = {
                $setViewValue: p
            };
            return {
                restrict: "E",
                require: [ "select", "?ngModel" ],
                controller: [ "$element", "$scope", "$attrs", function(e, t, n) {
                    var a, i, r = this, s = {}, u = o;
                    r.databound = n.ngModel, r.init = function(e, t, n) {
                        u = e, a = t, i = n;
                    }, r.addOption = function(t, n) {
                        se(t, '"option value"'), s[t] = !0, u.$viewValue == t && (e.val(t), i.parent() && i.remove()), 
                        n && n[0].hasAttribute("selected") && (n[0].selected = !0);
                    }, r.removeOption = function(e) {
                        this.hasOption(e) && (delete s[e], u.$viewValue === e && this.renderUnknownOption(e));
                    }, r.renderUnknownOption = function(t) {
                        var n = "? " + Ue(t) + " ?";
                        i.val(n), e.prepend(i), e.val(n), i.prop("selected", !0);
                    }, r.hasOption = function(e) {
                        return s.hasOwnProperty(e);
                    }, t.$on("$destroy", function() {
                        r.renderUnknownOption = p;
                    });
                } ],
                link: function(o, u, l, c) {
                    function d(e, t, n, a) {
                        n.$render = function() {
                            var e = n.$viewValue;
                            a.hasOption(e) ? (L.parent() && L.remove(), t.val(e), "" === e && p.prop("selected", !0)) : _(e) && p ? t.val("") : a.renderUnknownOption(e);
                        }, t.on("change", function() {
                            e.$apply(function() {
                                L.parent() && L.remove(), n.$setViewValue(t.val());
                            });
                        });
                    }
                    function f(e, t, n) {
                        var a;
                        n.$render = function() {
                            var e = new Ne(n.$viewValue);
                            r(t.find("option"), function(t) {
                                t.selected = v(e.get(t.value));
                            });
                        }, e.$watch(function() {
                            P(a, n.$viewValue) || (a = I(n.$viewValue), n.$render());
                        }), t.on("change", function() {
                            e.$apply(function() {
                                var e = [];
                                r(t.find("option"), function(t) {
                                    t.selected && e.push(t.value);
                                }), n.$setViewValue(e);
                            });
                        });
                    }
                    function m(t, o, u) {
                        function l(e, n, a) {
                            return P[Y] = a, x && (P[x] = n), e(t, P);
                        }
                        function c() {
                            t.$apply(function() {
                                var e, n = H(t) || [];
                                if (b) e = [], r(o.val(), function(t) {
                                    t = A ? O[t] : t, e.push(d(t, n[t]));
                                }); else {
                                    var a = A ? O[o.val()] : o.val();
                                    e = d(a, n[a]);
                                }
                                u.$setViewValue(e), _();
                            });
                        }
                        function d(e, t) {
                            if ("?" === e) return n;
                            if ("" === e) return null;
                            var a = S ? S : E;
                            return l(a, e, t);
                        }
                        function f() {
                            var e, n = H(t);
                            if (n && ca(n)) {
                                e = new Array(n.length);
                                for (var a = 0, i = n.length; a < i; a++) e[a] = l(D, a, n[a]);
                                return e;
                            }
                            if (n) {
                                e = {};
                                for (var r in n) n.hasOwnProperty(r) && (e[r] = l(D, r, n[r]));
                            }
                            return e;
                        }
                        function m(e) {
                            var t;
                            if (b) if (A && ca(e)) {
                                t = new Ne([]);
                                for (var n = 0; n < e.length; n++) t.put(l(A, null, e[n]), !0);
                            } else t = new Ne(e); else A && (e = l(A, null, e));
                            return function(n, a) {
                                var i;
                                return i = A ? A : S ? S : E, b ? v(t.remove(l(i, n, a))) : e === l(i, n, a);
                            };
                        }
                        function p() {
                            $ || (t.$$postDigest(_), $ = !0);
                        }
                        function g(e, t, n) {
                            e[t] = e[t] || 0, e[t] += n ? 1 : -1;
                        }
                        function _() {
                            $ = !1;
                            var e, n, a, i, c, d, f, p, _, y, L, Y, T, S, E, j, F, U = {
                                "": []
                            }, N = [ "" ], V = u.$viewValue, W = H(t) || [], q = x ? s(W) : W, R = {}, z = m(V), B = !1;
                            for (O = {}, Y = 0; y = q.length, Y < y; Y++) f = Y, x && (f = q[Y], "$" === f.charAt(0)) || (p = W[f], 
                            e = l(C, f, p) || "", (n = U[e]) || (n = U[e] = [], N.push(e)), T = z(f, p), B = B || T, 
                            j = l(D, f, p), j = v(j) ? j : "", F = A ? A(t, P) : x ? q[Y] : Y, A && (O[F] = f), 
                            n.push({
                                id: F,
                                label: j,
                                selected: T
                            }));
                            for (b || (M || null === V ? U[""].unshift({
                                id: "",
                                label: "",
                                selected: !B
                            }) : B || U[""].unshift({
                                id: "?",
                                label: "",
                                selected: !0
                            })), L = 0, _ = N.length; L < _; L++) {
                                for (e = N[L], n = U[e], I.length <= L ? (i = {
                                    element: w.clone().attr("label", e),
                                    label: n.label
                                }, c = [ i ], I.push(c), o.append(i.element)) : (c = I[L], i = c[0], i.label != e && i.element.attr("label", i.label = e)), 
                                S = null, Y = 0, y = n.length; Y < y; Y++) a = n[Y], (d = c[Y + 1]) ? (S = d.element, 
                                d.label !== a.label && (g(R, d.label, !1), g(R, a.label, !0), S.text(d.label = a.label), 
                                S.prop("label", d.label)), d.id !== a.id && S.val(d.id = a.id), S[0].selected !== a.selected && (S.prop("selected", d.selected = a.selected), 
                                Zn && S.prop("selected", d.selected))) : ("" === a.id && M ? E = M : (E = k.clone()).val(a.id).prop("selected", a.selected).attr("selected", a.selected).prop("label", a.label).text(a.label), 
                                c.push(d = {
                                    element: E,
                                    label: a.label,
                                    id: a.id,
                                    selected: a.selected
                                }), g(R, a.label, !0), S ? S.after(E) : i.element.append(E), S = E);
                                for (Y++; c.length > Y; ) a = c.pop(), g(R, a.label, !1), a.element.remove();
                            }
                            for (;I.length > L; ) {
                                for (n = I.pop(), Y = 1; Y < n.length; ++Y) g(R, n[Y].label, !1);
                                n[0].element.remove();
                            }
                            r(R, function(e, t) {
                                e > 0 ? h.addOption(t) : e < 0 && h.removeOption(t);
                            });
                        }
                        var L;
                        if (!(L = y.match(i))) throw Ar("iexp", "Expected expression in form of '_select_ (as _label_)? for (_key_,)?_value_ in _collection_' but got '{0}'. Element: {1}", y, R(o));
                        var D = a(L[2] || L[1]), Y = L[4] || L[6], T = / as /.test(L[0]) && L[1], S = T ? a(T) : null, x = L[5], C = a(L[3] || ""), E = a(L[2] ? L[1] : Y), H = a(L[7]), j = L[8], A = j ? a(L[8]) : null, O = {}, I = [ [ {
                            element: o,
                            label: ""
                        } ] ], P = {};
                        M && (e(M)(t), M.removeClass("ng-scope"), M.remove()), o.empty(), o.on("change", c), 
                        u.$render = _, t.$watchCollection(H, p), t.$watchCollection(f, p), b && t.$watchCollection(function() {
                            return u.$modelValue;
                        }, p);
                    }
                    if (c[1]) {
                        for (var p, h = c[0], g = c[1], b = l.multiple, y = l.ngOptions, M = !1, $ = !1, k = Xn(t.createElement("option")), w = Xn(t.createElement("optgroup")), L = k.clone(), D = 0, Y = u.children(), T = Y.length; D < T; D++) if ("" === Y[D].value) {
                            p = M = Y.eq(D);
                            break;
                        }
                        h.init(g, M, L), b && (g.$isEmpty = function(e) {
                            return !e || 0 === e.length;
                        }), y ? m(o, u, g) : b ? f(o, u, g) : d(o, u, g, h);
                    }
                }
            };
        } ], Pr = [ "$interpolate", function(e) {
            var t = {
                addOption: p,
                removeOption: p
            };
            return {
                restrict: "E",
                priority: 100,
                compile: function(n, a) {
                    if (_(a.value)) {
                        var i = e(n.text(), !0);
                        i || a.$set("value", n.text());
                    }
                    return function(e, n, a) {
                        var r = "$selectController", s = n.parent(), o = s.data(r) || s.parent().data(r);
                        o && o.databound || (o = t), i ? e.$watch(i, function(e, t) {
                            a.$set("value", e), t !== e && o.removeOption(t), o.addOption(e, n);
                        }) : o.addOption(a.value, n), n.on("$destroy", function() {
                            o.removeOption(a.value);
                        });
                    };
                }
            };
        } ], Fr = g({
            restrict: "E",
            terminal: !1
        }), Ur = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    a && (n.required = !0, a.$validators.required = function(e, t) {
                        return !n.required || !a.$isEmpty(t);
                    }, n.$observe("required", function() {
                        a.$validate();
                    }));
                }
            };
        }, Nr = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, i, r) {
                    if (r) {
                        var s, o = i.ngPattern || i.pattern;
                        i.$observe("pattern", function(e) {
                            if (y(e) && e.length > 0 && (e = new RegExp("^" + e + "$")), e && !e.test) throw a("ngPattern")("noregexp", "Expected {0} to be a RegExp but was {1}. Element: {2}", o, e, R(t));
                            s = e || n, r.$validate();
                        }), r.$validators.pattern = function(e) {
                            return r.$isEmpty(e) || _(s) || s.test(e);
                        };
                    }
                }
            };
        }, Vr = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var i = -1;
                        n.$observe("maxlength", function(e) {
                            var t = f(e);
                            i = isNaN(t) ? -1 : t, a.$validate();
                        }), a.$validators.maxlength = function(e, t) {
                            return i < 0 || a.$isEmpty(t) || t.length <= i;
                        };
                    }
                }
            };
        }, Wr = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var i = 0;
                        n.$observe("minlength", function(e) {
                            i = f(e) || 0, a.$validate();
                        }), a.$validators.minlength = function(e, t) {
                            return a.$isEmpty(t) || t.length >= i;
                        };
                    }
                }
            };
        };
        return e.angular.bootstrap ? void console.log("WARNING: Tried to load angular more than once.") : (ae(), 
        me(oa), void Xn(t).ready(function() {
            Z(t, X);
        }));
    }(window, document), !window.angular.$$csp() && window.angular.element(document).find("head").prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide:not(.ng-hide-animate){display:none !important;}ng\\:form{display:block;}</style>'), 
    e.exports = angular;
}, function(e, t) {
    /**
	 * @license AngularJS v1.3.14
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a() {
            function e(e, n) {
                return t.extend(Object.create(e), n);
            }
            function n(e, t) {
                var n = t.caseInsensitiveMatch, a = {
                    originalPath: e,
                    regexp: e
                }, i = a.keys = [];
                return e = e.replace(/([().])/g, "\\$1").replace(/(\/)?:(\w+)([\?\*])?/g, function(e, t, n, a) {
                    var r = "?" === a ? a : null, s = "*" === a ? a : null;
                    return i.push({
                        name: n,
                        optional: !!r
                    }), t = t || "", "" + (r ? "" : t) + "(?:" + (r ? t : "") + (s && "(.+?)" || "([^/]+)") + (r || "") + ")" + (r || "");
                }).replace(/([\/$\*])/g, "\\$1"), a.regexp = new RegExp("^" + e + "$", n ? "i" : ""), 
                a;
            }
            var a = {};
            this.when = function(e, i) {
                var r = t.copy(i);
                if (t.isUndefined(r.reloadOnSearch) && (r.reloadOnSearch = !0), t.isUndefined(r.caseInsensitiveMatch) && (r.caseInsensitiveMatch = this.caseInsensitiveMatch), 
                a[e] = t.extend(r, e && n(e, r)), e) {
                    var s = "/" == e[e.length - 1] ? e.substr(0, e.length - 1) : e + "/";
                    a[s] = t.extend({
                        redirectTo: e
                    }, n(s, r));
                }
                return this;
            }, this.caseInsensitiveMatch = !1, this.otherwise = function(e) {
                return "string" == typeof e && (e = {
                    redirectTo: e
                }), this.when(null, e), this;
            }, this.$get = [ "$rootScope", "$location", "$routeParams", "$q", "$injector", "$templateRequest", "$sce", function(n, i, r, s, o, l, c) {
                function d(e, t) {
                    var n = t.keys, a = {};
                    if (!t.regexp) return null;
                    var i = t.regexp.exec(e);
                    if (!i) return null;
                    for (var r = 1, s = i.length; r < s; ++r) {
                        var o = n[r - 1], u = i[r];
                        o && u && (a[o.name] = u);
                    }
                    return a;
                }
                function f(e) {
                    var a = b.current;
                    g = p(), _ = g && a && g.$$route === a.$$route && t.equals(g.pathParams, a.pathParams) && !g.reloadOnSearch && !v, 
                    _ || !a && !g || n.$broadcast("$routeChangeStart", g, a).defaultPrevented && e && e.preventDefault();
                }
                function m() {
                    var e = b.current, a = g;
                    _ ? (e.params = a.params, t.copy(e.params, r), n.$broadcast("$routeUpdate", e)) : (a || e) && (v = !1, 
                    b.current = a, a && a.redirectTo && (t.isString(a.redirectTo) ? i.path(h(a.redirectTo, a.params)).search(a.params).replace() : i.url(a.redirectTo(a.pathParams, i.path(), i.search())).replace()), 
                    s.when(a).then(function() {
                        if (a) {
                            var e, n, i = t.extend({}, a.resolve);
                            return t.forEach(i, function(e, n) {
                                i[n] = t.isString(e) ? o.get(e) : o.invoke(e, null, null, n);
                            }), t.isDefined(e = a.template) ? t.isFunction(e) && (e = e(a.params)) : t.isDefined(n = a.templateUrl) && (t.isFunction(n) && (n = n(a.params)), 
                            n = c.getTrustedResourceUrl(n), t.isDefined(n) && (a.loadedTemplateUrl = n, e = l(n))), 
                            t.isDefined(e) && (i.$template = e), s.all(i);
                        }
                    }).then(function(i) {
                        a == b.current && (a && (a.locals = i, t.copy(a.params, r)), n.$broadcast("$routeChangeSuccess", a, e));
                    }, function(t) {
                        a == b.current && n.$broadcast("$routeChangeError", a, e, t);
                    }));
                }
                function p() {
                    var n, r;
                    return t.forEach(a, function(a, s) {
                        !r && (n = d(i.path(), a)) && (r = e(a, {
                            params: t.extend({}, i.search(), n),
                            pathParams: n
                        }), r.$$route = a);
                    }), r || a[null] && e(a[null], {
                        params: {},
                        pathParams: {}
                    });
                }
                function h(e, n) {
                    var a = [];
                    return t.forEach((e || "").split(":"), function(e, t) {
                        if (0 === t) a.push(e); else {
                            var i = e.match(/(\w+)(?:[?*])?(.*)/), r = i[1];
                            a.push(n[r]), a.push(i[2] || ""), delete n[r];
                        }
                    }), a.join("");
                }
                var g, _, v = !1, b = {
                    routes: a,
                    reload: function() {
                        v = !0, n.$evalAsync(function() {
                            f(), m();
                        });
                    },
                    updateParams: function(e) {
                        if (!this.current || !this.current.$$route) throw u("norout", "Tried updating route when with no current route");
                        e = t.extend({}, this.current.params, e), i.path(h(this.current.$$route.originalPath, e)), 
                        i.search(e);
                    }
                };
                return n.$on("$locationChangeStart", f), n.$on("$locationChangeSuccess", m), b;
            } ];
        }
        function i() {
            this.$get = function() {
                return {};
            };
        }
        function r(e, n, a) {
            return {
                restrict: "ECA",
                terminal: !0,
                priority: 400,
                transclude: "element",
                link: function(i, r, s, o, u) {
                    function l() {
                        m && (a.cancel(m), m = null), d && (d.$destroy(), d = null), f && (m = a.leave(f), 
                        m.then(function() {
                            m = null;
                        }), f = null);
                    }
                    function c() {
                        var s = e.current && e.current.locals, o = s && s.$template;
                        if (t.isDefined(o)) {
                            var c = i.$new(), m = e.current, g = u(c, function(e) {
                                a.enter(e, null, f || r).then(function() {
                                    !t.isDefined(p) || p && !i.$eval(p) || n();
                                }), l();
                            });
                            f = g, d = m.scope = c, d.$emit("$viewContentLoaded"), d.$eval(h);
                        } else l();
                    }
                    var d, f, m, p = s.autoscroll, h = s.onload || "";
                    i.$on("$routeChangeSuccess", c), c();
                }
            };
        }
        function s(e, t, n) {
            return {
                restrict: "ECA",
                priority: -400,
                link: function(a, i) {
                    var r = n.current, s = r.locals;
                    i.html(s.$template);
                    var o = e(i.contents());
                    if (r.controller) {
                        s.$scope = a;
                        var u = t(r.controller, s);
                        r.controllerAs && (a[r.controllerAs] = u), i.data("$ngControllerController", u), 
                        i.children().data("$ngControllerController", u);
                    }
                    o(a);
                }
            };
        }
        var o = t.module("ngRoute", [ "ng" ]).provider("$route", a), u = t.$$minErr("ngRoute");
        o.provider("$routeParams", i), o.directive("ngView", r), o.directive("ngView", s), 
        r.$inject = [ "$route", "$anchorScroll", "$animate" ], s.$inject = [ "$compile", "$controller", "$route" ];
    }(window, window.angular);
}, , function(e, t) {
    angular.module("ui.bootstrap", [ "ui.bootstrap.collapse", "ui.bootstrap.accordion", "ui.bootstrap.alert", "ui.bootstrap.bindHtml", "ui.bootstrap.buttons", "ui.bootstrap.carousel", "ui.bootstrap.dateparser", "ui.bootstrap.position", "ui.bootstrap.datepicker", "ui.bootstrap.dropdown", "ui.bootstrap.modal", "ui.bootstrap.pagination", "ui.bootstrap.tooltip", "ui.bootstrap.popover", "ui.bootstrap.progressbar", "ui.bootstrap.rating", "ui.bootstrap.tabs", "ui.bootstrap.timepicker", "ui.bootstrap.transition", "ui.bootstrap.typeahead" ]), 
    angular.module("ui.bootstrap.collapse", []).directive("collapse", [ "$animate", function(e) {
        return {
            link: function(t, n, a) {
                function i() {
                    n.removeClass("collapse").addClass("collapsing"), e.addClass(n, "in", {
                        to: {
                            height: n[0].scrollHeight + "px"
                        }
                    }).then(r);
                }
                function r() {
                    n.removeClass("collapsing"), n.css({
                        height: "auto"
                    });
                }
                function s() {
                    n.css({
                        height: n[0].scrollHeight + "px"
                    }).removeClass("collapse").addClass("collapsing"), e.removeClass(n, "in", {
                        to: {
                            height: "0"
                        }
                    }).then(o);
                }
                function o() {
                    n.css({
                        height: "0"
                    }), n.removeClass("collapsing"), n.addClass("collapse");
                }
                t.$watch(a.collapse, function(e) {
                    e ? s() : i();
                });
            }
        };
    } ]), angular.module("ui.bootstrap.accordion", [ "ui.bootstrap.collapse" ]).constant("accordionConfig", {
        closeOthers: !0
    }).controller("AccordionController", [ "$scope", "$attrs", "accordionConfig", function(e, t, n) {
        this.groups = [], this.closeOthers = function(a) {
            var i = angular.isDefined(t.closeOthers) ? e.$eval(t.closeOthers) : n.closeOthers;
            i && angular.forEach(this.groups, function(e) {
                e !== a && (e.isOpen = !1);
            });
        }, this.addGroup = function(e) {
            var t = this;
            this.groups.push(e), e.$on("$destroy", function(n) {
                t.removeGroup(e);
            });
        }, this.removeGroup = function(e) {
            var t = this.groups.indexOf(e);
            t !== -1 && this.groups.splice(t, 1);
        };
    } ]).directive("accordion", function() {
        return {
            restrict: "EA",
            controller: "AccordionController",
            transclude: !0,
            replace: !1,
            templateUrl: "template/accordion/accordion.html"
        };
    }).directive("accordionGroup", function() {
        return {
            require: "^accordion",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: "template/accordion/accordion-group.html",
            scope: {
                heading: "@",
                isOpen: "=?",
                isDisabled: "=?"
            },
            controller: function() {
                this.setHeading = function(e) {
                    this.heading = e;
                };
            },
            link: function(e, t, n, a) {
                a.addGroup(e), e.$watch("isOpen", function(t) {
                    t && a.closeOthers(e);
                }), e.toggleOpen = function() {
                    e.isDisabled || (e.isOpen = !e.isOpen);
                };
            }
        };
    }).directive("accordionHeading", function() {
        return {
            restrict: "EA",
            transclude: !0,
            template: "",
            replace: !0,
            require: "^accordionGroup",
            link: function(e, t, n, a, i) {
                a.setHeading(i(e, angular.noop));
            }
        };
    }).directive("accordionTransclude", function() {
        return {
            require: "^accordionGroup",
            link: function(e, t, n, a) {
                e.$watch(function() {
                    return a[n.accordionTransclude];
                }, function(e) {
                    e && (t.html(""), t.append(e));
                });
            }
        };
    }), angular.module("ui.bootstrap.alert", []).controller("AlertController", [ "$scope", "$attrs", function(e, t) {
        e.closeable = "close" in t, this.close = e.close;
    } ]).directive("alert", function() {
        return {
            restrict: "EA",
            controller: "AlertController",
            templateUrl: "template/alert/alert.html",
            transclude: !0,
            replace: !0,
            scope: {
                type: "@",
                close: "&"
            }
        };
    }).directive("dismissOnTimeout", [ "$timeout", function(e) {
        return {
            require: "alert",
            link: function(t, n, a, i) {
                e(function() {
                    i.close();
                }, parseInt(a.dismissOnTimeout, 10));
            }
        };
    } ]), angular.module("ui.bootstrap.bindHtml", []).directive("bindHtmlUnsafe", function() {
        return function(e, t, n) {
            t.addClass("ng-binding").data("$binding", n.bindHtmlUnsafe), e.$watch(n.bindHtmlUnsafe, function(e) {
                t.html(e || "");
            });
        };
    }), angular.module("ui.bootstrap.buttons", []).constant("buttonConfig", {
        activeClass: "active",
        toggleEvent: "click"
    }).controller("ButtonsController", [ "buttonConfig", function(e) {
        this.activeClass = e.activeClass || "active", this.toggleEvent = e.toggleEvent || "click";
    } ]).directive("btnRadio", function() {
        return {
            require: [ "btnRadio", "ngModel" ],
            controller: "ButtonsController",
            link: function(e, t, n, a) {
                var i = a[0], r = a[1];
                r.$render = function() {
                    t.toggleClass(i.activeClass, angular.equals(r.$modelValue, e.$eval(n.btnRadio)));
                }, t.bind(i.toggleEvent, function() {
                    var a = t.hasClass(i.activeClass);
                    a && !angular.isDefined(n.uncheckable) || e.$apply(function() {
                        r.$setViewValue(a ? null : e.$eval(n.btnRadio)), r.$render();
                    });
                });
            }
        };
    }).directive("btnCheckbox", function() {
        return {
            require: [ "btnCheckbox", "ngModel" ],
            controller: "ButtonsController",
            link: function(e, t, n, a) {
                function i() {
                    return s(n.btnCheckboxTrue, !0);
                }
                function r() {
                    return s(n.btnCheckboxFalse, !1);
                }
                function s(t, n) {
                    var a = e.$eval(t);
                    return angular.isDefined(a) ? a : n;
                }
                var o = a[0], u = a[1];
                u.$render = function() {
                    t.toggleClass(o.activeClass, angular.equals(u.$modelValue, i()));
                }, t.bind(o.toggleEvent, function() {
                    e.$apply(function() {
                        u.$setViewValue(t.hasClass(o.activeClass) ? r() : i()), u.$render();
                    });
                });
            }
        };
    }), angular.module("ui.bootstrap.carousel", []).controller("CarouselController", [ "$scope", "$interval", "$animate", function(e, t, n) {
        function a(e) {
            if (angular.isUndefined(c[e].index)) return c[e];
            var t;
            c.length;
            for (t = 0; t < c.length; ++t) if (c[t].index == e) return c[t];
        }
        function i() {
            r();
            var n = +e.interval;
            !isNaN(n) && n > 0 && (o = t(s, n));
        }
        function r() {
            o && (t.cancel(o), o = null);
        }
        function s() {
            var t = +e.interval;
            u && !isNaN(t) && t > 0 ? e.next() : e.pause();
        }
        var o, u, l = this, c = l.slides = e.slides = [], d = -1;
        l.currentSlide = null;
        var f = !1;
        l.select = e.select = function(t, a) {
            function r() {
                f || (angular.extend(t, {
                    direction: a,
                    active: !0
                }), angular.extend(l.currentSlide || {}, {
                    direction: a,
                    active: !1
                }), n.enabled() && !e.noTransition && t.$element && (e.$currentTransition = !0, 
                t.$element.one("$animate:close", function() {
                    e.$currentTransition = null;
                })), l.currentSlide = t, d = s, i());
            }
            var s = l.indexOfSlide(t);
            void 0 === a && (a = s > l.getCurrentIndex() ? "next" : "prev"), t && t !== l.currentSlide && r();
        }, e.$on("$destroy", function() {
            f = !0;
        }), l.getCurrentIndex = function() {
            return l.currentSlide && angular.isDefined(l.currentSlide.index) ? +l.currentSlide.index : d;
        }, l.indexOfSlide = function(e) {
            return angular.isDefined(e.index) ? +e.index : c.indexOf(e);
        }, e.next = function() {
            var t = (l.getCurrentIndex() + 1) % c.length;
            if (!e.$currentTransition) return l.select(a(t), "next");
        }, e.prev = function() {
            var t = l.getCurrentIndex() - 1 < 0 ? c.length - 1 : l.getCurrentIndex() - 1;
            if (!e.$currentTransition) return l.select(a(t), "prev");
        }, e.isActive = function(e) {
            return l.currentSlide === e;
        }, e.$watch("interval", i), e.$on("$destroy", r), e.play = function() {
            u || (u = !0, i());
        }, e.pause = function() {
            e.noPause || (u = !1, r());
        }, l.addSlide = function(t, n) {
            t.$element = n, c.push(t), 1 === c.length || t.active ? (l.select(c[c.length - 1]), 
            1 == c.length && e.play()) : t.active = !1;
        }, l.removeSlide = function(e) {
            angular.isDefined(e.index) && c.sort(function(e, t) {
                return +e.index > +t.index;
            });
            var t = c.indexOf(e);
            c.splice(t, 1), c.length > 0 && e.active ? t >= c.length ? l.select(c[t - 1]) : l.select(c[t]) : d > t && d--;
        };
    } ]).directive("carousel", [ function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            controller: "CarouselController",
            require: "carousel",
            templateUrl: "template/carousel/carousel.html",
            scope: {
                interval: "=",
                noTransition: "=",
                noPause: "="
            }
        };
    } ]).directive("slide", function() {
        return {
            require: "^carousel",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: "template/carousel/slide.html",
            scope: {
                active: "=?",
                index: "=?"
            },
            link: function(e, t, n, a) {
                a.addSlide(e, t), e.$on("$destroy", function() {
                    a.removeSlide(e);
                }), e.$watch("active", function(t) {
                    t && a.select(e);
                });
            }
        };
    }).animation(".item", [ "$animate", function(e) {
        return {
            beforeAddClass: function(t, n, a) {
                if ("active" == n && t.parent() && !t.parent().scope().noTransition) {
                    var i = !1, r = t.isolateScope().direction, s = "next" == r ? "left" : "right";
                    return t.addClass(r), e.addClass(t, s).then(function() {
                        i || t.removeClass(s + " " + r), a();
                    }), function() {
                        i = !0;
                    };
                }
                a();
            },
            beforeRemoveClass: function(t, n, a) {
                if ("active" == n && t.parent() && !t.parent().scope().noTransition) {
                    var i = !1, r = t.isolateScope().direction, s = "next" == r ? "left" : "right";
                    return e.addClass(t, s).then(function() {
                        i || t.removeClass(s), a();
                    }), function() {
                        i = !0;
                    };
                }
                a();
            }
        };
    } ]), angular.module("ui.bootstrap.dateparser", []).service("dateParser", [ "$locale", "orderByFilter", function(e, t) {
        function n(e) {
            var n = [], a = e.split("");
            return angular.forEach(r, function(t, i) {
                var r = e.indexOf(i);
                if (r > -1) {
                    e = e.split(""), a[r] = "(" + t.regex + ")", e[r] = "$";
                    for (var s = r + 1, o = r + i.length; s < o; s++) a[s] = "", e[s] = "$";
                    e = e.join(""), n.push({
                        index: r,
                        apply: t.apply
                    });
                }
            }), {
                regex: new RegExp("^" + a.join("") + "$"),
                map: t(n, "index")
            };
        }
        function a(e, t, n) {
            return !(n < 1) && (1 === t && n > 28 ? 29 === n && (e % 4 === 0 && e % 100 !== 0 || e % 400 === 0) : 3 !== t && 5 !== t && 8 !== t && 10 !== t || n < 31);
        }
        var i = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
        this.parsers = {};
        var r = {
            yyyy: {
                regex: "\\d{4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            yy: {
                regex: "\\d{2}",
                apply: function(e) {
                    this.year = +e + 2e3;
                }
            },
            y: {
                regex: "\\d{1,4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            MMMM: {
                regex: e.DATETIME_FORMATS.MONTH.join("|"),
                apply: function(t) {
                    this.month = e.DATETIME_FORMATS.MONTH.indexOf(t);
                }
            },
            MMM: {
                regex: e.DATETIME_FORMATS.SHORTMONTH.join("|"),
                apply: function(t) {
                    this.month = e.DATETIME_FORMATS.SHORTMONTH.indexOf(t);
                }
            },
            MM: {
                regex: "0[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            M: {
                regex: "[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            dd: {
                regex: "[0-2][0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            d: {
                regex: "[1-2]?[0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            EEEE: {
                regex: e.DATETIME_FORMATS.DAY.join("|")
            },
            EEE: {
                regex: e.DATETIME_FORMATS.SHORTDAY.join("|")
            },
            HH: {
                regex: "(?:0|1)[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            H: {
                regex: "1?[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            mm: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            m: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            sss: {
                regex: "[0-9][0-9][0-9]",
                apply: function(e) {
                    this.milliseconds = +e;
                }
            },
            ss: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            },
            s: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            }
        };
        this.parse = function(t, r, s) {
            if (!angular.isString(t) || !r) return t;
            r = e.DATETIME_FORMATS[r] || r, r = r.replace(i, "\\$&"), this.parsers[r] || (this.parsers[r] = n(r));
            var o = this.parsers[r], u = o.regex, l = o.map, c = t.match(u);
            if (c && c.length) {
                var d, f;
                d = s ? {
                    year: s.getFullYear(),
                    month: s.getMonth(),
                    date: s.getDate(),
                    hours: s.getHours(),
                    minutes: s.getMinutes(),
                    seconds: s.getSeconds(),
                    milliseconds: s.getMilliseconds()
                } : {
                    year: 1900,
                    month: 0,
                    date: 1,
                    hours: 0,
                    minutes: 0,
                    seconds: 0,
                    milliseconds: 0
                };
                for (var m = 1, p = c.length; m < p; m++) {
                    var h = l[m - 1];
                    h.apply && h.apply.call(d, c[m]);
                }
                return a(d.year, d.month, d.date) && (f = new Date(d.year, d.month, d.date, d.hours, d.minutes, d.seconds, d.milliseconds || 0)), 
                f;
            }
        };
    } ]), angular.module("ui.bootstrap.position", []).factory("$position", [ "$document", "$window", function(e, t) {
        function n(e, n) {
            return e.currentStyle ? e.currentStyle[n] : t.getComputedStyle ? t.getComputedStyle(e)[n] : e.style[n];
        }
        function a(e) {
            return "static" === (n(e, "position") || "static");
        }
        var i = function(t) {
            for (var n = e[0], i = t.offsetParent || n; i && i !== n && a(i); ) i = i.offsetParent;
            return i || n;
        };
        return {
            position: function(t) {
                var n = this.offset(t), a = {
                    top: 0,
                    left: 0
                }, r = i(t[0]);
                r != e[0] && (a = this.offset(angular.element(r)), a.top += r.clientTop - r.scrollTop, 
                a.left += r.clientLeft - r.scrollLeft);
                var s = t[0].getBoundingClientRect();
                return {
                    width: s.width || t.prop("offsetWidth"),
                    height: s.height || t.prop("offsetHeight"),
                    top: n.top - a.top,
                    left: n.left - a.left
                };
            },
            offset: function(n) {
                var a = n[0].getBoundingClientRect();
                return {
                    width: a.width || n.prop("offsetWidth"),
                    height: a.height || n.prop("offsetHeight"),
                    top: a.top + (t.pageYOffset || e[0].documentElement.scrollTop),
                    left: a.left + (t.pageXOffset || e[0].documentElement.scrollLeft)
                };
            },
            positionElements: function(e, t, n, a) {
                var i, r, s, o, u = n.split("-"), l = u[0], c = u[1] || "center";
                i = a ? this.offset(e) : this.position(e), r = t.prop("offsetWidth"), s = t.prop("offsetHeight");
                var d = {
                    center: function() {
                        return i.left + i.width / 2 - r / 2;
                    },
                    left: function() {
                        return i.left;
                    },
                    right: function() {
                        return i.left + i.width;
                    }
                }, f = {
                    center: function() {
                        return i.top + i.height / 2 - s / 2;
                    },
                    top: function() {
                        return i.top;
                    },
                    bottom: function() {
                        return i.top + i.height;
                    }
                };
                switch (l) {
                  case "right":
                    o = {
                        top: f[c](),
                        left: d[l]()
                    };
                    break;

                  case "left":
                    o = {
                        top: f[c](),
                        left: i.left - r
                    };
                    break;

                  case "bottom":
                    o = {
                        top: f[l](),
                        left: d[c]()
                    };
                    break;

                  default:
                    o = {
                        top: i.top - s,
                        left: d[c]()
                    };
                }
                return o;
            }
        };
    } ]), angular.module("ui.bootstrap.datepicker", [ "ui.bootstrap.dateparser", "ui.bootstrap.position" ]).constant("datepickerConfig", {
        formatDay: "dd",
        formatMonth: "MMMM",
        formatYear: "yyyy",
        formatDayHeader: "EEE",
        formatDayTitle: "MMMM yyyy",
        formatMonthTitle: "yyyy",
        datepickerMode: "day",
        minMode: "day",
        maxMode: "year",
        showWeeks: !0,
        startingDay: 0,
        yearRange: 20,
        minDate: null,
        maxDate: null,
        shortcutPropagation: !1
    }).controller("DatepickerController", [ "$scope", "$attrs", "$parse", "$interpolate", "$timeout", "$log", "dateFilter", "datepickerConfig", function(e, t, n, a, i, r, s, o) {
        var u = this, l = {
            $setViewValue: angular.noop
        };
        this.modes = [ "day", "month", "year" ], angular.forEach([ "formatDay", "formatMonth", "formatYear", "formatDayHeader", "formatDayTitle", "formatMonthTitle", "minMode", "maxMode", "showWeeks", "startingDay", "yearRange", "shortcutPropagation" ], function(n, i) {
            u[n] = angular.isDefined(t[n]) ? i < 8 ? a(t[n])(e.$parent) : e.$parent.$eval(t[n]) : o[n];
        }), angular.forEach([ "minDate", "maxDate" ], function(a) {
            t[a] ? e.$parent.$watch(n(t[a]), function(e) {
                u[a] = e ? new Date(e) : null, u.refreshView();
            }) : u[a] = o[a] ? new Date(o[a]) : null;
        }), e.datepickerMode = e.datepickerMode || o.datepickerMode, e.maxMode = u.maxMode, 
        e.uniqueId = "datepicker-" + e.$id + "-" + Math.floor(1e4 * Math.random()), angular.isDefined(t.initDate) ? (this.activeDate = e.$parent.$eval(t.initDate) || new Date(), 
        e.$parent.$watch(t.initDate, function(e) {
            e && (l.$isEmpty(l.$modelValue) || l.$invalid) && (u.activeDate = e, u.refreshView());
        })) : this.activeDate = new Date(), e.isActive = function(t) {
            return 0 === u.compare(t.date, u.activeDate) && (e.activeDateId = t.uid, !0);
        }, this.init = function(e) {
            l = e, l.$render = function() {
                u.render();
            };
        }, this.render = function() {
            if (l.$viewValue) {
                var e = new Date(l.$viewValue), t = !isNaN(e);
                t ? this.activeDate = e : r.error('Datepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.'), 
                l.$setValidity("date", t);
            }
            this.refreshView();
        }, this.refreshView = function() {
            if (this.element) {
                this._refreshView();
                var e = l.$viewValue ? new Date(l.$viewValue) : null;
                l.$setValidity("date-disabled", !e || this.element && !this.isDisabled(e));
            }
        }, this.createDateObject = function(e, t) {
            var n = l.$viewValue ? new Date(l.$viewValue) : null;
            return {
                date: e,
                label: s(e, t),
                selected: n && 0 === this.compare(e, n),
                disabled: this.isDisabled(e),
                current: 0 === this.compare(e, new Date()),
                customClass: this.customClass(e)
            };
        }, this.isDisabled = function(n) {
            return this.minDate && this.compare(n, this.minDate) < 0 || this.maxDate && this.compare(n, this.maxDate) > 0 || t.dateDisabled && e.dateDisabled({
                date: n,
                mode: e.datepickerMode
            });
        }, this.customClass = function(t) {
            return e.customClass({
                date: t,
                mode: e.datepickerMode
            });
        }, this.split = function(e, t) {
            for (var n = []; e.length > 0; ) n.push(e.splice(0, t));
            return n;
        }, e.select = function(t) {
            if (e.datepickerMode === u.minMode) {
                var n = l.$viewValue ? new Date(l.$viewValue) : new Date(0, 0, 0, 0, 0, 0, 0);
                n.setFullYear(t.getFullYear(), t.getMonth(), t.getDate()), l.$setViewValue(n), l.$render();
            } else u.activeDate = t, e.datepickerMode = u.modes[u.modes.indexOf(e.datepickerMode) - 1];
        }, e.move = function(e) {
            var t = u.activeDate.getFullYear() + e * (u.step.years || 0), n = u.activeDate.getMonth() + e * (u.step.months || 0);
            u.activeDate.setFullYear(t, n, 1), u.refreshView();
        }, e.toggleMode = function(t) {
            t = t || 1, e.datepickerMode === u.maxMode && 1 === t || e.datepickerMode === u.minMode && t === -1 || (e.datepickerMode = u.modes[u.modes.indexOf(e.datepickerMode) + t]);
        }, e.keys = {
            13: "enter",
            32: "space",
            33: "pageup",
            34: "pagedown",
            35: "end",
            36: "home",
            37: "left",
            38: "up",
            39: "right",
            40: "down"
        };
        var c = function() {
            i(function() {
                u.element[0].focus();
            }, 0, !1);
        };
        e.$on("datepicker.focus", c), e.keydown = function(t) {
            var n = e.keys[t.which];
            if (n && !t.shiftKey && !t.altKey) if (t.preventDefault(), u.shortcutPropagation || t.stopPropagation(), 
            "enter" === n || "space" === n) {
                if (u.isDisabled(u.activeDate)) return;
                e.select(u.activeDate), c();
            } else !t.ctrlKey || "up" !== n && "down" !== n ? (u.handleKeyDown(n, t), u.refreshView()) : (e.toggleMode("up" === n ? 1 : -1), 
            c());
        };
    } ]).directive("datepicker", function() {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/datepicker.html",
            scope: {
                datepickerMode: "=?",
                dateDisabled: "&",
                customClass: "&",
                shortcutPropagation: "&?"
            },
            require: [ "datepicker", "?^ngModel" ],
            controller: "DatepickerController",
            link: function(e, t, n, a) {
                var i = a[0], r = a[1];
                r && i.init(r);
            }
        };
    }).directive("daypicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/day.html",
            require: "^datepicker",
            link: function(t, n, a, i) {
                function r(e, t) {
                    return 1 !== t || e % 4 !== 0 || e % 100 === 0 && e % 400 !== 0 ? u[t] : 29;
                }
                function s(e, t) {
                    var n = new Array(t), a = new Date(e), i = 0;
                    for (a.setHours(12); i < t; ) n[i++] = new Date(a), a.setDate(a.getDate() + 1);
                    return n;
                }
                function o(e) {
                    var t = new Date(e);
                    t.setDate(t.getDate() + 4 - (t.getDay() || 7));
                    var n = t.getTime();
                    return t.setMonth(0), t.setDate(1), Math.floor(Math.round((n - t) / 864e5) / 7) + 1;
                }
                t.showWeeks = i.showWeeks, i.step = {
                    months: 1
                }, i.element = n;
                var u = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
                i._refreshView = function() {
                    var n = i.activeDate.getFullYear(), a = i.activeDate.getMonth(), r = new Date(n, a, 1), u = i.startingDay - r.getDay(), l = u > 0 ? 7 - u : -u, c = new Date(r);
                    l > 0 && c.setDate(-l + 1);
                    for (var d = s(c, 42), f = 0; f < 42; f++) d[f] = angular.extend(i.createDateObject(d[f], i.formatDay), {
                        secondary: d[f].getMonth() !== a,
                        uid: t.uniqueId + "-" + f
                    });
                    t.labels = new Array(7);
                    for (var m = 0; m < 7; m++) t.labels[m] = {
                        abbr: e(d[m].date, i.formatDayHeader),
                        full: e(d[m].date, "EEEE")
                    };
                    if (t.title = e(i.activeDate, i.formatDayTitle), t.rows = i.split(d, 7), t.showWeeks) {
                        t.weekNumbers = [];
                        for (var p = (11 - i.startingDay) % 7, h = t.rows.length, g = 0; g < h; g++) t.weekNumbers.push(o(t.rows[g][p].date));
                    }
                }, i.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth(), e.getDate()) - new Date(t.getFullYear(), t.getMonth(), t.getDate());
                }, i.handleKeyDown = function(e, t) {
                    var n = i.activeDate.getDate();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 7; else if ("right" === e) n += 1; else if ("down" === e) n += 7; else if ("pageup" === e || "pagedown" === e) {
                        var a = i.activeDate.getMonth() + ("pageup" === e ? -1 : 1);
                        i.activeDate.setMonth(a, 1), n = Math.min(r(i.activeDate.getFullYear(), i.activeDate.getMonth()), n);
                    } else "home" === e ? n = 1 : "end" === e && (n = r(i.activeDate.getFullYear(), i.activeDate.getMonth()));
                    i.activeDate.setDate(n);
                }, i.refreshView();
            }
        };
    } ]).directive("monthpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/month.html",
            require: "^datepicker",
            link: function(t, n, a, i) {
                i.step = {
                    years: 1
                }, i.element = n, i._refreshView = function() {
                    for (var n = new Array(12), a = i.activeDate.getFullYear(), r = 0; r < 12; r++) n[r] = angular.extend(i.createDateObject(new Date(a, r, 1), i.formatMonth), {
                        uid: t.uniqueId + "-" + r
                    });
                    t.title = e(i.activeDate, i.formatMonthTitle), t.rows = i.split(n, 3);
                }, i.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth()) - new Date(t.getFullYear(), t.getMonth());
                }, i.handleKeyDown = function(e, t) {
                    var n = i.activeDate.getMonth();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 3; else if ("right" === e) n += 1; else if ("down" === e) n += 3; else if ("pageup" === e || "pagedown" === e) {
                        var a = i.activeDate.getFullYear() + ("pageup" === e ? -1 : 1);
                        i.activeDate.setFullYear(a);
                    } else "home" === e ? n = 0 : "end" === e && (n = 11);
                    i.activeDate.setMonth(n);
                }, i.refreshView();
            }
        };
    } ]).directive("yearpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/year.html",
            require: "^datepicker",
            link: function(e, t, n, a) {
                function i(e) {
                    return parseInt((e - 1) / r, 10) * r + 1;
                }
                var r = a.yearRange;
                a.step = {
                    years: r
                }, a.element = t, a._refreshView = function() {
                    for (var t = new Array(r), n = 0, s = i(a.activeDate.getFullYear()); n < r; n++) t[n] = angular.extend(a.createDateObject(new Date(s + n, 0, 1), a.formatYear), {
                        uid: e.uniqueId + "-" + n
                    });
                    e.title = [ t[0].label, t[r - 1].label ].join(" - "), e.rows = a.split(t, 5);
                }, a.compare = function(e, t) {
                    return e.getFullYear() - t.getFullYear();
                }, a.handleKeyDown = function(e, t) {
                    var n = a.activeDate.getFullYear();
                    "left" === e ? n -= 1 : "up" === e ? n -= 5 : "right" === e ? n += 1 : "down" === e ? n += 5 : "pageup" === e || "pagedown" === e ? n += ("pageup" === e ? -1 : 1) * a.step.years : "home" === e ? n = i(a.activeDate.getFullYear()) : "end" === e && (n = i(a.activeDate.getFullYear()) + r - 1), 
                    a.activeDate.setFullYear(n);
                }, a.refreshView();
            }
        };
    } ]).constant("datepickerPopupConfig", {
        datepickerPopup: "yyyy-MM-dd",
        html5Types: {
            date: "yyyy-MM-dd",
            "datetime-local": "yyyy-MM-ddTHH:mm:ss.sss",
            month: "yyyy-MM"
        },
        currentText: "Today",
        clearText: "Clear",
        closeText: "Done",
        closeOnDateSelection: !0,
        appendToBody: !1,
        showButtonBar: !0
    }).directive("datepickerPopup", [ "$compile", "$parse", "$document", "$position", "dateFilter", "dateParser", "datepickerPopupConfig", function(e, t, n, a, i, r, s) {
        return {
            restrict: "EA",
            require: "ngModel",
            scope: {
                isOpen: "=?",
                currentText: "@",
                clearText: "@",
                closeText: "@",
                dateDisabled: "&",
                customClass: "&"
            },
            link: function(o, u, l, c) {
                function d(e) {
                    return e.replace(/([A-Z])/g, function(e) {
                        return "-" + e.toLowerCase();
                    });
                }
                function f(e) {
                    angular.isNumber(e) && (e = new Date(e));
                    {
                        if (!e) return null;
                        if (angular.isDate(e) && !isNaN(e)) return e;
                        if (angular.isString(e)) {
                            var t = r.parse(e, p, o.date) || new Date(e);
                            return isNaN(t) ? void 0 : t;
                        }
                    }
                }
                function m(e, t) {
                    var n = e || t;
                    if (angular.isNumber(n) && (n = new Date(n)), n) {
                        if (angular.isDate(n) && !isNaN(n)) return !0;
                        if (angular.isString(n)) {
                            var a = r.parse(n, p) || new Date(n);
                            return !isNaN(a);
                        }
                        return !1;
                    }
                    return !0;
                }
                var p, h = angular.isDefined(l.closeOnDateSelection) ? o.$parent.$eval(l.closeOnDateSelection) : s.closeOnDateSelection, g = angular.isDefined(l.datepickerAppendToBody) ? o.$parent.$eval(l.datepickerAppendToBody) : s.appendToBody;
                o.showButtonBar = angular.isDefined(l.showButtonBar) ? o.$parent.$eval(l.showButtonBar) : s.showButtonBar, 
                o.getText = function(e) {
                    return o[e + "Text"] || s[e + "Text"];
                };
                var _ = !1;
                if (s.html5Types[l.type] ? (p = s.html5Types[l.type], _ = !0) : (p = l.datepickerPopup || s.datepickerPopup, 
                l.$observe("datepickerPopup", function(e, t) {
                    var n = e || s.datepickerPopup;
                    if (n !== p && (p = n, c.$modelValue = null, !p)) throw new Error("datepickerPopup must have a date format specified.");
                })), !p) throw new Error("datepickerPopup must have a date format specified.");
                if (_ && l.datepickerPopup) throw new Error("HTML5 date input types do not support custom formats.");
                var v = angular.element("<div datepicker-popup-wrap><div datepicker></div></div>");
                v.attr({
                    "ng-model": "date",
                    "ng-change": "dateSelection()"
                });
                var b = angular.element(v.children()[0]);
                if (_ && "month" == l.type && (b.attr("datepicker-mode", '"month"'), b.attr("min-mode", "month")), 
                l.datepickerOptions) {
                    var y = o.$parent.$eval(l.datepickerOptions);
                    y.initDate && (o.initDate = y.initDate, b.attr("init-date", "initDate"), delete y.initDate), 
                    angular.forEach(y, function(e, t) {
                        b.attr(d(t), e);
                    });
                }
                o.watchData = {}, angular.forEach([ "minDate", "maxDate", "datepickerMode", "initDate", "shortcutPropagation" ], function(e) {
                    if (l[e]) {
                        var n = t(l[e]);
                        if (o.$parent.$watch(n, function(t) {
                            o.watchData[e] = t;
                        }), b.attr(d(e), "watchData." + e), "datepickerMode" === e) {
                            var a = n.assign;
                            o.$watch("watchData." + e, function(e, t) {
                                e !== t && a(o.$parent, e);
                            });
                        }
                    }
                }), l.dateDisabled && b.attr("date-disabled", "dateDisabled({ date: date, mode: mode })"), 
                l.showWeeks && b.attr("show-weeks", l.showWeeks), l.customClass && b.attr("custom-class", "customClass({ date: date, mode: mode })"), 
                _ ? c.$formatters.push(function(e) {
                    return o.date = e, e;
                }) : (c.$$parserName = "date", c.$validators.date = m, c.$parsers.unshift(f), c.$formatters.push(function(e) {
                    return o.date = e, c.$isEmpty(e) ? e : i(e, p);
                })), o.dateSelection = function(e) {
                    angular.isDefined(e) && (o.date = e);
                    var t = o.date ? i(o.date, p) : "";
                    u.val(t), c.$setViewValue(t), h && (o.isOpen = !1, u[0].focus());
                }, c.$viewChangeListeners.push(function() {
                    o.date = r.parse(c.$viewValue, p, o.date) || new Date(c.$viewValue);
                });
                var M = function(e) {
                    o.isOpen && e.target !== u[0] && o.$apply(function() {
                        o.isOpen = !1;
                    });
                }, $ = function(e, t) {
                    o.keydown(e);
                };
                u.bind("keydown", $), o.keydown = function(e) {
                    27 === e.which ? (e.preventDefault(), o.isOpen && e.stopPropagation(), o.close()) : 40 !== e.which || o.isOpen || (o.isOpen = !0);
                }, o.$watch("isOpen", function(e) {
                    e ? (o.$broadcast("datepicker.focus"), o.position = g ? a.offset(u) : a.position(u), 
                    o.position.top = o.position.top + u.prop("offsetHeight"), n.bind("click", M)) : n.unbind("click", M);
                }), o.select = function(e) {
                    if ("today" === e) {
                        var t = new Date();
                        angular.isDate(o.date) ? (e = new Date(o.date), e.setFullYear(t.getFullYear(), t.getMonth(), t.getDate())) : e = new Date(t.setHours(0, 0, 0, 0));
                    }
                    o.dateSelection(e);
                }, o.close = function() {
                    o.isOpen = !1, u[0].focus();
                };
                var k = e(v)(o);
                v.remove(), g ? n.find("body").append(k) : u.after(k), o.$on("$destroy", function() {
                    k.remove(), u.unbind("keydown", $), n.unbind("click", M);
                });
            }
        };
    } ]).directive("datepickerPopupWrap", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            templateUrl: "template/datepicker/popup.html",
            link: function(e, t, n) {
                t.bind("click", function(e) {
                    e.preventDefault(), e.stopPropagation();
                });
            }
        };
    }), angular.module("ui.bootstrap.dropdown", [ "ui.bootstrap.position" ]).constant("dropdownConfig", {
        openClass: "open"
    }).service("dropdownService", [ "$document", "$rootScope", function(e, t) {
        var n = null;
        this.open = function(t) {
            n || (e.bind("click", a), e.bind("keydown", i)), n && n !== t && (n.isOpen = !1), 
            n = t;
        }, this.close = function(t) {
            n === t && (n = null, e.unbind("click", a), e.unbind("keydown", i));
        };
        var a = function(e) {
            if (n && (!e || "disabled" !== n.getAutoClose())) {
                var a = n.getToggleElement();
                if (!(e && a && a[0].contains(e.target))) {
                    var i = n.getElement();
                    e && "outsideClick" === n.getAutoClose() && i && i[0].contains(e.target) || (n.isOpen = !1, 
                    t.$$phase || n.$apply());
                }
            }
        }, i = function(e) {
            27 === e.which && (n.focusToggleElement(), a());
        };
    } ]).controller("DropdownController", [ "$scope", "$attrs", "$parse", "dropdownConfig", "dropdownService", "$animate", "$position", "$document", function(e, t, n, a, i, r, s, o) {
        var u, l = this, c = e.$new(), d = a.openClass, f = angular.noop, m = t.onToggle ? n(t.onToggle) : angular.noop, p = !1;
        this.init = function(a) {
            l.$element = a, t.isOpen && (u = n(t.isOpen), f = u.assign, e.$watch(u, function(e) {
                c.isOpen = !!e;
            })), p = angular.isDefined(t.dropdownAppendToBody), p && l.dropdownMenu && (o.find("body").append(l.dropdownMenu), 
            a.on("$destroy", function() {
                l.dropdownMenu.remove();
            }));
        }, this.toggle = function(e) {
            return c.isOpen = arguments.length ? !!e : !c.isOpen;
        }, this.isOpen = function() {
            return c.isOpen;
        }, c.getToggleElement = function() {
            return l.toggleElement;
        }, c.getAutoClose = function() {
            return t.autoClose || "always";
        }, c.getElement = function() {
            return l.$element;
        }, c.focusToggleElement = function() {
            l.toggleElement && l.toggleElement[0].focus();
        }, c.$watch("isOpen", function(t, n) {
            if (p && l.dropdownMenu) {
                var a = s.positionElements(l.$element, l.dropdownMenu, "bottom-left", !0);
                l.dropdownMenu.css({
                    top: a.top + "px",
                    left: a.left + "px",
                    display: t ? "block" : "none"
                });
            }
            r[t ? "addClass" : "removeClass"](l.$element, d), t ? (c.focusToggleElement(), i.open(c)) : i.close(c), 
            f(e, t), angular.isDefined(t) && t !== n && m(e, {
                open: !!t
            });
        }), e.$on("$locationChangeSuccess", function() {
            c.isOpen = !1;
        }), e.$on("$destroy", function() {
            c.$destroy();
        });
    } ]).directive("dropdown", function() {
        return {
            controller: "DropdownController",
            link: function(e, t, n, a) {
                a.init(t);
            }
        };
    }).directive("dropdownMenu", function() {
        return {
            restrict: "AC",
            require: "?^dropdown",
            link: function(e, t, n, a) {
                a && (a.dropdownMenu = t);
            }
        };
    }).directive("dropdownToggle", function() {
        return {
            require: "?^dropdown",
            link: function(e, t, n, a) {
                if (a) {
                    a.toggleElement = t;
                    var i = function(i) {
                        i.preventDefault(), t.hasClass("disabled") || n.disabled || e.$apply(function() {
                            a.toggle();
                        });
                    };
                    t.bind("click", i), t.attr({
                        "aria-haspopup": !0,
                        "aria-expanded": !1
                    }), e.$watch(a.isOpen, function(e) {
                        t.attr("aria-expanded", !!e);
                    }), e.$on("$destroy", function() {
                        t.unbind("click", i);
                    });
                }
            }
        };
    }), angular.module("ui.bootstrap.modal", []).factory("$$stackedMap", function() {
        return {
            createNew: function() {
                var e = [];
                return {
                    add: function(t, n) {
                        e.push({
                            key: t,
                            value: n
                        });
                    },
                    get: function(t) {
                        for (var n = 0; n < e.length; n++) if (t == e[n].key) return e[n];
                    },
                    keys: function() {
                        for (var t = [], n = 0; n < e.length; n++) t.push(e[n].key);
                        return t;
                    },
                    top: function() {
                        return e[e.length - 1];
                    },
                    remove: function(t) {
                        for (var n = -1, a = 0; a < e.length; a++) if (t == e[a].key) {
                            n = a;
                            break;
                        }
                        return e.splice(n, 1)[0];
                    },
                    removeTop: function() {
                        return e.splice(e.length - 1, 1)[0];
                    },
                    length: function() {
                        return e.length;
                    }
                };
            }
        };
    }).directive("modalBackdrop", [ "$timeout", function(e) {
        function t(t, n, a) {
            t.animate = !1, e(function() {
                t.animate = !0;
            });
        }
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/modal/backdrop.html",
            compile: function(e, n) {
                return e.addClass(n.backdropClass), t;
            }
        };
    } ]).directive("modalWindow", [ "$modalStack", "$q", function(e, t) {
        return {
            restrict: "EA",
            scope: {
                index: "@",
                animate: "="
            },
            replace: !0,
            transclude: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/modal/window.html";
            },
            link: function(n, a, i) {
                a.addClass(i.windowClass || ""), n.size = i.size, n.close = function(t) {
                    var n = e.getTop();
                    n && n.value.backdrop && "static" != n.value.backdrop && t.target === t.currentTarget && (t.preventDefault(), 
                    t.stopPropagation(), e.dismiss(n.key, "backdrop click"));
                }, n.$isRendered = !0;
                var r = t.defer();
                i.$observe("modalRender", function(e) {
                    "true" == e && r.resolve();
                }), r.promise.then(function() {
                    n.animate = !0;
                    var t = a[0].querySelectorAll("[autofocus]");
                    t.length ? t[0].focus() : a[0].focus();
                    var i = e.getTop();
                    i && e.modalRendered(i.key);
                });
            }
        };
    } ]).directive("modalAnimationClass", [ function() {
        return {
            compile: function(e, t) {
                t.modalAnimation && e.addClass(t.modalAnimationClass);
            }
        };
    } ]).directive("modalTransclude", function() {
        return {
            link: function(e, t, n, a, i) {
                i(e.$parent, function(e) {
                    t.empty(), t.append(e);
                });
            }
        };
    }).factory("$modalStack", [ "$animate", "$timeout", "$document", "$compile", "$rootScope", "$$stackedMap", function(e, t, n, a, i, r) {
        function s() {
            for (var e = -1, t = p.keys(), n = 0; n < t.length; n++) p.get(t[n]).value.backdrop && (e = n);
            return e;
        }
        function o(e) {
            var t = n.find("body").eq(0), a = p.get(e).value;
            p.remove(e), l(a.modalDomEl, a.modalScope, function() {
                t.toggleClass(m, p.length() > 0), u();
            });
        }
        function u() {
            if (d && s() == -1) {
                var e = f;
                l(d, f, function() {
                    e = null;
                }), d = void 0, f = void 0;
            }
        }
        function l(n, a, r) {
            function s() {
                s.done || (s.done = !0, n.remove(), a.$destroy(), r && r());
            }
            a.animate = !1, n.attr("modal-animation") && e.enabled() ? n.one("$animate:close", function() {
                i.$evalAsync(s);
            }) : t(s);
        }
        function c(e, t, n) {
            return !e.value.modalScope.$broadcast("modal.closing", t, n).defaultPrevented;
        }
        var d, f, m = "modal-open", p = r.createNew(), h = {};
        return i.$watch(s, function(e) {
            f && (f.index = e);
        }), n.bind("keydown", function(e) {
            var t;
            27 === e.which && (t = p.top(), t && t.value.keyboard && (e.preventDefault(), i.$apply(function() {
                h.dismiss(t.key, "escape key press");
            })));
        }), h.open = function(e, t) {
            var r = n[0].activeElement;
            p.add(e, {
                deferred: t.deferred,
                renderDeferred: t.renderDeferred,
                modalScope: t.scope,
                backdrop: t.backdrop,
                keyboard: t.keyboard
            });
            var o = n.find("body").eq(0), u = s();
            if (u >= 0 && !d) {
                f = i.$new(!0), f.index = u;
                var l = angular.element('<div modal-backdrop="modal-backdrop"></div>');
                l.attr("backdrop-class", t.backdropClass), t.animation && l.attr("modal-animation", "true"), 
                d = a(l)(f), o.append(d);
            }
            var c = angular.element('<div modal-window="modal-window"></div>');
            c.attr({
                "template-url": t.windowTemplateUrl,
                "window-class": t.windowClass,
                size: t.size,
                index: p.length() - 1,
                animate: "animate"
            }).html(t.content), t.animation && c.attr("modal-animation", "true");
            var h = a(c)(t.scope);
            p.top().value.modalDomEl = h, p.top().value.modalOpener = r, o.append(h), o.addClass(m);
        }, h.close = function(e, t) {
            var n = p.get(e);
            return n && c(n, t, !0) ? (n.value.deferred.resolve(t), o(e), n.value.modalOpener.focus(), 
            !0) : !n;
        }, h.dismiss = function(e, t) {
            var n = p.get(e);
            return n && c(n, t, !1) ? (n.value.deferred.reject(t), o(e), n.value.modalOpener.focus(), 
            !0) : !n;
        }, h.dismissAll = function(e) {
            for (var t = this.getTop(); t && this.dismiss(t.key, e); ) t = this.getTop();
        }, h.getTop = function() {
            return p.top();
        }, h.modalRendered = function(e) {
            var t = p.get(e);
            t && t.value.renderDeferred.resolve();
        }, h;
    } ]).provider("$modal", function() {
        var e = {
            options: {
                animation: !0,
                backdrop: !0,
                keyboard: !0
            },
            $get: [ "$injector", "$rootScope", "$q", "$templateRequest", "$controller", "$modalStack", function(t, n, a, i, r, s) {
                function o(e) {
                    return e.template ? a.when(e.template) : i(angular.isFunction(e.templateUrl) ? e.templateUrl() : e.templateUrl);
                }
                function u(e) {
                    var n = [];
                    return angular.forEach(e, function(e) {
                        (angular.isFunction(e) || angular.isArray(e)) && n.push(a.when(t.invoke(e)));
                    }), n;
                }
                var l = {};
                return l.open = function(t) {
                    var i = a.defer(), l = a.defer(), c = a.defer(), d = {
                        result: i.promise,
                        opened: l.promise,
                        rendered: c.promise,
                        close: function(e) {
                            return s.close(d, e);
                        },
                        dismiss: function(e) {
                            return s.dismiss(d, e);
                        }
                    };
                    if (t = angular.extend({}, e.options, t), t.resolve = t.resolve || {}, !t.template && !t.templateUrl) throw new Error("One of template or templateUrl options is required.");
                    var f = a.all([ o(t) ].concat(u(t.resolve)));
                    return f.then(function(e) {
                        var a = (t.scope || n).$new();
                        a.$close = d.close, a.$dismiss = d.dismiss;
                        var o, u = {}, l = 1;
                        t.controller && (u.$scope = a, u.$modalInstance = d, angular.forEach(t.resolve, function(t, n) {
                            u[n] = e[l++];
                        }), o = r(t.controller, u), t.controllerAs && (a[t.controllerAs] = o)), s.open(d, {
                            scope: a,
                            deferred: i,
                            renderDeferred: c,
                            content: e[0],
                            animation: t.animation,
                            backdrop: t.backdrop,
                            keyboard: t.keyboard,
                            backdropClass: t.backdropClass,
                            windowClass: t.windowClass,
                            windowTemplateUrl: t.windowTemplateUrl,
                            size: t.size
                        });
                    }, function(e) {
                        i.reject(e);
                    }), f.then(function() {
                        l.resolve(!0);
                    }, function(e) {
                        l.reject(e);
                    }), d;
                }, l;
            } ]
        };
        return e;
    }), angular.module("ui.bootstrap.pagination", []).controller("PaginationController", [ "$scope", "$attrs", "$parse", function(e, t, n) {
        var a = this, i = {
            $setViewValue: angular.noop
        }, r = t.numPages ? n(t.numPages).assign : angular.noop;
        this.init = function(s, o) {
            i = s, this.config = o, i.$render = function() {
                a.render();
            }, t.itemsPerPage ? e.$parent.$watch(n(t.itemsPerPage), function(t) {
                a.itemsPerPage = parseInt(t, 10), e.totalPages = a.calculateTotalPages();
            }) : this.itemsPerPage = o.itemsPerPage, e.$watch("totalItems", function() {
                e.totalPages = a.calculateTotalPages();
            }), e.$watch("totalPages", function(t) {
                r(e.$parent, t), e.page > t ? e.selectPage(t) : i.$render();
            });
        }, this.calculateTotalPages = function() {
            var t = this.itemsPerPage < 1 ? 1 : Math.ceil(e.totalItems / this.itemsPerPage);
            return Math.max(t || 0, 1);
        }, this.render = function() {
            e.page = parseInt(i.$viewValue, 10) || 1;
        }, e.selectPage = function(t, n) {
            e.page !== t && t > 0 && t <= e.totalPages && (n && n.target && n.target.blur(), 
            i.$setViewValue(t), i.$render());
        }, e.getText = function(t) {
            return e[t + "Text"] || a.config[t + "Text"];
        }, e.noPrevious = function() {
            return 1 === e.page;
        }, e.noNext = function() {
            return e.page === e.totalPages;
        };
    } ]).constant("paginationConfig", {
        itemsPerPage: 10,
        boundaryLinks: !1,
        directionLinks: !0,
        firstText: "First",
        previousText: "Previous",
        nextText: "Next",
        lastText: "Last",
        rotate: !0
    }).directive("pagination", [ "$parse", "paginationConfig", function(e, t) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                firstText: "@",
                previousText: "@",
                nextText: "@",
                lastText: "@"
            },
            require: [ "pagination", "?ngModel" ],
            controller: "PaginationController",
            templateUrl: "template/pagination/pagination.html",
            replace: !0,
            link: function(n, a, i, r) {
                function s(e, t, n) {
                    return {
                        number: e,
                        text: t,
                        active: n
                    };
                }
                function o(e, t) {
                    var n = [], a = 1, i = t, r = angular.isDefined(c) && c < t;
                    r && (d ? (a = Math.max(e - Math.floor(c / 2), 1), i = a + c - 1, i > t && (i = t, 
                    a = i - c + 1)) : (a = (Math.ceil(e / c) - 1) * c + 1, i = Math.min(a + c - 1, t)));
                    for (var o = a; o <= i; o++) {
                        var u = s(o, o, o === e);
                        n.push(u);
                    }
                    if (r && !d) {
                        if (a > 1) {
                            var l = s(a - 1, "...", !1);
                            n.unshift(l);
                        }
                        if (i < t) {
                            var f = s(i + 1, "...", !1);
                            n.push(f);
                        }
                    }
                    return n;
                }
                var u = r[0], l = r[1];
                if (l) {
                    var c = angular.isDefined(i.maxSize) ? n.$parent.$eval(i.maxSize) : t.maxSize, d = angular.isDefined(i.rotate) ? n.$parent.$eval(i.rotate) : t.rotate;
                    n.boundaryLinks = angular.isDefined(i.boundaryLinks) ? n.$parent.$eval(i.boundaryLinks) : t.boundaryLinks, 
                    n.directionLinks = angular.isDefined(i.directionLinks) ? n.$parent.$eval(i.directionLinks) : t.directionLinks, 
                    u.init(l, t), i.maxSize && n.$parent.$watch(e(i.maxSize), function(e) {
                        c = parseInt(e, 10), u.render();
                    });
                    var f = u.render;
                    u.render = function() {
                        f(), n.page > 0 && n.page <= n.totalPages && (n.pages = o(n.page, n.totalPages));
                    };
                }
            }
        };
    } ]).constant("pagerConfig", {
        itemsPerPage: 10,
        previousText: "« Previous",
        nextText: "Next »",
        align: !0
    }).directive("pager", [ "pagerConfig", function(e) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                previousText: "@",
                nextText: "@"
            },
            require: [ "pager", "?ngModel" ],
            controller: "PaginationController",
            templateUrl: "template/pagination/pager.html",
            replace: !0,
            link: function(t, n, a, i) {
                var r = i[0], s = i[1];
                s && (t.align = angular.isDefined(a.align) ? t.$parent.$eval(a.align) : e.align, 
                r.init(s, e));
            }
        };
    } ]), angular.module("ui.bootstrap.tooltip", [ "ui.bootstrap.position", "ui.bootstrap.bindHtml" ]).provider("$tooltip", function() {
        function e(e) {
            var t = /[A-Z]/g, n = "-";
            return e.replace(t, function(e, t) {
                return (t ? n : "") + e.toLowerCase();
            });
        }
        var t = {
            placement: "top",
            animation: !0,
            popupDelay: 0,
            useContentExp: !1
        }, n = {
            mouseenter: "mouseleave",
            click: "click",
            focus: "blur"
        }, a = {};
        this.options = function(e) {
            angular.extend(a, e);
        }, this.setTriggers = function(e) {
            angular.extend(n, e);
        }, this.$get = [ "$window", "$compile", "$timeout", "$document", "$position", "$interpolate", function(i, r, s, o, u, l) {
            return function(i, c, d, f) {
                function m(e) {
                    var t = e || f.trigger || d, a = n[t] || t;
                    return {
                        show: t,
                        hide: a
                    };
                }
                f = angular.extend({}, t, a, f);
                var p = e(i), h = l.startSymbol(), g = l.endSymbol(), _ = "<div " + p + '-popup title="' + h + "title" + g + '" ' + (f.useContentExp ? 'content-exp="contentExp()" ' : 'content="' + h + "content" + g + '" ') + 'placement="' + h + "placement" + g + '" popup-class="' + h + "popupClass" + g + '" animation="animation" is-open="isOpen"origin-scope="origScope" ></div>';
                return {
                    restrict: "EA",
                    compile: function(e, t) {
                        var n = r(_);
                        return function(e, t, a, r) {
                            function l() {
                                C.isOpen ? p() : d();
                            }
                            function d() {
                                x && !e.$eval(a[c + "Enable"]) || (b(), C.popupDelay ? Y || (Y = s(h, C.popupDelay, !1), 
                                Y.then(function(e) {
                                    e();
                                })) : h()());
                            }
                            function p() {
                                e.$apply(function() {
                                    g();
                                });
                            }
                            function h() {
                                return Y = null, D && (s.cancel(D), D = null), (f.useContentExp ? C.contentExp() : C.content) ? (_(), 
                                w.css({
                                    top: 0,
                                    left: 0,
                                    display: "block"
                                }), C.$digest(), E(), C.isOpen = !0, C.$apply(), E) : angular.noop;
                            }
                            function g() {
                                C.isOpen = !1, s.cancel(Y), Y = null, C.animation ? D || (D = s(v, 500)) : v();
                            }
                            function _() {
                                w && v(), L = C.$new(), w = n(L, function(e) {
                                    T ? o.find("body").append(e) : t.after(e);
                                }), L.$watch(function() {
                                    s(E, 0, !1);
                                }), f.useContentExp && L.$watch("contentExp()", function(e) {
                                    !e && C.isOpen && g();
                                });
                            }
                            function v() {
                                D = null, w && (w.remove(), w = null), L && (L.$destroy(), L = null);
                            }
                            function b() {
                                y(), M(), $();
                            }
                            function y() {
                                C.popupClass = a[c + "Class"];
                            }
                            function M() {
                                var e = a[c + "Placement"];
                                C.placement = angular.isDefined(e) ? e : f.placement;
                            }
                            function $() {
                                var e = a[c + "PopupDelay"], t = parseInt(e, 10);
                                C.popupDelay = isNaN(t) ? f.popupDelay : t;
                            }
                            function k() {
                                var e = a[c + "Trigger"];
                                H(), S = m(e), S.show === S.hide ? t.bind(S.show, l) : (t.bind(S.show, d), t.bind(S.hide, p));
                            }
                            var w, L, D, Y, T = !!angular.isDefined(f.appendToBody) && f.appendToBody, S = m(void 0), x = angular.isDefined(a[c + "Enable"]), C = e.$new(!0), E = function() {
                                if (w) {
                                    var e = u.positionElements(t, w, C.placement, T);
                                    e.top += "px", e.left += "px", w.css(e);
                                }
                            };
                            C.origScope = e, C.isOpen = !1, C.contentExp = function() {
                                return e.$eval(a[i]);
                            }, f.useContentExp || a.$observe(i, function(e) {
                                C.content = e, !e && C.isOpen && g();
                            }), a.$observe("disabled", function(e) {
                                e && C.isOpen && g();
                            }), a.$observe(c + "Title", function(e) {
                                C.title = e;
                            });
                            var H = function() {
                                t.unbind(S.show, d), t.unbind(S.hide, p);
                            };
                            k();
                            var j = e.$eval(a[c + "Animation"]);
                            C.animation = angular.isDefined(j) ? !!j : f.animation;
                            var A = e.$eval(a[c + "AppendToBody"]);
                            T = angular.isDefined(A) ? A : T, T && e.$on("$locationChangeSuccess", function() {
                                C.isOpen && g();
                            }), e.$on("$destroy", function() {
                                s.cancel(D), s.cancel(Y), H(), v(), C = null;
                            });
                        };
                    }
                };
            };
        } ];
    }).directive("tooltipTemplateTransclude", [ "$animate", "$sce", "$compile", "$templateRequest", function(e, t, n, a) {
        return {
            link: function(i, r, s) {
                var o, u, l, c = i.$eval(s.tooltipTemplateTranscludeScope), d = 0, f = function() {
                    u && (u.remove(), u = null), o && (o.$destroy(), o = null), l && (e.leave(l).then(function() {
                        u = null;
                    }), u = l, l = null);
                };
                i.$watch(t.parseAsResourceUrl(s.tooltipTemplateTransclude), function(t) {
                    var s = ++d;
                    t ? (a(t, !0).then(function(a) {
                        if (s === d) {
                            var i = c.$new(), u = a, m = n(u)(i, function(t) {
                                f(), e.enter(t, r);
                            });
                            o = i, l = m, o.$emit("$includeContentLoaded", t);
                        }
                    }, function() {
                        s === d && (f(), i.$emit("$includeContentError", t));
                    }), i.$emit("$includeContentRequested", t)) : f();
                }), i.$on("$destroy", f);
            }
        };
    } ]).directive("tooltipClasses", function() {
        return {
            restrict: "A",
            link: function(e, t, n) {
                e.placement && t.addClass(e.placement), e.popupClass && t.addClass(e.popupClass), 
                e.animation() && t.addClass(n.tooltipAnimationClass);
            }
        };
    }).directive("tooltipPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-popup.html"
        };
    }).directive("tooltip", [ "$tooltip", function(e) {
        return e("tooltip", "tooltip", "mouseenter");
    } ]).directive("tooltipTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/tooltip/tooltip-template-popup.html"
        };
    }).directive("tooltipTemplate", [ "$tooltip", function(e) {
        return e("tooltipTemplate", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-popup.html"
        };
    }).directive("tooltipHtml", [ "$tooltip", function(e) {
        return e("tooltipHtml", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlUnsafePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-unsafe-popup.html"
        };
    }).value("tooltipHtmlUnsafeSuppressDeprecated", !1).directive("tooltipHtmlUnsafe", [ "$tooltip", "tooltipHtmlUnsafeSuppressDeprecated", "$log", function(e, t, n) {
        return t || n.warn("tooltip-html-unsafe is now deprecated. Use tooltip-html or tooltip-template instead."), 
        e("tooltipHtmlUnsafe", "tooltip", "mouseenter");
    } ]), angular.module("ui.bootstrap.popover", [ "ui.bootstrap.tooltip" ]).directive("popoverTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/popover/popover-template.html"
        };
    }).directive("popoverTemplate", [ "$tooltip", function(e) {
        return e("popoverTemplate", "popover", "click", {
            useContentExp: !0
        });
    } ]).directive("popoverPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/popover/popover.html"
        };
    }).directive("popover", [ "$tooltip", function(e) {
        return e("popover", "popover", "click");
    } ]), angular.module("ui.bootstrap.progressbar", []).constant("progressConfig", {
        animate: !0,
        max: 100
    }).controller("ProgressController", [ "$scope", "$attrs", "progressConfig", function(e, t, n) {
        var a = this, i = angular.isDefined(t.animate) ? e.$parent.$eval(t.animate) : n.animate;
        this.bars = [], e.max = angular.isDefined(e.max) ? e.max : n.max, this.addBar = function(t, n) {
            i || n.css({
                transition: "none"
            }), this.bars.push(t), t.$watch("value", function(n) {
                t.percent = +(100 * n / e.max).toFixed(2);
            }), t.$on("$destroy", function() {
                n = null, a.removeBar(t);
            });
        }, this.removeBar = function(e) {
            this.bars.splice(this.bars.indexOf(e), 1);
        };
    } ]).directive("progress", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            require: "progress",
            scope: {},
            templateUrl: "template/progressbar/progress.html"
        };
    }).directive("bar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            require: "^progress",
            scope: {
                value: "=",
                max: "=?",
                type: "@"
            },
            templateUrl: "template/progressbar/bar.html",
            link: function(e, t, n, a) {
                a.addBar(e, t);
            }
        };
    }).directive("progressbar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            scope: {
                value: "=",
                max: "=?",
                type: "@"
            },
            templateUrl: "template/progressbar/progressbar.html",
            link: function(e, t, n, a) {
                a.addBar(e, angular.element(t.children()[0]));
            }
        };
    }), angular.module("ui.bootstrap.rating", []).constant("ratingConfig", {
        max: 5,
        stateOn: null,
        stateOff: null
    }).controller("RatingController", [ "$scope", "$attrs", "ratingConfig", function(e, t, n) {
        var a = {
            $setViewValue: angular.noop
        };
        this.init = function(i) {
            a = i, a.$render = this.render, a.$formatters.push(function(e) {
                return angular.isNumber(e) && e << 0 !== e && (e = Math.round(e)), e;
            }), this.stateOn = angular.isDefined(t.stateOn) ? e.$parent.$eval(t.stateOn) : n.stateOn, 
            this.stateOff = angular.isDefined(t.stateOff) ? e.$parent.$eval(t.stateOff) : n.stateOff;
            var r = angular.isDefined(t.ratingStates) ? e.$parent.$eval(t.ratingStates) : new Array(angular.isDefined(t.max) ? e.$parent.$eval(t.max) : n.max);
            e.range = this.buildTemplateObjects(r);
        }, this.buildTemplateObjects = function(e) {
            for (var t = 0, n = e.length; t < n; t++) e[t] = angular.extend({
                index: t
            }, {
                stateOn: this.stateOn,
                stateOff: this.stateOff
            }, e[t]);
            return e;
        }, e.rate = function(t) {
            !e.readonly && t >= 0 && t <= e.range.length && (a.$setViewValue(t), a.$render());
        }, e.enter = function(t) {
            e.readonly || (e.value = t), e.onHover({
                value: t
            });
        }, e.reset = function() {
            e.value = a.$viewValue, e.onLeave();
        }, e.onKeydown = function(t) {
            /(37|38|39|40)/.test(t.which) && (t.preventDefault(), t.stopPropagation(), e.rate(e.value + (38 === t.which || 39 === t.which ? 1 : -1)));
        }, this.render = function() {
            e.value = a.$viewValue;
        };
    } ]).directive("rating", function() {
        return {
            restrict: "EA",
            require: [ "rating", "ngModel" ],
            scope: {
                readonly: "=?",
                onHover: "&",
                onLeave: "&"
            },
            controller: "RatingController",
            templateUrl: "template/rating/rating.html",
            replace: !0,
            link: function(e, t, n, a) {
                var i = a[0], r = a[1];
                i.init(r);
            }
        };
    }), angular.module("ui.bootstrap.tabs", []).controller("TabsetController", [ "$scope", function(e) {
        var t = this, n = t.tabs = e.tabs = [];
        t.select = function(e) {
            angular.forEach(n, function(t) {
                t.active && t !== e && (t.active = !1, t.onDeselect());
            }), e.active = !0, e.onSelect();
        }, t.addTab = function(e) {
            n.push(e), 1 === n.length && e.active !== !1 ? e.active = !0 : e.active ? t.select(e) : e.active = !1;
        }, t.removeTab = function(e) {
            var i = n.indexOf(e);
            if (e.active && n.length > 1 && !a) {
                var r = i == n.length - 1 ? i - 1 : i + 1;
                t.select(n[r]);
            }
            n.splice(i, 1);
        };
        var a;
        e.$on("$destroy", function() {
            a = !0;
        });
    } ]).directive("tabset", function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            scope: {
                type: "@"
            },
            controller: "TabsetController",
            templateUrl: "template/tabs/tabset.html",
            link: function(e, t, n) {
                e.vertical = !!angular.isDefined(n.vertical) && e.$parent.$eval(n.vertical), e.justified = !!angular.isDefined(n.justified) && e.$parent.$eval(n.justified);
            }
        };
    }).directive("tab", [ "$parse", "$log", function(e, t) {
        return {
            require: "^tabset",
            restrict: "EA",
            replace: !0,
            templateUrl: "template/tabs/tab.html",
            transclude: !0,
            scope: {
                active: "=?",
                heading: "@",
                onSelect: "&select",
                onDeselect: "&deselect"
            },
            controller: function() {},
            compile: function(n, a, i) {
                return function(n, a, r, s) {
                    n.$watch("active", function(e) {
                        e && s.select(n);
                    }), n.disabled = !1, r.disable && n.$parent.$watch(e(r.disable), function(e) {
                        n.disabled = !!e;
                    }), r.disabled && (t.warn('Use of "disabled" attribute has been deprecated, please use "disable"'), 
                    n.$parent.$watch(e(r.disabled), function(e) {
                        n.disabled = !!e;
                    })), n.select = function() {
                        n.disabled || (n.active = !0);
                    }, s.addTab(n), n.$on("$destroy", function() {
                        s.removeTab(n);
                    }), n.$transcludeFn = i;
                };
            }
        };
    } ]).directive("tabHeadingTransclude", [ function() {
        return {
            restrict: "A",
            require: "^tab",
            link: function(e, t, n, a) {
                e.$watch("headingElement", function(e) {
                    e && (t.html(""), t.append(e));
                });
            }
        };
    } ]).directive("tabContentTransclude", function() {
        function e(e) {
            return e.tagName && (e.hasAttribute("tab-heading") || e.hasAttribute("data-tab-heading") || "tab-heading" === e.tagName.toLowerCase() || "data-tab-heading" === e.tagName.toLowerCase());
        }
        return {
            restrict: "A",
            require: "^tabset",
            link: function(t, n, a) {
                var i = t.$eval(a.tabContentTransclude);
                i.$transcludeFn(i.$parent, function(t) {
                    angular.forEach(t, function(t) {
                        e(t) ? i.headingElement = t : n.append(t);
                    });
                });
            }
        };
    }), angular.module("ui.bootstrap.timepicker", []).constant("timepickerConfig", {
        hourStep: 1,
        minuteStep: 1,
        showMeridian: !0,
        meridians: null,
        readonlyInput: !1,
        mousewheel: !0,
        arrowkeys: !0
    }).controller("TimepickerController", [ "$scope", "$attrs", "$parse", "$log", "$locale", "timepickerConfig", function(e, t, n, a, i, r) {
        function s() {
            var t = parseInt(e.hours, 10), n = e.showMeridian ? t > 0 && t < 13 : t >= 0 && t < 24;
            if (n) return e.showMeridian && (12 === t && (t = 0), e.meridian === h[1] && (t += 12)), 
            t;
        }
        function o() {
            var t = parseInt(e.minutes, 10);
            return t >= 0 && t < 60 ? t : void 0;
        }
        function u(e) {
            return angular.isDefined(e) && e.toString().length < 2 ? "0" + e : e.toString();
        }
        function l(e) {
            c(), p.$setViewValue(new Date(m)), d(e);
        }
        function c() {
            p.$setValidity("time", !0), e.invalidHours = !1, e.invalidMinutes = !1;
        }
        function d(t) {
            var n = m.getHours(), a = m.getMinutes();
            e.showMeridian && (n = 0 === n || 12 === n ? 12 : n % 12), e.hours = "h" === t ? n : u(n), 
            "m" !== t && (e.minutes = u(a)), e.meridian = m.getHours() < 12 ? h[0] : h[1];
        }
        function f(e) {
            var t = new Date(m.getTime() + 6e4 * e);
            m.setHours(t.getHours(), t.getMinutes()), l();
        }
        var m = new Date(), p = {
            $setViewValue: angular.noop
        }, h = angular.isDefined(t.meridians) ? e.$parent.$eval(t.meridians) : r.meridians || i.DATETIME_FORMATS.AMPMS;
        this.init = function(n, a) {
            p = n, p.$render = this.render, p.$formatters.unshift(function(e) {
                return e ? new Date(e) : null;
            });
            var i = a.eq(0), s = a.eq(1), o = angular.isDefined(t.mousewheel) ? e.$parent.$eval(t.mousewheel) : r.mousewheel;
            o && this.setupMousewheelEvents(i, s);
            var u = angular.isDefined(t.arrowkeys) ? e.$parent.$eval(t.arrowkeys) : r.arrowkeys;
            u && this.setupArrowkeyEvents(i, s), e.readonlyInput = angular.isDefined(t.readonlyInput) ? e.$parent.$eval(t.readonlyInput) : r.readonlyInput, 
            this.setupInputEvents(i, s);
        };
        var g = r.hourStep;
        t.hourStep && e.$parent.$watch(n(t.hourStep), function(e) {
            g = parseInt(e, 10);
        });
        var _ = r.minuteStep;
        t.minuteStep && e.$parent.$watch(n(t.minuteStep), function(e) {
            _ = parseInt(e, 10);
        }), e.showMeridian = r.showMeridian, t.showMeridian && e.$parent.$watch(n(t.showMeridian), function(t) {
            if (e.showMeridian = !!t, p.$error.time) {
                var n = s(), a = o();
                angular.isDefined(n) && angular.isDefined(a) && (m.setHours(n), l());
            } else d();
        }), this.setupMousewheelEvents = function(t, n) {
            var a = function(e) {
                e.originalEvent && (e = e.originalEvent);
                var t = e.wheelDelta ? e.wheelDelta : -e.deltaY;
                return e.detail || t > 0;
            };
            t.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementHours() : e.decrementHours()), t.preventDefault();
            }), n.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementMinutes() : e.decrementMinutes()), t.preventDefault();
            });
        }, this.setupArrowkeyEvents = function(t, n) {
            t.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementHours(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementHours(), e.$apply());
            }), n.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementMinutes(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementMinutes(), e.$apply());
            });
        }, this.setupInputEvents = function(t, n) {
            if (e.readonlyInput) return e.updateHours = angular.noop, void (e.updateMinutes = angular.noop);
            var a = function(t, n) {
                p.$setViewValue(null), p.$setValidity("time", !1), angular.isDefined(t) && (e.invalidHours = t), 
                angular.isDefined(n) && (e.invalidMinutes = n);
            };
            e.updateHours = function() {
                var e = s();
                angular.isDefined(e) ? (m.setHours(e), l("h")) : a(!0);
            }, t.bind("blur", function(t) {
                !e.invalidHours && e.hours < 10 && e.$apply(function() {
                    e.hours = u(e.hours);
                });
            }), e.updateMinutes = function() {
                var e = o();
                angular.isDefined(e) ? (m.setMinutes(e), l("m")) : a(void 0, !0);
            }, n.bind("blur", function(t) {
                !e.invalidMinutes && e.minutes < 10 && e.$apply(function() {
                    e.minutes = u(e.minutes);
                });
            });
        }, this.render = function() {
            var e = p.$viewValue;
            isNaN(e) ? (p.$setValidity("time", !1), a.error('Timepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.')) : (e && (m = e), 
            c(), d());
        }, e.incrementHours = function() {
            f(60 * g);
        }, e.decrementHours = function() {
            f(60 * -g);
        }, e.incrementMinutes = function() {
            f(_);
        }, e.decrementMinutes = function() {
            f(-_);
        }, e.toggleMeridian = function() {
            f(720 * (m.getHours() < 12 ? 1 : -1));
        };
    } ]).directive("timepicker", function() {
        return {
            restrict: "EA",
            require: [ "timepicker", "?^ngModel" ],
            controller: "TimepickerController",
            replace: !0,
            scope: {},
            templateUrl: "template/timepicker/timepicker.html",
            link: function(e, t, n, a) {
                var i = a[0], r = a[1];
                r && i.init(r, t.find("input"));
            }
        };
    }), angular.module("ui.bootstrap.transition", []).value("$transitionSuppressDeprecated", !1).factory("$transition", [ "$q", "$timeout", "$rootScope", "$log", "$transitionSuppressDeprecated", function(e, t, n, a, i) {
        function r(e) {
            for (var t in e) if (void 0 !== o.style[t]) return e[t];
        }
        i || a.warn("$transition is now deprecated. Use $animate from ngAnimate instead.");
        var s = function(a, i, r) {
            r = r || {};
            var o = e.defer(), u = s[r.animation ? "animationEndEventName" : "transitionEndEventName"], l = function(e) {
                n.$apply(function() {
                    a.unbind(u, l), o.resolve(a);
                });
            };
            return u && a.bind(u, l), t(function() {
                angular.isString(i) ? a.addClass(i) : angular.isFunction(i) ? i(a) : angular.isObject(i) && a.css(i), 
                u || o.resolve(a);
            }), o.promise.cancel = function() {
                u && a.unbind(u, l), o.reject("Transition cancelled");
            }, o.promise;
        }, o = document.createElement("trans"), u = {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            transition: "transitionend"
        }, l = {
            WebkitTransition: "webkitAnimationEnd",
            MozTransition: "animationend",
            OTransition: "oAnimationEnd",
            transition: "animationend"
        };
        return s.transitionEndEventName = r(u), s.animationEndEventName = r(l), s;
    } ]), angular.module("ui.bootstrap.typeahead", [ "ui.bootstrap.position", "ui.bootstrap.bindHtml" ]).factory("typeaheadParser", [ "$parse", function(e) {
        var t = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;
        return {
            parse: function(n) {
                var a = n.match(t);
                if (!a) throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "' + n + '".');
                return {
                    itemName: a[3],
                    source: e(a[4]),
                    viewMapper: e(a[2] || a[1]),
                    modelMapper: e(a[1])
                };
            }
        };
    } ]).directive("typeahead", [ "$compile", "$parse", "$q", "$timeout", "$document", "$position", "typeaheadParser", function(e, t, n, a, i, r, s) {
        var o = [ 9, 13, 27, 38, 40 ];
        return {
            require: "ngModel",
            link: function(u, l, c, d) {
                var f, m = u.$eval(c.typeaheadMinLength) || 1, p = u.$eval(c.typeaheadWaitMs) || 0, h = u.$eval(c.typeaheadEditable) !== !1, g = t(c.typeaheadLoading).assign || angular.noop, _ = t(c.typeaheadOnSelect), v = c.typeaheadInputFormatter ? t(c.typeaheadInputFormatter) : void 0, b = !!c.typeaheadAppendToBody && u.$eval(c.typeaheadAppendToBody), y = u.$eval(c.typeaheadFocusFirst) !== !1, M = t(c.ngModel).assign, $ = s.parse(c.typeahead), k = u.$new();
                u.$on("$destroy", function() {
                    k.$destroy();
                });
                var w = "typeahead-" + k.$id + "-" + Math.floor(1e4 * Math.random());
                l.attr({
                    "aria-autocomplete": "list",
                    "aria-expanded": !1,
                    "aria-owns": w
                });
                var L = angular.element("<div typeahead-popup></div>");
                L.attr({
                    id: w,
                    matches: "matches",
                    active: "activeIdx",
                    select: "select(activeIdx)",
                    query: "query",
                    position: "position"
                }), angular.isDefined(c.typeaheadTemplateUrl) && L.attr("template-url", c.typeaheadTemplateUrl);
                var D = function() {
                    k.matches = [], k.activeIdx = -1, l.attr("aria-expanded", !1);
                }, Y = function(e) {
                    return w + "-option-" + e;
                };
                k.$watch("activeIdx", function(e) {
                    e < 0 ? l.removeAttr("aria-activedescendant") : l.attr("aria-activedescendant", Y(e));
                });
                var T = function(e) {
                    var t = {
                        $viewValue: e
                    };
                    g(u, !0), n.when($.source(u, t)).then(function(n) {
                        var a = e === d.$viewValue;
                        if (a && f) if (n && n.length > 0) {
                            k.activeIdx = y ? 0 : -1, k.matches.length = 0;
                            for (var i = 0; i < n.length; i++) t[$.itemName] = n[i], k.matches.push({
                                id: Y(i),
                                label: $.viewMapper(k, t),
                                model: n[i]
                            });
                            k.query = e, k.position = b ? r.offset(l) : r.position(l), k.position.top = k.position.top + l.prop("offsetHeight"), 
                            l.attr("aria-expanded", !0);
                        } else D();
                        a && g(u, !1);
                    }, function() {
                        D(), g(u, !1);
                    });
                };
                D(), k.query = void 0;
                var S, x = function(e) {
                    S = a(function() {
                        T(e);
                    }, p);
                }, C = function() {
                    S && a.cancel(S);
                };
                d.$parsers.unshift(function(e) {
                    return f = !0, e && e.length >= m ? p > 0 ? (C(), x(e)) : T(e) : (g(u, !1), C(), 
                    D()), h ? e : e ? void d.$setValidity("editable", !1) : (d.$setValidity("editable", !0), 
                    e);
                }), d.$formatters.push(function(e) {
                    var t, n, a = {};
                    return h || d.$setValidity("editable", !0), v ? (a.$model = e, v(u, a)) : (a[$.itemName] = e, 
                    t = $.viewMapper(u, a), a[$.itemName] = void 0, n = $.viewMapper(u, a), t !== n ? t : e);
                }), k.select = function(e) {
                    var t, n, i = {};
                    i[$.itemName] = n = k.matches[e].model, t = $.modelMapper(u, i), M(u, t), d.$setValidity("editable", !0), 
                    d.$setValidity("parse", !0), _(u, {
                        $item: n,
                        $model: t,
                        $label: $.viewMapper(u, i)
                    }), D(), a(function() {
                        l[0].focus();
                    }, 0, !1);
                }, l.bind("keydown", function(e) {
                    0 !== k.matches.length && o.indexOf(e.which) !== -1 && (k.activeIdx != -1 || 13 !== e.which && 9 !== e.which) && (e.preventDefault(), 
                    40 === e.which ? (k.activeIdx = (k.activeIdx + 1) % k.matches.length, k.$digest()) : 38 === e.which ? (k.activeIdx = (k.activeIdx > 0 ? k.activeIdx : k.matches.length) - 1, 
                    k.$digest()) : 13 === e.which || 9 === e.which ? k.$apply(function() {
                        k.select(k.activeIdx);
                    }) : 27 === e.which && (e.stopPropagation(), D(), k.$digest()));
                }), l.bind("blur", function(e) {
                    f = !1;
                });
                var E = function(e) {
                    l[0] !== e.target && (D(), k.$digest());
                };
                i.bind("click", E), u.$on("$destroy", function() {
                    i.unbind("click", E), b && H.remove(), L.remove();
                });
                var H = e(L)(k);
                b ? i.find("body").append(H) : l.after(H);
            }
        };
    } ]).directive("typeaheadPopup", function() {
        return {
            restrict: "EA",
            scope: {
                matches: "=",
                query: "=",
                active: "=",
                position: "=",
                select: "&"
            },
            replace: !0,
            templateUrl: "template/typeahead/typeahead-popup.html",
            link: function(e, t, n) {
                e.templateUrl = n.templateUrl, e.isOpen = function() {
                    return e.matches.length > 0;
                }, e.isActive = function(t) {
                    return e.active == t;
                }, e.selectActive = function(t) {
                    e.active = t;
                }, e.selectMatch = function(t) {
                    e.select({
                        activeIdx: t
                    });
                };
            }
        };
    }).directive("typeaheadMatch", [ "$templateRequest", "$compile", "$parse", function(e, t, n) {
        return {
            restrict: "EA",
            scope: {
                index: "=",
                match: "=",
                query: "="
            },
            link: function(a, i, r) {
                var s = n(r.templateUrl)(a.$parent) || "template/typeahead/typeahead-match.html";
                e(s).then(function(e) {
                    t(e.trim())(a, function(e) {
                        i.replaceWith(e);
                    });
                });
            }
        };
    } ]).filter("typeaheadHighlight", function() {
        function e(e) {
            return e.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
        }
        return function(t, n) {
            return n ? ("" + t).replace(new RegExp(e(n), "gi"), "<strong>$&</strong>") : t;
        };
    }), !angular.$$csp() && angular.element(document).find("head").prepend('<style type="text/css">.ng-animate.item:not(.left):not(.right){-webkit-transition:0s ease-in-out left;transition:0s ease-in-out left}</style>');
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e() {
            "all" != window.debugging && "kube" != window.debugging || console.debug.apply(console, arguments);
        }
        function t(e) {
            var t, n, a, i;
            if (0 === e.length) return 0;
            for (t = 0, n = 0, i = e.length; n < i; n++) a = e.charCodeAt(n), t = (t << 5) - t + a, 
            t |= 0;
            return Math.abs(t);
        }
        function a(e, t) {
            for (var n, a, i = 0, r = e.length - 1; i <= r; ) if (n = (i + r) / 2 | 0, a = e[n], 
            a < t) i = n + 1; else {
                if (!(a > t)) return n;
                r = n - 1;
            }
            return i;
        }
        function i(e) {
            var n = this, i = [];
            n.add = function(n, r) {
                var s, o, u, l, c = n.length;
                for (o = 0; o < c; o++) s = t("" + n[o]) % e, u = i[s], void 0 === u && (u = i[s] = []), 
                l = a(u, r), u[l] != r && u.splice(l, 0, r);
            }, n.get = function(n) {
                var a = i[t("" + n) % e];
                return a ? a.slice() : [];
            }, n.all = function(n) {
                var a, r, s, o, u, l, c, d, f, m;
                for (r = 0, u = n.length; r < u; r++) {
                    if (a = t("" + n[r]) % e, s = i[a], !s) {
                        o = [];
                        break;
                    }
                    if (o) for (f = 0, m = 0, l = o.length; f < l; ) c = o[f], d = s[f + m], d < c ? m += 1 : c !== d ? (o.splice(f, 1), 
                    l -= 1) : f += 1; else o = s.slice();
                }
                return o || [];
            };
        }
        function r() {
            var e = "weakmap" + _;
            _ += 1;
            var t = this;
            t.delete = function(t) {
                var n = t[g];
                n && delete n[e];
            }, t.has = function(t) {
                var n = t[g];
                return n && e in n;
            }, t.get = function(t) {
                var n = t[g];
                if (n) return n[e];
            }, t.set = function(t, n) {
                var a = t[g];
                a || (a = function() {}, Object.defineProperty(t, g, {
                    enumerable: !1,
                    configurable: !1,
                    writable: !1,
                    value: a
                })), a[e] = n;
            };
        }
        function s(e) {
            var t, n, a = {
                "": d
            };
            for (t = 0, n = e.length; t < n; t++) a[e[t].type] = e[t], a[e[t].kind] = e[t];
            return a;
        }
        function o(e) {
            var t = e[0];
            if (t && "object" == typeof t) if (t.metadata) {
                if (t.metadata.selfLink) return t.metadata.selfLink;
                e = [ t.kind, t.metadata.name, t.metadata.namespace ];
            } else t.name && t.kind && (e = [ t.kind, t.name, t.namespace ]); else if (t && "/" == t[0]) return t;
            var n = f[e[0]] || f[""], a = n.api;
            return !n.global && e[2] && (a += "/namespaces/" + e[2]), a += "/" + n.type, e[1] && (a += "/" + e[1]), 
            a;
        }
        var u = n(32), l = "/api/v1", c = "/oapi/v1", d = {
            api: l,
            create: 0
        }, f = s([ {
            kind: "DeploymentConfig",
            type: "deploymentconfigs",
            api: c
        }, {
            kind: "Endpoints",
            type: "endpoints",
            api: l
        }, {
            kind: "Group",
            type: "groups",
            api: c,
            global: !0
        }, {
            kind: "Image",
            type: "images",
            api: c,
            global: !0
        }, {
            kind: "ImageStream",
            type: "imagestreams",
            api: c
        }, {
            kind: "ImageStreamImage",
            type: "imagestreamimages",
            api: c
        }, {
            kind: "ImageStreamTag",
            type: "imagestreamtags",
            api: c
        }, {
            kind: "LocalResourceAccessReview",
            type: "localresourceaccessreviews",
            api: c
        }, {
            kind: "Namespace",
            type: "namespaces",
            api: l,
            global: !0,
            create: -100
        }, {
            kind: "Node",
            type: "nodes",
            api: l,
            global: !0
        }, {
            kind: "Pod",
            type: "pods",
            api: l,
            create: -20
        }, {
            kind: "PolicyBinding",
            type: "policybindings",
            api: c
        }, {
            kind: "RoleBinding",
            type: "rolebindings",
            api: c
        }, {
            kind: "Route",
            type: "routes",
            api: c
        }, {
            kind: "PersistentVolume",
            type: "persistentvolumes",
            api: l,
            global: !0,
            create: -100
        }, {
            kind: "PersistentVolumeClaim",
            type: "persistentvolumeclaims",
            api: l,
            create: -50
        }, {
            kind: "Project",
            type: "projects",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ProjectRequest",
            type: "projectrequests",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ReplicationController",
            type: "replicationcontrollers",
            api: l,
            create: -60
        }, {
            kind: "Service",
            type: "services",
            api: l,
            create: -80
        }, {
            kind: "SubjectAccessReview",
            type: "subjectaccessreviews",
            api: c
        }, {
            kind: "User",
            type: "users",
            api: c,
            global: !0
        } ]), m = /^[a-z0-9]([-a-z0-9]*[a-z0-9])?$/, p = /^[a-zA-Z0-9_.]([-a-zA-Z0-9 ,=@._]*[a-zA-Z0-9._])?$/, h = "120s", g = Math.random().toString(36).slice(2), _ = 1;
        u.module("kubeClient", []).value("KUBE_SCHEMA", f).value("KUBE_NAME_RE", m).factory("kubeLoader", [ "$q", "$timeout", "KubeWatch", "KubeRequest", "KUBE_SCHEMA", function(e, t, n, a, i) {
            function r(e, t, a) {
                var i, r = f[e] || f[""], s = r.api;
                return !r.global && t && (s += "/namespaces/" + t), s += "/" + r.type, s in k || (i = new n(s, l), 
                i.what = e, i.global = r.global, i.namespace = t, i.cancelWatch = i.cancel, i.cancel = function() {
                    var e = k[s];
                    e && (e.references -= 1, e.references <= 0 && (e.cancelWatch(), delete k[s]));
                }, k[s] = i), k[s].references += a, k[s];
            }
            function s(t, n) {
                var a = $.namespace;
                if (!u.isArray(a)) return r(t, a, n);
                var i = [];
                u.forEach(a, function(e) {
                    i.push(r(t, e, n));
                });
                var s = e.all(i);
                return s.cancel = function() {
                    u.forEach(i, function(e) {
                        e.cancel();
                    });
                }, s;
            }
            function l(e) {
                if (null === L ? L = e : L.push.apply(L, e), e.length > 0) {
                    if (null !== D) return;
                    D = window.setTimeout(p, 150);
                }
                d(m);
            }
            function c(e) {
                var t;
                if (e && e.metadata && (t = parseInt(e.metadata.resourceVersion, 10)), !isNaN(t)) return t;
            }
            function d(e) {
                var t = L;
                if (L = null, t) {
                    var n, a, i, r, s, u, l = {}, d = {};
                    for (n = 0, a = t.length; n < a; n++) r = t[n].object, r && (i = o([ r ]), "DELETED" == t[n].type ? (delete w[i], 
                    d[i] = r) : t[n].checkResourceVersion ? (s = c(r), u = c(w[i]), (!s || !u || s >= u) && (l[i] = r, 
                    w[i] = r)) : (l[i] = r, w[i] = r));
                    e(l, d);
                }
            }
            function m() {
                var e, t, n;
                for (e = 0, t = M.length; e < t; e++) n = M[e], n && n.apply(y, arguments);
            }
            function p() {
                D = null, d(m);
            }
            function h() {
                var e;
                window.clearTimeout(D), D = null, L = null;
                var t = k;
                k = {}, u.forEach(t, function(e) {
                    e.cancelWatch();
                });
                for (e in w) delete w[e];
                for (e in $) delete $[e];
                $.namespace = null, m();
            }
            function g(e, t, n) {
                l(e.map(function(e) {
                    return n && (e.kind = n), {
                        type: t ? "DELETED" : "ADDED",
                        object: e,
                        checkResourceVersion: !0
                    };
                })), d(m);
            }
            function _() {
                var t = o(arguments), n = new a("GET", t), i = n.then(function(e) {
                    n = null;
                    var t = e.data;
                    return t && t.kind ? t.kind.indexOf("List") === t.kind.length - 4 ? (g(t.items, !1, t.kind.slice(0, -4)), 
                    t.items) : (g([ t ]), t) : null;
                }, function(t) {
                    n = null;
                    var a = t.data;
                    return e.reject(a || t);
                });
                return i.cancel = function(e) {
                    n.cancel(e);
                }, i;
            }
            function v(e) {
                window.clearTimeout(D), D = null;
                var t = {};
                null === e ? t = null : u.isArray(e) ? u.forEach(e, function(e) {
                    t[e] = !0;
                }) : t[e] = !0, $.namespace = e;
                var n = {}, a = {};
                d(function(e, t) {
                    n = e, a = t;
                });
                var i, r;
                for (r in w) i = w[r].metadata, !t || !i.namespace || i.namespace in t || (a[r] = w[r], 
                delete w[r], delete n[r]);
                var o, l, c = [];
                for (o in k) l = k[o], (!t && l.namespace || t && !l.global && !(l.namespace in t)) && (l.cancelWatch(), 
                delete k[o], c.push(l));
                m(n, a), u.forEach(c, function(e) {
                    s(e.what, e.references);
                });
            }
            function b(e, t) {
                t && (t.$on ? t.$on("destroy", function() {
                    e.cancel();
                }) : console.warn("invalid until passed to watch", t));
            }
            var y, M = [], $ = {
                namespace: null
            }, k = {}, w = {}, L = null, D = null;
            return y = {
                watch: function(e, t) {
                    var n = s(e, 1);
                    return b(n, t), n;
                },
                load: function() {
                    return _.apply(this, arguments);
                },
                limit: function(e) {
                    "namespace" in e && v(e.namespace);
                },
                reset: h,
                listen: function(e, n) {
                    e.early ? M.unshift(e) : M.push(e);
                    var a = t(function() {
                        a = null, e.call(y, w);
                    }, 0), i = {
                        cancel: function() {
                            var n, i;
                            for (t.cancel(a), a = null, n = 0, i = M.length; n < i; n++) M[n] === e && (M[n] = null);
                        }
                    };
                    return b(i, n), i;
                },
                handle: function(e, t, n) {
                    u.isArray(e) || (e = [ e ]), g(e, t, n);
                },
                resolve: function() {
                    return o(arguments);
                },
                objects: w,
                limits: $
            };
        } ]).factory("kubeSelect", [ "kubeLoader", function(e) {
            function t(e, t) {
                v += 1, e ? h && a(e) : h = null;
            }
            function n() {
                h = new i(262139), a(e.objects);
            }
            function a(e) {
                var t, n, a, i, r, s;
                for (t in e) {
                    n = e[t];
                    for (a in p) s = p[a], s.digest ? (i = s.digest.call(null, n), i && h.add([ i ], t)) : s.digests && (r = s.digests.call(null, n), 
                    r.length && h.add(r, t));
                }
            }
            function s(e) {
                var t = _.get(e);
                return t && t.version === v || (t = {
                    version: v,
                    length: t ? t.length : void 0
                }, _.set(e, t)), t;
            }
            function o(e) {
                return function() {
                    var t = s(this), i = Array.prototype.slice.call(arguments), r = e.name + ": " + JSON.stringify(i);
                    if (r in t) return t[r];
                    var o;
                    return e.filter ? o = e.filter.apply(this, i) : (h || n(), t.indexed || (a(this), 
                    t.indexed = !0), e.digests ? o = d(e, this, i) : e.digest ? o = c(e, this, i) : (console.warn("invalid filter: " + e.name), 
                    o = {})), t[r] = o, o;
                };
            }
            function u() {
                var e, t = {
                    length: {
                        enumerable: !1,
                        configurable: !0,
                        get: function() {
                            return s(this).length;
                        }
                    }
                };
                for (e in p) t[e] = {
                    enumerable: !1,
                    configurable: !0,
                    value: o(p[e])
                };
                return t;
            }
            function l(e, t, n) {
                var a, i;
                if (void 0 === t) {
                    t = 0;
                    for (a in e) t += 1;
                }
                return g = g || u(), Object.defineProperties(e, g), i = s(e), i.length = t, i.selection = e, 
                i.indexed = n, e;
            }
            function c(e, t, n) {
                var a, i, r, s, o, u, c = {}, d = 0;
                for (r = e.digest.apply(null, n), s = null !== r && void 0 !== r ? h.get(r) : [], 
                a = 0, i = s.length; a < i; a++) o = s[a], u = t[o], u && r === e.digest.call(null, u) && (c[o] = u, 
                d += 1);
                return l(c, d, !0);
            }
            function d(e, t, n) {
                var a, i, r, s, o, u, c, d, f, m, p, g, _ = {}, v = 0;
                for (a = e.digests.apply(null, n), i = a.length, i > 0 ? (d = h.all(a), a.sort()) : d = [], 
                f = 0, m = d.length; f < m; f++) if (o = d[f], c = t[o]) {
                    for (r = e.digests.call(null, c), r.sort(), u = !1, p = 0, g = r.length; !u && p < g; p++) if (a[0] === r[p]) for (u = !0, 
                    s = 0; u && s < i; s++) a[s] !== r[p + s] && (u = !1);
                    u && (_[o] = c, v += 1);
                }
                return l(_, v, !0);
            }
            function f(e, t) {
                "function" == typeof t && (e = {
                    name: e,
                    filter: t
                }), p[e.name] = e, h = null, g = null, v += 1;
            }
            function m(t) {
                var n, a = !1;
                if (void 0 === t ? (t = e.objects, a = !0) : t || (t = b), "object" != typeof t && (console.warn("Pass resources or resource dicts or null to kubeSelect()"), 
                t = b), n = s(t), n.selection) return n.selection;
                var i, r;
                return "string" == typeof t.kind ? (n.single || (i = t.meta || {}, r = {}, r[i.selfLink || 1] = t, 
                n.single = l(r, void 0, !1)), n.single) : l(t, void 0, a);
            }
            var p = {}, h = null, g = null, _ = new r(), v = 1;
            t.early = !0, e.listen(t), f("one", function() {
                var e;
                for (e in this) return this[e];
                return null;
            }), f("extend", function(e) {
                var t;
                for (t in this) e[t] = this[t];
                return e;
            }), f({
                name: "label",
                digests: function(e) {
                    var t = [];
                    if (!e) return t;
                    var n, a = e.metadata, i = a ? a.labels : e;
                    for (n in i || []) t.push(n + "=" + i[n]);
                    return t;
                }
            }), f({
                name: "namespace",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.namespace : null;
                }
            }), f({
                name: "name",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.name : null;
                }
            }), f({
                name: "kind",
                digest: function(e) {
                    return e ? "string" == typeof e ? e : e.kind : null;
                }
            }), f({
                name: "host",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.spec;
                    return t ? t.nodeName : null;
                }
            }), f({
                name: "uid",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.uid : null;
                }
            }), f({
                name: "statusPhase",
                digest: function(e) {
                    var t;
                    return "string" == typeof e ? e : (t = e.status || {}, t.phase ? t.phase : null);
                }
            });
            var b = {};
            return m.register = f, m;
        } ]).factory("kubeMethods", [ "$q", "KUBE_SCHEMA", "KubeRequest", "kubeLoader", function(t, n, a, i) {
            function r(e, t) {
                var a = n[e.kind].create || 0, i = n[t.kind].create || 0;
                return a - i;
            }
            function s(n, s) {
                function l() {
                    var t = n.shift();
                    if (!t) return void c.resolve();
                    var r = o([ t.kind, null, s || "default" ]);
                    r += "?timeout=" + h, m = new a("POST", r, JSON.stringify(t)).then(function(t) {
                        var n;
                        e("created resource:", r, t.data), t.data.kind && ("Project" == t.data.kind && (n = t.data.metadata || {}, 
                        delete n.selfLink), i.handle(t.data)), l();
                    }, function(n) {
                        var a = n.data;
                        "Namespace" != t.kind || !a || 409 !== a.code && 403 !== a.code ? (e("create failed:", r, a || n), 
                        c.reject(a || n)) : (e("skipping namespace creation"), l());
                    });
                }
                var c = t.defer(), d = c.promise, m = null;
                u.isArray(n) || (n = "List" == n.kind ? n.items : [ n ]);
                var p = !1, g = !1;
                return n.forEach(function(e) {
                    var t = e.metadata || {};
                    "Namespace" != e.kind && "Project" != e.kind || t.name !== s || (p = !0);
                    var n = f[e.kind] || f[""];
                    n.global || (g = !0);
                }), n = n.slice(), s && g && !p && n.unshift({
                    apiVersion: "v1",
                    kind: "Namespace",
                    metadata: {
                        name: s
                    }
                }), n.sort(r), l(), d.cancel = function() {
                    m && m.cancel();
                }, d;
            }
            function l() {
                var n = o(arguments), r = i.objects[n];
                n += "?timeout=" + h;
                var s = new a("DELETE", n);
                return s.then(function() {
                    e("deleted resource:", n, r), r && i.handle(r, !0);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function c(n, r) {
                var s = o([ n ]);
                s += "?timeout=" + h;
                var u = JSON.stringify(r), l = {
                    headers: {
                        "Content-Type": "application/strategic-merge-patch+json"
                    }
                }, c = new a("PATCH", s, u, l);
                return c.then(function(t) {
                    e("patched resource:", s, t.data), t.data.kind && i.handle(t.data);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function d(e, n, i, r) {
                var s = o([ n ]);
                "GET" != e && (s += "?timeout=" + h);
                var u = new a(e, s, JSON.stringify(i), r);
                return u.then(function(e) {
                    var t = e.data;
                    return t || e;
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function g(e, t, n) {
                return d("PUT", e, t, n);
            }
            function _(e, t, n) {
                return d("POST", e, t, n);
            }
            function v(e, n) {
                var a, i = t.defer(), r = [];
                n || (n = {});
                var s = e.metadata;
                if (s) {
                    if (a = null, void 0 !== s.name) {
                        var o = "User" == e.kind ? p : m;
                        s.name ? o.test(s.name) || (a = o == m ? new Error("The name contains invalid characters. Only letters, numbers and dashes are allowed") : new Error("The name contains invalid characters. Only letters, numbers, spaces and the following symbols are allowed: , = @  . _")) : a = new Error("The name cannot be empty");
                    }
                    a && (a.target = n["metadata.name"], r.push(a)), a = null, void 0 !== s.namespace && (s.namespace ? m.test(s.namespace) || (a = new Error("The name contains invalid characters. Only letters, numbers and dashes are allowed")) : a = new Error("The namespace cannot be empty")), 
                    a && (a.target = n["metadata.namespace"], r.push(a));
                }
                return r.length ? i.reject(r) : i.resolve(), i.promise;
            }
            return {
                create: s,
                delete: l,
                check: v,
                patch: c,
                post: _,
                put: g
            };
        } ]).provider("KubeRequest", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeRequest") : e.invoke(t);
            }
            var t = this;
            t.KubeRequestFactory = "MissingKubeRequest", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeRequestFactory);
            } ];
        } ]).factory("MissingKubeRequest", [ function() {
            return function(e, t) {
                throw new Error("no KubeRequestFactory set");
            };
        } ]).provider("KubeSocket", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeSocket") : e.invoke(t);
            }
            var t = this;
            t.KubeSocketFactory = "MissingKubeSocket", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeSocketFactory);
            } ];
        } ]).factory("MissingKubeSocket", [ function() {
            return function(e, t) {
                throw Error("no KubeSocketFactory set");
            };
        } ]).provider("KubeWatch", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeWatch") : e.invoke(t);
            }
            var t = this;
            t.KubeWatchFactory = "MissingKubeWatch", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeWatchFactory);
            } ];
        } ]).factory("MissingKubeWatch", [ function() {
            return function(e, t) {
                throw Error("no KubeWatchFactory set");
            };
        } ]).provider("KubeDiscoverSettings", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeDiscoverSettings") : e.invoke(t);
            }
            var t = this;
            t.KubeDiscoverSettingsFactory = "MissingKubeDiscoverSettings", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeDiscoverSettingsFactory);
            } ];
        } ]).factory("MissingKubeDiscoverSettings", [ function() {
            return function(e, t) {
                throw Error("no KubeDiscoverSettingsFactory set");
            };
        } ]);
    }();
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t) {
            var n, a, r, s, o = [], u = e.length;
            for (r = 0; r < u; r++) if (n = e[r].querySelectorAll(t)) for (a = 0, s = n.length; a < s; a++) o.push(n[a]);
            return i.element(o);
        }
        function t(e, t) {
            var n, a = null, r = e.length;
            for (n = 0; !a && n < r; n++) a = e[n].querySelector(t);
            return i.element(a);
        }
        function a(n, a, r, s, o) {
            function u(e) {
                if (!k) return y = e, $ ? void o.cancel() : void (null === y ? (h(), b()) : y === !0 ? (h(), 
                v(), o.result(!0, M)) : y === !1 ? (v(), c(M), o.result(!1, M)) : console.warn("invalid dialog state", y));
            }
            function l() {
                o = null, s = null, h(), v();
            }
            function c(e) {
                h(), i.isArray(e) || (e = [ e ]), e.forEach(function(e) {
                    var a = null;
                    e.target && (a = t(n, e.target)), a && a[0] ? f(a, e) : d(e);
                });
            }
            function d(e) {
                var s = i.element("<div class='alert alert-danger dialog-error'>"), o = e.message || e.toString();
                console.warn(o), s.text(o), s.prepend(i.element("<span class='fa fa-exclamation-triangle'>"));
                var u = t(n, a);
                u.length ? r ? u.append(s) : u.prepend(s) : n.append(s);
            }
            function f(e, t) {
                var n = i.element("<div class='dialog-error help-block'>");
                n.text(t.message || t.toString());
                var a = e.parent();
                a.addClass("has-error"), e.after(n), a.on("keypress change", m);
            }
            function m(e) {
                for (var t = e.target; t !== this; ) p(i.element(t)), t = t.parentNode;
            }
            function p(t) {
                var n = t.parent();
                e(n, ".dialog-error").remove(), n.removeClass("has-error"), n.off("keypress change", m);
            }
            function h() {
                var t = e(n, ".dialog-error");
                i.forEach(t, function(e) {
                    p(i.element(e));
                });
            }
            function g(e) {
                return s.cancel && s.cancel(), $ = !0, e.stopPropagation(), e.preventDefault(), 
                !1;
            }
            function _(e) {
                var t = e.message || e;
                "string" == typeof t || "number" == typeof t ? D.text(t) : t || D.text("");
            }
            function v() {
                for (var e; ;) {
                    if (e = w.pop(), !e) break;
                    e.removeAttr("disabled");
                }
                L.remove(), t(n, ".btn-cancel").off("click", g);
            }
            function b() {
                function r(e) {
                    var t = i.element(e);
                    t.attr("disabled") || s.cancel && t.hasClass("btn-cancel") || (w.push(t), t.attr("disabled", "disabled"));
                }
                v(), t(n, a).prepend(L), i.forEach(e(n, ".form-control"), r), i.forEach(e(n, ".form-checkbox"), r), 
                i.forEach(e(n, ".btn"), r), t(n, ".btn-cancel").on("click", g);
            }
            var y = null, M = null, $ = !1, k = !1, w = [], L = i.element("<div class='dialog-wait-ct pull-left'>");
            L.append(i.element("<div class='spinner spinner-sm'>"));
            var D = i.element("<span>");
            return L.append(D), this.detach = l, s ? (s.then(function(e) {
                M = e, s && u(!0);
            }, function(e) {
                M = e, s && u(!1);
            }, function(e) {
                s && _(e);
            }), void window.setTimeout(function() {
                s && o && null === y && (u(null), o.$digest());
            }, 0)) : void l();
        }
        var i = n(32);
        n(35), i.module("ui.cockpit", [ "ui.bootstrap" ]).directive("modalDialog", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<modal-group><ng-transclude></ng-transclude></modal-group>",
                link: function(e, t, n) {
                    e.cancel = function() {
                        e.$dismiss();
                    }, e.result = function(t, n) {
                        t && e.$close(n);
                    };
                }
            };
        } ]).directive("modalGroup", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<ng-transclude></ng-transclude>",
                link: function(n, i, r) {
                    function s() {
                        u && u.detach(), u = null;
                    }
                    function o() {
                        n.cancel();
                    }
                    var u = null;
                    n.complete = function(t) {
                        var r = n.modalGroupButtonSel || ".modal-footer", o = n.modalGroupErrorAfter || !1;
                        s(), t && t.then || (t = e(t)), u = new a(i, r, o, t, n);
                    }, n.failure = function() {
                        var t, a = arguments.length;
                        if (0 === a ? t = null : 1 === a ? t = arguments[0] : (t = [], t.push.apply(t, arguments)), 
                        !t) return void s();
                        var i = e.defer();
                        i.reject(t), n.complete(i.promise);
                    };
                    var l = t(i, ".btn-cancel");
                    l.on("click", o), n.$on("$routeChangeStart", o), n.$on("$destroy", function() {
                        l.off("click", o), s();
                    });
                }
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(t, n, a) {
            return t && t.classList && t.classList.contains(n) || t && t.tagName === a || t && e(t.parentNode, n, a);
        }
        var t = n(32);
        n(45), n(46), n(47), n(48), n(49), n(50), n(51), n(52), n(53), n(54), n(55), n(56), 
        n(57), n(58), t.module("kubernetes.listing", []).directive("listingTable", [ function() {
            return {
                restrict: "A",
                link: function(e, t, n) {}
            };
        } ]).factory("ListingState", [ function() {
            return function(n) {
                function a(t) {
                    return !(t && e(t.target, "btn", "li"));
                }
                var i = this, r = {};
                i.selected = {}, i.enableActions = !1, i.hasSelected = function(e) {
                    return !t.equals({}, i.selected);
                }, i.expanded = function(e) {
                    if (t.isUndefined(e)) {
                        for (e in r) return !0;
                        return !1;
                    }
                    return e in r;
                }, i.toggle = function(e, t) {
                    var n;
                    return i.enableActions ? void t.stopPropagation() : void (e && (n = !(e in r), n ? i.expand(e, t) : i.collapse(e, t)));
                }, i.expand = function(e, t) {
                    r[e] = !0, t && t.stopPropagation();
                }, i.activate = function(e, t) {
                    a(t) && (i.expanded(e) ? i.collapse(e) : n.$emit("activate", e));
                }, i.collapse = function(e, t) {
                    e ? delete r[e] : Object.keys(r).forEach(function(e) {
                        delete r[e];
                    }), t && t.stopPropagation();
                };
            };
        } ]).directive("listingPanel", [ function() {
            return {
                restrict: "A",
                scope: !0,
                link: function(e, t, n) {
                    var a = "main";
                    e.tab = function(e, t) {
                        return t && (a = e, t.stopPropagation()), a === e;
                    };
                },
                templateUrl: function(e, t) {
                    var n = t.kind;
                    return "views/" + n.toLowerCase() + "-panel.html";
                }
            };
        } ]);
    }();
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Image</a> </li> <li ng-class="{active: tab(\'config\')}"> <a ng-click="tab(\'config\', $event)" translate>Container</a> </li> <li ng-class="{active: tab(\'meta\')}"> <a ng-click="tab(\'meta\', $event)" translate>Metadata</a> </li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <div class="listing-ct-body" ng-show="tab(\'config\')"> <registry-image-config image="image"> </registry-image-config> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeUser(projects(), groups(), user())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyUser(user())"></button> </div> <div class="listing-ct-head"> <h3><i class="pficon pficon-user"></i>{{ user().metadata.name }}</h3> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>User</a></li> <li ng-class="{active: tab(\'membership\')}"> <a ng-click="tab(\'membership\', $event); tabbed = true" translate>Membership</a></li> </ul> </div> <div class="listing-ct-body project-panel"> <div ng-show="tab(\'main\')"> <div class="user-body"> <dl> <dt translate>Identities</dt> <dd>{{ user().identities }}</dd> </dl> </div> </div> <div class="project-panel" ng-show="tab(\'membership\')"> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Membership</th> <th translate></th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="member in getProjectsWithMember(projects(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td> <div ng-if="member.kind == &quot;Project&quot;" class="btn-group bootstrap-select namespace-filter" dropdown> <button class="btn btn-default dropdown-toggle" type="button" dropdown-toggle> <span class="pull-left"> <span ng-if="isRoles(user(), member)"> {{ getRegistryRoles(user(), member).join() }} </span> </span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="roleMp in getRegistryRolesMap() track by roleMp.displayRole" ng-class="{ checked: isRegistryRole(user(), roleMp.displayRole, member) }"> <a ng-click="changeRole(user(), roleMp, getRegistryRoles(user(), member), member)"> {{ roleMp.displayRole }} </a> </li> </ul> </div> </td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeMemberFromParent(user(), member)"></i> </a> </td> </tr> </tbody> <tbody colspan="3" ng-repeat="member in getGroupsWithMember(groups(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td></td> <td><a class="pull-right close-icon" ng-click="removeMemberFromParent(user(), member)"> <i translate class="pficon-close"></i> </a> </td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" ng-click="addMemberToParent(user())"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>Add Membership</span> </a> </td> </tr> </thead> </table> </div></div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/user-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Service</a></li> <li ng-class="{active: tab(\'endpoints\')}"><a ng-click="tab(\'endpoints\', $event)" translate>Endpoints</a></li> </ul> </div> <div class="listing-ct-body" service-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" service-endpoint ng-show="tab(\'endpoints\')"> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/service-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Pod</a></li> <li ng-class="{active: tab(\'containers\')}"><a ng-click="tab(\'containers\', $event)">Containers</a></li> <li ng-class="{active: tab(\'logs\')}"> <a ng-click="tab(\'logs\', $event); tabbed = true">Logs</a></li> <li ng-class="{active: tab(\'shell\')}"> <a ng-click="tab(\'shell\', $event); tabbed = true">Shell</a></li> <li ng-class="{active: tab(\'volumes\')}"> <a ng-click="tab(\'volumes\', $event); tabbed = true">Volumes</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-pod-body ng-init="pod = item"> </kube-pod-body> </div> <div class="listing-ct-body" ng-show="tab(\'containers\')"> <kube-container-body ng-repeat="container in containers(item)"> </kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-if="item.status.phase == \'Running\' && container.status.state.running" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div> </div> <div class="listing-ct-body" ng-show="tab(\'volumes\')"> <div class="container-fluid well" ng-repeat="podVolume in volumesForPod(item)" data-id="{{ podVolume.name }}"> <dl ng-if="!podVolume.persistentVolumeClaim" volume-body volume="podVolume"></dl> <dl ng-if="podVolume.persistentVolumeClaim" pvc-body settings="settings" item="claimFromVolumeSource(podVolume.persistentVolumeClaim, item.metadata.namespace)"></dl> <dl> <dt translate>Mount Location</dt> <dd> <span ng-if="!podVolume.mounts" translate>None</span> <dl class="full-width" ng-if="podVolume.mounts"> <dt ng-repeat-start="(name, data) in podVolume.mounts">{{ name }}</dt> <dd ng-repeat-end>{{ data.mountPath }}</dd> </dl> </dd> </dl> </div> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/pod-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Adjust" class="btn btn-default pficon pficon-edit" ng-click="modifyRoute(item)"></button>\n<button title="Delete" class="route-delete btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"> </button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Route</a></li> </ul> </div> <div class="listing-ct-body" route-body ng-show="tab(\'main\')"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/route-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deletePV(item)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-if="canEdit(item)" ng-click="modifyPV(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Volume</a> </li> <li ng-class="{active: tab(\'claim\')}"> <a ng-click="tab(\'claim\', $event)" translate>Claim</a> </li> </ul> </div> <div pv-body class="listing-ct-body" ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" ng-show="tab(\'claim\')" pv-claim></div> </div> ';
    n.run([ "$templateCache", function(e) {
        e.put("views/pv-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Image stream</a></li> <li ng-class="{active: tab(\'meta\')}" ng-if="stream.metadata.annotations"> <a ng-click="tab(\'meta\', $event)">Metadata</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push imagestream="stream" settings="settings"> </registry-imagestream-push> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-body"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/default-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteNode(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Node</a></li> <li ng-class="{active: tab(\'capacity\')}"><a ng-click="tab(\'capacity\', $event)">Capacity</a></li> </ul> </div> <div node-alerts></div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <div class="row" node-body></div> </div> <div class="listing-ct-body" ng-show="tab(\'capacity\')"> <div class="row" node-capacity></div> <div class="row" node-stats></div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/node-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeProject(project())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyProject(project())"></button> </div> <div class="listing-ct-body project-panel"> <p class="project-description" ng-if="project().metadata.annotations[\'openshift.io/description\']"> {{ project().metadata.annotations[\'openshift.io/description\'] }} </p> <div project-body> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/project-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head"> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Container</a></li> <li ng-class="{active: tab(\'logs\')}"> <a class="logs" ng-click="tab(\'logs\', $event); tabbed = true" translate>Logs</a></li> <li ng-class="{active: tab(\'shell\')}" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <a class="shell" ng-click="tab(\'shell\', $event); tabbed = true" translate>Shell</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-container-body></kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/container-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="deployment-delete btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Deployment Config</a></li> <li ng-class="{active: tab(\'template\')}" ng-if="item.spec.template"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" deploymentconfig-body ng-show="tab(\'main\')"></div> <div class="listing-ct-body" ng-show="tab(\'template\')" ng-if="item.spec.template"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/deploymentconfig-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeGroup(projects(), group())"></button> </div> <h3><i class="pficon pficon-users"></i>{{ group().metadata.name }}</h3> </div> <div class="listing-ct-body project-panel" ng-show="tab(\'main\')"> <div> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Group Members</th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="user in group().users"> <tr class="listing-ct-item inner-project-listing"> <td><i class="pficon-user"></i> {{ user }}</td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeUserFromGroup(user, group())"></i> </a></td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" disabled="disabled"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate ng-click="addUserToGroup(group())">Add Member</span> </a> </td> </tr> </thead> </table> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/group-panel.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-entity btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button>\n<button title="Adjust" class="adjust-entity btn btn-default pficon pficon-edit" ng-click="modifyRC(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Replication Controller</a></li> <li ng-class="{active: tab(\'pods\')}"> <a ng-click="tab(\'pods\', $event)" translate>Pods</a></li> <li ng-class="{active: tab(\'template\')}"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" replicationcontroller-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" replicationcontroller-pods ng-show="tab(\'pods\')"> </div> <div class="listing-ct-body" ng-show="tab(\'template\')"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/replicationcontroller-panel.html", i);
    } ]), e.exports = i;
}, , , function(e, t, n) {
    "use strict";
    !function() {
        var e = n(32), t = n(62);
        n(39), e.module("kubernetes.date", [ "kubeClient" ]).factory("refreshEveryMin", [ "$rootScope", "$window", "kubeLoader", function(e, t, n) {
            var a = 0, i = 6e4, r = 500;
            return n.listen(function() {
                a = new Date().getTime();
            }), t.setInterval(function() {
                var t = new Date().getTime();
                t - a + r >= i && e.$applyAsync(), a = t;
            }, i), {};
        } ]).filter("dateRelative", [ "refreshEveryMin", function() {
            function e(e) {
                return e ? t(e).fromNow() : e;
            }
            return e.$stateful = !0, e;
        } ]);
    }();
}, function(e, t, n) {
    (function(e) {
        //! moment.js
        //! version : 2.10.6
        //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
        //! license : MIT
        //! momentjs.com
        !function(t, n) {
            e.exports = n();
        }(this, function() {
            "use strict";
            function t() {
                return On.apply(null, arguments);
            }
            function a(e) {
                On = e;
            }
            function i(e) {
                return "[object Array]" === Object.prototype.toString.call(e);
            }
            function r(e) {
                return e instanceof Date || "[object Date]" === Object.prototype.toString.call(e);
            }
            function s(e, t) {
                var n, a = [];
                for (n = 0; n < e.length; ++n) a.push(t(e[n], n));
                return a;
            }
            function o(e, t) {
                return Object.prototype.hasOwnProperty.call(e, t);
            }
            function u(e, t) {
                for (var n in t) o(t, n) && (e[n] = t[n]);
                return o(t, "toString") && (e.toString = t.toString), o(t, "valueOf") && (e.valueOf = t.valueOf), 
                e;
            }
            function l(e, t, n, a) {
                return xe(e, t, n, a, !0).utc();
            }
            function c() {
                return {
                    empty: !1,
                    unusedTokens: [],
                    unusedInput: [],
                    overflow: -2,
                    charsLeftOver: 0,
                    nullInput: !1,
                    invalidMonth: null,
                    invalidFormat: !1,
                    userInvalidated: !1,
                    iso: !1
                };
            }
            function d(e) {
                return null == e._pf && (e._pf = c()), e._pf;
            }
            function f(e) {
                if (null == e._isValid) {
                    var t = d(e);
                    e._isValid = !(isNaN(e._d.getTime()) || !(t.overflow < 0) || t.empty || t.invalidMonth || t.invalidWeekday || t.nullInput || t.invalidFormat || t.userInvalidated), 
                    e._strict && (e._isValid = e._isValid && 0 === t.charsLeftOver && 0 === t.unusedTokens.length && void 0 === t.bigHour);
                }
                return e._isValid;
            }
            function m(e) {
                var t = l(NaN);
                return null != e ? u(d(t), e) : d(t).userInvalidated = !0, t;
            }
            function p(e, t) {
                var n, a, i;
                if ("undefined" != typeof t._isAMomentObject && (e._isAMomentObject = t._isAMomentObject), 
                "undefined" != typeof t._i && (e._i = t._i), "undefined" != typeof t._f && (e._f = t._f), 
                "undefined" != typeof t._l && (e._l = t._l), "undefined" != typeof t._strict && (e._strict = t._strict), 
                "undefined" != typeof t._tzm && (e._tzm = t._tzm), "undefined" != typeof t._isUTC && (e._isUTC = t._isUTC), 
                "undefined" != typeof t._offset && (e._offset = t._offset), "undefined" != typeof t._pf && (e._pf = d(t)), 
                "undefined" != typeof t._locale && (e._locale = t._locale), Pn.length > 0) for (n in Pn) a = Pn[n], 
                i = t[a], "undefined" != typeof i && (e[a] = i);
                return e;
            }
            function h(e) {
                p(this, e), this._d = new Date(null != e._d ? e._d.getTime() : NaN), Fn === !1 && (Fn = !0, 
                t.updateOffset(this), Fn = !1);
            }
            function g(e) {
                return e instanceof h || null != e && null != e._isAMomentObject;
            }
            function _(e) {
                return e < 0 ? Math.ceil(e) : Math.floor(e);
            }
            function v(e) {
                var t = +e, n = 0;
                return 0 !== t && isFinite(t) && (n = _(t)), n;
            }
            function b(e, t, n) {
                var a, i = Math.min(e.length, t.length), r = Math.abs(e.length - t.length), s = 0;
                for (a = 0; a < i; a++) (n && e[a] !== t[a] || !n && v(e[a]) !== v(t[a])) && s++;
                return s + r;
            }
            function y() {}
            function M(e) {
                return e ? e.toLowerCase().replace("_", "-") : e;
            }
            function $(e) {
                for (var t, n, a, i, r = 0; r < e.length; ) {
                    for (i = M(e[r]).split("-"), t = i.length, n = M(e[r + 1]), n = n ? n.split("-") : null; t > 0; ) {
                        if (a = k(i.slice(0, t).join("-"))) return a;
                        if (n && n.length >= t && b(i, n, !0) >= t - 1) break;
                        t--;
                    }
                    r++;
                }
                return null;
            }
            function k(t) {
                var a = null;
                if (!Un[t] && "undefined" != typeof e && e && e.exports) try {
                    a = In._abbr, n(64)("./" + t), w(a);
                } catch (e) {}
                return Un[t];
            }
            function w(e, t) {
                var n;
                return e && (n = "undefined" == typeof t ? D(e) : L(e, t), n && (In = n)), In._abbr;
            }
            function L(e, t) {
                return null !== t ? (t.abbr = e, Un[e] = Un[e] || new y(), Un[e].set(t), w(e), Un[e]) : (delete Un[e], 
                null);
            }
            function D(e) {
                var t;
                if (e && e._locale && e._locale._abbr && (e = e._locale._abbr), !e) return In;
                if (!i(e)) {
                    if (t = k(e)) return t;
                    e = [ e ];
                }
                return $(e);
            }
            function Y(e, t) {
                var n = e.toLowerCase();
                Nn[n] = Nn[n + "s"] = Nn[t] = e;
            }
            function T(e) {
                return "string" == typeof e ? Nn[e] || Nn[e.toLowerCase()] : void 0;
            }
            function S(e) {
                var t, n, a = {};
                for (n in e) o(e, n) && (t = T(n), t && (a[t] = e[n]));
                return a;
            }
            function x(e, n) {
                return function(a) {
                    return null != a ? (E(this, e, a), t.updateOffset(this, n), this) : C(this, e);
                };
            }
            function C(e, t) {
                return e._d["get" + (e._isUTC ? "UTC" : "") + t]();
            }
            function E(e, t, n) {
                return e._d["set" + (e._isUTC ? "UTC" : "") + t](n);
            }
            function H(e, t) {
                var n;
                if ("object" == typeof e) for (n in e) this.set(n, e[n]); else if (e = T(e), "function" == typeof this[e]) return this[e](t);
                return this;
            }
            function j(e, t, n) {
                var a = "" + Math.abs(e), i = t - a.length, r = e >= 0;
                return (r ? n ? "+" : "" : "-") + Math.pow(10, Math.max(0, i)).toString().substr(1) + a;
            }
            function A(e, t, n, a) {
                var i = a;
                "string" == typeof a && (i = function() {
                    return this[a]();
                }), e && (Rn[e] = i), t && (Rn[t[0]] = function() {
                    return j(i.apply(this, arguments), t[1], t[2]);
                }), n && (Rn[n] = function() {
                    return this.localeData().ordinal(i.apply(this, arguments), e);
                });
            }
            function O(e) {
                return e.match(/\[[\s\S]/) ? e.replace(/^\[|\]$/g, "") : e.replace(/\\/g, "");
            }
            function I(e) {
                var t, n, a = e.match(Vn);
                for (t = 0, n = a.length; t < n; t++) Rn[a[t]] ? a[t] = Rn[a[t]] : a[t] = O(a[t]);
                return function(i) {
                    var r = "";
                    for (t = 0; t < n; t++) r += a[t] instanceof Function ? a[t].call(i, e) : a[t];
                    return r;
                };
            }
            function P(e, t) {
                return e.isValid() ? (t = F(t, e.localeData()), qn[t] = qn[t] || I(t), qn[t](e)) : e.localeData().invalidDate();
            }
            function F(e, t) {
                function n(e) {
                    return t.longDateFormat(e) || e;
                }
                var a = 5;
                for (Wn.lastIndex = 0; a >= 0 && Wn.test(e); ) e = e.replace(Wn, n), Wn.lastIndex = 0, 
                a -= 1;
                return e;
            }
            function U(e) {
                return "function" == typeof e && "[object Function]" === Object.prototype.toString.call(e);
            }
            function N(e, t, n) {
                sa[e] = U(t) ? t : function(e) {
                    return e && n ? n : t;
                };
            }
            function V(e, t) {
                return o(sa, e) ? sa[e](t._strict, t._locale) : new RegExp(W(e));
            }
            function W(e) {
                return e.replace("\\", "").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function(e, t, n, a, i) {
                    return t || n || a || i;
                }).replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
            }
            function q(e, t) {
                var n, a = t;
                for ("string" == typeof e && (e = [ e ]), "number" == typeof t && (a = function(e, n) {
                    n[t] = v(e);
                }), n = 0; n < e.length; n++) oa[e[n]] = a;
            }
            function R(e, t) {
                q(e, function(e, n, a, i) {
                    a._w = a._w || {}, t(e, a._w, a, i);
                });
            }
            function z(e, t, n) {
                null != t && o(oa, e) && oa[e](t, n._a, n, e);
            }
            function B(e, t) {
                return new Date(Date.UTC(e, t + 1, 0)).getUTCDate();
            }
            function G(e) {
                return this._months[e.month()];
            }
            function J(e) {
                return this._monthsShort[e.month()];
            }
            function K(e, t, n) {
                var a, i, r;
                for (this._monthsParse || (this._monthsParse = [], this._longMonthsParse = [], this._shortMonthsParse = []), 
                a = 0; a < 12; a++) {
                    if (i = l([ 2e3, a ]), n && !this._longMonthsParse[a] && (this._longMonthsParse[a] = new RegExp("^" + this.months(i, "").replace(".", "") + "$", "i"), 
                    this._shortMonthsParse[a] = new RegExp("^" + this.monthsShort(i, "").replace(".", "") + "$", "i")), 
                    n || this._monthsParse[a] || (r = "^" + this.months(i, "") + "|^" + this.monthsShort(i, ""), 
                    this._monthsParse[a] = new RegExp(r.replace(".", ""), "i")), n && "MMMM" === t && this._longMonthsParse[a].test(e)) return a;
                    if (n && "MMM" === t && this._shortMonthsParse[a].test(e)) return a;
                    if (!n && this._monthsParse[a].test(e)) return a;
                }
            }
            function Q(e, t) {
                var n;
                return "string" == typeof t && (t = e.localeData().monthsParse(t), "number" != typeof t) ? e : (n = Math.min(e.date(), B(e.year(), t)), 
                e._d["set" + (e._isUTC ? "UTC" : "") + "Month"](t, n), e);
            }
            function Z(e) {
                return null != e ? (Q(this, e), t.updateOffset(this, !0), this) : C(this, "Month");
            }
            function X() {
                return B(this.year(), this.month());
            }
            function ee(e) {
                var t, n = e._a;
                return n && d(e).overflow === -2 && (t = n[la] < 0 || n[la] > 11 ? la : n[ca] < 1 || n[ca] > B(n[ua], n[la]) ? ca : n[da] < 0 || n[da] > 24 || 24 === n[da] && (0 !== n[fa] || 0 !== n[ma] || 0 !== n[pa]) ? da : n[fa] < 0 || n[fa] > 59 ? fa : n[ma] < 0 || n[ma] > 59 ? ma : n[pa] < 0 || n[pa] > 999 ? pa : -1, 
                d(e)._overflowDayOfYear && (t < ua || t > ca) && (t = ca), d(e).overflow = t), e;
            }
            function te(e) {
                t.suppressDeprecationWarnings === !1 && "undefined" != typeof console && console.warn && console.warn("Deprecation warning: " + e);
            }
            function ne(e, t) {
                var n = !0;
                return u(function() {
                    return n && (te(e + "\n" + new Error().stack), n = !1), t.apply(this, arguments);
                }, t);
            }
            function ae(e, t) {
                _a[e] || (te(t), _a[e] = !0);
            }
            function ie(e) {
                var t, n, a = e._i, i = va.exec(a);
                if (i) {
                    for (d(e).iso = !0, t = 0, n = ba.length; t < n; t++) if (ba[t][1].exec(a)) {
                        e._f = ba[t][0];
                        break;
                    }
                    for (t = 0, n = ya.length; t < n; t++) if (ya[t][1].exec(a)) {
                        e._f += (i[6] || " ") + ya[t][0];
                        break;
                    }
                    a.match(aa) && (e._f += "Z"), ke(e);
                } else e._isValid = !1;
            }
            function re(e) {
                var n = Ma.exec(e._i);
                return null !== n ? void (e._d = new Date(+n[1])) : (ie(e), void (e._isValid === !1 && (delete e._isValid, 
                t.createFromInputFallback(e))));
            }
            function se(e, t, n, a, i, r, s) {
                var o = new Date(e, t, n, a, i, r, s);
                return e < 1970 && o.setFullYear(e), o;
            }
            function oe(e) {
                var t = new Date(Date.UTC.apply(null, arguments));
                return e < 1970 && t.setUTCFullYear(e), t;
            }
            function ue(e) {
                return le(e) ? 366 : 365;
            }
            function le(e) {
                return e % 4 === 0 && e % 100 !== 0 || e % 400 === 0;
            }
            function ce() {
                return le(this.year());
            }
            function de(e, t, n) {
                var a, i = n - t, r = n - e.day();
                return r > i && (r -= 7), r < i - 7 && (r += 7), a = Ce(e).add(r, "d"), {
                    week: Math.ceil(a.dayOfYear() / 7),
                    year: a.year()
                };
            }
            function fe(e) {
                return de(e, this._week.dow, this._week.doy).week;
            }
            function me() {
                return this._week.dow;
            }
            function pe() {
                return this._week.doy;
            }
            function he(e) {
                var t = this.localeData().week(this);
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function ge(e) {
                var t = de(this, 1, 4).week;
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function _e(e, t, n, a, i) {
                var r, s = 6 + i - a, o = oe(e, 0, 1 + s), u = o.getUTCDay();
                return u < i && (u += 7), n = null != n ? 1 * n : i, r = 1 + s + 7 * (t - 1) - u + n, 
                {
                    year: r > 0 ? e : e - 1,
                    dayOfYear: r > 0 ? r : ue(e - 1) + r
                };
            }
            function ve(e) {
                var t = Math.round((this.clone().startOf("day") - this.clone().startOf("year")) / 864e5) + 1;
                return null == e ? t : this.add(e - t, "d");
            }
            function be(e, t, n) {
                return null != e ? e : null != t ? t : n;
            }
            function ye(e) {
                var t = new Date();
                return e._useUTC ? [ t.getUTCFullYear(), t.getUTCMonth(), t.getUTCDate() ] : [ t.getFullYear(), t.getMonth(), t.getDate() ];
            }
            function Me(e) {
                var t, n, a, i, r = [];
                if (!e._d) {
                    for (a = ye(e), e._w && null == e._a[ca] && null == e._a[la] && $e(e), e._dayOfYear && (i = be(e._a[ua], a[ua]), 
                    e._dayOfYear > ue(i) && (d(e)._overflowDayOfYear = !0), n = oe(i, 0, e._dayOfYear), 
                    e._a[la] = n.getUTCMonth(), e._a[ca] = n.getUTCDate()), t = 0; t < 3 && null == e._a[t]; ++t) e._a[t] = r[t] = a[t];
                    for (;t < 7; t++) e._a[t] = r[t] = null == e._a[t] ? 2 === t ? 1 : 0 : e._a[t];
                    24 === e._a[da] && 0 === e._a[fa] && 0 === e._a[ma] && 0 === e._a[pa] && (e._nextDay = !0, 
                    e._a[da] = 0), e._d = (e._useUTC ? oe : se).apply(null, r), null != e._tzm && e._d.setUTCMinutes(e._d.getUTCMinutes() - e._tzm), 
                    e._nextDay && (e._a[da] = 24);
                }
            }
            function $e(e) {
                var t, n, a, i, r, s, o;
                t = e._w, null != t.GG || null != t.W || null != t.E ? (r = 1, s = 4, n = be(t.GG, e._a[ua], de(Ce(), 1, 4).year), 
                a = be(t.W, 1), i = be(t.E, 1)) : (r = e._locale._week.dow, s = e._locale._week.doy, 
                n = be(t.gg, e._a[ua], de(Ce(), r, s).year), a = be(t.w, 1), null != t.d ? (i = t.d, 
                i < r && ++a) : i = null != t.e ? t.e + r : r), o = _e(n, a, i, s, r), e._a[ua] = o.year, 
                e._dayOfYear = o.dayOfYear;
            }
            function ke(e) {
                if (e._f === t.ISO_8601) return void ie(e);
                e._a = [], d(e).empty = !0;
                var n, a, i, r, s, o = "" + e._i, u = o.length, l = 0;
                for (i = F(e._f, e._locale).match(Vn) || [], n = 0; n < i.length; n++) r = i[n], 
                a = (o.match(V(r, e)) || [])[0], a && (s = o.substr(0, o.indexOf(a)), s.length > 0 && d(e).unusedInput.push(s), 
                o = o.slice(o.indexOf(a) + a.length), l += a.length), Rn[r] ? (a ? d(e).empty = !1 : d(e).unusedTokens.push(r), 
                z(r, a, e)) : e._strict && !a && d(e).unusedTokens.push(r);
                d(e).charsLeftOver = u - l, o.length > 0 && d(e).unusedInput.push(o), d(e).bigHour === !0 && e._a[da] <= 12 && e._a[da] > 0 && (d(e).bigHour = void 0), 
                e._a[da] = we(e._locale, e._a[da], e._meridiem), Me(e), ee(e);
            }
            function we(e, t, n) {
                var a;
                return null == n ? t : null != e.meridiemHour ? e.meridiemHour(t, n) : null != e.isPM ? (a = e.isPM(n), 
                a && t < 12 && (t += 12), a || 12 !== t || (t = 0), t) : t;
            }
            function Le(e) {
                var t, n, a, i, r;
                if (0 === e._f.length) return d(e).invalidFormat = !0, void (e._d = new Date(NaN));
                for (i = 0; i < e._f.length; i++) r = 0, t = p({}, e), null != e._useUTC && (t._useUTC = e._useUTC), 
                t._f = e._f[i], ke(t), f(t) && (r += d(t).charsLeftOver, r += 10 * d(t).unusedTokens.length, 
                d(t).score = r, (null == a || r < a) && (a = r, n = t));
                u(e, n || t);
            }
            function De(e) {
                if (!e._d) {
                    var t = S(e._i);
                    e._a = [ t.year, t.month, t.day || t.date, t.hour, t.minute, t.second, t.millisecond ], 
                    Me(e);
                }
            }
            function Ye(e) {
                var t = new h(ee(Te(e)));
                return t._nextDay && (t.add(1, "d"), t._nextDay = void 0), t;
            }
            function Te(e) {
                var t = e._i, n = e._f;
                return e._locale = e._locale || D(e._l), null === t || void 0 === n && "" === t ? m({
                    nullInput: !0
                }) : ("string" == typeof t && (e._i = t = e._locale.preparse(t)), g(t) ? new h(ee(t)) : (i(n) ? Le(e) : n ? ke(e) : r(t) ? e._d = t : Se(e), 
                e));
            }
            function Se(e) {
                var n = e._i;
                void 0 === n ? e._d = new Date() : r(n) ? e._d = new Date(+n) : "string" == typeof n ? re(e) : i(n) ? (e._a = s(n.slice(0), function(e) {
                    return parseInt(e, 10);
                }), Me(e)) : "object" == typeof n ? De(e) : "number" == typeof n ? e._d = new Date(n) : t.createFromInputFallback(e);
            }
            function xe(e, t, n, a, i) {
                var r = {};
                return "boolean" == typeof n && (a = n, n = void 0), r._isAMomentObject = !0, r._useUTC = r._isUTC = i, 
                r._l = n, r._i = e, r._f = t, r._strict = a, Ye(r);
            }
            function Ce(e, t, n, a) {
                return xe(e, t, n, a, !1);
            }
            function Ee(e, t) {
                var n, a;
                if (1 === t.length && i(t[0]) && (t = t[0]), !t.length) return Ce();
                for (n = t[0], a = 1; a < t.length; ++a) t[a].isValid() && !t[a][e](n) || (n = t[a]);
                return n;
            }
            function He() {
                var e = [].slice.call(arguments, 0);
                return Ee("isBefore", e);
            }
            function je() {
                var e = [].slice.call(arguments, 0);
                return Ee("isAfter", e);
            }
            function Ae(e) {
                var t = S(e), n = t.year || 0, a = t.quarter || 0, i = t.month || 0, r = t.week || 0, s = t.day || 0, o = t.hour || 0, u = t.minute || 0, l = t.second || 0, c = t.millisecond || 0;
                this._milliseconds = +c + 1e3 * l + 6e4 * u + 36e5 * o, this._days = +s + 7 * r, 
                this._months = +i + 3 * a + 12 * n, this._data = {}, this._locale = D(), this._bubble();
            }
            function Oe(e) {
                return e instanceof Ae;
            }
            function Ie(e, t) {
                A(e, 0, 0, function() {
                    var e = this.utcOffset(), n = "+";
                    return e < 0 && (e = -e, n = "-"), n + j(~~(e / 60), 2) + t + j(~~e % 60, 2);
                });
            }
            function Pe(e) {
                var t = (e || "").match(aa) || [], n = t[t.length - 1] || [], a = (n + "").match(Da) || [ "-", 0, 0 ], i = +(60 * a[1]) + v(a[2]);
                return "+" === a[0] ? i : -i;
            }
            function Fe(e, n) {
                var a, i;
                return n._isUTC ? (a = n.clone(), i = (g(e) || r(e) ? +e : +Ce(e)) - +a, a._d.setTime(+a._d + i), 
                t.updateOffset(a, !1), a) : Ce(e).local();
            }
            function Ue(e) {
                return 15 * -Math.round(e._d.getTimezoneOffset() / 15);
            }
            function Ne(e, n) {
                var a, i = this._offset || 0;
                return null != e ? ("string" == typeof e && (e = Pe(e)), Math.abs(e) < 16 && (e *= 60), 
                !this._isUTC && n && (a = Ue(this)), this._offset = e, this._isUTC = !0, null != a && this.add(a, "m"), 
                i !== e && (!n || this._changeInProgress ? at(this, Ze(e - i, "m"), 1, !1) : this._changeInProgress || (this._changeInProgress = !0, 
                t.updateOffset(this, !0), this._changeInProgress = null)), this) : this._isUTC ? i : Ue(this);
            }
            function Ve(e, t) {
                return null != e ? ("string" != typeof e && (e = -e), this.utcOffset(e, t), this) : -this.utcOffset();
            }
            function We(e) {
                return this.utcOffset(0, e);
            }
            function qe(e) {
                return this._isUTC && (this.utcOffset(0, e), this._isUTC = !1, e && this.subtract(Ue(this), "m")), 
                this;
            }
            function Re() {
                return this._tzm ? this.utcOffset(this._tzm) : "string" == typeof this._i && this.utcOffset(Pe(this._i)), 
                this;
            }
            function ze(e) {
                return e = e ? Ce(e).utcOffset() : 0, (this.utcOffset() - e) % 60 === 0;
            }
            function Be() {
                return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
            }
            function Ge() {
                if ("undefined" != typeof this._isDSTShifted) return this._isDSTShifted;
                var e = {};
                if (p(e, this), e = Te(e), e._a) {
                    var t = e._isUTC ? l(e._a) : Ce(e._a);
                    this._isDSTShifted = this.isValid() && b(e._a, t.toArray()) > 0;
                } else this._isDSTShifted = !1;
                return this._isDSTShifted;
            }
            function Je() {
                return !this._isUTC;
            }
            function Ke() {
                return this._isUTC;
            }
            function Qe() {
                return this._isUTC && 0 === this._offset;
            }
            function Ze(e, t) {
                var n, a, i, r = e, s = null;
                return Oe(e) ? r = {
                    ms: e._milliseconds,
                    d: e._days,
                    M: e._months
                } : "number" == typeof e ? (r = {}, t ? r[t] = e : r.milliseconds = e) : (s = Ya.exec(e)) ? (n = "-" === s[1] ? -1 : 1, 
                r = {
                    y: 0,
                    d: v(s[ca]) * n,
                    h: v(s[da]) * n,
                    m: v(s[fa]) * n,
                    s: v(s[ma]) * n,
                    ms: v(s[pa]) * n
                }) : (s = Ta.exec(e)) ? (n = "-" === s[1] ? -1 : 1, r = {
                    y: Xe(s[2], n),
                    M: Xe(s[3], n),
                    d: Xe(s[4], n),
                    h: Xe(s[5], n),
                    m: Xe(s[6], n),
                    s: Xe(s[7], n),
                    w: Xe(s[8], n)
                }) : null == r ? r = {} : "object" == typeof r && ("from" in r || "to" in r) && (i = tt(Ce(r.from), Ce(r.to)), 
                r = {}, r.ms = i.milliseconds, r.M = i.months), a = new Ae(r), Oe(e) && o(e, "_locale") && (a._locale = e._locale), 
                a;
            }
            function Xe(e, t) {
                var n = e && parseFloat(e.replace(",", "."));
                return (isNaN(n) ? 0 : n) * t;
            }
            function et(e, t) {
                var n = {
                    milliseconds: 0,
                    months: 0
                };
                return n.months = t.month() - e.month() + 12 * (t.year() - e.year()), e.clone().add(n.months, "M").isAfter(t) && --n.months, 
                n.milliseconds = +t - +e.clone().add(n.months, "M"), n;
            }
            function tt(e, t) {
                var n;
                return t = Fe(t, e), e.isBefore(t) ? n = et(e, t) : (n = et(t, e), n.milliseconds = -n.milliseconds, 
                n.months = -n.months), n;
            }
            function nt(e, t) {
                return function(n, a) {
                    var i, r;
                    return null === a || isNaN(+a) || (ae(t, "moment()." + t + "(period, number) is deprecated. Please use moment()." + t + "(number, period)."), 
                    r = n, n = a, a = r), n = "string" == typeof n ? +n : n, i = Ze(n, a), at(this, i, e), 
                    this;
                };
            }
            function at(e, n, a, i) {
                var r = n._milliseconds, s = n._days, o = n._months;
                i = null == i || i, r && e._d.setTime(+e._d + r * a), s && E(e, "Date", C(e, "Date") + s * a), 
                o && Q(e, C(e, "Month") + o * a), i && t.updateOffset(e, s || o);
            }
            function it(e, t) {
                var n = e || Ce(), a = Fe(n, this).startOf("day"), i = this.diff(a, "days", !0), r = i < -6 ? "sameElse" : i < -1 ? "lastWeek" : i < 0 ? "lastDay" : i < 1 ? "sameDay" : i < 2 ? "nextDay" : i < 7 ? "nextWeek" : "sameElse";
                return this.format(t && t[r] || this.localeData().calendar(r, this, Ce(n)));
            }
            function rt() {
                return new h(this);
            }
            function st(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this > +e) : (n = g(e) ? +e : +Ce(e), n < +this.clone().startOf(t));
            }
            function ot(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this < +e) : (n = g(e) ? +e : +Ce(e), +this.clone().endOf(t) < n);
            }
            function ut(e, t, n) {
                return this.isAfter(e, n) && this.isBefore(t, n);
            }
            function lt(e, t) {
                var n;
                return t = T(t || "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), +this === +e) : (n = +Ce(e), 
                +this.clone().startOf(t) <= n && n <= +this.clone().endOf(t));
            }
            function ct(e, t, n) {
                var a, i, r = Fe(e, this), s = 6e4 * (r.utcOffset() - this.utcOffset());
                return t = T(t), "year" === t || "month" === t || "quarter" === t ? (i = dt(this, r), 
                "quarter" === t ? i /= 3 : "year" === t && (i /= 12)) : (a = this - r, i = "second" === t ? a / 1e3 : "minute" === t ? a / 6e4 : "hour" === t ? a / 36e5 : "day" === t ? (a - s) / 864e5 : "week" === t ? (a - s) / 6048e5 : a), 
                n ? i : _(i);
            }
            function dt(e, t) {
                var n, a, i = 12 * (t.year() - e.year()) + (t.month() - e.month()), r = e.clone().add(i, "months");
                return t - r < 0 ? (n = e.clone().add(i - 1, "months"), a = (t - r) / (r - n)) : (n = e.clone().add(i + 1, "months"), 
                a = (t - r) / (n - r)), -(i + a);
            }
            function ft() {
                return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
            }
            function mt() {
                var e = this.clone().utc();
                return 0 < e.year() && e.year() <= 9999 ? "function" == typeof Date.prototype.toISOString ? this.toDate().toISOString() : P(e, "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]") : P(e, "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]");
            }
            function pt(e) {
                var n = P(this, e || t.defaultFormat);
                return this.localeData().postformat(n);
            }
            function ht(e, t) {
                return this.isValid() ? Ze({
                    to: this,
                    from: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function gt(e) {
                return this.from(Ce(), e);
            }
            function _t(e, t) {
                return this.isValid() ? Ze({
                    from: this,
                    to: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function vt(e) {
                return this.to(Ce(), e);
            }
            function bt(e) {
                var t;
                return void 0 === e ? this._locale._abbr : (t = D(e), null != t && (this._locale = t), 
                this);
            }
            function yt() {
                return this._locale;
            }
            function Mt(e) {
                switch (e = T(e)) {
                  case "year":
                    this.month(0);

                  case "quarter":
                  case "month":
                    this.date(1);

                  case "week":
                  case "isoWeek":
                  case "day":
                    this.hours(0);

                  case "hour":
                    this.minutes(0);

                  case "minute":
                    this.seconds(0);

                  case "second":
                    this.milliseconds(0);
                }
                return "week" === e && this.weekday(0), "isoWeek" === e && this.isoWeekday(1), "quarter" === e && this.month(3 * Math.floor(this.month() / 3)), 
                this;
            }
            function $t(e) {
                return e = T(e), void 0 === e || "millisecond" === e ? this : this.startOf(e).add(1, "isoWeek" === e ? "week" : e).subtract(1, "ms");
            }
            function kt() {
                return +this._d - 6e4 * (this._offset || 0);
            }
            function wt() {
                return Math.floor(+this / 1e3);
            }
            function Lt() {
                return this._offset ? new Date(+this) : this._d;
            }
            function Dt() {
                var e = this;
                return [ e.year(), e.month(), e.date(), e.hour(), e.minute(), e.second(), e.millisecond() ];
            }
            function Yt() {
                var e = this;
                return {
                    years: e.year(),
                    months: e.month(),
                    date: e.date(),
                    hours: e.hours(),
                    minutes: e.minutes(),
                    seconds: e.seconds(),
                    milliseconds: e.milliseconds()
                };
            }
            function Tt() {
                return f(this);
            }
            function St() {
                return u({}, d(this));
            }
            function xt() {
                return d(this).overflow;
            }
            function Ct(e, t) {
                A(0, [ e, e.length ], 0, t);
            }
            function Et(e, t, n) {
                return de(Ce([ e, 11, 31 + t - n ]), t, n).week;
            }
            function Ht(e) {
                var t = de(this, this.localeData()._week.dow, this.localeData()._week.doy).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function jt(e) {
                var t = de(this, 1, 4).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function At() {
                return Et(this.year(), 1, 4);
            }
            function Ot() {
                var e = this.localeData()._week;
                return Et(this.year(), e.dow, e.doy);
            }
            function It(e) {
                return null == e ? Math.ceil((this.month() + 1) / 3) : this.month(3 * (e - 1) + this.month() % 3);
            }
            function Pt(e, t) {
                return "string" != typeof e ? e : isNaN(e) ? (e = t.weekdaysParse(e), "number" == typeof e ? e : null) : parseInt(e, 10);
            }
            function Ft(e) {
                return this._weekdays[e.day()];
            }
            function Ut(e) {
                return this._weekdaysShort[e.day()];
            }
            function Nt(e) {
                return this._weekdaysMin[e.day()];
            }
            function Vt(e) {
                var t, n, a;
                for (this._weekdaysParse = this._weekdaysParse || [], t = 0; t < 7; t++) if (this._weekdaysParse[t] || (n = Ce([ 2e3, 1 ]).day(t), 
                a = "^" + this.weekdays(n, "") + "|^" + this.weekdaysShort(n, "") + "|^" + this.weekdaysMin(n, ""), 
                this._weekdaysParse[t] = new RegExp(a.replace(".", ""), "i")), this._weekdaysParse[t].test(e)) return t;
            }
            function Wt(e) {
                var t = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
                return null != e ? (e = Pt(e, this.localeData()), this.add(e - t, "d")) : t;
            }
            function qt(e) {
                var t = (this.day() + 7 - this.localeData()._week.dow) % 7;
                return null == e ? t : this.add(e - t, "d");
            }
            function Rt(e) {
                return null == e ? this.day() || 7 : this.day(this.day() % 7 ? e : e - 7);
            }
            function zt(e, t) {
                A(e, 0, 0, function() {
                    return this.localeData().meridiem(this.hours(), this.minutes(), t);
                });
            }
            function Bt(e, t) {
                return t._meridiemParse;
            }
            function Gt(e) {
                return "p" === (e + "").toLowerCase().charAt(0);
            }
            function Jt(e, t, n) {
                return e > 11 ? n ? "pm" : "PM" : n ? "am" : "AM";
            }
            function Kt(e, t) {
                t[pa] = v(1e3 * ("0." + e));
            }
            function Qt() {
                return this._isUTC ? "UTC" : "";
            }
            function Zt() {
                return this._isUTC ? "Coordinated Universal Time" : "";
            }
            function Xt(e) {
                return Ce(1e3 * e);
            }
            function en() {
                return Ce.apply(null, arguments).parseZone();
            }
            function tn(e, t, n) {
                var a = this._calendar[e];
                return "function" == typeof a ? a.call(t, n) : a;
            }
            function nn(e) {
                var t = this._longDateFormat[e], n = this._longDateFormat[e.toUpperCase()];
                return t || !n ? t : (this._longDateFormat[e] = n.replace(/MMMM|MM|DD|dddd/g, function(e) {
                    return e.slice(1);
                }), this._longDateFormat[e]);
            }
            function an() {
                return this._invalidDate;
            }
            function rn(e) {
                return this._ordinal.replace("%d", e);
            }
            function sn(e) {
                return e;
            }
            function on(e, t, n, a) {
                var i = this._relativeTime[n];
                return "function" == typeof i ? i(e, t, n, a) : i.replace(/%d/i, e);
            }
            function un(e, t) {
                var n = this._relativeTime[e > 0 ? "future" : "past"];
                return "function" == typeof n ? n(t) : n.replace(/%s/i, t);
            }
            function ln(e) {
                var t, n;
                for (n in e) t = e[n], "function" == typeof t ? this[n] = t : this["_" + n] = t;
                this._ordinalParseLenient = new RegExp(this._ordinalParse.source + "|" + /\d{1,2}/.source);
            }
            function cn(e, t, n, a) {
                var i = D(), r = l().set(a, t);
                return i[n](r, e);
            }
            function dn(e, t, n, a, i) {
                if ("number" == typeof e && (t = e, e = void 0), e = e || "", null != t) return cn(e, t, n, i);
                var r, s = [];
                for (r = 0; r < a; r++) s[r] = cn(e, r, n, i);
                return s;
            }
            function fn(e, t) {
                return dn(e, t, "months", 12, "month");
            }
            function mn(e, t) {
                return dn(e, t, "monthsShort", 12, "month");
            }
            function pn(e, t) {
                return dn(e, t, "weekdays", 7, "day");
            }
            function hn(e, t) {
                return dn(e, t, "weekdaysShort", 7, "day");
            }
            function gn(e, t) {
                return dn(e, t, "weekdaysMin", 7, "day");
            }
            function _n() {
                var e = this._data;
                return this._milliseconds = Qa(this._milliseconds), this._days = Qa(this._days), 
                this._months = Qa(this._months), e.milliseconds = Qa(e.milliseconds), e.seconds = Qa(e.seconds), 
                e.minutes = Qa(e.minutes), e.hours = Qa(e.hours), e.months = Qa(e.months), e.years = Qa(e.years), 
                this;
            }
            function vn(e, t, n, a) {
                var i = Ze(t, n);
                return e._milliseconds += a * i._milliseconds, e._days += a * i._days, e._months += a * i._months, 
                e._bubble();
            }
            function bn(e, t) {
                return vn(this, e, t, 1);
            }
            function yn(e, t) {
                return vn(this, e, t, -1);
            }
            function Mn(e) {
                return e < 0 ? Math.floor(e) : Math.ceil(e);
            }
            function $n() {
                var e, t, n, a, i, r = this._milliseconds, s = this._days, o = this._months, u = this._data;
                return r >= 0 && s >= 0 && o >= 0 || r <= 0 && s <= 0 && o <= 0 || (r += 864e5 * Mn(wn(o) + s), 
                s = 0, o = 0), u.milliseconds = r % 1e3, e = _(r / 1e3), u.seconds = e % 60, t = _(e / 60), 
                u.minutes = t % 60, n = _(t / 60), u.hours = n % 24, s += _(n / 24), i = _(kn(s)), 
                o += i, s -= Mn(wn(i)), a = _(o / 12), o %= 12, u.days = s, u.months = o, u.years = a, 
                this;
            }
            function kn(e) {
                return 4800 * e / 146097;
            }
            function wn(e) {
                return 146097 * e / 4800;
            }
            function Ln(e) {
                var t, n, a = this._milliseconds;
                if (e = T(e), "month" === e || "year" === e) return t = this._days + a / 864e5, 
                n = this._months + kn(t), "month" === e ? n : n / 12;
                switch (t = this._days + Math.round(wn(this._months)), e) {
                  case "week":
                    return t / 7 + a / 6048e5;

                  case "day":
                    return t + a / 864e5;

                  case "hour":
                    return 24 * t + a / 36e5;

                  case "minute":
                    return 1440 * t + a / 6e4;

                  case "second":
                    return 86400 * t + a / 1e3;

                  case "millisecond":
                    return Math.floor(864e5 * t) + a;

                  default:
                    throw new Error("Unknown unit " + e);
                }
            }
            function Dn() {
                return this._milliseconds + 864e5 * this._days + this._months % 12 * 2592e6 + 31536e6 * v(this._months / 12);
            }
            function Yn(e) {
                return function() {
                    return this.as(e);
                };
            }
            function Tn(e) {
                return e = T(e), this[e + "s"]();
            }
            function Sn(e) {
                return function() {
                    return this._data[e];
                };
            }
            function xn() {
                return _(this.days() / 7);
            }
            function Cn(e, t, n, a, i) {
                return i.relativeTime(t || 1, !!n, e, a);
            }
            function En(e, t, n) {
                var a = Ze(e).abs(), i = mi(a.as("s")), r = mi(a.as("m")), s = mi(a.as("h")), o = mi(a.as("d")), u = mi(a.as("M")), l = mi(a.as("y")), c = i < pi.s && [ "s", i ] || 1 === r && [ "m" ] || r < pi.m && [ "mm", r ] || 1 === s && [ "h" ] || s < pi.h && [ "hh", s ] || 1 === o && [ "d" ] || o < pi.d && [ "dd", o ] || 1 === u && [ "M" ] || u < pi.M && [ "MM", u ] || 1 === l && [ "y" ] || [ "yy", l ];
                return c[2] = t, c[3] = +e > 0, c[4] = n, Cn.apply(null, c);
            }
            function Hn(e, t) {
                return void 0 !== pi[e] && (void 0 === t ? pi[e] : (pi[e] = t, !0));
            }
            function jn(e) {
                var t = this.localeData(), n = En(this, !e, t);
                return e && (n = t.pastFuture(+this, n)), t.postformat(n);
            }
            function An() {
                var e, t, n, a = hi(this._milliseconds) / 1e3, i = hi(this._days), r = hi(this._months);
                e = _(a / 60), t = _(e / 60), a %= 60, e %= 60, n = _(r / 12), r %= 12;
                var s = n, o = r, u = i, l = t, c = e, d = a, f = this.asSeconds();
                return f ? (f < 0 ? "-" : "") + "P" + (s ? s + "Y" : "") + (o ? o + "M" : "") + (u ? u + "D" : "") + (l || c || d ? "T" : "") + (l ? l + "H" : "") + (c ? c + "M" : "") + (d ? d + "S" : "") : "P0D";
            }
            var On, In, Pn = t.momentProperties = [], Fn = !1, Un = {}, Nn = {}, Vn = /(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Q|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g, Wn = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, qn = {}, Rn = {}, zn = /\d/, Bn = /\d\d/, Gn = /\d{3}/, Jn = /\d{4}/, Kn = /[+-]?\d{6}/, Qn = /\d\d?/, Zn = /\d{1,3}/, Xn = /\d{1,4}/, ea = /[+-]?\d{1,6}/, ta = /\d+/, na = /[+-]?\d+/, aa = /Z|[+-]\d\d:?\d\d/gi, ia = /[+-]?\d+(\.\d{1,3})?/, ra = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i, sa = {}, oa = {}, ua = 0, la = 1, ca = 2, da = 3, fa = 4, ma = 5, pa = 6;
            A("M", [ "MM", 2 ], "Mo", function() {
                return this.month() + 1;
            }), A("MMM", 0, 0, function(e) {
                return this.localeData().monthsShort(this, e);
            }), A("MMMM", 0, 0, function(e) {
                return this.localeData().months(this, e);
            }), Y("month", "M"), N("M", Qn), N("MM", Qn, Bn), N("MMM", ra), N("MMMM", ra), q([ "M", "MM" ], function(e, t) {
                t[la] = v(e) - 1;
            }), q([ "MMM", "MMMM" ], function(e, t, n, a) {
                var i = n._locale.monthsParse(e, a, n._strict);
                null != i ? t[la] = i : d(n).invalidMonth = e;
            });
            var ha = "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ga = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"), _a = {};
            t.suppressDeprecationWarnings = !1;
            var va = /^\s*(?:[+-]\d{6}|\d{4})-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/, ba = [ [ "YYYYYY-MM-DD", /[+-]\d{6}-\d{2}-\d{2}/ ], [ "YYYY-MM-DD", /\d{4}-\d{2}-\d{2}/ ], [ "GGGG-[W]WW-E", /\d{4}-W\d{2}-\d/ ], [ "GGGG-[W]WW", /\d{4}-W\d{2}/ ], [ "YYYY-DDD", /\d{4}-\d{3}/ ] ], ya = [ [ "HH:mm:ss.SSSS", /(T| )\d\d:\d\d:\d\d\.\d+/ ], [ "HH:mm:ss", /(T| )\d\d:\d\d:\d\d/ ], [ "HH:mm", /(T| )\d\d:\d\d/ ], [ "HH", /(T| )\d\d/ ] ], Ma = /^\/?Date\((\-?\d+)/i;
            t.createFromInputFallback = ne("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to https://github.com/moment/moment/issues/1407 for more info.", function(e) {
                e._d = new Date(e._i + (e._useUTC ? " UTC" : ""));
            }), A(0, [ "YY", 2 ], 0, function() {
                return this.year() % 100;
            }), A(0, [ "YYYY", 4 ], 0, "year"), A(0, [ "YYYYY", 5 ], 0, "year"), A(0, [ "YYYYYY", 6, !0 ], 0, "year"), 
            Y("year", "y"), N("Y", na), N("YY", Qn, Bn), N("YYYY", Xn, Jn), N("YYYYY", ea, Kn), 
            N("YYYYYY", ea, Kn), q([ "YYYYY", "YYYYYY" ], ua), q("YYYY", function(e, n) {
                n[ua] = 2 === e.length ? t.parseTwoDigitYear(e) : v(e);
            }), q("YY", function(e, n) {
                n[ua] = t.parseTwoDigitYear(e);
            }), t.parseTwoDigitYear = function(e) {
                return v(e) + (v(e) > 68 ? 1900 : 2e3);
            };
            var $a = x("FullYear", !1);
            A("w", [ "ww", 2 ], "wo", "week"), A("W", [ "WW", 2 ], "Wo", "isoWeek"), Y("week", "w"), 
            Y("isoWeek", "W"), N("w", Qn), N("ww", Qn, Bn), N("W", Qn), N("WW", Qn, Bn), R([ "w", "ww", "W", "WW" ], function(e, t, n, a) {
                t[a.substr(0, 1)] = v(e);
            });
            var ka = {
                dow: 0,
                doy: 6
            };
            A("DDD", [ "DDDD", 3 ], "DDDo", "dayOfYear"), Y("dayOfYear", "DDD"), N("DDD", Zn), 
            N("DDDD", Gn), q([ "DDD", "DDDD" ], function(e, t, n) {
                n._dayOfYear = v(e);
            }), t.ISO_8601 = function() {};
            var wa = ne("moment().min is deprecated, use moment.min instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e < this ? this : e;
            }), La = ne("moment().max is deprecated, use moment.max instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e > this ? this : e;
            });
            Ie("Z", ":"), Ie("ZZ", ""), N("Z", aa), N("ZZ", aa), q([ "Z", "ZZ" ], function(e, t, n) {
                n._useUTC = !0, n._tzm = Pe(e);
            });
            var Da = /([\+\-]|\d\d)/gi;
            t.updateOffset = function() {};
            var Ya = /(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/, Ta = /^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/;
            Ze.fn = Ae.prototype;
            var Sa = nt(1, "add"), xa = nt(-1, "subtract");
            t.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
            var Ca = ne("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.", function(e) {
                return void 0 === e ? this.localeData() : this.locale(e);
            });
            A(0, [ "gg", 2 ], 0, function() {
                return this.weekYear() % 100;
            }), A(0, [ "GG", 2 ], 0, function() {
                return this.isoWeekYear() % 100;
            }), Ct("gggg", "weekYear"), Ct("ggggg", "weekYear"), Ct("GGGG", "isoWeekYear"), 
            Ct("GGGGG", "isoWeekYear"), Y("weekYear", "gg"), Y("isoWeekYear", "GG"), N("G", na), 
            N("g", na), N("GG", Qn, Bn), N("gg", Qn, Bn), N("GGGG", Xn, Jn), N("gggg", Xn, Jn), 
            N("GGGGG", ea, Kn), N("ggggg", ea, Kn), R([ "gggg", "ggggg", "GGGG", "GGGGG" ], function(e, t, n, a) {
                t[a.substr(0, 2)] = v(e);
            }), R([ "gg", "GG" ], function(e, n, a, i) {
                n[i] = t.parseTwoDigitYear(e);
            }), A("Q", 0, 0, "quarter"), Y("quarter", "Q"), N("Q", zn), q("Q", function(e, t) {
                t[la] = 3 * (v(e) - 1);
            }), A("D", [ "DD", 2 ], "Do", "date"), Y("date", "D"), N("D", Qn), N("DD", Qn, Bn), 
            N("Do", function(e, t) {
                return e ? t._ordinalParse : t._ordinalParseLenient;
            }), q([ "D", "DD" ], ca), q("Do", function(e, t) {
                t[ca] = v(e.match(Qn)[0], 10);
            });
            var Ea = x("Date", !0);
            A("d", 0, "do", "day"), A("dd", 0, 0, function(e) {
                return this.localeData().weekdaysMin(this, e);
            }), A("ddd", 0, 0, function(e) {
                return this.localeData().weekdaysShort(this, e);
            }), A("dddd", 0, 0, function(e) {
                return this.localeData().weekdays(this, e);
            }), A("e", 0, 0, "weekday"), A("E", 0, 0, "isoWeekday"), Y("day", "d"), Y("weekday", "e"), 
            Y("isoWeekday", "E"), N("d", Qn), N("e", Qn), N("E", Qn), N("dd", ra), N("ddd", ra), 
            N("dddd", ra), R([ "dd", "ddd", "dddd" ], function(e, t, n) {
                var a = n._locale.weekdaysParse(e);
                null != a ? t.d = a : d(n).invalidWeekday = e;
            }), R([ "d", "e", "E" ], function(e, t, n, a) {
                t[a] = v(e);
            });
            var Ha = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), ja = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"), Aa = "Su_Mo_Tu_We_Th_Fr_Sa".split("_");
            A("H", [ "HH", 2 ], 0, "hour"), A("h", [ "hh", 2 ], 0, function() {
                return this.hours() % 12 || 12;
            }), zt("a", !0), zt("A", !1), Y("hour", "h"), N("a", Bt), N("A", Bt), N("H", Qn), 
            N("h", Qn), N("HH", Qn, Bn), N("hh", Qn, Bn), q([ "H", "HH" ], da), q([ "a", "A" ], function(e, t, n) {
                n._isPm = n._locale.isPM(e), n._meridiem = e;
            }), q([ "h", "hh" ], function(e, t, n) {
                t[da] = v(e), d(n).bigHour = !0;
            });
            var Oa = /[ap]\.?m?\.?/i, Ia = x("Hours", !0);
            A("m", [ "mm", 2 ], 0, "minute"), Y("minute", "m"), N("m", Qn), N("mm", Qn, Bn), 
            q([ "m", "mm" ], fa);
            var Pa = x("Minutes", !1);
            A("s", [ "ss", 2 ], 0, "second"), Y("second", "s"), N("s", Qn), N("ss", Qn, Bn), 
            q([ "s", "ss" ], ma);
            var Fa = x("Seconds", !1);
            A("S", 0, 0, function() {
                return ~~(this.millisecond() / 100);
            }), A(0, [ "SS", 2 ], 0, function() {
                return ~~(this.millisecond() / 10);
            }), A(0, [ "SSS", 3 ], 0, "millisecond"), A(0, [ "SSSS", 4 ], 0, function() {
                return 10 * this.millisecond();
            }), A(0, [ "SSSSS", 5 ], 0, function() {
                return 100 * this.millisecond();
            }), A(0, [ "SSSSSS", 6 ], 0, function() {
                return 1e3 * this.millisecond();
            }), A(0, [ "SSSSSSS", 7 ], 0, function() {
                return 1e4 * this.millisecond();
            }), A(0, [ "SSSSSSSS", 8 ], 0, function() {
                return 1e5 * this.millisecond();
            }), A(0, [ "SSSSSSSSS", 9 ], 0, function() {
                return 1e6 * this.millisecond();
            }), Y("millisecond", "ms"), N("S", Zn, zn), N("SS", Zn, Bn), N("SSS", Zn, Gn);
            var Ua;
            for (Ua = "SSSS"; Ua.length <= 9; Ua += "S") N(Ua, ta);
            for (Ua = "S"; Ua.length <= 9; Ua += "S") q(Ua, Kt);
            var Na = x("Milliseconds", !1);
            A("z", 0, 0, "zoneAbbr"), A("zz", 0, 0, "zoneName");
            var Va = h.prototype;
            Va.add = Sa, Va.calendar = it, Va.clone = rt, Va.diff = ct, Va.endOf = $t, Va.format = pt, 
            Va.from = ht, Va.fromNow = gt, Va.to = _t, Va.toNow = vt, Va.get = H, Va.invalidAt = xt, 
            Va.isAfter = st, Va.isBefore = ot, Va.isBetween = ut, Va.isSame = lt, Va.isValid = Tt, 
            Va.lang = Ca, Va.locale = bt, Va.localeData = yt, Va.max = La, Va.min = wa, Va.parsingFlags = St, 
            Va.set = H, Va.startOf = Mt, Va.subtract = xa, Va.toArray = Dt, Va.toObject = Yt, 
            Va.toDate = Lt, Va.toISOString = mt, Va.toJSON = mt, Va.toString = ft, Va.unix = wt, 
            Va.valueOf = kt, Va.year = $a, Va.isLeapYear = ce, Va.weekYear = Ht, Va.isoWeekYear = jt, 
            Va.quarter = Va.quarters = It, Va.month = Z, Va.daysInMonth = X, Va.week = Va.weeks = he, 
            Va.isoWeek = Va.isoWeeks = ge, Va.weeksInYear = Ot, Va.isoWeeksInYear = At, Va.date = Ea, 
            Va.day = Va.days = Wt, Va.weekday = qt, Va.isoWeekday = Rt, Va.dayOfYear = ve, Va.hour = Va.hours = Ia, 
            Va.minute = Va.minutes = Pa, Va.second = Va.seconds = Fa, Va.millisecond = Va.milliseconds = Na, 
            Va.utcOffset = Ne, Va.utc = We, Va.local = qe, Va.parseZone = Re, Va.hasAlignedHourOffset = ze, 
            Va.isDST = Be, Va.isDSTShifted = Ge, Va.isLocal = Je, Va.isUtcOffset = Ke, Va.isUtc = Qe, 
            Va.isUTC = Qe, Va.zoneAbbr = Qt, Va.zoneName = Zt, Va.dates = ne("dates accessor is deprecated. Use date instead.", Ea), 
            Va.months = ne("months accessor is deprecated. Use month instead", Z), Va.years = ne("years accessor is deprecated. Use year instead", $a), 
            Va.zone = ne("moment().zone is deprecated, use moment().utcOffset instead. https://github.com/moment/moment/issues/1779", Ve);
            var Wa = Va, qa = {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            }, Ra = {
                LTS: "h:mm:ss A",
                LT: "h:mm A",
                L: "MM/DD/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY h:mm A",
                LLLL: "dddd, MMMM D, YYYY h:mm A"
            }, za = "Invalid date", Ba = "%d", Ga = /\d{1,2}/, Ja = {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            }, Ka = y.prototype;
            Ka._calendar = qa, Ka.calendar = tn, Ka._longDateFormat = Ra, Ka.longDateFormat = nn, 
            Ka._invalidDate = za, Ka.invalidDate = an, Ka._ordinal = Ba, Ka.ordinal = rn, Ka._ordinalParse = Ga, 
            Ka.preparse = sn, Ka.postformat = sn, Ka._relativeTime = Ja, Ka.relativeTime = on, 
            Ka.pastFuture = un, Ka.set = ln, Ka.months = G, Ka._months = ha, Ka.monthsShort = J, 
            Ka._monthsShort = ga, Ka.monthsParse = K, Ka.week = fe, Ka._week = ka, Ka.firstDayOfYear = pe, 
            Ka.firstDayOfWeek = me, Ka.weekdays = Ft, Ka._weekdays = Ha, Ka.weekdaysMin = Nt, 
            Ka._weekdaysMin = Aa, Ka.weekdaysShort = Ut, Ka._weekdaysShort = ja, Ka.weekdaysParse = Vt, 
            Ka.isPM = Gt, Ka._meridiemParse = Oa, Ka.meridiem = Jt, w("en", {
                ordinalParse: /\d{1,2}(th|st|nd|rd)/,
                ordinal: function(e) {
                    var t = e % 10, n = 1 === v(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                    return e + n;
                }
            }), t.lang = ne("moment.lang is deprecated. Use moment.locale instead.", w), t.langData = ne("moment.langData is deprecated. Use moment.localeData instead.", D);
            var Qa = Math.abs, Za = Yn("ms"), Xa = Yn("s"), ei = Yn("m"), ti = Yn("h"), ni = Yn("d"), ai = Yn("w"), ii = Yn("M"), ri = Yn("y"), si = Sn("milliseconds"), oi = Sn("seconds"), ui = Sn("minutes"), li = Sn("hours"), ci = Sn("days"), di = Sn("months"), fi = Sn("years"), mi = Math.round, pi = {
                s: 45,
                m: 45,
                h: 22,
                d: 26,
                M: 11
            }, hi = Math.abs, gi = Ae.prototype;
            gi.abs = _n, gi.add = bn, gi.subtract = yn, gi.as = Ln, gi.asMilliseconds = Za, 
            gi.asSeconds = Xa, gi.asMinutes = ei, gi.asHours = ti, gi.asDays = ni, gi.asWeeks = ai, 
            gi.asMonths = ii, gi.asYears = ri, gi.valueOf = Dn, gi._bubble = $n, gi.get = Tn, 
            gi.milliseconds = si, gi.seconds = oi, gi.minutes = ui, gi.hours = li, gi.days = ci, 
            gi.weeks = xn, gi.months = di, gi.years = fi, gi.humanize = jn, gi.toISOString = An, 
            gi.toString = An, gi.toJSON = An, gi.locale = bt, gi.localeData = yt, gi.toIsoString = ne("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)", An), 
            gi.lang = Ca, A("X", 0, 0, "unix"), A("x", 0, 0, "valueOf"), N("x", na), N("X", ia), 
            q("X", function(e, t, n) {
                n._d = new Date(1e3 * parseFloat(e, 10));
            }), q("x", function(e, t, n) {
                n._d = new Date(v(e));
            }), t.version = "2.10.6", a(Ce), t.fn = Wa, t.min = He, t.max = je, t.utc = l, t.unix = Xt, 
            t.months = fn, t.isDate = r, t.locale = w, t.invalid = m, t.duration = Ze, t.isMoment = g, 
            t.weekdays = pn, t.parseZone = en, t.localeData = D, t.isDuration = Oe, t.monthsShort = mn, 
            t.weekdaysMin = gn, t.defineLocale = L, t.weekdaysShort = hn, t.normalizeUnits = T, 
            t.relativeTimeThreshold = Hn;
            var _i = t;
            return _i;
        });
    }).call(t, n(63)(e));
}, function(e, t) {
    e.exports = function(e) {
        return e.webpackPolyfill || (e.deprecate = function() {}, e.paths = [], e.children = [], 
        e.webpackPolyfill = 1), e;
    };
}, function(e, t, n) {
    function a(e) {
        return n(i(e));
    }
    function i(e) {
        return r[e] || function() {
            throw new Error("Cannot find module '" + e + "'.");
        }();
    }
    var r = {
        "./af": 65,
        "./af.js": 65,
        "./ar": 66,
        "./ar-ma": 67,
        "./ar-ma.js": 67,
        "./ar-sa": 68,
        "./ar-sa.js": 68,
        "./ar-tn": 69,
        "./ar-tn.js": 69,
        "./ar.js": 66,
        "./az": 70,
        "./az.js": 70,
        "./be": 71,
        "./be.js": 71,
        "./bg": 72,
        "./bg.js": 72,
        "./bn": 73,
        "./bn.js": 73,
        "./bo": 74,
        "./bo.js": 74,
        "./br": 75,
        "./br.js": 75,
        "./bs": 76,
        "./bs.js": 76,
        "./ca": 77,
        "./ca.js": 77,
        "./cs": 78,
        "./cs.js": 78,
        "./cv": 79,
        "./cv.js": 79,
        "./cy": 80,
        "./cy.js": 80,
        "./da": 81,
        "./da.js": 81,
        "./de": 82,
        "./de-at": 83,
        "./de-at.js": 83,
        "./de.js": 82,
        "./el": 84,
        "./el.js": 84,
        "./en-au": 85,
        "./en-au.js": 85,
        "./en-ca": 86,
        "./en-ca.js": 86,
        "./en-gb": 87,
        "./en-gb.js": 87,
        "./eo": 88,
        "./eo.js": 88,
        "./es": 89,
        "./es.js": 89,
        "./et": 90,
        "./et.js": 90,
        "./eu": 91,
        "./eu.js": 91,
        "./fa": 92,
        "./fa.js": 92,
        "./fi": 93,
        "./fi.js": 93,
        "./fo": 94,
        "./fo.js": 94,
        "./fr": 95,
        "./fr-ca": 96,
        "./fr-ca.js": 96,
        "./fr.js": 95,
        "./fy": 97,
        "./fy.js": 97,
        "./gl": 98,
        "./gl.js": 98,
        "./he": 99,
        "./he.js": 99,
        "./hi": 100,
        "./hi.js": 100,
        "./hr": 101,
        "./hr.js": 101,
        "./hu": 102,
        "./hu.js": 102,
        "./hy-am": 103,
        "./hy-am.js": 103,
        "./id": 104,
        "./id.js": 104,
        "./is": 105,
        "./is.js": 105,
        "./it": 106,
        "./it.js": 106,
        "./ja": 107,
        "./ja.js": 107,
        "./jv": 108,
        "./jv.js": 108,
        "./ka": 109,
        "./ka.js": 109,
        "./km": 110,
        "./km.js": 110,
        "./ko": 111,
        "./ko.js": 111,
        "./lb": 112,
        "./lb.js": 112,
        "./lt": 113,
        "./lt.js": 113,
        "./lv": 114,
        "./lv.js": 114,
        "./me": 115,
        "./me.js": 115,
        "./mk": 116,
        "./mk.js": 116,
        "./ml": 117,
        "./ml.js": 117,
        "./mr": 118,
        "./mr.js": 118,
        "./ms": 119,
        "./ms-my": 120,
        "./ms-my.js": 120,
        "./ms.js": 119,
        "./my": 121,
        "./my.js": 121,
        "./nb": 122,
        "./nb.js": 122,
        "./ne": 123,
        "./ne.js": 123,
        "./nl": 124,
        "./nl.js": 124,
        "./nn": 125,
        "./nn.js": 125,
        "./pl": 126,
        "./pl.js": 126,
        "./pt": 127,
        "./pt-br": 128,
        "./pt-br.js": 128,
        "./pt.js": 127,
        "./ro": 129,
        "./ro.js": 129,
        "./ru": 130,
        "./ru.js": 130,
        "./si": 131,
        "./si.js": 131,
        "./sk": 132,
        "./sk.js": 132,
        "./sl": 133,
        "./sl.js": 133,
        "./sq": 134,
        "./sq.js": 134,
        "./sr": 135,
        "./sr-cyrl": 136,
        "./sr-cyrl.js": 136,
        "./sr.js": 135,
        "./sv": 137,
        "./sv.js": 137,
        "./ta": 138,
        "./ta.js": 138,
        "./th": 139,
        "./th.js": 139,
        "./tl-ph": 140,
        "./tl-ph.js": 140,
        "./tr": 141,
        "./tr.js": 141,
        "./tzl": 142,
        "./tzl.js": 142,
        "./tzm": 143,
        "./tzm-latn": 144,
        "./tzm-latn.js": 144,
        "./tzm.js": 143,
        "./uk": 145,
        "./uk.js": 145,
        "./uz": 146,
        "./uz.js": 146,
        "./vi": 147,
        "./vi.js": 147,
        "./zh-cn": 148,
        "./zh-cn.js": 148,
        "./zh-tw": 149,
        "./zh-tw.js": 149
    };
    a.keys = function() {
        return Object.keys(r);
    }, a.resolve = i, e.exports = a, a.id = 64;
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : afrikaans (af)
    //! author : Werner Mollentze : https://github.com/wernerm
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("af", {
            months: "Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),
            weekdaysShort: "Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),
            weekdaysMin: "So_Ma_Di_Wo_Do_Vr_Sa".split("_"),
            meridiemParse: /vm|nm/i,
            isPM: function(e) {
                return /^nm$/i.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n ? "vm" : "VM" : n ? "nm" : "NM";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Vandag om] LT",
                nextDay: "[Môre om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[Gister om] LT",
                lastWeek: "[Laas] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oor %s",
                past: "%s gelede",
                s: "'n paar sekondes",
                m: "'n minuut",
                mm: "%d minute",
                h: "'n uur",
                hh: "%d ure",
                d: "'n dag",
                dd: "%d dae",
                M: "'n maand",
                MM: "%d maande",
                y: "'n jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! Locale: Arabic (ar)
    //! Author: Abdel Said: https://github.com/abdelsaid
    //! Changes in months, weekdays: Ahmed Elkhatib
    //! Native plural forms: forabi https://github.com/forabi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = function(e) {
            return 0 === e ? 0 : 1 === e ? 1 : 2 === e ? 2 : e % 100 >= 3 && e % 100 <= 10 ? 3 : e % 100 >= 11 ? 4 : 5;
        }, i = {
            s: [ "أقل من ثانية", "ثانية واحدة", [ "ثانيتان", "ثانيتين" ], "%d ثوان", "%d ثانية", "%d ثانية" ],
            m: [ "أقل من دقيقة", "دقيقة واحدة", [ "دقيقتان", "دقيقتين" ], "%d دقائق", "%d دقيقة", "%d دقيقة" ],
            h: [ "أقل من ساعة", "ساعة واحدة", [ "ساعتان", "ساعتين" ], "%d ساعات", "%d ساعة", "%d ساعة" ],
            d: [ "أقل من يوم", "يوم واحد", [ "يومان", "يومين" ], "%d أيام", "%d يومًا", "%d يوم" ],
            M: [ "أقل من شهر", "شهر واحد", [ "شهران", "شهرين" ], "%d أشهر", "%d شهرا", "%d شهر" ],
            y: [ "أقل من عام", "عام واحد", [ "عامان", "عامين" ], "%d أعوام", "%d عامًا", "%d عام" ]
        }, r = function(e) {
            return function(t, n, r, s) {
                var o = a(t), u = i[e][a(t)];
                return 2 === o && (u = u[n ? 0 : 1]), u.replace(/%d/i, t);
            };
        }, s = [ "كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر" ], o = e.defineLocale("ar", {
            months: s,
            monthsShort: s,
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "D/‏M/‏YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم عند الساعة] LT",
                nextDay: "[غدًا عند الساعة] LT",
                nextWeek: "dddd [عند الساعة] LT",
                lastDay: "[أمس عند الساعة] LT",
                lastWeek: "dddd [عند الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "بعد %s",
                past: "منذ %s",
                s: r("s"),
                m: r("m"),
                mm: r("m"),
                h: r("h"),
                hh: r("h"),
                d: r("d"),
                dd: r("d"),
                M: r("M"),
                MM: r("M"),
                y: r("y"),
                yy: r("y")
            },
            preparse: function(e) {
                return e.replace(/\u200f/g, "").replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return o;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Moroccan Arabic (ar-ma)
    //! author : ElFadili Yassine : https://github.com/ElFadiliY
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-ma", {
            months: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            weekdays: "الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Arabic Saudi Arabia (ar-sa)
    //! author : Suhail Alkowaileet : https://github.com/xsoh
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = e.defineLocale("ar-sa", {
            months: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            preparse: function(e) {
                return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale  : Tunisian Arabic (ar-tn)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-tn", {
            months: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : azerbaijani (az)
    //! author : topchiyev : https://github.com/topchiyev
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "-inci",
            5: "-inci",
            8: "-inci",
            70: "-inci",
            80: "-inci",
            2: "-nci",
            7: "-nci",
            20: "-nci",
            50: "-nci",
            3: "-üncü",
            4: "-üncü",
            100: "-üncü",
            6: "-ncı",
            9: "-uncu",
            10: "-uncu",
            30: "-uncu",
            60: "-ıncı",
            90: "-ıncı"
        }, n = e.defineLocale("az", {
            months: "yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),
            monthsShort: "yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),
            weekdays: "Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə".split("_"),
            weekdaysShort: "Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən".split("_"),
            weekdaysMin: "Bz_BE_ÇA_Çə_CA_Cü_Şə".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[sabah saat] LT",
                nextWeek: "[gələn həftə] dddd [saat] LT",
                lastDay: "[dünən] LT",
                lastWeek: "[keçən həftə] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s əvvəl",
                s: "birneçə saniyyə",
                m: "bir dəqiqə",
                mm: "%d dəqiqə",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir il",
                yy: "%d il"
            },
            meridiemParse: /gecə|səhər|gündüz|axşam/,
            isPM: function(e) {
                return /^(gündüz|axşam)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "gecə" : e < 12 ? "səhər" : e < 17 ? "gündüz" : "axşam";
            },
            ordinalParse: /\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,
            ordinal: function(e) {
                if (0 === e) return e + "-ıncı";
                var n = e % 10, a = e % 100 - n, i = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[i]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : belarusian (be)
    //! author : Dmitry Demidov : https://github.com/demidov91
    //! author: Praleska: http://praleska.pro/
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var i = {
                mm: n ? "хвіліна_хвіліны_хвілін" : "хвіліну_хвіліны_хвілін",
                hh: n ? "гадзіна_гадзіны_гадзін" : "гадзіну_гадзіны_гадзін",
                dd: "дзень_дні_дзён",
                MM: "месяц_месяцы_месяцаў",
                yy: "год_гады_гадоў"
            };
            return "m" === a ? n ? "хвіліна" : "хвіліну" : "h" === a ? n ? "гадзіна" : "гадзіну" : e + " " + t(i[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань".split("_"),
                accusative: "студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function i(e, t) {
            var n = {
                nominative: "нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота".split("_"),
                accusative: "нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу".split("_")
            }, a = /\[ ?[Вв] ?(?:мінулую|наступную)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var r = e.defineLocale("be", {
            months: a,
            monthsShort: "студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж".split("_"),
            weekdays: i,
            weekdaysShort: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            weekdaysMin: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сёння ў] LT",
                nextDay: "[Заўтра ў] LT",
                lastDay: "[Учора ў] LT",
                nextWeek: function() {
                    return "[У] dddd [ў] LT";
                },
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return "[У мінулую] dddd [ў] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[У мінулы] dddd [ў] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "праз %s",
                past: "%s таму",
                s: "некалькі секунд",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "дзень",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночы|раніцы|дня|вечара/,
            isPM: function(e) {
                return /^(дня|вечара)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночы" : e < 12 ? "раніцы" : e < 17 ? "дня" : "вечара";
            },
            ordinalParse: /\d{1,2}-(і|ы|га)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e % 10 !== 2 && e % 10 !== 3 || e % 100 === 12 || e % 100 === 13 ? e + "-ы" : e + "-і";

                  case "D":
                    return e + "-га";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bulgarian (bg)
    //! author : Krasen Borisov : https://github.com/kraz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("bg", {
            months: "януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "янр_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "неделя_понеделник_вторник_сряда_четвъртък_петък_събота".split("_"),
            weekdaysShort: "нед_пон_вто_сря_чет_пет_съб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Днес в] LT",
                nextDay: "[Утре в] LT",
                nextWeek: "dddd [в] LT",
                lastDay: "[Вчера в] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[В изминалата] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[В изминалия] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "след %s",
                past: "преди %s",
                s: "няколко секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дни",
                M: "месец",
                MM: "%d месеца",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bengali (bn)
    //! author : Kaushik Gandhi : https://github.com/kaushikgandhi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "১",
            "2": "২",
            "3": "৩",
            "4": "৪",
            "5": "৫",
            "6": "৬",
            "7": "৭",
            "8": "৮",
            "9": "৯",
            "0": "০"
        }, n = {
            "১": "1",
            "২": "2",
            "৩": "3",
            "৪": "4",
            "৫": "5",
            "৬": "6",
            "৭": "7",
            "৮": "8",
            "৯": "9",
            "০": "0"
        }, a = e.defineLocale("bn", {
            months: "জানুয়ারী_ফেবুয়ারী_মার্চ_এপ্রিল_মে_জুন_জুলাই_অগাস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),
            monthsShort: "জানু_ফেব_মার্চ_এপর_মে_জুন_জুল_অগ_সেপ্ট_অক্টো_নভ_ডিসেম্".split("_"),
            weekdays: "রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পত্তিবার_শুক্রুবার_শনিবার".split("_"),
            weekdaysShort: "রবি_সোম_মঙ্গল_বুধ_বৃহস্পত্তি_শুক্রু_শনি".split("_"),
            weekdaysMin: "রব_সম_মঙ্গ_বু_ব্রিহ_শু_শনি".split("_"),
            longDateFormat: {
                LT: "A h:mm সময়",
                LTS: "A h:mm:ss সময়",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm সময়",
                LLLL: "dddd, D MMMM YYYY, A h:mm সময়"
            },
            calendar: {
                sameDay: "[আজ] LT",
                nextDay: "[আগামীকাল] LT",
                nextWeek: "dddd, LT",
                lastDay: "[গতকাল] LT",
                lastWeek: "[গত] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s পরে",
                past: "%s আগে",
                s: "কএক সেকেন্ড",
                m: "এক মিনিট",
                mm: "%d মিনিট",
                h: "এক ঘন্টা",
                hh: "%d ঘন্টা",
                d: "এক দিন",
                dd: "%d দিন",
                M: "এক মাস",
                MM: "%d মাস",
                y: "এক বছর",
                yy: "%d বছর"
            },
            preparse: function(e) {
                return e.replace(/[১২৩৪৫৬৭৮৯০]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /রাত|সকাল|দুপুর|বিকেল|রাত/,
            isPM: function(e) {
                return /^(দুপুর|বিকেল|রাত)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "রাত" : e < 10 ? "সকাল" : e < 17 ? "দুপুর" : e < 20 ? "বিকেল" : "রাত";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tibetan (bo)
    //! author : Thupten N. Chakrishar : https://github.com/vajradog
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "༡",
            "2": "༢",
            "3": "༣",
            "4": "༤",
            "5": "༥",
            "6": "༦",
            "7": "༧",
            "8": "༨",
            "9": "༩",
            "0": "༠"
        }, n = {
            "༡": "1",
            "༢": "2",
            "༣": "3",
            "༤": "4",
            "༥": "5",
            "༦": "6",
            "༧": "7",
            "༨": "8",
            "༩": "9",
            "༠": "0"
        }, a = e.defineLocale("bo", {
            months: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            monthsShort: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            weekdays: "གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་".split("_"),
            weekdaysShort: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            weekdaysMin: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            longDateFormat: {
                LT: "A h:mm",
                LTS: "A h:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm",
                LLLL: "dddd, D MMMM YYYY, A h:mm"
            },
            calendar: {
                sameDay: "[དི་རིང] LT",
                nextDay: "[སང་ཉིན] LT",
                nextWeek: "[བདུན་ཕྲག་རྗེས་མ], LT",
                lastDay: "[ཁ་སང] LT",
                lastWeek: "[བདུན་ཕྲག་མཐའ་མ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s ལ་",
                past: "%s སྔན་ལ",
                s: "ལམ་སང",
                m: "སྐར་མ་གཅིག",
                mm: "%d སྐར་མ",
                h: "ཆུ་ཚོད་གཅིག",
                hh: "%d ཆུ་ཚོད",
                d: "ཉིན་གཅིག",
                dd: "%d ཉིན་",
                M: "ཟླ་བ་གཅིག",
                MM: "%d ཟླ་བ",
                y: "ལོ་གཅིག",
                yy: "%d ལོ"
            },
            preparse: function(e) {
                return e.replace(/[༡༢༣༤༥༦༧༨༩༠]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,
            isPM: function(e) {
                return /^(ཉིན་གུང|དགོང་དག|མཚན་མོ)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "མཚན་མོ" : e < 10 ? "ཞོགས་ཀས" : e < 17 ? "ཉིན་གུང" : e < 20 ? "དགོང་དག" : "མཚན་མོ";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : breton (br)
    //! author : Jean-Baptiste Le Duigou : https://github.com/jbleduigou
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "munutenn",
                MM: "miz",
                dd: "devezh"
            };
            return e + " " + i(a[n], e);
        }
        function n(e) {
            switch (a(e)) {
              case 1:
              case 3:
              case 4:
              case 5:
              case 9:
                return e + " bloaz";

              default:
                return e + " vloaz";
            }
        }
        function a(e) {
            return e > 9 ? a(e % 10) : e;
        }
        function i(e, t) {
            return 2 === t ? r(e) : e;
        }
        function r(e) {
            var t = {
                m: "v",
                b: "v",
                d: "z"
            };
            return void 0 === t[e.charAt(0)] ? e : t[e.charAt(0)] + e.substring(1);
        }
        var s = e.defineLocale("br", {
            months: "Genver_C'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),
            monthsShort: "Gen_C'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),
            weekdays: "Sul_Lun_Meurzh_Merc'her_Yaou_Gwener_Sadorn".split("_"),
            weekdaysShort: "Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "h[e]mm A",
                LTS: "h[e]mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D [a viz] MMMM YYYY",
                LLL: "D [a viz] MMMM YYYY h[e]mm A",
                LLLL: "dddd, D [a viz] MMMM YYYY h[e]mm A"
            },
            calendar: {
                sameDay: "[Hiziv da] LT",
                nextDay: "[Warc'hoazh da] LT",
                nextWeek: "dddd [da] LT",
                lastDay: "[Dec'h da] LT",
                lastWeek: "dddd [paset da] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "a-benn %s",
                past: "%s 'zo",
                s: "un nebeud segondennoù",
                m: "ur vunutenn",
                mm: t,
                h: "un eur",
                hh: "%d eur",
                d: "un devezh",
                dd: t,
                M: "ur miz",
                MM: t,
                y: "ur bloaz",
                yy: n
            },
            ordinalParse: /\d{1,2}(añ|vet)/,
            ordinal: function(e) {
                var t = 1 === e ? "añ" : "vet";
                return e + t;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bosnian (bs)
    //! author : Nedim Cholich : https://github.com/frontyard
    //! based on (hr) translation by Bojan Marković
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("bs", {
            months: "januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : catalan (ca)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ca", {
            months: "gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),
            monthsShort: "gen._febr._mar._abr._mai._jun._jul._ag._set._oct._nov._des.".split("_"),
            weekdays: "diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),
            weekdaysShort: "dg._dl._dt._dc._dj._dv._ds.".split("_"),
            weekdaysMin: "Dg_Dl_Dt_Dc_Dj_Dv_Ds".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "LT:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[avui a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextDay: function() {
                    return "[demà a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastDay: function() {
                    return "[ahir a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [passat a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "fa %s",
                s: "uns segons",
                m: "un minut",
                mm: "%d minuts",
                h: "una hora",
                hh: "%d hores",
                d: "un dia",
                dd: "%d dies",
                M: "un mes",
                MM: "%d mesos",
                y: "un any",
                yy: "%d anys"
            },
            ordinalParse: /\d{1,2}(r|n|t|è|a)/,
            ordinal: function(e, t) {
                var n = 1 === e ? "r" : 2 === e ? "n" : 3 === e ? "r" : 4 === e ? "t" : "è";
                return "w" !== t && "W" !== t || (n = "a"), e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : czech (cs)
    //! author : petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5 && 1 !== ~~(e / 10);
        }
        function n(e, n, a, i) {
            var r = e + " ";
            switch (a) {
              case "s":
                return n || i ? "pár sekund" : "pár sekundami";

              case "m":
                return n ? "minuta" : i ? "minutu" : "minutou";

              case "mm":
                return n || i ? r + (t(e) ? "minuty" : "minut") : r + "minutami";

              case "h":
                return n ? "hodina" : i ? "hodinu" : "hodinou";

              case "hh":
                return n || i ? r + (t(e) ? "hodiny" : "hodin") : r + "hodinami";

              case "d":
                return n || i ? "den" : "dnem";

              case "dd":
                return n || i ? r + (t(e) ? "dny" : "dní") : r + "dny";

              case "M":
                return n || i ? "měsíc" : "měsícem";

              case "MM":
                return n || i ? r + (t(e) ? "měsíce" : "měsíců") : r + "měsíci";

              case "y":
                return n || i ? "rok" : "rokem";

              case "yy":
                return n || i ? r + (t(e) ? "roky" : "let") : r + "lety";
            }
        }
        var a = "leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec".split("_"), i = "led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro".split("_"), r = e.defineLocale("cs", {
            months: a,
            monthsShort: i,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, i),
            weekdays: "neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota".split("_"),
            weekdaysShort: "ne_po_út_st_čt_pá_so".split("_"),
            weekdaysMin: "ne_po_út_st_čt_pá_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes v] LT",
                nextDay: "[zítra v] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v neděli v] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [v] LT";

                      case 3:
                        return "[ve středu v] LT";

                      case 4:
                        return "[ve čtvrtek v] LT";

                      case 5:
                        return "[v pátek v] LT";

                      case 6:
                        return "[v sobotu v] LT";
                    }
                },
                lastDay: "[včera v] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulou neděli v] LT";

                      case 1:
                      case 2:
                        return "[minulé] dddd [v] LT";

                      case 3:
                        return "[minulou středu v] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [v] LT";

                      case 6:
                        return "[minulou sobotu v] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "před %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chuvash (cv)
    //! author : Anatoly Mironov : https://github.com/mirontoli
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cv", {
            months: "кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав".split("_"),
            monthsShort: "кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш".split("_"),
            weekdays: "вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун".split("_"),
            weekdaysShort: "выр_тун_ытл_юн_кӗҫ_эрн_шӑм".split("_"),
            weekdaysMin: "вр_тн_ыт_юн_кҫ_эр_шм".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]",
                LLL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm",
                LLLL: "dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm"
            },
            calendar: {
                sameDay: "[Паян] LT [сехетре]",
                nextDay: "[Ыран] LT [сехетре]",
                lastDay: "[Ӗнер] LT [сехетре]",
                nextWeek: "[Ҫитес] dddd LT [сехетре]",
                lastWeek: "[Иртнӗ] dddd LT [сехетре]",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    var t = /сехет$/i.exec(e) ? "рен" : /ҫул$/i.exec(e) ? "тан" : "ран";
                    return e + t;
                },
                past: "%s каялла",
                s: "пӗр-ик ҫеккунт",
                m: "пӗр минут",
                mm: "%d минут",
                h: "пӗр сехет",
                hh: "%d сехет",
                d: "пӗр кун",
                dd: "%d кун",
                M: "пӗр уйӑх",
                MM: "%d уйӑх",
                y: "пӗр ҫул",
                yy: "%d ҫул"
            },
            ordinalParse: /\d{1,2}-мӗш/,
            ordinal: "%d-мӗш",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Welsh (cy)
    //! author : Robert Allen
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cy", {
            months: "Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),
            monthsShort: "Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),
            weekdays: "Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),
            weekdaysShort: "Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heddiw am] LT",
                nextDay: "[Yfory am] LT",
                nextWeek: "dddd [am] LT",
                lastDay: "[Ddoe am] LT",
                lastWeek: "dddd [diwethaf am] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "mewn %s",
                past: "%s yn ôl",
                s: "ychydig eiliadau",
                m: "munud",
                mm: "%d munud",
                h: "awr",
                hh: "%d awr",
                d: "diwrnod",
                dd: "%d diwrnod",
                M: "mis",
                MM: "%d mis",
                y: "blwyddyn",
                yy: "%d flynedd"
            },
            ordinalParse: /\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,
            ordinal: function(e) {
                var t = e, n = "", a = [ "", "af", "il", "ydd", "ydd", "ed", "ed", "ed", "fed", "fed", "fed", "eg", "fed", "eg", "eg", "fed", "eg", "eg", "fed", "eg", "fed" ];
                return t > 20 ? n = 40 === t || 50 === t || 60 === t || 80 === t || 100 === t ? "fed" : "ain" : t > 0 && (n = a[t]), 
                e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : danish (da)
    //! author : Ulrik Nielsen : https://github.com/mrbase
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("da", {
            months: "januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tir_ons_tor_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd [d.] D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag kl.] LT",
                nextDay: "[I morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[I går kl.] LT",
                lastWeek: "[sidste] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "%s siden",
                s: "få sekunder",
                m: "et minut",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dage",
                M: "en måned",
                MM: "%d måneder",
                y: "et år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : german (de)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? i[n][0] : i[n][1];
        }
        var n = e.defineLocale("de", {
            months: "Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : austrian german (de-at)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    //! author : Martin Groller : https://github.com/MadMG
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? i[n][0] : i[n][1];
        }
        var n = e.defineLocale("de-at", {
            months: "Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : modern greek (el)
    //! author : Aggelos Karalias : https://github.com/mehiel
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("el", {
            monthsNominativeEl: "Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος".split("_"),
            monthsGenitiveEl: "Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου".split("_"),
            months: function(e, t) {
                return /D/.test(t.substring(0, t.indexOf("MMMM"))) ? this._monthsGenitiveEl[e.month()] : this._monthsNominativeEl[e.month()];
            },
            monthsShort: "Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ".split("_"),
            weekdays: "Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο".split("_"),
            weekdaysShort: "Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ".split("_"),
            weekdaysMin: "Κυ_Δε_Τρ_Τε_Πε_Πα_Σα".split("_"),
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "μμ" : "ΜΜ" : n ? "πμ" : "ΠΜ";
            },
            isPM: function(e) {
                return "μ" === (e + "").toLowerCase()[0];
            },
            meridiemParse: /[ΠΜ]\.?Μ?\.?/i,
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendarEl: {
                sameDay: "[Σήμερα {}] LT",
                nextDay: "[Αύριο {}] LT",
                nextWeek: "dddd [{}] LT",
                lastDay: "[Χθες {}] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 6:
                        return "[το προηγούμενο] dddd [{}] LT";

                      default:
                        return "[την προηγούμενη] dddd [{}] LT";
                    }
                },
                sameElse: "L"
            },
            calendar: function(e, t) {
                var n = this._calendarEl[e], a = t && t.hours();
                return "function" == typeof n && (n = n.apply(t)), n.replace("{}", a % 12 === 1 ? "στη" : "στις");
            },
            relativeTime: {
                future: "σε %s",
                past: "%s πριν",
                s: "λίγα δευτερόλεπτα",
                m: "ένα λεπτό",
                mm: "%d λεπτά",
                h: "μία ώρα",
                hh: "%d ώρες",
                d: "μία μέρα",
                dd: "%d μέρες",
                M: "ένας μήνας",
                MM: "%d μήνες",
                y: "ένας χρόνος",
                yy: "%d χρόνια"
            },
            ordinalParse: /\d{1,2}η/,
            ordinal: "%dη",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : australian english (en-au)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-au", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian english (en-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-ca", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "YYYY-MM-DD",
                LL: "D MMMM, YYYY",
                LLL: "D MMMM, YYYY h:mm A",
                LLLL: "dddd, D MMMM, YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : great britain english (en-gb)
    //! author : Chris Gedrim : https://github.com/chrisgedrim
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-gb", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : esperanto (eo)
    //! author : Colin Dean : https://github.com/colindean
    //! komento: Mi estas malcerta se mi korekte traktis akuzativojn en tiu traduko.
    //!          Se ne, bonvolu korekti kaj avizi min por ke mi povas lerni!
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eo", {
            months: "januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aŭg_sep_okt_nov_dec".split("_"),
            weekdays: "Dimanĉo_Lundo_Mardo_Merkredo_Ĵaŭdo_Vendredo_Sabato".split("_"),
            weekdaysShort: "Dim_Lun_Mard_Merk_Ĵaŭ_Ven_Sab".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Ĵa_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D[-an de] MMMM, YYYY",
                LLL: "D[-an de] MMMM, YYYY HH:mm",
                LLLL: "dddd, [la] D[-an de] MMMM, YYYY HH:mm"
            },
            meridiemParse: /[ap]\.t\.m/i,
            isPM: function(e) {
                return "p" === e.charAt(0).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "p.t.m." : "P.T.M." : n ? "a.t.m." : "A.T.M.";
            },
            calendar: {
                sameDay: "[Hodiaŭ je] LT",
                nextDay: "[Morgaŭ je] LT",
                nextWeek: "dddd [je] LT",
                lastDay: "[Hieraŭ je] LT",
                lastWeek: "[pasinta] dddd [je] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "je %s",
                past: "antaŭ %s",
                s: "sekundoj",
                m: "minuto",
                mm: "%d minutoj",
                h: "horo",
                hh: "%d horoj",
                d: "tago",
                dd: "%d tagoj",
                M: "monato",
                MM: "%d monatoj",
                y: "jaro",
                yy: "%d jaroj"
            },
            ordinalParse: /\d{1,2}a/,
            ordinal: "%da",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : spanish (es)
    //! author : Julio Napurí : https://github.com/julionc
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "Ene._Feb._Mar._Abr._May._Jun._Jul._Ago._Sep._Oct._Nov._Dic.".split("_"), n = "Ene_Feb_Mar_Abr_May_Jun_Jul_Ago_Sep_Oct_Nov_Dic".split("_"), a = e.defineLocale("es", {
            months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "Domingo_Lunes_Martes_Miércoles_Jueves_Viernes_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mié._Jue._Vie._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY H:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoy a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextDay: function() {
                    return "[mañana a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastDay: function() {
                    return "[ayer a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [pasado a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "hace %s",
                s: "unos segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "una hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un año",
                yy: "%d años"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : estonian (et)
    //! author : Henry Kehlmann : https://github.com/madhenry
    //! improvements : Illimar Tambek : https://github.com/ragulka
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = {
                s: [ "mõne sekundi", "mõni sekund", "paar sekundit" ],
                m: [ "ühe minuti", "üks minut" ],
                mm: [ e + " minuti", e + " minutit" ],
                h: [ "ühe tunni", "tund aega", "üks tund" ],
                hh: [ e + " tunni", e + " tundi" ],
                d: [ "ühe päeva", "üks päev" ],
                M: [ "kuu aja", "kuu aega", "üks kuu" ],
                MM: [ e + " kuu", e + " kuud" ],
                y: [ "ühe aasta", "aasta", "üks aasta" ],
                yy: [ e + " aasta", e + " aastat" ]
            };
            return t ? i[n][2] ? i[n][2] : i[n][1] : a ? i[n][0] : i[n][1];
        }
        var n = e.defineLocale("et", {
            months: "jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),
            monthsShort: "jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),
            weekdays: "pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev".split("_"),
            weekdaysShort: "P_E_T_K_N_R_L".split("_"),
            weekdaysMin: "P_E_T_K_N_R_L".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Täna,] LT",
                nextDay: "[Homme,] LT",
                nextWeek: "[Järgmine] dddd LT",
                lastDay: "[Eile,] LT",
                lastWeek: "[Eelmine] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s pärast",
                past: "%s tagasi",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: "%d päeva",
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : euskara (eu)
    //! author : Eneko Illarramendi : https://github.com/eillarra
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eu", {
            months: "urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),
            monthsShort: "urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),
            weekdays: "igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),
            weekdaysShort: "ig._al._ar._az._og._ol._lr.".split("_"),
            weekdaysMin: "ig_al_ar_az_og_ol_lr".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY[ko] MMMM[ren] D[a]",
                LLL: "YYYY[ko] MMMM[ren] D[a] HH:mm",
                LLLL: "dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",
                l: "YYYY-M-D",
                ll: "YYYY[ko] MMM D[a]",
                lll: "YYYY[ko] MMM D[a] HH:mm",
                llll: "ddd, YYYY[ko] MMM D[a] HH:mm"
            },
            calendar: {
                sameDay: "[gaur] LT[etan]",
                nextDay: "[bihar] LT[etan]",
                nextWeek: "dddd LT[etan]",
                lastDay: "[atzo] LT[etan]",
                lastWeek: "[aurreko] dddd LT[etan]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s barru",
                past: "duela %s",
                s: "segundo batzuk",
                m: "minutu bat",
                mm: "%d minutu",
                h: "ordu bat",
                hh: "%d ordu",
                d: "egun bat",
                dd: "%d egun",
                M: "hilabete bat",
                MM: "%d hilabete",
                y: "urte bat",
                yy: "%d urte"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Persian (fa)
    //! author : Ebrahim Byagowi : https://github.com/ebraminio
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "۱",
            "2": "۲",
            "3": "۳",
            "4": "۴",
            "5": "۵",
            "6": "۶",
            "7": "۷",
            "8": "۸",
            "9": "۹",
            "0": "۰"
        }, n = {
            "۱": "1",
            "۲": "2",
            "۳": "3",
            "۴": "4",
            "۵": "5",
            "۶": "6",
            "۷": "7",
            "۸": "8",
            "۹": "9",
            "۰": "0"
        }, a = e.defineLocale("fa", {
            months: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            monthsShort: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            weekdays: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysShort: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysMin: "ی_د_س_چ_پ_ج_ش".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            meridiemParse: /قبل از ظهر|بعد از ظهر/,
            isPM: function(e) {
                return /بعد از ظهر/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "قبل از ظهر" : "بعد از ظهر";
            },
            calendar: {
                sameDay: "[امروز ساعت] LT",
                nextDay: "[فردا ساعت] LT",
                nextWeek: "dddd [ساعت] LT",
                lastDay: "[دیروز ساعت] LT",
                lastWeek: "dddd [پیش] [ساعت] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "در %s",
                past: "%s پیش",
                s: "چندین ثانیه",
                m: "یک دقیقه",
                mm: "%d دقیقه",
                h: "یک ساعت",
                hh: "%d ساعت",
                d: "یک روز",
                dd: "%d روز",
                M: "یک ماه",
                MM: "%d ماه",
                y: "یک سال",
                yy: "%d سال"
            },
            preparse: function(e) {
                return e.replace(/[۰-۹]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            ordinalParse: /\d{1,2}م/,
            ordinal: "%dم",
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : finnish (fi)
    //! author : Tarmo Aidantausta : https://github.com/bleadof
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, a, i) {
            var r = "";
            switch (a) {
              case "s":
                return i ? "muutaman sekunnin" : "muutama sekunti";

              case "m":
                return i ? "minuutin" : "minuutti";

              case "mm":
                r = i ? "minuutin" : "minuuttia";
                break;

              case "h":
                return i ? "tunnin" : "tunti";

              case "hh":
                r = i ? "tunnin" : "tuntia";
                break;

              case "d":
                return i ? "päivän" : "päivä";

              case "dd":
                r = i ? "päivän" : "päivää";
                break;

              case "M":
                return i ? "kuukauden" : "kuukausi";

              case "MM":
                r = i ? "kuukauden" : "kuukautta";
                break;

              case "y":
                return i ? "vuoden" : "vuosi";

              case "yy":
                r = i ? "vuoden" : "vuotta";
            }
            return r = n(e, i) + " " + r;
        }
        function n(e, t) {
            return e < 10 ? t ? i[e] : a[e] : e;
        }
        var a = "nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän".split(" "), i = [ "nolla", "yhden", "kahden", "kolmen", "neljän", "viiden", "kuuden", a[7], a[8], a[9] ], r = e.defineLocale("fi", {
            months: "tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),
            monthsShort: "tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu".split("_"),
            weekdays: "sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),
            weekdaysShort: "su_ma_ti_ke_to_pe_la".split("_"),
            weekdaysMin: "su_ma_ti_ke_to_pe_la".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD.MM.YYYY",
                LL: "Do MMMM[ta] YYYY",
                LLL: "Do MMMM[ta] YYYY, [klo] HH.mm",
                LLLL: "dddd, Do MMMM[ta] YYYY, [klo] HH.mm",
                l: "D.M.YYYY",
                ll: "Do MMM YYYY",
                lll: "Do MMM YYYY, [klo] HH.mm",
                llll: "ddd, Do MMM YYYY, [klo] HH.mm"
            },
            calendar: {
                sameDay: "[tänään] [klo] LT",
                nextDay: "[huomenna] [klo] LT",
                nextWeek: "dddd [klo] LT",
                lastDay: "[eilen] [klo] LT",
                lastWeek: "[viime] dddd[na] [klo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s päästä",
                past: "%s sitten",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : faroese (fo)
    //! author : Ragnar Johannesen : https://github.com/ragnar123
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fo", {
            months: "januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur".split("_"),
            weekdaysShort: "sun_mán_týs_mik_hós_frí_ley".split("_"),
            weekdaysMin: "su_má_tý_mi_hó_fr_le".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D. MMMM, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Í dag kl.] LT",
                nextDay: "[Í morgin kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[Í gjár kl.] LT",
                lastWeek: "[síðstu] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "um %s",
                past: "%s síðani",
                s: "fá sekund",
                m: "ein minutt",
                mm: "%d minuttir",
                h: "ein tími",
                hh: "%d tímar",
                d: "ein dagur",
                dd: "%d dagar",
                M: "ein mánaði",
                MM: "%d mánaðir",
                y: "eitt ár",
                yy: "%d ár"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : french (fr)
    //! author : John Fischer : https://github.com/jfroffice
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian french (fr-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr-ca", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|e)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "e");
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : frisian (fy)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_"), n = "jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"), a = e.defineLocale("fy", {
            months: "jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),
            weekdaysShort: "si._mo._ti._wo._to._fr._so.".split("_"),
            weekdaysMin: "Si_Mo_Ti_Wo_To_Fr_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[hjoed om] LT",
                nextDay: "[moarn om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[juster om] LT",
                lastWeek: "[ôfrûne] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oer %s",
                past: "%s lyn",
                s: "in pear sekonden",
                m: "ien minút",
                mm: "%d minuten",
                h: "ien oere",
                hh: "%d oeren",
                d: "ien dei",
                dd: "%d dagen",
                M: "ien moanne",
                MM: "%d moannen",
                y: "ien jier",
                yy: "%d jierren"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : galician (gl)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("gl", {
            months: "Xaneiro_Febreiro_Marzo_Abril_Maio_Xuño_Xullo_Agosto_Setembro_Outubro_Novembro_Decembro".split("_"),
            monthsShort: "Xan._Feb._Mar._Abr._Mai._Xuñ._Xul._Ago._Set._Out._Nov._Dec.".split("_"),
            weekdays: "Domingo_Luns_Martes_Mércores_Xoves_Venres_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mér._Xov._Ven._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mé_Xo_Ve_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoxe " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextDay: function() {
                    return "[mañá " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [" + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                lastDay: function() {
                    return "[onte " + (1 !== this.hours() ? "á" : "a") + "] LT";
                },
                lastWeek: function() {
                    return "[o] dddd [pasado " + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return "uns segundos" === e ? "nuns segundos" : "en " + e;
                },
                past: "hai %s",
                s: "uns segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "unha hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Hebrew (he)
    //! author : Tomer Cohen : https://github.com/tomer
    //! author : Moshe Simantov : https://github.com/DevelopmentIL
    //! author : Tal Ater : https://github.com/TalAter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("he", {
            months: "ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר".split("_"),
            monthsShort: "ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳".split("_"),
            weekdays: "ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת".split("_"),
            weekdaysShort: "א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳".split("_"),
            weekdaysMin: "א_ב_ג_ד_ה_ו_ש".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [ב]MMMM YYYY",
                LLL: "D [ב]MMMM YYYY HH:mm",
                LLLL: "dddd, D [ב]MMMM YYYY HH:mm",
                l: "D/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[היום ב־]LT",
                nextDay: "[מחר ב־]LT",
                nextWeek: "dddd [בשעה] LT",
                lastDay: "[אתמול ב־]LT",
                lastWeek: "[ביום] dddd [האחרון בשעה] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "בעוד %s",
                past: "לפני %s",
                s: "מספר שניות",
                m: "דקה",
                mm: "%d דקות",
                h: "שעה",
                hh: function(e) {
                    return 2 === e ? "שעתיים" : e + " שעות";
                },
                d: "יום",
                dd: function(e) {
                    return 2 === e ? "יומיים" : e + " ימים";
                },
                M: "חודש",
                MM: function(e) {
                    return 2 === e ? "חודשיים" : e + " חודשים";
                },
                y: "שנה",
                yy: function(e) {
                    return 2 === e ? "שנתיים" : e % 10 === 0 && 10 !== e ? e + " שנה" : e + " שנים";
                }
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hindi (hi)
    //! author : Mayank Singhal : https://github.com/mayanksinghal
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("hi", {
            months: "जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर".split("_"),
            monthsShort: "जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.".split("_"),
            weekdays: "रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm बजे",
                LTS: "A h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, A h:mm बजे"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[कल] LT",
                nextWeek: "dddd, LT",
                lastDay: "[कल] LT",
                lastWeek: "[पिछले] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s में",
                past: "%s पहले",
                s: "कुछ ही क्षण",
                m: "एक मिनट",
                mm: "%d मिनट",
                h: "एक घंटा",
                hh: "%d घंटे",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महीने",
                MM: "%d महीने",
                y: "एक वर्ष",
                yy: "%d वर्ष"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात|सुबह|दोपहर|शाम/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात" === t ? e < 4 ? e : e + 12 : "सुबह" === t ? e : "दोपहर" === t ? e >= 10 ? e : e + 12 : "शाम" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात" : e < 10 ? "सुबह" : e < 17 ? "दोपहर" : e < 20 ? "शाम" : "रात";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hrvatski (hr)
    //! author : Bojan Marković : https://github.com/bmarkovic
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("hr", {
            months: "siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_"),
            monthsShort: "sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hungarian (hu)
    //! author : Adam Brunner : https://github.com/adambrunner
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = e;
            switch (n) {
              case "s":
                return a || t ? "néhány másodperc" : "néhány másodperce";

              case "m":
                return "egy" + (a || t ? " perc" : " perce");

              case "mm":
                return i + (a || t ? " perc" : " perce");

              case "h":
                return "egy" + (a || t ? " óra" : " órája");

              case "hh":
                return i + (a || t ? " óra" : " órája");

              case "d":
                return "egy" + (a || t ? " nap" : " napja");

              case "dd":
                return i + (a || t ? " nap" : " napja");

              case "M":
                return "egy" + (a || t ? " hónap" : " hónapja");

              case "MM":
                return i + (a || t ? " hónap" : " hónapja");

              case "y":
                return "egy" + (a || t ? " év" : " éve");

              case "yy":
                return i + (a || t ? " év" : " éve");
            }
            return "";
        }
        function n(e) {
            return (e ? "" : "[múlt] ") + "[" + a[this.day()] + "] LT[-kor]";
        }
        var a = "vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton".split(" "), i = e.defineLocale("hu", {
            months: "január_február_március_április_május_június_július_augusztus_szeptember_október_november_december".split("_"),
            monthsShort: "jan_feb_márc_ápr_máj_jún_júl_aug_szept_okt_nov_dec".split("_"),
            weekdays: "vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat".split("_"),
            weekdaysShort: "vas_hét_kedd_sze_csüt_pén_szo".split("_"),
            weekdaysMin: "v_h_k_sze_cs_p_szo".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "YYYY.MM.DD.",
                LL: "YYYY. MMMM D.",
                LLL: "YYYY. MMMM D. H:mm",
                LLLL: "YYYY. MMMM D., dddd H:mm"
            },
            meridiemParse: /de|du/i,
            isPM: function(e) {
                return "u" === e.charAt(1).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n === !0 ? "de" : "DE" : n === !0 ? "du" : "DU";
            },
            calendar: {
                sameDay: "[ma] LT[-kor]",
                nextDay: "[holnap] LT[-kor]",
                nextWeek: function() {
                    return n.call(this, !0);
                },
                lastDay: "[tegnap] LT[-kor]",
                lastWeek: function() {
                    return n.call(this, !1);
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s múlva",
                past: "%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Armenian (hy-am)
    //! author : Armendarabyan : https://github.com/armendarabyan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր".split("_"),
                accusative: "հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = "հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ".split("_");
            return n[e.month()];
        }
        function a(e, t) {
            var n = "կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ".split("_");
            return n[e.day()];
        }
        var i = e.defineLocale("hy-am", {
            months: t,
            monthsShort: n,
            weekdays: a,
            weekdaysShort: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            weekdaysMin: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY թ.",
                LLL: "D MMMM YYYY թ., HH:mm",
                LLLL: "dddd, D MMMM YYYY թ., HH:mm"
            },
            calendar: {
                sameDay: "[այսօր] LT",
                nextDay: "[վաղը] LT",
                lastDay: "[երեկ] LT",
                nextWeek: function() {
                    return "dddd [օրը ժամը] LT";
                },
                lastWeek: function() {
                    return "[անցած] dddd [օրը ժամը] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s հետո",
                past: "%s առաջ",
                s: "մի քանի վայրկյան",
                m: "րոպե",
                mm: "%d րոպե",
                h: "ժամ",
                hh: "%d ժամ",
                d: "օր",
                dd: "%d օր",
                M: "ամիս",
                MM: "%d ամիս",
                y: "տարի",
                yy: "%d տարի"
            },
            meridiemParse: /գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,
            isPM: function(e) {
                return /^(ցերեկվա|երեկոյան)$/.test(e);
            },
            meridiem: function(e) {
                return e < 4 ? "գիշերվա" : e < 12 ? "առավոտվա" : e < 17 ? "ցերեկվա" : "երեկոյան";
            },
            ordinalParse: /\d{1,2}|\d{1,2}-(ին|րդ)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "DDD":
                  case "w":
                  case "W":
                  case "DDDo":
                    return 1 === e ? e + "-ին" : e + "-րդ";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Indonesia (id)
    //! author : Mohammad Satrio Utomo : https://github.com/tyok
    //! reference: http://id.wikisource.org/wiki/Pedoman_Umum_Ejaan_Bahasa_Indonesia_yang_Disempurnakan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("id", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|siang|sore|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "siang" === t ? e >= 11 ? e : e + 12 : "sore" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "siang" : e < 19 ? "sore" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Besok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kemarin pukul] LT",
                lastWeek: "dddd [lalu pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lalu",
                s: "beberapa detik",
                m: "semenit",
                mm: "%d menit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : icelandic (is)
    //! author : Hinrik Örn Sigurðsson : https://github.com/hinrik
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 100 === 11 || e % 10 !== 1;
        }
        function n(e, n, a, i) {
            var r = e + " ";
            switch (a) {
              case "s":
                return n || i ? "nokkrar sekúndur" : "nokkrum sekúndum";

              case "m":
                return n ? "mínúta" : "mínútu";

              case "mm":
                return t(e) ? r + (n || i ? "mínútur" : "mínútum") : n ? r + "mínúta" : r + "mínútu";

              case "hh":
                return t(e) ? r + (n || i ? "klukkustundir" : "klukkustundum") : r + "klukkustund";

              case "d":
                return n ? "dagur" : i ? "dag" : "degi";

              case "dd":
                return t(e) ? n ? r + "dagar" : r + (i ? "daga" : "dögum") : n ? r + "dagur" : r + (i ? "dag" : "degi");

              case "M":
                return n ? "mánuður" : i ? "mánuð" : "mánuði";

              case "MM":
                return t(e) ? n ? r + "mánuðir" : r + (i ? "mánuði" : "mánuðum") : n ? r + "mánuður" : r + (i ? "mánuð" : "mánuði");

              case "y":
                return n || i ? "ár" : "ári";

              case "yy":
                return t(e) ? r + (n || i ? "ár" : "árum") : r + (n || i ? "ár" : "ári");
            }
        }
        var a = e.defineLocale("is", {
            months: "janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des".split("_"),
            weekdays: "sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur".split("_"),
            weekdaysShort: "sun_mán_þri_mið_fim_fös_lau".split("_"),
            weekdaysMin: "Su_Má_Þr_Mi_Fi_Fö_La".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H:mm",
                LLLL: "dddd, D. MMMM YYYY [kl.] H:mm"
            },
            calendar: {
                sameDay: "[í dag kl.] LT",
                nextDay: "[á morgun kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[í gær kl.] LT",
                lastWeek: "[síðasta] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "eftir %s",
                past: "fyrir %s síðan",
                s: n,
                m: n,
                mm: n,
                h: "klukkustund",
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : italian (it)
    //! author : Lorenzo : https://github.com/aliem
    //! author: Mattia Larentis: https://github.com/nostalgiaz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("it", {
            months: "gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),
            monthsShort: "gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),
            weekdays: "Domenica_Lunedì_Martedì_Mercoledì_Giovedì_Venerdì_Sabato".split("_"),
            weekdaysShort: "Dom_Lun_Mar_Mer_Gio_Ven_Sab".split("_"),
            weekdaysMin: "D_L_Ma_Me_G_V_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Oggi alle] LT",
                nextDay: "[Domani alle] LT",
                nextWeek: "dddd [alle] LT",
                lastDay: "[Ieri alle] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[la scorsa] dddd [alle] LT";

                      default:
                        return "[lo scorso] dddd [alle] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return (/^[0-9].+$/.test(e) ? "tra" : "in") + " " + e;
                },
                past: "%s fa",
                s: "alcuni secondi",
                m: "un minuto",
                mm: "%d minuti",
                h: "un'ora",
                hh: "%d ore",
                d: "un giorno",
                dd: "%d giorni",
                M: "un mese",
                MM: "%d mesi",
                y: "un anno",
                yy: "%d anni"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : japanese (ja)
    //! author : LI Long : https://github.com/baryon
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ja", {
            months: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),
            weekdaysShort: "日_月_火_水_木_金_土".split("_"),
            weekdaysMin: "日_月_火_水_木_金_土".split("_"),
            longDateFormat: {
                LT: "Ah時m分",
                LTS: "Ah時m分s秒",
                L: "YYYY/MM/DD",
                LL: "YYYY年M月D日",
                LLL: "YYYY年M月D日Ah時m分",
                LLLL: "YYYY年M月D日Ah時m分 dddd"
            },
            meridiemParse: /午前|午後/i,
            isPM: function(e) {
                return "午後" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "午前" : "午後";
            },
            calendar: {
                sameDay: "[今日] LT",
                nextDay: "[明日] LT",
                nextWeek: "[来週]dddd LT",
                lastDay: "[昨日] LT",
                lastWeek: "[前週]dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s後",
                past: "%s前",
                s: "数秒",
                m: "1分",
                mm: "%d分",
                h: "1時間",
                hh: "%d時間",
                d: "1日",
                dd: "%d日",
                M: "1ヶ月",
                MM: "%dヶ月",
                y: "1年",
                yy: "%d年"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Boso Jowo (jv)
    //! author : Rony Lantip : https://github.com/lantip
    //! reference: http://jv.wikipedia.org/wiki/Basa_Jawa
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("jv", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),
            weekdays: "Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /enjing|siyang|sonten|ndalu/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "enjing" === t ? e : "siyang" === t ? e >= 11 ? e : e + 12 : "sonten" === t || "ndalu" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "enjing" : e < 15 ? "siyang" : e < 19 ? "sonten" : "ndalu";
            },
            calendar: {
                sameDay: "[Dinten puniko pukul] LT",
                nextDay: "[Mbenjang pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kala wingi pukul] LT",
                lastWeek: "dddd [kepengker pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "wonten ing %s",
                past: "%s ingkang kepengker",
                s: "sawetawis detik",
                m: "setunggal menit",
                mm: "%d menit",
                h: "setunggal jam",
                hh: "%d jam",
                d: "sedinten",
                dd: "%d dinten",
                M: "sewulan",
                MM: "%d wulan",
                y: "setaun",
                yy: "%d taun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Georgian (ka)
    //! author : Irakli Janiashvili : https://github.com/irakli-janiashvili
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი".split("_"),
                accusative: "იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს".split("_")
            }, a = /D[oD] *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = {
                nominative: "კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი".split("_"),
                accusative: "კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს".split("_")
            }, a = /(წინა|შემდეგ)/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var a = e.defineLocale("ka", {
            months: t,
            monthsShort: "იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),
            weekdays: n,
            weekdaysShort: "კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),
            weekdaysMin: "კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[დღეს] LT[-ზე]",
                nextDay: "[ხვალ] LT[-ზე]",
                lastDay: "[გუშინ] LT[-ზე]",
                nextWeek: "[შემდეგ] dddd LT[-ზე]",
                lastWeek: "[წინა] dddd LT-ზე",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return /(წამი|წუთი|საათი|წელი)/.test(e) ? e.replace(/ი$/, "ში") : e + "ში";
                },
                past: function(e) {
                    return /(წამი|წუთი|საათი|დღე|თვე)/.test(e) ? e.replace(/(ი|ე)$/, "ის წინ") : /წელი/.test(e) ? e.replace(/წელი$/, "წლის წინ") : void 0;
                },
                s: "რამდენიმე წამი",
                m: "წუთი",
                mm: "%d წუთი",
                h: "საათი",
                hh: "%d საათი",
                d: "დღე",
                dd: "%d დღე",
                M: "თვე",
                MM: "%d თვე",
                y: "წელი",
                yy: "%d წელი"
            },
            ordinalParse: /0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,
            ordinal: function(e) {
                return 0 === e ? e : 1 === e ? e + "-ლი" : e < 20 || e <= 100 && e % 20 === 0 || e % 100 === 0 ? "მე-" + e : e + "-ე";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : khmer (km)
    //! author : Kruy Vanna : https://github.com/kruyvanna
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("km", {
            months: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            monthsShort: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            weekdays: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysShort: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysMin: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ថ្ងៃនៈ ម៉ោង] LT",
                nextDay: "[ស្អែក ម៉ោង] LT",
                nextWeek: "dddd [ម៉ោង] LT",
                lastDay: "[ម្សិលមិញ ម៉ោង] LT",
                lastWeek: "dddd [សប្តាហ៍មុន] [ម៉ោង] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sទៀត",
                past: "%sមុន",
                s: "ប៉ុន្មានវិនាទី",
                m: "មួយនាទី",
                mm: "%d នាទី",
                h: "មួយម៉ោង",
                hh: "%d ម៉ោង",
                d: "មួយថ្ងៃ",
                dd: "%d ថ្ងៃ",
                M: "មួយខែ",
                MM: "%d ខែ",
                y: "មួយឆ្នាំ",
                yy: "%d ឆ្នាំ"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : korean (ko)
    //!
    //! authors
    //!
    //! - Kyungwook, Park : https://github.com/kyungw00k
    //! - Jeeeyul Lee <jeeeyul@gmail.com>
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ko", {
            months: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            monthsShort: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            weekdays: "일요일_월요일_화요일_수요일_목요일_금요일_토요일".split("_"),
            weekdaysShort: "일_월_화_수_목_금_토".split("_"),
            weekdaysMin: "일_월_화_수_목_금_토".split("_"),
            longDateFormat: {
                LT: "A h시 m분",
                LTS: "A h시 m분 s초",
                L: "YYYY.MM.DD",
                LL: "YYYY년 MMMM D일",
                LLL: "YYYY년 MMMM D일 A h시 m분",
                LLLL: "YYYY년 MMMM D일 dddd A h시 m분"
            },
            calendar: {
                sameDay: "오늘 LT",
                nextDay: "내일 LT",
                nextWeek: "dddd LT",
                lastDay: "어제 LT",
                lastWeek: "지난주 dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s 후",
                past: "%s 전",
                s: "몇초",
                ss: "%d초",
                m: "일분",
                mm: "%d분",
                h: "한시간",
                hh: "%d시간",
                d: "하루",
                dd: "%d일",
                M: "한달",
                MM: "%d달",
                y: "일년",
                yy: "%d년"
            },
            ordinalParse: /\d{1,2}일/,
            ordinal: "%d일",
            meridiemParse: /오전|오후/,
            isPM: function(e) {
                return "오후" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "오전" : "오후";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Luxembourgish (lb)
    //! author : mweimerskirch : https://github.com/mweimerskirch, David Raison : https://github.com/kwisatz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = {
                m: [ "eng Minutt", "enger Minutt" ],
                h: [ "eng Stonn", "enger Stonn" ],
                d: [ "een Dag", "engem Dag" ],
                M: [ "ee Mount", "engem Mount" ],
                y: [ "ee Joer", "engem Joer" ]
            };
            return t ? i[n][0] : i[n][1];
        }
        function n(e) {
            var t = e.substr(0, e.indexOf(" "));
            return i(t) ? "a " + e : "an " + e;
        }
        function a(e) {
            var t = e.substr(0, e.indexOf(" "));
            return i(t) ? "viru " + e : "virun " + e;
        }
        function i(e) {
            if (e = parseInt(e, 10), isNaN(e)) return !1;
            if (e < 0) return !0;
            if (e < 10) return 4 <= e && e <= 7;
            if (e < 100) {
                var t = e % 10, n = e / 10;
                return i(0 === t ? n : t);
            }
            if (e < 1e4) {
                for (;e >= 10; ) e /= 10;
                return i(e);
            }
            return e /= 1e3, i(e);
        }
        var r = e.defineLocale("lb", {
            months: "Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),
            weekdaysShort: "So._Mé._Dë._Më._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mé_Dë_Më_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "H:mm [Auer]",
                LTS: "H:mm:ss [Auer]",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm [Auer]",
                LLLL: "dddd, D. MMMM YYYY H:mm [Auer]"
            },
            calendar: {
                sameDay: "[Haut um] LT",
                sameElse: "L",
                nextDay: "[Muer um] LT",
                nextWeek: "dddd [um] LT",
                lastDay: "[Gëschter um] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 2:
                      case 4:
                        return "[Leschten] dddd [um] LT";

                      default:
                        return "[Leschte] dddd [um] LT";
                    }
                }
            },
            relativeTime: {
                future: n,
                past: a,
                s: "e puer Sekonnen",
                m: t,
                mm: "%d Minutten",
                h: t,
                hh: "%d Stonnen",
                d: t,
                dd: "%d Deeg",
                M: t,
                MM: "%d Méint",
                y: t,
                yy: "%d Joer"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Lithuanian (lt)
    //! author : Mindaugas Mozūras : https://github.com/mmozuras
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            return t ? "kelios sekundės" : a ? "kelių sekundžių" : "kelias sekundes";
        }
        function n(e, t) {
            var n = {
                nominative: "sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis".split("_"),
                accusative: "sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function a(e, t, n, a) {
            return t ? r(n)[0] : a ? r(n)[1] : r(n)[2];
        }
        function i(e) {
            return e % 10 === 0 || e > 10 && e < 20;
        }
        function r(e) {
            return u[e].split("_");
        }
        function s(e, t, n, s) {
            var o = e + " ";
            return 1 === e ? o + a(e, t, n[0], s) : t ? o + (i(e) ? r(n)[1] : r(n)[0]) : s ? o + r(n)[1] : o + (i(e) ? r(n)[1] : r(n)[2]);
        }
        function o(e, t) {
            var n = t.indexOf("dddd HH:mm") === -1, a = l[e.day()];
            return n ? a : a.substring(0, a.length - 2) + "į";
        }
        var u = {
            m: "minutė_minutės_minutę",
            mm: "minutės_minučių_minutes",
            h: "valanda_valandos_valandą",
            hh: "valandos_valandų_valandas",
            d: "diena_dienos_dieną",
            dd: "dienos_dienų_dienas",
            M: "mėnuo_mėnesio_mėnesį",
            MM: "mėnesiai_mėnesių_mėnesius",
            y: "metai_metų_metus",
            yy: "metai_metų_metus"
        }, l = "sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis".split("_"), c = e.defineLocale("lt", {
            months: n,
            monthsShort: "sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),
            weekdays: o,
            weekdaysShort: "Sek_Pir_Ant_Tre_Ket_Pen_Šeš".split("_"),
            weekdaysMin: "S_P_A_T_K_Pn_Š".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY [m.] MMMM D [d.]",
                LLL: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                LLLL: "YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",
                l: "YYYY-MM-DD",
                ll: "YYYY [m.] MMMM D [d.]",
                lll: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                llll: "YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"
            },
            calendar: {
                sameDay: "[Šiandien] LT",
                nextDay: "[Rytoj] LT",
                nextWeek: "dddd LT",
                lastDay: "[Vakar] LT",
                lastWeek: "[Praėjusį] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "po %s",
                past: "prieš %s",
                s: t,
                m: a,
                mm: s,
                h: a,
                hh: s,
                d: a,
                dd: s,
                M: a,
                MM: s,
                y: a,
                yy: s
            },
            ordinalParse: /\d{1,2}-oji/,
            ordinal: function(e) {
                return e + "-oji";
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return c;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : latvian (lv)
    //! author : Kristaps Karlsons : https://github.com/skakri
    //! author : Jānis Elmeris : https://github.com/JanisE
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            return n ? t % 10 === 1 && 11 !== t ? e[2] : e[3] : t % 10 === 1 && 11 !== t ? e[0] : e[1];
        }
        function n(e, n, a) {
            return e + " " + t(r[a], e, n);
        }
        function a(e, n, a) {
            return t(r[a], e, n);
        }
        function i(e, t) {
            return t ? "dažas sekundes" : "dažām sekundēm";
        }
        var r = {
            m: "minūtes_minūtēm_minūte_minūtes".split("_"),
            mm: "minūtes_minūtēm_minūte_minūtes".split("_"),
            h: "stundas_stundām_stunda_stundas".split("_"),
            hh: "stundas_stundām_stunda_stundas".split("_"),
            d: "dienas_dienām_diena_dienas".split("_"),
            dd: "dienas_dienām_diena_dienas".split("_"),
            M: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            MM: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            y: "gada_gadiem_gads_gadi".split("_"),
            yy: "gada_gadiem_gads_gadi".split("_")
        }, s = e.defineLocale("lv", {
            months: "janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec".split("_"),
            weekdays: "svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena".split("_"),
            weekdaysShort: "Sv_P_O_T_C_Pk_S".split("_"),
            weekdaysMin: "Sv_P_O_T_C_Pk_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY.",
                LL: "YYYY. [gada] D. MMMM",
                LLL: "YYYY. [gada] D. MMMM, HH:mm",
                LLLL: "YYYY. [gada] D. MMMM, dddd, HH:mm"
            },
            calendar: {
                sameDay: "[Šodien pulksten] LT",
                nextDay: "[Rīt pulksten] LT",
                nextWeek: "dddd [pulksten] LT",
                lastDay: "[Vakar pulksten] LT",
                lastWeek: "[Pagājušā] dddd [pulksten] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "pēc %s",
                past: "pirms %s",
                s: i,
                m: a,
                mm: n,
                h: a,
                hh: n,
                d: a,
                dd: n,
                M: a,
                MM: n,
                y: a,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Montenegrin (me)
    //! author : Miodrag Nikač <miodrag@restartit.me> : https://github.com/miodragnikac
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jednog minuta" ],
                mm: [ "minut", "minuta", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mjesec", "mjeseca", "mjeseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var i = t.words[a];
                return 1 === a.length ? n ? i[0] : i[1] : e + " " + t.correctGrammaticalCase(e, i);
            }
        }, n = e.defineLocale("me", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sri.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sjutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedjelje] [u] LT", "[prošlog] [ponedjeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srijede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mjesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : macedonian (mk)
    //! author : Borislav Mickov : https://github.com/B0k0
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("mk", {
            months: "јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "недела_понеделник_вторник_среда_четврток_петок_сабота".split("_"),
            weekdaysShort: "нед_пон_вто_сре_чет_пет_саб".split("_"),
            weekdaysMin: "нe_пo_вт_ср_че_пе_сa".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Денес во] LT",
                nextDay: "[Утре во] LT",
                nextWeek: "dddd [во] LT",
                lastDay: "[Вчера во] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[Во изминатата] dddd [во] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[Во изминатиот] dddd [во] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "после %s",
                past: "пред %s",
                s: "неколку секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дена",
                M: "месец",
                MM: "%d месеци",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : malayalam (ml)
    //! author : Floyd Pink : https://github.com/floydpink
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ml", {
            months: "ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ".split("_"),
            monthsShort: "ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.".split("_"),
            weekdays: "ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച".split("_"),
            weekdaysShort: "ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി".split("_"),
            weekdaysMin: "ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ".split("_"),
            longDateFormat: {
                LT: "A h:mm -നു",
                LTS: "A h:mm:ss -നു",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm -നു",
                LLLL: "dddd, D MMMM YYYY, A h:mm -നു"
            },
            calendar: {
                sameDay: "[ഇന്ന്] LT",
                nextDay: "[നാളെ] LT",
                nextWeek: "dddd, LT",
                lastDay: "[ഇന്നലെ] LT",
                lastWeek: "[കഴിഞ്ഞ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s കഴിഞ്ഞ്",
                past: "%s മുൻപ്",
                s: "അൽപ നിമിഷങ്ങൾ",
                m: "ഒരു മിനിറ്റ്",
                mm: "%d മിനിറ്റ്",
                h: "ഒരു മണിക്കൂർ",
                hh: "%d മണിക്കൂർ",
                d: "ഒരു ദിവസം",
                dd: "%d ദിവസം",
                M: "ഒരു മാസം",
                MM: "%d മാസം",
                y: "ഒരു വർഷം",
                yy: "%d വർഷം"
            },
            meridiemParse: /രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,
            isPM: function(e) {
                return /^(ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "രാത്രി" : e < 12 ? "രാവിലെ" : e < 17 ? "ഉച്ച കഴിഞ്ഞ്" : e < 20 ? "വൈകുന്നേരം" : "രാത്രി";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Marathi (mr)
    //! author : Harshad Kale : https://github.com/kalehv
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("mr", {
            months: "जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),
            monthsShort: "जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),
            weekdays: "रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm वाजता",
                LTS: "A h:mm:ss वाजता",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm वाजता",
                LLLL: "dddd, D MMMM YYYY, A h:mm वाजता"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[उद्या] LT",
                nextWeek: "dddd, LT",
                lastDay: "[काल] LT",
                lastWeek: "[मागील] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s नंतर",
                past: "%s पूर्वी",
                s: "सेकंद",
                m: "एक मिनिट",
                mm: "%d मिनिटे",
                h: "एक तास",
                hh: "%d तास",
                d: "एक दिवस",
                dd: "%d दिवस",
                M: "एक महिना",
                MM: "%d महिने",
                y: "एक वर्ष",
                yy: "%d वर्षे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात्री|सकाळी|दुपारी|सायंकाळी/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात्री" === t ? e < 4 ? e : e + 12 : "सकाळी" === t ? e : "दुपारी" === t ? e >= 10 ? e : e + 12 : "सायंकाळी" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात्री" : e < 10 ? "सकाळी" : e < 17 ? "दुपारी" : e < 20 ? "सायंकाळी" : "रात्री";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms-my", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Burmese (my)
    //! author : Squar team, mysquar.com
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "၁",
            "2": "၂",
            "3": "၃",
            "4": "၄",
            "5": "၅",
            "6": "၆",
            "7": "၇",
            "8": "၈",
            "9": "၉",
            "0": "၀"
        }, n = {
            "၁": "1",
            "၂": "2",
            "၃": "3",
            "၄": "4",
            "၅": "5",
            "၆": "6",
            "၇": "7",
            "၈": "8",
            "၉": "9",
            "၀": "0"
        }, a = e.defineLocale("my", {
            months: "ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ".split("_"),
            monthsShort: "ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ".split("_"),
            weekdays: "တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ".split("_"),
            weekdaysShort: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            weekdaysMin: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ယနေ.] LT [မှာ]",
                nextDay: "[မနက်ဖြန်] LT [မှာ]",
                nextWeek: "dddd LT [မှာ]",
                lastDay: "[မနေ.က] LT [မှာ]",
                lastWeek: "[ပြီးခဲ့သော] dddd LT [မှာ]",
                sameElse: "L"
            },
            relativeTime: {
                future: "လာမည့် %s မှာ",
                past: "လွန်ခဲ့သော %s က",
                s: "စက္ကန်.အနည်းငယ်",
                m: "တစ်မိနစ်",
                mm: "%d မိနစ်",
                h: "တစ်နာရီ",
                hh: "%d နာရီ",
                d: "တစ်ရက်",
                dd: "%d ရက်",
                M: "တစ်လ",
                MM: "%d လ",
                y: "တစ်နှစ်",
                yy: "%d နှစ်"
            },
            preparse: function(e) {
                return e.replace(/[၁၂၃၄၅၆၇၈၉၀]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian bokmål (nb)
    //! authors : Espen Hovlandsdal : https://github.com/rexxars
    //!           Sigurd Gartmann : https://github.com/sigurdga
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nb", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tirs_ons_tors_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "H.mm",
                LTS: "H.mm.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H.mm",
                LLLL: "dddd D. MMMM YYYY [kl.] H.mm"
            },
            calendar: {
                sameDay: "[i dag kl.] LT",
                nextDay: "[i morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[i går kl.] LT",
                lastWeek: "[forrige] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s siden",
                s: "noen sekunder",
                m: "ett minutt",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dager",
                M: "en måned",
                MM: "%d måneder",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : nepali/nepalese
    //! author : suvash : https://github.com/suvash
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("ne", {
            months: "जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर".split("_"),
            monthsShort: "जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.".split("_"),
            weekdays: "आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार".split("_"),
            weekdaysShort: "आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.".split("_"),
            weekdaysMin: "आइ._सो._मङ्_बु._बि._शु._श.".split("_"),
            longDateFormat: {
                LT: "Aको h:mm बजे",
                LTS: "Aको h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, Aको h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, Aको h:mm बजे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /राती|बिहान|दिउँसो|बेलुका|साँझ|राती/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "राती" === t ? e < 3 ? e : e + 12 : "बिहान" === t ? e : "दिउँसो" === t ? e >= 10 ? e : e + 12 : "बेलुका" === t || "साँझ" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 3 ? "राती" : e < 10 ? "बिहान" : e < 15 ? "दिउँसो" : e < 18 ? "बेलुका" : e < 20 ? "साँझ" : "राती";
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[भोली] LT",
                nextWeek: "[आउँदो] dddd[,] LT",
                lastDay: "[हिजो] LT",
                lastWeek: "[गएको] dddd[,] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sमा",
                past: "%s अगाडी",
                s: "केही समय",
                m: "एक मिनेट",
                mm: "%d मिनेट",
                h: "एक घण्टा",
                hh: "%d घण्टा",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महिना",
                MM: "%d महिना",
                y: "एक बर्ष",
                yy: "%d बर्ष"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : dutch (nl)
    //! author : Joris Röling : https://github.com/jjupiter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"), n = "jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"), a = e.defineLocale("nl", {
            months: "januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),
            weekdaysShort: "zo._ma._di._wo._do._vr._za.".split("_"),
            weekdaysMin: "Zo_Ma_Di_Wo_Do_Vr_Za".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[vandaag om] LT",
                nextDay: "[morgen om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[gisteren om] LT",
                lastWeek: "[afgelopen] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "over %s",
                past: "%s geleden",
                s: "een paar seconden",
                m: "één minuut",
                mm: "%d minuten",
                h: "één uur",
                hh: "%d uur",
                d: "één dag",
                dd: "%d dagen",
                M: "één maand",
                MM: "%d maanden",
                y: "één jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian nynorsk (nn)
    //! author : https://github.com/mechuwind
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nn", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),
            weekdaysShort: "sun_mån_tys_ons_tor_fre_lau".split("_"),
            weekdaysMin: "su_må_ty_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag klokka] LT",
                nextDay: "[I morgon klokka] LT",
                nextWeek: "dddd [klokka] LT",
                lastDay: "[I går klokka] LT",
                lastWeek: "[Føregåande] dddd [klokka] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s sidan",
                s: "nokre sekund",
                m: "eit minutt",
                mm: "%d minutt",
                h: "ein time",
                hh: "%d timar",
                d: "ein dag",
                dd: "%d dagar",
                M: "ein månad",
                MM: "%d månader",
                y: "eit år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : polish (pl)
    //! author : Rafal Hirsz : https://github.com/evoL
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 10 < 5 && e % 10 > 1 && ~~(e / 10) % 10 !== 1;
        }
        function n(e, n, a) {
            var i = e + " ";
            switch (a) {
              case "m":
                return n ? "minuta" : "minutę";

              case "mm":
                return i + (t(e) ? "minuty" : "minut");

              case "h":
                return n ? "godzina" : "godzinę";

              case "hh":
                return i + (t(e) ? "godziny" : "godzin");

              case "MM":
                return i + (t(e) ? "miesiące" : "miesięcy");

              case "yy":
                return i + (t(e) ? "lata" : "lat");
            }
        }
        var a = "styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"), i = "stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"), r = e.defineLocale("pl", {
            months: function(e, t) {
                return "" === t ? "(" + i[e.month()] + "|" + a[e.month()] + ")" : /D MMMM/.test(t) ? i[e.month()] : a[e.month()];
            },
            monthsShort: "sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),
            weekdays: "niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),
            weekdaysShort: "nie_pon_wt_śr_czw_pt_sb".split("_"),
            weekdaysMin: "N_Pn_Wt_Śr_Cz_Pt_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Dziś o] LT",
                nextDay: "[Jutro o] LT",
                nextWeek: "[W] dddd [o] LT",
                lastDay: "[Wczoraj o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[W zeszłą niedzielę o] LT";

                      case 3:
                        return "[W zeszłą środę o] LT";

                      case 6:
                        return "[W zeszłą sobotę o] LT";

                      default:
                        return "[W zeszły] dddd [o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "%s temu",
                s: "kilka sekund",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "1 dzień",
                dd: "%d dni",
                M: "miesiąc",
                MM: n,
                y: "rok",
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : portuguese (pt)
    //! author : Jefferson : https://github.com/jalex79
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "há %s",
                s: "segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : brazilian portuguese (pt-br)
    //! author : Caio Ribeiro Pereira : https://github.com/caio-ribeiro-pereira
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt-br", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY [às] HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY [às] HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "%s atrás",
                s: "poucos segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº"
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : romanian (ro)
    //! author : Vlad Gurdiga : https://github.com/gurdiga
    //! author : Valentin Agachi : https://github.com/avaly
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "minute",
                hh: "ore",
                dd: "zile",
                MM: "luni",
                yy: "ani"
            }, i = " ";
            return (e % 100 >= 20 || e >= 100 && e % 100 === 0) && (i = " de "), e + i + a[n];
        }
        var n = e.defineLocale("ro", {
            months: "ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),
            monthsShort: "ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),
            weekdays: "duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),
            weekdaysShort: "Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),
            weekdaysMin: "Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[azi la] LT",
                nextDay: "[mâine la] LT",
                nextWeek: "dddd [la] LT",
                lastDay: "[ieri la] LT",
                lastWeek: "[fosta] dddd [la] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "peste %s",
                past: "%s în urmă",
                s: "câteva secunde",
                m: "un minut",
                mm: t,
                h: "o oră",
                hh: t,
                d: "o zi",
                dd: t,
                M: "o lună",
                MM: t,
                y: "un an",
                yy: t
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : russian (ru)
    //! author : Viktorminator : https://github.com/Viktorminator
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var i = {
                mm: n ? "минута_минуты_минут" : "минуту_минуты_минут",
                hh: "час_часа_часов",
                dd: "день_дня_дней",
                MM: "месяц_месяца_месяцев",
                yy: "год_года_лет"
            };
            return "m" === a ? n ? "минута" : "минуту" : e + " " + t(i[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
                accusative: "января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function i(e, t) {
            var n = {
                nominative: "янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек".split("_"),
                accusative: "янв_фев_мар_апр_мая_июня_июля_авг_сен_окт_ноя_дек".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),
                accusative: "воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_")
            }, a = /\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var s = e.defineLocale("ru", {
            months: a,
            monthsShort: i,
            weekdays: r,
            weekdaysShort: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            monthsParse: [ /^янв/i, /^фев/i, /^мар/i, /^апр/i, /^ма[й|я]/i, /^июн/i, /^июл/i, /^авг/i, /^сен/i, /^окт/i, /^ноя/i, /^дек/i ],
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сегодня в] LT",
                nextDay: "[Завтра в] LT",
                lastDay: "[Вчера в] LT",
                nextWeek: function() {
                    return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                },
                lastWeek: function(e) {
                    if (e.week() === this.week()) return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                    switch (this.day()) {
                      case 0:
                        return "[В прошлое] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[В прошлый] dddd [в] LT";

                      case 3:
                      case 5:
                      case 6:
                        return "[В прошлую] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "через %s",
                past: "%s назад",
                s: "несколько секунд",
                m: n,
                mm: n,
                h: "час",
                hh: n,
                d: "день",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночи|утра|дня|вечера/i,
            isPM: function(e) {
                return /^(дня|вечера)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночи" : e < 12 ? "утра" : e < 17 ? "дня" : "вечера";
            },
            ordinalParse: /\d{1,2}-(й|го|я)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  case "w":
                  case "W":
                    return e + "-я";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Sinhalese (si)
    //! author : Sampath Sitinamaluwa : https://github.com/sampathsris
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("si", {
            months: "ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්".split("_"),
            monthsShort: "ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ".split("_"),
            weekdays: "ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා".split("_"),
            weekdaysShort: "ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන".split("_"),
            weekdaysMin: "ඉ_ස_අ_බ_බ්‍ර_සි_සෙ".split("_"),
            longDateFormat: {
                LT: "a h:mm",
                LTS: "a h:mm:ss",
                L: "YYYY/MM/DD",
                LL: "YYYY MMMM D",
                LLL: "YYYY MMMM D, a h:mm",
                LLLL: "YYYY MMMM D [වැනි] dddd, a h:mm:ss"
            },
            calendar: {
                sameDay: "[අද] LT[ට]",
                nextDay: "[හෙට] LT[ට]",
                nextWeek: "dddd LT[ට]",
                lastDay: "[ඊයේ] LT[ට]",
                lastWeek: "[පසුගිය] dddd LT[ට]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sකින්",
                past: "%sකට පෙර",
                s: "තත්පර කිහිපය",
                m: "මිනිත්තුව",
                mm: "මිනිත්තු %d",
                h: "පැය",
                hh: "පැය %d",
                d: "දිනය",
                dd: "දින %d",
                M: "මාසය",
                MM: "මාස %d",
                y: "වසර",
                yy: "වසර %d"
            },
            ordinalParse: /\d{1,2} වැනි/,
            ordinal: function(e) {
                return e + " වැනි";
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "ප.ව." : "පස් වරු" : n ? "පෙ.ව." : "පෙර වරු";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovak (sk)
    //! author : Martin Minka : https://github.com/k2s
    //! based on work of petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5;
        }
        function n(e, n, a, i) {
            var r = e + " ";
            switch (a) {
              case "s":
                return n || i ? "pár sekúnd" : "pár sekundami";

              case "m":
                return n ? "minúta" : i ? "minútu" : "minútou";

              case "mm":
                return n || i ? r + (t(e) ? "minúty" : "minút") : r + "minútami";

              case "h":
                return n ? "hodina" : i ? "hodinu" : "hodinou";

              case "hh":
                return n || i ? r + (t(e) ? "hodiny" : "hodín") : r + "hodinami";

              case "d":
                return n || i ? "deň" : "dňom";

              case "dd":
                return n || i ? r + (t(e) ? "dni" : "dní") : r + "dňami";

              case "M":
                return n || i ? "mesiac" : "mesiacom";

              case "MM":
                return n || i ? r + (t(e) ? "mesiace" : "mesiacov") : r + "mesiacmi";

              case "y":
                return n || i ? "rok" : "rokom";

              case "yy":
                return n || i ? r + (t(e) ? "roky" : "rokov") : r + "rokmi";
            }
        }
        var a = "január_február_marec_apríl_máj_jún_júl_august_september_október_november_december".split("_"), i = "jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec".split("_"), r = e.defineLocale("sk", {
            months: a,
            monthsShort: i,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, i),
            weekdays: "nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota".split("_"),
            weekdaysShort: "ne_po_ut_st_št_pi_so".split("_"),
            weekdaysMin: "ne_po_ut_st_št_pi_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes o] LT",
                nextDay: "[zajtra o] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [o] LT";

                      case 3:
                        return "[v stredu o] LT";

                      case 4:
                        return "[vo štvrtok o] LT";

                      case 5:
                        return "[v piatok o] LT";

                      case 6:
                        return "[v sobotu o] LT";
                    }
                },
                lastDay: "[včera o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulú nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[minulý] dddd [o] LT";

                      case 3:
                        return "[minulú stredu o] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [o] LT";

                      case 6:
                        return "[minulú sobotu o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pred %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovenian (sl)
    //! author : Robert Sedovšek : https://github.com/sedovsek
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = e + " ";
            switch (n) {
              case "s":
                return t || a ? "nekaj sekund" : "nekaj sekundami";

              case "m":
                return t ? "ena minuta" : "eno minuto";

              case "mm":
                return i += 1 === e ? t ? "minuta" : "minuto" : 2 === e ? t || a ? "minuti" : "minutama" : e < 5 ? t || a ? "minute" : "minutami" : t || a ? "minut" : "minutami";

              case "h":
                return t ? "ena ura" : "eno uro";

              case "hh":
                return i += 1 === e ? t ? "ura" : "uro" : 2 === e ? t || a ? "uri" : "urama" : e < 5 ? t || a ? "ure" : "urami" : t || a ? "ur" : "urami";

              case "d":
                return t || a ? "en dan" : "enim dnem";

              case "dd":
                return i += 1 === e ? t || a ? "dan" : "dnem" : 2 === e ? t || a ? "dni" : "dnevoma" : t || a ? "dni" : "dnevi";

              case "M":
                return t || a ? "en mesec" : "enim mesecem";

              case "MM":
                return i += 1 === e ? t || a ? "mesec" : "mesecem" : 2 === e ? t || a ? "meseca" : "mesecema" : e < 5 ? t || a ? "mesece" : "meseci" : t || a ? "mesecev" : "meseci";

              case "y":
                return t || a ? "eno leto" : "enim letom";

              case "yy":
                return i += 1 === e ? t || a ? "leto" : "letom" : 2 === e ? t || a ? "leti" : "letoma" : e < 5 ? t || a ? "leta" : "leti" : t || a ? "let" : "leti";
            }
        }
        var n = e.defineLocale("sl", {
            months: "januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),
            weekdays: "nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota".split("_"),
            weekdaysShort: "ned._pon._tor._sre._čet._pet._sob.".split("_"),
            weekdaysMin: "ne_po_to_sr_če_pe_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danes ob] LT",
                nextDay: "[jutri ob] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v] [nedeljo] [ob] LT";

                      case 3:
                        return "[v] [sredo] [ob] LT";

                      case 6:
                        return "[v] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[v] dddd [ob] LT";
                    }
                },
                lastDay: "[včeraj ob] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[prejšnjo] [nedeljo] [ob] LT";

                      case 3:
                        return "[prejšnjo] [sredo] [ob] LT";

                      case 6:
                        return "[prejšnjo] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prejšnji] dddd [ob] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "čez %s",
                past: "pred %s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Albanian (sq)
    //! author : Flakërim Ismani : https://github.com/flakerimi
    //! author: Menelion Elensúle: https://github.com/Oire (tests)
    //! author : Oerd Cukalla : https://github.com/oerd (fixes)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sq", {
            months: "Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor".split("_"),
            monthsShort: "Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj".split("_"),
            weekdays: "E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë".split("_"),
            weekdaysShort: "Die_Hën_Mar_Mër_Enj_Pre_Sht".split("_"),
            weekdaysMin: "D_H_Ma_Më_E_P_Sh".split("_"),
            meridiemParse: /PD|MD/,
            isPM: function(e) {
                return "M" === e.charAt(0);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "PD" : "MD";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Sot në] LT",
                nextDay: "[Nesër në] LT",
                nextWeek: "dddd [në] LT",
                lastDay: "[Dje në] LT",
                lastWeek: "dddd [e kaluar në] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "në %s",
                past: "%s më parë",
                s: "disa sekonda",
                m: "një minutë",
                mm: "%d minuta",
                h: "një orë",
                hh: "%d orë",
                d: "një ditë",
                dd: "%d ditë",
                M: "një muaj",
                MM: "%d muaj",
                y: "një vit",
                yy: "%d vite"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-latin (sr)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jedne minute" ],
                mm: [ "minut", "minute", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mesec", "meseca", "meseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var i = t.words[a];
                return 1 === a.length ? n ? i[0] : i[1] : e + " " + t.correctGrammaticalCase(e, i);
            }
        }, n = e.defineLocale("sr", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedelja", "ponedeljak", "utorak", "sreda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sre.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedelju] [u] LT";

                      case 3:
                        return "[u] [sredu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedelje] [u] LT", "[prošlog] [ponedeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pre %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-cyrillic (sr-cyrl)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "један минут", "једне минуте" ],
                mm: [ "минут", "минуте", "минута" ],
                h: [ "један сат", "једног сата" ],
                hh: [ "сат", "сата", "сати" ],
                dd: [ "дан", "дана", "дана" ],
                MM: [ "месец", "месеца", "месеци" ],
                yy: [ "година", "године", "година" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var i = t.words[a];
                return 1 === a.length ? n ? i[0] : i[1] : e + " " + t.correctGrammaticalCase(e, i);
            }
        }, n = e.defineLocale("sr-cyrl", {
            months: [ "јануар", "фебруар", "март", "април", "мај", "јун", "јул", "август", "септембар", "октобар", "новембар", "децембар" ],
            monthsShort: [ "јан.", "феб.", "мар.", "апр.", "мај", "јун", "јул", "авг.", "сеп.", "окт.", "нов.", "дец." ],
            weekdays: [ "недеља", "понедељак", "уторак", "среда", "четвртак", "петак", "субота" ],
            weekdaysShort: [ "нед.", "пон.", "уто.", "сре.", "чет.", "пет.", "суб." ],
            weekdaysMin: [ "не", "по", "ут", "ср", "че", "пе", "су" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[данас у] LT",
                nextDay: "[сутра у] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[у] [недељу] [у] LT";

                      case 3:
                        return "[у] [среду] [у] LT";

                      case 6:
                        return "[у] [суботу] [у] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[у] dddd [у] LT";
                    }
                },
                lastDay: "[јуче у] LT",
                lastWeek: function() {
                    var e = [ "[прошле] [недеље] [у] LT", "[прошлог] [понедељка] [у] LT", "[прошлог] [уторка] [у] LT", "[прошле] [среде] [у] LT", "[прошлог] [четвртка] [у] LT", "[прошлог] [петка] [у] LT", "[прошле] [суботе] [у] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "пре %s",
                s: "неколико секунди",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "дан",
                dd: t.translate,
                M: "месец",
                MM: t.translate,
                y: "годину",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : swedish (sv)
    //! author : Jens Alm : https://github.com/ulmus
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sv", {
            months: "januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag".split("_"),
            weekdaysShort: "sön_mån_tis_ons_tor_fre_lör".split("_"),
            weekdaysMin: "sö_må_ti_on_to_fr_lö".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Idag] LT",
                nextDay: "[Imorgon] LT",
                lastDay: "[Igår] LT",
                nextWeek: "[På] dddd LT",
                lastWeek: "[I] dddd[s] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "för %s sedan",
                s: "några sekunder",
                m: "en minut",
                mm: "%d minuter",
                h: "en timme",
                hh: "%d timmar",
                d: "en dag",
                dd: "%d dagar",
                M: "en månad",
                MM: "%d månader",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}(e|a)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "e" : 1 === t ? "a" : 2 === t ? "a" : "e";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tamil (ta)
    //! author : Arjunkumar Krishnamoorthy : https://github.com/tk120404
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ta", {
            months: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            monthsShort: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            weekdays: "ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை".split("_"),
            weekdaysShort: "ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி".split("_"),
            weekdaysMin: "ஞா_தி_செ_பு_வி_வெ_ச".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, HH:mm",
                LLLL: "dddd, D MMMM YYYY, HH:mm"
            },
            calendar: {
                sameDay: "[இன்று] LT",
                nextDay: "[நாளை] LT",
                nextWeek: "dddd, LT",
                lastDay: "[நேற்று] LT",
                lastWeek: "[கடந்த வாரம்] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s இல்",
                past: "%s முன்",
                s: "ஒரு சில விநாடிகள்",
                m: "ஒரு நிமிடம்",
                mm: "%d நிமிடங்கள்",
                h: "ஒரு மணி நேரம்",
                hh: "%d மணி நேரம்",
                d: "ஒரு நாள்",
                dd: "%d நாட்கள்",
                M: "ஒரு மாதம்",
                MM: "%d மாதங்கள்",
                y: "ஒரு வருடம்",
                yy: "%d ஆண்டுகள்"
            },
            ordinalParse: /\d{1,2}வது/,
            ordinal: function(e) {
                return e + "வது";
            },
            meridiemParse: /யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,
            meridiem: function(e, t, n) {
                return e < 2 ? " யாமம்" : e < 6 ? " வைகறை" : e < 10 ? " காலை" : e < 14 ? " நண்பகல்" : e < 18 ? " எற்பாடு" : e < 22 ? " மாலை" : " யாமம்";
            },
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "யாமம்" === t ? e < 2 ? e : e + 12 : "வைகறை" === t || "காலை" === t ? e : "நண்பகல்" === t && e >= 10 ? e : e + 12;
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : thai (th)
    //! author : Kridsada Thanabulpong : https://github.com/sirn
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("th", {
            months: "มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม".split("_"),
            monthsShort: "มกรา_กุมภา_มีนา_เมษา_พฤษภา_มิถุนา_กรกฎา_สิงหา_กันยา_ตุลา_พฤศจิกา_ธันวา".split("_"),
            weekdays: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์".split("_"),
            weekdaysShort: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์".split("_"),
            weekdaysMin: "อา._จ._อ._พ._พฤ._ศ._ส.".split("_"),
            longDateFormat: {
                LT: "H นาฬิกา m นาที",
                LTS: "H นาฬิกา m นาที s วินาที",
                L: "YYYY/MM/DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY เวลา H นาฬิกา m นาที",
                LLLL: "วันddddที่ D MMMM YYYY เวลา H นาฬิกา m นาที"
            },
            meridiemParse: /ก่อนเที่ยง|หลังเที่ยง/,
            isPM: function(e) {
                return "หลังเที่ยง" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ก่อนเที่ยง" : "หลังเที่ยง";
            },
            calendar: {
                sameDay: "[วันนี้ เวลา] LT",
                nextDay: "[พรุ่งนี้ เวลา] LT",
                nextWeek: "dddd[หน้า เวลา] LT",
                lastDay: "[เมื่อวานนี้ เวลา] LT",
                lastWeek: "[วัน]dddd[ที่แล้ว เวลา] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "อีก %s",
                past: "%sที่แล้ว",
                s: "ไม่กี่วินาที",
                m: "1 นาที",
                mm: "%d นาที",
                h: "1 ชั่วโมง",
                hh: "%d ชั่วโมง",
                d: "1 วัน",
                dd: "%d วัน",
                M: "1 เดือน",
                MM: "%d เดือน",
                y: "1 ปี",
                yy: "%d ปี"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Tagalog/Filipino (tl-ph)
    //! author : Dan Hagman
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tl-ph", {
            months: "Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),
            monthsShort: "Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),
            weekdays: "Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),
            weekdaysShort: "Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),
            weekdaysMin: "Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "MM/D/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY HH:mm",
                LLLL: "dddd, MMMM DD, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Ngayon sa] LT",
                nextDay: "[Bukas sa] LT",
                nextWeek: "dddd [sa] LT",
                lastDay: "[Kahapon sa] LT",
                lastWeek: "dddd [huling linggo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "sa loob ng %s",
                past: "%s ang nakalipas",
                s: "ilang segundo",
                m: "isang minuto",
                mm: "%d minuto",
                h: "isang oras",
                hh: "%d oras",
                d: "isang araw",
                dd: "%d araw",
                M: "isang buwan",
                MM: "%d buwan",
                y: "isang taon",
                yy: "%d taon"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : turkish (tr)
    //! authors : Erhan Gundogan : https://github.com/erhangundogan,
    //!           Burak Yiğit Kaya: https://github.com/BYK
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "'inci",
            5: "'inci",
            8: "'inci",
            70: "'inci",
            80: "'inci",
            2: "'nci",
            7: "'nci",
            20: "'nci",
            50: "'nci",
            3: "'üncü",
            4: "'üncü",
            100: "'üncü",
            6: "'ncı",
            9: "'uncu",
            10: "'uncu",
            30: "'uncu",
            60: "'ıncı",
            90: "'ıncı"
        }, n = e.defineLocale("tr", {
            months: "Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık".split("_"),
            monthsShort: "Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara".split("_"),
            weekdays: "Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi".split("_"),
            weekdaysShort: "Paz_Pts_Sal_Çar_Per_Cum_Cts".split("_"),
            weekdaysMin: "Pz_Pt_Sa_Ça_Pe_Cu_Ct".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[yarın saat] LT",
                nextWeek: "[haftaya] dddd [saat] LT",
                lastDay: "[dün] LT",
                lastWeek: "[geçen hafta] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s önce",
                s: "birkaç saniye",
                m: "bir dakika",
                mm: "%d dakika",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir yıl",
                yy: "%d yıl"
            },
            ordinalParse: /\d{1,2}'(inci|nci|üncü|ncı|uncu|ıncı)/,
            ordinal: function(e) {
                if (0 === e) return e + "'ıncı";
                var n = e % 10, a = e % 100 - n, i = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[i]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : talossan (tzl)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v with the help of Iustì Canun
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var i = {
                s: [ "viensas secunds", "'iensas secunds" ],
                m: [ "'n míut", "'iens míut" ],
                mm: [ e + " míuts", " " + e + " míuts" ],
                h: [ "'n þora", "'iensa þora" ],
                hh: [ e + " þoras", " " + e + " þoras" ],
                d: [ "'n ziua", "'iensa ziua" ],
                dd: [ e + " ziuas", " " + e + " ziuas" ],
                M: [ "'n mes", "'iens mes" ],
                MM: [ e + " mesen", " " + e + " mesen" ],
                y: [ "'n ar", "'iens ar" ],
                yy: [ e + " ars", " " + e + " ars" ]
            };
            return a ? i[n][0] : t ? i[n][0] : i[n][1].trim();
        }
        var n = e.defineLocale("tzl", {
            months: "Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar".split("_"),
            monthsShort: "Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec".split("_"),
            weekdays: "Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi".split("_"),
            weekdaysShort: "Súl_Lún_Mai_Már_Xhú_Vié_Sát".split("_"),
            weekdaysMin: "Sú_Lú_Ma_Má_Xh_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "LT.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM [dallas] YYYY",
                LLL: "D. MMMM [dallas] YYYY LT",
                LLLL: "dddd, [li] D. MMMM [dallas] YYYY LT"
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "d'o" : "D'O" : n ? "d'a" : "D'A";
            },
            calendar: {
                sameDay: "[oxhi à] LT",
                nextDay: "[demà à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[ieiri à] LT",
                lastWeek: "[sür el] dddd [lasteu à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "osprei %s",
                past: "ja%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt (tzm)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm", {
            months: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            monthsShort: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            weekdays: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysShort: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysMin: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ⴰⵙⴷⵅ ⴴ] LT",
                nextDay: "[ⴰⵙⴽⴰ ⴴ] LT",
                nextWeek: "dddd [ⴴ] LT",
                lastDay: "[ⴰⵚⴰⵏⵜ ⴴ] LT",
                lastWeek: "dddd [ⴴ] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s",
                past: "ⵢⴰⵏ %s",
                s: "ⵉⵎⵉⴽ",
                m: "ⵎⵉⵏⵓⴺ",
                mm: "%d ⵎⵉⵏⵓⴺ",
                h: "ⵙⴰⵄⴰ",
                hh: "%d ⵜⴰⵙⵙⴰⵄⵉⵏ",
                d: "ⴰⵙⵙ",
                dd: "%d oⵙⵙⴰⵏ",
                M: "ⴰⵢoⵓⵔ",
                MM: "%d ⵉⵢⵢⵉⵔⵏ",
                y: "ⴰⵙⴳⴰⵙ",
                yy: "%d ⵉⵙⴳⴰⵙⵏ"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt in Latin (tzm-latn)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm-latn", {
            months: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            monthsShort: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            weekdays: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysShort: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysMin: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[asdkh g] LT",
                nextDay: "[aska g] LT",
                nextWeek: "dddd [g] LT",
                lastDay: "[assant g] LT",
                lastWeek: "dddd [g] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dadkh s yan %s",
                past: "yan %s",
                s: "imik",
                m: "minuḍ",
                mm: "%d minuḍ",
                h: "saɛa",
                hh: "%d tassaɛin",
                d: "ass",
                dd: "%d ossan",
                M: "ayowr",
                MM: "%d iyyirn",
                y: "asgas",
                yy: "%d isgasn"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : ukrainian (uk)
    //! author : zemlanin : https://github.com/zemlanin
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var i = {
                mm: "хвилина_хвилини_хвилин",
                hh: "година_години_годин",
                dd: "день_дні_днів",
                MM: "місяць_місяці_місяців",
                yy: "рік_роки_років"
            };
            return "m" === a ? n ? "хвилина" : "хвилину" : "h" === a ? n ? "година" : "годину" : e + " " + t(i[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_"),
                accusative: "січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_")
            }, a = /D[oD]? *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function i(e, t) {
            var n = {
                nominative: "неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),
                accusative: "неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),
                genitive: "неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")
            }, a = /(\[[ВвУу]\]) ?dddd/.test(t) ? "accusative" : /\[?(?:минулої|наступної)? ?\] ?dddd/.test(t) ? "genitive" : "nominative";
            return n[a][e.day()];
        }
        function r(e) {
            return function() {
                return e + "о" + (11 === this.hours() ? "б" : "") + "] LT";
            };
        }
        var s = e.defineLocale("uk", {
            months: a,
            monthsShort: "січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),
            weekdays: i,
            weekdaysShort: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY р.",
                LLL: "D MMMM YYYY р., HH:mm",
                LLLL: "dddd, D MMMM YYYY р., HH:mm"
            },
            calendar: {
                sameDay: r("[Сьогодні "),
                nextDay: r("[Завтра "),
                lastDay: r("[Вчора "),
                nextWeek: r("[У] dddd ["),
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return r("[Минулої] dddd [").call(this);

                      case 1:
                      case 2:
                      case 4:
                        return r("[Минулого] dddd [").call(this);
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "%s тому",
                s: "декілька секунд",
                m: n,
                mm: n,
                h: "годину",
                hh: n,
                d: "день",
                dd: n,
                M: "місяць",
                MM: n,
                y: "рік",
                yy: n
            },
            meridiemParse: /ночі|ранку|дня|вечора/,
            isPM: function(e) {
                return /^(дня|вечора)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночі" : e < 12 ? "ранку" : e < 17 ? "дня" : "вечора";
            },
            ordinalParse: /\d{1,2}-(й|го)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : uzbek (uz)
    //! author : Sardor Muminov : https://github.com/muminoff
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("uz", {
            months: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
            monthsShort: "янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),
            weekdays: "Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба".split("_"),
            weekdaysShort: "Якш_Душ_Сеш_Чор_Пай_Жум_Шан".split("_"),
            weekdaysMin: "Як_Ду_Се_Чо_Па_Жу_Ша".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "D MMMM YYYY, dddd HH:mm"
            },
            calendar: {
                sameDay: "[Бугун соат] LT [да]",
                nextDay: "[Эртага] LT [да]",
                nextWeek: "dddd [куни соат] LT [да]",
                lastDay: "[Кеча соат] LT [да]",
                lastWeek: "[Утган] dddd [куни соат] LT [да]",
                sameElse: "L"
            },
            relativeTime: {
                future: "Якин %s ичида",
                past: "Бир неча %s олдин",
                s: "фурсат",
                m: "бир дакика",
                mm: "%d дакика",
                h: "бир соат",
                hh: "%d соат",
                d: "бир кун",
                dd: "%d кун",
                M: "бир ой",
                MM: "%d ой",
                y: "бир йил",
                yy: "%d йил"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : vietnamese (vi)
    //! author : Bang Nguyen : https://github.com/bangnk
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("vi", {
            months: "tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12".split("_"),
            monthsShort: "Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12".split("_"),
            weekdays: "chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy".split("_"),
            weekdaysShort: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            weekdaysMin: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM [năm] YYYY",
                LLL: "D MMMM [năm] YYYY HH:mm",
                LLLL: "dddd, D MMMM [năm] YYYY HH:mm",
                l: "DD/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hôm nay lúc] LT",
                nextDay: "[Ngày mai lúc] LT",
                nextWeek: "dddd [tuần tới lúc] LT",
                lastDay: "[Hôm qua lúc] LT",
                lastWeek: "dddd [tuần rồi lúc] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s tới",
                past: "%s trước",
                s: "vài giây",
                m: "một phút",
                mm: "%d phút",
                h: "một giờ",
                hh: "%d giờ",
                d: "một ngày",
                dd: "%d ngày",
                M: "một tháng",
                MM: "%d tháng",
                y: "một năm",
                yy: "%d năm"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chinese (zh-cn)
    //! author : suupic : https://github.com/suupic
    //! author : Zeno Zeng : https://github.com/zenozeng
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-cn", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "周日_周一_周二_周三_周四_周五_周六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah点mm分",
                LTS: "Ah点m分s秒",
                L: "YYYY-MM-DD",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah点mm分",
                LLLL: "YYYY年MMMD日ddddAh点mm分",
                l: "YYYY-MM-DD",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah点mm分",
                llll: "YYYY年MMMD日ddddAh点mm分"
            },
            meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "凌晨" === t || "早上" === t || "上午" === t ? e : "下午" === t || "晚上" === t ? e + 12 : e >= 11 ? e : e + 12;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 600 ? "凌晨" : a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: function() {
                    return 0 === this.minutes() ? "[今天]Ah[点整]" : "[今天]LT";
                },
                nextDay: function() {
                    return 0 === this.minutes() ? "[明天]Ah[点整]" : "[明天]LT";
                },
                lastDay: function() {
                    return 0 === this.minutes() ? "[昨天]Ah[点整]" : "[昨天]LT";
                },
                nextWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() - t.unix() >= 604800 ? "[下]" : "[本]", 
                    0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                lastWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() < t.unix() ? "[上]" : "[本]", 0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                sameElse: "LL"
            },
            ordinalParse: /\d{1,2}(日|月|周)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "周";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s内",
                past: "%s前",
                s: "几秒",
                m: "1 分钟",
                mm: "%d 分钟",
                h: "1 小时",
                hh: "%d 小时",
                d: "1 天",
                dd: "%d 天",
                M: "1 个月",
                MM: "%d 个月",
                y: "1 年",
                yy: "%d 年"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : traditional chinese (zh-tw)
    //! author : Ben : https://github.com/ben-lin
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-tw", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "週日_週一_週二_週三_週四_週五_週六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah點mm分",
                LTS: "Ah點m分s秒",
                L: "YYYY年MMMD日",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah點mm分",
                LLLL: "YYYY年MMMD日ddddAh點mm分",
                l: "YYYY年MMMD日",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah點mm分",
                llll: "YYYY年MMMD日ddddAh點mm分"
            },
            meridiemParse: /早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "早上" === t || "上午" === t ? e : "中午" === t ? e >= 11 ? e : e + 12 : "下午" === t || "晚上" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: "[今天]LT",
                nextDay: "[明天]LT",
                nextWeek: "[下]ddddLT",
                lastDay: "[昨天]LT",
                lastWeek: "[上]ddddLT",
                sameElse: "L"
            },
            ordinalParse: /\d{1,2}(日|月|週)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "週";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s內",
                past: "%s前",
                s: "幾秒",
                m: "一分鐘",
                mm: "%d分鐘",
                h: "一小時",
                hh: "%d小時",
                d: "一天",
                dd: "%d天",
                M: "一個月",
                MM: "%d個月",
                y: "一年",
                yy: "%d年"
            }
        });
        return t;
    });
}, , , , , , , , , , , , , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <h3> <i class="pficon pficon-image"></i>\n<span ng-if="labels.name">{{ labels.name }}</span>\n<span ng-if="!labels.name">{{ names[0] }}</span> </h3> <a ng-href="#/images/{{ stream.metadata.namespace }}/{{ stream.metadata.name }}" translate class="hidden-xs">Show all images</a> </div> <div class="listing-ct-inline"> <h3 translate>Image</h3> <div class="listing-ct-body"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <h3 translate>Container</h3> <div class="listing-ct-body"> <registry-image-config image="image"> </registry-image-config> </div> <h3 translate>Metadata</h3> <div class="listing-ct-body"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-page.html", i);
    } ]), e.exports = i;
}, , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<filter-bar class="content-filter"> </filter-bar> <div image-listing> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/images-page.html", i);
    } ]), e.exports = i;
}, , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <h3> <i class="fa fa-folder"></i>\n{{ stream.metadata.namespace }}/{{ stream.metadata.name}} </h3> <a ng-href="#{{ viewUrl(\'images\') }}" translate>Show all image streams</a> </div> <div class="listing-ct-inline"> <h3 translate>Image Stream</h3> <div class="listing-ct-body"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push settings="settings" imagestream="stream" ng-show="showDockerPushCommands"> </registry-imagestream-push> </div> <h3 translate>Images</h3> <div image-listing> </div> <h3 translate ng-if="stream.metadata.annotations">Metadata</h3> <div class="listing-ct-body" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-page.html", i);
    } ]), e.exports = i;
}, , , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    "use strict";
    !function() {
        var e = n(32);
        n(39), e.module("registry.policy", [ "kubeClient" ]).factory("projectPolicy", [ "$q", "$rootScope", "kubeLoader", "kubeMethods", function(t, n, a, i) {
            function r(t, n) {
                e.forEach(t || [], function(e) {
                    a.handle(e.roleBinding, n, "RoleBinding");
                });
            }
            function s(t) {
                e.forEach(t, function(e) {
                    var t = a.resolve(e.kind, e.name, e.namespace);
                    if (!(t in a.objects)) {
                        var n = {
                            kind: e.kind,
                            apiVersion: "v1",
                            metadata: {
                                name: e.name
                            }
                        };
                        e.namespace && (n.metadata.namespace = e.namespace), a.handle(n);
                    }
                });
            }
            function o(e, t, a, i) {
                var r = t + ":" + a;
                e in $ || ($[e] = {}), $[e][r] = i, i && e in k && delete k[e][r], n.$applyAsync();
            }
            function u(t) {
                t ? (k[t] = e.extend({}, $[t]), delete $[t]) : (k = $, $ = {}), n.$applyAsync();
            }
            function l(e, t, n) {
                var r = t + ":" + n, s = !0, u = null, l = $[e];
                if (l && r in l && (u = l[r], s = !1), u || (l = k[e], l && r in l && (u = l[r])), 
                !s) return u;
                var c = {
                    kind: "LocalResourceAccessReview",
                    apiVersion: "v1",
                    namespace: "",
                    verb: t,
                    resource: n,
                    resourceName: "",
                    content: null
                };
                o(e, t, n, null);
                var d = a.resolve("localresourceaccessreviews", null, e);
                return i.post(d, c).then(function(a) {
                    o(e, t, n, a);
                }, function(a) {
                    console.warn("failed to lookup access:", e, t, n + ":", a.message || JSON.stringify(a));
                }), u;
            }
            function c(e, n, r, s) {
                var o = e + ":" + (n ? n.metadata.name : "") + ":" + r + ":" + s, u = t.defer();
                if (o in w) u.resolve(w[o]); else {
                    var l = {
                        kind: "SubjectAccessReview",
                        apiVersion: "v1",
                        namespace: e,
                        verb: r,
                        resource: s
                    };
                    i.post(a.resolve("subjectaccessreviews"), l).then(function(e) {
                        w[o] = e.allowed, u.resolve(e.allowed);
                    }, function(e) {
                        console.warn("failed to review subject access:", e.message || JSON.stringify(e)), 
                        u.reject(e.message || JSON.stringify(e));
                    });
                }
                return u.promise;
            }
            function d(e) {
                if (e) for (var t in w) 0 === t.lastIndexOf(e + ":", 0) && delete w[t]; else w = {};
                n.$applyAsync();
            }
            function f(e, t, n) {
                var r = a.resolve("RoleBinding", t, e);
                return a.load(r).then(function(e) {
                    return n(e), i.put(r, e);
                });
            }
            function m(e, t, n) {
                var a = M(t), r = {
                    kind: "RoleBinding",
                    apiVersion: "v1",
                    metadata: {
                        name: a,
                        namespace: e,
                        creationTimestamp: null
                    },
                    userNames: [],
                    groupNames: [],
                    subjects: [],
                    roleRef: {
                        name: t
                    }
                };
                return _(b(r, "subjects"), n), _(y(r, n.kind), n.name), i.create(r, e);
            }
            function p(e, n, a) {
                var i = M(e);
                return f(i, n, function(e) {
                    v(b(e, "subjects"), a), v(y(e, a.kind), a.name);
                }).then(function() {
                    u(i);
                }, function(e) {
                    if (404 !== e.code) return t.reject(e);
                });
            }
            function h(n, a, i, r) {
                var s, o = [ "registry-admin", "registry-editor", "registry-viewer" ], u = t.when(), l = [];
                return n && n.one() && (s = n.one(), l = s.roleBindings), e.forEach(i, function(t) {
                    e.forEach(l, function(e) {
                        g(o, e.name) !== -1 && e.name === t.metadata.name && (u = u.then(function() {
                            return p(a, e.name, r);
                        }));
                    });
                }), u;
            }
            function g(t, n) {
                var a, i;
                for (a = 0, i = t.length; a < i; a++) if (e.equals(t[a], n)) return a;
                return -1;
            }
            function _(e, t) {
                var n = g(e, t);
                n < 0 && e.push(t);
            }
            function v(e, t) {
                var n = g(e, t);
                n >= 0 && e.splice(n, 1);
            }
            function b(e, t) {
                var n = e[t] || [];
                return e[t] = n, n;
            }
            function y(e, t) {
                return "Group" == t || "SystemGroup" == t ? b(e, "groupNames") : b(e, "userNames");
            }
            function M(e) {
                return "object" == typeof e ? e.metadata.name : e;
            }
            a.listen(function(e, t) {
                var n, a = {};
                for (n in t) "PolicyBinding" == t[n].kind && (r(t[n].roleBindings, !0), a[t[n].metadata.namespace] = !0);
                for (n in e) "PolicyBinding" == e[n].kind ? (r(e[n].roleBindings, !1), a[e[n].metadata.namespace] = !0) : "RoleBinding" == e[n].kind && (s(e[n].subjects || []), 
                a[e[n].metadata.namespace] = !0);
                var i;
                for (i in a) u(i), d(i);
            });
            var $ = {}, k = {}, w = {};
            return {
                watch: function(e) {
                    a.watch("policybindings", e).then(function() {
                        u(null);
                    });
                },
                whoCan: function(e, t, n) {
                    return l(M(e), t, n);
                },
                addToRole: function(e, n, a) {
                    var i = M(e);
                    return f(i, n, function(e) {
                        _(b(e, "subjects"), a), _(y(e, a.kind), a.name);
                    }).then(function() {
                        u(i);
                    }, function(e) {
                        return 404 === e.code ? m(i, n, a) : t.reject(e);
                    });
                },
                removeFromRole: p,
                removeMemberFromPolicyBinding: h,
                subjectAccessReview: c
            };
        } ]);
    }();
}, , , , , , , , , , , , , , , , , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t, n) {
            var a, i, r, s, o, u = (e.status || {}).tags || [];
            for (s = 0, o = u.length; s < o; s++) for (r = u[s].items || [], a = 0, i = r.length; a < i; a++) t.call(n || null, u[s], r[a]);
        }
        var t = n(32);
        n(33), n(43), n(39), n(61), n(44), n(236), n(216), n(237), n(188), n(191), n(174), 
        n(45), n(238), n(239), n(240), n(240), n(241), t.module("registry.images", [ "ngRoute", "ui.cockpit", "kubeClient", "kubernetes.date", "kubernetes.listing", "registry.tags", "registryUI.images" ]).config([ "$routeProvider", function(e) {
            e.when("/images/:namespace?", {
                templateUrl: "views/images-page.html",
                controller: "ImagesCtrl"
            }).when("/images/:namespace/:target", {
                controller: "ImageCtrl",
                templateUrl: function(e) {
                    var t = e.target || "";
                    return t.indexOf(":") === -1 ? "views/imagestream-page.html" : "views/image-page.html";
                }
            });
        } ]).controller("ImagesCtrl", [ "$scope", "$location", "imageData", "imageActions", "ListingState", "projectData", "filterService", function(e, n, a, i, r, s) {
            e.imagestreams = a.allStreams, e.sharedImages = s.sharedImages, t.extend(e, a), 
            e.listing = new r(e), a.watchImages(), e.$on("activate", function(e, t) {
                e.preventDefault(), n.path("/images/" + t);
            }), t.extend(e, i);
        } ]).controller("ImageCtrl", [ "$scope", "$location", "$routeParams", "kubeSelect", "kubeLoader", "KubeDiscoverSettings", "imageData", "imageActions", "ListingState", "projectData", "projectPolicy", function(n, a, i, r, s, o, u, l, c, d, f) {
            function m() {
                o().then(function(e) {
                    f.subjectAccessReview(v, e.currentUser, "update", "imagestreamimages").then(function(e) {
                        e != n.showDockerPushCommands && (n.showDockerPushCommands = e, n.$applyAsync());
                    });
                });
            }
            var p, h, g = i.target || "", _ = g.indexOf(":"), v = i.namespace || "";
            _ === -1 ? (n.kind = "ImageStream", p = g, h = null) : (n.kind = "Image", p = g.substr(0, _), 
            h = g.substr(_ + 1)), u.watchImages(n), s.listen(function() {
                n.stream = r().kind("ImageStream").namespace(v).name(p).one(), n.image = n.config = n.layers = n.labels = n.tag = null, 
                e(n.stream || {}, function(e, t) {
                    e.tag === h && (n.tag = e);
                }), n.tag && (n.image = r().kind("Image").taggedFirst(n.tag).one()), n.image && (n.names = u.imageTagNames(n.image), 
                n.config = u.imageConfig(n.image), n.layers = u.imageLayers(n.image), n.labels = u.imageLabels(n.image));
            }, n), n.listing = new c(n), n.listing.inline = !0, n.imagestreams = function() {
                return n.stream ? {
                    "/": n.stream
                } : {};
            }, t.extend(n, u), t.extend(n, l), n.sharedImages = d.sharedImages, n.deleteImageStream = function(e) {
                var t = l.deleteImageStream(e);
                return t.then(function() {
                    a.path(n.viewUrl("images"));
                }), t;
            }, n.$on("activate", function(e, t) {
                e.preventDefault(), a.path("/images/" + t);
            }), n.deleteTag = function(e, t) {
                var n = l.deleteTag(e, t);
                return n.then(function() {
                    var t = [ "images", e.metadata.namespace, e.metadata.name ];
                    a.path("/" + t.map(encodeURIComponent).join("/"));
                }), n;
            }, n.$on("$routeUpdate", m), m();
        } ]).directive("imagePanel", [ "kubeLoader", "imageData", function(e, t) {
            return {
                restrict: "A",
                scope: !0,
                link: function(n, a, i) {
                    var r = "main";
                    n.tab = function(e, t) {
                        return t && (r = e, t.stopPropagation()), r === e;
                    }, e.listen(function() {
                        n.names = n.config = n.layers = n.labels = null, n.image && (n.names = t.imageTagNames(n.image), 
                        n.config = t.imageConfig(n.image), n.layers = t.imageLayers(n.image), n.labels = t.imageLabels(n.image));
                    }, n);
                },
                templateUrl: "views/image-panel.html"
            };
        } ]).directive("imageListing", function() {
            return {
                restrict: "A",
                templateUrl: "views/image-listing.html"
            };
        }).factory("imageData", [ "kubeSelect", "kubeLoader", function(n, a) {
            function i(e) {
                var n = e.metadata || {}, i = e.status || {};
                t.forEach(i.tags || [], function(e) {
                    t.forEach(e.items || [], function(e) {
                        var t = a.resolve("Image", e.image);
                        if (!(t in a.objects)) {
                            var i = {
                                kind: "Image",
                                apiVersion: "v1",
                                metadata: {
                                    name: e.image
                                }
                            };
                            if (a.handle(i), l) {
                                var s = n.name + "@" + e.image;
                                a.load("ImageStreamImage", s, n.namespace).then(function(e) {
                                    var t = e.image;
                                    t && (t.kind = "Image", a.handle(t), r(t));
                                }, function(e) {
                                    var t = e.statusText || e.message || String(e);
                                    console.warn("couldn't load image: " + t), i.metadata.resourceVersion = "invalid";
                                });
                            }
                        }
                    });
                });
            }
            function r(e) {
                var n, i = e.dockerImageManifest;
                i && (i = JSON.parse(i), t.forEach(i.history || [], function(e) {
                    "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                }), n = {
                    kind: "DockerImageManifest",
                    metadata: {
                        name: e.metadata.name,
                        selfLink: "/internal/manifests/" + e.metadata.name
                    },
                    manifest: i
                }, a.handle(n));
            }
            function s(e) {
                l = !0;
                var t = a.watch("images", e), n = a.watch("imagestreams", e);
                return {
                    cancel: function() {
                        t.cancel(), n.cancel();
                    }
                };
            }
            function o(e) {
                if (!e) return null;
                var t = n().kind("DockerImageManifest").name(e.metadata.name).one();
                return t && t.manifest && 1 === t.manifest.schemaVersion ? t.manifest.history : e.dockerImageLayers ? e.dockerImageLayers : null;
            }
            function u(e) {
                var t = [];
                if (!e) return "";
                e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                var n = t.join(" ");
                return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
            }
            var l = !1;
            return a.listen(function(e) {
                for (var t in e) "ImageStream" === e[t].kind && i(e[t]), "Image" === e[t].kind && r(e[t]);
            }), n.register("taggedBy", function(e) {
                var t, a, i = {};
                if (!e.items) return n(null);
                for (t = 0, a = e.items.length; t < a; t++) this.name(e.items[t].image).extend(i);
                return n(i);
            }), n.register("taggedFirst", function(e) {
                var t = {};
                return e.items ? (e.items.length && this.name(e.items[0].image).extend(t), n(t)) : n(null);
            }), n.register({
                name: "containsTagImage",
                digests: function(t) {
                    var n = [];
                    return "string" == typeof t ? n.push(t) : e(t, function(e, t) {
                        n.push(t.image + "");
                    }), n;
                }
            }), n.register("listTagNames", function(n) {
                var a = [];
                return t.forEach(this.containsTagImage(n), function(t) {
                    e(t, function(e, i) {
                        n && i.image != n || a.push(t.metadata.namespace + "/" + t.metadata.name + ":" + e.tag);
                    });
                }), a;
            }), n.register("dockerImageConfig", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a, i = o(t) || {};
                    if (i[0] && (a = i[0].v1Compatibility, a && a.config)) return void (e[n] = a.config);
                    var r = t.dockerImageMetadata || {};
                    r.Config && (e[n] = r.Config);
                }), n(e);
            }), n.register("dockerConfigLabels", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a;
                    t && (a = t.Labels), a && (e[n] = a);
                }), n(e);
            }), {
                watchImages: s,
                allStreams: function() {
                    return n().kind("ImageStream");
                },
                imageByTag: function(e) {
                    return n().kind("Image").taggedFirst(e);
                },
                imageLayers: o,
                imageConfig: function(e) {
                    return n(e).dockerImageConfig().one() || {};
                },
                imageTagNames: function(e) {
                    return n().kind("ImageStream").listTagNames(e.metadata.name);
                },
                imageLabels: function(e) {
                    var a = n(e).dockerImageConfig().dockerConfigLabels().one();
                    return a && t.equals({}, a) && (a = null), a;
                },
                configCommand: u
            };
        } ]).factory("imageActions", [ "$modal", "$location", function(e, t) {
            function n(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamDeleteCtrl",
                    templateUrl: "views/imagestream-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function a() {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {};
                        }
                    }
                }).result;
            }
            function i(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function r(t, n) {
                var a = e.open({
                    animation: !1,
                    controller: "ImageDeleteCtrl",
                    templateUrl: "views/image-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t,
                                tag: n
                            };
                        }
                    }
                });
                return a.result;
            }
            function s(e) {
                return t.path("/projects/" + e), !1;
            }
            return {
                createImageStream: a,
                modifyImageStream: i,
                deleteImageStream: n,
                deleteTag: r,
                modifyProject: s
            };
        } ]).controller("ImageStreamDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, i) {
            t.extend(e, a), e.performDelete = function() {
                return i.delete(e.stream);
            };
        } ]).controller("ImageStreamModifyCtrl", [ "$scope", "$modalInstance", "dialogData", "imageTagData", "kubeMethods", "filterService", "gettextCatalog", function(e, n, a, i, r, s, o) {
            function u() {
                var e = {
                    spec: {
                        dockerImageRepository: null,
                        tags: null
                    }
                };
                return "none" != g.populate && (e.spec.dockerImageRepository = g.pull.trim()), "tags" == g.populate && i.buildSpec(g.tags, e.spec, g.insecure), 
                r.patch(d, e);
            }
            function l() {
                var e = {
                    kind: "ImageStream",
                    metadata: {
                        name: g.name.trim(),
                        namespace: g.project.trim()
                    }
                };
                return "none" != g.populate && (e.spec = {
                    dockerImageRepository: g.pull.trim()
                }), "tags" == g.populate && (e.spec = i.buildSpec(g.tags, e.spec, g.insecure)), 
                r.check(e, {
                    "metadata.name": "#imagestream-modify-name",
                    "metadata.namespace": "#imagestream-modify-project"
                }).then(function() {
                    return r.create(e, g.project);
                });
            }
            function c(e) {
                var t;
                if (e) for (var n in e.tags) if (e.tags[n].importPolicy.insecure) {
                    t = e.tags[n].importPolicy.insecure;
                    break;
                }
                return t;
            }
            var d = a.stream || {}, f = d.metadata || {}, m = d.spec || {}, p = o.getString.bind(o), h = "none";
            m.dockerImageRepository && (h = "pull"), m.tags && (h = "tags");
            var g = {
                name: f.name || "",
                project: f.namespace || s.namespace() || "",
                populate: h,
                pull: m.dockerImageRepository || "",
                tags: i.parseSpec(m),
                insecure: c(m)
            };
            e.fields = g, e.labels = {
                populate: {
                    none: p("Don't pull images automatically"),
                    pull: p("Sync all tags from a remote image repository"),
                    tags: p("Pull specific tags from another image repository")
                }
            }, e.placeholder = p("eg: my-image-stream"), a.stream || (e.labels.populate.none = p("Create empty image stream")), 
            e.performCreate = l, e.performModify = u, e.hasInsecureTag = c, e.projects = s.namespaces, 
            t.extend(e, a);
        } ]).controller("ImageDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, i) {
            t.extend(e, a), e.performDelete = function() {
                var t = e.stream.metadata.name + ":" + e.tag.tag;
                return i.delete("ImageStreamTag", t, e.stream.metadata.namespace);
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(e) {
            function t(e) {
                e && i.push(e);
            }
            var n, a, i = [];
            for (n = e.firstChild; n; n = n.nextSibling) a = "", 3 == n.nodeType ? a = n.nodeValue.trim() : 1 == n.nodeType && n.hasAttribute("value") && (a = n.getAttribute("value")), 
            a.split(s).forEach(t);
            return i;
        }
        function t(e) {
            var t = [ document.createTextNode("​") ];
            return r.forEach(e, function(e) {
                var n = document.createElement("span");
                n.setAttribute("contenteditable", "false"), n.setAttribute("class", "image-tag"), 
                n.setAttribute("value", e), n.appendChild(document.createTextNode(e));
                var a = document.createElement("a");
                a.setAttribute("class", "pficon pficon-close"), n.appendChild(a), t.push(n), t.push(document.createTextNode(" "));
            }), t;
        }
        function a(e) {
            var t = [];
            return r.forEach(e.tags || [], function(e) {
                t.push(e.name);
            }), t;
        }
        function i(e, t, n) {
            var a = {};
            t || (t = {}), r.forEach(t.tags || [], function(e) {
                a[e.name] = e;
            });
            var i = [];
            return r.forEach(e, function(e) {
                e in a ? (a[e].importPolicy = {
                    insecure: n
                }, i.push(a[e])) : i.push({
                    name: e,
                    importPolicy: {
                        insecure: n
                    }
                });
            }), t.tags = i, t;
        }
        var r = n(32), s = /[\u200B\s,]+/;
        r.module("registry.tags", []).directive("imageTagEditor", [ function() {
            return {
                restrict: "A",
                transclude: !0,
                scope: {
                    tags: "="
                },
                link: function(n, a, i) {
                    a.addClass("image-tag-editor"), a.attr("tabindex", "0"), a.attr("contenteditable", "true");
                    var r = t(n.tags);
                    a.append(r);
                    var s = document.createRange();
                    s.selectNodeContents(r[r.length - 1]), s.collapse(!1);
                    var o = window.getSelection();
                    o.removeAllRanges(), o.addRange(s), a.on("click", function(e) {
                        var t = e.target, n = t.parentNode;
                        "a" == t.nodeName.toLowerCase() && "span" == n.nodeName.toLowerCase() && n.parentNode.removeChild(n);
                    }), a.on("blur keyup paste copy cut mouseup", function() {
                        for (var t = e(a[0]); n.tags.length > 0; ) n.tags.pop();
                        t.forEach(function(e) {
                            n.tags.push(e);
                        });
                    });
                }
            };
        } ]).factory("imageTagData", [ function() {
            return {
                parseSpec: a,
                buildSpec: i,
                buildNodes: t,
                parseNodes: e
            };
        } ]);
    }();
}, function(e, t) {
    !function(e) {
        function t(a) {
            if (n[a]) return n[a].exports;
            var i = n[a] = {
                exports: {},
                id: a,
                loaded: !1
            };
            return e[a].call(i.exports, i, i.exports, t), i.loaded = !0, i.exports;
        }
        var n = {};
        return t.m = e, t.c = n, t.p = "", t(0);
    }([ function(e, t, n) {
        n(4), n(5), n(6), n(7), n(8), n(10), n(11), n(12), n(13), n(14), n(15), n(16), n(17), 
        e.exports = n(18);
    }, , , , function(e, t) {
        !function() {
            "use strict";
            angular.module("registryUI.images", [ "registryUI.client", "registryUI.date" ]).factory("imageDockerManifest", [ "WeakMap", function(e) {
                var t = new e();
                return function(e) {
                    if (!e) return {};
                    var n = t.get(e);
                    return n || (n = JSON.parse(e.dockerImageManifest || "{ }"), angular.forEach(n.history || [], function(e) {
                        "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                    }), t.set(e, n)), n;
                };
            } ]).factory("imageDockerConfig", [ "WeakMap", "imageLayers", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return {};
                    var a, i, r, s = n.get(e);
                    return s || (i = t(e), i.length && (r = i[0].v1Compatibility), r && r.config ? s = r.config : (a = e.dockerImageMetadata || {}, 
                    a.Config && (s = a.Config)), n.set(e, s)), s || {};
                };
            } ]).factory("imageLayers", [ "WeakMap", "imageDockerManifest", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return [];
                    var a, i = n.get(e);
                    return i || (a = t(e), i = a.history ? a.history : e.dockerImageLayers ? e.dockerImageLayers : [], 
                    n.set(e, i)), i;
                };
            } ]).directive("registryImageBody", [ "imageLayers", "imageDockerConfig", function(e, t) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-body.html",
                    link: function(n, a, i) {
                        n.$watch("image", function(a) {
                            n.layers = e(a), n.config = t(a), n.labels = n.config.Labels, angular.equals({}, n.labels) && (n.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagePull", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        settings: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-pull.html"
                };
            } ]).directive("registryImageConfig", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-config.html",
                    link: function(t, n, a) {
                        t.configCommand = function(e) {
                            var t = [];
                            if (!e) return "";
                            e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                            var n = t.join(" ");
                            return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
                        }, t.$watch("image", function(n) {
                            t.config = e(n);
                        });
                    }
                };
            } ]).directive("registryImageMeta", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-meta.html",
                    link: function(t, n, a) {
                        t.$watch("image", function(n) {
                            t.config = e(n), t.labels = t.config.Labels, angular.equals({}, t.labels) && (t.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagestreamBody", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        imagestreamFunc: "&imagestreamModify",
                        projectFunc: "&projectModify",
                        sharingFunc: "&projectSharing"
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-body.html",
                    link: function(e, t, n) {
                        e.projectModify = e.projectFunc(), e.projectSharing = e.sharingFunc(), e.imagestreamModify = e.imagestreamFunc();
                    }
                };
            } ]).directive("registryImagestreamPush", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        settings: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-push.html"
                };
            } ]).directive("registryImagestreamMeta", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-meta.html"
                };
            } ]);
        }();
    }, function(e, t) {
        angular.module("registryUI.client", []).factory("WeakMap", function() {
            function e() {
                var e = "weakmap" + n;
                n += 1, t || (t = Math.random().toString(36).slice(2));
                var a = this;
                a.delete = function(n) {
                    var a = n[t];
                    a && delete a[e];
                }, a.has = function(n) {
                    var a = n[t];
                    return a && e in a;
                }, a.get = function(n) {
                    var a = n[t];
                    if (a) return a[e];
                }, a.set = function(n, a) {
                    var i = n[t];
                    i || (i = function() {}, Object.defineProperty(n, t, {
                        enumerable: !1,
                        configurable: !1,
                        writable: !1,
                        value: i
                    })), i[e] = a;
                };
            }
            if ("function" == typeof window.WeakMap) return window.WeakMap;
            var t, n = 1;
            return e;
        });
    }, function(e, t) {
        !function() {
            angular.module("registryUI.date", []).factory("dateRefreshMinute", [ "$rootScope", function(e) {
                var t = null;
                return {
                    enable: function() {
                        null === t && (t = window.setInterval(function() {
                            e.$applyAsync();
                        }, 6e4));
                    },
                    disable: function() {
                        null !== t && (window.clearInterval(t), t = null);
                    }
                };
            } ]).filter("dateRelative", [ "dateRefreshMinute", function() {
                function e(e) {
                    return e ? moment(e).fromNow() : e;
                }
                function t(e) {
                    return e;
                }
                return e.$stateful = !0, "function" == typeof moment ? e : t;
            } ]);
        }();
    }, function(e, t) {
        !function() {
            "use strict";
            function e(e, t) {
                var n, a;
                return e.v1Compatibility.container_config && (n = e.v1Compatibility.container_config.Cmd) ? (a = n[n.length - 1], 
                0 === a.indexOf("#(nop)") ? a.substring(6).trim() : 1 == n.length && 0 === n[0].indexOf("/bin/sh -c #(nop)") ? n[0].substring(17).trim() : n.join(" ")) : e.v1Compatibility.id;
            }
            angular.module("registryUI.images").factory("prepareLayer", [ "gettextCatalog", function(t) {
                return function(n, a, i) {
                    var r;
                    return r = n.v1Compatibility ? {
                        id: n.v1Compatibility.id,
                        size: n.v1Compatibility.Size || 0,
                        label: e(n, i[a + 1])
                    } : n.name && n.size ? {
                        id: n.name,
                        size: n.size || 0,
                        label: n.name
                    } : {
                        size: 0,
                        id: a,
                        label: t.getString("Unknown layer")
                    }, 0 === r.label.indexOf("RUN ") ? r.hint = "run" : 0 === r.label.indexOf("ADD ") || r.size > 8192 ? r.hint = "add" : r.hint = "other", 
                    r;
                };
            } ]).directive("registryImageLayers", [ "imageLayers", "prepareLayer", "gettextCatalog", function(e, t, n) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        data: "=?layers"
                    },
                    templateUrl: "registry-image-widgets/views/image-layers.html",
                    link: function(a, i, r) {
                        a.formatSize = function(e) {
                            var t;
                            return e ? e > 1024 && "undefined" != typeof cockpit ? cockpit.format_bytes(e) : e > 1048576 ? (t = (e / 1048576).toFixed(1), 
                            n.getPlural(t, a, "{0} MB", "{0} MB").replace("{0}", t)) : n.getPlural(t, a, "{0} byte", "{0} bytes").replace("{0}", e) : "";
                        }, a.$watch("data", function(e) {
                            e && e.length && (e = e.map(t).reverse()), a.layers = e;
                        }), a.$watch("image", function(t) {
                            angular.isUndefined(t) || (a.data = e(t));
                        });
                    }
                };
            } ]);
        }();
    }, function(e, t) {}, , function(e, t) {}, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<dl class="dl-horizontal left"> <dt ng-if="labels.name" translate>Name</dt> <dd ng-if="labels.name">{{ labels.name }}</dd> <dt ng-if="labels.summary" translate>Summary</dt> <dd ng-if="labels.summary">{{ labels.summary }}</dd> <dt ng-if="labels.description" translate>Description</dt> <dd ng-if="labels.description">{{ labels.description }}</dd> <dt ng-if="labels.url" translate>Source URL</dt> <dd ng-if="labels.url"> <a href="labels.url"><i class="fa fa-external-link"></i> {{ labels.url }}</a> </dd> <dt translate>Author</dt> <dd ng-if="config.author">{{config.author}}</dd> <dd ng-if="!config.author && image.dockerImageMetadata.Author">{{image.dockerImageMetadata.Author}}</dd> <dd ng-if="!config.author && !image.dockerImageMetadata.Author"><em translate>Unknown</em></dd> <dt ng-if="labels[\'build-date\'] || layers[0].v1Compatibility.created || image.dockerImageMetadata.Created" translate>Built</dt> <dd ng-if="labels[\'build-date\']" title="{{labels[\'build-date\']}}">{{ labels[\'build-date\'] | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && layers[0].v1Compatibility.created" title="{{layers[0].v1Compatibility.created}}">{{ layers[0].v1Compatibility.created | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && !layers[0].v1Compatibility.created && image.dockerImageMetadata.Created" title="{{image.dockerImageMetadata.Created}}">{{image.dockerImageMetadata.Created | dateRelative}}</dd> <dt translate>Digest</dt> <dd><tt>{{ image.metadata.name }}</tt></dd> <dt translate>Identifier</dt> <dd><tt>{{ config.Image }}</tt></dd> </dl> <dl class="registry-image-tags" ng-if="names"> <dt translate>Tags</dt> <dd><span class="registry-image-tag" ng-repeat="name in names">{{name}}</span></dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-body.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<dl class="dl-horizontal"> <dt translate>Command:</dt> <dd><code>{{ configCommand(config) }}</code></dd> </dl> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Run as</dt> <dd ng-if="config.User">{{config.User}}</dd> <dd ng-if="!config.User"><em translate>Default</em></dd> <dt translate>Directory</dt> <dd ng-if="config.WorkingDir">{{config.WorkingDir}}</dd> <dd ng-if="!config.WorkingDir">/</dd> <dt ng-if="config.StopSignal" translate>Stop with</dt> <dd ng-if="config.StopSignal">{{config.StopSignal}}</dd> <dt translate>Architecture</dt> <dd ng-if="config.architecture">{{config.architecture}}</dd> <dd ng-if="!config.architecture">{{image.dockerImageMetadata.Architecture}}</dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Env.length" translate>Environment</dt> <dd ng-repeat="env in config.Env"><tt>{{env}}</tt></dd> </dl> </div> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Ports</dt> <dd ng-repeat="(port, data) in config.ExposedPorts">{{port}}</dd> <dd ng-if="!config.ExposedPorts"><em translate>None</em></dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Volumes" translate>Volumes</dt> <dd ng-repeat="(volume, data) in config.Volumes">{{volume}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-config.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<div> <dl class="dl-horizontal left"> <dt ng-if="labels" translate>Labels</dt> <dd ng-repeat="(name, value) in labels" ng-show="name != \'description\' && name != \'name\'"> <tt>{{name}}={{value}}</tt> </dd> <dt ng-if="config.OnBuild.length" translate>On Build</dt> <dd ng-repeat="line in config.OnBuild"><tt>{{line}}</tt></dd> <dt ng-if="image.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in image.metadata.annotations">{{name}}: {{value}}</dd> <dt translate>Docker Version</dt> <dd>{{image.dockerImageMetadata.DockerVersion}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-meta.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<ul class="registry-image-layers"> <li ng-repeat="layer in layers" class="hint-{{ layer.hint }}"> <span title="{{ layer.size }}">{{ formatSize(layer.size) }}</span> <p>{{ layer.label}}</p> </li> </ul>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-layers.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<div ng-if="names" class="registry-image-pull"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To pull this image:</span> </p> <code ng-if="!settings.registry.host">$ sudo docker pull <span class="placeholder">registry</span>/{{names[0]}}</code>\n<code ng-if="settings.registry.host">$ sudo docker pull <span>{{settings.registry.host}}</span>/{{names[0]}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-pull.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<div ng-repeat="statustags in imagestream.status.tags"> <div ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="alert alert-danger"> <span class="pficon pficon-error-circle-o"></span>\n<span translate>{{ condition.message }}. Timestamp: {{ condition.lastTransitionTime }} Error count: {{ condition.generation }}</span>\n<a translate ng-if="imagestreamModify" ng-click="imagestreamModify(imagestream)" class="alert-link">Edit image stream</a> </div> </div> <dl class="dl-horizontal left"> <dt translate>Access Policy</dt> <dd ng-switch="projectSharing(imagestream.metadata.namespace)"> <div ng-switch-when="anonymous"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by anonymous users</a>\n<i title="Images accessible to anonymous users" class="fa fa-unlock registry-imagestream-lock"></i> </div> <div ng-switch-when="shared"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by any authenticated user or group</a>\n<i title="Images accessible to authenticated users" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-when="private"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may only be pulled by specific users or groups</a>\n<i title="Images only accessible to members" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-default> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Unknown</a>\n<i title="Unknown or invalid image access policy" class="fa fa-lock registry-imagestream-lock"></i> </div> </dd> <dt translate>Pull repository</dt> <dd ng-if="imagestream.spec.dockerImageRepository"><tt>{{imagestream.spec.dockerImageRepository}}</tt></dd> <dd ng-if="!imagestream.spec.dockerImageRepository"><em translate>None</em></dd> <dt translate>Image count</dt> <dd>{{imagestream.status.tags.length}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-body.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<dl class="dl-horizontal left"> <dt ng-if="imagestream.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in imagestream.metadata.annotations">{{name}}: {{value}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-meta.html", i);
        } ]), e.exports = i;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var i = '<div class="registry-imagestream-push"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To push to an image to this image stream:</span> </p> <code ng-if="settings.registry.host">$ sudo docker tag <em>myimage</em> <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code>\n<code ng-if="!settings.registry.host">$ sudo docker tag <em>myimage</em> <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-push.html", i);
        } ]), e.exports = i;
    } ]);
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<table listing-table class="listing-ct images-listing"> <thead> <tr ng-if="!listing.inline"> <td colspan="4"> <a class="pull-right" ng-click="createImageStream()"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>New image stream</span> </a> <h3 translate>Images</h3> </td> </tr> <tr> <th class="listing-ct-toggle"></th> <th translate>Tags</th> <th translate>Author</th> <th translate>Last Updated</th> </tr> </thead> <tbody ng-repeat-start="(link, stream) in imagestreams() track by link" ng-init="sid = stream.metadata.namespace + \'/\' + stream.metadata.name" data-id="{{ sid }}" class="active" ng-class="{open: listing.expanded(sid)}"> <tr ng-if="!listing.inline" ng-click="listing.activate(sid)" class="listing-ct-item imagestream-item"> <td ng-click="listing.toggle(sid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <th colspan="4"> {{ sid }} <div class="listing-status" ng-repeat="statustags in stream.status.tags"> <span ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="pficon pficon-warning-triangle-o"></span> </div>  </th> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(sid)" ng-init="id = sid"> <td listing-panel kind="ImageStream" colspan="4"></td> </tr> </tbody> <tbody ng-repeat="tag in stream.status.tags track by tag.tag" ng-init="iid = sid + \':\' + tag.tag" data-id="{{ iid }}" ng-class="{open: listing.expanded(iid), last: $last, first: $first}"> <tr ng-click="listing.activate(iid)" class="listing-ct-item tag-item" ng-repeat-start="image in imageByTag(tag)"> <td ng-click="listing.toggle(iid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <td class="tag-label"><span class="image-tag">:{{ tag.tag }}</span></td> <td colspan="3" class="container"> <div class="row"> <div class="col col-xs-12"><tt>{{ image.metadata.name }}</tt></div> </div> <div class="row"> <div class="col col-xs-6 text-left" ng-if="conf.author">{{ conf.author }}</div> <div class="col col-xs-6 text-left" ng-if="!conf.author">{{ image.dockerImageMetadata.Author }}</div> <div class="col col-xs-6" title="{{ tag.items[0].created }}">{{ tag.items[0].created | dateRelative }}</div> </div> </td> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(iid)" ng-init="id = iid" ng-repeat-end=""> <td image-panel colspan="4"></td> </tr> </tbody> <tbody data-ng-rubbish="" ng-if="0" ng-repeat-end> </tbody> <thead class="listing-ct-empty" ng-if="!quiet"> <tr> <td colspan="4" ng-if="!failure" translate>No image streams are present.</td> <td colspan="4" ng-if="failure">{{failure}}</td> </tr> </thead> </table>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-listing.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Delete image stream</h3> </div> <div class="modal-body" translate>Do you want to delete the \'{{stream.metadata.namespace}}/{{stream.metadata.name}}\' image stream?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-delete.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" ng-if="!stream" translate>Create image stream</h3> <h3 class="modal-title" ng-if="stream" translate>Change image stream</h3> </div> <div class="modal-body"> <table class="form-table-ct"> <tr> <td> <label class="control-label" for="imagestream-modify-name" translate>Name</label> </td> <td> <input id="imagestream-modify-name" class="form-control" type="text" ng-if="!stream" ng-model="fields.name" placeholder="{{ placeholder }}" autofocus>\n<span id="imagestream-modify-name" ng-if="stream">{{ fields.name }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-project-text" translate>Project</label> </td> <td> <div ng-if="!stream" id="imagestream-modify-project" class="input-group input-combo"> <input class="form-control" id="imagestream-modify-project-text" type="text" ng-model="fields.project">\n<span class="input-group-btn" dropdown> <button class="btn btn-default dropdown-toggle" dropdown-toggle type="button"> <span class="caret"></span> </button> <ul dropdown-menu class="dropdown-menu" role="menu"> <li ng-repeat="name in projects() track by name" ng-class="{ checked: name == fields.project }"> <a ng-click="fields.project = name" value="{{name}}">{{ name }}</a> </li> </ul> </span> </div> <span id="imagestream-modify-project" ng-if="stream">{{ fields.project }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-populate" translate>Populate</label> </td> <td> <div class="btn-group bootstrap-select form-control" dropdown id="imagestream-modify-populate"> <button class="btn btn-default dropdown-toggle" dropdown-toggle> <span class="pull-left">{{ labels.populate[fields.populate] }}</span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="(value, label) in labels.populate" ng-class="{checked: value == fields.populate}"> <a ng-click="fields.populate = value" value="{{value}}">{{ label }}</a> </li> </ul> </div> </td> </tr> <tr ng-show="fields.populate != \'none\'"> <td class="top"> <label class="control-label" for="imagestream-modify-pull" translate>Pull from</label> </td> <td> <input id="imagestream-modify-pull" class="form-control" type="text" ng-model="fields.pull" placeholder="eg: docker.io/library/fedora"> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td class="top"> <label class="control-label" for="imagestream-modify-tags" translate>Tags</label> </td> <td> <div image-tag-editor id="imagestream-modify-tags" tags="fields.tags"> </div> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td></td> <td> <label> <input type="checkbox" ng-checked="hasInsecureTag(stream.spec)" ng-model="fields.insecure">\n<span translate>Remote registry is insecure</span> </label> </td> </tr> </table> </div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-primary" ng-if="stream" ng-click="complete(performModify())">Change</button>\n<button class="btn btn-primary" ng-if="!stream" ng-click="complete(performCreate())">Create</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-modify.html", i);
    } ]), e.exports = i;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var i = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Remove image tag</h3> </div> <div class="modal-body" translate>Do you want to remove the image tagged as \'{{stream.metadata.namespace}}/{{stream.metadata.name}}:{{tag.tag}}\'?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-delete.html", i);
    } ]), e.exports = i;
}, , , , , function(e, t, n) {
    "use strict";
    !function() {
        window.QUnit = n(247), window.qunitTap = n(249), n(250), n(251), e.exports = window.QUnit;
    }();
}, function(e, t, n) {
    var a;
    (function(e, i) {
        /*!
	 * QUnit 1.23.1
	 * https://qunitjs.com/
	 *
	 * Copyright jQuery Foundation and other contributors
	 * Released under the MIT license
	 * https://jquery.org/license
	 *
	 * Date: 2016-04-12T17:29Z
	 */
        !function(e) {
            function r(e, t) {
                var n, a, i = e.slice();
                for (n = 0; n < i.length; n++) for (a = 0; a < t.length; a++) if (i[n] === t[a]) {
                    i.splice(n, 1), n--;
                    break;
                }
                return i;
            }
            function s(e, t) {
                if (t.indexOf) return t.indexOf(e);
                for (var n = 0, a = t.length; n < a; n++) if (t[n] === e) return n;
                return -1;
            }
            function o(e) {
                var t, n, a = j.is("array", e) ? [] : {};
                for (t in e) R.call(e, t) && (n = e[t], a[t] = n === Object(n) ? o(n) : n);
                return a;
            }
            function u(t, n, a) {
                for (var i in n) R.call(n, i) && ("constructor" === i && t === e || (void 0 === n[i] ? delete t[i] : a && "undefined" != typeof t[i] || (t[i] = n[i])));
                return t;
            }
            function l(e) {
                if ("undefined" == typeof e) return "undefined";
                if (null === e) return "null";
                var t = q.call(e).match(/^\[object\s(.*)\]$/), n = t && t[1];
                switch (n) {
                  case "Number":
                    return isNaN(e) ? "nan" : "number";

                  case "String":
                  case "Boolean":
                  case "Array":
                  case "Set":
                  case "Map":
                  case "Date":
                  case "RegExp":
                  case "Function":
                  case "Symbol":
                    return n.toLowerCase();
                }
                return "object" == typeof e ? "object" : void 0;
            }
            function c(e, t) {
                return j.objectType(t) === e;
            }
            function d(e, t) {
                t = void 0 === t ? 4 : t;
                var n, a, i;
                if (e.stack) {
                    if (n = e.stack.split("\n"), /^error$/i.test(n[0]) && n.shift(), N) {
                        for (a = [], i = t; i < n.length && n[i].indexOf(N) === -1; i++) a.push(n[i]);
                        if (a.length) return a.join("\n");
                    }
                    return n[t];
                }
                if (e.sourceURL) {
                    if (/qunit.js$/.test(e.sourceURL)) return;
                    return e.sourceURL + ":" + e.line;
                }
            }
            function f(e) {
                var t = new Error();
                if (!t.stack) try {
                    throw t;
                } catch (e) {
                    t = e;
                }
                return d(t, e);
            }
            function m(e) {
                function t(e) {
                    var t = function(t) {
                        if ("function" !== l(t)) throw new Error("QUnit logging methods require a callback function as their first parameters.");
                        z.callbacks[e].push(t);
                    };
                    return B[e] = t, t;
                }
                var n, a, i, r = [ "begin", "done", "log", "testStart", "testDone", "moduleStart", "moduleDone" ];
                for (n = 0, a = r.length; n < a; n++) i = r[n], "undefined" === l(z.callbacks[i]) && (z.callbacks[i] = []), 
                e[i] = t(i);
            }
            function p(e, t) {
                var n, a, i;
                for (i = z.callbacks[e], n = 0, a = i.length; n < a; n++) i[n](t);
            }
            function h() {
                var t, n;
                for (t in B) j[t] !== B[t] && (n = j[t], j[t] = B[t], j[t](n), e.console && e.console.warn && e.console.warn("QUnit." + t + " was replaced with a new value.\nPlease, check out the documentation on how to apply logging callbacks.\nReference: https://api.qunitjs.com/category/callbacks/"));
            }
            function g() {
                var e, t, n = [];
                if (!z.started) {
                    for (z.started = O(), h(), "" === z.modules[0].name && 0 === z.modules[0].tests.length && z.modules.shift(), 
                    e = 0, t = z.modules.length; e < t; e++) n.push({
                        name: z.modules[e].name,
                        tests: z.modules[e].tests
                    });
                    p("begin", {
                        totalTests: $.count,
                        modules: n
                    });
                }
                z.blocking = !1, _(!0);
            }
            function _(e) {
                function t() {
                    _(e);
                }
                var n = O();
                for (z.depth = (z.depth || 0) + 1; z.queue.length && !z.blocking; ) {
                    if (!(!U.setTimeout || z.updateRate <= 0 || O() - n < z.updateRate)) {
                        I(t, 13);
                        break;
                    }
                    z.current && (z.current.usedAsync = !1), z.queue.shift()();
                }
                z.depth--, !e || z.blocking || z.queue.length || 0 !== z.depth || y();
            }
            function v() {
                z.blocking = !0, z.testTimeout && U.setTimeout && (P(z.timeout), z.timeout = I(function() {
                    if (!z.current) throw new Error("Test timed out");
                    z.current.semaphore = 0, j.pushFailure("Test timed out", f(2)), b();
                }, z.testTimeout));
            }
            function b() {
                W = !0, U.setTimeout ? I(function() {
                    z.current && z.current.semaphore > 0 || (z.timeout && P(z.timeout), g());
                }, 13) : g();
            }
            function y() {
                var e, t;
                z.autorun = !0, z.previousModule && p("moduleDone", {
                    name: z.previousModule.name,
                    tests: z.previousModule.tests,
                    failed: z.moduleStats.bad,
                    passed: z.moduleStats.all - z.moduleStats.bad,
                    total: z.moduleStats.all,
                    runtime: O() - z.moduleStats.started
                }), delete z.previousModule, e = O() - z.started, t = z.stats.all - z.stats.bad, 
                p("done", {
                    failed: z.stats.bad,
                    passed: t,
                    total: z.stats.all,
                    runtime: e
                });
            }
            function M(e, t) {
                return void 0 === e.testEnvironment && (e.testEnvironment = {}), function(n) {
                    e.testEnvironment[t] = n;
                };
            }
            function $(e) {
                var t, n;
                for (++$.count, u(this, e), this.assertions = [], this.semaphore = 0, this.usedAsync = !1, 
                this.module = z.currentModule, this.stack = f(3), t = 0, n = this.module.tests; t < n.length; t++) this.module.tests[t].name === this.testName && (this.testName += " ");
                this.testId = k(this.module.name, this.testName), this.module.tests.push({
                    name: this.testName,
                    testId: this.testId
                }), e.skip ? (this.callback = function() {}, this.async = !1, this.expected = 0) : this.assert = new E(this);
            }
            function k(e, t) {
                for (var n, a = 0, i = 0, r = e + "" + t, s = r.length; a < s; a++) i = (i << 5) - i + r.charCodeAt(a), 
                i |= 0;
                return n = (4294967296 + i).toString(16), n.length < 8 && (n = "0000000" + n), n.slice(-8);
            }
            function w(e, t, n) {
                var a, i = !t;
                if ("array" !== j.objectType(e)) t ? z.queue.splice(K++, 0, e) : n ? (G || (G = L(n)), 
                a = Math.floor(G() * (z.queue.length - K + 1)), z.queue.splice(K + a, 0, e)) : z.queue.push(e), 
                z.autorun && !z.blocking && _(i); else for (;e.length; ) w(e.shift());
            }
            function L(e) {
                var t = parseInt(k(e), 16) || -1;
                return function() {
                    return t ^= t << 13, t ^= t >>> 17, t ^= t << 5, t < 0 && (t += 4294967296), t / 4294967296;
                };
            }
            function D() {
                if (z.pollution = [], z.noglobals) for (var t in e) if (R.call(e, t)) {
                    if (/^qunit-test-output/.test(t)) continue;
                    z.pollution.push(t);
                }
            }
            function Y() {
                var e, t, n = z.pollution;
                D(), e = r(z.pollution, n), e.length > 0 && j.pushFailure("Introduced global variable(s): " + e.join(", ")), 
                t = r(n, z.pollution), t.length > 0 && j.pushFailure("Deleted global variable(s): " + t.join(", "));
            }
            function T(e, t, n) {
                2 === arguments.length && (n = t, t = null), j.test(e, t, n, !0);
            }
            function S(e, t, n, a) {
                if (!J) {
                    var i;
                    2 === arguments.length && (n = t, t = null), i = new $({
                        testName: e,
                        expected: t,
                        async: a,
                        callback: n
                    }), i.queue();
                }
            }
            function x(e) {
                if (!J) {
                    var t = new $({
                        testName: e,
                        skip: !0
                    });
                    t.queue();
                }
            }
            function C(e, t, n, a) {
                var i;
                J || (j.config.queue.length = 0, J = !0, 2 === arguments.length && (n = t, t = null), 
                i = new $({
                    testName: e,
                    expected: t,
                    async: a,
                    callback: n
                }), i.queue());
            }
            function E(e) {
                this.test = e;
            }
            function H(e) {
                var t, n, a = e.toString();
                return "[object" === a.substring(0, 7) ? (t = e.name ? e.name.toString() : "Error", 
                n = e.message ? e.message.toString() : "", t && n ? t + ": " + n : t ? t : n ? n : "Error") : a;
            }
            var j = {}, A = e.Date, O = A.now || function() {
                return new A().getTime();
            }, I = e.setTimeout, P = e.clearTimeout, F = e.window, U = {
                document: F && void 0 !== F.document,
                setTimeout: void 0 !== I,
                sessionStorage: function() {
                    var e = "qunit-test-string";
                    try {
                        return sessionStorage.setItem(e, e), sessionStorage.removeItem(e), !0;
                    } catch (e) {
                        return !1;
                    }
                }()
            }, N = (f(0) || "").replace(/(:\d+)+\)?/, "").replace(/.+\//, ""), V = !1, W = !1, q = Object.prototype.toString, R = Object.prototype.hasOwnProperty, z = {
                queue: [],
                blocking: !0,
                reorder: !0,
                altertitle: !0,
                collapse: !0,
                scrolltop: !0,
                maxDepth: 5,
                requireExpects: !1,
                urlConfig: [],
                modules: [],
                moduleStack: [],
                currentModule: {
                    name: "",
                    tests: []
                },
                callbacks: {}
            };
            z.modules.push(z.currentModule);
            var B = {};
            !function() {
                if (U.document) {
                    var e = F.onerror;
                    F.onerror = function(t, n, a) {
                        var i = !1;
                        if (e && (i = e(t, n, a)), i !== !0) {
                            if (j.config.current) {
                                if (j.config.current.ignoreGlobalErrors) return !0;
                                j.pushFailure(t, n + ":" + a);
                            } else j.test("global failure", u(function() {
                                j.pushFailure(t, n + ":" + a);
                            }, {
                                validTest: !0
                            }));
                            return !1;
                        }
                        return i;
                    };
                }
            }(), j.isLocal = !(U.document && "file:" !== F.location.protocol), j.version = "1.23.1", 
            u(j, {
                module: function(e, t, n) {
                    function a() {
                        var n = z.moduleStack.length ? z.moduleStack.slice(-1)[0] : null, a = null !== n ? [ n.name, e ].join(" > ") : e, i = {
                            name: a,
                            parentModule: n,
                            tests: [],
                            moduleId: k(a)
                        }, r = {};
                        return n && (u(r, n.testEnvironment), delete r.beforeEach, delete r.afterEach), 
                        u(r, t), i.testEnvironment = r, z.modules.push(i), i;
                    }
                    function i(e) {
                        z.currentModule = e;
                    }
                    var r, s, o = z.currentModule;
                    2 === arguments.length && "function" === l(t) && (n = t, t = void 0), t && t.setup && (t.beforeEach = t.setup, 
                    delete t.setup), t && t.teardown && (t.afterEach = t.teardown, delete t.teardown), 
                    r = a(), s = {
                        beforeEach: M(r, "beforeEach"),
                        afterEach: M(r, "afterEach")
                    }, "function" === l(n) && (z.moduleStack.push(r), i(r), n.call(r.testEnvironment, s), 
                    z.moduleStack.pop(), r = r.parentModule || o), i(r);
                },
                asyncTest: T,
                test: S,
                skip: x,
                only: C,
                start: function(e) {
                    var t = V;
                    if (z.current) {
                        if (z.current.semaphore -= e || 1, isNaN(z.current.semaphore)) return z.current.semaphore = 0, 
                        void j.pushFailure("Called start() with a non-numeric decrement.", f(2));
                        if (z.current.semaphore > 0) return;
                        if (z.current.semaphore < 0) return z.current.semaphore = 0, void j.pushFailure("Called start() while already started (test's semaphore was 0 already)", f(2));
                    } else {
                        if (V = !0, W) throw new Error("Called start() outside of a test context while already started");
                        if (t || e > 1) throw new Error("Called start() outside of a test context too many times");
                        if (z.autostart) throw new Error("Called start() outside of a test context when QUnit.config.autostart was true");
                        if (!z.pageLoaded) return void (z.autostart = !0);
                    }
                    b();
                },
                stop: function(e) {
                    if (!z.current) throw new Error("Called stop() outside of a test context");
                    z.current.semaphore += e || 1, v();
                },
                config: z,
                is: c,
                objectType: l,
                extend: u,
                load: function() {
                    z.pageLoaded = !0, u(z, {
                        stats: {
                            all: 0,
                            bad: 0
                        },
                        moduleStats: {
                            all: 0,
                            bad: 0
                        },
                        started: 0,
                        updateRate: 1e3,
                        autostart: !0,
                        filter: ""
                    }, !0), z.blocking = !1, z.autostart && b();
                },
                stack: function(e) {
                    return e = (e || 0) + 2, f(e);
                }
            }), m(j);
            var G, J = !1, K = 0;
            $.count = 0, $.prototype = {
                before: function() {
                    this.module === z.previousModule && R.call(z, "previousModule") || (R.call(z, "previousModule") && p("moduleDone", {
                        name: z.previousModule.name,
                        tests: z.previousModule.tests,
                        failed: z.moduleStats.bad,
                        passed: z.moduleStats.all - z.moduleStats.bad,
                        total: z.moduleStats.all,
                        runtime: O() - z.moduleStats.started
                    }), z.previousModule = this.module, z.moduleStats = {
                        all: 0,
                        bad: 0,
                        started: O()
                    }, p("moduleStart", {
                        name: this.module.name,
                        tests: this.module.tests
                    })), z.current = this, this.module.testEnvironment && (delete this.module.testEnvironment.beforeEach, 
                    delete this.module.testEnvironment.afterEach), this.testEnvironment = u({}, this.module.testEnvironment), 
                    this.started = O(), p("testStart", {
                        name: this.testName,
                        module: this.module.name,
                        testId: this.testId
                    }), z.pollution || D();
                },
                run: function() {
                    function e(e) {
                        t = e.callback.call(e.testEnvironment, e.assert), e.resolvePromise(t);
                    }
                    var t;
                    if (z.current = this, this.async && j.stop(), this.callbackStarted = O(), z.notrycatch) return void e(this);
                    try {
                        e(this);
                    } catch (e) {
                        this.pushFailure("Died on test #" + (this.assertions.length + 1) + " " + this.stack + ": " + (e.message || e), d(e, 0)), 
                        D(), z.blocking && j.start();
                    }
                },
                after: function() {
                    Y();
                },
                queueHook: function(e, t) {
                    var n, a = this;
                    return function() {
                        function i() {
                            n = e.call(a.testEnvironment, a.assert), a.resolvePromise(n, t);
                        }
                        if (z.current = a, z.notrycatch) return void i();
                        try {
                            i();
                        } catch (e) {
                            a.pushFailure(t + " failed on " + a.testName + ": " + (e.message || e), d(e, 0));
                        }
                    };
                },
                hooks: function(e) {
                    function t(a, i) {
                        i.parentModule && t(a, i.parentModule), i.testEnvironment && "function" === j.objectType(i.testEnvironment[e]) && n.push(a.queueHook(i.testEnvironment[e], e));
                    }
                    var n = [];
                    return this.skip || t(this, this.module), n;
                },
                finish: function() {
                    z.current = this, z.requireExpects && null === this.expected ? this.pushFailure("Expected number of assertions to be defined, but expect() was not called.", this.stack) : null !== this.expected && this.expected !== this.assertions.length ? this.pushFailure("Expected " + this.expected + " assertions, but " + this.assertions.length + " were run", this.stack) : null !== this.expected || this.assertions.length || this.pushFailure("Expected at least one assertion, but none were run - call expect(0) to accept zero assertions.", this.stack);
                    var e, t = 0;
                    for (this.runtime = O() - this.started, z.stats.all += this.assertions.length, z.moduleStats.all += this.assertions.length, 
                    e = 0; e < this.assertions.length; e++) this.assertions[e].result || (t++, z.stats.bad++, 
                    z.moduleStats.bad++);
                    p("testDone", {
                        name: this.testName,
                        module: this.module.name,
                        skipped: !!this.skip,
                        failed: t,
                        passed: this.assertions.length - t,
                        total: this.assertions.length,
                        runtime: this.runtime,
                        assertions: this.assertions,
                        testId: this.testId,
                        source: this.stack,
                        duration: this.runtime
                    }), j.reset(), z.current = void 0;
                },
                queue: function() {
                    function e() {
                        w([ function() {
                            n.before();
                        }, n.hooks("beforeEach"), function() {
                            n.run();
                        }, n.hooks("afterEach").reverse(), function() {
                            n.after();
                        }, function() {
                            n.finish();
                        } ]);
                    }
                    var t, n = this;
                    if (this.valid()) return t = j.config.reorder && U.sessionStorage && +sessionStorage.getItem("qunit-test-" + this.module.name + "-" + this.testName), 
                    w(e, t, z.seed);
                },
                pushResult: function(e) {
                    var t, n = {
                        module: this.module.name,
                        name: this.testName,
                        result: e.result,
                        message: e.message,
                        actual: e.actual,
                        expected: e.expected,
                        testId: this.testId,
                        negative: e.negative || !1,
                        runtime: O() - this.started
                    };
                    e.result || (t = f(), t && (n.source = t)), p("log", n), this.assertions.push({
                        result: !!e.result,
                        message: e.message
                    });
                },
                pushFailure: function(e, t, n) {
                    if (!(this instanceof $)) throw new Error("pushFailure() assertion outside test context, was " + f(2));
                    var a = {
                        module: this.module.name,
                        name: this.testName,
                        result: !1,
                        message: e || "error",
                        actual: n || null,
                        testId: this.testId,
                        runtime: O() - this.started
                    };
                    t && (a.source = t), p("log", a), this.assertions.push({
                        result: !1,
                        message: e
                    });
                },
                resolvePromise: function(e, t) {
                    var n, a, i = this;
                    null != e && (n = e.then, "function" === j.objectType(n) && (j.stop(), n.call(e, function() {
                        j.start();
                    }, function(e) {
                        a = "Promise rejected " + (t ? t.replace(/Each$/, "") : "during") + " " + i.testName + ": " + (e.message || e), 
                        i.pushFailure(a, d(e, 0)), D(), j.start();
                    })));
                },
                valid: function() {
                    function e(t) {
                        var n = t.name ? t.name.toLowerCase() : null;
                        return n === i || !!t.parentModule && e(t.parentModule);
                    }
                    function t(e) {
                        return s(e.moduleId, z.moduleId) > -1 || e.parentModule && t(e.parentModule);
                    }
                    var n = z.filter, a = /^(!?)\/([\w\W]*)\/(i?$)/.exec(n), i = z.module && z.module.toLowerCase(), r = this.module.name + ": " + this.testName;
                    return !(!this.callback || !this.callback.validTest) || !(z.moduleId && z.moduleId.length > 0 && !t(this.module)) && (!(z.testId && z.testId.length > 0 && s(this.testId, z.testId) < 0) && (!(i && !e(this.module)) && (!n || (a ? this.regexFilter(!!a[1], a[2], a[3], r) : this.stringFilter(n, r)))));
                },
                regexFilter: function(e, t, n, a) {
                    var i = new RegExp(t, n), r = i.test(a);
                    return r !== e;
                },
                stringFilter: function(e, t) {
                    e = e.toLowerCase(), t = t.toLowerCase();
                    var n = "!" !== e.charAt(0);
                    return n || (e = e.slice(1)), t.indexOf(e) !== -1 ? n : !n;
                }
            }, j.reset = function() {
                if (U.document) {
                    var e = U.document && document.getElementById && document.getElementById("qunit-fixture");
                    e && (e.innerHTML = z.fixture);
                }
            }, j.pushFailure = function() {
                if (!j.config.current) throw new Error("pushFailure() assertion outside test context, in " + f(2));
                var e = j.config.current;
                return e.pushFailure.apply(e, arguments);
            }, j.assert = E.prototype = {
                expect: function(e) {
                    return 1 !== arguments.length ? this.test.expected : void (this.test.expected = e);
                },
                async: function(e) {
                    var t = this.test, n = !1, a = e;
                    return "undefined" == typeof a && (a = 1), t.semaphore += 1, t.usedAsync = !0, v(), 
                    function() {
                        return n ? void t.pushFailure("Too many calls to the `assert.async` callback", f(2)) : (a -= 1, 
                        void (a > 0 || (t.semaphore -= 1, n = !0, b())));
                    };
                },
                push: function(e, t, n, a, i) {
                    var r = this instanceof E ? this : j.config.current.assert;
                    return r.pushResult({
                        result: e,
                        actual: t,
                        expected: n,
                        message: a,
                        negative: i
                    });
                },
                pushResult: function(e) {
                    var t = this, n = t instanceof E && t.test || j.config.current;
                    if (!n) throw new Error("assertion outside test context, in " + f(2));
                    return n.usedAsync === !0 && 0 === n.semaphore && n.pushFailure("Assertion after the final `assert.async` was resolved", f(2)), 
                    t instanceof E || (t = n.assert), t.test.pushResult(e);
                },
                ok: function(e, t) {
                    t = t || (e ? "okay" : "failed, expected argument to be truthy, was: " + j.dump.parse(e)), 
                    this.pushResult({
                        result: !!e,
                        actual: e,
                        expected: !0,
                        message: t
                    });
                },
                notOk: function(e, t) {
                    t = t || (e ? "failed, expected argument to be falsy, was: " + j.dump.parse(e) : "okay"), 
                    this.pushResult({
                        result: !e,
                        actual: e,
                        expected: !1,
                        message: t
                    });
                },
                equal: function(e, t, n) {
                    this.pushResult({
                        result: t == e,
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notEqual: function(e, t, n) {
                    this.pushResult({
                        result: t != e,
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                propEqual: function(e, t, n) {
                    e = o(e), t = o(t), this.pushResult({
                        result: j.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notPropEqual: function(e, t, n) {
                    e = o(e), t = o(t), this.pushResult({
                        result: !j.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                deepEqual: function(e, t, n) {
                    this.pushResult({
                        result: j.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notDeepEqual: function(e, t, n) {
                    this.pushResult({
                        result: !j.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                strictEqual: function(e, t, n) {
                    this.pushResult({
                        result: t === e,
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notStrictEqual: function(e, t, n) {
                    this.pushResult({
                        result: t !== e,
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                throws: function(e, t, n) {
                    var a, i, r = t, s = !1, o = this instanceof E && this.test || j.config.current;
                    null == n && "string" == typeof t && (n = t, t = null), o.ignoreGlobalErrors = !0;
                    try {
                        e.call(o.testEnvironment);
                    } catch (e) {
                        a = e;
                    }
                    o.ignoreGlobalErrors = !1, a && (i = j.objectType(t), t ? "regexp" === i ? s = t.test(H(a)) : "string" === i ? s = t === H(a) : "function" === i && a instanceof t ? s = !0 : "object" === i ? s = a instanceof t.constructor && a.name === t.name && a.message === t.message : "function" === i && t.call({}, a) === !0 && (r = null, 
                    s = !0) : (s = !0, r = null)), o.assert.pushResult({
                        result: s,
                        actual: a,
                        expected: r,
                        message: n
                    });
                }
            }, function() {
                E.prototype.raises = E.prototype.throws;
            }(), j.equiv = function() {
                function e(e, t) {
                    return "object" == typeof t && (t = t.valueOf()), "object" == typeof e && (e = e.valueOf()), 
                    t === e;
                }
                function t(e, t) {
                    var n = u(e), a = u(t);
                    return e.constructor === t.constructor || (n && null === n.constructor && (n = null), 
                    a && null === a.constructor && (a = null), null === n && a === Object.prototype || null === a && n === Object.prototype);
                }
                function n(e) {
                    return "flags" in e ? e.flags : e.toString().match(/[gimuy]*$/)[0];
                }
                function a(e, t) {
                    var n = j.objectType(e);
                    return j.objectType(t) === n && l[n](t, e);
                }
                function i(e, t) {
                    return arguments.length < 2 || (e === t || a(e, t)) && (2 === arguments.length || i.apply(this, [].slice.call(arguments, 1)));
                }
                var r = [], s = [], o = [], u = Object.getPrototypeOf || function(e) {
                    return e.__proto__;
                }, l = {
                    string: e,
                    boolean: e,
                    number: e,
                    null: e,
                    undefined: e,
                    symbol: e,
                    date: e,
                    nan: function() {
                        return !0;
                    },
                    regexp: function(e, t) {
                        return t.source === e.source && n(t) === n(e);
                    },
                    function: function() {
                        var e = r[r.length - 1];
                        return e !== Object && "undefined" != typeof e;
                    },
                    array: function(e, t) {
                        var n, a, r, u, l, c;
                        if (r = t.length, r !== e.length) return !1;
                        for (s.push(t), o.push(e), n = 0; n < r; n++) {
                            for (u = !1, a = 0; a < s.length; a++) if (l = s[a] === t[n], c = o[a] === e[n], 
                            l || c) {
                                if (!(t[n] === e[n] || l && c)) return s.pop(), o.pop(), !1;
                                u = !0;
                            }
                            if (!u && !i(t[n], e[n])) return s.pop(), o.pop(), !1;
                        }
                        return s.pop(), o.pop(), !0;
                    },
                    set: function(e, t) {
                        var n, a = !0;
                        return t.size === e.size && (t.forEach(function(t) {
                            n = !1, e.forEach(function(e) {
                                i(e, t) && (n = !0);
                            }), n || (a = !1);
                        }), a);
                    },
                    map: function(e, t) {
                        var n, a = !0;
                        return t.size === e.size && (t.forEach(function(t, r) {
                            n = !1, e.forEach(function(e, a) {
                                i([ e, a ], [ t, r ]) && (n = !0);
                            }), n || (a = !1);
                        }), a);
                    },
                    object: function(e, n) {
                        var a, u, l, c, d, f = !0, m = [], p = [];
                        if (t(n, e) === !1) return !1;
                        r.push(n.constructor), s.push(n), o.push(e);
                        for (a in n) {
                            for (l = !1, u = 0; u < s.length; u++) if (c = s[u] === n[a], d = o[u] === e[a], 
                            c || d) {
                                if (!(n[a] === e[a] || c && d)) {
                                    f = !1;
                                    break;
                                }
                                l = !0;
                            }
                            if (m.push(a), !l && !i(n[a], e[a])) {
                                f = !1;
                                break;
                            }
                        }
                        s.pop(), o.pop(), r.pop();
                        for (a in e) p.push(a);
                        return f && i(m.sort(), p.sort());
                    }
                };
                return i;
            }(), j.dump = function() {
                function e(e) {
                    return '"' + e.toString().replace(/\\/g, "\\\\").replace(/"/g, '\\"') + '"';
                }
                function t(e) {
                    return e + "";
                }
                function n(e, t, n) {
                    var a = r.separator(), i = r.indent(), s = r.indent(1);
                    return t.join && (t = t.join("," + a + s)), t ? [ e, s + t, i + n ].join(a) : e + n;
                }
                function a(e, t) {
                    var a = e.length, i = new Array(a);
                    if (r.maxDepth && r.depth > r.maxDepth) return "[object Array]";
                    for (this.up(); a--; ) i[a] = this.parse(e[a], void 0, t);
                    return this.down(), n("[", i, "]");
                }
                var i = /^function (\w+)/, r = {
                    parse: function(e, t, n) {
                        n = n || [];
                        var a, i, r, o = s(e, n);
                        return o !== -1 ? "recursion(" + (o - n.length) + ")" : (t = t || this.typeOf(e), 
                        i = this.parsers[t], r = typeof i, "function" === r ? (n.push(e), a = i.call(this, e, n), 
                        n.pop(), a) : "string" === r ? i : this.parsers.error);
                    },
                    typeOf: function(e) {
                        var t;
                        return t = null === e ? "null" : "undefined" == typeof e ? "undefined" : j.is("regexp", e) ? "regexp" : j.is("date", e) ? "date" : j.is("function", e) ? "function" : void 0 !== e.setInterval && void 0 !== e.document && void 0 === e.nodeType ? "window" : 9 === e.nodeType ? "document" : e.nodeType ? "node" : "[object Array]" === q.call(e) || "number" == typeof e.length && void 0 !== e.item && (e.length ? e.item(0) === e[0] : null === e.item(0) && void 0 === e[0]) ? "array" : e.constructor === Error.prototype.constructor ? "error" : typeof e;
                    },
                    separator: function() {
                        return this.multiline ? this.HTML ? "<br />" : "\n" : this.HTML ? "&#160;" : " ";
                    },
                    indent: function(e) {
                        if (!this.multiline) return "";
                        var t = this.indentChar;
                        return this.HTML && (t = t.replace(/\t/g, "   ").replace(/ /g, "&#160;")), new Array(this.depth + (e || 0)).join(t);
                    },
                    up: function(e) {
                        this.depth += e || 1;
                    },
                    down: function(e) {
                        this.depth -= e || 1;
                    },
                    setParser: function(e, t) {
                        this.parsers[e] = t;
                    },
                    quote: e,
                    literal: t,
                    join: n,
                    depth: 1,
                    maxDepth: j.config.maxDepth,
                    parsers: {
                        window: "[Window]",
                        document: "[Document]",
                        error: function(e) {
                            return 'Error("' + e.message + '")';
                        },
                        unknown: "[Unknown]",
                        null: "null",
                        undefined: "undefined",
                        function: function(e) {
                            var t = "function", a = "name" in e ? e.name : (i.exec(e) || [])[1];
                            return a && (t += " " + a), t += "(", t = [ t, r.parse(e, "functionArgs"), "){" ].join(""), 
                            n(t, r.parse(e, "functionCode"), "}");
                        },
                        array: a,
                        nodelist: a,
                        arguments: a,
                        object: function(e, t) {
                            var a, i, o, u, l, c = [];
                            if (r.maxDepth && r.depth > r.maxDepth) return "[object Object]";
                            r.up(), a = [];
                            for (i in e) a.push(i);
                            l = [ "message", "name" ];
                            for (u in l) i = l[u], i in e && s(i, a) < 0 && a.push(i);
                            for (a.sort(), u = 0; u < a.length; u++) i = a[u], o = e[i], c.push(r.parse(i, "key") + ": " + r.parse(o, void 0, t));
                            return r.down(), n("{", c, "}");
                        },
                        node: function(e) {
                            var t, n, a, i = r.HTML ? "&lt;" : "<", s = r.HTML ? "&gt;" : ">", o = e.nodeName.toLowerCase(), u = i + o, l = e.attributes;
                            if (l) for (n = 0, t = l.length; n < t; n++) a = l[n].nodeValue, a && "inherit" !== a && (u += " " + l[n].nodeName + "=" + r.parse(a, "attribute"));
                            return u += s, 3 !== e.nodeType && 4 !== e.nodeType || (u += e.nodeValue), u + i + "/" + o + s;
                        },
                        functionArgs: function(e) {
                            var t, n = e.length;
                            if (!n) return "";
                            for (t = new Array(n); n--; ) t[n] = String.fromCharCode(97 + n);
                            return " " + t.join(", ") + " ";
                        },
                        key: e,
                        functionCode: "[code]",
                        attribute: e,
                        string: e,
                        date: e,
                        regexp: t,
                        number: t,
                        boolean: t
                    },
                    HTML: !1,
                    indentChar: "  ",
                    multiline: !0
                };
                return r;
            }(), j.jsDump = j.dump, function() {
                function e(e) {
                    return function() {
                        var t = new E(j.config.current);
                        e.apply(t, arguments);
                    };
                }
                var t, n = E.prototype;
                for (t in n) j[t] = e(n[t]);
            }(), U.document && (!function() {
                var e, t, n = [ "test", "module", "expect", "asyncTest", "start", "stop", "ok", "notOk", "equal", "notEqual", "propEqual", "notPropEqual", "deepEqual", "notDeepEqual", "strictEqual", "notStrictEqual", "throws", "raises" ];
                for (e = 0, t = n.length; e < t; e++) F[n[e]] = j[n[e]];
            }(), F.QUnit = j), "undefined" != typeof i && i && i.exports && (i.exports = j, 
            i.exports.QUnit = j), "undefined" != typeof t && t && (t.QUnit = j), a = function() {
                return j;
            }.call(t, n, t, i), !(void 0 !== a && (i.exports = a)), j.config.autostart = !1;
        }(function() {
            return this;
        }()), function() {
            function e() {
                var e, t, n, a, i = {}, r = S.search.slice(1).split("&"), s = r.length;
                for (e = 0; e < s; e++) r[e] && (t = r[e].split("="), n = decodeURIComponent(t[0]), 
                a = 1 === t.length || decodeURIComponent(t.slice(1).join("=")), i[n] ? i[n] = [].concat(i[n], a) : i[n] = a);
                return i;
            }
            function t(e) {
                return e ? (e += "", e.replace(/['"<>&]/g, function(e) {
                    switch (e) {
                      case "'":
                        return "&#039;";

                      case '"':
                        return "&quot;";

                      case "<":
                        return "&lt;";

                      case ">":
                        return "&gt;";

                      case "&":
                        return "&amp;";
                    }
                })) : "";
            }
            function n(e, t, n) {
                e.addEventListener ? e.addEventListener(t, n, !1) : e.attachEvent && e.attachEvent("on" + t, function() {
                    var t = window.event;
                    t.target || (t.target = t.srcElement || E), n.call(e, t);
                });
            }
            function a(e, t, a) {
                for (var i = e.length; i--; ) n(e[i], t, a);
            }
            function i(e, t) {
                return (" " + e.className + " ").indexOf(" " + t + " ") >= 0;
            }
            function r(e, t) {
                i(e, t) || (e.className += (e.className ? " " : "") + t);
            }
            function s(e, t, n) {
                n || "undefined" == typeof n && !i(e, t) ? r(e, t) : o(e, t);
            }
            function o(e, t) {
                for (var n = " " + e.className + " "; n.indexOf(" " + t + " ") >= 0; ) n = n.replace(" " + t + " ", " ");
                e.className = "function" == typeof n.trim ? n.trim() : n.replace(/^\s+|\s+$/g, "");
            }
            function u(e) {
                return E.getElementById && E.getElementById(e);
            }
            function l() {
                var e, n, a, i, r, s = !1, o = C.urlConfig, u = "";
                for (e = 0; e < o.length; e++) if (a = C.urlConfig[e], "string" == typeof a && (a = {
                    id: a,
                    label: a
                }), i = t(a.id), r = t(a.tooltip), a.value && "string" != typeof a.value) {
                    if (u += "<label for='qunit-urlconfig-" + i + "' title='" + r + "'>" + a.label + ": </label><select id='qunit-urlconfig-" + i + "' name='" + i + "' title='" + r + "'><option></option>", 
                    QUnit.is("array", a.value)) for (n = 0; n < a.value.length; n++) i = t(a.value[n]), 
                    u += "<option value='" + i + "'" + (C[a.id] === a.value[n] ? (s = !0) && " selected='selected'" : "") + ">" + i + "</option>"; else for (n in a.value) j.call(a.value, n) && (u += "<option value='" + t(n) + "'" + (C[a.id] === n ? (s = !0) && " selected='selected'" : "") + ">" + t(a.value[n]) + "</option>");
                    C[a.id] && !s && (i = t(C[a.id]), u += "<option value='" + i + "' selected='selected' disabled='disabled'>" + i + "</option>"), 
                    u += "</select>";
                } else u += "<input id='qunit-urlconfig-" + i + "' name='" + i + "' type='checkbox'" + (a.value ? " value='" + t(a.value) + "'" : "") + (C[a.id] ? " checked='checked'" : "") + " title='" + r + "' /><label for='qunit-urlconfig-" + i + "' title='" + r + "'>" + a.label + "</label>";
                return u;
            }
            function c() {
                var e, t, n, a = this, i = {};
                t = "selectedIndex" in a ? a.options[a.selectedIndex].value || void 0 : a.checked ? a.defaultValue || !0 : void 0, 
                i[a.name] = t, e = d(i), "hidepassed" === a.name && "replaceState" in window.history ? (QUnit.urlParams[a.name] = t, 
                C[a.name] = t || !1, n = u("qunit-tests"), n && s(n, "hidepass", t || !1), window.history.replaceState(null, "", e)) : window.location = e;
            }
            function d(e) {
                var t, n, a, i = "?", r = window.location;
                e = QUnit.extend(QUnit.extend({}, QUnit.urlParams), e);
                for (t in e) if (j.call(e, t) && void 0 !== e[t]) for (n = [].concat(e[t]), a = 0; a < n.length; a++) i += encodeURIComponent(t), 
                n[a] !== !0 && (i += "=" + encodeURIComponent(n[a])), i += "&";
                return r.protocol + "//" + r.host + r.pathname + i.slice(0, -1);
            }
            function f() {
                var e, t = u("qunit-modulefilter"), n = u("qunit-filter-input").value;
                e = t ? decodeURIComponent(t.options[t.selectedIndex].value) : void 0, window.location = d({
                    module: "" === e ? void 0 : e,
                    filter: "" === n ? void 0 : n,
                    moduleId: void 0,
                    testId: void 0
                });
            }
            function m() {
                var e = E.createElement("span");
                return e.innerHTML = l(), r(e, "qunit-url-config"), a(e.getElementsByTagName("input"), "click", c), 
                a(e.getElementsByTagName("select"), "change", c), e;
            }
            function p() {
                var e = E.createElement("form"), t = E.createElement("label"), a = E.createElement("input"), i = E.createElement("button");
                return r(e, "qunit-filter"), t.innerHTML = "Filter: ", a.type = "text", a.value = C.filter || "", 
                a.name = "filter", a.id = "qunit-filter-input", i.innerHTML = "Go", t.appendChild(a), 
                e.appendChild(t), e.appendChild(i), n(e, "submit", function(e) {
                    return f(), e && e.preventDefault && e.preventDefault(), !1;
                }), e;
            }
            function h() {
                var e, n = "";
                if (!I.length) return !1;
                for (n += "<label for='qunit-modulefilter'>Module: </label><select id='qunit-modulefilter' name='modulefilter'><option value='' " + (void 0 === QUnit.urlParams.module ? "selected='selected'" : "") + ">< All Modules ></option>", 
                e = 0; e < I.length; e++) n += "<option value='" + t(encodeURIComponent(I[e])) + "' " + (QUnit.urlParams.module === I[e] ? "selected='selected'" : "") + ">" + t(I[e]) + "</option>";
                return n += "</select>";
            }
            function g() {
                var e = u("qunit-testrunner-toolbar"), t = E.createElement("span"), a = h();
                return !(!e || !a) && (t.setAttribute("id", "qunit-modulefilter-container"), t.innerHTML = a, 
                n(t.lastChild, "change", f), void e.appendChild(t));
            }
            function _() {
                var e = u("qunit-testrunner-toolbar");
                e && (e.appendChild(m()), e.appendChild(p()), g());
            }
            function v() {
                var e = u("qunit-header");
                e && (e.innerHTML = "<a href='" + t(A) + "'>" + e.innerHTML + "</a> ");
            }
            function b() {
                var e = u("qunit-banner");
                e && (e.className = "");
            }
            function y() {
                var e = u("qunit-tests"), t = u("qunit-testresult");
                t && t.parentNode.removeChild(t), e && (e.innerHTML = "", t = E.createElement("p"), 
                t.id = "qunit-testresult", t.className = "result", e.parentNode.insertBefore(t, e), 
                t.innerHTML = "Running...<br />&#160;");
            }
            function M() {
                var e = u("qunit-fixture");
                e && (C.fixture = e.innerHTML);
            }
            function $() {
                var e = QUnit.config.testId;
                return !e || e.length <= 0 ? "" : "<div id='qunit-filteredTest'>Rerunning selected tests: " + t(e.join(", ")) + " <a id='qunit-clearFilter' href='" + t(A) + "'>Run all tests</a></div>";
            }
            function k() {
                var e = u("qunit-userAgent");
                e && (e.innerHTML = "", e.appendChild(E.createTextNode("QUnit " + QUnit.version + "; " + navigator.userAgent)));
            }
            function w() {
                var e = u("qunit");
                e && (e.innerHTML = "<h1 id='qunit-header'>" + t(E.title) + "</h1><h2 id='qunit-banner'></h2><div id='qunit-testrunner-toolbar'></div>" + $() + "<h2 id='qunit-userAgent'></h2><ol id='qunit-tests'></ol>"), 
                v(), b(), y(), k(), _();
            }
            function L(e) {
                var t, n, a, i, r, s;
                for (t = 0, n = e.length; t < n; t++) for (s = e[t], a = 0, i = s.tests.length; a < i; a++) r = s.tests[a], 
                D(r.name, r.testId, s.name);
            }
            function D(e, t, n) {
                var a, i, r, s, o = u("qunit-tests");
                o && (a = E.createElement("strong"), a.innerHTML = Y(e, n), i = E.createElement("a"), 
                i.innerHTML = "Rerun", i.href = d({
                    testId: t
                }), r = E.createElement("li"), r.appendChild(a), r.appendChild(i), r.id = "qunit-test-output-" + t, 
                s = E.createElement("ol"), s.className = "qunit-assert-list", r.appendChild(s), 
                o.appendChild(r));
            }
            function Y(e, n) {
                var a = "";
                return n && (a = "<span class='module-name'>" + t(n) + "</span>: "), a += "<span class='test-name'>" + t(e) + "</span>";
            }
            function T(e) {
                return e.replace(/<\/?[^>]+(>|$)/g, "").replace(/\&quot;/g, "").replace(/\s+/g, "");
            }
            var S = "undefined" != typeof window && window.location;
            if (S) {
                var x = e();
                if (QUnit.urlParams = x, QUnit.config.moduleId = [].concat(x.moduleId || []), QUnit.config.testId = [].concat(x.testId || []), 
                QUnit.config.module = x.module, QUnit.config.filter = x.filter, x.seed === !0 ? QUnit.config.seed = Math.random().toString(36).slice(2) : x.seed && (QUnit.config.seed = x.seed), 
                QUnit.config.urlConfig.push({
                    id: "hidepassed",
                    label: "Hide passed tests",
                    tooltip: "Only show tests and assertions that fail. Stored as query-strings."
                }, {
                    id: "noglobals",
                    label: "Check for Globals",
                    tooltip: "Enabling this will test if any test introduces new properties on the global object (`window` in Browsers). Stored as query-strings."
                }, {
                    id: "notrycatch",
                    label: "No try-catch",
                    tooltip: "Enabling this will run tests outside of a try-catch block. Makes debugging exceptions in IE reasonable. Stored as query-strings."
                }), QUnit.begin(function() {
                    var e, t, n = QUnit.config.urlConfig;
                    for (e = 0; e < n.length; e++) t = QUnit.config.urlConfig[e], "string" != typeof t && (t = t.id), 
                    void 0 === QUnit.config[t] && (QUnit.config[t] = x[t]);
                }), "undefined" != typeof window && window.document) {
                    QUnit.init = function() {
                        var e = QUnit.config;
                        e.stats = {
                            all: 0,
                            bad: 0
                        }, e.moduleStats = {
                            all: 0,
                            bad: 0
                        }, e.started = 0, e.updateRate = 1e3, e.blocking = !1, e.autostart = !0, e.autorun = !1, 
                        e.filter = "", e.queue = [], w();
                    };
                    var C = QUnit.config, E = window.document, H = !1, j = Object.prototype.hasOwnProperty, A = d({
                        filter: void 0,
                        module: void 0,
                        moduleId: void 0,
                        testId: void 0
                    }), O = {
                        sessionStorage: function() {
                            var e = "qunit-test-string";
                            try {
                                return sessionStorage.setItem(e, e), sessionStorage.removeItem(e), !0;
                            } catch (e) {
                                return !1;
                            }
                        }()
                    }, I = [];
                    QUnit.begin(function(e) {
                        var t, n, a;
                        for (t = 0; t < e.modules.length; t++) n = e.modules[t], n.name && I.push(n.name);
                        I.sort(function(e, t) {
                            return e.localeCompare(t);
                        }), M(), w(), L(e.modules), a = u("qunit-tests"), a && C.hidepassed && r(a, "hidepass");
                    }), QUnit.done(function(e) {
                        var t, n, a = u("qunit-banner"), i = u("qunit-tests"), r = [ "Tests completed in ", e.runtime, " milliseconds.<br />", "<span class='passed'>", e.passed, "</span> assertions of <span class='total'>", e.total, "</span> passed, <span class='failed'>", e.failed, "</span> failed." ].join("");
                        if (a && (a.className = e.failed ? "qunit-fail" : "qunit-pass"), i && (u("qunit-testresult").innerHTML = r), 
                        C.altertitle && E.title && (E.title = [ e.failed ? "✖" : "✔", E.title.replace(/^[\u2714\u2716] /i, "") ].join(" ")), 
                        C.reorder && O.sessionStorage && 0 === e.failed) for (t = 0; t < sessionStorage.length; t++) n = sessionStorage.key(t++), 
                        0 === n.indexOf("qunit-test-") && sessionStorage.removeItem(n);
                        C.scrolltop && window.scrollTo && window.scrollTo(0, 0);
                    }), QUnit.testStart(function(e) {
                        var t, n, a;
                        n = u("qunit-test-output-" + e.testId), n ? n.className = "running" : D(e.name, e.testId, e.module), 
                        t = u("qunit-testresult"), t && (a = QUnit.config.reorder && O.sessionStorage && +sessionStorage.getItem("qunit-test-" + e.module + "-" + e.name), 
                        t.innerHTML = (a ? "Rerunning previously failed test: <br />" : "Running: <br />") + Y(e.name, e.module));
                    }), QUnit.log(function(e) {
                        var n, a, i, r, s, o, l = !1, c = u("qunit-test-output-" + e.testId);
                        c && (i = t(e.message) || (e.result ? "okay" : "failed"), i = "<span class='test-message'>" + i + "</span>", 
                        i += "<span class='runtime'>@ " + e.runtime + " ms</span>", !e.result && j.call(e, "expected") ? (r = e.negative ? "NOT " + QUnit.dump.parse(e.expected) : QUnit.dump.parse(e.expected), 
                        s = QUnit.dump.parse(e.actual), i += "<table><tr class='test-expected'><th>Expected: </th><td><pre>" + t(r) + "</pre></td></tr>", 
                        s !== r ? (i += "<tr class='test-actual'><th>Result: </th><td><pre>" + t(s) + "</pre></td></tr>", 
                        /^(true|false)$/.test(s) || /^(true|false)$/.test(r) || (o = QUnit.diff(r, s), l = T(o).length !== T(r).length + T(s).length), 
                        l && (i += "<tr class='test-diff'><th>Diff: </th><td><pre>" + o + "</pre></td></tr>")) : i += r.indexOf("[object Array]") !== -1 || r.indexOf("[object Object]") !== -1 ? "<tr class='test-message'><th>Message: </th><td>Diff suppressed as the depth of object is more than current max depth (" + QUnit.config.maxDepth + ").<p>Hint: Use <code>QUnit.dump.maxDepth</code> to  run with a higher max depth or <a href='" + t(d({
                            maxDepth: -1
                        })) + "'>Rerun</a> without max depth.</p></td></tr>" : "<tr class='test-message'><th>Message: </th><td>Diff suppressed as the expected and actual results have an equivalent serialization</td></tr>", 
                        e.source && (i += "<tr class='test-source'><th>Source: </th><td><pre>" + t(e.source) + "</pre></td></tr>"), 
                        i += "</table>") : !e.result && e.source && (i += "<table><tr class='test-source'><th>Source: </th><td><pre>" + t(e.source) + "</pre></td></tr></table>"), 
                        n = c.getElementsByTagName("ol")[0], a = E.createElement("li"), a.className = e.result ? "pass" : "fail", 
                        a.innerHTML = i, n.appendChild(a));
                    }), QUnit.testDone(function(e) {
                        var t, a, i, o, l, c, d, f, m, p = u("qunit-tests");
                        p && (i = u("qunit-test-output-" + e.testId), o = i.getElementsByTagName("ol")[0], 
                        l = e.passed, c = e.failed, C.reorder && O.sessionStorage && (c ? sessionStorage.setItem("qunit-test-" + e.module + "-" + e.name, c) : sessionStorage.removeItem("qunit-test-" + e.module + "-" + e.name)), 
                        0 === c ? r(o, "qunit-collapsed") : c && C.collapse && !H ? H = !0 : r(o, "qunit-collapsed"), 
                        t = i.firstChild, d = c ? "<b class='failed'>" + c + "</b>, <b class='passed'>" + l + "</b>, " : "", 
                        t.innerHTML += " <b class='counts'>(" + d + e.assertions.length + ")</b>", e.skipped ? (i.className = "skipped", 
                        f = E.createElement("em"), f.className = "qunit-skipped-label", f.innerHTML = "skipped", 
                        i.insertBefore(f, t)) : (n(t, "click", function() {
                            s(o, "qunit-collapsed");
                        }), i.className = c ? "fail" : "pass", a = E.createElement("span"), a.className = "runtime", 
                        a.innerHTML = e.runtime + " ms", i.insertBefore(a, o)), e.source && (m = E.createElement("p"), 
                        m.innerHTML = "<strong>Source: </strong>" + e.source, r(m, "qunit-source"), 0 === c && r(m, "qunit-collapsed"), 
                        n(t, "click", function() {
                            s(m, "qunit-collapsed");
                        }), i.appendChild(m)));
                    });
                    var P = function(e) {
                        return !(e && e.version && e.version.major > 0);
                    }(window.phantom);
                    P && "complete" === E.readyState ? QUnit.load() : n(window, "load", QUnit.load), 
                    QUnit.diff = function() {
                        function e() {}
                        var n = -1, a = 1, i = 0;
                        return e.prototype.DiffMain = function(e, t, n) {
                            var a, r, s, o, u, l;
                            if (a = new Date().getTime() + 1e3, null === e || null === t) throw new Error("Null input. (DiffMain)");
                            return e === t ? e ? [ [ i, e ] ] : [] : ("undefined" == typeof n && (n = !0), r = n, 
                            s = this.diffCommonPrefix(e, t), o = e.substring(0, s), e = e.substring(s), t = t.substring(s), 
                            s = this.diffCommonSuffix(e, t), u = e.substring(e.length - s), e = e.substring(0, e.length - s), 
                            t = t.substring(0, t.length - s), l = this.diffCompute(e, t, r, a), o && l.unshift([ i, o ]), 
                            u && l.push([ i, u ]), this.diffCleanupMerge(l), l);
                        }, e.prototype.diffCleanupEfficiency = function(e) {
                            var t, r, s, o, u, l, c, d, f;
                            for (t = !1, r = [], s = 0, o = null, u = 0, l = !1, c = !1, d = !1, f = !1; u < e.length; ) e[u][0] === i ? (e[u][1].length < 4 && (d || f) ? (r[s++] = u, 
                            l = d, c = f, o = e[u][1]) : (s = 0, o = null), d = f = !1) : (e[u][0] === n ? f = !0 : d = !0, 
                            o && (l && c && d && f || o.length < 2 && l + c + d + f === 3) && (e.splice(r[s - 1], 0, [ n, o ]), 
                            e[r[s - 1] + 1][0] = a, s--, o = null, l && c ? (d = f = !0, s = 0) : (s--, u = s > 0 ? r[s - 1] : -1, 
                            d = f = !1), t = !0)), u++;
                            t && this.diffCleanupMerge(e);
                        }, e.prototype.diffPrettyHtml = function(e) {
                            var r, s, o, u = [];
                            for (o = 0; o < e.length; o++) switch (r = e[o][0], s = e[o][1], r) {
                              case a:
                                u[o] = "<ins>" + t(s) + "</ins>";
                                break;

                              case n:
                                u[o] = "<del>" + t(s) + "</del>";
                                break;

                              case i:
                                u[o] = "<span>" + t(s) + "</span>";
                            }
                            return u.join("");
                        }, e.prototype.diffCommonPrefix = function(e, t) {
                            var n, a, i, r;
                            if (!e || !t || e.charAt(0) !== t.charAt(0)) return 0;
                            for (i = 0, a = Math.min(e.length, t.length), n = a, r = 0; i < n; ) e.substring(r, n) === t.substring(r, n) ? (i = n, 
                            r = i) : a = n, n = Math.floor((a - i) / 2 + i);
                            return n;
                        }, e.prototype.diffCommonSuffix = function(e, t) {
                            var n, a, i, r;
                            if (!e || !t || e.charAt(e.length - 1) !== t.charAt(t.length - 1)) return 0;
                            for (i = 0, a = Math.min(e.length, t.length), n = a, r = 0; i < n; ) e.substring(e.length - n, e.length - r) === t.substring(t.length - n, t.length - r) ? (i = n, 
                            r = i) : a = n, n = Math.floor((a - i) / 2 + i);
                            return n;
                        }, e.prototype.diffCompute = function(e, t, r, s) {
                            var o, u, l, c, d, f, m, p, h, g, _, v;
                            return e ? t ? (u = e.length > t.length ? e : t, l = e.length > t.length ? t : e, 
                            c = u.indexOf(l), c !== -1 ? (o = [ [ a, u.substring(0, c) ], [ i, l ], [ a, u.substring(c + l.length) ] ], 
                            e.length > t.length && (o[0][0] = o[2][0] = n), o) : 1 === l.length ? [ [ n, e ], [ a, t ] ] : (d = this.diffHalfMatch(e, t), 
                            d ? (f = d[0], p = d[1], m = d[2], h = d[3], g = d[4], _ = this.DiffMain(f, m, r, s), 
                            v = this.DiffMain(p, h, r, s), _.concat([ [ i, g ] ], v)) : r && e.length > 100 && t.length > 100 ? this.diffLineMode(e, t, s) : this.diffBisect(e, t, s))) : [ [ n, e ] ] : [ [ a, t ] ];
                        }, e.prototype.diffHalfMatch = function(e, t) {
                            function n(e, t, n) {
                                var a, i, s, o, u, l, c, d, f;
                                for (a = e.substring(n, n + Math.floor(e.length / 4)), i = -1, s = ""; (i = t.indexOf(a, i + 1)) !== -1; ) o = r.diffCommonPrefix(e.substring(n), t.substring(i)), 
                                u = r.diffCommonSuffix(e.substring(0, n), t.substring(0, i)), s.length < u + o && (s = t.substring(i - u, i) + t.substring(i, i + o), 
                                l = e.substring(0, n - u), c = e.substring(n + o), d = t.substring(0, i - u), f = t.substring(i + o));
                                return 2 * s.length >= e.length ? [ l, c, d, f, s ] : null;
                            }
                            var a, i, r, s, o, u, l, c, d, f, m;
                            return a = e.length > t.length ? e : t, i = e.length > t.length ? t : e, a.length < 4 || 2 * i.length < a.length ? null : (r = this, 
                            d = n(a, i, Math.ceil(a.length / 4)), f = n(a, i, Math.ceil(a.length / 2)), d || f ? (m = f ? d && d[4].length > f[4].length ? d : f : d, 
                            e.length > t.length ? (s = m[0], l = m[1], u = m[2], o = m[3]) : (u = m[0], o = m[1], 
                            s = m[2], l = m[3]), c = m[4], [ s, l, u, o, c ]) : null);
                        }, e.prototype.diffLineMode = function(e, t, r) {
                            var s, o, u, l, c, d, f, m, p;
                            for (s = this.diffLinesToChars(e, t), e = s.chars1, t = s.chars2, u = s.lineArray, 
                            o = this.DiffMain(e, t, !1, r), this.diffCharsToLines(o, u), this.diffCleanupSemantic(o), 
                            o.push([ i, "" ]), l = 0, d = 0, c = 0, m = "", f = ""; l < o.length; ) {
                                switch (o[l][0]) {
                                  case a:
                                    c++, f += o[l][1];
                                    break;

                                  case n:
                                    d++, m += o[l][1];
                                    break;

                                  case i:
                                    if (d >= 1 && c >= 1) {
                                        for (o.splice(l - d - c, d + c), l = l - d - c, s = this.DiffMain(m, f, !1, r), 
                                        p = s.length - 1; p >= 0; p--) o.splice(l, 0, s[p]);
                                        l += s.length;
                                    }
                                    c = 0, d = 0, m = "", f = "";
                                }
                                l++;
                            }
                            return o.pop(), o;
                        }, e.prototype.diffBisect = function(e, t, i) {
                            var r, s, o, u, l, c, d, f, m, p, h, g, _, v, b, y, M, $, k, w, L, D, Y;
                            for (r = e.length, s = t.length, o = Math.ceil((r + s) / 2), u = o, l = 2 * o, c = new Array(l), 
                            d = new Array(l), f = 0; f < l; f++) c[f] = -1, d[f] = -1;
                            for (c[u + 1] = 0, d[u + 1] = 0, m = r - s, p = m % 2 !== 0, h = 0, g = 0, _ = 0, 
                            v = 0, L = 0; L < o && !(new Date().getTime() > i); L++) {
                                for (D = -L + h; D <= L - g; D += 2) {
                                    for (y = u + D, M = D === -L || D !== L && c[y - 1] < c[y + 1] ? c[y + 1] : c[y - 1] + 1, 
                                    k = M - D; M < r && k < s && e.charAt(M) === t.charAt(k); ) M++, k++;
                                    if (c[y] = M, M > r) g += 2; else if (k > s) h += 2; else if (p && (b = u + m - D, 
                                    b >= 0 && b < l && d[b] !== -1 && ($ = r - d[b], M >= $))) return this.diffBisectSplit(e, t, M, k, i);
                                }
                                for (Y = -L + _; Y <= L - v; Y += 2) {
                                    for (b = u + Y, $ = Y === -L || Y !== L && d[b - 1] < d[b + 1] ? d[b + 1] : d[b - 1] + 1, 
                                    w = $ - Y; $ < r && w < s && e.charAt(r - $ - 1) === t.charAt(s - w - 1); ) $++, 
                                    w++;
                                    if (d[b] = $, $ > r) v += 2; else if (w > s) _ += 2; else if (!p && (y = u + m - Y, 
                                    y >= 0 && y < l && c[y] !== -1 && (M = c[y], k = u + M - y, $ = r - $, M >= $))) return this.diffBisectSplit(e, t, M, k, i);
                                }
                            }
                            return [ [ n, e ], [ a, t ] ];
                        }, e.prototype.diffBisectSplit = function(e, t, n, a, i) {
                            var r, s, o, u, l, c;
                            return r = e.substring(0, n), o = t.substring(0, a), s = e.substring(n), u = t.substring(a), 
                            l = this.DiffMain(r, o, !1, i), c = this.DiffMain(s, u, !1, i), l.concat(c);
                        }, e.prototype.diffCleanupSemantic = function(e) {
                            var t, r, s, o, u, l, c, d, f, m, p, h, g;
                            for (t = !1, r = [], s = 0, o = null, u = 0, d = 0, f = 0, l = 0, c = 0; u < e.length; ) e[u][0] === i ? (r[s++] = u, 
                            d = l, f = c, l = 0, c = 0, o = e[u][1]) : (e[u][0] === a ? l += e[u][1].length : c += e[u][1].length, 
                            o && o.length <= Math.max(d, f) && o.length <= Math.max(l, c) && (e.splice(r[s - 1], 0, [ n, o ]), 
                            e[r[s - 1] + 1][0] = a, s--, s--, u = s > 0 ? r[s - 1] : -1, d = 0, f = 0, l = 0, 
                            c = 0, o = null, t = !0)), u++;
                            for (t && this.diffCleanupMerge(e), u = 1; u < e.length; ) e[u - 1][0] === n && e[u][0] === a && (m = e[u - 1][1], 
                            p = e[u][1], h = this.diffCommonOverlap(m, p), g = this.diffCommonOverlap(p, m), 
                            h >= g ? (h >= m.length / 2 || h >= p.length / 2) && (e.splice(u, 0, [ i, p.substring(0, h) ]), 
                            e[u - 1][1] = m.substring(0, m.length - h), e[u + 1][1] = p.substring(h), u++) : (g >= m.length / 2 || g >= p.length / 2) && (e.splice(u, 0, [ i, m.substring(0, g) ]), 
                            e[u - 1][0] = a, e[u - 1][1] = p.substring(0, p.length - g), e[u + 1][0] = n, e[u + 1][1] = m.substring(g), 
                            u++), u++), u++;
                        }, e.prototype.diffCommonOverlap = function(e, t) {
                            var n, a, i, r, s, o, u;
                            if (n = e.length, a = t.length, 0 === n || 0 === a) return 0;
                            if (n > a ? e = e.substring(n - a) : n < a && (t = t.substring(0, n)), i = Math.min(n, a), 
                            e === t) return i;
                            for (r = 0, s = 1; ;) {
                                if (o = e.substring(i - s), u = t.indexOf(o), u === -1) return r;
                                s += u, 0 !== u && e.substring(i - s) !== t.substring(0, s) || (r = s, s++);
                            }
                        }, e.prototype.diffLinesToChars = function(e, t) {
                            function n(e) {
                                var t, n, r, s, o;
                                for (t = "", n = 0, r = -1, s = a.length; r < e.length - 1; ) r = e.indexOf("\n", n), 
                                r === -1 && (r = e.length - 1), o = e.substring(n, r + 1), n = r + 1, (i.hasOwnProperty ? i.hasOwnProperty(o) : void 0 !== i[o]) ? t += String.fromCharCode(i[o]) : (t += String.fromCharCode(s), 
                                i[o] = s, a[s++] = o);
                                return t;
                            }
                            var a, i, r, s;
                            return a = [], i = {}, a[0] = "", r = n(e), s = n(t), {
                                chars1: r,
                                chars2: s,
                                lineArray: a
                            };
                        }, e.prototype.diffCharsToLines = function(e, t) {
                            var n, a, i, r;
                            for (n = 0; n < e.length; n++) {
                                for (a = e[n][1], i = [], r = 0; r < a.length; r++) i[r] = t[a.charCodeAt(r)];
                                e[n][1] = i.join("");
                            }
                        }, e.prototype.diffCleanupMerge = function(e) {
                            var t, r, s, o, u, l, c, d, f;
                            for (e.push([ i, "" ]), t = 0, r = 0, s = 0, u = "", o = ""; t < e.length; ) switch (e[t][0]) {
                              case a:
                                s++, o += e[t][1], t++;
                                break;

                              case n:
                                r++, u += e[t][1], t++;
                                break;

                              case i:
                                r + s > 1 ? (0 !== r && 0 !== s && (l = this.diffCommonPrefix(o, u), 0 !== l && (t - r - s > 0 && e[t - r - s - 1][0] === i ? e[t - r - s - 1][1] += o.substring(0, l) : (e.splice(0, 0, [ i, o.substring(0, l) ]), 
                                t++), o = o.substring(l), u = u.substring(l)), l = this.diffCommonSuffix(o, u), 
                                0 !== l && (e[t][1] = o.substring(o.length - l) + e[t][1], o = o.substring(0, o.length - l), 
                                u = u.substring(0, u.length - l))), 0 === r ? e.splice(t - s, r + s, [ a, o ]) : 0 === s ? e.splice(t - r, r + s, [ n, u ]) : e.splice(t - r - s, r + s, [ n, u ], [ a, o ]), 
                                t = t - r - s + (r ? 1 : 0) + (s ? 1 : 0) + 1) : 0 !== t && e[t - 1][0] === i ? (e[t - 1][1] += e[t][1], 
                                e.splice(t, 1)) : t++, s = 0, r = 0, u = "", o = "";
                            }
                            for ("" === e[e.length - 1][1] && e.pop(), c = !1, t = 1; t < e.length - 1; ) e[t - 1][0] === i && e[t + 1][0] === i && (d = e[t][1], 
                            f = d.substring(d.length - e[t - 1][1].length), f === e[t - 1][1] ? (e[t][1] = e[t - 1][1] + e[t][1].substring(0, e[t][1].length - e[t - 1][1].length), 
                            e[t + 1][1] = e[t - 1][1] + e[t + 1][1], e.splice(t - 1, 1), c = !0) : d.substring(0, e[t + 1][1].length) === e[t + 1][1] && (e[t - 1][1] += e[t + 1][1], 
                            e[t][1] = e[t][1].substring(e[t + 1][1].length) + e[t + 1][1], e.splice(t + 1, 1), 
                            c = !0)), t++;
                            c && this.diffCleanupMerge(e);
                        }, function(t, n) {
                            var a, i, r;
                            return a = new e(), i = a.DiffMain(t, n), a.diffCleanupEfficiency(i), r = a.diffPrettyHtml(i);
                        };
                    }();
                }
            }
        }();
    }).call(t, n(248), n(63)(e));
}, function(e, t) {
    function n() {
        throw new Error("setTimeout has not been defined");
    }
    function a() {
        throw new Error("clearTimeout has not been defined");
    }
    function i(e) {
        if (c === setTimeout) return setTimeout(e, 0);
        if ((c === n || !c) && setTimeout) return c = setTimeout, setTimeout(e, 0);
        try {
            return c(e, 0);
        } catch (t) {
            try {
                return c.call(null, e, 0);
            } catch (t) {
                return c.call(this, e, 0);
            }
        }
    }
    function r(e) {
        if (d === clearTimeout) return clearTimeout(e);
        if ((d === a || !d) && clearTimeout) return d = clearTimeout, clearTimeout(e);
        try {
            return d(e);
        } catch (t) {
            try {
                return d.call(null, e);
            } catch (t) {
                return d.call(this, e);
            }
        }
    }
    function s() {
        h && m && (h = !1, m.length ? p = m.concat(p) : g = -1, p.length && o());
    }
    function o() {
        if (!h) {
            var e = i(s);
            h = !0;
            for (var t = p.length; t; ) {
                for (m = p, p = []; ++g < t; ) m && m[g].run();
                g = -1, t = p.length;
            }
            m = null, h = !1, r(e);
        }
    }
    function u(e, t) {
        this.fun = e, this.array = t;
    }
    function l() {}
    var c, d, f = e.exports = {};
    !function() {
        try {
            c = "function" == typeof setTimeout ? setTimeout : n;
        } catch (e) {
            c = n;
        }
        try {
            d = "function" == typeof clearTimeout ? clearTimeout : a;
        } catch (e) {
            d = a;
        }
    }();
    var m, p = [], h = !1, g = -1;
    f.nextTick = function(e) {
        var t = new Array(arguments.length - 1);
        if (arguments.length > 1) for (var n = 1; n < arguments.length; n++) t[n - 1] = arguments[n];
        p.push(new u(e, t)), 1 !== p.length || h || i(o);
    }, u.prototype.run = function() {
        this.fun.apply(null, this.array);
    }, f.title = "browser", f.browser = !0, f.env = {}, f.argv = [], f.version = "", 
    f.versions = {}, f.on = l, f.addListener = l, f.once = l, f.off = l, f.removeListener = l, 
    f.removeAllListeners = l, f.emit = l, f.prependListener = l, f.prependOnceListener = l, 
    f.listeners = function(e) {
        return [];
    }, f.binding = function(e) {
        throw new Error("process.binding is not supported");
    }, f.cwd = function() {
        return "/";
    }, f.chdir = function(e) {
        throw new Error("process.chdir is not supported");
    }, f.umask = function() {
        return 0;
    };
}, function(e, t, n) {
    var a, i;
    !function(r, s) {
        "use strict";
        a = s, i = "function" == typeof a ? a.call(t, n, t, e) : a, !(void 0 !== i && (e.exports = i));
    }(this, function() {
        "use strict";
        function e(e, t) {
            var n;
            for (n in t) t.hasOwnProperty(n) && ("undefined" == typeof t[n] ? delete e[n] : e[n] = t[n]);
            return e;
        }
        function t(e, t) {
            var n;
            for (n = 0; n < e.length; n += 1) if (e[n] === t) return n;
            return -1;
        }
        function n(e, n) {
            var a = t(e, n);
            return a !== -1 ? e.splice(a, 1) : [];
        }
        function a(e) {
            return "undefined" != typeof e && "undefined" != typeof e.requireExpects && e.requireExpects;
        }
        function i(e) {
            return !!e.result;
        }
        function r(e) {
            return !i(e);
        }
        function s(e) {
            return r(e) && "undefined" == typeof e.expected && "undefined" == typeof e.actual;
        }
        function o(e) {
            return e.replace(/(\r?\n)/g, "$&# ");
        }
        function u(e) {
            return e.replace(/^\s+/, "");
        }
        function l(e) {
            return e;
        }
        function c(e, t, n, a) {
            e.push(t + ": " + a(n));
        }
        function d(e, t, n, a, i) {
            e && "undefined" != typeof a && c(t, n, a, i);
        }
        function f(e, t) {
            return t ? e + " - " + o(t) : e;
        }
        function m(m, _, v) {
            function b(e) {
                return L.config[e];
            }
            function y(e) {
                if (i(e)) return e.message;
                var t = [];
                return e.message && t.push(e.message), b("showExpectationOnFailure") && !s(e) && (c(t, "expected", e.expected, S), 
                c(t, "got", e.actual, S)), d(b("showTestNameOnFailure"), t, "test", e.name, l), 
                d(b("showModuleNameOnFailure"), t, "module", e.module, l), d(b("showSourceOnFailure"), t, "source", e.source, u), 
                t.join(", ");
            }
            function M(e) {
                L.puts(L.config.initialCount + ".." + e);
            }
            function $(e) {
                var a;
                t(Y, e) !== -1 && (a = w.config[e], "undefined" != typeof a && n(a, T[e]));
            }
            function k(e) {
                var t;
                for (t = 0; t < e.length; t += 1) $(e[t]);
            }
            if (!m) throw new Error('should pass QUnit object reference. Please check QUnit\'s "require" path if you are using Node.js (or any CommonJS env).');
            if ("function" != typeof _) throw new Error("should pass print-like function");
            var w = m, L = {}, D = function(e, t) {
                v && "object" == typeof v && "undefined" != typeof v[e] && (_('# WARNING: Option "' + e + '" is deprecated and will be removed in future version.'), 
                t(v[e]));
            }, Y = [ "moduleStart", "testStart", "log", "testDone", "done" ], T = {}, S = function() {
                return "undefined" != typeof w.dump && "function" == typeof w.dump.parse ? function(e) {
                    return w.dump.parse(e);
                } : "undefined" != typeof w.jsDump && "function" == typeof w.jsDump.parse ? function(e) {
                    return w.jsDump.parse(e);
                } : l;
            }();
            return L.config = e({
                initialCount: 1,
                showModuleNameOnFailure: !0,
                showTestNameOnFailure: !0,
                showExpectationOnFailure: !0,
                showSourceOnFailure: !0
            }, v), D("noPlan", function(e) {
                _('# Now QUnit-TAP works as with "noPlan: true" by default. If you want to delare plan explicitly, please use "QUnit.config.requireExpects" option instead.'), 
                L.config.noPlan = e;
            }), D("count", function(e) {
                L.config.initialCount = e + 1;
            }), D("showDetailsOnFailure", function(e) {
                L.config.showModuleNameOnFailure = e, L.config.showTestNameOnFailure = e, L.config.showExpectationOnFailure = e, 
                L.config.showSourceOnFailure = e;
            }), L.VERSION = p, L.puts = _, L.count = L.config.initialCount - 1, L.expectedCount = L.config.initialCount - 1, 
            L.explain = S, L.note = function(e) {
                L.puts(o("# " + e));
            }, L.diag = function(e) {
                return L.note(e), !1;
            }, L.moduleStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                L.note("module: " + t);
            }, L.testStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                L.note("test: " + t);
            }, L.log = function(e) {
                var t = "";
                L.count += 1, r(e) && (t += "not "), t += "ok " + L.count, L.puts(f(t, y(e)));
            }, L.testDone = function() {
                a(w.config) && (L.expectedCount += w.config.current.expected);
            }, L.done = function() {
                ("undefined" == typeof L.config.noPlan || L.config.noPlan) && M(a(w.config) ? L.expectedCount : L.count);
            }, L.unsubscribe = function() {
                "undefined" != typeof w.config && k(0 === arguments.length ? Y : h.apply(arguments));
            }, function() {
                var e, t, n, a = g(w);
                for (t = 0; t < Y.length; t += 1) e = Y[t], n = a(w, L, e), T[e] = n;
            }(), L;
        }
        var p = "1.5.1", h = Array.prototype.slice, g = function(e) {
            return function(e, t, n) {
                var a = e[n], i = function() {
                    t[n].apply(t, h.apply(arguments));
                };
                return a(i), i;
            };
        };
        return m.qunitTap = function() {
            throw new Error('[BC BREAK] Since 1.4.0, QUnit-TAP exports single qunitTap function as module.exports. Therefore, require("qunit-tap") returns qunitTap function itself. Please fix your code if you are using Node.js (or any CommonJS env).');
        }, m;
    });
}, function(e, t, n) {
    (function(e) {
        "use strict";
        var t = !1;
        QUnit.config.autostart = !1;
        var n = window.onerror;
        window.onerror = null, QUnit.begin(function() {
            window.onerror = function(e, t, a) {
                var i = !1;
                return n && (i = n(e, t, a)), QUnit.config.current && QUnit.config.current.async && QUnit.start(), 
                i;
            };
        }), QUnit.moduleStart(function() {
            t = !0;
        }), QUnit.done(function() {
            console.log("phantom-tap-done"), window.onerror = null;
        });
        var a = /^((not )?ok [0-9]+ (- )?)(.*)$/;
        qunitTap(QUnit, function() {
            if (1 == arguments.length && QUnit.config.current) {
                var e = a.exec(arguments[0]);
                if (e) return void console.log(e[1] + QUnit.config.current.testName + ": " + e[4]);
            }
            console.log.apply(console, arguments);
        }), window.setTimeout(function() {
            t || (console.log("QUnit not started by test"), console.log("phantom-tap-error"));
        }, 2e4), window.tests_included = !0, e && e.exports && (e.exports = QUnit);
    }).call(t, n(63)(e));
}, function(e, t) {} ]);
//# sourceMappingURL=test-images.min.js.map