!function(e) {
    function t(a) {
        if (n[a]) return n[a].exports;
        var r = n[a] = {
            exports: {},
            id: a,
            loaded: !1
        };
        return e[a].call(r.exports, r, r.exports, t), r.loaded = !0, r.exports;
    }
    var n = {};
    return t.m = e, t.c = n, t.p = "", t(0);
}([ function(e, t, n) {
    "use strict";
    function a(e) {
        function t(e, t, r, s) {
            i.test(e, function() {
                a.expect(t), n([ "kubeLoader", function(e) {
                    e.reset(!0), r && e.handle(r);
                } ]), n(s);
            });
        }
        var n, a = i, s = r.module("registry.images.tests", [ "kubeClient", "registry.images" ]);
        t("filter containsTagImage", 7, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().containsTagImage("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.equal(n.length, 2, "number ofstreams"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n, "matched busybee"), 
            a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "matched juggs"), 
            n = e().containsTagImage("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.equal(n.length, 1, "one stream matched"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "other stream matched juggs"), 
            a.ok(!("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n), "other stream not busybee"), 
            n = e().containsTagImage("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.equal(n.length, 0, "no streams selected");
        } ]), t("filter taggedBy", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedBy(n);
            a.equal(r.length, 2, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in r, "matched busybee"), 
            a.ok("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in r, "matched juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedBy(n), a.equal(r.length, 0, "no images matched");
        } ]), t("filter taggedFirst", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedFirst(n);
            a.equal(r.length, 1, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in r, "matched busybee"), 
            a.ok(!("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in r), "didn't match juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedFirst(n), a.equal(r.length, 0, "no images matched");
        } ]), t("filter listTagNames", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().listTagNames("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.deepEqual(n, [ "marmalade/busybee:latest", "marmalade/juggs:extratag" ], "got right names"), 
            n = e().listTagNames("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.deepEqual(n, [ "marmalade/juggs:latest" ], "got another image tag name"), n = e().listTagNames("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.deepEqual(n, [], "no names returned");
        } ]), t("split dockerImageManifest", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("DockerImageManifest").name("sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7");
            a.equal(n.length, 1, "only manifest returned");
            var r = n["/internal/manifests/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.ok(!!r, "got right manifest"), a.equal(r.manifest.history[0].v1Compatibility.config.Hostname, "13709f13afe1", "parsed manifest and compat");
        } ]), t("filter dockerConfigLabels", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.equal(n.length, 1, "got one set of labels");
            var r = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.strictEqual(n, r, "cached results");
            var i = n["/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.deepEqual(i, {
                Test: "Value",
                version: "1.0"
            }, "got right labels");
        } ]), r.module("exceptionOverride", []).factory("$exceptionHandler", function() {
            return function(e, t) {
                throw e.message += ' (caused by "' + t + '")', e;
            };
        }), s.run([ "$injector", function(e) {
            n = function(t) {
                return e.invoke(t);
            }, i.start();
        } ]), r.bootstrap(document, [ "registry.images.tests" ]);
    }
    var r = n(32), i = n(246);
    n(235), a([ {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "busybee",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/busybee",
            uid: "4612c052-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/busybee",
            tags: [ {
                tag: "0.x",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "juggs",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/juggs",
            uid: "84e3a672-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/juggs",
            tags: [ {
                tag: "2.11",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
                    image: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
                } ]
            }, {
                tag: "2.5",
                items: [ {
                    created: "2016-01-06T08:21:46Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe",
                    image: "sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, {
                tag: "extratag",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "origin",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/origin",
            uid: "94813e0a-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/origin",
            tags: [ {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:22:10Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
                    image: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
                } ]
            } ]
        }
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
            selfLink: "/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
            selfLink: "/oapi/v1/images/sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
            selfLink: "/oapi/v1/images/sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
            selfLink: "/oapi/v1/images/sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
            selfLink: "/oapi/v1/images/sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
            selfLink: "/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
            selfLink: "/oapi/v1/images/sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            selfLink: "/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            annotations: {
                "openshift.io/image.managed": "true"
            }
        },
        dockerImageReference: "172.30.198.253:5000/marmalade/juggs@sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d",
            Parent: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
            Created: "2016-03-04T16:50:11Z",
            Container: "7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d",
            ContainerConfig: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "/bin/sh", "-c", "#(nop) LABEL version=1.0" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            DockerVersion: "1.9.1",
            Config: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "-c" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            Architecture: "amd64",
            Size: 126388696
        },
        dockerImageMetadataVersion: "1.0",
        dockerImageManifest: '{\n   "schemaVersion": 1,\n   "name": "marmalade/juggs",\n   "tag": "2.8",\n   "architecture": "amd64",\n   "fsLayers": [\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:74fc2669b7664c1705ea18d946fb92111a2904fdc69c24dc25db546923663c4b"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:8cbbdaf3178f15e3e23f5eb59c754d16511edf100ba0e57557e47c8a5924d422"\n      },\n      {\n         "blobSum": "sha256:bc66c3b5709234727e260b55c5553c2bf9608084419271b08bca484914624d84"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:f810322bba2c5f0a6dd58ba31eba0543baabb4533e479ab2db376aaa8064be55"\n      }\n   ],\n   "history": [\n      {\n         "v1Compatibility": "{\\"id\\":\\"fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d\\",\\"parent\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"created\\":\\"2016-03-04T16:50:11.993242911Z\\",\\"container\\":\\"7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL version=1.0\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"parent\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"created\\":\\"2016-03-04T16:50:06.235447946Z\\",\\"container\\":\\"a13a641996f5d0425de27a7fd80d30174e165acd7bf913432f899ab2f57e0154\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL Test=Value\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"parent\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"created\\":\\"2016-03-04T16:50:00.89289203Z\\",\\"container\\":\\"2a9474018a32f776c8470897e6600b6a62503a734ae2775a5fbedd9ba9b28307\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG simple\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"parent\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"created\\":\\"2016-03-04T16:49:55.64958347Z\\",\\"container\\":\\"6fc564cbd8a2f53f81e1be0cf8b2752448c9b51d69787706bd1a40efc4b53870\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG hello=test\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"parent\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"created\\":\\"2016-03-04T16:49:50.274796262Z\\",\\"container\\":\\"90360222ef8c7a4978c0a27542d78175b16cf1b559ea3a0c344c21d6596f8878\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ONBUILD ADD . /app/src\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"parent\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"created\\":\\"2016-03-04T16:49:43.316816134Z\\",\\"container\\":\\"ada3ba6c28f4d40ad447384f990d4a2075abf86b821cbd5b1f3b339aae2bda7b\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) STOPSIGNAL [SIGKILL]\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"parent\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"created\\":\\"2016-03-04T16:49:36.966840962Z\\",\\"container\\":\\"75a79bb684c3ff1a8b9bccd1f046e87f84b9da4722b8b45853602f0a69f4cb27\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"-c\\\\\\"]\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"parent\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"created\\":\\"2016-03-04T16:49:32.056781057Z\\",\\"container\\":\\"076b707ed7bf04602d56b714deb3270998c5b145520b925fc9d8029b28e1484e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ENTRYPOINT \\\\u0026{[\\\\\\"top\\\\\\" \\\\\\"-b\\\\\\"]}\\"],\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":null,\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"parent\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"created\\":\\"2016-03-04T16:49:27.230310779Z\\",\\"container\\":\\"b1fff8a998363845efbbc77e64e58a2ef8cd422896a40816fe5016a0d66c8804\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) USER [nobody:wheel]\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"parent\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"created\\":\\"2016-03-04T16:49:19.278707045Z\\",\\"container\\":\\"a9ec15a2ac6c962d3f7141f789e0a703f68b1b35386b226485a470fdc297c921\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:32d397773a81df8feb5d5baf04619f65e2a1e4fddf24bbceb85157ff7f0db752 in /usr/bin\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":125275044}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"parent\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"created\\":\\"2016-03-04T16:48:53.085321054Z\\",\\"container\\":\\"7749a20ab52bd8714b5cc2823d3c09767f574b8f2d4bd4393b37f0a4964f3376\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"/bin/sh\\\\\\" \\\\\\"-c\\\\\\" \\\\\\"\\\\\\\\\\\\\\"/echo-script\\\\\\\\\\\\\\"\\\\\\"]\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"parent\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"created\\":\\"2016-03-04T16:48:47.790555865Z\\",\\"container\\":\\"ab835892b5519c2d0ffd84e22fe3d971a4a80d9d3e31757c7dce5379b947887e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"chmod +x /echo-script\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"parent\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"created\\":\\"2016-03-04T16:48:42.037533681Z\\",\\"container\\":\\"e16228a90ccf6d29c214833ba202b94b467979f5db03797d0a27da8430509966\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:b35fc316562d0e29fa7ae1e767f3597811f4349e30aa74122b67965a103f817a in /\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"parent\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"created\\":\\"2016-03-04T16:48:36.879318282Z\\",\\"container\\":\\"a759048c873ac86cef61a9aec0ac72734cfe53feb7acd81a2b4975473675ed20\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) EXPOSE 8888/tcp\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"parent\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"created\\":\\"2016-03-04T16:48:31.254943299Z\\",\\"container\\":\\"0484d0202032d11f48613463684f344ddc4f238635dcb640774e00828251f57d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) MAINTAINER cockpit@example.com\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"parent\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:37.407805421Z\\",\\"container\\":\\"d23509cd0189de02bef382544ebfab515f29094f3c0e2f161fa7ce09afa8974e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"sh\\\\\\"]\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:36.792440427Z\\",\\"container\\":\\"13709f13afe11b7d4a007d2866afd20c5b783f0a89f4e6792a28102a4c12c473\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:7cdf7a89f6a004b2e9501317bd72bd863d93a51255d8f83b2ed3058d385a4938 in /\\"],\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":null,\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":1113554}"\n      }\n   ],\n   "signatures": [\n      {\n         "header": {\n            "jwk": {\n               "crv": "P-256",\n               "kid": "VQO7:TVYU:FARI:VIFC:P2YU:W23P:AC7V:7ZXR:I5RO:DTY4:NRES:MGXE",\n               "kty": "EC",\n               "x": "EsCEZHIfgzZDBsbCzgCng884FdTcwyQ8dZbhap2cpgo",\n               "y": "9Hlp74n2G2aMwzyvvM9G-8BbrXDp2dl9rt2RGbidQ8I"\n            },\n            "alg": "ES256"\n         },\n         "signature": "MFqsTUp-ci7Th-1r02bHj8eDh5xRg_WtjpN7WD4dI2Tuvg96fyGH6rf5bYKIjEVKz1_3Z42Ma06DDw8hSsMOGw",\n         "protected": "eyJmb3JtYXRMZW5ndGgiOjI3NjU1LCJmb3JtYXRUYWlsIjoiQ24wIiwidGltZSI6IjIwMTYtMDMtMDRUMTY6NTA6MzJaIn0"\n      }\n   ]\n}'
    } ]);
}, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    /**
	 * @license AngularJS v1.3.14
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a(e, t) {
            return t = t || Error, function() {
                var n, a, r = arguments[0], i = "[" + (e ? e + ":" : "") + r + "] ", s = arguments[1], o = arguments;
                for (n = i + s.replace(/\{\d+\}/g, function(e) {
                    var t = +e.slice(1, -1);
                    return t + 2 < o.length ? me(o[t + 2]) : e;
                }), n = n + "\nhttp://errors.angularjs.org/1.3.14/" + (e ? e + "/" : "") + r, a = 2; a < arguments.length; a++) n = n + (2 == a ? "?" : "&") + "p" + (a - 2) + "=" + encodeURIComponent(me(arguments[a]));
                return new t(n);
            };
        }
        function r(e) {
            if (null == e || w(e)) return !1;
            var t = e.length;
            return !(e.nodeType !== _a || !t) || (y(e) || ca(e) || 0 === t || "number" == typeof t && t > 0 && t - 1 in e);
        }
        function i(e, t, n) {
            var a, s;
            if (e) if (L(e)) for (a in e) "prototype" == a || "length" == a || "name" == a || e.hasOwnProperty && !e.hasOwnProperty(a) || t.call(n, e[a], a, e); else if (ca(e) || r(e)) {
                var o = "object" != typeof e;
                for (a = 0, s = e.length; a < s; a++) (o || a in e) && t.call(n, e[a], a, e);
            } else if (e.forEach && e.forEach !== i) e.forEach(t, n, e); else for (a in e) e.hasOwnProperty(a) && t.call(n, e[a], a, e);
            return e;
        }
        function s(e) {
            return Object.keys(e).sort();
        }
        function o(e, t, n) {
            for (var a = s(e), r = 0; r < a.length; r++) t.call(n, e[a[r]], a[r]);
            return a;
        }
        function u(e) {
            return function(t, n) {
                e(n, t);
            };
        }
        function l() {
            return ++ua;
        }
        function c(e, t) {
            t ? e.$$hashKey = t : delete e.$$hashKey;
        }
        function d(e) {
            for (var t = e.$$hashKey, n = 1, a = arguments.length; n < a; n++) {
                var r = arguments[n];
                if (r) for (var i = Object.keys(r), s = 0, o = i.length; s < o; s++) {
                    var u = i[s];
                    e[u] = r[u];
                }
            }
            return c(e, t), e;
        }
        function m(e) {
            return parseInt(e, 10);
        }
        function f(e, t) {
            return d(Object.create(e), t);
        }
        function p() {}
        function h(e) {
            return e;
        }
        function g(e) {
            return function() {
                return e;
            };
        }
        function _(e) {
            return "undefined" == typeof e;
        }
        function v(e) {
            return "undefined" != typeof e;
        }
        function b(e) {
            return null !== e && "object" == typeof e;
        }
        function y(e) {
            return "string" == typeof e;
        }
        function M(e) {
            return "number" == typeof e;
        }
        function $(e) {
            return "[object Date]" === ia.call(e);
        }
        function L(e) {
            return "function" == typeof e;
        }
        function k(e) {
            return "[object RegExp]" === ia.call(e);
        }
        function w(e) {
            return e && e.window === e;
        }
        function D(e) {
            return e && e.$evalAsync && e.$watch;
        }
        function Y(e) {
            return "[object File]" === ia.call(e);
        }
        function T(e) {
            return "[object FormData]" === ia.call(e);
        }
        function S(e) {
            return "[object Blob]" === ia.call(e);
        }
        function x(e) {
            return "boolean" == typeof e;
        }
        function C(e) {
            return e && L(e.then);
        }
        function E(e) {
            return !(!e || !(e.nodeName || e.prop && e.attr && e.find));
        }
        function H(e) {
            var t, n = {}, a = e.split(",");
            for (t = 0; t < a.length; t++) n[a[t]] = !0;
            return n;
        }
        function j(e) {
            return Bn(e.nodeName || e[0] && e[0].nodeName);
        }
        function A(e, t) {
            var n = e.indexOf(t);
            return n >= 0 && e.splice(n, 1), t;
        }
        function O(e, t, n, a) {
            if (w(e) || D(e)) throw sa("cpws", "Can't copy! Making copies of Window or Scope instances is not supported.");
            if (t) {
                if (e === t) throw sa("cpi", "Can't copy! Source and destination are identical.");
                if (n = n || [], a = a || [], b(e)) {
                    var r = n.indexOf(e);
                    if (r !== -1) return a[r];
                    n.push(e), a.push(t);
                }
                var s;
                if (ca(e)) {
                    t.length = 0;
                    for (var o = 0; o < e.length; o++) s = O(e[o], null, n, a), b(e[o]) && (n.push(e[o]), 
                    a.push(s)), t.push(s);
                } else {
                    var u = t.$$hashKey;
                    ca(t) ? t.length = 0 : i(t, function(e, n) {
                        delete t[n];
                    });
                    for (var l in e) e.hasOwnProperty(l) && (s = O(e[l], null, n, a), b(e[l]) && (n.push(e[l]), 
                    a.push(s)), t[l] = s);
                    c(t, u);
                }
            } else if (t = e, e) if (ca(e)) t = O(e, [], n, a); else if ($(e)) t = new Date(e.getTime()); else if (k(e)) t = new RegExp(e.source, e.toString().match(/[^\/]*$/)[0]), 
            t.lastIndex = e.lastIndex; else if (b(e)) {
                var d = Object.create(Object.getPrototypeOf(e));
                t = O(e, d, n, a);
            }
            return t;
        }
        function P(e, t) {
            if (ca(e)) {
                t = t || [];
                for (var n = 0, a = e.length; n < a; n++) t[n] = e[n];
            } else if (b(e)) {
                t = t || {};
                for (var r in e) "$" === r.charAt(0) && "$" === r.charAt(1) || (t[r] = e[r]);
            }
            return t || e;
        }
        function I(e, t) {
            if (e === t) return !0;
            if (null === e || null === t) return !1;
            if (e !== e && t !== t) return !0;
            var a, r, i, s = typeof e, o = typeof t;
            if (s == o && "object" == s) {
                if (!ca(e)) {
                    if ($(e)) return !!$(t) && I(e.getTime(), t.getTime());
                    if (k(e) && k(t)) return e.toString() == t.toString();
                    if (D(e) || D(t) || w(e) || w(t) || ca(t)) return !1;
                    i = {};
                    for (r in e) if ("$" !== r.charAt(0) && !L(e[r])) {
                        if (!I(e[r], t[r])) return !1;
                        i[r] = !0;
                    }
                    for (r in t) if (!i.hasOwnProperty(r) && "$" !== r.charAt(0) && t[r] !== n && !L(t[r])) return !1;
                    return !0;
                }
                if (!ca(t)) return !1;
                if ((a = e.length) == t.length) {
                    for (r = 0; r < a; r++) if (!I(e[r], t[r])) return !1;
                    return !0;
                }
            }
            return !1;
        }
        function F(e, t, n) {
            return e.concat(na.call(t, n));
        }
        function N(e, t) {
            return na.call(e, t || 0);
        }
        function U(e, t) {
            var n = arguments.length > 2 ? N(arguments, 2) : [];
            return !L(t) || t instanceof RegExp ? t : n.length ? function() {
                return arguments.length ? t.apply(e, F(n, arguments, 0)) : t.apply(e, n);
            } : function() {
                return arguments.length ? t.apply(e, arguments) : t.call(e);
            };
        }
        function V(e, a) {
            var r = a;
            return "string" == typeof e && "$" === e.charAt(0) && "$" === e.charAt(1) ? r = n : w(a) ? r = "$WINDOW" : a && t === a ? r = "$DOCUMENT" : D(a) && (r = "$SCOPE"), 
            r;
        }
        function W(e, t) {
            return "undefined" == typeof e ? n : (M(t) || (t = t ? 2 : null), JSON.stringify(e, V, t));
        }
        function q(e) {
            return y(e) ? JSON.parse(e) : e;
        }
        function R(e) {
            e = Xn(e).clone();
            try {
                e.empty();
            } catch (e) {}
            var t = Xn("<div>").append(e).html();
            try {
                return e[0].nodeType === va ? Bn(t) : t.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/, function(e, t) {
                    return "<" + Bn(t);
                });
            } catch (e) {
                return Bn(t);
            }
        }
        function z(e) {
            try {
                return decodeURIComponent(e);
            } catch (e) {}
        }
        function B(e) {
            var t, n, a = {};
            return i((e || "").split("&"), function(e) {
                if (e && (t = e.replace(/\+/g, "%20").split("="), n = z(t[0]), v(n))) {
                    var r = !v(t[1]) || z(t[1]);
                    Gn.call(a, n) ? ca(a[n]) ? a[n].push(r) : a[n] = [ a[n], r ] : a[n] = r;
                }
            }), a;
        }
        function G(e) {
            var t = [];
            return i(e, function(e, n) {
                ca(e) ? i(e, function(e) {
                    t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
                }) : t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
            }), t.length ? t.join("&") : "";
        }
        function J(e) {
            return K(e, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+");
        }
        function K(e, t) {
            return encodeURIComponent(e).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%3B/gi, ";").replace(/%20/g, t ? "%20" : "+");
        }
        function Z(e, t) {
            var n, a, r = pa.length;
            for (e = Xn(e), a = 0; a < r; ++a) if (n = pa[a] + t, y(n = e.attr(n))) return n;
            return null;
        }
        function Q(e, t) {
            var n, a, r = {};
            i(pa, function(t) {
                var r = t + "app";
                !n && e.hasAttribute && e.hasAttribute(r) && (n = e, a = e.getAttribute(r));
            }), i(pa, function(t) {
                var r, i = t + "app";
                !n && (r = e.querySelector("[" + i.replace(":", "\\:") + "]")) && (n = r, a = r.getAttribute(i));
            }), n && (r.strictDi = null !== Z(n, "strict-di"), t(n, a ? [ a ] : [], r));
        }
        function X(n, a, r) {
            b(r) || (r = {});
            var s = {
                strictDi: !1
            };
            r = d(s, r);
            var o = function() {
                if (n = Xn(n), n.injector()) {
                    var e = n[0] === t ? "document" : R(n);
                    throw sa("btstrpd", "App Already Bootstrapped with this Element '{0}'", e.replace(/</, "&lt;").replace(/>/, "&gt;"));
                }
                a = a || [], a.unshift([ "$provide", function(e) {
                    e.value("$rootElement", n);
                } ]), r.debugInfoEnabled && a.push([ "$compileProvider", function(e) {
                    e.debugInfoEnabled(!0);
                } ]), a.unshift("ng");
                var i = qe(a, r.strictDi);
                return i.invoke([ "$rootScope", "$rootElement", "$compile", "$injector", function(e, t, n, a) {
                    e.$apply(function() {
                        t.data("$injector", a), n(t)(e);
                    });
                } ]), i;
            }, u = /^NG_ENABLE_DEBUG_INFO!/, l = /^NG_DEFER_BOOTSTRAP!/;
            return e && u.test(e.name) && (r.debugInfoEnabled = !0, e.name = e.name.replace(u, "")), 
            e && !l.test(e.name) ? o() : (e.name = e.name.replace(l, ""), oa.resumeBootstrap = function(e) {
                return i(e, function(e) {
                    a.push(e);
                }), o();
            }, void (L(oa.resumeDeferredBootstrap) && oa.resumeDeferredBootstrap()));
        }
        function ee() {
            e.name = "NG_ENABLE_DEBUG_INFO!" + e.name, e.location.reload();
        }
        function te(e) {
            var t = oa.element(e).injector();
            if (!t) throw sa("test", "no injector found for element argument to getTestability");
            return t.get("$$testability");
        }
        function ne(e, t) {
            return t = t || "_", e.replace(ha, function(e, n) {
                return (n ? t : "") + e.toLowerCase();
            });
        }
        function ae() {
            var t;
            ga || (ea = e.jQuery, ea && ea.fn.on ? (Xn = ea, d(ea.fn, {
                scope: Oa.scope,
                isolateScope: Oa.isolateScope,
                controller: Oa.controller,
                injector: Oa.injector,
                inheritedData: Oa.inheritedData
            }), t = ea.cleanData, ea.cleanData = function(e) {
                var n;
                if (la) la = !1; else for (var a, r = 0; null != (a = e[r]); r++) n = ea._data(a, "events"), 
                n && n.$destroy && ea(a).triggerHandler("$destroy");
                t(e);
            }) : Xn = ye, oa.element = Xn, ga = !0);
        }
        function re(e, t, n) {
            if (!e) throw sa("areq", "Argument '{0}' is {1}", t || "?", n || "required");
            return e;
        }
        function ie(e, t, n) {
            return n && ca(e) && (e = e[e.length - 1]), re(L(e), t, "not a function, got " + (e && "object" == typeof e ? e.constructor.name || "Object" : typeof e)), 
            e;
        }
        function se(e, t) {
            if ("hasOwnProperty" === e) throw sa("badname", "hasOwnProperty is not a valid {0} name", t);
        }
        function oe(e, t, n) {
            if (!t) return e;
            for (var a, r = t.split("."), i = e, s = r.length, o = 0; o < s; o++) a = r[o], 
            e && (e = (i = e)[a]);
            return !n && L(e) ? U(i, e) : e;
        }
        function ue(e) {
            var t = e[0], n = e[e.length - 1], a = [ t ];
            do {
                if (t = t.nextSibling, !t) break;
                a.push(t);
            } while (t !== n);
            return Xn(a);
        }
        function le() {
            return Object.create(null);
        }
        function ce(e) {
            function t(e, t, n) {
                return e[t] || (e[t] = n());
            }
            var n = a("$injector"), r = a("ng"), i = t(e, "angular", Object);
            return i.$$minErr = i.$$minErr || a, t(i, "module", function() {
                var e = {};
                return function(a, i, s) {
                    var o = function(e, t) {
                        if ("hasOwnProperty" === e) throw r("badname", "hasOwnProperty is not a valid {0} name", t);
                    };
                    return o(a, "module"), i && e.hasOwnProperty(a) && (e[a] = null), t(e, a, function() {
                        function e(e, n, a, r) {
                            return r || (r = t), function() {
                                return r[a || "push"]([ e, n, arguments ]), l;
                            };
                        }
                        if (!i) throw n("nomod", "Module '{0}' is not available! You either misspelled the module name or forgot to load it. If registering a module ensure that you specify the dependencies as the second argument.", a);
                        var t = [], r = [], o = [], u = e("$injector", "invoke", "push", r), l = {
                            _invokeQueue: t,
                            _configBlocks: r,
                            _runBlocks: o,
                            requires: i,
                            name: a,
                            provider: e("$provide", "provider"),
                            factory: e("$provide", "factory"),
                            service: e("$provide", "service"),
                            value: e("$provide", "value"),
                            constant: e("$provide", "constant", "unshift"),
                            animation: e("$animateProvider", "register"),
                            filter: e("$filterProvider", "register"),
                            controller: e("$controllerProvider", "register"),
                            directive: e("$compileProvider", "directive"),
                            config: u,
                            run: function(e) {
                                return o.push(e), this;
                            }
                        };
                        return s && u(s), l;
                    });
                };
            });
        }
        function de(e) {
            var t = [];
            return JSON.stringify(e, function(e, n) {
                if (n = V(e, n), b(n)) {
                    if (t.indexOf(n) >= 0) return "<<already seen>>";
                    t.push(n);
                }
                return n;
            });
        }
        function me(e) {
            return "function" == typeof e ? e.toString().replace(/ \{[\s\S]*$/, "") : "undefined" == typeof e ? "undefined" : "string" != typeof e ? de(e) : e;
        }
        function fe(t) {
            d(t, {
                bootstrap: X,
                copy: O,
                extend: d,
                equals: I,
                element: Xn,
                forEach: i,
                injector: qe,
                noop: p,
                bind: U,
                toJson: W,
                fromJson: q,
                identity: h,
                isUndefined: _,
                isDefined: v,
                isString: y,
                isFunction: L,
                isObject: b,
                isNumber: M,
                isElement: E,
                isArray: ca,
                version: $a,
                isDate: $,
                lowercase: Bn,
                uppercase: Jn,
                callbacks: {
                    counter: 0
                },
                getTestability: te,
                $$minErr: a,
                $$csp: fa,
                reloadWithDebugInfo: ee
            }), ta = ce(e);
            try {
                ta("ngLocale");
            } catch (e) {
                ta("ngLocale", []).provider("$locale", gt);
            }
            ta("ng", [ "ngLocale" ], [ "$provide", function(e) {
                e.provider({
                    $$sanitizeUri: Gt
                }), e.provider("$compile", Ze).directive({
                    a: Tr,
                    input: Rr,
                    textarea: Rr,
                    form: Hr,
                    script: ji,
                    select: Pi,
                    style: Fi,
                    option: Ii,
                    ngBind: Gr,
                    ngBindHtml: Kr,
                    ngBindTemplate: Jr,
                    ngClass: Qr,
                    ngClassEven: ei,
                    ngClassOdd: Xr,
                    ngCloak: ti,
                    ngController: ni,
                    ngForm: jr,
                    ngHide: Ti,
                    ngIf: ii,
                    ngInclude: si,
                    ngInit: ui,
                    ngNonBindable: $i,
                    ngPluralize: Li,
                    ngRepeat: ki,
                    ngShow: Yi,
                    ngStyle: Si,
                    ngSwitch: xi,
                    ngSwitchWhen: Ci,
                    ngSwitchDefault: Ei,
                    ngOptions: Oi,
                    ngTransclude: Hi,
                    ngModel: bi,
                    ngList: li,
                    ngChange: Zr,
                    pattern: Ui,
                    ngPattern: Ui,
                    required: Ni,
                    ngRequired: Ni,
                    minlength: Wi,
                    ngMinlength: Wi,
                    maxlength: Vi,
                    ngMaxlength: Vi,
                    ngValue: Br,
                    ngModelOptions: Mi
                }).directive({
                    ngInclude: oi
                }).directive(Sr).directive(ai), e.provider({
                    $anchorScroll: Re,
                    $animate: za,
                    $browser: Ge,
                    $cacheFactory: Je,
                    $controller: tt,
                    $document: nt,
                    $exceptionHandler: at,
                    $filter: on,
                    $interpolate: pt,
                    $interval: ht,
                    $http: ct,
                    $httpBackend: mt,
                    $location: xt,
                    $log: Ct,
                    $parse: Vt,
                    $rootScope: Bt,
                    $q: Wt,
                    $$q: qt,
                    $sce: Qt,
                    $sceDelegate: Zt,
                    $sniffer: Xt,
                    $templateCache: Ke,
                    $templateRequest: en,
                    $$testability: tn,
                    $timeout: nn,
                    $window: sn,
                    $$rAF: zt,
                    $$asyncCallback: ze,
                    $$jqLite: Fe
                });
            } ]);
        }
        function pe() {
            return ++ka;
        }
        function he(e) {
            return e.replace(Ya, function(e, t, n, a) {
                return a ? n.toUpperCase() : n;
            }).replace(Ta, "Moz$1");
        }
        function ge(e) {
            return !Ea.test(e);
        }
        function _e(e) {
            var t = e.nodeType;
            return t === _a || !t || t === ya;
        }
        function ve(e, t) {
            var n, a, r, s, o = t.createDocumentFragment(), u = [];
            if (ge(e)) u.push(t.createTextNode(e)); else {
                for (n = n || o.appendChild(t.createElement("div")), a = (Ha.exec(e) || [ "", "" ])[1].toLowerCase(), 
                r = Aa[a] || Aa._default, n.innerHTML = r[1] + e.replace(ja, "<$1></$2>") + r[2], 
                s = r[0]; s--; ) n = n.lastChild;
                u = F(u, n.childNodes), n = o.firstChild, n.textContent = "";
            }
            return o.textContent = "", o.innerHTML = "", i(u, function(e) {
                o.appendChild(e);
            }), o;
        }
        function be(e, n) {
            n = n || t;
            var a;
            return (a = Ca.exec(e)) ? [ n.createElement(a[1]) ] : (a = ve(e, n)) ? a.childNodes : [];
        }
        function ye(e) {
            if (e instanceof ye) return e;
            var t;
            if (y(e) && (e = da(e), t = !0), !(this instanceof ye)) {
                if (t && "<" != e.charAt(0)) throw xa("nosel", "Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element");
                return new ye(e);
            }
            t ? xe(this, be(e)) : xe(this, e);
        }
        function Me(e) {
            return e.cloneNode(!0);
        }
        function $e(e, t) {
            if (t || ke(e), e.querySelectorAll) for (var n = e.querySelectorAll("*"), a = 0, r = n.length; a < r; a++) ke(n[a]);
        }
        function Le(e, t, n, a) {
            if (v(a)) throw xa("offargs", "jqLite#off() does not support the `selector` argument");
            var r = we(e), s = r && r.events, o = r && r.handle;
            if (o) if (t) i(t.split(" "), function(t) {
                if (v(n)) {
                    var a = s[t];
                    if (A(a || [], n), a && a.length > 0) return;
                }
                Da(e, t, o), delete s[t];
            }); else for (t in s) "$destroy" !== t && Da(e, t, o), delete s[t];
        }
        function ke(e, t) {
            var a = e.ng339, r = a && La[a];
            if (r) {
                if (t) return void delete r.data[t];
                r.handle && (r.events.$destroy && r.handle({}, "$destroy"), Le(e)), delete La[a], 
                e.ng339 = n;
            }
        }
        function we(e, t) {
            var a = e.ng339, r = a && La[a];
            return t && !r && (e.ng339 = a = pe(), r = La[a] = {
                events: {},
                data: {},
                handle: n
            }), r;
        }
        function De(e, t, n) {
            if (_e(e)) {
                var a = v(n), r = !a && t && !b(t), i = !t, s = we(e, !r), o = s && s.data;
                if (a) o[t] = n; else {
                    if (i) return o;
                    if (r) return o && o[t];
                    d(o, t);
                }
            }
        }
        function Ye(e, t) {
            return !!e.getAttribute && (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").indexOf(" " + t + " ") > -1;
        }
        function Te(e, t) {
            t && e.setAttribute && i(t.split(" "), function(t) {
                e.setAttribute("class", da((" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").replace(" " + da(t) + " ", " ")));
            });
        }
        function Se(e, t) {
            if (t && e.setAttribute) {
                var n = (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ");
                i(t.split(" "), function(e) {
                    e = da(e), n.indexOf(" " + e + " ") === -1 && (n += e + " ");
                }), e.setAttribute("class", da(n));
            }
        }
        function xe(e, t) {
            if (t) if (t.nodeType) e[e.length++] = t; else {
                var n = t.length;
                if ("number" == typeof n && t.window !== t) {
                    if (n) for (var a = 0; a < n; a++) e[e.length++] = t[a];
                } else e[e.length++] = t;
            }
        }
        function Ce(e, t) {
            return Ee(e, "$" + (t || "ngController") + "Controller");
        }
        function Ee(e, t, a) {
            e.nodeType == ya && (e = e.documentElement);
            for (var r = ca(t) ? t : [ t ]; e; ) {
                for (var i = 0, s = r.length; i < s; i++) if ((a = Xn.data(e, r[i])) !== n) return a;
                e = e.parentNode || e.nodeType === Ma && e.host;
            }
        }
        function He(e) {
            for ($e(e, !0); e.firstChild; ) e.removeChild(e.firstChild);
        }
        function je(e, t) {
            t || $e(e);
            var n = e.parentNode;
            n && n.removeChild(e);
        }
        function Ae(t, n) {
            n = n || e, "complete" === n.document.readyState ? n.setTimeout(t) : Xn(n).on("load", t);
        }
        function Oe(e, t) {
            var n = Pa[t.toLowerCase()];
            return n && Ia[j(e)] && n;
        }
        function Pe(e, t) {
            var n = e.nodeName;
            return ("INPUT" === n || "TEXTAREA" === n) && Fa[t];
        }
        function Ie(e, t) {
            var n = function(n, a) {
                n.isDefaultPrevented = function() {
                    return n.defaultPrevented;
                };
                var r = t[a || n.type], i = r ? r.length : 0;
                if (i) {
                    if (_(n.immediatePropagationStopped)) {
                        var s = n.stopImmediatePropagation;
                        n.stopImmediatePropagation = function() {
                            n.immediatePropagationStopped = !0, n.stopPropagation && n.stopPropagation(), s && s.call(n);
                        };
                    }
                    n.isImmediatePropagationStopped = function() {
                        return n.immediatePropagationStopped === !0;
                    }, i > 1 && (r = P(r));
                    for (var o = 0; o < i; o++) n.isImmediatePropagationStopped() || r[o].call(e, n);
                }
            };
            return n.elem = e, n;
        }
        function Fe() {
            this.$get = function() {
                return d(ye, {
                    hasClass: function(e, t) {
                        return e.attr && (e = e[0]), Ye(e, t);
                    },
                    addClass: function(e, t) {
                        return e.attr && (e = e[0]), Se(e, t);
                    },
                    removeClass: function(e, t) {
                        return e.attr && (e = e[0]), Te(e, t);
                    }
                });
            };
        }
        function Ne(e, t) {
            var n = e && e.$$hashKey;
            if (n) return "function" == typeof n && (n = e.$$hashKey()), n;
            var a = typeof e;
            return n = "function" == a || "object" == a && null !== e ? e.$$hashKey = a + ":" + (t || l)() : a + ":" + e;
        }
        function Ue(e, t) {
            if (t) {
                var n = 0;
                this.nextUid = function() {
                    return ++n;
                };
            }
            i(e, this.put, this);
        }
        function Ve(e) {
            var t = e.toString().replace(Wa, ""), n = t.match(Na);
            return n ? "function(" + (n[1] || "").replace(/[\s\r\n]+/, " ") + ")" : "fn";
        }
        function We(e, t, n) {
            var a, r, s, o;
            if ("function" == typeof e) {
                if (!(a = e.$inject)) {
                    if (a = [], e.length) {
                        if (t) throw y(n) && n || (n = e.name || Ve(e)), qa("strictdi", "{0} is not using explicit annotation and cannot be invoked in strict mode", n);
                        r = e.toString().replace(Wa, ""), s = r.match(Na), i(s[1].split(Ua), function(e) {
                            e.replace(Va, function(e, t, n) {
                                a.push(n);
                            });
                        });
                    }
                    e.$inject = a;
                }
            } else ca(e) ? (o = e.length - 1, ie(e[o], "fn"), a = e.slice(0, o)) : ie(e, "fn", !0);
            return a;
        }
        function qe(e, t) {
            function a(e) {
                return function(t, n) {
                    return b(t) ? void i(t, u(e)) : e(t, n);
                };
            }
            function r(e, t) {
                if (se(e, "service"), (L(t) || ca(t)) && (t = D.instantiate(t)), !t.$get) throw qa("pget", "Provider '{0}' must define $get factory method.", e);
                return w[e + M] = t;
            }
            function s(e, t) {
                return function() {
                    var n = T.invoke(t, this);
                    if (_(n)) throw qa("undef", "Provider '{0}' must return a value from $get factory method.", e);
                    return n;
                };
            }
            function o(e, t, n) {
                return r(e, {
                    $get: n !== !1 ? s(e, t) : t
                });
            }
            function l(e, t) {
                return o(e, [ "$injector", function(e) {
                    return e.instantiate(t);
                } ]);
            }
            function c(e, t) {
                return o(e, g(t), !1);
            }
            function d(e, t) {
                se(e, "constant"), w[e] = t, Y[e] = t;
            }
            function m(e, t) {
                var n = D.get(e + M), a = n.$get;
                n.$get = function() {
                    var e = T.invoke(a, n);
                    return T.invoke(t, null, {
                        $delegate: e
                    });
                };
            }
            function f(e) {
                var t, n = [];
                return i(e, function(e) {
                    function a(e) {
                        var t, n;
                        for (t = 0, n = e.length; t < n; t++) {
                            var a = e[t], r = D.get(a[0]);
                            r[a[1]].apply(r, a[2]);
                        }
                    }
                    if (!k.get(e)) {
                        k.put(e, !0);
                        try {
                            y(e) ? (t = ta(e), n = n.concat(f(t.requires)).concat(t._runBlocks), a(t._invokeQueue), 
                            a(t._configBlocks)) : L(e) ? n.push(D.invoke(e)) : ca(e) ? n.push(D.invoke(e)) : ie(e, "module");
                        } catch (t) {
                            throw ca(e) && (e = e[e.length - 1]), t.message && t.stack && t.stack.indexOf(t.message) == -1 && (t = t.message + "\n" + t.stack), 
                            qa("modulerr", "Failed to instantiate module {0} due to:\n{1}", e, t.stack || t.message || t);
                        }
                    }
                }), n;
            }
            function h(e, n) {
                function a(t, a) {
                    if (e.hasOwnProperty(t)) {
                        if (e[t] === v) throw qa("cdep", "Circular dependency found: {0}", t + " <- " + $.join(" <- "));
                        return e[t];
                    }
                    try {
                        return $.unshift(t), e[t] = v, e[t] = n(t, a);
                    } catch (n) {
                        throw e[t] === v && delete e[t], n;
                    } finally {
                        $.shift();
                    }
                }
                function r(e, n, r, i) {
                    "string" == typeof r && (i = r, r = null);
                    var s, o, u, l = [], c = qe.$$annotate(e, t, i);
                    for (o = 0, s = c.length; o < s; o++) {
                        if (u = c[o], "string" != typeof u) throw qa("itkn", "Incorrect injection token! Expected service name as string, got {0}", u);
                        l.push(r && r.hasOwnProperty(u) ? r[u] : a(u, i));
                    }
                    return ca(e) && (e = e[s]), e.apply(n, l);
                }
                function i(e, t, n) {
                    var a = Object.create((ca(e) ? e[e.length - 1] : e).prototype || null), i = r(e, a, t, n);
                    return b(i) || L(i) ? i : a;
                }
                return {
                    invoke: r,
                    instantiate: i,
                    get: a,
                    annotate: qe.$$annotate,
                    has: function(t) {
                        return w.hasOwnProperty(t + M) || e.hasOwnProperty(t);
                    }
                };
            }
            t = t === !0;
            var v = {}, M = "Provider", $ = [], k = new Ue([], !0), w = {
                $provide: {
                    provider: a(r),
                    factory: a(o),
                    service: a(l),
                    value: a(c),
                    constant: a(d),
                    decorator: m
                }
            }, D = w.$injector = h(w, function(e, t) {
                throw oa.isString(t) && $.push(t), qa("unpr", "Unknown provider: {0}", $.join(" <- "));
            }), Y = {}, T = Y.$injector = h(Y, function(e, t) {
                var a = D.get(e + M, t);
                return T.invoke(a.$get, a, n, e);
            });
            return i(f(e), function(e) {
                T.invoke(e || p);
            }), T;
        }
        function Re() {
            var e = !0;
            this.disableAutoScrolling = function() {
                e = !1;
            }, this.$get = [ "$window", "$location", "$rootScope", function(t, n, a) {
                function r(e) {
                    var t = null;
                    return Array.prototype.some.call(e, function(e) {
                        if ("a" === j(e)) return t = e, !0;
                    }), t;
                }
                function i() {
                    var e = o.yOffset;
                    if (L(e)) e = e(); else if (E(e)) {
                        var n = e[0], a = t.getComputedStyle(n);
                        e = "fixed" !== a.position ? 0 : n.getBoundingClientRect().bottom;
                    } else M(e) || (e = 0);
                    return e;
                }
                function s(e) {
                    if (e) {
                        e.scrollIntoView();
                        var n = i();
                        if (n) {
                            var a = e.getBoundingClientRect().top;
                            t.scrollBy(0, a - n);
                        }
                    } else t.scrollTo(0, 0);
                }
                function o() {
                    var e, t = n.hash();
                    t ? (e = u.getElementById(t)) ? s(e) : (e = r(u.getElementsByName(t))) ? s(e) : "top" === t && s(null) : s(null);
                }
                var u = t.document;
                return e && a.$watch(function() {
                    return n.hash();
                }, function(e, t) {
                    e === t && "" === e || Ae(function() {
                        a.$evalAsync(o);
                    });
                }), o;
            } ];
        }
        function ze() {
            this.$get = [ "$$rAF", "$timeout", function(e, t) {
                return e.supported ? function(t) {
                    return e(t);
                } : function(e) {
                    return t(e, 0, !1);
                };
            } ];
        }
        function Be(e, t, a, r) {
            function s(e) {
                try {
                    e.apply(null, N(arguments, 1));
                } finally {
                    if (L--, 0 === L) for (;k.length; ) try {
                        k.pop()();
                    } catch (e) {
                        a.error(e);
                    }
                }
            }
            function o(e) {
                var t = e.indexOf("#");
                return t === -1 ? "" : e.substr(t + 1);
            }
            function u(e, t) {
                !function n() {
                    i(D, function(e) {
                        e();
                    }), w = t(n, e);
                }();
            }
            function l() {
                c(), d();
            }
            function c() {
                Y = e.history.state, Y = _(Y) ? null : Y, I(Y, j) && (Y = j), j = Y;
            }
            function d() {
                S === f.url() && T === Y || (S = f.url(), T = Y, i(E, function(e) {
                    e(f.url(), Y);
                }));
            }
            function m(e) {
                try {
                    return decodeURIComponent(e);
                } catch (t) {
                    return e;
                }
            }
            var f = this, h = t[0], g = e.location, v = e.history, b = e.setTimeout, M = e.clearTimeout, $ = {};
            f.isMock = !1;
            var L = 0, k = [];
            f.$$completeOutstandingRequest = s, f.$$incOutstandingRequestCount = function() {
                L++;
            }, f.notifyWhenNoOutstandingRequests = function(e) {
                i(D, function(e) {
                    e();
                }), 0 === L ? e() : k.push(e);
            };
            var w, D = [];
            f.addPollFn = function(e) {
                return _(w) && u(100, b), D.push(e), e;
            };
            var Y, T, S = g.href, x = t.find("base"), C = null;
            c(), T = Y, f.url = function(t, n, a) {
                if (_(a) && (a = null), g !== e.location && (g = e.location), v !== e.history && (v = e.history), 
                t) {
                    var i = T === a;
                    if (S === t && (!r.history || i)) return f;
                    var s = S && Mt(S) === Mt(t);
                    return S = t, T = a, !r.history || s && i ? (s || (C = t), n ? g.replace(t) : s ? g.hash = o(t) : g.href = t) : (v[n ? "replaceState" : "pushState"](a, "", t), 
                    c(), T = Y), f;
                }
                return C || g.href.replace(/%27/g, "'");
            }, f.state = function() {
                return Y;
            };
            var E = [], H = !1, j = null;
            f.onUrlChange = function(t) {
                return H || (r.history && Xn(e).on("popstate", l), Xn(e).on("hashchange", l), H = !0), 
                E.push(t), t;
            }, f.$$checkUrlChange = d, f.baseHref = function() {
                var e = x.attr("href");
                return e ? e.replace(/^(https?\:)?\/\/[^\/]*/, "") : "";
            };
            var A = {}, O = "", P = f.baseHref();
            f.cookies = function(e, t) {
                var r, i, s, o, u;
                if (!e) {
                    if (h.cookie !== O) for (O = h.cookie, i = O.split("; "), A = {}, o = 0; o < i.length; o++) s = i[o], 
                    u = s.indexOf("="), u > 0 && (e = m(s.substring(0, u)), A[e] === n && (A[e] = m(s.substring(u + 1))));
                    return A;
                }
                t === n ? h.cookie = encodeURIComponent(e) + "=;path=" + P + ";expires=Thu, 01 Jan 1970 00:00:00 GMT" : y(t) && (r = (h.cookie = encodeURIComponent(e) + "=" + encodeURIComponent(t) + ";path=" + P).length + 1, 
                r > 4096 && a.warn("Cookie '" + e + "' possibly not set or overflowed because it was too large (" + r + " > 4096 bytes)!"));
            }, f.defer = function(e, t) {
                var n;
                return L++, n = b(function() {
                    delete $[n], s(e);
                }, t || 0), $[n] = !0, n;
            }, f.defer.cancel = function(e) {
                return !!$[e] && (delete $[e], M(e), s(p), !0);
            };
        }
        function Ge() {
            this.$get = [ "$window", "$log", "$sniffer", "$document", function(e, t, n, a) {
                return new Be(e, a, t, n);
            } ];
        }
        function Je() {
            this.$get = function() {
                function e(e, n) {
                    function r(e) {
                        e != m && (f ? f == e && (f = e.n) : f = e, i(e.n, e.p), i(e, m), m = e, m.n = null);
                    }
                    function i(e, t) {
                        e != t && (e && (e.p = t), t && (t.n = e));
                    }
                    if (e in t) throw a("$cacheFactory")("iid", "CacheId '{0}' is already taken!", e);
                    var s = 0, o = d({}, n, {
                        id: e
                    }), u = {}, l = n && n.capacity || Number.MAX_VALUE, c = {}, m = null, f = null;
                    return t[e] = {
                        put: function(e, t) {
                            if (l < Number.MAX_VALUE) {
                                var n = c[e] || (c[e] = {
                                    key: e
                                });
                                r(n);
                            }
                            if (!_(t)) return e in u || s++, u[e] = t, s > l && this.remove(f.key), t;
                        },
                        get: function(e) {
                            if (l < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                r(t);
                            }
                            return u[e];
                        },
                        remove: function(e) {
                            if (l < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                t == m && (m = t.p), t == f && (f = t.n), i(t.n, t.p), delete c[e];
                            }
                            delete u[e], s--;
                        },
                        removeAll: function() {
                            u = {}, s = 0, c = {}, m = f = null;
                        },
                        destroy: function() {
                            u = null, o = null, c = null, delete t[e];
                        },
                        info: function() {
                            return d({}, o, {
                                size: s
                            });
                        }
                    };
                }
                var t = {};
                return e.info = function() {
                    var e = {};
                    return i(t, function(t, n) {
                        e[n] = t.info();
                    }), e;
                }, e.get = function(e) {
                    return t[e];
                }, e;
            };
        }
        function Ke() {
            this.$get = [ "$cacheFactory", function(e) {
                return e("templates");
            } ];
        }
        function Ze(e, a) {
            function r(e, t) {
                var n = /^\s*([@&]|=(\*?))(\??)\s*(\w*)\s*$/, a = {};
                return i(e, function(e, r) {
                    var i = e.match(n);
                    if (!i) throw Ba("iscp", "Invalid isolate scope definition for directive '{0}'. Definition: {... {1}: '{2}' ...}", t, r, e);
                    a[r] = {
                        mode: i[1][0],
                        collection: "*" === i[2],
                        optional: "?" === i[3],
                        attrName: i[4] || r
                    };
                }), a;
            }
            var s = {}, o = "Directive", l = /^\s*directive\:\s*([\w\-]+)\s+(.*)$/, c = /(([\w\-]+)(?:\:([^;]+))?;?)/, m = H("ngSrc,ngSrcset,src,srcset"), _ = /^(?:(\^\^?)?(\?)?(\^\^?)?)?/, M = /^(on[a-z]+|formaction)$/;
            this.directive = function t(n, a) {
                return se(n, "directive"), y(n) ? (re(a, "directiveFactory"), s.hasOwnProperty(n) || (s[n] = [], 
                e.factory(n + o, [ "$injector", "$exceptionHandler", function(e, t) {
                    var a = [];
                    return i(s[n], function(i, s) {
                        try {
                            var o = e.invoke(i);
                            L(o) ? o = {
                                compile: g(o)
                            } : !o.compile && o.link && (o.compile = g(o.link)), o.priority = o.priority || 0, 
                            o.index = s, o.name = o.name || n, o.require = o.require || o.controller && o.name, 
                            o.restrict = o.restrict || "EA", b(o.scope) && (o.$$isolateBindings = r(o.scope, o.name)), 
                            a.push(o);
                        } catch (e) {
                            t(e);
                        }
                    }), a;
                } ])), s[n].push(a)) : i(n, u(t)), this;
            }, this.aHrefSanitizationWhitelist = function(e) {
                return v(e) ? (a.aHrefSanitizationWhitelist(e), this) : a.aHrefSanitizationWhitelist();
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (a.imgSrcSanitizationWhitelist(e), this) : a.imgSrcSanitizationWhitelist();
            };
            var $ = !0;
            this.debugInfoEnabled = function(e) {
                return v(e) ? ($ = e, this) : $;
            }, this.$get = [ "$injector", "$interpolate", "$exceptionHandler", "$templateRequest", "$parse", "$controller", "$rootScope", "$document", "$sce", "$animate", "$$sanitizeUri", function(e, a, r, u, g, v, k, w, Y, T, S) {
                function x(e, t) {
                    try {
                        e.addClass(t);
                    } catch (e) {}
                }
                function C(e, t, n, a, r) {
                    e instanceof Xn || (e = Xn(e)), i(e, function(t, n) {
                        t.nodeType == va && t.nodeValue.match(/\S+/) && (e[n] = Xn(t).wrap("<span></span>").parent()[0]);
                    });
                    var s = H(e, t, e, n, a, r);
                    C.$$addScopeClass(e);
                    var o = null;
                    return function(t, n, a) {
                        re(t, "scope"), a = a || {};
                        var r = a.parentBoundTranscludeFn, i = a.transcludeControllers, u = a.futureParentElement;
                        r && r.$$boundTransclude && (r = r.$$boundTransclude), o || (o = E(u));
                        var l;
                        if (l = "html" !== o ? Xn(Q(o, Xn("<div>").append(e).html())) : n ? Oa.clone.call(e) : e, 
                        i) for (var c in i) l.data("$" + c + "Controller", i[c].instance);
                        return C.$$addScopeInfo(l, t), n && n(l, t), s && s(t, l, l, r), l;
                    };
                }
                function E(e) {
                    var t = e && e[0];
                    return t && "foreignobject" !== j(t) && t.toString().match(/SVG/) ? "svg" : "html";
                }
                function H(e, t, a, r, i, s) {
                    function o(e, a, r, i) {
                        var s, o, u, l, c, d, m, f, g;
                        if (p) {
                            var _ = a.length;
                            for (g = new Array(_), c = 0; c < h.length; c += 3) m = h[c], g[m] = a[m];
                        } else g = a;
                        for (c = 0, d = h.length; c < d; ) u = g[h[c++]], s = h[c++], o = h[c++], s ? (s.scope ? (l = e.$new(), 
                        C.$$addScopeInfo(Xn(u), l)) : l = e, f = s.transcludeOnThisElement ? O(e, s.transclude, i, s.elementTranscludeOnThisElement) : !s.templateOnThisElement && i ? i : !i && t ? O(e, t) : null, 
                        s(o, l, u, r, f)) : o && o(e, u.childNodes, n, i);
                    }
                    for (var u, l, c, d, m, f, p, h = [], g = 0; g < e.length; g++) u = new se(), l = P(e[g], [], u, 0 === g ? r : n, i), 
                    c = l.length ? V(l, e[g], u, t, a, null, [], [], s) : null, c && c.scope && C.$$addScopeClass(u.$$element), 
                    m = c && c.terminal || !(d = e[g].childNodes) || !d.length ? null : H(d, c ? (c.transcludeOnThisElement || !c.templateOnThisElement) && c.transclude : t), 
                    (c || m) && (h.push(g, c, m), f = !0, p = p || c), s = null;
                    return f ? o : null;
                }
                function O(e, t, n, a) {
                    var r = function(a, r, i, s, o) {
                        return a || (a = e.$new(!1, o), a.$$transcluded = !0), t(a, r, {
                            parentBoundTranscludeFn: n,
                            transcludeControllers: i,
                            futureParentElement: s
                        });
                    };
                    return r;
                }
                function P(e, t, n, a, r) {
                    var i, s, o = e.nodeType, u = n.$attr;
                    switch (o) {
                      case _a:
                        q(t, Qe(j(e)), "E", a, r);
                        for (var d, m, f, p, h, g, _ = e.attributes, v = 0, M = _ && _.length; v < M; v++) {
                            var $ = !1, L = !1;
                            d = _[v], m = d.name, h = da(d.value), p = Qe(m), (g = de.test(p)) && (m = m.replace(Ga, "").substr(8).replace(/_(.)/g, function(e, t) {
                                return t.toUpperCase();
                            }));
                            var k = p.replace(/(Start|End)$/, "");
                            z(k) && p === k + "Start" && ($ = m, L = m.substr(0, m.length - 5) + "end", m = m.substr(0, m.length - 6)), 
                            f = Qe(m.toLowerCase()), u[f] = m, !g && n.hasOwnProperty(f) || (n[f] = h, Oe(e, f) && (n[f] = !0)), 
                            ee(e, t, h, f, g), q(t, f, "A", a, r, $, L);
                        }
                        if (s = e.className, b(s) && (s = s.animVal), y(s) && "" !== s) for (;i = c.exec(s); ) f = Qe(i[2]), 
                        q(t, f, "C", a, r) && (n[f] = da(i[3])), s = s.substr(i.index + i[0].length);
                        break;

                      case va:
                        Z(t, e.nodeValue);
                        break;

                      case ba:
                        try {
                            i = l.exec(e.nodeValue), i && (f = Qe(i[1]), q(t, f, "M", a, r) && (n[f] = da(i[2])));
                        } catch (e) {}
                    }
                    return t.sort(J), t;
                }
                function F(e, t, n) {
                    var a = [], r = 0;
                    if (t && e.hasAttribute && e.hasAttribute(t)) {
                        do {
                            if (!e) throw Ba("uterdir", "Unterminated attribute, found '{0}' but no matching '{1}' found.", t, n);
                            e.nodeType == _a && (e.hasAttribute(t) && r++, e.hasAttribute(n) && r--), a.push(e), 
                            e = e.nextSibling;
                        } while (r > 0);
                    } else a.push(e);
                    return Xn(a);
                }
                function U(e, t, n) {
                    return function(a, r, i, s, o) {
                        return r = F(r[0], t, n), e(a, r, i, s, o);
                    };
                }
                function V(e, s, o, u, l, c, d, m, f) {
                    function p(e, t, n, a) {
                        e && (n && (e = U(e, n, a)), e.require = w.require, e.directiveName = Y, (j === w || w.$$isolateScope) && (e = ae(e, {
                            isolateScope: !0
                        })), d.push(e)), t && (n && (t = U(t, n, a)), t.require = w.require, t.directiveName = Y, 
                        (j === w || w.$$isolateScope) && (t = ae(t, {
                            isolateScope: !0
                        })), m.push(t));
                    }
                    function h(e, t, n, a) {
                        var r, s, o = "data", u = !1, l = n;
                        if (y(t)) {
                            if (s = t.match(_), t = t.substring(s[0].length), s[3] && (s[1] ? s[3] = null : s[1] = s[3]), 
                            "^" === s[1] ? o = "inheritedData" : "^^" === s[1] && (o = "inheritedData", l = n.parent()), 
                            "?" === s[2] && (u = !0), r = null, a && "data" === o && (r = a[t]) && (r = r.instance), 
                            r = r || l[o]("$" + t + "Controller"), !r && !u) throw Ba("ctreq", "Controller '{0}', required by directive '{1}', can't be found!", t, e);
                            return r || null;
                        }
                        return ca(t) && (r = [], i(t, function(t) {
                            r.push(h(e, t, n, a));
                        })), r;
                    }
                    function M(e, t, r, u, l) {
                        function c(e, t, a) {
                            var r;
                            return D(e) || (a = t, t = e, e = n), z && (r = M), a || (a = z ? L.parent() : L), 
                            l(e, t, r, a, S);
                        }
                        var f, p, _, b, y, M, $, L, w;
                        if (s === r ? (w = o, L = o.$$element) : (L = Xn(r), w = new se(L, o)), j && (y = t.$new(!0)), 
                        l && ($ = c, $.$$boundTransclude = l), H && (k = {}, M = {}, i(H, function(e) {
                            var n, a = {
                                $scope: e === j || e.$$isolateScope ? y : t,
                                $element: L,
                                $attrs: w,
                                $transclude: $
                            };
                            b = e.controller, "@" == b && (b = w[e.name]), n = v(b, a, !0, e.controllerAs), 
                            M[e.name] = n, z || L.data("$" + e.name + "Controller", n.instance), k[e.name] = n;
                        })), j) {
                            C.$$addScopeInfo(L, y, !0, !(A && (A === j || A === j.$$originalDirective))), C.$$addScopeClass(L, !0);
                            var Y = k && k[j.name], T = y;
                            Y && Y.identifier && j.bindToController === !0 && (T = Y.instance), i(y.$$isolateBindings = j.$$isolateBindings, function(e, n) {
                                var r, i, s, o, u = e.attrName, l = e.optional, c = e.mode;
                                switch (c) {
                                  case "@":
                                    w.$observe(u, function(e) {
                                        T[n] = e;
                                    }), w.$$observers[u].$$scope = t, w[u] && (T[n] = a(w[u])(t));
                                    break;

                                  case "=":
                                    if (l && !w[u]) return;
                                    i = g(w[u]), o = i.literal ? I : function(e, t) {
                                        return e === t || e !== e && t !== t;
                                    }, s = i.assign || function() {
                                        throw r = T[n] = i(t), Ba("nonassign", "Expression '{0}' used with directive '{1}' is non-assignable!", w[u], j.name);
                                    }, r = T[n] = i(t);
                                    var d = function(e) {
                                        return o(e, T[n]) || (o(e, r) ? s(t, e = T[n]) : T[n] = e), r = e;
                                    };
                                    d.$stateful = !0;
                                    var m;
                                    m = e.collection ? t.$watchCollection(w[u], d) : t.$watch(g(w[u], d), null, i.literal), 
                                    y.$on("$destroy", m);
                                    break;

                                  case "&":
                                    i = g(w[u]), T[n] = function(e) {
                                        return i(t, e);
                                    };
                                }
                            });
                        }
                        for (k && (i(k, function(e) {
                            e();
                        }), k = null), f = 0, p = d.length; f < p; f++) _ = d[f], ie(_, _.isolateScope ? y : t, L, w, _.require && h(_.directiveName, _.require, L, M), $);
                        var S = t;
                        for (j && (j.template || null === j.templateUrl) && (S = y), e && e(S, r.childNodes, n, l), 
                        f = m.length - 1; f >= 0; f--) _ = m[f], ie(_, _.isolateScope ? y : t, L, w, _.require && h(_.directiveName, _.require, L, M), $);
                    }
                    f = f || {};
                    for (var $, k, w, Y, T, S, x, E = -Number.MAX_VALUE, H = f.controllerDirectives, j = f.newIsolateScopeDirective, A = f.templateDirective, O = f.nonTlbTranscludeDirective, V = !1, q = !1, z = f.hasElementTranscludeDirective, J = o.$$element = Xn(s), Z = c, X = u, ee = 0, ne = e.length; ee < ne; ee++) {
                        w = e[ee];
                        var re = w.$$start, oe = w.$$end;
                        if (re && (J = F(s, re, oe)), T = n, E > w.priority) break;
                        if ((x = w.scope) && (w.templateUrl || (b(x) ? (K("new/isolated scope", j || $, w, J), 
                        j = w) : K("new/isolated scope", j, w, J)), $ = $ || w), Y = w.name, !w.templateUrl && w.controller && (x = w.controller, 
                        H = H || {}, K("'" + Y + "' controller", H[Y], w, J), H[Y] = w), (x = w.transclude) && (V = !0, 
                        w.$$tlb || (K("transclusion", O, w, J), O = w), "element" == x ? (z = !0, E = w.priority, 
                        T = J, J = o.$$element = Xn(t.createComment(" " + Y + ": " + o[Y] + " ")), s = J[0], 
                        te(l, N(T), s), X = C(T, u, E, Z && Z.name, {
                            nonTlbTranscludeDirective: O
                        })) : (T = Xn(Me(s)).contents(), J.empty(), X = C(T, u))), w.template) if (q = !0, 
                        K("template", A, w, J), A = w, x = L(w.template) ? w.template(J, o) : w.template, 
                        x = ce(x), w.replace) {
                            if (Z = w, T = ge(x) ? [] : et(Q(w.templateNamespace, da(x))), s = T[0], 1 != T.length || s.nodeType !== _a) throw Ba("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", Y, "");
                            te(l, J, s);
                            var ue = {
                                $attr: {}
                            }, le = P(s, [], ue), de = e.splice(ee + 1, e.length - (ee + 1));
                            j && W(le), e = e.concat(le).concat(de), B(o, ue), ne = e.length;
                        } else J.html(x);
                        if (w.templateUrl) q = !0, K("template", A, w, J), A = w, w.replace && (Z = w), 
                        M = G(e.splice(ee, e.length - ee), J, o, l, V && X, d, m, {
                            controllerDirectives: H,
                            newIsolateScopeDirective: j,
                            templateDirective: A,
                            nonTlbTranscludeDirective: O
                        }), ne = e.length; else if (w.compile) try {
                            S = w.compile(J, o, X), L(S) ? p(null, S, re, oe) : S && p(S.pre, S.post, re, oe);
                        } catch (e) {
                            r(e, R(J));
                        }
                        w.terminal && (M.terminal = !0, E = Math.max(E, w.priority));
                    }
                    return M.scope = $ && $.scope === !0, M.transcludeOnThisElement = V, M.elementTranscludeOnThisElement = z, 
                    M.templateOnThisElement = q, M.transclude = X, f.hasElementTranscludeDirective = z, 
                    M;
                }
                function W(e) {
                    for (var t = 0, n = e.length; t < n; t++) e[t] = f(e[t], {
                        $$isolateScope: !0
                    });
                }
                function q(t, a, i, u, l, c, d) {
                    if (a === l) return null;
                    var m = null;
                    if (s.hasOwnProperty(a)) for (var p, h = e.get(a + o), g = 0, _ = h.length; g < _; g++) try {
                        p = h[g], (u === n || u > p.priority) && p.restrict.indexOf(i) != -1 && (c && (p = f(p, {
                            $$start: c,
                            $$end: d
                        })), t.push(p), m = p);
                    } catch (e) {
                        r(e);
                    }
                    return m;
                }
                function z(t) {
                    if (s.hasOwnProperty(t)) for (var n, a = e.get(t + o), r = 0, i = a.length; r < i; r++) if (n = a[r], 
                    n.multiElement) return !0;
                    return !1;
                }
                function B(e, t) {
                    var n = t.$attr, a = e.$attr, r = e.$$element;
                    i(e, function(a, r) {
                        "$" != r.charAt(0) && (t[r] && t[r] !== a && (a += ("style" === r ? ";" : " ") + t[r]), 
                        e.$set(r, a, !0, n[r]));
                    }), i(t, function(t, i) {
                        "class" == i ? (x(r, t), e.class = (e.class ? e.class + " " : "") + t) : "style" == i ? (r.attr("style", r.attr("style") + ";" + t), 
                        e.style = (e.style ? e.style + ";" : "") + t) : "$" == i.charAt(0) || e.hasOwnProperty(i) || (e[i] = t, 
                        a[i] = n[i]);
                    });
                }
                function G(e, t, n, a, r, s, o, l) {
                    var c, d, m = [], p = t[0], h = e.shift(), g = f(h, {
                        templateUrl: null,
                        transclude: null,
                        replace: null,
                        $$originalDirective: h
                    }), _ = L(h.templateUrl) ? h.templateUrl(t, n) : h.templateUrl, v = h.templateNamespace;
                    return t.empty(), u(Y.getTrustedResourceUrl(_)).then(function(u) {
                        var f, y, M, $;
                        if (u = ce(u), h.replace) {
                            if (M = ge(u) ? [] : et(Q(v, da(u))), f = M[0], 1 != M.length || f.nodeType !== _a) throw Ba("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", h.name, _);
                            y = {
                                $attr: {}
                            }, te(a, t, f);
                            var L = P(f, [], y);
                            b(h.scope) && W(L), e = L.concat(e), B(n, y);
                        } else f = p, t.html(u);
                        for (e.unshift(g), c = V(e, f, n, r, t, h, s, o, l), i(a, function(e, n) {
                            e == f && (a[n] = t[0]);
                        }), d = H(t[0].childNodes, r); m.length; ) {
                            var k = m.shift(), w = m.shift(), D = m.shift(), Y = m.shift(), T = t[0];
                            if (!k.$$destroyed) {
                                if (w !== p) {
                                    var S = w.className;
                                    l.hasElementTranscludeDirective && h.replace || (T = Me(f)), te(D, Xn(w), T), x(Xn(T), S);
                                }
                                $ = c.transcludeOnThisElement ? O(k, c.transclude, Y) : Y, c(d, k, T, a, $);
                            }
                        }
                        m = null;
                    }), function(e, t, n, a, r) {
                        var i = r;
                        t.$$destroyed || (m ? m.push(t, n, a, i) : (c.transcludeOnThisElement && (i = O(t, c.transclude, r)), 
                        c(d, t, n, a, i)));
                    };
                }
                function J(e, t) {
                    var n = t.priority - e.priority;
                    return 0 !== n ? n : e.name !== t.name ? e.name < t.name ? -1 : 1 : e.index - t.index;
                }
                function K(e, t, n, a) {
                    if (t) throw Ba("multidir", "Multiple directives [{0}, {1}] asking for {2} on: {3}", t.name, n.name, e, R(a));
                }
                function Z(e, t) {
                    var n = a(t, !0);
                    n && e.push({
                        priority: 0,
                        compile: function(e) {
                            var t = e.parent(), a = !!t.length;
                            return a && C.$$addBindingClass(t), function(e, t) {
                                var r = t.parent();
                                a || C.$$addBindingClass(r), C.$$addBindingInfo(r, n.expressions), e.$watch(n, function(e) {
                                    t[0].nodeValue = e;
                                });
                            };
                        }
                    });
                }
                function Q(e, n) {
                    switch (e = Bn(e || "html")) {
                      case "svg":
                      case "math":
                        var a = t.createElement("div");
                        return a.innerHTML = "<" + e + ">" + n + "</" + e + ">", a.childNodes[0].childNodes;

                      default:
                        return n;
                    }
                }
                function X(e, t) {
                    if ("srcdoc" == t) return Y.HTML;
                    var n = j(e);
                    return "xlinkHref" == t || "form" == n && "action" == t || "img" != n && ("src" == t || "ngSrc" == t) ? Y.RESOURCE_URL : void 0;
                }
                function ee(e, t, n, r, i) {
                    var s = X(e, r);
                    i = m[r] || i;
                    var o = a(n, !0, s, i);
                    if (o) {
                        if ("multiple" === r && "select" === j(e)) throw Ba("selmulti", "Binding to the 'multiple' attribute is not supported. Element: {0}", R(e));
                        t.push({
                            priority: 100,
                            compile: function() {
                                return {
                                    pre: function(e, t, u) {
                                        var l = u.$$observers || (u.$$observers = {});
                                        if (M.test(r)) throw Ba("nodomevents", "Interpolations for HTML DOM event attributes are disallowed.  Please use the ng- versions (such as ng-click instead of onclick) instead.");
                                        var c = u[r];
                                        c !== n && (o = c && a(c, !0, s, i), n = c), o && (u[r] = o(e), (l[r] || (l[r] = [])).$$inter = !0, 
                                        (u.$$observers && u.$$observers[r].$$scope || e).$watch(o, function(e, t) {
                                            "class" === r && e != t ? u.$updateClass(e, t) : u.$set(r, e);
                                        }));
                                    }
                                };
                            }
                        });
                    }
                }
                function te(e, n, a) {
                    var r, i, s = n[0], o = n.length, u = s.parentNode;
                    if (e) for (r = 0, i = e.length; r < i; r++) if (e[r] == s) {
                        e[r++] = a;
                        for (var l = r, c = l + o - 1, d = e.length; l < d; l++, c++) c < d ? e[l] = e[c] : delete e[l];
                        e.length -= o - 1, e.context === s && (e.context = a);
                        break;
                    }
                    u && u.replaceChild(a, s);
                    var m = t.createDocumentFragment();
                    m.appendChild(s), Xn(a).data(Xn(s).data()), ea ? (la = !0, ea.cleanData([ s ])) : delete Xn.cache[s[Xn.expando]];
                    for (var f = 1, p = n.length; f < p; f++) {
                        var h = n[f];
                        Xn(h).remove(), m.appendChild(h), delete n[f];
                    }
                    n[0] = a, n.length = 1;
                }
                function ae(e, t) {
                    return d(function() {
                        return e.apply(null, arguments);
                    }, e, t);
                }
                function ie(e, t, n, a, i, s) {
                    try {
                        e(t, n, a, i, s);
                    } catch (e) {
                        r(e, R(n));
                    }
                }
                var se = function(e, t) {
                    if (t) {
                        var n, a, r, i = Object.keys(t);
                        for (n = 0, a = i.length; n < a; n++) r = i[n], this[r] = t[r];
                    } else this.$attr = {};
                    this.$$element = e;
                };
                se.prototype = {
                    $normalize: Qe,
                    $addClass: function(e) {
                        e && e.length > 0 && T.addClass(this.$$element, e);
                    },
                    $removeClass: function(e) {
                        e && e.length > 0 && T.removeClass(this.$$element, e);
                    },
                    $updateClass: function(e, t) {
                        var n = Xe(e, t);
                        n && n.length && T.addClass(this.$$element, n);
                        var a = Xe(t, e);
                        a && a.length && T.removeClass(this.$$element, a);
                    },
                    $set: function(e, t, a, s) {
                        var o, u = this.$$element[0], l = Oe(u, e), c = Pe(u, e), d = e;
                        if (l ? (this.$$element.prop(e, t), s = l) : c && (this[c] = t, d = c), this[e] = t, 
                        s ? this.$attr[e] = s : (s = this.$attr[e], s || (this.$attr[e] = s = ne(e, "-"))), 
                        o = j(this.$$element), "a" === o && "href" === e || "img" === o && "src" === e) this[e] = t = S(t, "src" === e); else if ("img" === o && "srcset" === e) {
                            for (var m = "", f = da(t), p = /(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/, h = /\s/.test(f) ? p : /(,)/, g = f.split(h), _ = Math.floor(g.length / 2), v = 0; v < _; v++) {
                                var b = 2 * v;
                                m += S(da(g[b]), !0), m += " " + da(g[b + 1]);
                            }
                            var y = da(g[2 * v]).split(/\s/);
                            m += S(da(y[0]), !0), 2 === y.length && (m += " " + da(y[1])), this[e] = t = m;
                        }
                        a !== !1 && (null === t || t === n ? this.$$element.removeAttr(s) : this.$$element.attr(s, t));
                        var M = this.$$observers;
                        M && i(M[d], function(e) {
                            try {
                                e(t);
                            } catch (e) {
                                r(e);
                            }
                        });
                    },
                    $observe: function(e, t) {
                        var n = this, a = n.$$observers || (n.$$observers = le()), r = a[e] || (a[e] = []);
                        return r.push(t), k.$evalAsync(function() {
                            !r.$$inter && n.hasOwnProperty(e) && t(n[e]);
                        }), function() {
                            A(r, t);
                        };
                    }
                };
                var oe = a.startSymbol(), ue = a.endSymbol(), ce = "{{" == oe || "}}" == ue ? h : function(e) {
                    return e.replace(/\{\{/g, oe).replace(/}}/g, ue);
                }, de = /^ngAttr[A-Z]/;
                return C.$$addBindingInfo = $ ? function(e, t) {
                    var n = e.data("$binding") || [];
                    ca(t) ? n = n.concat(t) : n.push(t), e.data("$binding", n);
                } : p, C.$$addBindingClass = $ ? function(e) {
                    x(e, "ng-binding");
                } : p, C.$$addScopeInfo = $ ? function(e, t, n, a) {
                    var r = n ? a ? "$isolateScopeNoTemplate" : "$isolateScope" : "$scope";
                    e.data(r, t);
                } : p, C.$$addScopeClass = $ ? function(e, t) {
                    x(e, t ? "ng-isolate-scope" : "ng-scope");
                } : p, C;
            } ];
        }
        function Qe(e) {
            return he(e.replace(Ga, ""));
        }
        function Xe(e, t) {
            var n = "", a = e.split(/\s+/), r = t.split(/\s+/);
            e: for (var i = 0; i < a.length; i++) {
                for (var s = a[i], o = 0; o < r.length; o++) if (s == r[o]) continue e;
                n += (n.length > 0 ? " " : "") + s;
            }
            return n;
        }
        function et(e) {
            e = Xn(e);
            var t = e.length;
            if (t <= 1) return e;
            for (;t--; ) {
                var n = e[t];
                n.nodeType === ba && aa.call(e, t, 1);
            }
            return e;
        }
        function tt() {
            var e = {}, t = !1, r = /^(\S+)(\s+as\s+(\w+))?$/;
            this.register = function(t, n) {
                se(t, "controller"), b(t) ? d(e, t) : e[t] = n;
            }, this.allowGlobals = function() {
                t = !0;
            }, this.$get = [ "$injector", "$window", function(i, s) {
                function o(e, t, n, r) {
                    if (!e || !b(e.$scope)) throw a("$controller")("noscp", "Cannot export controller '{0}' as '{1}'! No $scope object provided via `locals`.", r, t);
                    e.$scope[t] = n;
                }
                return function(a, u, l, c) {
                    var m, f, p, h;
                    if (l = l === !0, c && y(c) && (h = c), y(a)) {
                        if (f = a.match(r), !f) throw Ja("ctrlfmt", "Badly formed controller string '{0}'. Must match `__name__ as __id__` or `__name__`.", a);
                        p = f[1], h = h || f[3], a = e.hasOwnProperty(p) ? e[p] : oe(u.$scope, p, !0) || (t ? oe(s, p, !0) : n), 
                        ie(a, p, !0);
                    }
                    if (l) {
                        var g = (ca(a) ? a[a.length - 1] : a).prototype;
                        return m = Object.create(g || null), h && o(u, h, m, p || a.name), d(function() {
                            return i.invoke(a, m, u, p), m;
                        }, {
                            instance: m,
                            identifier: h
                        });
                    }
                    return m = i.instantiate(a, u, p), h && o(u, h, m, p || a.name), m;
                };
            } ];
        }
        function nt() {
            this.$get = [ "$window", function(e) {
                return Xn(e.document);
            } ];
        }
        function at() {
            this.$get = [ "$log", function(e) {
                return function(t, n) {
                    e.error.apply(e, arguments);
                };
            } ];
        }
        function rt(e, t) {
            if (y(e)) {
                var n = e.replace(er, "").trim();
                if (n) {
                    var a = t("Content-Type");
                    (a && 0 === a.indexOf(Ka) || it(n)) && (e = q(n));
                }
            }
            return e;
        }
        function it(e) {
            var t = e.match(Qa);
            return t && Xa[t[0]].test(e);
        }
        function st(e) {
            var t, n, a, r = le();
            return e ? (i(e.split("\n"), function(e) {
                a = e.indexOf(":"), t = Bn(da(e.substr(0, a))), n = da(e.substr(a + 1)), t && (r[t] = r[t] ? r[t] + ", " + n : n);
            }), r) : r;
        }
        function ot(e) {
            var t = b(e) ? e : n;
            return function(n) {
                if (t || (t = st(e)), n) {
                    var a = t[Bn(n)];
                    return void 0 === a && (a = null), a;
                }
                return t;
            };
        }
        function ut(e, t, n, a) {
            return L(a) ? a(e, t, n) : (i(a, function(a) {
                e = a(e, t, n);
            }), e);
        }
        function lt(e) {
            return 200 <= e && e < 300;
        }
        function ct() {
            var e = this.defaults = {
                transformResponse: [ rt ],
                transformRequest: [ function(e) {
                    return !b(e) || Y(e) || S(e) || T(e) ? e : W(e);
                } ],
                headers: {
                    common: {
                        Accept: "application/json, text/plain, */*"
                    },
                    post: P(Za),
                    put: P(Za),
                    patch: P(Za)
                },
                xsrfCookieName: "XSRF-TOKEN",
                xsrfHeaderName: "X-XSRF-TOKEN"
            }, t = !1;
            this.useApplyAsync = function(e) {
                return v(e) ? (t = !!e, this) : t;
            };
            var r = this.interceptors = [];
            this.$get = [ "$httpBackend", "$browser", "$cacheFactory", "$rootScope", "$q", "$injector", function(s, u, l, c, m, f) {
                function p(t) {
                    function r(e) {
                        var t = d({}, e);
                        return e.data ? t.data = ut(e.data, e.headers, e.status, u.transformResponse) : t.data = e.data, 
                        lt(e.status) ? t : m.reject(t);
                    }
                    function s(e) {
                        var t, n = {};
                        return i(e, function(e, a) {
                            L(e) ? (t = e(), null != t && (n[a] = t)) : n[a] = e;
                        }), n;
                    }
                    function o(t) {
                        var n, a, r, i = e.headers, o = d({}, t.headers);
                        i = d({}, i.common, i[Bn(t.method)]);
                        e: for (n in i) {
                            a = Bn(n);
                            for (r in o) if (Bn(r) === a) continue e;
                            o[n] = i[n];
                        }
                        return s(o);
                    }
                    if (!oa.isObject(t)) throw a("$http")("badreq", "Http request configuration must be an object.  Received: {0}", t);
                    var u = d({
                        method: "get",
                        transformRequest: e.transformRequest,
                        transformResponse: e.transformResponse
                    }, t);
                    u.headers = o(t), u.method = Jn(u.method);
                    var l = function(t) {
                        var a = t.headers, s = ut(t.data, ot(a), n, t.transformRequest);
                        return _(s) && i(a, function(e, t) {
                            "content-type" === Bn(t) && delete a[t];
                        }), _(t.withCredentials) && !_(e.withCredentials) && (t.withCredentials = e.withCredentials), 
                        M(t, s).then(r, r);
                    }, c = [ l, n ], f = m.when(u);
                    for (i(D, function(e) {
                        (e.request || e.requestError) && c.unshift(e.request, e.requestError), (e.response || e.responseError) && c.push(e.response, e.responseError);
                    }); c.length; ) {
                        var p = c.shift(), h = c.shift();
                        f = f.then(p, h);
                    }
                    return f.success = function(e) {
                        return f.then(function(t) {
                            e(t.data, t.status, t.headers, u);
                        }), f;
                    }, f.error = function(e) {
                        return f.then(null, function(t) {
                            e(t.data, t.status, t.headers, u);
                        }), f;
                    }, f;
                }
                function h(e) {
                    i(arguments, function(e) {
                        p[e] = function(t, n) {
                            return p(d(n || {}, {
                                method: e,
                                url: t
                            }));
                        };
                    });
                }
                function g(e) {
                    i(arguments, function(e) {
                        p[e] = function(t, n, a) {
                            return p(d(a || {}, {
                                method: e,
                                url: t,
                                data: n
                            }));
                        };
                    });
                }
                function M(a, r) {
                    function i(e, n, a, r) {
                        function i() {
                            o(n, e, a, r);
                        }
                        f && (lt(e) ? f.put($, [ e, n, st(a), r ]) : f.remove($)), t ? c.$applyAsync(i) : (i(), 
                        c.$$phase || c.$apply());
                    }
                    function o(e, t, n, r) {
                        t = Math.max(t, 0), (lt(t) ? g.resolve : g.reject)({
                            data: e,
                            status: t,
                            headers: ot(n),
                            config: a,
                            statusText: r
                        });
                    }
                    function l(e) {
                        o(e.data, e.status, P(e.headers()), e.statusText);
                    }
                    function d() {
                        var e = p.pendingRequests.indexOf(a);
                        e !== -1 && p.pendingRequests.splice(e, 1);
                    }
                    var f, h, g = m.defer(), y = g.promise, M = a.headers, $ = k(a.url, a.params);
                    if (p.pendingRequests.push(a), y.then(d, d), !a.cache && !e.cache || a.cache === !1 || "GET" !== a.method && "JSONP" !== a.method || (f = b(a.cache) ? a.cache : b(e.cache) ? e.cache : w), 
                    f && (h = f.get($), v(h) ? C(h) ? h.then(l, l) : ca(h) ? o(h[1], h[0], P(h[2]), h[3]) : o(h, 200, {}, "OK") : f.put($, y)), 
                    _(h)) {
                        var L = rn(a.url) ? u.cookies()[a.xsrfCookieName || e.xsrfCookieName] : n;
                        L && (M[a.xsrfHeaderName || e.xsrfHeaderName] = L), s(a.method, $, r, i, M, a.timeout, a.withCredentials, a.responseType);
                    }
                    return y;
                }
                function k(e, t) {
                    if (!t) return e;
                    var n = [];
                    return o(t, function(e, t) {
                        null === e || _(e) || (ca(e) || (e = [ e ]), i(e, function(e) {
                            b(e) && (e = $(e) ? e.toISOString() : W(e)), n.push(K(t) + "=" + K(e));
                        }));
                    }), n.length > 0 && (e += (e.indexOf("?") == -1 ? "?" : "&") + n.join("&")), e;
                }
                var w = l("$http"), D = [];
                return i(r, function(e) {
                    D.unshift(y(e) ? f.get(e) : f.invoke(e));
                }), p.pendingRequests = [], h("get", "delete", "head", "jsonp"), g("post", "put", "patch"), 
                p.defaults = e, p;
            } ];
        }
        function dt() {
            return new e.XMLHttpRequest();
        }
        function mt() {
            this.$get = [ "$browser", "$window", "$document", function(e, t, n) {
                return ft(e, dt, e.defer, t.angular.callbacks, n[0]);
            } ];
        }
        function ft(e, t, a, r, s) {
            function o(e, t, n) {
                var a = s.createElement("script"), i = null;
                return a.type = "text/javascript", a.src = e, a.async = !0, i = function(e) {
                    Da(a, "load", i), Da(a, "error", i), s.body.removeChild(a), a = null;
                    var o = -1, u = "unknown";
                    e && ("load" !== e.type || r[t].called || (e = {
                        type: "error"
                    }), u = e.type, o = "error" === e.type ? 404 : 200), n && n(o, u);
                }, wa(a, "load", i), wa(a, "error", i), s.body.appendChild(a), i;
            }
            return function(s, u, l, c, d, m, f, h) {
                function g() {
                    y && y(), M && M.abort();
                }
                function _(t, r, i, s, o) {
                    L !== n && a.cancel(L), y = M = null, t(r, i, s, o), e.$$completeOutstandingRequest(p);
                }
                if (e.$$incOutstandingRequestCount(), u = u || e.url(), "jsonp" == Bn(s)) {
                    var b = "_" + (r.counter++).toString(36);
                    r[b] = function(e) {
                        r[b].data = e, r[b].called = !0;
                    };
                    var y = o(u.replace("JSON_CALLBACK", "angular.callbacks." + b), b, function(e, t) {
                        _(c, e, r[b].data, "", t), r[b] = p;
                    });
                } else {
                    var M = t();
                    M.open(s, u, !0), i(d, function(e, t) {
                        v(e) && M.setRequestHeader(t, e);
                    }), M.onload = function() {
                        var e = M.statusText || "", t = "response" in M ? M.response : M.responseText, n = 1223 === M.status ? 204 : M.status;
                        0 === n && (n = t ? 200 : "file" == an(u).protocol ? 404 : 0), _(c, n, t, M.getAllResponseHeaders(), e);
                    };
                    var $ = function() {
                        _(c, -1, null, null, "");
                    };
                    if (M.onerror = $, M.onabort = $, f && (M.withCredentials = !0), h) try {
                        M.responseType = h;
                    } catch (e) {
                        if ("json" !== h) throw e;
                    }
                    M.send(l || null);
                }
                if (m > 0) var L = a(g, m); else C(m) && m.then(g);
            };
        }
        function pt() {
            var e = "{{", t = "}}";
            this.startSymbol = function(t) {
                return t ? (e = t, this) : e;
            }, this.endSymbol = function(e) {
                return e ? (t = e, this) : t;
            }, this.$get = [ "$parse", "$exceptionHandler", "$sce", function(n, a, r) {
                function i(e) {
                    return "\\\\\\" + e;
                }
                function s(i, s, m, f) {
                    function p(n) {
                        return n.replace(l, e).replace(c, t);
                    }
                    function h(e) {
                        try {
                            return e = S(e), f && !v(e) ? e : x(e);
                        } catch (e) {
                            var t = tr("interr", "Can't interpolate: {0}\n{1}", i, e.toString());
                            a(t);
                        }
                    }
                    f = !!f;
                    for (var g, b, y, M = 0, $ = [], k = [], w = i.length, D = [], Y = []; M < w; ) {
                        if ((g = i.indexOf(e, M)) == -1 || (b = i.indexOf(t, g + o)) == -1) {
                            M !== w && D.push(p(i.substring(M)));
                            break;
                        }
                        M !== g && D.push(p(i.substring(M, g))), y = i.substring(g + o, b), $.push(y), k.push(n(y, h)), 
                        M = b + u, Y.push(D.length), D.push("");
                    }
                    if (m && D.length > 1) throw tr("noconcat", "Error while interpolating: {0}\nStrict Contextual Escaping disallows interpolations that concatenate multiple expressions when a trusted value is required.  See http://docs.angularjs.org/api/ng.$sce", i);
                    if (!s || $.length) {
                        var T = function(e) {
                            for (var t = 0, n = $.length; t < n; t++) {
                                if (f && _(e[t])) return;
                                D[Y[t]] = e[t];
                            }
                            return D.join("");
                        }, S = function(e) {
                            return m ? r.getTrusted(m, e) : r.valueOf(e);
                        }, x = function(e) {
                            if (null == e) return "";
                            switch (typeof e) {
                              case "string":
                                break;

                              case "number":
                                e = "" + e;
                                break;

                              default:
                                e = W(e);
                            }
                            return e;
                        };
                        return d(function(e) {
                            var t = 0, n = $.length, r = new Array(n);
                            try {
                                for (;t < n; t++) r[t] = k[t](e);
                                return T(r);
                            } catch (e) {
                                var s = tr("interr", "Can't interpolate: {0}\n{1}", i, e.toString());
                                a(s);
                            }
                        }, {
                            exp: i,
                            expressions: $,
                            $$watchDelegate: function(e, t, n) {
                                var a;
                                return e.$watchGroup(k, function(n, r) {
                                    var i = T(n);
                                    L(t) && t.call(this, i, n !== r ? a : i, e), a = i;
                                }, n);
                            }
                        });
                    }
                }
                var o = e.length, u = t.length, l = new RegExp(e.replace(/./g, i), "g"), c = new RegExp(t.replace(/./g, i), "g");
                return s.startSymbol = function() {
                    return e;
                }, s.endSymbol = function() {
                    return t;
                }, s;
            } ];
        }
        function ht() {
            this.$get = [ "$rootScope", "$window", "$q", "$$q", function(e, t, n, a) {
                function r(r, s, o, u) {
                    var l = t.setInterval, c = t.clearInterval, d = 0, m = v(u) && !u, f = (m ? a : n).defer(), p = f.promise;
                    return o = v(o) ? o : 0, p.then(null, null, r), p.$$intervalId = l(function() {
                        f.notify(d++), o > 0 && d >= o && (f.resolve(d), c(p.$$intervalId), delete i[p.$$intervalId]), 
                        m || e.$apply();
                    }, s), i[p.$$intervalId] = f, p;
                }
                var i = {};
                return r.cancel = function(e) {
                    return !!(e && e.$$intervalId in i) && (i[e.$$intervalId].reject("canceled"), t.clearInterval(e.$$intervalId), 
                    delete i[e.$$intervalId], !0);
                }, r;
            } ];
        }
        function gt() {
            this.$get = function() {
                return {
                    id: "en-us",
                    NUMBER_FORMATS: {
                        DECIMAL_SEP: ".",
                        GROUP_SEP: ",",
                        PATTERNS: [ {
                            minInt: 1,
                            minFrac: 0,
                            maxFrac: 3,
                            posPre: "",
                            posSuf: "",
                            negPre: "-",
                            negSuf: "",
                            gSize: 3,
                            lgSize: 3
                        }, {
                            minInt: 1,
                            minFrac: 2,
                            maxFrac: 2,
                            posPre: "¤",
                            posSuf: "",
                            negPre: "(¤",
                            negSuf: ")",
                            gSize: 3,
                            lgSize: 3
                        } ],
                        CURRENCY_SYM: "$"
                    },
                    DATETIME_FORMATS: {
                        MONTH: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
                        SHORTMONTH: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
                        DAY: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
                        SHORTDAY: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(","),
                        AMPMS: [ "AM", "PM" ],
                        medium: "MMM d, y h:mm:ss a",
                        short: "M/d/yy h:mm a",
                        fullDate: "EEEE, MMMM d, y",
                        longDate: "MMMM d, y",
                        mediumDate: "MMM d, y",
                        shortDate: "M/d/yy",
                        mediumTime: "h:mm:ss a",
                        shortTime: "h:mm a"
                    },
                    pluralCat: function(e) {
                        return 1 === e ? "one" : "other";
                    }
                };
            };
        }
        function _t(e) {
            for (var t = e.split("/"), n = t.length; n--; ) t[n] = J(t[n]);
            return t.join("/");
        }
        function vt(e, t) {
            var n = an(e);
            t.$$protocol = n.protocol, t.$$host = n.hostname, t.$$port = m(n.port) || ar[n.protocol] || null;
        }
        function bt(e, t) {
            var n = "/" !== e.charAt(0);
            n && (e = "/" + e);
            var a = an(e);
            t.$$path = decodeURIComponent(n && "/" === a.pathname.charAt(0) ? a.pathname.substring(1) : a.pathname), 
            t.$$search = B(a.search), t.$$hash = decodeURIComponent(a.hash), t.$$path && "/" != t.$$path.charAt(0) && (t.$$path = "/" + t.$$path);
        }
        function yt(e, t) {
            if (0 === t.indexOf(e)) return t.substr(e.length);
        }
        function Mt(e) {
            var t = e.indexOf("#");
            return t == -1 ? e : e.substr(0, t);
        }
        function $t(e) {
            return e.replace(/(#.+)|#$/, "$1");
        }
        function Lt(e) {
            return e.substr(0, Mt(e).lastIndexOf("/") + 1);
        }
        function kt(e) {
            return e.substring(0, e.indexOf("/", e.indexOf("//") + 2));
        }
        function wt(e, t) {
            this.$$html5 = !0, t = t || "";
            var a = Lt(e);
            vt(e, this), this.$$parse = function(e) {
                var t = yt(a, e);
                if (!y(t)) throw rr("ipthprfx", 'Invalid url "{0}", missing path prefix "{1}".', e, a);
                bt(t, this), this.$$path || (this.$$path = "/"), this.$$compose();
            }, this.$$compose = function() {
                var e = G(this.$$search), t = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (e ? "?" + e : "") + t, this.$$absUrl = a + this.$$url.substr(1);
            }, this.$$parseLinkUrl = function(r, i) {
                if (i && "#" === i[0]) return this.hash(i.slice(1)), !0;
                var s, o, u;
                return (s = yt(e, r)) !== n ? (o = s, u = (s = yt(t, s)) !== n ? a + (yt("/", s) || s) : e + o) : (s = yt(a, r)) !== n ? u = a + s : a == r + "/" && (u = a), 
                u && this.$$parse(u), !!u;
            };
        }
        function Dt(e, t) {
            var n = Lt(e);
            vt(e, this), this.$$parse = function(a) {
                function r(e, t, n) {
                    var a, r = /^\/[A-Z]:(\/.*)/;
                    return 0 === t.indexOf(n) && (t = t.replace(n, "")), r.exec(t) ? e : (a = r.exec(e), 
                    a ? a[1] : e);
                }
                var i, s = yt(e, a) || yt(n, a);
                "#" === s.charAt(0) ? (i = yt(t, s), _(i) && (i = s)) : i = this.$$html5 ? s : "", 
                bt(i, this), this.$$path = r(this.$$path, i, e), this.$$compose();
            }, this.$$compose = function() {
                var n = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (n ? "?" + n : "") + a, this.$$absUrl = e + (this.$$url ? t + this.$$url : "");
            }, this.$$parseLinkUrl = function(t, n) {
                return Mt(e) == Mt(t) && (this.$$parse(t), !0);
            };
        }
        function Yt(e, t) {
            this.$$html5 = !0, Dt.apply(this, arguments);
            var n = Lt(e);
            this.$$parseLinkUrl = function(a, r) {
                if (r && "#" === r[0]) return this.hash(r.slice(1)), !0;
                var i, s;
                return e == Mt(a) ? i = a : (s = yt(n, a)) ? i = e + t + s : n === a + "/" && (i = n), 
                i && this.$$parse(i), !!i;
            }, this.$$compose = function() {
                var n = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (n ? "?" + n : "") + a, this.$$absUrl = e + t + this.$$url;
            };
        }
        function Tt(e) {
            return function() {
                return this[e];
            };
        }
        function St(e, t) {
            return function(n) {
                return _(n) ? this[e] : (this[e] = t(n), this.$$compose(), this);
            };
        }
        function xt() {
            var e = "", t = {
                enabled: !1,
                requireBase: !0,
                rewriteLinks: !0
            };
            this.hashPrefix = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.html5Mode = function(e) {
                return x(e) ? (t.enabled = e, this) : b(e) ? (x(e.enabled) && (t.enabled = e.enabled), 
                x(e.requireBase) && (t.requireBase = e.requireBase), x(e.rewriteLinks) && (t.rewriteLinks = e.rewriteLinks), 
                this) : t;
            }, this.$get = [ "$rootScope", "$browser", "$sniffer", "$rootElement", "$window", function(n, a, r, i, s) {
                function o(e, t, n) {
                    var r = l.url(), i = l.$$state;
                    try {
                        a.url(e, t, n), l.$$state = a.state();
                    } catch (e) {
                        throw l.url(r), l.$$state = i, e;
                    }
                }
                function u(e, t) {
                    n.$broadcast("$locationChangeSuccess", l.absUrl(), e, l.$$state, t);
                }
                var l, c, d, m = a.baseHref(), f = a.url();
                if (t.enabled) {
                    if (!m && t.requireBase) throw rr("nobase", "$location in HTML5 mode requires a <base> tag to be present!");
                    d = kt(f) + (m || "/"), c = r.history ? wt : Yt;
                } else d = Mt(f), c = Dt;
                l = new c(d, "#" + e), l.$$parseLinkUrl(f, f), l.$$state = a.state();
                var p = /^\s*(javascript|mailto):/i;
                i.on("click", function(e) {
                    if (t.rewriteLinks && !e.ctrlKey && !e.metaKey && !e.shiftKey && 2 != e.which && 2 != e.button) {
                        for (var r = Xn(e.target); "a" !== j(r[0]); ) if (r[0] === i[0] || !(r = r.parent())[0]) return;
                        var o = r.prop("href"), u = r.attr("href") || r.attr("xlink:href");
                        b(o) && "[object SVGAnimatedString]" === o.toString() && (o = an(o.animVal).href), 
                        p.test(o) || !o || r.attr("target") || e.isDefaultPrevented() || l.$$parseLinkUrl(o, u) && (e.preventDefault(), 
                        l.absUrl() != a.url() && (n.$apply(), s.angular["ff-684208-preventDefault"] = !0));
                    }
                }), $t(l.absUrl()) != $t(f) && a.url(l.absUrl(), !0);
                var h = !0;
                return a.onUrlChange(function(e, t) {
                    n.$evalAsync(function() {
                        var a, r = l.absUrl(), i = l.$$state;
                        l.$$parse(e), l.$$state = t, a = n.$broadcast("$locationChangeStart", e, r, t, i).defaultPrevented, 
                        l.absUrl() === e && (a ? (l.$$parse(r), l.$$state = i, o(r, !1, i)) : (h = !1, u(r, i)));
                    }), n.$$phase || n.$digest();
                }), n.$watch(function() {
                    var e = $t(a.url()), t = $t(l.absUrl()), i = a.state(), s = l.$$replace, c = e !== t || l.$$html5 && r.history && i !== l.$$state;
                    (h || c) && (h = !1, n.$evalAsync(function() {
                        var t = l.absUrl(), a = n.$broadcast("$locationChangeStart", t, e, l.$$state, i).defaultPrevented;
                        l.absUrl() === t && (a ? (l.$$parse(e), l.$$state = i) : (c && o(t, s, i === l.$$state ? null : l.$$state), 
                        u(e, i)));
                    })), l.$$replace = !1;
                }), l;
            } ];
        }
        function Ct() {
            var e = !0, t = this;
            this.debugEnabled = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.$get = [ "$window", function(n) {
                function a(e) {
                    return e instanceof Error && (e.stack ? e = e.message && e.stack.indexOf(e.message) === -1 ? "Error: " + e.message + "\n" + e.stack : e.stack : e.sourceURL && (e = e.message + "\n" + e.sourceURL + ":" + e.line)), 
                    e;
                }
                function r(e) {
                    var t = n.console || {}, r = t[e] || t.log || p, s = !1;
                    try {
                        s = !!r.apply;
                    } catch (e) {}
                    return s ? function() {
                        var e = [];
                        return i(arguments, function(t) {
                            e.push(a(t));
                        }), r.apply(t, e);
                    } : function(e, t) {
                        r(e, null == t ? "" : t);
                    };
                }
                return {
                    log: r("log"),
                    info: r("info"),
                    warn: r("warn"),
                    error: r("error"),
                    debug: function() {
                        var n = r("debug");
                        return function() {
                            e && n.apply(t, arguments);
                        };
                    }()
                };
            } ];
        }
        function Et(e, t) {
            if ("__defineGetter__" === e || "__defineSetter__" === e || "__lookupGetter__" === e || "__lookupSetter__" === e || "__proto__" === e) throw sr("isecfld", "Attempting to access a disallowed field in Angular expressions! Expression: {0}", t);
            return e;
        }
        function Ht(e, t) {
            if (e) {
                if (e.constructor === e) throw sr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e.window === e) throw sr("isecwindow", "Referencing the Window in Angular expressions is disallowed! Expression: {0}", t);
                if (e.children && (e.nodeName || e.prop && e.attr && e.find)) throw sr("isecdom", "Referencing DOM nodes in Angular expressions is disallowed! Expression: {0}", t);
                if (e === Object) throw sr("isecobj", "Referencing Object in Angular expressions is disallowed! Expression: {0}", t);
            }
            return e;
        }
        function jt(e, t) {
            if (e) {
                if (e.constructor === e) throw sr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e === or || e === ur || e === lr) throw sr("isecff", "Referencing call, apply or bind in Angular expressions is disallowed! Expression: {0}", t);
            }
        }
        function At(e) {
            return e.constant;
        }
        function Ot(e, t, n, a, r) {
            Ht(e, r), Ht(t, r);
            for (var i, s = n.split("."), o = 0; s.length > 1; o++) {
                i = Et(s.shift(), r);
                var u = 0 === o && t && t[i] || e[i];
                u || (u = {}, e[i] = u), e = Ht(u, r);
            }
            return i = Et(s.shift(), r), Ht(e[i], r), e[i] = a, a;
        }
        function Pt(e) {
            return "constructor" == e;
        }
        function It(e, t, a, r, i, s, o) {
            Et(e, s), Et(t, s), Et(a, s), Et(r, s), Et(i, s);
            var u = function(e) {
                return Ht(e, s);
            }, l = o || Pt(e) ? u : h, c = o || Pt(t) ? u : h, d = o || Pt(a) ? u : h, m = o || Pt(r) ? u : h, f = o || Pt(i) ? u : h;
            return function(s, o) {
                var u = o && o.hasOwnProperty(e) ? o : s;
                return null == u ? u : (u = l(u[e]), t ? null == u ? n : (u = c(u[t]), a ? null == u ? n : (u = d(u[a]), 
                r ? null == u ? n : (u = m(u[r]), i ? null == u ? n : u = f(u[i]) : u) : u) : u) : u);
            };
        }
        function Ft(e, t) {
            return function(n, a) {
                return e(n, a, Ht, t);
            };
        }
        function Nt(e, t, a) {
            var r = t.expensiveChecks, s = r ? gr : hr, o = s[e];
            if (o) return o;
            var u = e.split("."), l = u.length;
            if (t.csp) o = l < 6 ? It(u[0], u[1], u[2], u[3], u[4], a, r) : function(e, t) {
                var i, s = 0;
                do i = It(u[s++], u[s++], u[s++], u[s++], u[s++], a, r)(e, t), t = n, e = i; while (s < l);
                return i;
            }; else {
                var c = "";
                r && (c += "s = eso(s, fe);\nl = eso(l, fe);\n");
                var d = r;
                i(u, function(e, t) {
                    Et(e, a);
                    var n = (t ? "s" : '((l&&l.hasOwnProperty("' + e + '"))?l:s)') + "." + e;
                    (r || Pt(e)) && (n = "eso(" + n + ", fe)", d = !0), c += "if(s == null) return undefined;\ns=" + n + ";\n";
                }), c += "return s;";
                var m = new Function("s", "l", "eso", "fe", c);
                m.toString = g(c), d && (m = Ft(m, a)), o = m;
            }
            return o.sharedGetter = !0, o.assign = function(t, n, a) {
                return Ot(t, a, e, n, e);
            }, s[e] = o, o;
        }
        function Ut(e) {
            return L(e.valueOf) ? e.valueOf() : _r.call(e);
        }
        function Vt() {
            var e = le(), t = le();
            this.$get = [ "$filter", "$sniffer", function(n, a) {
                function r(e) {
                    var t = e;
                    return e.sharedGetter && (t = function(t, n) {
                        return e(t, n);
                    }, t.literal = e.literal, t.constant = e.constant, t.assign = e.assign), t;
                }
                function s(e, t) {
                    for (var n = 0, a = e.length; n < a; n++) {
                        var r = e[n];
                        r.constant || (r.inputs ? s(r.inputs, t) : t.indexOf(r) === -1 && t.push(r));
                    }
                    return t;
                }
                function o(e, t) {
                    return null == e || null == t ? e === t : ("object" != typeof e || (e = Ut(e), "object" != typeof e)) && (e === t || e !== e && t !== t);
                }
                function u(e, t, n, a) {
                    var r, i = a.$$inputs || (a.$$inputs = s(a.inputs, []));
                    if (1 === i.length) {
                        var u = o;
                        return i = i[0], e.$watch(function(e) {
                            var t = i(e);
                            return o(t, u) || (r = a(e), u = t && Ut(t)), r;
                        }, t, n);
                    }
                    for (var l = [], c = 0, d = i.length; c < d; c++) l[c] = o;
                    return e.$watch(function(e) {
                        for (var t = !1, n = 0, s = i.length; n < s; n++) {
                            var u = i[n](e);
                            (t || (t = !o(u, l[n]))) && (l[n] = u && Ut(u));
                        }
                        return t && (r = a(e)), r;
                    }, t, n);
                }
                function l(e, t, n, a) {
                    var r, i;
                    return r = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        i = e, L(t) && t.apply(this, arguments), v(e) && a.$$postDigest(function() {
                            v(i) && r();
                        });
                    }, n);
                }
                function c(e, t, n, a) {
                    function r(e) {
                        var t = !0;
                        return i(e, function(e) {
                            v(e) || (t = !1);
                        }), t;
                    }
                    var s, o;
                    return s = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        o = e, L(t) && t.call(this, e, n, a), r(e) && a.$$postDigest(function() {
                            r(o) && s();
                        });
                    }, n);
                }
                function d(e, t, n, a) {
                    var r;
                    return r = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        L(t) && t.apply(this, arguments), r();
                    }, n);
                }
                function m(e, t) {
                    if (!t) return e;
                    var n = e.$$watchDelegate, a = n !== c && n !== l, r = a ? function(n, a) {
                        var r = e(n, a);
                        return t(r, n, a);
                    } : function(n, a) {
                        var r = e(n, a), i = t(r, n, a);
                        return v(r) ? i : r;
                    };
                    return e.$$watchDelegate && e.$$watchDelegate !== u ? r.$$watchDelegate = e.$$watchDelegate : t.$stateful || (r.$$watchDelegate = u, 
                    r.inputs = [ e ]), r;
                }
                var f = {
                    csp: a.csp,
                    expensiveChecks: !1
                }, h = {
                    csp: a.csp,
                    expensiveChecks: !0
                };
                return function(a, i, s) {
                    var o, g, _;
                    switch (typeof a) {
                      case "string":
                        _ = a = a.trim();
                        var v = s ? t : e;
                        if (o = v[_], !o) {
                            ":" === a.charAt(0) && ":" === a.charAt(1) && (g = !0, a = a.substring(2));
                            var b = s ? h : f, y = new fr(b), M = new pr(y, n, b);
                            o = M.parse(a), o.constant ? o.$$watchDelegate = d : g ? (o = r(o), o.$$watchDelegate = o.literal ? c : l) : o.inputs && (o.$$watchDelegate = u), 
                            v[_] = o;
                        }
                        return m(o, i);

                      case "function":
                        return m(a, i);

                      default:
                        return m(p, i);
                    }
                };
            } ];
        }
        function Wt() {
            this.$get = [ "$rootScope", "$exceptionHandler", function(e, t) {
                return Rt(function(t) {
                    e.$evalAsync(t);
                }, t);
            } ];
        }
        function qt() {
            this.$get = [ "$browser", "$exceptionHandler", function(e, t) {
                return Rt(function(t) {
                    e.defer(t);
                }, t);
            } ];
        }
        function Rt(e, t) {
            function r(e, t, n) {
                function a(t) {
                    return function(n) {
                        r || (r = !0, t.call(e, n));
                    };
                }
                var r = !1;
                return [ a(t), a(n) ];
            }
            function s() {
                this.$$state = {
                    status: 0
                };
            }
            function o(e, t) {
                return function(n) {
                    t.call(e, n);
                };
            }
            function u(e) {
                var a, r, i;
                i = e.pending, e.processScheduled = !1, e.pending = n;
                for (var s = 0, o = i.length; s < o; ++s) {
                    r = i[s][0], a = i[s][e.status];
                    try {
                        L(a) ? r.resolve(a(e.value)) : 1 === e.status ? r.resolve(e.value) : r.reject(e.value);
                    } catch (e) {
                        r.reject(e), t(e);
                    }
                }
            }
            function l(t) {
                !t.processScheduled && t.pending && (t.processScheduled = !0, e(function() {
                    u(t);
                }));
            }
            function c() {
                this.promise = new s(), this.resolve = o(this, this.resolve), this.reject = o(this, this.reject), 
                this.notify = o(this, this.notify);
            }
            function d(e) {
                var t = new c(), n = 0, a = ca(e) ? [] : {};
                return i(e, function(e, r) {
                    n++, _(e).then(function(e) {
                        a.hasOwnProperty(r) || (a[r] = e, --n || t.resolve(a));
                    }, function(e) {
                        a.hasOwnProperty(r) || t.reject(e);
                    });
                }), 0 === n && t.resolve(a), t.promise;
            }
            var m = a("$q", TypeError), f = function() {
                return new c();
            };
            s.prototype = {
                then: function(e, t, n) {
                    var a = new c();
                    return this.$$state.pending = this.$$state.pending || [], this.$$state.pending.push([ a, e, t, n ]), 
                    this.$$state.status > 0 && l(this.$$state), a.promise;
                },
                catch: function(e) {
                    return this.then(null, e);
                },
                finally: function(e, t) {
                    return this.then(function(t) {
                        return g(t, !0, e);
                    }, function(t) {
                        return g(t, !1, e);
                    }, t);
                }
            }, c.prototype = {
                resolve: function(e) {
                    this.promise.$$state.status || (e === this.promise ? this.$$reject(m("qcycle", "Expected promise to be resolved with value other than itself '{0}'", e)) : this.$$resolve(e));
                },
                $$resolve: function(e) {
                    var n, a;
                    a = r(this, this.$$resolve, this.$$reject);
                    try {
                        (b(e) || L(e)) && (n = e && e.then), L(n) ? (this.promise.$$state.status = -1, n.call(e, a[0], a[1], this.notify)) : (this.promise.$$state.value = e, 
                        this.promise.$$state.status = 1, l(this.promise.$$state));
                    } catch (e) {
                        a[1](e), t(e);
                    }
                },
                reject: function(e) {
                    this.promise.$$state.status || this.$$reject(e);
                },
                $$reject: function(e) {
                    this.promise.$$state.value = e, this.promise.$$state.status = 2, l(this.promise.$$state);
                },
                notify: function(n) {
                    var a = this.promise.$$state.pending;
                    this.promise.$$state.status <= 0 && a && a.length && e(function() {
                        for (var e, r, i = 0, s = a.length; i < s; i++) {
                            r = a[i][0], e = a[i][3];
                            try {
                                r.notify(L(e) ? e(n) : n);
                            } catch (e) {
                                t(e);
                            }
                        }
                    });
                }
            };
            var p = function(e) {
                var t = new c();
                return t.reject(e), t.promise;
            }, h = function(e, t) {
                var n = new c();
                return t ? n.resolve(e) : n.reject(e), n.promise;
            }, g = function(e, t, n) {
                var a = null;
                try {
                    L(n) && (a = n());
                } catch (e) {
                    return h(e, !1);
                }
                return C(a) ? a.then(function() {
                    return h(e, t);
                }, function(e) {
                    return h(e, !1);
                }) : h(e, t);
            }, _ = function(e, t, n, a) {
                var r = new c();
                return r.resolve(e), r.promise.then(t, n, a);
            }, v = function e(t) {
                function n(e) {
                    r.resolve(e);
                }
                function a(e) {
                    r.reject(e);
                }
                if (!L(t)) throw m("norslvr", "Expected resolverFn, got '{0}'", t);
                if (!(this instanceof e)) return new e(t);
                var r = new c();
                return t(n, a), r.promise;
            };
            return v.defer = f, v.reject = p, v.when = _, v.all = d, v;
        }
        function zt() {
            this.$get = [ "$window", "$timeout", function(e, t) {
                var n = e.requestAnimationFrame || e.webkitRequestAnimationFrame, a = e.cancelAnimationFrame || e.webkitCancelAnimationFrame || e.webkitCancelRequestAnimationFrame, r = !!n, i = r ? function(e) {
                    var t = n(e);
                    return function() {
                        a(t);
                    };
                } : function(e) {
                    var n = t(e, 16.66, !1);
                    return function() {
                        t.cancel(n);
                    };
                };
                return i.supported = r, i;
            } ];
        }
        function Bt() {
            var e = 10, t = a("$rootScope"), n = null, s = null;
            this.digestTtl = function(t) {
                return arguments.length && (e = t), e;
            }, this.$get = [ "$injector", "$exceptionHandler", "$parse", "$browser", function(a, o, u, c) {
                function d() {
                    this.$id = l(), this.$$phase = this.$parent = this.$$watchers = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = null, 
                    this.$root = this, this.$$destroyed = !1, this.$$listeners = {}, this.$$listenerCount = {}, 
                    this.$$isolateBindings = null;
                }
                function m(e) {
                    if (M.$$phase) throw t("inprog", "{0} already in progress", M.$$phase);
                    M.$$phase = e;
                }
                function f() {
                    M.$$phase = null;
                }
                function h(e, t, n) {
                    do e.$$listenerCount[n] -= t, 0 === e.$$listenerCount[n] && delete e.$$listenerCount[n]; while (e = e.$parent);
                }
                function g() {}
                function v() {
                    for (;w.length; ) try {
                        w.shift()();
                    } catch (e) {
                        o(e);
                    }
                    s = null;
                }
                function y() {
                    null === s && (s = c.defer(function() {
                        M.$apply(v);
                    }));
                }
                d.prototype = {
                    constructor: d,
                    $new: function(e, t) {
                        function n() {
                            a.$$destroyed = !0;
                        }
                        var a;
                        return t = t || this, e ? (a = new d(), a.$root = this.$root) : (this.$$ChildScope || (this.$$ChildScope = function() {
                            this.$$watchers = this.$$nextSibling = this.$$childHead = this.$$childTail = null, 
                            this.$$listeners = {}, this.$$listenerCount = {}, this.$id = l(), this.$$ChildScope = null;
                        }, this.$$ChildScope.prototype = this), a = new this.$$ChildScope()), a.$parent = t, 
                        a.$$prevSibling = t.$$childTail, t.$$childHead ? (t.$$childTail.$$nextSibling = a, 
                        t.$$childTail = a) : t.$$childHead = t.$$childTail = a, (e || t != this) && a.$on("$destroy", n), 
                        a;
                    },
                    $watch: function(e, t, a) {
                        var r = u(e);
                        if (r.$$watchDelegate) return r.$$watchDelegate(this, t, a, r);
                        var i = this, s = i.$$watchers, o = {
                            fn: t,
                            last: g,
                            get: r,
                            exp: e,
                            eq: !!a
                        };
                        return n = null, L(t) || (o.fn = p), s || (s = i.$$watchers = []), s.unshift(o), 
                        function() {
                            A(s, o), n = null;
                        };
                    },
                    $watchGroup: function(e, t) {
                        function n() {
                            u = !1, l ? (l = !1, t(r, r, o)) : t(r, a, o);
                        }
                        var a = new Array(e.length), r = new Array(e.length), s = [], o = this, u = !1, l = !0;
                        if (!e.length) {
                            var c = !0;
                            return o.$evalAsync(function() {
                                c && t(r, r, o);
                            }), function() {
                                c = !1;
                            };
                        }
                        return 1 === e.length ? this.$watch(e[0], function(e, n, i) {
                            r[0] = e, a[0] = n, t(r, e === n ? r : a, i);
                        }) : (i(e, function(e, t) {
                            var i = o.$watch(e, function(e, i) {
                                r[t] = e, a[t] = i, u || (u = !0, o.$evalAsync(n));
                            });
                            s.push(i);
                        }), function() {
                            for (;s.length; ) s.shift()();
                        });
                    },
                    $watchCollection: function(e, t) {
                        function n(e) {
                            i = e;
                            var t, n, a, o, u;
                            if (!_(i)) {
                                if (b(i)) if (r(i)) {
                                    s !== f && (s = f, g = s.length = 0, d++), t = i.length, g !== t && (d++, s.length = g = t);
                                    for (var l = 0; l < t; l++) u = s[l], o = i[l], a = u !== u && o !== o, a || u === o || (d++, 
                                    s[l] = o);
                                } else {
                                    s !== p && (s = p = {}, g = 0, d++), t = 0;
                                    for (n in i) i.hasOwnProperty(n) && (t++, o = i[n], u = s[n], n in s ? (a = u !== u && o !== o, 
                                    a || u === o || (d++, s[n] = o)) : (g++, s[n] = o, d++));
                                    if (g > t) {
                                        d++;
                                        for (n in s) i.hasOwnProperty(n) || (g--, delete s[n]);
                                    }
                                } else s !== i && (s = i, d++);
                                return d;
                            }
                        }
                        function a() {
                            if (h ? (h = !1, t(i, i, l)) : t(i, o, l), c) if (b(i)) if (r(i)) {
                                o = new Array(i.length);
                                for (var e = 0; e < i.length; e++) o[e] = i[e];
                            } else {
                                o = {};
                                for (var n in i) Gn.call(i, n) && (o[n] = i[n]);
                            } else o = i;
                        }
                        n.$stateful = !0;
                        var i, s, o, l = this, c = t.length > 1, d = 0, m = u(e, n), f = [], p = {}, h = !0, g = 0;
                        return this.$watch(m, a);
                    },
                    $digest: function() {
                        var a, r, i, u, l, d, p, h, _, b, y = e, w = this, D = [];
                        m("$digest"), c.$$checkUrlChange(), this === M && null !== s && (c.defer.cancel(s), 
                        v()), n = null;
                        do {
                            for (d = !1, h = w; $.length; ) {
                                try {
                                    b = $.shift(), b.scope.$eval(b.expression, b.locals);
                                } catch (e) {
                                    o(e);
                                }
                                n = null;
                            }
                            e: do {
                                if (u = h.$$watchers) for (l = u.length; l--; ) try {
                                    if (a = u[l]) if ((r = a.get(h)) === (i = a.last) || (a.eq ? I(r, i) : "number" == typeof r && "number" == typeof i && isNaN(r) && isNaN(i))) {
                                        if (a === n) {
                                            d = !1;
                                            break e;
                                        }
                                    } else d = !0, n = a, a.last = a.eq ? O(r, null) : r, a.fn(r, i === g ? r : i, h), 
                                    y < 5 && (_ = 4 - y, D[_] || (D[_] = []), D[_].push({
                                        msg: L(a.exp) ? "fn: " + (a.exp.name || a.exp.toString()) : a.exp,
                                        newVal: r,
                                        oldVal: i
                                    }));
                                } catch (e) {
                                    o(e);
                                }
                                if (!(p = h.$$childHead || h !== w && h.$$nextSibling)) for (;h !== w && !(p = h.$$nextSibling); ) h = h.$parent;
                            } while (h = p);
                            if ((d || $.length) && !y--) throw f(), t("infdig", "{0} $digest() iterations reached. Aborting!\nWatchers fired in the last 5 iterations: {1}", e, D);
                        } while (d || $.length);
                        for (f(); k.length; ) try {
                            k.shift()();
                        } catch (e) {
                            o(e);
                        }
                    },
                    $destroy: function() {
                        if (!this.$$destroyed) {
                            var e = this.$parent;
                            if (this.$broadcast("$destroy"), this.$$destroyed = !0, this !== M) {
                                for (var t in this.$$listenerCount) h(this, this.$$listenerCount[t], t);
                                e.$$childHead == this && (e.$$childHead = this.$$nextSibling), e.$$childTail == this && (e.$$childTail = this.$$prevSibling), 
                                this.$$prevSibling && (this.$$prevSibling.$$nextSibling = this.$$nextSibling), this.$$nextSibling && (this.$$nextSibling.$$prevSibling = this.$$prevSibling), 
                                this.$destroy = this.$digest = this.$apply = this.$evalAsync = this.$applyAsync = p, 
                                this.$on = this.$watch = this.$watchGroup = function() {
                                    return p;
                                }, this.$$listeners = {}, this.$parent = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = this.$root = this.$$watchers = null;
                            }
                        }
                    },
                    $eval: function(e, t) {
                        return u(e)(this, t);
                    },
                    $evalAsync: function(e, t) {
                        M.$$phase || $.length || c.defer(function() {
                            $.length && M.$digest();
                        }), $.push({
                            scope: this,
                            expression: e,
                            locals: t
                        });
                    },
                    $$postDigest: function(e) {
                        k.push(e);
                    },
                    $apply: function(e) {
                        try {
                            return m("$apply"), this.$eval(e);
                        } catch (e) {
                            o(e);
                        } finally {
                            f();
                            try {
                                M.$digest();
                            } catch (e) {
                                throw o(e), e;
                            }
                        }
                    },
                    $applyAsync: function(e) {
                        function t() {
                            n.$eval(e);
                        }
                        var n = this;
                        e && w.push(t), y();
                    },
                    $on: function(e, t) {
                        var n = this.$$listeners[e];
                        n || (this.$$listeners[e] = n = []), n.push(t);
                        var a = this;
                        do a.$$listenerCount[e] || (a.$$listenerCount[e] = 0), a.$$listenerCount[e]++; while (a = a.$parent);
                        var r = this;
                        return function() {
                            var a = n.indexOf(t);
                            a !== -1 && (n[a] = null, h(r, 1, e));
                        };
                    },
                    $emit: function(e, t) {
                        var n, a, r, i = [], s = this, u = !1, l = {
                            name: e,
                            targetScope: s,
                            stopPropagation: function() {
                                u = !0;
                            },
                            preventDefault: function() {
                                l.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        }, c = F([ l ], arguments, 1);
                        do {
                            for (n = s.$$listeners[e] || i, l.currentScope = s, a = 0, r = n.length; a < r; a++) if (n[a]) try {
                                n[a].apply(null, c);
                            } catch (e) {
                                o(e);
                            } else n.splice(a, 1), a--, r--;
                            if (u) return l.currentScope = null, l;
                            s = s.$parent;
                        } while (s);
                        return l.currentScope = null, l;
                    },
                    $broadcast: function(e, t) {
                        var n = this, a = n, r = n, i = {
                            name: e,
                            targetScope: n,
                            preventDefault: function() {
                                i.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        };
                        if (!n.$$listenerCount[e]) return i;
                        for (var s, u, l, c = F([ i ], arguments, 1); a = r; ) {
                            for (i.currentScope = a, s = a.$$listeners[e] || [], u = 0, l = s.length; u < l; u++) if (s[u]) try {
                                s[u].apply(null, c);
                            } catch (e) {
                                o(e);
                            } else s.splice(u, 1), u--, l--;
                            if (!(r = a.$$listenerCount[e] && a.$$childHead || a !== n && a.$$nextSibling)) for (;a !== n && !(r = a.$$nextSibling); ) a = a.$parent;
                        }
                        return i.currentScope = null, i;
                    }
                };
                var M = new d(), $ = M.$$asyncQueue = [], k = M.$$postDigestQueue = [], w = M.$$applyAsyncQueue = [];
                return M;
            } ];
        }
        function Gt() {
            var e = /^\s*(https?|ftp|mailto|tel|file):/, t = /^\s*((https?|ftp|file|blob):|data:image\/)/;
            this.aHrefSanitizationWhitelist = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (t = e, this) : t;
            }, this.$get = function() {
                return function(n, a) {
                    var r, i = a ? t : e;
                    return r = an(n).href, "" === r || r.match(i) ? n : "unsafe:" + r;
                };
            };
        }
        function Jt(e) {
            if ("self" === e) return e;
            if (y(e)) {
                if (e.indexOf("***") > -1) throw vr("iwcard", "Illegal sequence *** in string matcher.  String: {0}", e);
                return e = ma(e).replace("\\*\\*", ".*").replace("\\*", "[^:/.?&;]*"), new RegExp("^" + e + "$");
            }
            if (k(e)) return new RegExp("^" + e.source + "$");
            throw vr("imatcher", 'Matchers may only be "self", string patterns or RegExp objects');
        }
        function Kt(e) {
            var t = [];
            return v(e) && i(e, function(e) {
                t.push(Jt(e));
            }), t;
        }
        function Zt() {
            this.SCE_CONTEXTS = br;
            var e = [ "self" ], t = [];
            this.resourceUrlWhitelist = function(t) {
                return arguments.length && (e = Kt(t)), e;
            }, this.resourceUrlBlacklist = function(e) {
                return arguments.length && (t = Kt(e)), t;
            }, this.$get = [ "$injector", function(a) {
                function r(e, t) {
                    return "self" === e ? rn(t) : !!e.exec(t.href);
                }
                function i(n) {
                    var a, i, s = an(n.toString()), o = !1;
                    for (a = 0, i = e.length; a < i; a++) if (r(e[a], s)) {
                        o = !0;
                        break;
                    }
                    if (o) for (a = 0, i = t.length; a < i; a++) if (r(t[a], s)) {
                        o = !1;
                        break;
                    }
                    return o;
                }
                function s(e) {
                    var t = function(e) {
                        this.$$unwrapTrustedValue = function() {
                            return e;
                        };
                    };
                    return e && (t.prototype = new e()), t.prototype.valueOf = function() {
                        return this.$$unwrapTrustedValue();
                    }, t.prototype.toString = function() {
                        return this.$$unwrapTrustedValue().toString();
                    }, t;
                }
                function o(e, t) {
                    var a = m.hasOwnProperty(e) ? m[e] : null;
                    if (!a) throw vr("icontext", "Attempted to trust a value in invalid context. Context: {0}; Value: {1}", e, t);
                    if (null === t || t === n || "" === t) return t;
                    if ("string" != typeof t) throw vr("itype", "Attempted to trust a non-string value in a content requiring a string: Context: {0}", e);
                    return new a(t);
                }
                function u(e) {
                    return e instanceof d ? e.$$unwrapTrustedValue() : e;
                }
                function l(e, t) {
                    if (null === t || t === n || "" === t) return t;
                    var a = m.hasOwnProperty(e) ? m[e] : null;
                    if (a && t instanceof a) return t.$$unwrapTrustedValue();
                    if (e === br.RESOURCE_URL) {
                        if (i(t)) return t;
                        throw vr("insecurl", "Blocked loading resource from url not allowed by $sceDelegate policy.  URL: {0}", t.toString());
                    }
                    if (e === br.HTML) return c(t);
                    throw vr("unsafe", "Attempting to use an unsafe value in a safe context.");
                }
                var c = function(e) {
                    throw vr("unsafe", "Attempting to use an unsafe value in a safe context.");
                };
                a.has("$sanitize") && (c = a.get("$sanitize"));
                var d = s(), m = {};
                return m[br.HTML] = s(d), m[br.CSS] = s(d), m[br.URL] = s(d), m[br.JS] = s(d), m[br.RESOURCE_URL] = s(m[br.URL]), 
                {
                    trustAs: o,
                    getTrusted: l,
                    valueOf: u
                };
            } ];
        }
        function Qt() {
            var e = !0;
            this.enabled = function(t) {
                return arguments.length && (e = !!t), e;
            }, this.$get = [ "$parse", "$sceDelegate", function(t, n) {
                if (e && Qn < 8) throw vr("iequirks", "Strict Contextual Escaping does not support Internet Explorer version < 11 in quirks mode.  You can fix this by adding the text <!doctype html> to the top of your HTML document.  See http://docs.angularjs.org/api/ng.$sce for more information.");
                var a = P(br);
                a.isEnabled = function() {
                    return e;
                }, a.trustAs = n.trustAs, a.getTrusted = n.getTrusted, a.valueOf = n.valueOf, e || (a.trustAs = a.getTrusted = function(e, t) {
                    return t;
                }, a.valueOf = h), a.parseAs = function(e, n) {
                    var r = t(n);
                    return r.literal && r.constant ? r : t(n, function(t) {
                        return a.getTrusted(e, t);
                    });
                };
                var r = a.parseAs, s = a.getTrusted, o = a.trustAs;
                return i(br, function(e, t) {
                    var n = Bn(t);
                    a[he("parse_as_" + n)] = function(t) {
                        return r(e, t);
                    }, a[he("get_trusted_" + n)] = function(t) {
                        return s(e, t);
                    }, a[he("trust_as_" + n)] = function(t) {
                        return o(e, t);
                    };
                }), a;
            } ];
        }
        function Xt() {
            this.$get = [ "$window", "$document", function(e, t) {
                var n, a, r = {}, i = m((/android (\d+)/.exec(Bn((e.navigator || {}).userAgent)) || [])[1]), s = /Boxee/i.test((e.navigator || {}).userAgent), o = t[0] || {}, u = /^(Moz|webkit|ms)(?=[A-Z])/, l = o.body && o.body.style, c = !1, d = !1;
                if (l) {
                    for (var f in l) if (a = u.exec(f)) {
                        n = a[0], n = n.substr(0, 1).toUpperCase() + n.substr(1);
                        break;
                    }
                    n || (n = "WebkitOpacity" in l && "webkit"), c = !!("transition" in l || n + "Transition" in l), 
                    d = !!("animation" in l || n + "Animation" in l), !i || c && d || (c = y(o.body.style.webkitTransition), 
                    d = y(o.body.style.webkitAnimation));
                }
                return {
                    history: !(!e.history || !e.history.pushState || i < 4 || s),
                    hasEvent: function(e) {
                        if ("input" === e && Qn <= 11) return !1;
                        if (_(r[e])) {
                            var t = o.createElement("div");
                            r[e] = "on" + e in t;
                        }
                        return r[e];
                    },
                    csp: fa(),
                    vendorPrefix: n,
                    transitions: c,
                    animations: d,
                    android: i
                };
            } ];
        }
        function en() {
            this.$get = [ "$templateCache", "$http", "$q", function(e, t, n) {
                function a(r, i) {
                    function s(e) {
                        if (!i) throw Ba("tpload", "Failed to load template: {0}", r);
                        return n.reject(e);
                    }
                    a.totalPendingRequests++;
                    var o = t.defaults && t.defaults.transformResponse;
                    ca(o) ? o = o.filter(function(e) {
                        return e !== rt;
                    }) : o === rt && (o = null);
                    var u = {
                        cache: e,
                        transformResponse: o
                    };
                    return t.get(r, u).finally(function() {
                        a.totalPendingRequests--;
                    }).then(function(e) {
                        return e.data;
                    }, s);
                }
                return a.totalPendingRequests = 0, a;
            } ];
        }
        function tn() {
            this.$get = [ "$rootScope", "$browser", "$location", function(e, t, n) {
                var a = {};
                return a.findBindings = function(e, t, n) {
                    var a = e.getElementsByClassName("ng-binding"), r = [];
                    return i(a, function(e) {
                        var a = oa.element(e).data("$binding");
                        a && i(a, function(a) {
                            if (n) {
                                var i = new RegExp("(^|\\s)" + ma(t) + "(\\s|\\||$)");
                                i.test(a) && r.push(e);
                            } else a.indexOf(t) != -1 && r.push(e);
                        });
                    }), r;
                }, a.findModels = function(e, t, n) {
                    for (var a = [ "ng-", "data-ng-", "ng\\:" ], r = 0; r < a.length; ++r) {
                        var i = n ? "=" : "*=", s = "[" + a[r] + "model" + i + '"' + t + '"]', o = e.querySelectorAll(s);
                        if (o.length) return o;
                    }
                }, a.getLocation = function() {
                    return n.url();
                }, a.setLocation = function(t) {
                    t !== n.url() && (n.url(t), e.$digest());
                }, a.whenStable = function(e) {
                    t.notifyWhenNoOutstandingRequests(e);
                }, a;
            } ];
        }
        function nn() {
            this.$get = [ "$rootScope", "$browser", "$q", "$$q", "$exceptionHandler", function(e, t, n, a, r) {
                function i(i, o, u) {
                    var l, c = v(u) && !u, d = (c ? a : n).defer(), m = d.promise;
                    return l = t.defer(function() {
                        try {
                            d.resolve(i());
                        } catch (e) {
                            d.reject(e), r(e);
                        } finally {
                            delete s[m.$$timeoutId];
                        }
                        c || e.$apply();
                    }, o), m.$$timeoutId = l, s[l] = d, m;
                }
                var s = {};
                return i.cancel = function(e) {
                    return !!(e && e.$$timeoutId in s) && (s[e.$$timeoutId].reject("canceled"), delete s[e.$$timeoutId], 
                    t.defer.cancel(e.$$timeoutId));
                }, i;
            } ];
        }
        function an(e) {
            var t = e;
            return Qn && (yr.setAttribute("href", t), t = yr.href), yr.setAttribute("href", t), 
            {
                href: yr.href,
                protocol: yr.protocol ? yr.protocol.replace(/:$/, "") : "",
                host: yr.host,
                search: yr.search ? yr.search.replace(/^\?/, "") : "",
                hash: yr.hash ? yr.hash.replace(/^#/, "") : "",
                hostname: yr.hostname,
                port: yr.port,
                pathname: "/" === yr.pathname.charAt(0) ? yr.pathname : "/" + yr.pathname
            };
        }
        function rn(e) {
            var t = y(e) ? an(e) : e;
            return t.protocol === Mr.protocol && t.host === Mr.host;
        }
        function sn() {
            this.$get = g(e);
        }
        function on(e) {
            function t(a, r) {
                if (b(a)) {
                    var s = {};
                    return i(a, function(e, n) {
                        s[n] = t(n, e);
                    }), s;
                }
                return e.factory(a + n, r);
            }
            var n = "Filter";
            this.register = t, this.$get = [ "$injector", function(e) {
                return function(t) {
                    return e.get(t + n);
                };
            } ], t("currency", dn), t("date", $n), t("filter", un), t("json", Ln), t("limitTo", kn), 
            t("lowercase", Dr), t("number", mn), t("orderBy", wn), t("uppercase", Yr);
        }
        function un() {
            return function(e, t, n) {
                if (!ca(e)) return e;
                var a, r;
                switch (typeof t) {
                  case "function":
                    a = t;
                    break;

                  case "boolean":
                  case "number":
                  case "string":
                    r = !0;

                  case "object":
                    a = ln(t, n, r);
                    break;

                  default:
                    return e;
                }
                return e.filter(a);
            };
        }
        function ln(e, t, n) {
            var a, r = b(e) && "$" in e;
            return t === !0 ? t = I : L(t) || (t = function(e, t) {
                return !b(e) && !b(t) && (e = Bn("" + e), t = Bn("" + t), e.indexOf(t) !== -1);
            }), a = function(a) {
                return r && !b(a) ? cn(a, e.$, t, !1) : cn(a, e, t, n);
            };
        }
        function cn(e, t, n, a, r) {
            var i = typeof e, s = typeof t;
            if ("string" === s && "!" === t.charAt(0)) return !cn(e, t.substring(1), n, a);
            if (ca(e)) return e.some(function(e) {
                return cn(e, t, n, a);
            });
            switch (i) {
              case "object":
                var o;
                if (a) {
                    for (o in e) if ("$" !== o.charAt(0) && cn(e[o], t, n, !0)) return !0;
                    return !r && cn(e, t, n, !1);
                }
                if ("object" === s) {
                    for (o in t) {
                        var u = t[o];
                        if (!L(u)) {
                            var l = "$" === o, c = l ? e : e[o];
                            if (!cn(c, u, n, l, l)) return !1;
                        }
                    }
                    return !0;
                }
                return n(e, t);

              case "function":
                return !1;

              default:
                return n(e, t);
            }
        }
        function dn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n, a) {
                return _(n) && (n = t.CURRENCY_SYM), _(a) && (a = t.PATTERNS[1].maxFrac), null == e ? e : fn(e, t.PATTERNS[1], t.GROUP_SEP, t.DECIMAL_SEP, a).replace(/\u00A4/g, n);
            };
        }
        function mn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n) {
                return null == e ? e : fn(e, t.PATTERNS[0], t.GROUP_SEP, t.DECIMAL_SEP, n);
            };
        }
        function fn(e, t, n, a, r) {
            if (!isFinite(e) || b(e)) return "";
            var i = e < 0;
            e = Math.abs(e);
            var s = e + "", o = "", u = [], l = !1;
            if (s.indexOf("e") !== -1) {
                var c = s.match(/([\d\.]+)e(-?)(\d+)/);
                c && "-" == c[2] && c[3] > r + 1 ? e = 0 : (o = s, l = !0);
            }
            if (l) r > 0 && e < 1 && (o = e.toFixed(r), e = parseFloat(o)); else {
                var d = (s.split($r)[1] || "").length;
                _(r) && (r = Math.min(Math.max(t.minFrac, d), t.maxFrac)), e = +(Math.round(+(e.toString() + "e" + r)).toString() + "e" + -r);
                var m = ("" + e).split($r), f = m[0];
                m = m[1] || "";
                var p, h = 0, g = t.lgSize, v = t.gSize;
                if (f.length >= g + v) for (h = f.length - g, p = 0; p < h; p++) (h - p) % v === 0 && 0 !== p && (o += n), 
                o += f.charAt(p);
                for (p = h; p < f.length; p++) (f.length - p) % g === 0 && 0 !== p && (o += n), 
                o += f.charAt(p);
                for (;m.length < r; ) m += "0";
                r && "0" !== r && (o += a + m.substr(0, r));
            }
            return 0 === e && (i = !1), u.push(i ? t.negPre : t.posPre, o, i ? t.negSuf : t.posSuf), 
            u.join("");
        }
        function pn(e, t, n) {
            var a = "";
            for (e < 0 && (a = "-", e = -e), e = "" + e; e.length < t; ) e = "0" + e;
            return n && (e = e.substr(e.length - t)), a + e;
        }
        function hn(e, t, n, a) {
            return n = n || 0, function(r) {
                var i = r["get" + e]();
                return (n > 0 || i > -n) && (i += n), 0 === i && n == -12 && (i = 12), pn(i, t, a);
            };
        }
        function gn(e, t) {
            return function(n, a) {
                var r = n["get" + e](), i = Jn(t ? "SHORT" + e : e);
                return a[i][r];
            };
        }
        function _n(e) {
            var t = -1 * e.getTimezoneOffset(), n = t >= 0 ? "+" : "";
            return n += pn(Math[t > 0 ? "floor" : "ceil"](t / 60), 2) + pn(Math.abs(t % 60), 2);
        }
        function vn(e) {
            var t = new Date(e, 0, 1).getDay();
            return new Date(e, 0, (t <= 4 ? 5 : 12) - t);
        }
        function bn(e) {
            return new Date(e.getFullYear(), e.getMonth(), e.getDate() + (4 - e.getDay()));
        }
        function yn(e) {
            return function(t) {
                var n = vn(t.getFullYear()), a = bn(t), r = +a - +n, i = 1 + Math.round(r / 6048e5);
                return pn(i, e);
            };
        }
        function Mn(e, t) {
            return e.getHours() < 12 ? t.AMPMS[0] : t.AMPMS[1];
        }
        function $n(e) {
            function t(e) {
                var t;
                if (t = e.match(n)) {
                    var a = new Date(0), r = 0, i = 0, s = t[8] ? a.setUTCFullYear : a.setFullYear, o = t[8] ? a.setUTCHours : a.setHours;
                    t[9] && (r = m(t[9] + t[10]), i = m(t[9] + t[11])), s.call(a, m(t[1]), m(t[2]) - 1, m(t[3]));
                    var u = m(t[4] || 0) - r, l = m(t[5] || 0) - i, c = m(t[6] || 0), d = Math.round(1e3 * parseFloat("0." + (t[7] || 0)));
                    return o.call(a, u, l, c, d), a;
                }
                return e;
            }
            var n = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;
            return function(n, a, r) {
                var s, o, u = "", l = [];
                if (a = a || "mediumDate", a = e.DATETIME_FORMATS[a] || a, y(n) && (n = wr.test(n) ? m(n) : t(n)), 
                M(n) && (n = new Date(n)), !$(n)) return n;
                for (;a; ) o = kr.exec(a), o ? (l = F(l, o, 1), a = l.pop()) : (l.push(a), a = null);
                return r && "UTC" === r && (n = new Date(n.getTime()), n.setMinutes(n.getMinutes() + n.getTimezoneOffset())), 
                i(l, function(t) {
                    s = Lr[t], u += s ? s(n, e.DATETIME_FORMATS) : t.replace(/(^'|'$)/g, "").replace(/''/g, "'");
                }), u;
            };
        }
        function Ln() {
            return function(e, t) {
                return _(t) && (t = 2), W(e, t);
            };
        }
        function kn() {
            return function(e, t) {
                return M(e) && (e = e.toString()), ca(e) || y(e) ? (t = Math.abs(Number(t)) === 1 / 0 ? Number(t) : m(t), 
                t ? t > 0 ? e.slice(0, t) : e.slice(t) : y(e) ? "" : []) : e;
            };
        }
        function wn(e) {
            return function(t, n, a) {
                function i(e, t) {
                    for (var a = 0; a < n.length; a++) {
                        var r = n[a](e, t);
                        if (0 !== r) return r;
                    }
                    return 0;
                }
                function s(e, t) {
                    return t ? function(t, n) {
                        return e(n, t);
                    } : e;
                }
                function o(e) {
                    switch (typeof e) {
                      case "number":
                      case "boolean":
                      case "string":
                        return !0;

                      default:
                        return !1;
                    }
                }
                function u(e) {
                    return null === e ? "null" : "function" == typeof e.valueOf && (e = e.valueOf(), 
                    o(e)) ? e : "function" == typeof e.toString && (e = e.toString(), o(e)) ? e : "";
                }
                function l(e, t) {
                    var n = typeof e, a = typeof t;
                    return n === a && "object" === n && (e = u(e), t = u(t)), n === a ? ("string" === n && (e = e.toLowerCase(), 
                    t = t.toLowerCase()), e === t ? 0 : e < t ? -1 : 1) : n < a ? -1 : 1;
                }
                return r(t) ? (n = ca(n) ? n : [ n ], 0 === n.length && (n = [ "+" ]), n = n.map(function(t) {
                    var n = !1, a = t || h;
                    if (y(t)) {
                        if ("+" != t.charAt(0) && "-" != t.charAt(0) || (n = "-" == t.charAt(0), t = t.substring(1)), 
                        "" === t) return s(l, n);
                        if (a = e(t), a.constant) {
                            var r = a();
                            return s(function(e, t) {
                                return l(e[r], t[r]);
                            }, n);
                        }
                    }
                    return s(function(e, t) {
                        return l(a(e), a(t));
                    }, n);
                }), na.call(t).sort(s(i, a))) : t;
            };
        }
        function Dn(e) {
            return L(e) && (e = {
                link: e
            }), e.restrict = e.restrict || "AC", g(e);
        }
        function Yn(e, t) {
            e.$name = t;
        }
        function Tn(e, t, a, r, s) {
            var o = this, u = [], l = o.$$parentForm = e.parent().controller("form") || xr;
            o.$error = {}, o.$$success = {}, o.$pending = n, o.$name = s(t.name || t.ngForm || "")(a), 
            o.$dirty = !1, o.$pristine = !0, o.$valid = !0, o.$invalid = !1, o.$submitted = !1, 
            l.$addControl(o), o.$rollbackViewValue = function() {
                i(u, function(e) {
                    e.$rollbackViewValue();
                });
            }, o.$commitViewValue = function() {
                i(u, function(e) {
                    e.$commitViewValue();
                });
            }, o.$addControl = function(e) {
                se(e.$name, "input"), u.push(e), e.$name && (o[e.$name] = e);
            }, o.$$renameControl = function(e, t) {
                var n = e.$name;
                o[n] === e && delete o[n], o[t] = e, e.$name = t;
            }, o.$removeControl = function(e) {
                e.$name && o[e.$name] === e && delete o[e.$name], i(o.$pending, function(t, n) {
                    o.$setValidity(n, null, e);
                }), i(o.$error, function(t, n) {
                    o.$setValidity(n, null, e);
                }), i(o.$$success, function(t, n) {
                    o.$setValidity(n, null, e);
                }), A(u, e);
            }, Wn({
                ctrl: this,
                $element: e,
                set: function(e, t, n) {
                    var a = e[t];
                    if (a) {
                        var r = a.indexOf(n);
                        r === -1 && a.push(n);
                    } else e[t] = [ n ];
                },
                unset: function(e, t, n) {
                    var a = e[t];
                    a && (A(a, n), 0 === a.length && delete e[t]);
                },
                parentForm: l,
                $animate: r
            }), o.$setDirty = function() {
                r.removeClass(e, mi), r.addClass(e, fi), o.$dirty = !0, o.$pristine = !1, l.$setDirty();
            }, o.$setPristine = function() {
                r.setClass(e, mi, fi + " " + Cr), o.$dirty = !1, o.$pristine = !0, o.$submitted = !1, 
                i(u, function(e) {
                    e.$setPristine();
                });
            }, o.$setUntouched = function() {
                i(u, function(e) {
                    e.$setUntouched();
                });
            }, o.$setSubmitted = function() {
                r.addClass(e, Cr), o.$submitted = !0, l.$setSubmitted();
            };
        }
        function Sn(e) {
            e.$formatters.push(function(t) {
                return e.$isEmpty(t) ? t : t.toString();
            });
        }
        function xn(e, t, n, a, r, i) {
            Cn(e, t, n, a, r, i), Sn(a);
        }
        function Cn(e, t, n, a, r, i) {
            var s = Bn(t[0].type);
            if (!r.android) {
                var o = !1;
                t.on("compositionstart", function(e) {
                    o = !0;
                }), t.on("compositionend", function() {
                    o = !1, u();
                });
            }
            var u = function(e) {
                if (l && (i.defer.cancel(l), l = null), !o) {
                    var r = t.val(), u = e && e.type;
                    "password" === s || n.ngTrim && "false" === n.ngTrim || (r = da(r)), (a.$viewValue !== r || "" === r && a.$$hasNativeValidators) && a.$setViewValue(r, u);
                }
            };
            if (r.hasEvent("input")) t.on("input", u); else {
                var l, c = function(e, t, n) {
                    l || (l = i.defer(function() {
                        l = null, t && t.value === n || u(e);
                    }));
                };
                t.on("keydown", function(e) {
                    var t = e.keyCode;
                    91 === t || 15 < t && t < 19 || 37 <= t && t <= 40 || c(e, this, this.value);
                }), r.hasEvent("paste") && t.on("paste cut", c);
            }
            t.on("change", u), a.$render = function() {
                t.val(a.$isEmpty(a.$viewValue) ? "" : a.$viewValue);
            };
        }
        function En(e, t) {
            if ($(e)) return e;
            if (y(e)) {
                Ur.lastIndex = 0;
                var n = Ur.exec(e);
                if (n) {
                    var a = +n[1], r = +n[2], i = 0, s = 0, o = 0, u = 0, l = vn(a), c = 7 * (r - 1);
                    return t && (i = t.getHours(), s = t.getMinutes(), o = t.getSeconds(), u = t.getMilliseconds()), 
                    new Date(a, 0, l.getDate() + c, i, s, o, u);
                }
            }
            return NaN;
        }
        function Hn(e, t) {
            return function(n, a) {
                var r, s;
                if ($(n)) return n;
                if (y(n)) {
                    if ('"' == n.charAt(0) && '"' == n.charAt(n.length - 1) && (n = n.substring(1, n.length - 1)), 
                    Ar.test(n)) return new Date(n);
                    if (e.lastIndex = 0, r = e.exec(n)) return r.shift(), s = a ? {
                        yyyy: a.getFullYear(),
                        MM: a.getMonth() + 1,
                        dd: a.getDate(),
                        HH: a.getHours(),
                        mm: a.getMinutes(),
                        ss: a.getSeconds(),
                        sss: a.getMilliseconds() / 1e3
                    } : {
                        yyyy: 1970,
                        MM: 1,
                        dd: 1,
                        HH: 0,
                        mm: 0,
                        ss: 0,
                        sss: 0
                    }, i(r, function(e, n) {
                        n < t.length && (s[t[n]] = +e);
                    }), new Date(s.yyyy, s.MM - 1, s.dd, s.HH, s.mm, s.ss || 0, 1e3 * s.sss || 0);
                }
                return NaN;
            };
        }
        function jn(e, t, a, r) {
            return function(i, s, o, u, l, c, d) {
                function m(e) {
                    return e && !(e.getTime && e.getTime() !== e.getTime());
                }
                function f(e) {
                    return v(e) ? $(e) ? e : a(e) : n;
                }
                An(i, s, o, u), Cn(i, s, o, u, l, c);
                var p, h = u && u.$options && u.$options.timezone;
                if (u.$$parserName = e, u.$parsers.push(function(e) {
                    if (u.$isEmpty(e)) return null;
                    if (t.test(e)) {
                        var r = a(e, p);
                        return "UTC" === h && r.setMinutes(r.getMinutes() - r.getTimezoneOffset()), r;
                    }
                    return n;
                }), u.$formatters.push(function(e) {
                    if (e && !$(e)) throw _i("datefmt", "Expected `{0}` to be a date", e);
                    if (m(e)) {
                        if (p = e, p && "UTC" === h) {
                            var t = 6e4 * p.getTimezoneOffset();
                            p = new Date(p.getTime() + t);
                        }
                        return d("date")(e, r, h);
                    }
                    return p = null, "";
                }), v(o.min) || o.ngMin) {
                    var g;
                    u.$validators.min = function(e) {
                        return !m(e) || _(g) || a(e) >= g;
                    }, o.$observe("min", function(e) {
                        g = f(e), u.$validate();
                    });
                }
                if (v(o.max) || o.ngMax) {
                    var b;
                    u.$validators.max = function(e) {
                        return !m(e) || _(b) || a(e) <= b;
                    }, o.$observe("max", function(e) {
                        b = f(e), u.$validate();
                    });
                }
            };
        }
        function An(e, t, a, r) {
            var i = t[0], s = r.$$hasNativeValidators = b(i.validity);
            s && r.$parsers.push(function(e) {
                var a = t.prop(zn) || {};
                return a.badInput && !a.typeMismatch ? n : e;
            });
        }
        function On(e, t, a, r, i, s) {
            if (An(e, t, a, r), Cn(e, t, a, r, i, s), r.$$parserName = "number", r.$parsers.push(function(e) {
                return r.$isEmpty(e) ? null : Ir.test(e) ? parseFloat(e) : n;
            }), r.$formatters.push(function(e) {
                if (!r.$isEmpty(e)) {
                    if (!M(e)) throw _i("numfmt", "Expected `{0}` to be a number", e);
                    e = e.toString();
                }
                return e;
            }), v(a.min) || a.ngMin) {
                var o;
                r.$validators.min = function(e) {
                    return r.$isEmpty(e) || _(o) || e >= o;
                }, a.$observe("min", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), o = M(e) && !isNaN(e) ? e : n, r.$validate();
                });
            }
            if (v(a.max) || a.ngMax) {
                var u;
                r.$validators.max = function(e) {
                    return r.$isEmpty(e) || _(u) || e <= u;
                }, a.$observe("max", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), u = M(e) && !isNaN(e) ? e : n, r.$validate();
                });
            }
        }
        function Pn(e, t, n, a, r, i) {
            Cn(e, t, n, a, r, i), Sn(a), a.$$parserName = "url", a.$validators.url = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Or.test(n);
            };
        }
        function In(e, t, n, a, r, i) {
            Cn(e, t, n, a, r, i), Sn(a), a.$$parserName = "email", a.$validators.email = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Pr.test(n);
            };
        }
        function Fn(e, t, n, a) {
            _(n.name) && t.attr("name", l());
            var r = function(e) {
                t[0].checked && a.$setViewValue(n.value, e && e.type);
            };
            t.on("click", r), a.$render = function() {
                var e = n.value;
                t[0].checked = e == a.$viewValue;
            }, n.$observe("value", a.$render);
        }
        function Nn(e, t, n, r, i) {
            var s;
            if (v(r)) {
                if (s = e(r), !s.constant) throw a("ngModel")("constexpr", "Expected constant expression for `{0}`, but saw `{1}`.", n, r);
                return s(t);
            }
            return i;
        }
        function Un(e, t, n, a, r, i, s, o) {
            var u = Nn(o, e, "ngTrueValue", n.ngTrueValue, !0), l = Nn(o, e, "ngFalseValue", n.ngFalseValue, !1), c = function(e) {
                a.$setViewValue(t[0].checked, e && e.type);
            };
            t.on("click", c), a.$render = function() {
                t[0].checked = a.$viewValue;
            }, a.$isEmpty = function(e) {
                return e === !1;
            }, a.$formatters.push(function(e) {
                return I(e, u);
            }), a.$parsers.push(function(e) {
                return e ? u : l;
            });
        }
        function Vn(e, t) {
            return e = "ngClass" + e, [ "$animate", function(n) {
                function a(e, t) {
                    var n = [];
                    e: for (var a = 0; a < e.length; a++) {
                        for (var r = e[a], i = 0; i < t.length; i++) if (r == t[i]) continue e;
                        n.push(r);
                    }
                    return n;
                }
                function r(e) {
                    if (ca(e)) return e;
                    if (y(e)) return e.split(" ");
                    if (b(e)) {
                        var t = [];
                        return i(e, function(e, n) {
                            e && (t = t.concat(n.split(" ")));
                        }), t;
                    }
                    return e;
                }
                return {
                    restrict: "AC",
                    link: function(s, o, u) {
                        function l(e) {
                            var t = d(e, 1);
                            u.$addClass(t);
                        }
                        function c(e) {
                            var t = d(e, -1);
                            u.$removeClass(t);
                        }
                        function d(e, t) {
                            var n = o.data("$classCounts") || {}, a = [];
                            return i(e, function(e) {
                                (t > 0 || n[e]) && (n[e] = (n[e] || 0) + t, n[e] === +(t > 0) && a.push(e));
                            }), o.data("$classCounts", n), a.join(" ");
                        }
                        function m(e, t) {
                            var r = a(t, e), i = a(e, t);
                            r = d(r, 1), i = d(i, -1), r && r.length && n.addClass(o, r), i && i.length && n.removeClass(o, i);
                        }
                        function f(e) {
                            if (t === !0 || s.$index % 2 === t) {
                                var n = r(e || []);
                                if (p) {
                                    if (!I(e, p)) {
                                        var a = r(p);
                                        m(a, n);
                                    }
                                } else l(n);
                            }
                            p = P(e);
                        }
                        var p;
                        s.$watch(u[e], f, !0), u.$observe("class", function(t) {
                            f(s.$eval(u[e]));
                        }), "ngClass" !== e && s.$watch("$index", function(n, a) {
                            var i = 1 & n;
                            if (i !== (1 & a)) {
                                var o = r(s.$eval(u[e]));
                                i === t ? l(o) : c(o);
                            }
                        });
                    }
                };
            } ];
        }
        function Wn(e) {
            function t(e, t, u) {
                t === n ? a("$pending", e, u) : r("$pending", e, u), x(t) ? t ? (d(o.$error, e, u), 
                c(o.$$success, e, u)) : (c(o.$error, e, u), d(o.$$success, e, u)) : (d(o.$error, e, u), 
                d(o.$$success, e, u)), o.$pending ? (i(gi, !0), o.$valid = o.$invalid = n, s("", null)) : (i(gi, !1), 
                o.$valid = qn(o.$error), o.$invalid = !o.$valid, s("", o.$valid));
                var l;
                l = o.$pending && o.$pending[e] ? n : !o.$error[e] && (!!o.$$success[e] || null), 
                s(e, l), m.$setValidity(e, l, o);
            }
            function a(e, t, n) {
                o[e] || (o[e] = {}), c(o[e], t, n);
            }
            function r(e, t, a) {
                o[e] && d(o[e], t, a), qn(o[e]) && (o[e] = n);
            }
            function i(e, t) {
                t && !l[e] ? (f.addClass(u, e), l[e] = !0) : !t && l[e] && (f.removeClass(u, e), 
                l[e] = !1);
            }
            function s(e, t) {
                e = e ? "-" + ne(e, "-") : "", i(ci + e, t === !0), i(di + e, t === !1);
            }
            var o = e.ctrl, u = e.$element, l = {}, c = e.set, d = e.unset, m = e.parentForm, f = e.$animate;
            l[di] = !(l[ci] = u.hasClass(ci)), o.$setValidity = t;
        }
        function qn(e) {
            if (e) for (var t in e) return !1;
            return !0;
        }
        var Rn = /^\/(.+)\/([a-z]*)$/, zn = "validity", Bn = function(e) {
            return y(e) ? e.toLowerCase() : e;
        }, Gn = Object.prototype.hasOwnProperty, Jn = function(e) {
            return y(e) ? e.toUpperCase() : e;
        }, Kn = function(e) {
            return y(e) ? e.replace(/[A-Z]/g, function(e) {
                return String.fromCharCode(32 | e.charCodeAt(0));
            }) : e;
        }, Zn = function(e) {
            return y(e) ? e.replace(/[a-z]/g, function(e) {
                return String.fromCharCode(e.charCodeAt(0) & -33);
            }) : e;
        };
        "i" !== "I".toLowerCase() && (Bn = Kn, Jn = Zn);
        var Qn, Xn, ea, ta, na = [].slice, aa = [].splice, ra = [].push, ia = Object.prototype.toString, sa = a("ng"), oa = e.angular || (e.angular = {}), ua = 0;
        Qn = t.documentMode, p.$inject = [], h.$inject = [];
        var la, ca = Array.isArray, da = function(e) {
            return y(e) ? e.trim() : e;
        }, ma = function(e) {
            return e.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
        }, fa = function() {
            if (v(fa.isActive_)) return fa.isActive_;
            var e = !(!t.querySelector("[ng-csp]") && !t.querySelector("[data-ng-csp]"));
            if (!e) try {
                new Function("");
            } catch (t) {
                e = !0;
            }
            return fa.isActive_ = e;
        }, pa = [ "ng-", "data-ng-", "ng:", "x-ng-" ], ha = /[A-Z]/g, ga = !1, _a = 1, va = 3, ba = 8, ya = 9, Ma = 11, $a = {
            full: "1.3.14",
            major: 1,
            minor: 3,
            dot: 14,
            codeName: "instantaneous-browserification"
        };
        ye.expando = "ng339";
        var La = ye.cache = {}, ka = 1, wa = function(e, t, n) {
            e.addEventListener(t, n, !1);
        }, Da = function(e, t, n) {
            e.removeEventListener(t, n, !1);
        };
        ye._data = function(e) {
            return this.cache[e[this.expando]] || {};
        };
        var Ya = /([\:\-\_]+(.))/g, Ta = /^moz([A-Z])/, Sa = {
            mouseleave: "mouseout",
            mouseenter: "mouseover"
        }, xa = a("jqLite"), Ca = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, Ea = /<|&#?\w+;/, Ha = /<([\w:]+)/, ja = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, Aa = {
            option: [ 1, '<select multiple="multiple">', "</select>" ],
            thead: [ 1, "<table>", "</table>" ],
            col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
            tr: [ 2, "<table><tbody>", "</tbody></table>" ],
            td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
            _default: [ 0, "", "" ]
        };
        Aa.optgroup = Aa.option, Aa.tbody = Aa.tfoot = Aa.colgroup = Aa.caption = Aa.thead, 
        Aa.th = Aa.td;
        var Oa = ye.prototype = {
            ready: function(n) {
                function a() {
                    r || (r = !0, n());
                }
                var r = !1;
                "complete" === t.readyState ? setTimeout(a) : (this.on("DOMContentLoaded", a), ye(e).on("load", a));
            },
            toString: function() {
                var e = [];
                return i(this, function(t) {
                    e.push("" + t);
                }), "[" + e.join(", ") + "]";
            },
            eq: function(e) {
                return Xn(e >= 0 ? this[e] : this[this.length + e]);
            },
            length: 0,
            push: ra,
            sort: [].sort,
            splice: [].splice
        }, Pa = {};
        i("multiple,selected,checked,disabled,readOnly,required,open".split(","), function(e) {
            Pa[Bn(e)] = e;
        });
        var Ia = {};
        i("input,select,option,textarea,button,form,details".split(","), function(e) {
            Ia[e] = !0;
        });
        var Fa = {
            ngMinlength: "minlength",
            ngMaxlength: "maxlength",
            ngMin: "min",
            ngMax: "max",
            ngPattern: "pattern"
        };
        i({
            data: De,
            removeData: ke
        }, function(e, t) {
            ye[t] = e;
        }), i({
            data: De,
            inheritedData: Ee,
            scope: function(e) {
                return Xn.data(e, "$scope") || Ee(e.parentNode || e, [ "$isolateScope", "$scope" ]);
            },
            isolateScope: function(e) {
                return Xn.data(e, "$isolateScope") || Xn.data(e, "$isolateScopeNoTemplate");
            },
            controller: Ce,
            injector: function(e) {
                return Ee(e, "$injector");
            },
            removeAttr: function(e, t) {
                e.removeAttribute(t);
            },
            hasClass: Ye,
            css: function(e, t, n) {
                return t = he(t), v(n) ? void (e.style[t] = n) : e.style[t];
            },
            attr: function(e, t, a) {
                var r = Bn(t);
                if (Pa[r]) {
                    if (!v(a)) return e[t] || (e.attributes.getNamedItem(t) || p).specified ? r : n;
                    a ? (e[t] = !0, e.setAttribute(t, r)) : (e[t] = !1, e.removeAttribute(r));
                } else if (v(a)) e.setAttribute(t, a); else if (e.getAttribute) {
                    var i = e.getAttribute(t, 2);
                    return null === i ? n : i;
                }
            },
            prop: function(e, t, n) {
                return v(n) ? void (e[t] = n) : e[t];
            },
            text: function() {
                function e(e, t) {
                    if (_(t)) {
                        var n = e.nodeType;
                        return n === _a || n === va ? e.textContent : "";
                    }
                    e.textContent = t;
                }
                return e.$dv = "", e;
            }(),
            val: function(e, t) {
                if (_(t)) {
                    if (e.multiple && "select" === j(e)) {
                        var n = [];
                        return i(e.options, function(e) {
                            e.selected && n.push(e.value || e.text);
                        }), 0 === n.length ? null : n;
                    }
                    return e.value;
                }
                e.value = t;
            },
            html: function(e, t) {
                return _(t) ? e.innerHTML : ($e(e, !0), void (e.innerHTML = t));
            },
            empty: He
        }, function(e, t) {
            ye.prototype[t] = function(t, a) {
                var r, i, s = this.length;
                if (e !== He && (2 == e.length && e !== Ye && e !== Ce ? t : a) === n) {
                    if (b(t)) {
                        for (r = 0; r < s; r++) if (e === De) e(this[r], t); else for (i in t) e(this[r], i, t[i]);
                        return this;
                    }
                    for (var o = e.$dv, u = o === n ? Math.min(s, 1) : s, l = 0; l < u; l++) {
                        var c = e(this[l], t, a);
                        o = o ? o + c : c;
                    }
                    return o;
                }
                for (r = 0; r < s; r++) e(this[r], t, a);
                return this;
            };
        }), i({
            removeData: ke,
            on: function e(t, n, a, r) {
                if (v(r)) throw xa("onargs", "jqLite#on() does not support the `selector` or `eventData` parameters");
                if (_e(t)) {
                    var i = we(t, !0), s = i.events, o = i.handle;
                    o || (o = i.handle = Ie(t, s));
                    for (var u = n.indexOf(" ") >= 0 ? n.split(" ") : [ n ], l = u.length; l--; ) {
                        n = u[l];
                        var c = s[n];
                        c || (s[n] = [], "mouseenter" === n || "mouseleave" === n ? e(t, Sa[n], function(e) {
                            var t = this, a = e.relatedTarget;
                            a && (a === t || t.contains(a)) || o(e, n);
                        }) : "$destroy" !== n && wa(t, n, o), c = s[n]), c.push(a);
                    }
                }
            },
            off: Le,
            one: function(e, t, n) {
                e = Xn(e), e.on(t, function a() {
                    e.off(t, n), e.off(t, a);
                }), e.on(t, n);
            },
            replaceWith: function(e, t) {
                var n, a = e.parentNode;
                $e(e), i(new ye(t), function(t) {
                    n ? a.insertBefore(t, n.nextSibling) : a.replaceChild(t, e), n = t;
                });
            },
            children: function(e) {
                var t = [];
                return i(e.childNodes, function(e) {
                    e.nodeType === _a && t.push(e);
                }), t;
            },
            contents: function(e) {
                return e.contentDocument || e.childNodes || [];
            },
            append: function(e, t) {
                var n = e.nodeType;
                if (n === _a || n === Ma) {
                    t = new ye(t);
                    for (var a = 0, r = t.length; a < r; a++) {
                        var i = t[a];
                        e.appendChild(i);
                    }
                }
            },
            prepend: function(e, t) {
                if (e.nodeType === _a) {
                    var n = e.firstChild;
                    i(new ye(t), function(t) {
                        e.insertBefore(t, n);
                    });
                }
            },
            wrap: function(e, t) {
                t = Xn(t).eq(0).clone()[0];
                var n = e.parentNode;
                n && n.replaceChild(t, e), t.appendChild(e);
            },
            remove: je,
            detach: function(e) {
                je(e, !0);
            },
            after: function(e, t) {
                var n = e, a = e.parentNode;
                t = new ye(t);
                for (var r = 0, i = t.length; r < i; r++) {
                    var s = t[r];
                    a.insertBefore(s, n.nextSibling), n = s;
                }
            },
            addClass: Se,
            removeClass: Te,
            toggleClass: function(e, t, n) {
                t && i(t.split(" "), function(t) {
                    var a = n;
                    _(a) && (a = !Ye(e, t)), (a ? Se : Te)(e, t);
                });
            },
            parent: function(e) {
                var t = e.parentNode;
                return t && t.nodeType !== Ma ? t : null;
            },
            next: function(e) {
                return e.nextElementSibling;
            },
            find: function(e, t) {
                return e.getElementsByTagName ? e.getElementsByTagName(t) : [];
            },
            clone: Me,
            triggerHandler: function(e, t, n) {
                var a, r, s, o = t.type || t, u = we(e), l = u && u.events, c = l && l[o];
                c && (a = {
                    preventDefault: function() {
                        this.defaultPrevented = !0;
                    },
                    isDefaultPrevented: function() {
                        return this.defaultPrevented === !0;
                    },
                    stopImmediatePropagation: function() {
                        this.immediatePropagationStopped = !0;
                    },
                    isImmediatePropagationStopped: function() {
                        return this.immediatePropagationStopped === !0;
                    },
                    stopPropagation: p,
                    type: o,
                    target: e
                }, t.type && (a = d(a, t)), r = P(c), s = n ? [ a ].concat(n) : [ a ], i(r, function(t) {
                    a.isImmediatePropagationStopped() || t.apply(e, s);
                }));
            }
        }, function(e, t) {
            ye.prototype[t] = function(t, n, a) {
                for (var r, i = 0, s = this.length; i < s; i++) _(r) ? (r = e(this[i], t, n, a), 
                v(r) && (r = Xn(r))) : xe(r, e(this[i], t, n, a));
                return v(r) ? r : this;
            }, ye.prototype.bind = ye.prototype.on, ye.prototype.unbind = ye.prototype.off;
        }), Ue.prototype = {
            put: function(e, t) {
                this[Ne(e, this.nextUid)] = t;
            },
            get: function(e) {
                return this[Ne(e, this.nextUid)];
            },
            remove: function(e) {
                var t = this[e = Ne(e, this.nextUid)];
                return delete this[e], t;
            }
        };
        var Na = /^function\s*[^\(]*\(\s*([^\)]*)\)/m, Ua = /,/, Va = /^\s*(_?)(\S+?)\1\s*$/, Wa = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm, qa = a("$injector");
        qe.$$annotate = We;
        var Ra = a("$animate"), za = [ "$provide", function(e) {
            this.$$selectors = {}, this.register = function(t, n) {
                var a = t + "-animation";
                if (t && "." != t.charAt(0)) throw Ra("notcsel", "Expecting class selector starting with '.' got '{0}'.", t);
                this.$$selectors[t.substr(1)] = a, e.factory(a, n);
            }, this.classNameFilter = function(e) {
                return 1 === arguments.length && (this.$$classNameFilter = e instanceof RegExp ? e : null), 
                this.$$classNameFilter;
            }, this.$get = [ "$$q", "$$asyncCallback", "$rootScope", function(e, t, n) {
                function a(t) {
                    var a, r = e.defer();
                    return r.promise.$$cancelFn = function() {
                        a && a();
                    }, n.$$postDigest(function() {
                        a = t(function() {
                            r.resolve();
                        });
                    }), r.promise;
                }
                function r(e, t) {
                    var n = [], a = [], r = le();
                    return i((e.attr("class") || "").split(/\s+/), function(e) {
                        r[e] = !0;
                    }), i(t, function(e, t) {
                        var i = r[t];
                        e === !1 && i ? a.push(t) : e !== !0 || i || n.push(t);
                    }), n.length + a.length > 0 && [ n.length ? n : null, a.length ? a : null ];
                }
                function s(e, t, n) {
                    for (var a = 0, r = t.length; a < r; ++a) {
                        var i = t[a];
                        e[i] = n;
                    }
                }
                function o() {
                    return l || (l = e.defer(), t(function() {
                        l.resolve(), l = null;
                    })), l.promise;
                }
                function u(e, t) {
                    if (oa.isObject(t)) {
                        var n = d(t.from || {}, t.to || {});
                        e.css(n);
                    }
                }
                var l;
                return {
                    animate: function(e, t, n) {
                        return u(e, {
                            from: t,
                            to: n
                        }), o();
                    },
                    enter: function(e, t, n, a) {
                        return u(e, a), n ? n.after(e) : t.prepend(e), o();
                    },
                    leave: function(e, t) {
                        return e.remove(), o();
                    },
                    move: function(e, t, n, a) {
                        return this.enter(e, t, n, a);
                    },
                    addClass: function(e, t, n) {
                        return this.setClass(e, t, [], n);
                    },
                    $$addClassImmediately: function(e, t, n) {
                        return e = Xn(e), t = y(t) ? t : ca(t) ? t.join(" ") : "", i(e, function(e) {
                            Se(e, t);
                        }), u(e, n), o();
                    },
                    removeClass: function(e, t, n) {
                        return this.setClass(e, [], t, n);
                    },
                    $$removeClassImmediately: function(e, t, n) {
                        return e = Xn(e), t = y(t) ? t : ca(t) ? t.join(" ") : "", i(e, function(e) {
                            Te(e, t);
                        }), u(e, n), o();
                    },
                    setClass: function(e, t, n, i) {
                        var o = this, u = "$$animateClasses", l = !1;
                        e = Xn(e);
                        var c = e.data(u);
                        c ? i && c.options && (c.options = oa.extend(c.options || {}, i)) : (c = {
                            classes: {},
                            options: i
                        }, l = !0);
                        var d = c.classes;
                        return t = ca(t) ? t : t.split(" "), n = ca(n) ? n : n.split(" "), s(d, t, !0), 
                        s(d, n, !1), l && (c.promise = a(function(t) {
                            var n = e.data(u);
                            if (e.removeData(u), n) {
                                var a = r(e, n.classes);
                                a && o.$$setClassImmediately(e, a[0], a[1], n.options);
                            }
                            t();
                        }), e.data(u, c)), c.promise;
                    },
                    $$setClassImmediately: function(e, t, n, a) {
                        return t && this.$$addClassImmediately(e, t), n && this.$$removeClassImmediately(e, n), 
                        u(e, a), o();
                    },
                    enabled: p,
                    cancel: p
                };
            } ];
        } ], Ba = a("$compile");
        Ze.$inject = [ "$provide", "$$sanitizeUriProvider" ];
        var Ga = /^((?:x|data)[\:\-_])/i, Ja = a("$controller"), Ka = "application/json", Za = {
            "Content-Type": Ka + ";charset=utf-8"
        }, Qa = /^\[|^\{(?!\{)/, Xa = {
            "[": /]$/,
            "{": /}$/
        }, er = /^\)\]\}',?\n/, tr = a("$interpolate"), nr = /^([^\?#]*)(\?([^#]*))?(#(.*))?$/, ar = {
            http: 80,
            https: 443,
            ftp: 21
        }, rr = a("$location"), ir = {
            $$html5: !1,
            $$replace: !1,
            absUrl: Tt("$$absUrl"),
            url: function(e) {
                if (_(e)) return this.$$url;
                var t = nr.exec(e);
                return (t[1] || "" === e) && this.path(decodeURIComponent(t[1])), (t[2] || t[1] || "" === e) && this.search(t[3] || ""), 
                this.hash(t[5] || ""), this;
            },
            protocol: Tt("$$protocol"),
            host: Tt("$$host"),
            port: Tt("$$port"),
            path: St("$$path", function(e) {
                return e = null !== e ? e.toString() : "", "/" == e.charAt(0) ? e : "/" + e;
            }),
            search: function(e, t) {
                switch (arguments.length) {
                  case 0:
                    return this.$$search;

                  case 1:
                    if (y(e) || M(e)) e = e.toString(), this.$$search = B(e); else {
                        if (!b(e)) throw rr("isrcharg", "The first argument of the `$location#search()` call must be a string or an object.");
                        e = O(e, {}), i(e, function(t, n) {
                            null == t && delete e[n];
                        }), this.$$search = e;
                    }
                    break;

                  default:
                    _(t) || null === t ? delete this.$$search[e] : this.$$search[e] = t;
                }
                return this.$$compose(), this;
            },
            hash: St("$$hash", function(e) {
                return null !== e ? e.toString() : "";
            }),
            replace: function() {
                return this.$$replace = !0, this;
            }
        };
        i([ Yt, Dt, wt ], function(e) {
            e.prototype = Object.create(ir), e.prototype.state = function(t) {
                if (!arguments.length) return this.$$state;
                if (e !== wt || !this.$$html5) throw rr("nostate", "History API state support is available only in HTML5 mode and only in browsers supporting HTML5 History API");
                return this.$$state = _(t) ? null : t, this;
            };
        });
        var sr = a("$parse"), or = Function.prototype.call, ur = Function.prototype.apply, lr = Function.prototype.bind, cr = le();
        i({
            null: function() {
                return null;
            },
            true: function() {
                return !0;
            },
            false: function() {
                return !1;
            },
            undefined: function() {}
        }, function(e, t) {
            e.constant = e.literal = e.sharedGetter = !0, cr[t] = e;
        }), cr.this = function(e) {
            return e;
        }, cr.this.sharedGetter = !0;
        var dr = d(le(), {
            "+": function(e, t, a, r) {
                return a = a(e, t), r = r(e, t), v(a) ? v(r) ? a + r : a : v(r) ? r : n;
            },
            "-": function(e, t, n, a) {
                return n = n(e, t), a = a(e, t), (v(n) ? n : 0) - (v(a) ? a : 0);
            },
            "*": function(e, t, n, a) {
                return n(e, t) * a(e, t);
            },
            "/": function(e, t, n, a) {
                return n(e, t) / a(e, t);
            },
            "%": function(e, t, n, a) {
                return n(e, t) % a(e, t);
            },
            "===": function(e, t, n, a) {
                return n(e, t) === a(e, t);
            },
            "!==": function(e, t, n, a) {
                return n(e, t) !== a(e, t);
            },
            "==": function(e, t, n, a) {
                return n(e, t) == a(e, t);
            },
            "!=": function(e, t, n, a) {
                return n(e, t) != a(e, t);
            },
            "<": function(e, t, n, a) {
                return n(e, t) < a(e, t);
            },
            ">": function(e, t, n, a) {
                return n(e, t) > a(e, t);
            },
            "<=": function(e, t, n, a) {
                return n(e, t) <= a(e, t);
            },
            ">=": function(e, t, n, a) {
                return n(e, t) >= a(e, t);
            },
            "&&": function(e, t, n, a) {
                return n(e, t) && a(e, t);
            },
            "||": function(e, t, n, a) {
                return n(e, t) || a(e, t);
            },
            "!": function(e, t, n) {
                return !n(e, t);
            },
            "=": !0,
            "|": !0
        }), mr = {
            n: "\n",
            f: "\f",
            r: "\r",
            t: "\t",
            v: "\v",
            "'": "'",
            '"': '"'
        }, fr = function(e) {
            this.options = e;
        };
        fr.prototype = {
            constructor: fr,
            lex: function(e) {
                for (this.text = e, this.index = 0, this.tokens = []; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if ('"' === t || "'" === t) this.readString(t); else if (this.isNumber(t) || "." === t && this.isNumber(this.peek())) this.readNumber(); else if (this.isIdent(t)) this.readIdent(); else if (this.is(t, "(){}[].,;:?")) this.tokens.push({
                        index: this.index,
                        text: t
                    }), this.index++; else if (this.isWhitespace(t)) this.index++; else {
                        var n = t + this.peek(), a = n + this.peek(2), r = dr[t], i = dr[n], s = dr[a];
                        if (r || i || s) {
                            var o = s ? a : i ? n : t;
                            this.tokens.push({
                                index: this.index,
                                text: o,
                                operator: !0
                            }), this.index += o.length;
                        } else this.throwError("Unexpected next character ", this.index, this.index + 1);
                    }
                }
                return this.tokens;
            },
            is: function(e, t) {
                return t.indexOf(e) !== -1;
            },
            peek: function(e) {
                var t = e || 1;
                return this.index + t < this.text.length && this.text.charAt(this.index + t);
            },
            isNumber: function(e) {
                return "0" <= e && e <= "9" && "string" == typeof e;
            },
            isWhitespace: function(e) {
                return " " === e || "\r" === e || "\t" === e || "\n" === e || "\v" === e || " " === e;
            },
            isIdent: function(e) {
                return "a" <= e && e <= "z" || "A" <= e && e <= "Z" || "_" === e || "$" === e;
            },
            isExpOperator: function(e) {
                return "-" === e || "+" === e || this.isNumber(e);
            },
            throwError: function(e, t, n) {
                n = n || this.index;
                var a = v(t) ? "s " + t + "-" + this.index + " [" + this.text.substring(t, n) + "]" : " " + n;
                throw sr("lexerr", "Lexer Error: {0} at column{1} in expression [{2}].", e, a, this.text);
            },
            readNumber: function() {
                for (var e = "", t = this.index; this.index < this.text.length; ) {
                    var n = Bn(this.text.charAt(this.index));
                    if ("." == n || this.isNumber(n)) e += n; else {
                        var a = this.peek();
                        if ("e" == n && this.isExpOperator(a)) e += n; else if (this.isExpOperator(n) && a && this.isNumber(a) && "e" == e.charAt(e.length - 1)) e += n; else {
                            if (!this.isExpOperator(n) || a && this.isNumber(a) || "e" != e.charAt(e.length - 1)) break;
                            this.throwError("Invalid exponent");
                        }
                    }
                    this.index++;
                }
                this.tokens.push({
                    index: t,
                    text: e,
                    constant: !0,
                    value: Number(e)
                });
            },
            readIdent: function() {
                for (var e = this.index; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if (!this.isIdent(t) && !this.isNumber(t)) break;
                    this.index++;
                }
                this.tokens.push({
                    index: e,
                    text: this.text.slice(e, this.index),
                    identifier: !0
                });
            },
            readString: function(e) {
                var t = this.index;
                this.index++;
                for (var n = "", a = e, r = !1; this.index < this.text.length; ) {
                    var i = this.text.charAt(this.index);
                    if (a += i, r) {
                        if ("u" === i) {
                            var s = this.text.substring(this.index + 1, this.index + 5);
                            s.match(/[\da-f]{4}/i) || this.throwError("Invalid unicode escape [\\u" + s + "]"), 
                            this.index += 4, n += String.fromCharCode(parseInt(s, 16));
                        } else {
                            var o = mr[i];
                            n += o || i;
                        }
                        r = !1;
                    } else if ("\\" === i) r = !0; else {
                        if (i === e) return this.index++, void this.tokens.push({
                            index: t,
                            text: a,
                            constant: !0,
                            value: n
                        });
                        n += i;
                    }
                    this.index++;
                }
                this.throwError("Unterminated quote", t);
            }
        };
        var pr = function(e, t, n) {
            this.lexer = e, this.$filter = t, this.options = n;
        };
        pr.ZERO = d(function() {
            return 0;
        }, {
            sharedGetter: !0,
            constant: !0
        }), pr.prototype = {
            constructor: pr,
            parse: function(e) {
                this.text = e, this.tokens = this.lexer.lex(e);
                var t = this.statements();
                return 0 !== this.tokens.length && this.throwError("is an unexpected token", this.tokens[0]), 
                t.literal = !!t.literal, t.constant = !!t.constant, t;
            },
            primary: function() {
                var e;
                this.expect("(") ? (e = this.filterChain(), this.consume(")")) : this.expect("[") ? e = this.arrayDeclaration() : this.expect("{") ? e = this.object() : this.peek().identifier && this.peek().text in cr ? e = cr[this.consume().text] : this.peek().identifier ? e = this.identifier() : this.peek().constant ? e = this.constant() : this.throwError("not a primary expression", this.peek());
                for (var t, n; t = this.expect("(", "[", "."); ) "(" === t.text ? (e = this.functionCall(e, n), 
                n = null) : "[" === t.text ? (n = e, e = this.objectIndex(e)) : "." === t.text ? (n = e, 
                e = this.fieldAccess(e)) : this.throwError("IMPOSSIBLE");
                return e;
            },
            throwError: function(e, t) {
                throw sr("syntax", "Syntax Error: Token '{0}' {1} at column {2} of the expression [{3}] starting at [{4}].", t.text, e, t.index + 1, this.text, this.text.substring(t.index));
            },
            peekToken: function() {
                if (0 === this.tokens.length) throw sr("ueoe", "Unexpected end of expression: {0}", this.text);
                return this.tokens[0];
            },
            peek: function(e, t, n, a) {
                return this.peekAhead(0, e, t, n, a);
            },
            peekAhead: function(e, t, n, a, r) {
                if (this.tokens.length > e) {
                    var i = this.tokens[e], s = i.text;
                    if (s === t || s === n || s === a || s === r || !t && !n && !a && !r) return i;
                }
                return !1;
            },
            expect: function(e, t, n, a) {
                var r = this.peek(e, t, n, a);
                return !!r && (this.tokens.shift(), r);
            },
            consume: function(e) {
                if (0 === this.tokens.length) throw sr("ueoe", "Unexpected end of expression: {0}", this.text);
                var t = this.expect(e);
                return t || this.throwError("is unexpected, expecting [" + e + "]", this.peek()), 
                t;
            },
            unaryFn: function(e, t) {
                var n = dr[e];
                return d(function(e, a) {
                    return n(e, a, t);
                }, {
                    constant: t.constant,
                    inputs: [ t ]
                });
            },
            binaryFn: function(e, t, n, a) {
                var r = dr[t];
                return d(function(t, a) {
                    return r(t, a, e, n);
                }, {
                    constant: e.constant && n.constant,
                    inputs: !a && [ e, n ]
                });
            },
            identifier: function() {
                for (var e = this.consume().text; this.peek(".") && this.peekAhead(1).identifier && !this.peekAhead(2, "("); ) e += this.consume().text + this.consume().text;
                return Nt(e, this.options, this.text);
            },
            constant: function() {
                var e = this.consume().value;
                return d(function() {
                    return e;
                }, {
                    constant: !0,
                    literal: !0
                });
            },
            statements: function() {
                for (var e = []; ;) if (this.tokens.length > 0 && !this.peek("}", ")", ";", "]") && e.push(this.filterChain()), 
                !this.expect(";")) return 1 === e.length ? e[0] : function(t, n) {
                    for (var a, r = 0, i = e.length; r < i; r++) a = e[r](t, n);
                    return a;
                };
            },
            filterChain: function() {
                for (var e, t = this.expression(); e = this.expect("|"); ) t = this.filter(t);
                return t;
            },
            filter: function(e) {
                var t, a, r = this.$filter(this.consume().text);
                if (this.peek(":")) for (t = [], a = []; this.expect(":"); ) t.push(this.expression());
                var i = [ e ].concat(t || []);
                return d(function(i, s) {
                    var o = e(i, s);
                    if (a) {
                        a[0] = o;
                        for (var u = t.length; u--; ) a[u + 1] = t[u](i, s);
                        return r.apply(n, a);
                    }
                    return r(o);
                }, {
                    constant: !r.$stateful && i.every(At),
                    inputs: !r.$stateful && i
                });
            },
            expression: function() {
                return this.assignment();
            },
            assignment: function() {
                var e, t, n = this.ternary();
                return (t = this.expect("=")) ? (n.assign || this.throwError("implies assignment but [" + this.text.substring(0, t.index) + "] can not be assigned to", t), 
                e = this.ternary(), d(function(t, a) {
                    return n.assign(t, e(t, a), a);
                }, {
                    inputs: [ n, e ]
                })) : n;
            },
            ternary: function() {
                var e, t, n = this.logicalOR();
                if ((t = this.expect("?")) && (e = this.assignment(), this.consume(":"))) {
                    var a = this.assignment();
                    return d(function(t, r) {
                        return n(t, r) ? e(t, r) : a(t, r);
                    }, {
                        constant: n.constant && e.constant && a.constant
                    });
                }
                return n;
            },
            logicalOR: function() {
                for (var e, t = this.logicalAND(); e = this.expect("||"); ) t = this.binaryFn(t, e.text, this.logicalAND(), !0);
                return t;
            },
            logicalAND: function() {
                for (var e, t = this.equality(); e = this.expect("&&"); ) t = this.binaryFn(t, e.text, this.equality(), !0);
                return t;
            },
            equality: function() {
                for (var e, t = this.relational(); e = this.expect("==", "!=", "===", "!=="); ) t = this.binaryFn(t, e.text, this.relational());
                return t;
            },
            relational: function() {
                for (var e, t = this.additive(); e = this.expect("<", ">", "<=", ">="); ) t = this.binaryFn(t, e.text, this.additive());
                return t;
            },
            additive: function() {
                for (var e, t = this.multiplicative(); e = this.expect("+", "-"); ) t = this.binaryFn(t, e.text, this.multiplicative());
                return t;
            },
            multiplicative: function() {
                for (var e, t = this.unary(); e = this.expect("*", "/", "%"); ) t = this.binaryFn(t, e.text, this.unary());
                return t;
            },
            unary: function() {
                var e;
                return this.expect("+") ? this.primary() : (e = this.expect("-")) ? this.binaryFn(pr.ZERO, e.text, this.unary()) : (e = this.expect("!")) ? this.unaryFn(e.text, this.unary()) : this.primary();
            },
            fieldAccess: function(e) {
                var t = this.identifier();
                return d(function(a, r, i) {
                    var s = i || e(a, r);
                    return null == s ? n : t(s);
                }, {
                    assign: function(n, a, r) {
                        var i = e(n, r);
                        return i || e.assign(n, i = {}, r), t.assign(i, a);
                    }
                });
            },
            objectIndex: function(e) {
                var t = this.text, a = this.expression();
                return this.consume("]"), d(function(r, i) {
                    var s, o = e(r, i), u = a(r, i);
                    return Et(u, t), o ? s = Ht(o[u], t) : n;
                }, {
                    assign: function(n, r, i) {
                        var s = Et(a(n, i), t), o = Ht(e(n, i), t);
                        return o || e.assign(n, o = {}, i), o[s] = r;
                    }
                });
            },
            functionCall: function(e, t) {
                var a = [];
                if (")" !== this.peekToken().text) do a.push(this.expression()); while (this.expect(","));
                this.consume(")");
                var r = this.text, i = a.length ? [] : null;
                return function(s, o) {
                    var u = t ? t(s, o) : v(t) ? n : s, l = e(s, o, u) || p;
                    if (i) for (var c = a.length; c--; ) i[c] = Ht(a[c](s, o), r);
                    Ht(u, r), jt(l, r);
                    var d = l.apply ? l.apply(u, i) : l(i[0], i[1], i[2], i[3], i[4]);
                    return i && (i.length = 0), Ht(d, r);
                };
            },
            arrayDeclaration: function() {
                var e = [];
                if ("]" !== this.peekToken().text) do {
                    if (this.peek("]")) break;
                    e.push(this.expression());
                } while (this.expect(","));
                return this.consume("]"), d(function(t, n) {
                    for (var a = [], r = 0, i = e.length; r < i; r++) a.push(e[r](t, n));
                    return a;
                }, {
                    literal: !0,
                    constant: e.every(At),
                    inputs: e
                });
            },
            object: function() {
                var e = [], t = [];
                if ("}" !== this.peekToken().text) do {
                    if (this.peek("}")) break;
                    var n = this.consume();
                    n.constant ? e.push(n.value) : n.identifier ? e.push(n.text) : this.throwError("invalid key", n), 
                    this.consume(":"), t.push(this.expression());
                } while (this.expect(","));
                return this.consume("}"), d(function(n, a) {
                    for (var r = {}, i = 0, s = t.length; i < s; i++) r[e[i]] = t[i](n, a);
                    return r;
                }, {
                    literal: !0,
                    constant: t.every(At),
                    inputs: t
                });
            }
        };
        var hr = le(), gr = le(), _r = Object.prototype.valueOf, vr = a("$sce"), br = {
            HTML: "html",
            CSS: "css",
            URL: "url",
            RESOURCE_URL: "resourceUrl",
            JS: "js"
        }, Ba = a("$compile"), yr = t.createElement("a"), Mr = an(e.location.href);
        on.$inject = [ "$provide" ], dn.$inject = [ "$locale" ], mn.$inject = [ "$locale" ];
        var $r = ".", Lr = {
            yyyy: hn("FullYear", 4),
            yy: hn("FullYear", 2, 0, !0),
            y: hn("FullYear", 1),
            MMMM: gn("Month"),
            MMM: gn("Month", !0),
            MM: hn("Month", 2, 1),
            M: hn("Month", 1, 1),
            dd: hn("Date", 2),
            d: hn("Date", 1),
            HH: hn("Hours", 2),
            H: hn("Hours", 1),
            hh: hn("Hours", 2, -12),
            h: hn("Hours", 1, -12),
            mm: hn("Minutes", 2),
            m: hn("Minutes", 1),
            ss: hn("Seconds", 2),
            s: hn("Seconds", 1),
            sss: hn("Milliseconds", 3),
            EEEE: gn("Day"),
            EEE: gn("Day", !0),
            a: Mn,
            Z: _n,
            ww: yn(2),
            w: yn(1)
        }, kr = /((?:[^yMdHhmsaZEw']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z|w+))(.*)/, wr = /^\-?\d+$/;
        $n.$inject = [ "$locale" ];
        var Dr = g(Bn), Yr = g(Jn);
        wn.$inject = [ "$parse" ];
        var Tr = g({
            restrict: "E",
            compile: function(e, t) {
                if (!t.href && !t.xlinkHref && !t.name) return function(e, t) {
                    if ("a" === t[0].nodeName.toLowerCase()) {
                        var n = "[object SVGAnimatedString]" === ia.call(t.prop("href")) ? "xlink:href" : "href";
                        t.on("click", function(e) {
                            t.attr(n) || e.preventDefault();
                        });
                    }
                };
            }
        }), Sr = {};
        i(Pa, function(e, t) {
            if ("multiple" != e) {
                var n = Qe("ng-" + t);
                Sr[n] = function() {
                    return {
                        restrict: "A",
                        priority: 100,
                        link: function(e, a, r) {
                            e.$watch(r[n], function(e) {
                                r.$set(t, !!e);
                            });
                        }
                    };
                };
            }
        }), i(Fa, function(e, t) {
            Sr[t] = function() {
                return {
                    priority: 100,
                    link: function(e, n, a) {
                        if ("ngPattern" === t && "/" == a.ngPattern.charAt(0)) {
                            var r = a.ngPattern.match(Rn);
                            if (r) return void a.$set("ngPattern", new RegExp(r[1], r[2]));
                        }
                        e.$watch(a[t], function(e) {
                            a.$set(t, e);
                        });
                    }
                };
            };
        }), i([ "src", "srcset", "href" ], function(e) {
            var t = Qe("ng-" + e);
            Sr[t] = function() {
                return {
                    priority: 99,
                    link: function(n, a, r) {
                        var i = e, s = e;
                        "href" === e && "[object SVGAnimatedString]" === ia.call(a.prop("href")) && (s = "xlinkHref", 
                        r.$attr[s] = "xlink:href", i = null), r.$observe(t, function(t) {
                            return t ? (r.$set(s, t), void (Qn && i && a.prop(i, r[s]))) : void ("href" === e && r.$set(s, null));
                        });
                    }
                };
            };
        });
        var xr = {
            $addControl: p,
            $$renameControl: Yn,
            $removeControl: p,
            $setValidity: p,
            $setDirty: p,
            $setPristine: p,
            $setSubmitted: p
        }, Cr = "ng-submitted";
        Tn.$inject = [ "$element", "$attrs", "$scope", "$animate", "$interpolate" ];
        var Er = function(e) {
            return [ "$timeout", function(t) {
                var a = {
                    name: "form",
                    restrict: e ? "EAC" : "E",
                    controller: Tn,
                    compile: function(e) {
                        return e.addClass(mi).addClass(ci), {
                            pre: function(e, a, r, i) {
                                if (!("action" in r)) {
                                    var s = function(t) {
                                        e.$apply(function() {
                                            i.$commitViewValue(), i.$setSubmitted();
                                        }), t.preventDefault();
                                    };
                                    wa(a[0], "submit", s), a.on("$destroy", function() {
                                        t(function() {
                                            Da(a[0], "submit", s);
                                        }, 0, !1);
                                    });
                                }
                                var o = i.$$parentForm, u = i.$name;
                                u && (Ot(e, null, u, i, u), r.$observe(r.name ? "name" : "ngForm", function(t) {
                                    u !== t && (Ot(e, null, u, n, u), u = t, Ot(e, null, u, i, u), o.$$renameControl(i, u));
                                })), a.on("$destroy", function() {
                                    o.$removeControl(i), u && Ot(e, null, u, n, u), d(i, xr);
                                });
                            }
                        };
                    }
                };
                return a;
            } ];
        }, Hr = Er(), jr = Er(!0), Ar = /\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z)/, Or = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/, Pr = /^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i, Ir = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/, Fr = /^(\d{4})-(\d{2})-(\d{2})$/, Nr = /^(\d{4})-(\d\d)-(\d\d)T(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, Ur = /^(\d{4})-W(\d\d)$/, Vr = /^(\d{4})-(\d\d)$/, Wr = /^(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, qr = {
            text: xn,
            date: jn("date", Fr, Hn(Fr, [ "yyyy", "MM", "dd" ]), "yyyy-MM-dd"),
            "datetime-local": jn("datetimelocal", Nr, Hn(Nr, [ "yyyy", "MM", "dd", "HH", "mm", "ss", "sss" ]), "yyyy-MM-ddTHH:mm:ss.sss"),
            time: jn("time", Wr, Hn(Wr, [ "HH", "mm", "ss", "sss" ]), "HH:mm:ss.sss"),
            week: jn("week", Ur, En, "yyyy-Www"),
            month: jn("month", Vr, Hn(Vr, [ "yyyy", "MM" ]), "yyyy-MM"),
            number: On,
            url: Pn,
            email: In,
            radio: Fn,
            checkbox: Un,
            hidden: p,
            button: p,
            submit: p,
            reset: p,
            file: p
        }, Rr = [ "$browser", "$sniffer", "$filter", "$parse", function(e, t, n, a) {
            return {
                restrict: "E",
                require: [ "?ngModel" ],
                link: {
                    pre: function(r, i, s, o) {
                        o[0] && (qr[Bn(s.type)] || qr.text)(r, i, s, o[0], t, e, n, a);
                    }
                }
            };
        } ], zr = /^(true|false|\d+)$/, Br = function() {
            return {
                restrict: "A",
                priority: 100,
                compile: function(e, t) {
                    return zr.test(t.ngValue) ? function(e, t, n) {
                        n.$set("value", e.$eval(n.ngValue));
                    } : function(e, t, n) {
                        e.$watch(n.ngValue, function(e) {
                            n.$set("value", e);
                        });
                    };
                }
            };
        }, Gr = [ "$compile", function(e) {
            return {
                restrict: "AC",
                compile: function(t) {
                    return e.$$addBindingClass(t), function(t, a, r) {
                        e.$$addBindingInfo(a, r.ngBind), a = a[0], t.$watch(r.ngBind, function(e) {
                            a.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], Jr = [ "$interpolate", "$compile", function(e, t) {
            return {
                compile: function(a) {
                    return t.$$addBindingClass(a), function(a, r, i) {
                        var s = e(r.attr(i.$attr.ngBindTemplate));
                        t.$$addBindingInfo(r, s.expressions), r = r[0], i.$observe("ngBindTemplate", function(e) {
                            r.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], Kr = [ "$sce", "$parse", "$compile", function(e, t, n) {
            return {
                restrict: "A",
                compile: function(a, r) {
                    var i = t(r.ngBindHtml), s = t(r.ngBindHtml, function(e) {
                        return (e || "").toString();
                    });
                    return n.$$addBindingClass(a), function(t, a, r) {
                        n.$$addBindingInfo(a, r.ngBindHtml), t.$watch(s, function() {
                            a.html(e.getTrustedHtml(i(t)) || "");
                        });
                    };
                }
            };
        } ], Zr = g({
            restrict: "A",
            require: "ngModel",
            link: function(e, t, n, a) {
                a.$viewChangeListeners.push(function() {
                    e.$eval(n.ngChange);
                });
            }
        }), Qr = Vn("", !0), Xr = Vn("Odd", 0), ei = Vn("Even", 1), ti = Dn({
            compile: function(e, t) {
                t.$set("ngCloak", n), e.removeClass("ng-cloak");
            }
        }), ni = [ function() {
            return {
                restrict: "A",
                scope: !0,
                controller: "@",
                priority: 500
            };
        } ], ai = {}, ri = {
            blur: !0,
            focus: !0
        };
        i("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "), function(e) {
            var t = Qe("ng-" + e);
            ai[t] = [ "$parse", "$rootScope", function(n, a) {
                return {
                    restrict: "A",
                    compile: function(r, i) {
                        var s = n(i[t], null, !0);
                        return function(t, n) {
                            n.on(e, function(n) {
                                var r = function() {
                                    s(t, {
                                        $event: n
                                    });
                                };
                                ri[e] && a.$$phase ? t.$evalAsync(r) : t.$apply(r);
                            });
                        };
                    }
                };
            } ];
        });
        var ii = [ "$animate", function(e) {
            return {
                multiElement: !0,
                transclude: "element",
                priority: 600,
                terminal: !0,
                restrict: "A",
                $$tlb: !0,
                link: function(n, a, r, i, s) {
                    var o, u, l;
                    n.$watch(r.ngIf, function(n) {
                        n ? u || s(function(n, i) {
                            u = i, n[n.length++] = t.createComment(" end ngIf: " + r.ngIf + " "), o = {
                                clone: n
                            }, e.enter(n, a.parent(), a);
                        }) : (l && (l.remove(), l = null), u && (u.$destroy(), u = null), o && (l = ue(o.clone), 
                        e.leave(l).then(function() {
                            l = null;
                        }), o = null));
                    });
                }
            };
        } ], si = [ "$templateRequest", "$anchorScroll", "$animate", "$sce", function(e, t, n, a) {
            return {
                restrict: "ECA",
                priority: 400,
                terminal: !0,
                transclude: "element",
                controller: oa.noop,
                compile: function(r, i) {
                    var s = i.ngInclude || i.src, o = i.onload || "", u = i.autoscroll;
                    return function(r, i, l, c, d) {
                        var m, f, p, h = 0, g = function() {
                            f && (f.remove(), f = null), m && (m.$destroy(), m = null), p && (n.leave(p).then(function() {
                                f = null;
                            }), f = p, p = null);
                        };
                        r.$watch(a.parseAsResourceUrl(s), function(a) {
                            var s = function() {
                                !v(u) || u && !r.$eval(u) || t();
                            }, l = ++h;
                            a ? (e(a, !0).then(function(e) {
                                if (l === h) {
                                    var t = r.$new();
                                    c.template = e;
                                    var u = d(t, function(e) {
                                        g(), n.enter(e, null, i).then(s);
                                    });
                                    m = t, p = u, m.$emit("$includeContentLoaded", a), r.$eval(o);
                                }
                            }, function() {
                                l === h && (g(), r.$emit("$includeContentError", a));
                            }), r.$emit("$includeContentRequested", a)) : (g(), c.template = null);
                        });
                    };
                }
            };
        } ], oi = [ "$compile", function(e) {
            return {
                restrict: "ECA",
                priority: -400,
                require: "ngInclude",
                link: function(n, a, r, i) {
                    return /SVG/.test(a[0].toString()) ? (a.empty(), void e(ve(i.template, t).childNodes)(n, function(e) {
                        a.append(e);
                    }, {
                        futureParentElement: a
                    })) : (a.html(i.template), void e(a.contents())(n));
                }
            };
        } ], ui = Dn({
            priority: 450,
            compile: function() {
                return {
                    pre: function(e, t, n) {
                        e.$eval(n.ngInit);
                    }
                };
            }
        }), li = function() {
            return {
                restrict: "A",
                priority: 100,
                require: "ngModel",
                link: function(e, t, a, r) {
                    var s = t.attr(a.$attr.ngList) || ", ", o = "false" !== a.ngTrim, u = o ? da(s) : s, l = function(e) {
                        if (!_(e)) {
                            var t = [];
                            return e && i(e.split(u), function(e) {
                                e && t.push(o ? da(e) : e);
                            }), t;
                        }
                    };
                    r.$parsers.push(l), r.$formatters.push(function(e) {
                        return ca(e) ? e.join(s) : n;
                    }), r.$isEmpty = function(e) {
                        return !e || !e.length;
                    };
                }
            };
        }, ci = "ng-valid", di = "ng-invalid", mi = "ng-pristine", fi = "ng-dirty", pi = "ng-untouched", hi = "ng-touched", gi = "ng-pending", _i = new a("ngModel"), vi = [ "$scope", "$exceptionHandler", "$attrs", "$element", "$parse", "$animate", "$timeout", "$rootScope", "$q", "$interpolate", function(e, t, a, r, s, o, u, l, c, d) {
            this.$viewValue = Number.NaN, this.$modelValue = Number.NaN, this.$$rawModelValue = n, 
            this.$validators = {}, this.$asyncValidators = {}, this.$parsers = [], this.$formatters = [], 
            this.$viewChangeListeners = [], this.$untouched = !0, this.$touched = !1, this.$pristine = !0, 
            this.$dirty = !1, this.$valid = !0, this.$invalid = !1, this.$error = {}, this.$$success = {}, 
            this.$pending = n, this.$name = d(a.name || "", !1)(e);
            var m, f = s(a.ngModel), h = f.assign, g = f, b = h, y = null, $ = this;
            this.$$setOptions = function(e) {
                if ($.$options = e, e && e.getterSetter) {
                    var t = s(a.ngModel + "()"), n = s(a.ngModel + "($$$p)");
                    g = function(e) {
                        var n = f(e);
                        return L(n) && (n = t(e)), n;
                    }, b = function(e, t) {
                        L(f(e)) ? n(e, {
                            $$$p: $.$modelValue
                        }) : h(e, $.$modelValue);
                    };
                } else if (!f.assign) throw _i("nonassign", "Expression '{0}' is non-assignable. Element: {1}", a.ngModel, R(r));
            }, this.$render = p, this.$isEmpty = function(e) {
                return _(e) || "" === e || null === e || e !== e;
            };
            var k = r.inheritedData("$formController") || xr, w = 0;
            Wn({
                ctrl: this,
                $element: r,
                set: function(e, t) {
                    e[t] = !0;
                },
                unset: function(e, t) {
                    delete e[t];
                },
                parentForm: k,
                $animate: o
            }), this.$setPristine = function() {
                $.$dirty = !1, $.$pristine = !0, o.removeClass(r, fi), o.addClass(r, mi);
            }, this.$setDirty = function() {
                $.$dirty = !0, $.$pristine = !1, o.removeClass(r, mi), o.addClass(r, fi), k.$setDirty();
            }, this.$setUntouched = function() {
                $.$touched = !1, $.$untouched = !0, o.setClass(r, pi, hi);
            }, this.$setTouched = function() {
                $.$touched = !0, $.$untouched = !1, o.setClass(r, hi, pi);
            }, this.$rollbackViewValue = function() {
                u.cancel(y), $.$viewValue = $.$$lastCommittedViewValue, $.$render();
            }, this.$validate = function() {
                if (!M($.$modelValue) || !isNaN($.$modelValue)) {
                    var e = $.$$lastCommittedViewValue, t = $.$$rawModelValue, a = $.$valid, r = $.$modelValue, i = $.$options && $.$options.allowInvalid;
                    $.$$runValidators(t, e, function(e) {
                        i || a === e || ($.$modelValue = e ? t : n, $.$modelValue !== r && $.$$writeModelToScope());
                    });
                }
            }, this.$$runValidators = function(e, t, a) {
                function r() {
                    var e = $.$$parserName || "parse";
                    return m !== n ? (m || (i($.$validators, function(e, t) {
                        u(t, null);
                    }), i($.$asyncValidators, function(e, t) {
                        u(t, null);
                    })), u(e, m), m) : (u(e, null), !0);
                }
                function s() {
                    var n = !0;
                    return i($.$validators, function(a, r) {
                        var i = a(e, t);
                        n = n && i, u(r, i);
                    }), !!n || (i($.$asyncValidators, function(e, t) {
                        u(t, null);
                    }), !1);
                }
                function o() {
                    var a = [], r = !0;
                    i($.$asyncValidators, function(i, s) {
                        var o = i(e, t);
                        if (!C(o)) throw _i("$asyncValidators", "Expected asynchronous validator to return a promise but got '{0}' instead.", o);
                        u(s, n), a.push(o.then(function() {
                            u(s, !0);
                        }, function(e) {
                            r = !1, u(s, !1);
                        }));
                    }), a.length ? c.all(a).then(function() {
                        l(r);
                    }, p) : l(!0);
                }
                function u(e, t) {
                    d === w && $.$setValidity(e, t);
                }
                function l(e) {
                    d === w && a(e);
                }
                w++;
                var d = w;
                return r() && s() ? void o() : void l(!1);
            }, this.$commitViewValue = function() {
                var e = $.$viewValue;
                u.cancel(y), ($.$$lastCommittedViewValue !== e || "" === e && $.$$hasNativeValidators) && ($.$$lastCommittedViewValue = e, 
                $.$pristine && this.$setDirty(), this.$$parseAndValidate());
            }, this.$$parseAndValidate = function() {
                function t() {
                    $.$modelValue !== s && $.$$writeModelToScope();
                }
                var a = $.$$lastCommittedViewValue, r = a;
                if (m = !_(r) || n) for (var i = 0; i < $.$parsers.length; i++) if (r = $.$parsers[i](r), 
                _(r)) {
                    m = !1;
                    break;
                }
                M($.$modelValue) && isNaN($.$modelValue) && ($.$modelValue = g(e));
                var s = $.$modelValue, o = $.$options && $.$options.allowInvalid;
                $.$$rawModelValue = r, o && ($.$modelValue = r, t()), $.$$runValidators(r, $.$$lastCommittedViewValue, function(e) {
                    o || ($.$modelValue = e ? r : n, t());
                });
            }, this.$$writeModelToScope = function() {
                b(e, $.$modelValue), i($.$viewChangeListeners, function(e) {
                    try {
                        e();
                    } catch (e) {
                        t(e);
                    }
                });
            }, this.$setViewValue = function(e, t) {
                $.$viewValue = e, $.$options && !$.$options.updateOnDefault || $.$$debounceViewValueCommit(t);
            }, this.$$debounceViewValueCommit = function(t) {
                var n, a = 0, r = $.$options;
                r && v(r.debounce) && (n = r.debounce, M(n) ? a = n : M(n[t]) ? a = n[t] : M(n.default) && (a = n.default)), 
                u.cancel(y), a ? y = u(function() {
                    $.$commitViewValue();
                }, a) : l.$$phase ? $.$commitViewValue() : e.$apply(function() {
                    $.$commitViewValue();
                });
            }, e.$watch(function() {
                var t = g(e);
                if (t !== $.$modelValue) {
                    $.$modelValue = $.$$rawModelValue = t, m = n;
                    for (var a = $.$formatters, r = a.length, i = t; r--; ) i = a[r](i);
                    $.$viewValue !== i && ($.$viewValue = $.$$lastCommittedViewValue = i, $.$render(), 
                    $.$$runValidators(t, i, p));
                }
                return t;
            });
        } ], bi = [ "$rootScope", function(e) {
            return {
                restrict: "A",
                require: [ "ngModel", "^?form", "^?ngModelOptions" ],
                controller: vi,
                priority: 1,
                compile: function(t) {
                    return t.addClass(mi).addClass(pi).addClass(ci), {
                        pre: function(e, t, n, a) {
                            var r = a[0], i = a[1] || xr;
                            r.$$setOptions(a[2] && a[2].$options), i.$addControl(r), n.$observe("name", function(e) {
                                r.$name !== e && i.$$renameControl(r, e);
                            }), e.$on("$destroy", function() {
                                i.$removeControl(r);
                            });
                        },
                        post: function(t, n, a, r) {
                            var i = r[0];
                            i.$options && i.$options.updateOn && n.on(i.$options.updateOn, function(e) {
                                i.$$debounceViewValueCommit(e && e.type);
                            }), n.on("blur", function(n) {
                                i.$touched || (e.$$phase ? t.$evalAsync(i.$setTouched) : t.$apply(i.$setTouched));
                            });
                        }
                    };
                }
            };
        } ], yi = /(\s+|^)default(\s+|$)/, Mi = function() {
            return {
                restrict: "A",
                controller: [ "$scope", "$attrs", function(e, t) {
                    var a = this;
                    this.$options = e.$eval(t.ngModelOptions), this.$options.updateOn !== n ? (this.$options.updateOnDefault = !1, 
                    this.$options.updateOn = da(this.$options.updateOn.replace(yi, function() {
                        return a.$options.updateOnDefault = !0, " ";
                    }))) : this.$options.updateOnDefault = !0;
                } ]
            };
        }, $i = Dn({
            terminal: !0,
            priority: 1e3
        }), Li = [ "$locale", "$interpolate", function(e, t) {
            var n = /{}/g, a = /^when(Minus)?(.+)$/;
            return {
                restrict: "EA",
                link: function(r, s, o) {
                    function u(e) {
                        s.text(e || "");
                    }
                    var l, c = o.count, d = o.$attr.when && s.attr(o.$attr.when), m = o.offset || 0, f = r.$eval(d) || {}, p = {}, h = t.startSymbol(), g = t.endSymbol(), _ = h + c + "-" + m + g, v = oa.noop;
                    i(o, function(e, t) {
                        var n = a.exec(t);
                        if (n) {
                            var r = (n[1] ? "-" : "") + Bn(n[2]);
                            f[r] = s.attr(o.$attr[t]);
                        }
                    }), i(f, function(e, a) {
                        p[a] = t(e.replace(n, _));
                    }), r.$watch(c, function(t) {
                        var n = parseFloat(t), a = isNaN(n);
                        a || n in f || (n = e.pluralCat(n - m)), n === l || a && isNaN(l) || (v(), v = r.$watch(p[n], u), 
                        l = n);
                    });
                }
            };
        } ], ki = [ "$parse", "$animate", function(e, s) {
            var o = "$$NG_REMOVED", u = a("ngRepeat"), l = function(e, t, n, a, r, i, s) {
                e[n] = a, r && (e[r] = i), e.$index = t, e.$first = 0 === t, e.$last = t === s - 1, 
                e.$middle = !(e.$first || e.$last), e.$odd = !(e.$even = 0 === (1 & t));
            }, c = function(e) {
                return e.clone[0];
            }, d = function(e) {
                return e.clone[e.clone.length - 1];
            };
            return {
                restrict: "A",
                multiElement: !0,
                transclude: "element",
                priority: 1e3,
                terminal: !0,
                $$tlb: !0,
                compile: function(a, m) {
                    var f = m.ngRepeat, p = t.createComment(" end ngRepeat: " + f + " "), h = f.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);
                    if (!h) throw u("iexp", "Expected expression in form of '_item_ in _collection_[ track by _id_]' but got '{0}'.", f);
                    var g = h[1], _ = h[2], v = h[3], b = h[4];
                    if (h = g.match(/^(?:(\s*[\$\w]+)|\(\s*([\$\w]+)\s*,\s*([\$\w]+)\s*\))$/), !h) throw u("iidexp", "'_item_' in '_item_ in _collection_' should be an identifier or '(_key_, _value_)' expression, but got '{0}'.", g);
                    var y = h[3] || h[1], M = h[2];
                    if (v && (!/^[$a-zA-Z_][$a-zA-Z0-9_]*$/.test(v) || /^(null|undefined|this|\$index|\$first|\$middle|\$last|\$even|\$odd|\$parent|\$root|\$id)$/.test(v))) throw u("badident", "alias '{0}' is invalid --- must be a valid JS identifier which is not a reserved name.", v);
                    var $, L, k, w, D = {
                        $id: Ne
                    };
                    return b ? $ = e(b) : (k = function(e, t) {
                        return Ne(t);
                    }, w = function(e) {
                        return e;
                    }), function(e, t, a, m, h) {
                        $ && (L = function(t, n, a) {
                            return M && (D[M] = t), D[y] = n, D.$index = a, $(e, D);
                        });
                        var g = le();
                        e.$watchCollection(_, function(a) {
                            var m, _, b, $, D, Y, T, S, x, C, E, H, j = t[0], A = le();
                            if (v && (e[v] = a), r(a)) x = a, S = L || k; else {
                                S = L || w, x = [];
                                for (var O in a) a.hasOwnProperty(O) && "$" != O.charAt(0) && x.push(O);
                                x.sort();
                            }
                            for ($ = x.length, E = new Array($), m = 0; m < $; m++) if (D = a === x ? m : x[m], 
                            Y = a[D], T = S(D, Y, m), g[T]) C = g[T], delete g[T], A[T] = C, E[m] = C; else {
                                if (A[T]) throw i(E, function(e) {
                                    e && e.scope && (g[e.id] = e);
                                }), u("dupes", "Duplicates in a repeater are not allowed. Use 'track by' expression to specify unique keys. Repeater: {0}, Duplicate key: {1}, Duplicate value: {2}", f, T, Y);
                                E[m] = {
                                    id: T,
                                    scope: n,
                                    clone: n
                                }, A[T] = !0;
                            }
                            for (var P in g) {
                                if (C = g[P], H = ue(C.clone), s.leave(H), H[0].parentNode) for (m = 0, _ = H.length; m < _; m++) H[m][o] = !0;
                                C.scope.$destroy();
                            }
                            for (m = 0; m < $; m++) if (D = a === x ? m : x[m], Y = a[D], C = E[m], C.scope) {
                                b = j;
                                do b = b.nextSibling; while (b && b[o]);
                                c(C) != b && s.move(ue(C.clone), null, Xn(j)), j = d(C), l(C.scope, m, y, Y, M, D, $);
                            } else h(function(e, t) {
                                C.scope = t;
                                var n = p.cloneNode(!1);
                                e[e.length++] = n, s.enter(e, null, Xn(j)), j = n, C.clone = e, A[C.id] = C, l(C.scope, m, y, Y, M, D, $);
                            });
                            g = A;
                        });
                    };
                }
            };
        } ], wi = "ng-hide", Di = "ng-hide-animate", Yi = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngShow, function(t) {
                        e[t ? "removeClass" : "addClass"](n, wi, {
                            tempClasses: Di
                        });
                    });
                }
            };
        } ], Ti = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngHide, function(t) {
                        e[t ? "addClass" : "removeClass"](n, wi, {
                            tempClasses: Di
                        });
                    });
                }
            };
        } ], Si = Dn(function(e, t, n) {
            e.$watchCollection(n.ngStyle, function(e, n) {
                n && e !== n && i(n, function(e, n) {
                    t.css(n, "");
                }), e && t.css(e);
            });
        }), xi = [ "$animate", function(e) {
            return {
                restrict: "EA",
                require: "ngSwitch",
                controller: [ "$scope", function() {
                    this.cases = {};
                } ],
                link: function(n, a, r, s) {
                    var o = r.ngSwitch || r.on, u = [], l = [], c = [], d = [], m = function(e, t) {
                        return function() {
                            e.splice(t, 1);
                        };
                    };
                    n.$watch(o, function(n) {
                        var a, r;
                        for (a = 0, r = c.length; a < r; ++a) e.cancel(c[a]);
                        for (c.length = 0, a = 0, r = d.length; a < r; ++a) {
                            var o = ue(l[a].clone);
                            d[a].$destroy();
                            var f = c[a] = e.leave(o);
                            f.then(m(c, a));
                        }
                        l.length = 0, d.length = 0, (u = s.cases["!" + n] || s.cases["?"]) && i(u, function(n) {
                            n.transclude(function(a, r) {
                                d.push(r);
                                var i = n.element;
                                a[a.length++] = t.createComment(" end ngSwitchWhen: ");
                                var s = {
                                    clone: a
                                };
                                l.push(s), e.enter(a, i.parent(), i);
                            });
                        });
                    });
                }
            };
        } ], Ci = Dn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, r) {
                a.cases["!" + n.ngSwitchWhen] = a.cases["!" + n.ngSwitchWhen] || [], a.cases["!" + n.ngSwitchWhen].push({
                    transclude: r,
                    element: t
                });
            }
        }), Ei = Dn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, r) {
                a.cases["?"] = a.cases["?"] || [], a.cases["?"].push({
                    transclude: r,
                    element: t
                });
            }
        }), Hi = Dn({
            restrict: "EAC",
            link: function(e, t, n, r, i) {
                if (!i) throw a("ngTransclude")("orphan", "Illegal use of ngTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}", R(t));
                i(function(e) {
                    t.empty(), t.append(e);
                });
            }
        }), ji = [ "$templateCache", function(e) {
            return {
                restrict: "E",
                terminal: !0,
                compile: function(t, n) {
                    if ("text/ng-template" == n.type) {
                        var a = n.id, r = t[0].text;
                        e.put(a, r);
                    }
                }
            };
        } ], Ai = a("ngOptions"), Oi = g({
            restrict: "A",
            terminal: !0
        }), Pi = [ "$compile", "$parse", function(e, a) {
            var r = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/, o = {
                $setViewValue: p
            };
            return {
                restrict: "E",
                require: [ "select", "?ngModel" ],
                controller: [ "$element", "$scope", "$attrs", function(e, t, n) {
                    var a, r, i = this, s = {}, u = o;
                    i.databound = n.ngModel, i.init = function(e, t, n) {
                        u = e, a = t, r = n;
                    }, i.addOption = function(t, n) {
                        se(t, '"option value"'), s[t] = !0, u.$viewValue == t && (e.val(t), r.parent() && r.remove()), 
                        n && n[0].hasAttribute("selected") && (n[0].selected = !0);
                    }, i.removeOption = function(e) {
                        this.hasOption(e) && (delete s[e], u.$viewValue === e && this.renderUnknownOption(e));
                    }, i.renderUnknownOption = function(t) {
                        var n = "? " + Ne(t) + " ?";
                        r.val(n), e.prepend(r), e.val(n), r.prop("selected", !0);
                    }, i.hasOption = function(e) {
                        return s.hasOwnProperty(e);
                    }, t.$on("$destroy", function() {
                        i.renderUnknownOption = p;
                    });
                } ],
                link: function(o, u, l, c) {
                    function d(e, t, n, a) {
                        n.$render = function() {
                            var e = n.$viewValue;
                            a.hasOption(e) ? (w.parent() && w.remove(), t.val(e), "" === e && p.prop("selected", !0)) : _(e) && p ? t.val("") : a.renderUnknownOption(e);
                        }, t.on("change", function() {
                            e.$apply(function() {
                                w.parent() && w.remove(), n.$setViewValue(t.val());
                            });
                        });
                    }
                    function m(e, t, n) {
                        var a;
                        n.$render = function() {
                            var e = new Ue(n.$viewValue);
                            i(t.find("option"), function(t) {
                                t.selected = v(e.get(t.value));
                            });
                        }, e.$watch(function() {
                            I(a, n.$viewValue) || (a = P(n.$viewValue), n.$render());
                        }), t.on("change", function() {
                            e.$apply(function() {
                                var e = [];
                                i(t.find("option"), function(t) {
                                    t.selected && e.push(t.value);
                                }), n.$setViewValue(e);
                            });
                        });
                    }
                    function f(t, o, u) {
                        function l(e, n, a) {
                            return I[Y] = a, x && (I[x] = n), e(t, I);
                        }
                        function c() {
                            t.$apply(function() {
                                var e, n = H(t) || [];
                                if (b) e = [], i(o.val(), function(t) {
                                    t = A ? O[t] : t, e.push(d(t, n[t]));
                                }); else {
                                    var a = A ? O[o.val()] : o.val();
                                    e = d(a, n[a]);
                                }
                                u.$setViewValue(e), _();
                            });
                        }
                        function d(e, t) {
                            if ("?" === e) return n;
                            if ("" === e) return null;
                            var a = S ? S : E;
                            return l(a, e, t);
                        }
                        function m() {
                            var e, n = H(t);
                            if (n && ca(n)) {
                                e = new Array(n.length);
                                for (var a = 0, r = n.length; a < r; a++) e[a] = l(D, a, n[a]);
                                return e;
                            }
                            if (n) {
                                e = {};
                                for (var i in n) n.hasOwnProperty(i) && (e[i] = l(D, i, n[i]));
                            }
                            return e;
                        }
                        function f(e) {
                            var t;
                            if (b) if (A && ca(e)) {
                                t = new Ue([]);
                                for (var n = 0; n < e.length; n++) t.put(l(A, null, e[n]), !0);
                            } else t = new Ue(e); else A && (e = l(A, null, e));
                            return function(n, a) {
                                var r;
                                return r = A ? A : S ? S : E, b ? v(t.remove(l(r, n, a))) : e === l(r, n, a);
                            };
                        }
                        function p() {
                            $ || (t.$$postDigest(_), $ = !0);
                        }
                        function g(e, t, n) {
                            e[t] = e[t] || 0, e[t] += n ? 1 : -1;
                        }
                        function _() {
                            $ = !1;
                            var e, n, a, r, c, d, m, p, _, y, w, Y, T, S, E, j, F, N = {
                                "": []
                            }, U = [ "" ], V = u.$viewValue, W = H(t) || [], q = x ? s(W) : W, R = {}, z = f(V), B = !1;
                            for (O = {}, Y = 0; y = q.length, Y < y; Y++) m = Y, x && (m = q[Y], "$" === m.charAt(0)) || (p = W[m], 
                            e = l(C, m, p) || "", (n = N[e]) || (n = N[e] = [], U.push(e)), T = z(m, p), B = B || T, 
                            j = l(D, m, p), j = v(j) ? j : "", F = A ? A(t, I) : x ? q[Y] : Y, A && (O[F] = m), 
                            n.push({
                                id: F,
                                label: j,
                                selected: T
                            }));
                            for (b || (M || null === V ? N[""].unshift({
                                id: "",
                                label: "",
                                selected: !B
                            }) : B || N[""].unshift({
                                id: "?",
                                label: "",
                                selected: !0
                            })), w = 0, _ = U.length; w < _; w++) {
                                for (e = U[w], n = N[e], P.length <= w ? (r = {
                                    element: k.clone().attr("label", e),
                                    label: n.label
                                }, c = [ r ], P.push(c), o.append(r.element)) : (c = P[w], r = c[0], r.label != e && r.element.attr("label", r.label = e)), 
                                S = null, Y = 0, y = n.length; Y < y; Y++) a = n[Y], (d = c[Y + 1]) ? (S = d.element, 
                                d.label !== a.label && (g(R, d.label, !1), g(R, a.label, !0), S.text(d.label = a.label), 
                                S.prop("label", d.label)), d.id !== a.id && S.val(d.id = a.id), S[0].selected !== a.selected && (S.prop("selected", d.selected = a.selected), 
                                Qn && S.prop("selected", d.selected))) : ("" === a.id && M ? E = M : (E = L.clone()).val(a.id).prop("selected", a.selected).attr("selected", a.selected).prop("label", a.label).text(a.label), 
                                c.push(d = {
                                    element: E,
                                    label: a.label,
                                    id: a.id,
                                    selected: a.selected
                                }), g(R, a.label, !0), S ? S.after(E) : r.element.append(E), S = E);
                                for (Y++; c.length > Y; ) a = c.pop(), g(R, a.label, !1), a.element.remove();
                            }
                            for (;P.length > w; ) {
                                for (n = P.pop(), Y = 1; Y < n.length; ++Y) g(R, n[Y].label, !1);
                                n[0].element.remove();
                            }
                            i(R, function(e, t) {
                                e > 0 ? h.addOption(t) : e < 0 && h.removeOption(t);
                            });
                        }
                        var w;
                        if (!(w = y.match(r))) throw Ai("iexp", "Expected expression in form of '_select_ (as _label_)? for (_key_,)?_value_ in _collection_' but got '{0}'. Element: {1}", y, R(o));
                        var D = a(w[2] || w[1]), Y = w[4] || w[6], T = / as /.test(w[0]) && w[1], S = T ? a(T) : null, x = w[5], C = a(w[3] || ""), E = a(w[2] ? w[1] : Y), H = a(w[7]), j = w[8], A = j ? a(w[8]) : null, O = {}, P = [ [ {
                            element: o,
                            label: ""
                        } ] ], I = {};
                        M && (e(M)(t), M.removeClass("ng-scope"), M.remove()), o.empty(), o.on("change", c), 
                        u.$render = _, t.$watchCollection(H, p), t.$watchCollection(m, p), b && t.$watchCollection(function() {
                            return u.$modelValue;
                        }, p);
                    }
                    if (c[1]) {
                        for (var p, h = c[0], g = c[1], b = l.multiple, y = l.ngOptions, M = !1, $ = !1, L = Xn(t.createElement("option")), k = Xn(t.createElement("optgroup")), w = L.clone(), D = 0, Y = u.children(), T = Y.length; D < T; D++) if ("" === Y[D].value) {
                            p = M = Y.eq(D);
                            break;
                        }
                        h.init(g, M, w), b && (g.$isEmpty = function(e) {
                            return !e || 0 === e.length;
                        }), y ? f(o, u, g) : b ? m(o, u, g) : d(o, u, g, h);
                    }
                }
            };
        } ], Ii = [ "$interpolate", function(e) {
            var t = {
                addOption: p,
                removeOption: p
            };
            return {
                restrict: "E",
                priority: 100,
                compile: function(n, a) {
                    if (_(a.value)) {
                        var r = e(n.text(), !0);
                        r || a.$set("value", n.text());
                    }
                    return function(e, n, a) {
                        var i = "$selectController", s = n.parent(), o = s.data(i) || s.parent().data(i);
                        o && o.databound || (o = t), r ? e.$watch(r, function(e, t) {
                            a.$set("value", e), t !== e && o.removeOption(t), o.addOption(e, n);
                        }) : o.addOption(a.value, n), n.on("$destroy", function() {
                            o.removeOption(a.value);
                        });
                    };
                }
            };
        } ], Fi = g({
            restrict: "E",
            terminal: !1
        }), Ni = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    a && (n.required = !0, a.$validators.required = function(e, t) {
                        return !n.required || !a.$isEmpty(t);
                    }, n.$observe("required", function() {
                        a.$validate();
                    }));
                }
            };
        }, Ui = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, r, i) {
                    if (i) {
                        var s, o = r.ngPattern || r.pattern;
                        r.$observe("pattern", function(e) {
                            if (y(e) && e.length > 0 && (e = new RegExp("^" + e + "$")), e && !e.test) throw a("ngPattern")("noregexp", "Expected {0} to be a RegExp but was {1}. Element: {2}", o, e, R(t));
                            s = e || n, i.$validate();
                        }), i.$validators.pattern = function(e) {
                            return i.$isEmpty(e) || _(s) || s.test(e);
                        };
                    }
                }
            };
        }, Vi = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var r = -1;
                        n.$observe("maxlength", function(e) {
                            var t = m(e);
                            r = isNaN(t) ? -1 : t, a.$validate();
                        }), a.$validators.maxlength = function(e, t) {
                            return r < 0 || a.$isEmpty(t) || t.length <= r;
                        };
                    }
                }
            };
        }, Wi = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var r = 0;
                        n.$observe("minlength", function(e) {
                            r = m(e) || 0, a.$validate();
                        }), a.$validators.minlength = function(e, t) {
                            return a.$isEmpty(t) || t.length >= r;
                        };
                    }
                }
            };
        };
        return e.angular.bootstrap ? void console.log("WARNING: Tried to load angular more than once.") : (ae(), 
        fe(oa), void Xn(t).ready(function() {
            Q(t, X);
        }));
    }(window, document), !window.angular.$$csp() && window.angular.element(document).find("head").prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide:not(.ng-hide-animate){display:none !important;}ng\\:form{display:block;}</style>'), 
    e.exports = angular;
}, function(e, t) {
    /**
	 * @license AngularJS v1.3.14
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a() {
            function e(e, n) {
                return t.extend(Object.create(e), n);
            }
            function n(e, t) {
                var n = t.caseInsensitiveMatch, a = {
                    originalPath: e,
                    regexp: e
                }, r = a.keys = [];
                return e = e.replace(/([().])/g, "\\$1").replace(/(\/)?:(\w+)([\?\*])?/g, function(e, t, n, a) {
                    var i = "?" === a ? a : null, s = "*" === a ? a : null;
                    return r.push({
                        name: n,
                        optional: !!i
                    }), t = t || "", "" + (i ? "" : t) + "(?:" + (i ? t : "") + (s && "(.+?)" || "([^/]+)") + (i || "") + ")" + (i || "");
                }).replace(/([\/$\*])/g, "\\$1"), a.regexp = new RegExp("^" + e + "$", n ? "i" : ""), 
                a;
            }
            var a = {};
            this.when = function(e, r) {
                var i = t.copy(r);
                if (t.isUndefined(i.reloadOnSearch) && (i.reloadOnSearch = !0), t.isUndefined(i.caseInsensitiveMatch) && (i.caseInsensitiveMatch = this.caseInsensitiveMatch), 
                a[e] = t.extend(i, e && n(e, i)), e) {
                    var s = "/" == e[e.length - 1] ? e.substr(0, e.length - 1) : e + "/";
                    a[s] = t.extend({
                        redirectTo: e
                    }, n(s, i));
                }
                return this;
            }, this.caseInsensitiveMatch = !1, this.otherwise = function(e) {
                return "string" == typeof e && (e = {
                    redirectTo: e
                }), this.when(null, e), this;
            }, this.$get = [ "$rootScope", "$location", "$routeParams", "$q", "$injector", "$templateRequest", "$sce", function(n, r, i, s, o, l, c) {
                function d(e, t) {
                    var n = t.keys, a = {};
                    if (!t.regexp) return null;
                    var r = t.regexp.exec(e);
                    if (!r) return null;
                    for (var i = 1, s = r.length; i < s; ++i) {
                        var o = n[i - 1], u = r[i];
                        o && u && (a[o.name] = u);
                    }
                    return a;
                }
                function m(e) {
                    var a = b.current;
                    g = p(), _ = g && a && g.$$route === a.$$route && t.equals(g.pathParams, a.pathParams) && !g.reloadOnSearch && !v, 
                    _ || !a && !g || n.$broadcast("$routeChangeStart", g, a).defaultPrevented && e && e.preventDefault();
                }
                function f() {
                    var e = b.current, a = g;
                    _ ? (e.params = a.params, t.copy(e.params, i), n.$broadcast("$routeUpdate", e)) : (a || e) && (v = !1, 
                    b.current = a, a && a.redirectTo && (t.isString(a.redirectTo) ? r.path(h(a.redirectTo, a.params)).search(a.params).replace() : r.url(a.redirectTo(a.pathParams, r.path(), r.search())).replace()), 
                    s.when(a).then(function() {
                        if (a) {
                            var e, n, r = t.extend({}, a.resolve);
                            return t.forEach(r, function(e, n) {
                                r[n] = t.isString(e) ? o.get(e) : o.invoke(e, null, null, n);
                            }), t.isDefined(e = a.template) ? t.isFunction(e) && (e = e(a.params)) : t.isDefined(n = a.templateUrl) && (t.isFunction(n) && (n = n(a.params)), 
                            n = c.getTrustedResourceUrl(n), t.isDefined(n) && (a.loadedTemplateUrl = n, e = l(n))), 
                            t.isDefined(e) && (r.$template = e), s.all(r);
                        }
                    }).then(function(r) {
                        a == b.current && (a && (a.locals = r, t.copy(a.params, i)), n.$broadcast("$routeChangeSuccess", a, e));
                    }, function(t) {
                        a == b.current && n.$broadcast("$routeChangeError", a, e, t);
                    }));
                }
                function p() {
                    var n, i;
                    return t.forEach(a, function(a, s) {
                        !i && (n = d(r.path(), a)) && (i = e(a, {
                            params: t.extend({}, r.search(), n),
                            pathParams: n
                        }), i.$$route = a);
                    }), i || a[null] && e(a[null], {
                        params: {},
                        pathParams: {}
                    });
                }
                function h(e, n) {
                    var a = [];
                    return t.forEach((e || "").split(":"), function(e, t) {
                        if (0 === t) a.push(e); else {
                            var r = e.match(/(\w+)(?:[?*])?(.*)/), i = r[1];
                            a.push(n[i]), a.push(r[2] || ""), delete n[i];
                        }
                    }), a.join("");
                }
                var g, _, v = !1, b = {
                    routes: a,
                    reload: function() {
                        v = !0, n.$evalAsync(function() {
                            m(), f();
                        });
                    },
                    updateParams: function(e) {
                        if (!this.current || !this.current.$$route) throw u("norout", "Tried updating route when with no current route");
                        e = t.extend({}, this.current.params, e), r.path(h(this.current.$$route.originalPath, e)), 
                        r.search(e);
                    }
                };
                return n.$on("$locationChangeStart", m), n.$on("$locationChangeSuccess", f), b;
            } ];
        }
        function r() {
            this.$get = function() {
                return {};
            };
        }
        function i(e, n, a) {
            return {
                restrict: "ECA",
                terminal: !0,
                priority: 400,
                transclude: "element",
                link: function(r, i, s, o, u) {
                    function l() {
                        f && (a.cancel(f), f = null), d && (d.$destroy(), d = null), m && (f = a.leave(m), 
                        f.then(function() {
                            f = null;
                        }), m = null);
                    }
                    function c() {
                        var s = e.current && e.current.locals, o = s && s.$template;
                        if (t.isDefined(o)) {
                            var c = r.$new(), f = e.current, g = u(c, function(e) {
                                a.enter(e, null, m || i).then(function() {
                                    !t.isDefined(p) || p && !r.$eval(p) || n();
                                }), l();
                            });
                            m = g, d = f.scope = c, d.$emit("$viewContentLoaded"), d.$eval(h);
                        } else l();
                    }
                    var d, m, f, p = s.autoscroll, h = s.onload || "";
                    r.$on("$routeChangeSuccess", c), c();
                }
            };
        }
        function s(e, t, n) {
            return {
                restrict: "ECA",
                priority: -400,
                link: function(a, r) {
                    var i = n.current, s = i.locals;
                    r.html(s.$template);
                    var o = e(r.contents());
                    if (i.controller) {
                        s.$scope = a;
                        var u = t(i.controller, s);
                        i.controllerAs && (a[i.controllerAs] = u), r.data("$ngControllerController", u), 
                        r.children().data("$ngControllerController", u);
                    }
                    o(a);
                }
            };
        }
        var o = t.module("ngRoute", [ "ng" ]).provider("$route", a), u = t.$$minErr("ngRoute");
        o.provider("$routeParams", r), o.directive("ngView", i), o.directive("ngView", s), 
        i.$inject = [ "$route", "$anchorScroll", "$animate" ], s.$inject = [ "$compile", "$controller", "$route" ];
    }(window, window.angular);
}, , function(e, t) {
    angular.module("ui.bootstrap", [ "ui.bootstrap.collapse", "ui.bootstrap.accordion", "ui.bootstrap.alert", "ui.bootstrap.bindHtml", "ui.bootstrap.buttons", "ui.bootstrap.carousel", "ui.bootstrap.dateparser", "ui.bootstrap.position", "ui.bootstrap.datepicker", "ui.bootstrap.dropdown", "ui.bootstrap.modal", "ui.bootstrap.pagination", "ui.bootstrap.tooltip", "ui.bootstrap.popover", "ui.bootstrap.progressbar", "ui.bootstrap.rating", "ui.bootstrap.tabs", "ui.bootstrap.timepicker", "ui.bootstrap.transition", "ui.bootstrap.typeahead" ]), 
    angular.module("ui.bootstrap.collapse", []).directive("collapse", [ "$animate", function(e) {
        return {
            link: function(t, n, a) {
                function r() {
                    n.removeClass("collapse").addClass("collapsing"), e.addClass(n, "in", {
                        to: {
                            height: n[0].scrollHeight + "px"
                        }
                    }).then(i);
                }
                function i() {
                    n.removeClass("collapsing"), n.css({
                        height: "auto"
                    });
                }
                function s() {
                    n.css({
                        height: n[0].scrollHeight + "px"
                    }).removeClass("collapse").addClass("collapsing"), e.removeClass(n, "in", {
                        to: {
                            height: "0"
                        }
                    }).then(o);
                }
                function o() {
                    n.css({
                        height: "0"
                    }), n.removeClass("collapsing"), n.addClass("collapse");
                }
                t.$watch(a.collapse, function(e) {
                    e ? s() : r();
                });
            }
        };
    } ]), angular.module("ui.bootstrap.accordion", [ "ui.bootstrap.collapse" ]).constant("accordionConfig", {
        closeOthers: !0
    }).controller("AccordionController", [ "$scope", "$attrs", "accordionConfig", function(e, t, n) {
        this.groups = [], this.closeOthers = function(a) {
            var r = angular.isDefined(t.closeOthers) ? e.$eval(t.closeOthers) : n.closeOthers;
            r && angular.forEach(this.groups, function(e) {
                e !== a && (e.isOpen = !1);
            });
        }, this.addGroup = function(e) {
            var t = this;
            this.groups.push(e), e.$on("$destroy", function(n) {
                t.removeGroup(e);
            });
        }, this.removeGroup = function(e) {
            var t = this.groups.indexOf(e);
            t !== -1 && this.groups.splice(t, 1);
        };
    } ]).directive("accordion", function() {
        return {
            restrict: "EA",
            controller: "AccordionController",
            transclude: !0,
            replace: !1,
            templateUrl: "template/accordion/accordion.html"
        };
    }).directive("accordionGroup", function() {
        return {
            require: "^accordion",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: "template/accordion/accordion-group.html",
            scope: {
                heading: "@",
                isOpen: "=?",
                isDisabled: "=?"
            },
            controller: function() {
                this.setHeading = function(e) {
                    this.heading = e;
                };
            },
            link: function(e, t, n, a) {
                a.addGroup(e), e.$watch("isOpen", function(t) {
                    t && a.closeOthers(e);
                }), e.toggleOpen = function() {
                    e.isDisabled || (e.isOpen = !e.isOpen);
                };
            }
        };
    }).directive("accordionHeading", function() {
        return {
            restrict: "EA",
            transclude: !0,
            template: "",
            replace: !0,
            require: "^accordionGroup",
            link: function(e, t, n, a, r) {
                a.setHeading(r(e, angular.noop));
            }
        };
    }).directive("accordionTransclude", function() {
        return {
            require: "^accordionGroup",
            link: function(e, t, n, a) {
                e.$watch(function() {
                    return a[n.accordionTransclude];
                }, function(e) {
                    e && (t.html(""), t.append(e));
                });
            }
        };
    }), angular.module("ui.bootstrap.alert", []).controller("AlertController", [ "$scope", "$attrs", function(e, t) {
        e.closeable = "close" in t, this.close = e.close;
    } ]).directive("alert", function() {
        return {
            restrict: "EA",
            controller: "AlertController",
            templateUrl: "template/alert/alert.html",
            transclude: !0,
            replace: !0,
            scope: {
                type: "@",
                close: "&"
            }
        };
    }).directive("dismissOnTimeout", [ "$timeout", function(e) {
        return {
            require: "alert",
            link: function(t, n, a, r) {
                e(function() {
                    r.close();
                }, parseInt(a.dismissOnTimeout, 10));
            }
        };
    } ]), angular.module("ui.bootstrap.bindHtml", []).directive("bindHtmlUnsafe", function() {
        return function(e, t, n) {
            t.addClass("ng-binding").data("$binding", n.bindHtmlUnsafe), e.$watch(n.bindHtmlUnsafe, function(e) {
                t.html(e || "");
            });
        };
    }), angular.module("ui.bootstrap.buttons", []).constant("buttonConfig", {
        activeClass: "active",
        toggleEvent: "click"
    }).controller("ButtonsController", [ "buttonConfig", function(e) {
        this.activeClass = e.activeClass || "active", this.toggleEvent = e.toggleEvent || "click";
    } ]).directive("btnRadio", function() {
        return {
            require: [ "btnRadio", "ngModel" ],
            controller: "ButtonsController",
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                i.$render = function() {
                    t.toggleClass(r.activeClass, angular.equals(i.$modelValue, e.$eval(n.btnRadio)));
                }, t.bind(r.toggleEvent, function() {
                    var a = t.hasClass(r.activeClass);
                    a && !angular.isDefined(n.uncheckable) || e.$apply(function() {
                        i.$setViewValue(a ? null : e.$eval(n.btnRadio)), i.$render();
                    });
                });
            }
        };
    }).directive("btnCheckbox", function() {
        return {
            require: [ "btnCheckbox", "ngModel" ],
            controller: "ButtonsController",
            link: function(e, t, n, a) {
                function r() {
                    return s(n.btnCheckboxTrue, !0);
                }
                function i() {
                    return s(n.btnCheckboxFalse, !1);
                }
                function s(t, n) {
                    var a = e.$eval(t);
                    return angular.isDefined(a) ? a : n;
                }
                var o = a[0], u = a[1];
                u.$render = function() {
                    t.toggleClass(o.activeClass, angular.equals(u.$modelValue, r()));
                }, t.bind(o.toggleEvent, function() {
                    e.$apply(function() {
                        u.$setViewValue(t.hasClass(o.activeClass) ? i() : r()), u.$render();
                    });
                });
            }
        };
    }), angular.module("ui.bootstrap.carousel", []).controller("CarouselController", [ "$scope", "$interval", "$animate", function(e, t, n) {
        function a(e) {
            if (angular.isUndefined(c[e].index)) return c[e];
            var t;
            c.length;
            for (t = 0; t < c.length; ++t) if (c[t].index == e) return c[t];
        }
        function r() {
            i();
            var n = +e.interval;
            !isNaN(n) && n > 0 && (o = t(s, n));
        }
        function i() {
            o && (t.cancel(o), o = null);
        }
        function s() {
            var t = +e.interval;
            u && !isNaN(t) && t > 0 ? e.next() : e.pause();
        }
        var o, u, l = this, c = l.slides = e.slides = [], d = -1;
        l.currentSlide = null;
        var m = !1;
        l.select = e.select = function(t, a) {
            function i() {
                m || (angular.extend(t, {
                    direction: a,
                    active: !0
                }), angular.extend(l.currentSlide || {}, {
                    direction: a,
                    active: !1
                }), n.enabled() && !e.noTransition && t.$element && (e.$currentTransition = !0, 
                t.$element.one("$animate:close", function() {
                    e.$currentTransition = null;
                })), l.currentSlide = t, d = s, r());
            }
            var s = l.indexOfSlide(t);
            void 0 === a && (a = s > l.getCurrentIndex() ? "next" : "prev"), t && t !== l.currentSlide && i();
        }, e.$on("$destroy", function() {
            m = !0;
        }), l.getCurrentIndex = function() {
            return l.currentSlide && angular.isDefined(l.currentSlide.index) ? +l.currentSlide.index : d;
        }, l.indexOfSlide = function(e) {
            return angular.isDefined(e.index) ? +e.index : c.indexOf(e);
        }, e.next = function() {
            var t = (l.getCurrentIndex() + 1) % c.length;
            if (!e.$currentTransition) return l.select(a(t), "next");
        }, e.prev = function() {
            var t = l.getCurrentIndex() - 1 < 0 ? c.length - 1 : l.getCurrentIndex() - 1;
            if (!e.$currentTransition) return l.select(a(t), "prev");
        }, e.isActive = function(e) {
            return l.currentSlide === e;
        }, e.$watch("interval", r), e.$on("$destroy", i), e.play = function() {
            u || (u = !0, r());
        }, e.pause = function() {
            e.noPause || (u = !1, i());
        }, l.addSlide = function(t, n) {
            t.$element = n, c.push(t), 1 === c.length || t.active ? (l.select(c[c.length - 1]), 
            1 == c.length && e.play()) : t.active = !1;
        }, l.removeSlide = function(e) {
            angular.isDefined(e.index) && c.sort(function(e, t) {
                return +e.index > +t.index;
            });
            var t = c.indexOf(e);
            c.splice(t, 1), c.length > 0 && e.active ? t >= c.length ? l.select(c[t - 1]) : l.select(c[t]) : d > t && d--;
        };
    } ]).directive("carousel", [ function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            controller: "CarouselController",
            require: "carousel",
            templateUrl: "template/carousel/carousel.html",
            scope: {
                interval: "=",
                noTransition: "=",
                noPause: "="
            }
        };
    } ]).directive("slide", function() {
        return {
            require: "^carousel",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: "template/carousel/slide.html",
            scope: {
                active: "=?",
                index: "=?"
            },
            link: function(e, t, n, a) {
                a.addSlide(e, t), e.$on("$destroy", function() {
                    a.removeSlide(e);
                }), e.$watch("active", function(t) {
                    t && a.select(e);
                });
            }
        };
    }).animation(".item", [ "$animate", function(e) {
        return {
            beforeAddClass: function(t, n, a) {
                if ("active" == n && t.parent() && !t.parent().scope().noTransition) {
                    var r = !1, i = t.isolateScope().direction, s = "next" == i ? "left" : "right";
                    return t.addClass(i), e.addClass(t, s).then(function() {
                        r || t.removeClass(s + " " + i), a();
                    }), function() {
                        r = !0;
                    };
                }
                a();
            },
            beforeRemoveClass: function(t, n, a) {
                if ("active" == n && t.parent() && !t.parent().scope().noTransition) {
                    var r = !1, i = t.isolateScope().direction, s = "next" == i ? "left" : "right";
                    return e.addClass(t, s).then(function() {
                        r || t.removeClass(s), a();
                    }), function() {
                        r = !0;
                    };
                }
                a();
            }
        };
    } ]), angular.module("ui.bootstrap.dateparser", []).service("dateParser", [ "$locale", "orderByFilter", function(e, t) {
        function n(e) {
            var n = [], a = e.split("");
            return angular.forEach(i, function(t, r) {
                var i = e.indexOf(r);
                if (i > -1) {
                    e = e.split(""), a[i] = "(" + t.regex + ")", e[i] = "$";
                    for (var s = i + 1, o = i + r.length; s < o; s++) a[s] = "", e[s] = "$";
                    e = e.join(""), n.push({
                        index: i,
                        apply: t.apply
                    });
                }
            }), {
                regex: new RegExp("^" + a.join("") + "$"),
                map: t(n, "index")
            };
        }
        function a(e, t, n) {
            return !(n < 1) && (1 === t && n > 28 ? 29 === n && (e % 4 === 0 && e % 100 !== 0 || e % 400 === 0) : 3 !== t && 5 !== t && 8 !== t && 10 !== t || n < 31);
        }
        var r = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
        this.parsers = {};
        var i = {
            yyyy: {
                regex: "\\d{4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            yy: {
                regex: "\\d{2}",
                apply: function(e) {
                    this.year = +e + 2e3;
                }
            },
            y: {
                regex: "\\d{1,4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            MMMM: {
                regex: e.DATETIME_FORMATS.MONTH.join("|"),
                apply: function(t) {
                    this.month = e.DATETIME_FORMATS.MONTH.indexOf(t);
                }
            },
            MMM: {
                regex: e.DATETIME_FORMATS.SHORTMONTH.join("|"),
                apply: function(t) {
                    this.month = e.DATETIME_FORMATS.SHORTMONTH.indexOf(t);
                }
            },
            MM: {
                regex: "0[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            M: {
                regex: "[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            dd: {
                regex: "[0-2][0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            d: {
                regex: "[1-2]?[0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            EEEE: {
                regex: e.DATETIME_FORMATS.DAY.join("|")
            },
            EEE: {
                regex: e.DATETIME_FORMATS.SHORTDAY.join("|")
            },
            HH: {
                regex: "(?:0|1)[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            H: {
                regex: "1?[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            mm: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            m: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            sss: {
                regex: "[0-9][0-9][0-9]",
                apply: function(e) {
                    this.milliseconds = +e;
                }
            },
            ss: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            },
            s: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            }
        };
        this.parse = function(t, i, s) {
            if (!angular.isString(t) || !i) return t;
            i = e.DATETIME_FORMATS[i] || i, i = i.replace(r, "\\$&"), this.parsers[i] || (this.parsers[i] = n(i));
            var o = this.parsers[i], u = o.regex, l = o.map, c = t.match(u);
            if (c && c.length) {
                var d, m;
                d = s ? {
                    year: s.getFullYear(),
                    month: s.getMonth(),
                    date: s.getDate(),
                    hours: s.getHours(),
                    minutes: s.getMinutes(),
                    seconds: s.getSeconds(),
                    milliseconds: s.getMilliseconds()
                } : {
                    year: 1900,
                    month: 0,
                    date: 1,
                    hours: 0,
                    minutes: 0,
                    seconds: 0,
                    milliseconds: 0
                };
                for (var f = 1, p = c.length; f < p; f++) {
                    var h = l[f - 1];
                    h.apply && h.apply.call(d, c[f]);
                }
                return a(d.year, d.month, d.date) && (m = new Date(d.year, d.month, d.date, d.hours, d.minutes, d.seconds, d.milliseconds || 0)), 
                m;
            }
        };
    } ]), angular.module("ui.bootstrap.position", []).factory("$position", [ "$document", "$window", function(e, t) {
        function n(e, n) {
            return e.currentStyle ? e.currentStyle[n] : t.getComputedStyle ? t.getComputedStyle(e)[n] : e.style[n];
        }
        function a(e) {
            return "static" === (n(e, "position") || "static");
        }
        var r = function(t) {
            for (var n = e[0], r = t.offsetParent || n; r && r !== n && a(r); ) r = r.offsetParent;
            return r || n;
        };
        return {
            position: function(t) {
                var n = this.offset(t), a = {
                    top: 0,
                    left: 0
                }, i = r(t[0]);
                i != e[0] && (a = this.offset(angular.element(i)), a.top += i.clientTop - i.scrollTop, 
                a.left += i.clientLeft - i.scrollLeft);
                var s = t[0].getBoundingClientRect();
                return {
                    width: s.width || t.prop("offsetWidth"),
                    height: s.height || t.prop("offsetHeight"),
                    top: n.top - a.top,
                    left: n.left - a.left
                };
            },
            offset: function(n) {
                var a = n[0].getBoundingClientRect();
                return {
                    width: a.width || n.prop("offsetWidth"),
                    height: a.height || n.prop("offsetHeight"),
                    top: a.top + (t.pageYOffset || e[0].documentElement.scrollTop),
                    left: a.left + (t.pageXOffset || e[0].documentElement.scrollLeft)
                };
            },
            positionElements: function(e, t, n, a) {
                var r, i, s, o, u = n.split("-"), l = u[0], c = u[1] || "center";
                r = a ? this.offset(e) : this.position(e), i = t.prop("offsetWidth"), s = t.prop("offsetHeight");
                var d = {
                    center: function() {
                        return r.left + r.width / 2 - i / 2;
                    },
                    left: function() {
                        return r.left;
                    },
                    right: function() {
                        return r.left + r.width;
                    }
                }, m = {
                    center: function() {
                        return r.top + r.height / 2 - s / 2;
                    },
                    top: function() {
                        return r.top;
                    },
                    bottom: function() {
                        return r.top + r.height;
                    }
                };
                switch (l) {
                  case "right":
                    o = {
                        top: m[c](),
                        left: d[l]()
                    };
                    break;

                  case "left":
                    o = {
                        top: m[c](),
                        left: r.left - i
                    };
                    break;

                  case "bottom":
                    o = {
                        top: m[l](),
                        left: d[c]()
                    };
                    break;

                  default:
                    o = {
                        top: r.top - s,
                        left: d[c]()
                    };
                }
                return o;
            }
        };
    } ]), angular.module("ui.bootstrap.datepicker", [ "ui.bootstrap.dateparser", "ui.bootstrap.position" ]).constant("datepickerConfig", {
        formatDay: "dd",
        formatMonth: "MMMM",
        formatYear: "yyyy",
        formatDayHeader: "EEE",
        formatDayTitle: "MMMM yyyy",
        formatMonthTitle: "yyyy",
        datepickerMode: "day",
        minMode: "day",
        maxMode: "year",
        showWeeks: !0,
        startingDay: 0,
        yearRange: 20,
        minDate: null,
        maxDate: null,
        shortcutPropagation: !1
    }).controller("DatepickerController", [ "$scope", "$attrs", "$parse", "$interpolate", "$timeout", "$log", "dateFilter", "datepickerConfig", function(e, t, n, a, r, i, s, o) {
        var u = this, l = {
            $setViewValue: angular.noop
        };
        this.modes = [ "day", "month", "year" ], angular.forEach([ "formatDay", "formatMonth", "formatYear", "formatDayHeader", "formatDayTitle", "formatMonthTitle", "minMode", "maxMode", "showWeeks", "startingDay", "yearRange", "shortcutPropagation" ], function(n, r) {
            u[n] = angular.isDefined(t[n]) ? r < 8 ? a(t[n])(e.$parent) : e.$parent.$eval(t[n]) : o[n];
        }), angular.forEach([ "minDate", "maxDate" ], function(a) {
            t[a] ? e.$parent.$watch(n(t[a]), function(e) {
                u[a] = e ? new Date(e) : null, u.refreshView();
            }) : u[a] = o[a] ? new Date(o[a]) : null;
        }), e.datepickerMode = e.datepickerMode || o.datepickerMode, e.maxMode = u.maxMode, 
        e.uniqueId = "datepicker-" + e.$id + "-" + Math.floor(1e4 * Math.random()), angular.isDefined(t.initDate) ? (this.activeDate = e.$parent.$eval(t.initDate) || new Date(), 
        e.$parent.$watch(t.initDate, function(e) {
            e && (l.$isEmpty(l.$modelValue) || l.$invalid) && (u.activeDate = e, u.refreshView());
        })) : this.activeDate = new Date(), e.isActive = function(t) {
            return 0 === u.compare(t.date, u.activeDate) && (e.activeDateId = t.uid, !0);
        }, this.init = function(e) {
            l = e, l.$render = function() {
                u.render();
            };
        }, this.render = function() {
            if (l.$viewValue) {
                var e = new Date(l.$viewValue), t = !isNaN(e);
                t ? this.activeDate = e : i.error('Datepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.'), 
                l.$setValidity("date", t);
            }
            this.refreshView();
        }, this.refreshView = function() {
            if (this.element) {
                this._refreshView();
                var e = l.$viewValue ? new Date(l.$viewValue) : null;
                l.$setValidity("date-disabled", !e || this.element && !this.isDisabled(e));
            }
        }, this.createDateObject = function(e, t) {
            var n = l.$viewValue ? new Date(l.$viewValue) : null;
            return {
                date: e,
                label: s(e, t),
                selected: n && 0 === this.compare(e, n),
                disabled: this.isDisabled(e),
                current: 0 === this.compare(e, new Date()),
                customClass: this.customClass(e)
            };
        }, this.isDisabled = function(n) {
            return this.minDate && this.compare(n, this.minDate) < 0 || this.maxDate && this.compare(n, this.maxDate) > 0 || t.dateDisabled && e.dateDisabled({
                date: n,
                mode: e.datepickerMode
            });
        }, this.customClass = function(t) {
            return e.customClass({
                date: t,
                mode: e.datepickerMode
            });
        }, this.split = function(e, t) {
            for (var n = []; e.length > 0; ) n.push(e.splice(0, t));
            return n;
        }, e.select = function(t) {
            if (e.datepickerMode === u.minMode) {
                var n = l.$viewValue ? new Date(l.$viewValue) : new Date(0, 0, 0, 0, 0, 0, 0);
                n.setFullYear(t.getFullYear(), t.getMonth(), t.getDate()), l.$setViewValue(n), l.$render();
            } else u.activeDate = t, e.datepickerMode = u.modes[u.modes.indexOf(e.datepickerMode) - 1];
        }, e.move = function(e) {
            var t = u.activeDate.getFullYear() + e * (u.step.years || 0), n = u.activeDate.getMonth() + e * (u.step.months || 0);
            u.activeDate.setFullYear(t, n, 1), u.refreshView();
        }, e.toggleMode = function(t) {
            t = t || 1, e.datepickerMode === u.maxMode && 1 === t || e.datepickerMode === u.minMode && t === -1 || (e.datepickerMode = u.modes[u.modes.indexOf(e.datepickerMode) + t]);
        }, e.keys = {
            13: "enter",
            32: "space",
            33: "pageup",
            34: "pagedown",
            35: "end",
            36: "home",
            37: "left",
            38: "up",
            39: "right",
            40: "down"
        };
        var c = function() {
            r(function() {
                u.element[0].focus();
            }, 0, !1);
        };
        e.$on("datepicker.focus", c), e.keydown = function(t) {
            var n = e.keys[t.which];
            if (n && !t.shiftKey && !t.altKey) if (t.preventDefault(), u.shortcutPropagation || t.stopPropagation(), 
            "enter" === n || "space" === n) {
                if (u.isDisabled(u.activeDate)) return;
                e.select(u.activeDate), c();
            } else !t.ctrlKey || "up" !== n && "down" !== n ? (u.handleKeyDown(n, t), u.refreshView()) : (e.toggleMode("up" === n ? 1 : -1), 
            c());
        };
    } ]).directive("datepicker", function() {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/datepicker.html",
            scope: {
                datepickerMode: "=?",
                dateDisabled: "&",
                customClass: "&",
                shortcutPropagation: "&?"
            },
            require: [ "datepicker", "?^ngModel" ],
            controller: "DatepickerController",
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                i && r.init(i);
            }
        };
    }).directive("daypicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/day.html",
            require: "^datepicker",
            link: function(t, n, a, r) {
                function i(e, t) {
                    return 1 !== t || e % 4 !== 0 || e % 100 === 0 && e % 400 !== 0 ? u[t] : 29;
                }
                function s(e, t) {
                    var n = new Array(t), a = new Date(e), r = 0;
                    for (a.setHours(12); r < t; ) n[r++] = new Date(a), a.setDate(a.getDate() + 1);
                    return n;
                }
                function o(e) {
                    var t = new Date(e);
                    t.setDate(t.getDate() + 4 - (t.getDay() || 7));
                    var n = t.getTime();
                    return t.setMonth(0), t.setDate(1), Math.floor(Math.round((n - t) / 864e5) / 7) + 1;
                }
                t.showWeeks = r.showWeeks, r.step = {
                    months: 1
                }, r.element = n;
                var u = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
                r._refreshView = function() {
                    var n = r.activeDate.getFullYear(), a = r.activeDate.getMonth(), i = new Date(n, a, 1), u = r.startingDay - i.getDay(), l = u > 0 ? 7 - u : -u, c = new Date(i);
                    l > 0 && c.setDate(-l + 1);
                    for (var d = s(c, 42), m = 0; m < 42; m++) d[m] = angular.extend(r.createDateObject(d[m], r.formatDay), {
                        secondary: d[m].getMonth() !== a,
                        uid: t.uniqueId + "-" + m
                    });
                    t.labels = new Array(7);
                    for (var f = 0; f < 7; f++) t.labels[f] = {
                        abbr: e(d[f].date, r.formatDayHeader),
                        full: e(d[f].date, "EEEE")
                    };
                    if (t.title = e(r.activeDate, r.formatDayTitle), t.rows = r.split(d, 7), t.showWeeks) {
                        t.weekNumbers = [];
                        for (var p = (11 - r.startingDay) % 7, h = t.rows.length, g = 0; g < h; g++) t.weekNumbers.push(o(t.rows[g][p].date));
                    }
                }, r.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth(), e.getDate()) - new Date(t.getFullYear(), t.getMonth(), t.getDate());
                }, r.handleKeyDown = function(e, t) {
                    var n = r.activeDate.getDate();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 7; else if ("right" === e) n += 1; else if ("down" === e) n += 7; else if ("pageup" === e || "pagedown" === e) {
                        var a = r.activeDate.getMonth() + ("pageup" === e ? -1 : 1);
                        r.activeDate.setMonth(a, 1), n = Math.min(i(r.activeDate.getFullYear(), r.activeDate.getMonth()), n);
                    } else "home" === e ? n = 1 : "end" === e && (n = i(r.activeDate.getFullYear(), r.activeDate.getMonth()));
                    r.activeDate.setDate(n);
                }, r.refreshView();
            }
        };
    } ]).directive("monthpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/month.html",
            require: "^datepicker",
            link: function(t, n, a, r) {
                r.step = {
                    years: 1
                }, r.element = n, r._refreshView = function() {
                    for (var n = new Array(12), a = r.activeDate.getFullYear(), i = 0; i < 12; i++) n[i] = angular.extend(r.createDateObject(new Date(a, i, 1), r.formatMonth), {
                        uid: t.uniqueId + "-" + i
                    });
                    t.title = e(r.activeDate, r.formatMonthTitle), t.rows = r.split(n, 3);
                }, r.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth()) - new Date(t.getFullYear(), t.getMonth());
                }, r.handleKeyDown = function(e, t) {
                    var n = r.activeDate.getMonth();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 3; else if ("right" === e) n += 1; else if ("down" === e) n += 3; else if ("pageup" === e || "pagedown" === e) {
                        var a = r.activeDate.getFullYear() + ("pageup" === e ? -1 : 1);
                        r.activeDate.setFullYear(a);
                    } else "home" === e ? n = 0 : "end" === e && (n = 11);
                    r.activeDate.setMonth(n);
                }, r.refreshView();
            }
        };
    } ]).directive("yearpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/year.html",
            require: "^datepicker",
            link: function(e, t, n, a) {
                function r(e) {
                    return parseInt((e - 1) / i, 10) * i + 1;
                }
                var i = a.yearRange;
                a.step = {
                    years: i
                }, a.element = t, a._refreshView = function() {
                    for (var t = new Array(i), n = 0, s = r(a.activeDate.getFullYear()); n < i; n++) t[n] = angular.extend(a.createDateObject(new Date(s + n, 0, 1), a.formatYear), {
                        uid: e.uniqueId + "-" + n
                    });
                    e.title = [ t[0].label, t[i - 1].label ].join(" - "), e.rows = a.split(t, 5);
                }, a.compare = function(e, t) {
                    return e.getFullYear() - t.getFullYear();
                }, a.handleKeyDown = function(e, t) {
                    var n = a.activeDate.getFullYear();
                    "left" === e ? n -= 1 : "up" === e ? n -= 5 : "right" === e ? n += 1 : "down" === e ? n += 5 : "pageup" === e || "pagedown" === e ? n += ("pageup" === e ? -1 : 1) * a.step.years : "home" === e ? n = r(a.activeDate.getFullYear()) : "end" === e && (n = r(a.activeDate.getFullYear()) + i - 1), 
                    a.activeDate.setFullYear(n);
                }, a.refreshView();
            }
        };
    } ]).constant("datepickerPopupConfig", {
        datepickerPopup: "yyyy-MM-dd",
        html5Types: {
            date: "yyyy-MM-dd",
            "datetime-local": "yyyy-MM-ddTHH:mm:ss.sss",
            month: "yyyy-MM"
        },
        currentText: "Today",
        clearText: "Clear",
        closeText: "Done",
        closeOnDateSelection: !0,
        appendToBody: !1,
        showButtonBar: !0
    }).directive("datepickerPopup", [ "$compile", "$parse", "$document", "$position", "dateFilter", "dateParser", "datepickerPopupConfig", function(e, t, n, a, r, i, s) {
        return {
            restrict: "EA",
            require: "ngModel",
            scope: {
                isOpen: "=?",
                currentText: "@",
                clearText: "@",
                closeText: "@",
                dateDisabled: "&",
                customClass: "&"
            },
            link: function(o, u, l, c) {
                function d(e) {
                    return e.replace(/([A-Z])/g, function(e) {
                        return "-" + e.toLowerCase();
                    });
                }
                function m(e) {
                    angular.isNumber(e) && (e = new Date(e));
                    {
                        if (!e) return null;
                        if (angular.isDate(e) && !isNaN(e)) return e;
                        if (angular.isString(e)) {
                            var t = i.parse(e, p, o.date) || new Date(e);
                            return isNaN(t) ? void 0 : t;
                        }
                    }
                }
                function f(e, t) {
                    var n = e || t;
                    if (angular.isNumber(n) && (n = new Date(n)), n) {
                        if (angular.isDate(n) && !isNaN(n)) return !0;
                        if (angular.isString(n)) {
                            var a = i.parse(n, p) || new Date(n);
                            return !isNaN(a);
                        }
                        return !1;
                    }
                    return !0;
                }
                var p, h = angular.isDefined(l.closeOnDateSelection) ? o.$parent.$eval(l.closeOnDateSelection) : s.closeOnDateSelection, g = angular.isDefined(l.datepickerAppendToBody) ? o.$parent.$eval(l.datepickerAppendToBody) : s.appendToBody;
                o.showButtonBar = angular.isDefined(l.showButtonBar) ? o.$parent.$eval(l.showButtonBar) : s.showButtonBar, 
                o.getText = function(e) {
                    return o[e + "Text"] || s[e + "Text"];
                };
                var _ = !1;
                if (s.html5Types[l.type] ? (p = s.html5Types[l.type], _ = !0) : (p = l.datepickerPopup || s.datepickerPopup, 
                l.$observe("datepickerPopup", function(e, t) {
                    var n = e || s.datepickerPopup;
                    if (n !== p && (p = n, c.$modelValue = null, !p)) throw new Error("datepickerPopup must have a date format specified.");
                })), !p) throw new Error("datepickerPopup must have a date format specified.");
                if (_ && l.datepickerPopup) throw new Error("HTML5 date input types do not support custom formats.");
                var v = angular.element("<div datepicker-popup-wrap><div datepicker></div></div>");
                v.attr({
                    "ng-model": "date",
                    "ng-change": "dateSelection()"
                });
                var b = angular.element(v.children()[0]);
                if (_ && "month" == l.type && (b.attr("datepicker-mode", '"month"'), b.attr("min-mode", "month")), 
                l.datepickerOptions) {
                    var y = o.$parent.$eval(l.datepickerOptions);
                    y.initDate && (o.initDate = y.initDate, b.attr("init-date", "initDate"), delete y.initDate), 
                    angular.forEach(y, function(e, t) {
                        b.attr(d(t), e);
                    });
                }
                o.watchData = {}, angular.forEach([ "minDate", "maxDate", "datepickerMode", "initDate", "shortcutPropagation" ], function(e) {
                    if (l[e]) {
                        var n = t(l[e]);
                        if (o.$parent.$watch(n, function(t) {
                            o.watchData[e] = t;
                        }), b.attr(d(e), "watchData." + e), "datepickerMode" === e) {
                            var a = n.assign;
                            o.$watch("watchData." + e, function(e, t) {
                                e !== t && a(o.$parent, e);
                            });
                        }
                    }
                }), l.dateDisabled && b.attr("date-disabled", "dateDisabled({ date: date, mode: mode })"), 
                l.showWeeks && b.attr("show-weeks", l.showWeeks), l.customClass && b.attr("custom-class", "customClass({ date: date, mode: mode })"), 
                _ ? c.$formatters.push(function(e) {
                    return o.date = e, e;
                }) : (c.$$parserName = "date", c.$validators.date = f, c.$parsers.unshift(m), c.$formatters.push(function(e) {
                    return o.date = e, c.$isEmpty(e) ? e : r(e, p);
                })), o.dateSelection = function(e) {
                    angular.isDefined(e) && (o.date = e);
                    var t = o.date ? r(o.date, p) : "";
                    u.val(t), c.$setViewValue(t), h && (o.isOpen = !1, u[0].focus());
                }, c.$viewChangeListeners.push(function() {
                    o.date = i.parse(c.$viewValue, p, o.date) || new Date(c.$viewValue);
                });
                var M = function(e) {
                    o.isOpen && e.target !== u[0] && o.$apply(function() {
                        o.isOpen = !1;
                    });
                }, $ = function(e, t) {
                    o.keydown(e);
                };
                u.bind("keydown", $), o.keydown = function(e) {
                    27 === e.which ? (e.preventDefault(), o.isOpen && e.stopPropagation(), o.close()) : 40 !== e.which || o.isOpen || (o.isOpen = !0);
                }, o.$watch("isOpen", function(e) {
                    e ? (o.$broadcast("datepicker.focus"), o.position = g ? a.offset(u) : a.position(u), 
                    o.position.top = o.position.top + u.prop("offsetHeight"), n.bind("click", M)) : n.unbind("click", M);
                }), o.select = function(e) {
                    if ("today" === e) {
                        var t = new Date();
                        angular.isDate(o.date) ? (e = new Date(o.date), e.setFullYear(t.getFullYear(), t.getMonth(), t.getDate())) : e = new Date(t.setHours(0, 0, 0, 0));
                    }
                    o.dateSelection(e);
                }, o.close = function() {
                    o.isOpen = !1, u[0].focus();
                };
                var L = e(v)(o);
                v.remove(), g ? n.find("body").append(L) : u.after(L), o.$on("$destroy", function() {
                    L.remove(), u.unbind("keydown", $), n.unbind("click", M);
                });
            }
        };
    } ]).directive("datepickerPopupWrap", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            templateUrl: "template/datepicker/popup.html",
            link: function(e, t, n) {
                t.bind("click", function(e) {
                    e.preventDefault(), e.stopPropagation();
                });
            }
        };
    }), angular.module("ui.bootstrap.dropdown", [ "ui.bootstrap.position" ]).constant("dropdownConfig", {
        openClass: "open"
    }).service("dropdownService", [ "$document", "$rootScope", function(e, t) {
        var n = null;
        this.open = function(t) {
            n || (e.bind("click", a), e.bind("keydown", r)), n && n !== t && (n.isOpen = !1), 
            n = t;
        }, this.close = function(t) {
            n === t && (n = null, e.unbind("click", a), e.unbind("keydown", r));
        };
        var a = function(e) {
            if (n && (!e || "disabled" !== n.getAutoClose())) {
                var a = n.getToggleElement();
                if (!(e && a && a[0].contains(e.target))) {
                    var r = n.getElement();
                    e && "outsideClick" === n.getAutoClose() && r && r[0].contains(e.target) || (n.isOpen = !1, 
                    t.$$phase || n.$apply());
                }
            }
        }, r = function(e) {
            27 === e.which && (n.focusToggleElement(), a());
        };
    } ]).controller("DropdownController", [ "$scope", "$attrs", "$parse", "dropdownConfig", "dropdownService", "$animate", "$position", "$document", function(e, t, n, a, r, i, s, o) {
        var u, l = this, c = e.$new(), d = a.openClass, m = angular.noop, f = t.onToggle ? n(t.onToggle) : angular.noop, p = !1;
        this.init = function(a) {
            l.$element = a, t.isOpen && (u = n(t.isOpen), m = u.assign, e.$watch(u, function(e) {
                c.isOpen = !!e;
            })), p = angular.isDefined(t.dropdownAppendToBody), p && l.dropdownMenu && (o.find("body").append(l.dropdownMenu), 
            a.on("$destroy", function() {
                l.dropdownMenu.remove();
            }));
        }, this.toggle = function(e) {
            return c.isOpen = arguments.length ? !!e : !c.isOpen;
        }, this.isOpen = function() {
            return c.isOpen;
        }, c.getToggleElement = function() {
            return l.toggleElement;
        }, c.getAutoClose = function() {
            return t.autoClose || "always";
        }, c.getElement = function() {
            return l.$element;
        }, c.focusToggleElement = function() {
            l.toggleElement && l.toggleElement[0].focus();
        }, c.$watch("isOpen", function(t, n) {
            if (p && l.dropdownMenu) {
                var a = s.positionElements(l.$element, l.dropdownMenu, "bottom-left", !0);
                l.dropdownMenu.css({
                    top: a.top + "px",
                    left: a.left + "px",
                    display: t ? "block" : "none"
                });
            }
            i[t ? "addClass" : "removeClass"](l.$element, d), t ? (c.focusToggleElement(), r.open(c)) : r.close(c), 
            m(e, t), angular.isDefined(t) && t !== n && f(e, {
                open: !!t
            });
        }), e.$on("$locationChangeSuccess", function() {
            c.isOpen = !1;
        }), e.$on("$destroy", function() {
            c.$destroy();
        });
    } ]).directive("dropdown", function() {
        return {
            controller: "DropdownController",
            link: function(e, t, n, a) {
                a.init(t);
            }
        };
    }).directive("dropdownMenu", function() {
        return {
            restrict: "AC",
            require: "?^dropdown",
            link: function(e, t, n, a) {
                a && (a.dropdownMenu = t);
            }
        };
    }).directive("dropdownToggle", function() {
        return {
            require: "?^dropdown",
            link: function(e, t, n, a) {
                if (a) {
                    a.toggleElement = t;
                    var r = function(r) {
                        r.preventDefault(), t.hasClass("disabled") || n.disabled || e.$apply(function() {
                            a.toggle();
                        });
                    };
                    t.bind("click", r), t.attr({
                        "aria-haspopup": !0,
                        "aria-expanded": !1
                    }), e.$watch(a.isOpen, function(e) {
                        t.attr("aria-expanded", !!e);
                    }), e.$on("$destroy", function() {
                        t.unbind("click", r);
                    });
                }
            }
        };
    }), angular.module("ui.bootstrap.modal", []).factory("$$stackedMap", function() {
        return {
            createNew: function() {
                var e = [];
                return {
                    add: function(t, n) {
                        e.push({
                            key: t,
                            value: n
                        });
                    },
                    get: function(t) {
                        for (var n = 0; n < e.length; n++) if (t == e[n].key) return e[n];
                    },
                    keys: function() {
                        for (var t = [], n = 0; n < e.length; n++) t.push(e[n].key);
                        return t;
                    },
                    top: function() {
                        return e[e.length - 1];
                    },
                    remove: function(t) {
                        for (var n = -1, a = 0; a < e.length; a++) if (t == e[a].key) {
                            n = a;
                            break;
                        }
                        return e.splice(n, 1)[0];
                    },
                    removeTop: function() {
                        return e.splice(e.length - 1, 1)[0];
                    },
                    length: function() {
                        return e.length;
                    }
                };
            }
        };
    }).directive("modalBackdrop", [ "$timeout", function(e) {
        function t(t, n, a) {
            t.animate = !1, e(function() {
                t.animate = !0;
            });
        }
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/modal/backdrop.html",
            compile: function(e, n) {
                return e.addClass(n.backdropClass), t;
            }
        };
    } ]).directive("modalWindow", [ "$modalStack", "$q", function(e, t) {
        return {
            restrict: "EA",
            scope: {
                index: "@",
                animate: "="
            },
            replace: !0,
            transclude: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/modal/window.html";
            },
            link: function(n, a, r) {
                a.addClass(r.windowClass || ""), n.size = r.size, n.close = function(t) {
                    var n = e.getTop();
                    n && n.value.backdrop && "static" != n.value.backdrop && t.target === t.currentTarget && (t.preventDefault(), 
                    t.stopPropagation(), e.dismiss(n.key, "backdrop click"));
                }, n.$isRendered = !0;
                var i = t.defer();
                r.$observe("modalRender", function(e) {
                    "true" == e && i.resolve();
                }), i.promise.then(function() {
                    n.animate = !0;
                    var t = a[0].querySelectorAll("[autofocus]");
                    t.length ? t[0].focus() : a[0].focus();
                    var r = e.getTop();
                    r && e.modalRendered(r.key);
                });
            }
        };
    } ]).directive("modalAnimationClass", [ function() {
        return {
            compile: function(e, t) {
                t.modalAnimation && e.addClass(t.modalAnimationClass);
            }
        };
    } ]).directive("modalTransclude", function() {
        return {
            link: function(e, t, n, a, r) {
                r(e.$parent, function(e) {
                    t.empty(), t.append(e);
                });
            }
        };
    }).factory("$modalStack", [ "$animate", "$timeout", "$document", "$compile", "$rootScope", "$$stackedMap", function(e, t, n, a, r, i) {
        function s() {
            for (var e = -1, t = p.keys(), n = 0; n < t.length; n++) p.get(t[n]).value.backdrop && (e = n);
            return e;
        }
        function o(e) {
            var t = n.find("body").eq(0), a = p.get(e).value;
            p.remove(e), l(a.modalDomEl, a.modalScope, function() {
                t.toggleClass(f, p.length() > 0), u();
            });
        }
        function u() {
            if (d && s() == -1) {
                var e = m;
                l(d, m, function() {
                    e = null;
                }), d = void 0, m = void 0;
            }
        }
        function l(n, a, i) {
            function s() {
                s.done || (s.done = !0, n.remove(), a.$destroy(), i && i());
            }
            a.animate = !1, n.attr("modal-animation") && e.enabled() ? n.one("$animate:close", function() {
                r.$evalAsync(s);
            }) : t(s);
        }
        function c(e, t, n) {
            return !e.value.modalScope.$broadcast("modal.closing", t, n).defaultPrevented;
        }
        var d, m, f = "modal-open", p = i.createNew(), h = {};
        return r.$watch(s, function(e) {
            m && (m.index = e);
        }), n.bind("keydown", function(e) {
            var t;
            27 === e.which && (t = p.top(), t && t.value.keyboard && (e.preventDefault(), r.$apply(function() {
                h.dismiss(t.key, "escape key press");
            })));
        }), h.open = function(e, t) {
            var i = n[0].activeElement;
            p.add(e, {
                deferred: t.deferred,
                renderDeferred: t.renderDeferred,
                modalScope: t.scope,
                backdrop: t.backdrop,
                keyboard: t.keyboard
            });
            var o = n.find("body").eq(0), u = s();
            if (u >= 0 && !d) {
                m = r.$new(!0), m.index = u;
                var l = angular.element('<div modal-backdrop="modal-backdrop"></div>');
                l.attr("backdrop-class", t.backdropClass), t.animation && l.attr("modal-animation", "true"), 
                d = a(l)(m), o.append(d);
            }
            var c = angular.element('<div modal-window="modal-window"></div>');
            c.attr({
                "template-url": t.windowTemplateUrl,
                "window-class": t.windowClass,
                size: t.size,
                index: p.length() - 1,
                animate: "animate"
            }).html(t.content), t.animation && c.attr("modal-animation", "true");
            var h = a(c)(t.scope);
            p.top().value.modalDomEl = h, p.top().value.modalOpener = i, o.append(h), o.addClass(f);
        }, h.close = function(e, t) {
            var n = p.get(e);
            return n && c(n, t, !0) ? (n.value.deferred.resolve(t), o(e), n.value.modalOpener.focus(), 
            !0) : !n;
        }, h.dismiss = function(e, t) {
            var n = p.get(e);
            return n && c(n, t, !1) ? (n.value.deferred.reject(t), o(e), n.value.modalOpener.focus(), 
            !0) : !n;
        }, h.dismissAll = function(e) {
            for (var t = this.getTop(); t && this.dismiss(t.key, e); ) t = this.getTop();
        }, h.getTop = function() {
            return p.top();
        }, h.modalRendered = function(e) {
            var t = p.get(e);
            t && t.value.renderDeferred.resolve();
        }, h;
    } ]).provider("$modal", function() {
        var e = {
            options: {
                animation: !0,
                backdrop: !0,
                keyboard: !0
            },
            $get: [ "$injector", "$rootScope", "$q", "$templateRequest", "$controller", "$modalStack", function(t, n, a, r, i, s) {
                function o(e) {
                    return e.template ? a.when(e.template) : r(angular.isFunction(e.templateUrl) ? e.templateUrl() : e.templateUrl);
                }
                function u(e) {
                    var n = [];
                    return angular.forEach(e, function(e) {
                        (angular.isFunction(e) || angular.isArray(e)) && n.push(a.when(t.invoke(e)));
                    }), n;
                }
                var l = {};
                return l.open = function(t) {
                    var r = a.defer(), l = a.defer(), c = a.defer(), d = {
                        result: r.promise,
                        opened: l.promise,
                        rendered: c.promise,
                        close: function(e) {
                            return s.close(d, e);
                        },
                        dismiss: function(e) {
                            return s.dismiss(d, e);
                        }
                    };
                    if (t = angular.extend({}, e.options, t), t.resolve = t.resolve || {}, !t.template && !t.templateUrl) throw new Error("One of template or templateUrl options is required.");
                    var m = a.all([ o(t) ].concat(u(t.resolve)));
                    return m.then(function(e) {
                        var a = (t.scope || n).$new();
                        a.$close = d.close, a.$dismiss = d.dismiss;
                        var o, u = {}, l = 1;
                        t.controller && (u.$scope = a, u.$modalInstance = d, angular.forEach(t.resolve, function(t, n) {
                            u[n] = e[l++];
                        }), o = i(t.controller, u), t.controllerAs && (a[t.controllerAs] = o)), s.open(d, {
                            scope: a,
                            deferred: r,
                            renderDeferred: c,
                            content: e[0],
                            animation: t.animation,
                            backdrop: t.backdrop,
                            keyboard: t.keyboard,
                            backdropClass: t.backdropClass,
                            windowClass: t.windowClass,
                            windowTemplateUrl: t.windowTemplateUrl,
                            size: t.size
                        });
                    }, function(e) {
                        r.reject(e);
                    }), m.then(function() {
                        l.resolve(!0);
                    }, function(e) {
                        l.reject(e);
                    }), d;
                }, l;
            } ]
        };
        return e;
    }), angular.module("ui.bootstrap.pagination", []).controller("PaginationController", [ "$scope", "$attrs", "$parse", function(e, t, n) {
        var a = this, r = {
            $setViewValue: angular.noop
        }, i = t.numPages ? n(t.numPages).assign : angular.noop;
        this.init = function(s, o) {
            r = s, this.config = o, r.$render = function() {
                a.render();
            }, t.itemsPerPage ? e.$parent.$watch(n(t.itemsPerPage), function(t) {
                a.itemsPerPage = parseInt(t, 10), e.totalPages = a.calculateTotalPages();
            }) : this.itemsPerPage = o.itemsPerPage, e.$watch("totalItems", function() {
                e.totalPages = a.calculateTotalPages();
            }), e.$watch("totalPages", function(t) {
                i(e.$parent, t), e.page > t ? e.selectPage(t) : r.$render();
            });
        }, this.calculateTotalPages = function() {
            var t = this.itemsPerPage < 1 ? 1 : Math.ceil(e.totalItems / this.itemsPerPage);
            return Math.max(t || 0, 1);
        }, this.render = function() {
            e.page = parseInt(r.$viewValue, 10) || 1;
        }, e.selectPage = function(t, n) {
            e.page !== t && t > 0 && t <= e.totalPages && (n && n.target && n.target.blur(), 
            r.$setViewValue(t), r.$render());
        }, e.getText = function(t) {
            return e[t + "Text"] || a.config[t + "Text"];
        }, e.noPrevious = function() {
            return 1 === e.page;
        }, e.noNext = function() {
            return e.page === e.totalPages;
        };
    } ]).constant("paginationConfig", {
        itemsPerPage: 10,
        boundaryLinks: !1,
        directionLinks: !0,
        firstText: "First",
        previousText: "Previous",
        nextText: "Next",
        lastText: "Last",
        rotate: !0
    }).directive("pagination", [ "$parse", "paginationConfig", function(e, t) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                firstText: "@",
                previousText: "@",
                nextText: "@",
                lastText: "@"
            },
            require: [ "pagination", "?ngModel" ],
            controller: "PaginationController",
            templateUrl: "template/pagination/pagination.html",
            replace: !0,
            link: function(n, a, r, i) {
                function s(e, t, n) {
                    return {
                        number: e,
                        text: t,
                        active: n
                    };
                }
                function o(e, t) {
                    var n = [], a = 1, r = t, i = angular.isDefined(c) && c < t;
                    i && (d ? (a = Math.max(e - Math.floor(c / 2), 1), r = a + c - 1, r > t && (r = t, 
                    a = r - c + 1)) : (a = (Math.ceil(e / c) - 1) * c + 1, r = Math.min(a + c - 1, t)));
                    for (var o = a; o <= r; o++) {
                        var u = s(o, o, o === e);
                        n.push(u);
                    }
                    if (i && !d) {
                        if (a > 1) {
                            var l = s(a - 1, "...", !1);
                            n.unshift(l);
                        }
                        if (r < t) {
                            var m = s(r + 1, "...", !1);
                            n.push(m);
                        }
                    }
                    return n;
                }
                var u = i[0], l = i[1];
                if (l) {
                    var c = angular.isDefined(r.maxSize) ? n.$parent.$eval(r.maxSize) : t.maxSize, d = angular.isDefined(r.rotate) ? n.$parent.$eval(r.rotate) : t.rotate;
                    n.boundaryLinks = angular.isDefined(r.boundaryLinks) ? n.$parent.$eval(r.boundaryLinks) : t.boundaryLinks, 
                    n.directionLinks = angular.isDefined(r.directionLinks) ? n.$parent.$eval(r.directionLinks) : t.directionLinks, 
                    u.init(l, t), r.maxSize && n.$parent.$watch(e(r.maxSize), function(e) {
                        c = parseInt(e, 10), u.render();
                    });
                    var m = u.render;
                    u.render = function() {
                        m(), n.page > 0 && n.page <= n.totalPages && (n.pages = o(n.page, n.totalPages));
                    };
                }
            }
        };
    } ]).constant("pagerConfig", {
        itemsPerPage: 10,
        previousText: "« Previous",
        nextText: "Next »",
        align: !0
    }).directive("pager", [ "pagerConfig", function(e) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                previousText: "@",
                nextText: "@"
            },
            require: [ "pager", "?ngModel" ],
            controller: "PaginationController",
            templateUrl: "template/pagination/pager.html",
            replace: !0,
            link: function(t, n, a, r) {
                var i = r[0], s = r[1];
                s && (t.align = angular.isDefined(a.align) ? t.$parent.$eval(a.align) : e.align, 
                i.init(s, e));
            }
        };
    } ]), angular.module("ui.bootstrap.tooltip", [ "ui.bootstrap.position", "ui.bootstrap.bindHtml" ]).provider("$tooltip", function() {
        function e(e) {
            var t = /[A-Z]/g, n = "-";
            return e.replace(t, function(e, t) {
                return (t ? n : "") + e.toLowerCase();
            });
        }
        var t = {
            placement: "top",
            animation: !0,
            popupDelay: 0,
            useContentExp: !1
        }, n = {
            mouseenter: "mouseleave",
            click: "click",
            focus: "blur"
        }, a = {};
        this.options = function(e) {
            angular.extend(a, e);
        }, this.setTriggers = function(e) {
            angular.extend(n, e);
        }, this.$get = [ "$window", "$compile", "$timeout", "$document", "$position", "$interpolate", function(r, i, s, o, u, l) {
            return function(r, c, d, m) {
                function f(e) {
                    var t = e || m.trigger || d, a = n[t] || t;
                    return {
                        show: t,
                        hide: a
                    };
                }
                m = angular.extend({}, t, a, m);
                var p = e(r), h = l.startSymbol(), g = l.endSymbol(), _ = "<div " + p + '-popup title="' + h + "title" + g + '" ' + (m.useContentExp ? 'content-exp="contentExp()" ' : 'content="' + h + "content" + g + '" ') + 'placement="' + h + "placement" + g + '" popup-class="' + h + "popupClass" + g + '" animation="animation" is-open="isOpen"origin-scope="origScope" ></div>';
                return {
                    restrict: "EA",
                    compile: function(e, t) {
                        var n = i(_);
                        return function(e, t, a, i) {
                            function l() {
                                C.isOpen ? p() : d();
                            }
                            function d() {
                                x && !e.$eval(a[c + "Enable"]) || (b(), C.popupDelay ? Y || (Y = s(h, C.popupDelay, !1), 
                                Y.then(function(e) {
                                    e();
                                })) : h()());
                            }
                            function p() {
                                e.$apply(function() {
                                    g();
                                });
                            }
                            function h() {
                                return Y = null, D && (s.cancel(D), D = null), (m.useContentExp ? C.contentExp() : C.content) ? (_(), 
                                k.css({
                                    top: 0,
                                    left: 0,
                                    display: "block"
                                }), C.$digest(), E(), C.isOpen = !0, C.$apply(), E) : angular.noop;
                            }
                            function g() {
                                C.isOpen = !1, s.cancel(Y), Y = null, C.animation ? D || (D = s(v, 500)) : v();
                            }
                            function _() {
                                k && v(), w = C.$new(), k = n(w, function(e) {
                                    T ? o.find("body").append(e) : t.after(e);
                                }), w.$watch(function() {
                                    s(E, 0, !1);
                                }), m.useContentExp && w.$watch("contentExp()", function(e) {
                                    !e && C.isOpen && g();
                                });
                            }
                            function v() {
                                D = null, k && (k.remove(), k = null), w && (w.$destroy(), w = null);
                            }
                            function b() {
                                y(), M(), $();
                            }
                            function y() {
                                C.popupClass = a[c + "Class"];
                            }
                            function M() {
                                var e = a[c + "Placement"];
                                C.placement = angular.isDefined(e) ? e : m.placement;
                            }
                            function $() {
                                var e = a[c + "PopupDelay"], t = parseInt(e, 10);
                                C.popupDelay = isNaN(t) ? m.popupDelay : t;
                            }
                            function L() {
                                var e = a[c + "Trigger"];
                                H(), S = f(e), S.show === S.hide ? t.bind(S.show, l) : (t.bind(S.show, d), t.bind(S.hide, p));
                            }
                            var k, w, D, Y, T = !!angular.isDefined(m.appendToBody) && m.appendToBody, S = f(void 0), x = angular.isDefined(a[c + "Enable"]), C = e.$new(!0), E = function() {
                                if (k) {
                                    var e = u.positionElements(t, k, C.placement, T);
                                    e.top += "px", e.left += "px", k.css(e);
                                }
                            };
                            C.origScope = e, C.isOpen = !1, C.contentExp = function() {
                                return e.$eval(a[r]);
                            }, m.useContentExp || a.$observe(r, function(e) {
                                C.content = e, !e && C.isOpen && g();
                            }), a.$observe("disabled", function(e) {
                                e && C.isOpen && g();
                            }), a.$observe(c + "Title", function(e) {
                                C.title = e;
                            });
                            var H = function() {
                                t.unbind(S.show, d), t.unbind(S.hide, p);
                            };
                            L();
                            var j = e.$eval(a[c + "Animation"]);
                            C.animation = angular.isDefined(j) ? !!j : m.animation;
                            var A = e.$eval(a[c + "AppendToBody"]);
                            T = angular.isDefined(A) ? A : T, T && e.$on("$locationChangeSuccess", function() {
                                C.isOpen && g();
                            }), e.$on("$destroy", function() {
                                s.cancel(D), s.cancel(Y), H(), v(), C = null;
                            });
                        };
                    }
                };
            };
        } ];
    }).directive("tooltipTemplateTransclude", [ "$animate", "$sce", "$compile", "$templateRequest", function(e, t, n, a) {
        return {
            link: function(r, i, s) {
                var o, u, l, c = r.$eval(s.tooltipTemplateTranscludeScope), d = 0, m = function() {
                    u && (u.remove(), u = null), o && (o.$destroy(), o = null), l && (e.leave(l).then(function() {
                        u = null;
                    }), u = l, l = null);
                };
                r.$watch(t.parseAsResourceUrl(s.tooltipTemplateTransclude), function(t) {
                    var s = ++d;
                    t ? (a(t, !0).then(function(a) {
                        if (s === d) {
                            var r = c.$new(), u = a, f = n(u)(r, function(t) {
                                m(), e.enter(t, i);
                            });
                            o = r, l = f, o.$emit("$includeContentLoaded", t);
                        }
                    }, function() {
                        s === d && (m(), r.$emit("$includeContentError", t));
                    }), r.$emit("$includeContentRequested", t)) : m();
                }), r.$on("$destroy", m);
            }
        };
    } ]).directive("tooltipClasses", function() {
        return {
            restrict: "A",
            link: function(e, t, n) {
                e.placement && t.addClass(e.placement), e.popupClass && t.addClass(e.popupClass), 
                e.animation() && t.addClass(n.tooltipAnimationClass);
            }
        };
    }).directive("tooltipPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-popup.html"
        };
    }).directive("tooltip", [ "$tooltip", function(e) {
        return e("tooltip", "tooltip", "mouseenter");
    } ]).directive("tooltipTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/tooltip/tooltip-template-popup.html"
        };
    }).directive("tooltipTemplate", [ "$tooltip", function(e) {
        return e("tooltipTemplate", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-popup.html"
        };
    }).directive("tooltipHtml", [ "$tooltip", function(e) {
        return e("tooltipHtml", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlUnsafePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-unsafe-popup.html"
        };
    }).value("tooltipHtmlUnsafeSuppressDeprecated", !1).directive("tooltipHtmlUnsafe", [ "$tooltip", "tooltipHtmlUnsafeSuppressDeprecated", "$log", function(e, t, n) {
        return t || n.warn("tooltip-html-unsafe is now deprecated. Use tooltip-html or tooltip-template instead."), 
        e("tooltipHtmlUnsafe", "tooltip", "mouseenter");
    } ]), angular.module("ui.bootstrap.popover", [ "ui.bootstrap.tooltip" ]).directive("popoverTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/popover/popover-template.html"
        };
    }).directive("popoverTemplate", [ "$tooltip", function(e) {
        return e("popoverTemplate", "popover", "click", {
            useContentExp: !0
        });
    } ]).directive("popoverPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/popover/popover.html"
        };
    }).directive("popover", [ "$tooltip", function(e) {
        return e("popover", "popover", "click");
    } ]), angular.module("ui.bootstrap.progressbar", []).constant("progressConfig", {
        animate: !0,
        max: 100
    }).controller("ProgressController", [ "$scope", "$attrs", "progressConfig", function(e, t, n) {
        var a = this, r = angular.isDefined(t.animate) ? e.$parent.$eval(t.animate) : n.animate;
        this.bars = [], e.max = angular.isDefined(e.max) ? e.max : n.max, this.addBar = function(t, n) {
            r || n.css({
                transition: "none"
            }), this.bars.push(t), t.$watch("value", function(n) {
                t.percent = +(100 * n / e.max).toFixed(2);
            }), t.$on("$destroy", function() {
                n = null, a.removeBar(t);
            });
        }, this.removeBar = function(e) {
            this.bars.splice(this.bars.indexOf(e), 1);
        };
    } ]).directive("progress", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            require: "progress",
            scope: {},
            templateUrl: "template/progressbar/progress.html"
        };
    }).directive("bar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            require: "^progress",
            scope: {
                value: "=",
                max: "=?",
                type: "@"
            },
            templateUrl: "template/progressbar/bar.html",
            link: function(e, t, n, a) {
                a.addBar(e, t);
            }
        };
    }).directive("progressbar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            scope: {
                value: "=",
                max: "=?",
                type: "@"
            },
            templateUrl: "template/progressbar/progressbar.html",
            link: function(e, t, n, a) {
                a.addBar(e, angular.element(t.children()[0]));
            }
        };
    }), angular.module("ui.bootstrap.rating", []).constant("ratingConfig", {
        max: 5,
        stateOn: null,
        stateOff: null
    }).controller("RatingController", [ "$scope", "$attrs", "ratingConfig", function(e, t, n) {
        var a = {
            $setViewValue: angular.noop
        };
        this.init = function(r) {
            a = r, a.$render = this.render, a.$formatters.push(function(e) {
                return angular.isNumber(e) && e << 0 !== e && (e = Math.round(e)), e;
            }), this.stateOn = angular.isDefined(t.stateOn) ? e.$parent.$eval(t.stateOn) : n.stateOn, 
            this.stateOff = angular.isDefined(t.stateOff) ? e.$parent.$eval(t.stateOff) : n.stateOff;
            var i = angular.isDefined(t.ratingStates) ? e.$parent.$eval(t.ratingStates) : new Array(angular.isDefined(t.max) ? e.$parent.$eval(t.max) : n.max);
            e.range = this.buildTemplateObjects(i);
        }, this.buildTemplateObjects = function(e) {
            for (var t = 0, n = e.length; t < n; t++) e[t] = angular.extend({
                index: t
            }, {
                stateOn: this.stateOn,
                stateOff: this.stateOff
            }, e[t]);
            return e;
        }, e.rate = function(t) {
            !e.readonly && t >= 0 && t <= e.range.length && (a.$setViewValue(t), a.$render());
        }, e.enter = function(t) {
            e.readonly || (e.value = t), e.onHover({
                value: t
            });
        }, e.reset = function() {
            e.value = a.$viewValue, e.onLeave();
        }, e.onKeydown = function(t) {
            /(37|38|39|40)/.test(t.which) && (t.preventDefault(), t.stopPropagation(), e.rate(e.value + (38 === t.which || 39 === t.which ? 1 : -1)));
        }, this.render = function() {
            e.value = a.$viewValue;
        };
    } ]).directive("rating", function() {
        return {
            restrict: "EA",
            require: [ "rating", "ngModel" ],
            scope: {
                readonly: "=?",
                onHover: "&",
                onLeave: "&"
            },
            controller: "RatingController",
            templateUrl: "template/rating/rating.html",
            replace: !0,
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                r.init(i);
            }
        };
    }), angular.module("ui.bootstrap.tabs", []).controller("TabsetController", [ "$scope", function(e) {
        var t = this, n = t.tabs = e.tabs = [];
        t.select = function(e) {
            angular.forEach(n, function(t) {
                t.active && t !== e && (t.active = !1, t.onDeselect());
            }), e.active = !0, e.onSelect();
        }, t.addTab = function(e) {
            n.push(e), 1 === n.length && e.active !== !1 ? e.active = !0 : e.active ? t.select(e) : e.active = !1;
        }, t.removeTab = function(e) {
            var r = n.indexOf(e);
            if (e.active && n.length > 1 && !a) {
                var i = r == n.length - 1 ? r - 1 : r + 1;
                t.select(n[i]);
            }
            n.splice(r, 1);
        };
        var a;
        e.$on("$destroy", function() {
            a = !0;
        });
    } ]).directive("tabset", function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            scope: {
                type: "@"
            },
            controller: "TabsetController",
            templateUrl: "template/tabs/tabset.html",
            link: function(e, t, n) {
                e.vertical = !!angular.isDefined(n.vertical) && e.$parent.$eval(n.vertical), e.justified = !!angular.isDefined(n.justified) && e.$parent.$eval(n.justified);
            }
        };
    }).directive("tab", [ "$parse", "$log", function(e, t) {
        return {
            require: "^tabset",
            restrict: "EA",
            replace: !0,
            templateUrl: "template/tabs/tab.html",
            transclude: !0,
            scope: {
                active: "=?",
                heading: "@",
                onSelect: "&select",
                onDeselect: "&deselect"
            },
            controller: function() {},
            compile: function(n, a, r) {
                return function(n, a, i, s) {
                    n.$watch("active", function(e) {
                        e && s.select(n);
                    }), n.disabled = !1, i.disable && n.$parent.$watch(e(i.disable), function(e) {
                        n.disabled = !!e;
                    }), i.disabled && (t.warn('Use of "disabled" attribute has been deprecated, please use "disable"'), 
                    n.$parent.$watch(e(i.disabled), function(e) {
                        n.disabled = !!e;
                    })), n.select = function() {
                        n.disabled || (n.active = !0);
                    }, s.addTab(n), n.$on("$destroy", function() {
                        s.removeTab(n);
                    }), n.$transcludeFn = r;
                };
            }
        };
    } ]).directive("tabHeadingTransclude", [ function() {
        return {
            restrict: "A",
            require: "^tab",
            link: function(e, t, n, a) {
                e.$watch("headingElement", function(e) {
                    e && (t.html(""), t.append(e));
                });
            }
        };
    } ]).directive("tabContentTransclude", function() {
        function e(e) {
            return e.tagName && (e.hasAttribute("tab-heading") || e.hasAttribute("data-tab-heading") || "tab-heading" === e.tagName.toLowerCase() || "data-tab-heading" === e.tagName.toLowerCase());
        }
        return {
            restrict: "A",
            require: "^tabset",
            link: function(t, n, a) {
                var r = t.$eval(a.tabContentTransclude);
                r.$transcludeFn(r.$parent, function(t) {
                    angular.forEach(t, function(t) {
                        e(t) ? r.headingElement = t : n.append(t);
                    });
                });
            }
        };
    }), angular.module("ui.bootstrap.timepicker", []).constant("timepickerConfig", {
        hourStep: 1,
        minuteStep: 1,
        showMeridian: !0,
        meridians: null,
        readonlyInput: !1,
        mousewheel: !0,
        arrowkeys: !0
    }).controller("TimepickerController", [ "$scope", "$attrs", "$parse", "$log", "$locale", "timepickerConfig", function(e, t, n, a, r, i) {
        function s() {
            var t = parseInt(e.hours, 10), n = e.showMeridian ? t > 0 && t < 13 : t >= 0 && t < 24;
            if (n) return e.showMeridian && (12 === t && (t = 0), e.meridian === h[1] && (t += 12)), 
            t;
        }
        function o() {
            var t = parseInt(e.minutes, 10);
            return t >= 0 && t < 60 ? t : void 0;
        }
        function u(e) {
            return angular.isDefined(e) && e.toString().length < 2 ? "0" + e : e.toString();
        }
        function l(e) {
            c(), p.$setViewValue(new Date(f)), d(e);
        }
        function c() {
            p.$setValidity("time", !0), e.invalidHours = !1, e.invalidMinutes = !1;
        }
        function d(t) {
            var n = f.getHours(), a = f.getMinutes();
            e.showMeridian && (n = 0 === n || 12 === n ? 12 : n % 12), e.hours = "h" === t ? n : u(n), 
            "m" !== t && (e.minutes = u(a)), e.meridian = f.getHours() < 12 ? h[0] : h[1];
        }
        function m(e) {
            var t = new Date(f.getTime() + 6e4 * e);
            f.setHours(t.getHours(), t.getMinutes()), l();
        }
        var f = new Date(), p = {
            $setViewValue: angular.noop
        }, h = angular.isDefined(t.meridians) ? e.$parent.$eval(t.meridians) : i.meridians || r.DATETIME_FORMATS.AMPMS;
        this.init = function(n, a) {
            p = n, p.$render = this.render, p.$formatters.unshift(function(e) {
                return e ? new Date(e) : null;
            });
            var r = a.eq(0), s = a.eq(1), o = angular.isDefined(t.mousewheel) ? e.$parent.$eval(t.mousewheel) : i.mousewheel;
            o && this.setupMousewheelEvents(r, s);
            var u = angular.isDefined(t.arrowkeys) ? e.$parent.$eval(t.arrowkeys) : i.arrowkeys;
            u && this.setupArrowkeyEvents(r, s), e.readonlyInput = angular.isDefined(t.readonlyInput) ? e.$parent.$eval(t.readonlyInput) : i.readonlyInput, 
            this.setupInputEvents(r, s);
        };
        var g = i.hourStep;
        t.hourStep && e.$parent.$watch(n(t.hourStep), function(e) {
            g = parseInt(e, 10);
        });
        var _ = i.minuteStep;
        t.minuteStep && e.$parent.$watch(n(t.minuteStep), function(e) {
            _ = parseInt(e, 10);
        }), e.showMeridian = i.showMeridian, t.showMeridian && e.$parent.$watch(n(t.showMeridian), function(t) {
            if (e.showMeridian = !!t, p.$error.time) {
                var n = s(), a = o();
                angular.isDefined(n) && angular.isDefined(a) && (f.setHours(n), l());
            } else d();
        }), this.setupMousewheelEvents = function(t, n) {
            var a = function(e) {
                e.originalEvent && (e = e.originalEvent);
                var t = e.wheelDelta ? e.wheelDelta : -e.deltaY;
                return e.detail || t > 0;
            };
            t.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementHours() : e.decrementHours()), t.preventDefault();
            }), n.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementMinutes() : e.decrementMinutes()), t.preventDefault();
            });
        }, this.setupArrowkeyEvents = function(t, n) {
            t.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementHours(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementHours(), e.$apply());
            }), n.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementMinutes(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementMinutes(), e.$apply());
            });
        }, this.setupInputEvents = function(t, n) {
            if (e.readonlyInput) return e.updateHours = angular.noop, void (e.updateMinutes = angular.noop);
            var a = function(t, n) {
                p.$setViewValue(null), p.$setValidity("time", !1), angular.isDefined(t) && (e.invalidHours = t), 
                angular.isDefined(n) && (e.invalidMinutes = n);
            };
            e.updateHours = function() {
                var e = s();
                angular.isDefined(e) ? (f.setHours(e), l("h")) : a(!0);
            }, t.bind("blur", function(t) {
                !e.invalidHours && e.hours < 10 && e.$apply(function() {
                    e.hours = u(e.hours);
                });
            }), e.updateMinutes = function() {
                var e = o();
                angular.isDefined(e) ? (f.setMinutes(e), l("m")) : a(void 0, !0);
            }, n.bind("blur", function(t) {
                !e.invalidMinutes && e.minutes < 10 && e.$apply(function() {
                    e.minutes = u(e.minutes);
                });
            });
        }, this.render = function() {
            var e = p.$viewValue;
            isNaN(e) ? (p.$setValidity("time", !1), a.error('Timepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.')) : (e && (f = e), 
            c(), d());
        }, e.incrementHours = function() {
            m(60 * g);
        }, e.decrementHours = function() {
            m(60 * -g);
        }, e.incrementMinutes = function() {
            m(_);
        }, e.decrementMinutes = function() {
            m(-_);
        }, e.toggleMeridian = function() {
            m(720 * (f.getHours() < 12 ? 1 : -1));
        };
    } ]).directive("timepicker", function() {
        return {
            restrict: "EA",
            require: [ "timepicker", "?^ngModel" ],
            controller: "TimepickerController",
            replace: !0,
            scope: {},
            templateUrl: "template/timepicker/timepicker.html",
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                i && r.init(i, t.find("input"));
            }
        };
    }), angular.module("ui.bootstrap.transition", []).value("$transitionSuppressDeprecated", !1).factory("$transition", [ "$q", "$timeout", "$rootScope", "$log", "$transitionSuppressDeprecated", function(e, t, n, a, r) {
        function i(e) {
            for (var t in e) if (void 0 !== o.style[t]) return e[t];
        }
        r || a.warn("$transition is now deprecated. Use $animate from ngAnimate instead.");
        var s = function(a, r, i) {
            i = i || {};
            var o = e.defer(), u = s[i.animation ? "animationEndEventName" : "transitionEndEventName"], l = function(e) {
                n.$apply(function() {
                    a.unbind(u, l), o.resolve(a);
                });
            };
            return u && a.bind(u, l), t(function() {
                angular.isString(r) ? a.addClass(r) : angular.isFunction(r) ? r(a) : angular.isObject(r) && a.css(r), 
                u || o.resolve(a);
            }), o.promise.cancel = function() {
                u && a.unbind(u, l), o.reject("Transition cancelled");
            }, o.promise;
        }, o = document.createElement("trans"), u = {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            transition: "transitionend"
        }, l = {
            WebkitTransition: "webkitAnimationEnd",
            MozTransition: "animationend",
            OTransition: "oAnimationEnd",
            transition: "animationend"
        };
        return s.transitionEndEventName = i(u), s.animationEndEventName = i(l), s;
    } ]), angular.module("ui.bootstrap.typeahead", [ "ui.bootstrap.position", "ui.bootstrap.bindHtml" ]).factory("typeaheadParser", [ "$parse", function(e) {
        var t = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;
        return {
            parse: function(n) {
                var a = n.match(t);
                if (!a) throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "' + n + '".');
                return {
                    itemName: a[3],
                    source: e(a[4]),
                    viewMapper: e(a[2] || a[1]),
                    modelMapper: e(a[1])
                };
            }
        };
    } ]).directive("typeahead", [ "$compile", "$parse", "$q", "$timeout", "$document", "$position", "typeaheadParser", function(e, t, n, a, r, i, s) {
        var o = [ 9, 13, 27, 38, 40 ];
        return {
            require: "ngModel",
            link: function(u, l, c, d) {
                var m, f = u.$eval(c.typeaheadMinLength) || 1, p = u.$eval(c.typeaheadWaitMs) || 0, h = u.$eval(c.typeaheadEditable) !== !1, g = t(c.typeaheadLoading).assign || angular.noop, _ = t(c.typeaheadOnSelect), v = c.typeaheadInputFormatter ? t(c.typeaheadInputFormatter) : void 0, b = !!c.typeaheadAppendToBody && u.$eval(c.typeaheadAppendToBody), y = u.$eval(c.typeaheadFocusFirst) !== !1, M = t(c.ngModel).assign, $ = s.parse(c.typeahead), L = u.$new();
                u.$on("$destroy", function() {
                    L.$destroy();
                });
                var k = "typeahead-" + L.$id + "-" + Math.floor(1e4 * Math.random());
                l.attr({
                    "aria-autocomplete": "list",
                    "aria-expanded": !1,
                    "aria-owns": k
                });
                var w = angular.element("<div typeahead-popup></div>");
                w.attr({
                    id: k,
                    matches: "matches",
                    active: "activeIdx",
                    select: "select(activeIdx)",
                    query: "query",
                    position: "position"
                }), angular.isDefined(c.typeaheadTemplateUrl) && w.attr("template-url", c.typeaheadTemplateUrl);
                var D = function() {
                    L.matches = [], L.activeIdx = -1, l.attr("aria-expanded", !1);
                }, Y = function(e) {
                    return k + "-option-" + e;
                };
                L.$watch("activeIdx", function(e) {
                    e < 0 ? l.removeAttr("aria-activedescendant") : l.attr("aria-activedescendant", Y(e));
                });
                var T = function(e) {
                    var t = {
                        $viewValue: e
                    };
                    g(u, !0), n.when($.source(u, t)).then(function(n) {
                        var a = e === d.$viewValue;
                        if (a && m) if (n && n.length > 0) {
                            L.activeIdx = y ? 0 : -1, L.matches.length = 0;
                            for (var r = 0; r < n.length; r++) t[$.itemName] = n[r], L.matches.push({
                                id: Y(r),
                                label: $.viewMapper(L, t),
                                model: n[r]
                            });
                            L.query = e, L.position = b ? i.offset(l) : i.position(l), L.position.top = L.position.top + l.prop("offsetHeight"), 
                            l.attr("aria-expanded", !0);
                        } else D();
                        a && g(u, !1);
                    }, function() {
                        D(), g(u, !1);
                    });
                };
                D(), L.query = void 0;
                var S, x = function(e) {
                    S = a(function() {
                        T(e);
                    }, p);
                }, C = function() {
                    S && a.cancel(S);
                };
                d.$parsers.unshift(function(e) {
                    return m = !0, e && e.length >= f ? p > 0 ? (C(), x(e)) : T(e) : (g(u, !1), C(), 
                    D()), h ? e : e ? void d.$setValidity("editable", !1) : (d.$setValidity("editable", !0), 
                    e);
                }), d.$formatters.push(function(e) {
                    var t, n, a = {};
                    return h || d.$setValidity("editable", !0), v ? (a.$model = e, v(u, a)) : (a[$.itemName] = e, 
                    t = $.viewMapper(u, a), a[$.itemName] = void 0, n = $.viewMapper(u, a), t !== n ? t : e);
                }), L.select = function(e) {
                    var t, n, r = {};
                    r[$.itemName] = n = L.matches[e].model, t = $.modelMapper(u, r), M(u, t), d.$setValidity("editable", !0), 
                    d.$setValidity("parse", !0), _(u, {
                        $item: n,
                        $model: t,
                        $label: $.viewMapper(u, r)
                    }), D(), a(function() {
                        l[0].focus();
                    }, 0, !1);
                }, l.bind("keydown", function(e) {
                    0 !== L.matches.length && o.indexOf(e.which) !== -1 && (L.activeIdx != -1 || 13 !== e.which && 9 !== e.which) && (e.preventDefault(), 
                    40 === e.which ? (L.activeIdx = (L.activeIdx + 1) % L.matches.length, L.$digest()) : 38 === e.which ? (L.activeIdx = (L.activeIdx > 0 ? L.activeIdx : L.matches.length) - 1, 
                    L.$digest()) : 13 === e.which || 9 === e.which ? L.$apply(function() {
                        L.select(L.activeIdx);
                    }) : 27 === e.which && (e.stopPropagation(), D(), L.$digest()));
                }), l.bind("blur", function(e) {
                    m = !1;
                });
                var E = function(e) {
                    l[0] !== e.target && (D(), L.$digest());
                };
                r.bind("click", E), u.$on("$destroy", function() {
                    r.unbind("click", E), b && H.remove(), w.remove();
                });
                var H = e(w)(L);
                b ? r.find("body").append(H) : l.after(H);
            }
        };
    } ]).directive("typeaheadPopup", function() {
        return {
            restrict: "EA",
            scope: {
                matches: "=",
                query: "=",
                active: "=",
                position: "=",
                select: "&"
            },
            replace: !0,
            templateUrl: "template/typeahead/typeahead-popup.html",
            link: function(e, t, n) {
                e.templateUrl = n.templateUrl, e.isOpen = function() {
                    return e.matches.length > 0;
                }, e.isActive = function(t) {
                    return e.active == t;
                }, e.selectActive = function(t) {
                    e.active = t;
                }, e.selectMatch = function(t) {
                    e.select({
                        activeIdx: t
                    });
                };
            }
        };
    }).directive("typeaheadMatch", [ "$templateRequest", "$compile", "$parse", function(e, t, n) {
        return {
            restrict: "EA",
            scope: {
                index: "=",
                match: "=",
                query: "="
            },
            link: function(a, r, i) {
                var s = n(i.templateUrl)(a.$parent) || "template/typeahead/typeahead-match.html";
                e(s).then(function(e) {
                    t(e.trim())(a, function(e) {
                        r.replaceWith(e);
                    });
                });
            }
        };
    } ]).filter("typeaheadHighlight", function() {
        function e(e) {
            return e.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
        }
        return function(t, n) {
            return n ? ("" + t).replace(new RegExp(e(n), "gi"), "<strong>$&</strong>") : t;
        };
    }), !angular.$$csp() && angular.element(document).find("head").prepend('<style type="text/css">.ng-animate.item:not(.left):not(.right){-webkit-transition:0s ease-in-out left;transition:0s ease-in-out left}</style>');
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e() {
            "all" != window.debugging && "kube" != window.debugging || console.debug.apply(console, arguments);
        }
        function t(e) {
            var t, n, a, r;
            if (0 === e.length) return 0;
            for (t = 0, n = 0, r = e.length; n < r; n++) a = e.charCodeAt(n), t = (t << 5) - t + a, 
            t |= 0;
            return Math.abs(t);
        }
        function a(e, t) {
            for (var n, a, r = 0, i = e.length - 1; r <= i; ) if (n = (r + i) / 2 | 0, a = e[n], 
            a < t) r = n + 1; else {
                if (!(a > t)) return n;
                i = n - 1;
            }
            return r;
        }
        function r(e) {
            var n = this, r = [];
            n.add = function(n, i) {
                var s, o, u, l, c = n.length;
                for (o = 0; o < c; o++) s = t("" + n[o]) % e, u = r[s], void 0 === u && (u = r[s] = []), 
                l = a(u, i), u[l] != i && u.splice(l, 0, i);
            }, n.get = function(n) {
                var a = r[t("" + n) % e];
                return a ? a.slice() : [];
            }, n.all = function(n) {
                var a, i, s, o, u, l, c, d, m, f;
                for (i = 0, u = n.length; i < u; i++) {
                    if (a = t("" + n[i]) % e, s = r[a], !s) {
                        o = [];
                        break;
                    }
                    if (o) for (m = 0, f = 0, l = o.length; m < l; ) c = o[m], d = s[m + f], d < c ? f += 1 : c !== d ? (o.splice(m, 1), 
                    l -= 1) : m += 1; else o = s.slice();
                }
                return o || [];
            };
        }
        function i() {
            var e = "weakmap" + _;
            _ += 1;
            var t = this;
            t.delete = function(t) {
                var n = t[g];
                n && delete n[e];
            }, t.has = function(t) {
                var n = t[g];
                return n && e in n;
            }, t.get = function(t) {
                var n = t[g];
                if (n) return n[e];
            }, t.set = function(t, n) {
                var a = t[g];
                a || (a = function() {}, Object.defineProperty(t, g, {
                    enumerable: !1,
                    configurable: !1,
                    writable: !1,
                    value: a
                })), a[e] = n;
            };
        }
        function s(e) {
            var t, n, a = {
                "": d
            };
            for (t = 0, n = e.length; t < n; t++) a[e[t].type] = e[t], a[e[t].kind] = e[t];
            return a;
        }
        function o(e) {
            var t = e[0];
            if (t && "object" == typeof t) if (t.metadata) {
                if (t.metadata.selfLink) return t.metadata.selfLink;
                e = [ t.kind, t.metadata.name, t.metadata.namespace ];
            } else t.name && t.kind && (e = [ t.kind, t.name, t.namespace ]); else if (t && "/" == t[0]) return t;
            var n = m[e[0]] || m[""], a = n.api;
            return !n.global && e[2] && (a += "/namespaces/" + e[2]), a += "/" + n.type, e[1] && (a += "/" + e[1]), 
            a;
        }
        var u = n(32), l = "/api/v1", c = "/oapi/v1", d = {
            api: l,
            create: 0
        }, m = s([ {
            kind: "DeploymentConfig",
            type: "deploymentconfigs",
            api: c
        }, {
            kind: "Endpoints",
            type: "endpoints",
            api: l
        }, {
            kind: "Group",
            type: "groups",
            api: c,
            global: !0
        }, {
            kind: "Image",
            type: "images",
            api: c,
            global: !0
        }, {
            kind: "ImageStream",
            type: "imagestreams",
            api: c
        }, {
            kind: "ImageStreamImage",
            type: "imagestreamimages",
            api: c
        }, {
            kind: "ImageStreamTag",
            type: "imagestreamtags",
            api: c
        }, {
            kind: "LocalResourceAccessReview",
            type: "localresourceaccessreviews",
            api: c
        }, {
            kind: "Namespace",
            type: "namespaces",
            api: l,
            global: !0,
            create: -100
        }, {
            kind: "Node",
            type: "nodes",
            api: l,
            global: !0
        }, {
            kind: "Pod",
            type: "pods",
            api: l,
            create: -20
        }, {
            kind: "PolicyBinding",
            type: "policybindings",
            api: c
        }, {
            kind: "RoleBinding",
            type: "rolebindings",
            api: c
        }, {
            kind: "Route",
            type: "routes",
            api: c
        }, {
            kind: "PersistentVolume",
            type: "persistentvolumes",
            api: l,
            global: !0,
            create: -100
        }, {
            kind: "PersistentVolumeClaim",
            type: "persistentvolumeclaims",
            api: l,
            create: -50
        }, {
            kind: "Project",
            type: "projects",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ProjectRequest",
            type: "projectrequests",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ReplicationController",
            type: "replicationcontrollers",
            api: l,
            create: -60
        }, {
            kind: "Service",
            type: "services",
            api: l,
            create: -80
        }, {
            kind: "User",
            type: "users",
            api: c,
            global: !0
        } ]), f = /^[a-z0-9]([-a-z0-9]*[a-z0-9])?$/, p = /^[a-z0-9_.]([-a-z0-9@._]*[a-z0-9._])?$/, h = "120s", g = Math.random().toString(36).slice(2), _ = 1;
        u.module("kubeClient", []).value("KUBE_SCHEMA", m).value("KUBE_NAME_RE", f).factory("kubeLoader", [ "$q", "$timeout", "KubeWatch", "KubeRequest", "KUBE_SCHEMA", function(e, t, n, a, r) {
            function i(e, t, a) {
                var r, i = m[e] || m[""], s = i.api;
                return !i.global && t && (s += "/namespaces/" + t), s += "/" + i.type, s in L || (r = new n(s, l), 
                r.what = e, r.global = i.global, r.namespace = t, r.cancelWatch = r.cancel, r.cancel = function() {
                    var e = L[s];
                    e && (e.references -= 1, e.references <= 0 && (e.cancelWatch(), delete L[s]));
                }, L[s] = r), L[s].references += a, L[s];
            }
            function s(t, n) {
                var a = $.namespace;
                if (!u.isArray(a)) return i(t, a, n);
                var r = [];
                u.forEach(a, function(e) {
                    r.push(i(t, e, n));
                });
                var s = e.all(r);
                return s.cancel = function() {
                    u.forEach(r, function(e) {
                        e.cancel();
                    });
                }, s;
            }
            function l(e) {
                if (null === w ? w = e : w.push.apply(w, e), e.length > 0) {
                    if (null !== D) return;
                    D = window.setTimeout(p, 150);
                }
                d(f);
            }
            function c(e) {
                var t;
                if (e && e.metadata && (t = parseInt(e.metadata.resourceVersion, 10)), !isNaN(t)) return t;
            }
            function d(e) {
                var t = w;
                if (w = null, t) {
                    var n, a, r, i, s, u, l = {}, d = {};
                    for (n = 0, a = t.length; n < a; n++) i = t[n].object, i && (r = o([ i ]), "DELETED" == t[n].type ? (delete k[r], 
                    d[r] = i) : t[n].checkResourceVersion ? (s = c(i), u = c(k[r]), (!s || !u || s >= u) && (l[r] = i, 
                    k[r] = i)) : (l[r] = i, k[r] = i));
                    e(l, d);
                }
            }
            function f() {
                var e, t, n;
                for (e = 0, t = M.length; e < t; e++) n = M[e], n && n.apply(y, arguments);
            }
            function p() {
                D = null, d(f);
            }
            function h() {
                var e;
                window.clearTimeout(D), D = null, w = null;
                var t = L;
                L = {}, u.forEach(t, function(e) {
                    e.cancelWatch();
                });
                for (e in k) delete k[e];
                for (e in $) delete $[e];
                $.namespace = null, f();
            }
            function g(e, t, n) {
                l(e.map(function(e) {
                    return n && (e.kind = n), {
                        type: t ? "DELETED" : "ADDED",
                        object: e,
                        checkResourceVersion: !0
                    };
                })), d(f);
            }
            function _() {
                var t = o(arguments), n = new a("GET", t), r = n.then(function(e) {
                    n = null;
                    var t = e.data;
                    return t && t.kind ? t.kind.indexOf("List") === t.kind.length - 4 ? (g(t.items, !1, t.kind.slice(0, -4)), 
                    t.items) : (g([ t ]), t) : null;
                }, function(t) {
                    n = null;
                    var a = t.data;
                    return e.reject(a || t);
                });
                return r.cancel = function(e) {
                    n.cancel(e);
                }, r;
            }
            function v(e) {
                window.clearTimeout(D), D = null;
                var t = {};
                null === e ? t = null : u.isArray(e) ? u.forEach(e, function(e) {
                    t[e] = !0;
                }) : t[e] = !0, $.namespace = e;
                var n = {}, a = {};
                d(function(e, t) {
                    n = e, a = t;
                });
                var r, i;
                for (i in k) r = k[i].metadata, !t || !r.namespace || r.namespace in t || (a[i] = k[i], 
                delete k[i], delete n[i]);
                var o, l, c = [];
                for (o in L) l = L[o], (!t && l.namespace || t && !l.global && !(l.namespace in t)) && (l.cancelWatch(), 
                delete L[o], c.push(l));
                f(n, a), u.forEach(c, function(e) {
                    s(e.what, e.references);
                });
            }
            function b(e, t) {
                t && (t.$on ? t.$on("destroy", function() {
                    e.cancel();
                }) : console.warn("invalid until passed to watch", t));
            }
            var y, M = [], $ = {
                namespace: null
            }, L = {}, k = {}, w = null, D = null;
            return y = {
                watch: function(e, t) {
                    var n = s(e, 1);
                    return b(n, t), n;
                },
                load: function() {
                    return _.apply(this, arguments);
                },
                limit: function(e) {
                    "namespace" in e && v(e.namespace);
                },
                reset: h,
                listen: function(e, n) {
                    e.early ? M.unshift(e) : M.push(e);
                    var a = t(function() {
                        a = null, e.call(y, k);
                    }, 0), r = {
                        cancel: function() {
                            var n, r;
                            for (t.cancel(a), a = null, n = 0, r = M.length; n < r; n++) M[n] === e && (M[n] = null);
                        }
                    };
                    return b(r, n), r;
                },
                handle: function(e, t, n) {
                    u.isArray(e) || (e = [ e ]), g(e, t, n);
                },
                resolve: function() {
                    return o(arguments);
                },
                objects: k,
                limits: $
            };
        } ]).factory("kubeSelect", [ "kubeLoader", function(e) {
            function t(e, t) {
                v += 1, e ? h && a(e) : h = null;
            }
            function n() {
                h = new r(262139), a(e.objects);
            }
            function a(e) {
                var t, n, a, r, i, s;
                for (t in e) {
                    n = e[t];
                    for (a in p) s = p[a], s.digest ? (r = s.digest.call(null, n), r && h.add([ r ], t)) : s.digests && (i = s.digests.call(null, n), 
                    i.length && h.add(i, t));
                }
            }
            function s(e) {
                var t = _.get(e);
                return t && t.version === v || (t = {
                    version: v,
                    length: t ? t.length : void 0
                }, _.set(e, t)), t;
            }
            function o(e) {
                return function() {
                    var t = s(this), r = Array.prototype.slice.call(arguments), i = e.name + ": " + JSON.stringify(r);
                    if (i in t) return t[i];
                    var o;
                    return e.filter ? o = e.filter.apply(this, r) : (h || n(), t.indexed || (a(this), 
                    t.indexed = !0), e.digests ? o = d(e, this, r) : e.digest ? o = c(e, this, r) : (console.warn("invalid filter: " + e.name), 
                    o = {})), t[i] = o, o;
                };
            }
            function u() {
                var e, t = {
                    length: {
                        enumerable: !1,
                        configurable: !0,
                        get: function() {
                            return s(this).length;
                        }
                    }
                };
                for (e in p) t[e] = {
                    enumerable: !1,
                    configurable: !0,
                    value: o(p[e])
                };
                return t;
            }
            function l(e, t, n) {
                var a, r;
                if (void 0 === t) {
                    t = 0;
                    for (a in e) t += 1;
                }
                return g = g || u(), Object.defineProperties(e, g), r = s(e), r.length = t, r.selection = e, 
                r.indexed = n, e;
            }
            function c(e, t, n) {
                var a, r, i, s, o, u, c = {}, d = 0;
                for (i = e.digest.apply(null, n), s = null !== i && void 0 !== i ? h.get(i) : [], 
                a = 0, r = s.length; a < r; a++) o = s[a], u = t[o], u && i === e.digest.call(null, u) && (c[o] = u, 
                d += 1);
                return l(c, d, !0);
            }
            function d(e, t, n) {
                var a, r, i, s, o, u, c, d, m, f, p, g, _ = {}, v = 0;
                for (a = e.digests.apply(null, n), r = a.length, r > 0 ? (d = h.all(a), a.sort()) : d = [], 
                m = 0, f = d.length; m < f; m++) if (o = d[m], c = t[o]) {
                    for (i = e.digests.call(null, c), i.sort(), u = !1, p = 0, g = i.length; !u && p < g; p++) if (a[0] === i[p]) for (u = !0, 
                    s = 0; u && s < r; s++) a[s] !== i[p + s] && (u = !1);
                    u && (_[o] = c, v += 1);
                }
                return l(_, v, !0);
            }
            function m(e, t) {
                "function" == typeof t && (e = {
                    name: e,
                    filter: t
                }), p[e.name] = e, h = null, g = null, v += 1;
            }
            function f(t) {
                var n, a = !1;
                if (void 0 === t ? (t = e.objects, a = !0) : t || (t = b), "object" != typeof t && (console.warn("Pass resources or resource dicts or null to kubeSelect()"), 
                t = b), n = s(t), n.selection) return n.selection;
                var r, i;
                return "string" == typeof t.kind ? (n.single || (r = t.meta || {}, i = {}, i[r.selfLink || 1] = t, 
                n.single = l(i, void 0, !1)), n.single) : l(t, void 0, a);
            }
            var p = {}, h = null, g = null, _ = new i(), v = 1;
            t.early = !0, e.listen(t), m("one", function() {
                var e;
                for (e in this) return this[e];
                return null;
            }), m("extend", function(e) {
                var t;
                for (t in this) e[t] = this[t];
                return e;
            }), m({
                name: "label",
                digests: function(e) {
                    var t = [];
                    if (!e) return t;
                    var n, a = e.metadata, r = a ? a.labels : e;
                    for (n in r || []) t.push(n + "=" + r[n]);
                    return t;
                }
            }), m({
                name: "namespace",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.namespace : null;
                }
            }), m({
                name: "name",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.name : null;
                }
            }), m({
                name: "kind",
                digest: function(e) {
                    return e ? "string" == typeof e ? e : e.kind : null;
                }
            }), m({
                name: "host",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.spec;
                    return t ? t.nodeName : null;
                }
            }), m({
                name: "uid",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.uid : null;
                }
            }), m({
                name: "statusPhase",
                digest: function(e) {
                    var t;
                    return "string" == typeof e ? e : (t = e.status || {}, t.phase ? t.phase : null);
                }
            });
            var b = {};
            return f.register = m, f;
        } ]).factory("kubeMethods", [ "$q", "KUBE_SCHEMA", "KubeRequest", "kubeLoader", function(t, n, a, r) {
            function i(e, t) {
                var a = n[e.kind].create || 0, r = n[t.kind].create || 0;
                return a - r;
            }
            function s(n, s) {
                function l() {
                    var t = n.shift();
                    if (!t) return void c.resolve();
                    var i = o([ t.kind, null, s || "default" ]);
                    i += "?timeout=" + h, f = new a("POST", i, JSON.stringify(t)).then(function(t) {
                        var n;
                        e("created resource:", i, t.data), t.data.kind && ("Project" == t.data.kind && (n = t.data.metadata || {}, 
                        delete n.selfLink), r.handle(t.data)), l();
                    }, function(n) {
                        var a = n.data;
                        "Namespace" != t.kind || !a || 409 !== a.code && 403 !== a.code ? (e("create failed:", i, a || n), 
                        c.reject(a || n)) : (e("skipping namespace creation"), l());
                    });
                }
                var c = t.defer(), d = c.promise, f = null;
                u.isArray(n) || (n = "List" == n.kind ? n.items : [ n ]);
                var p = !1, g = !1;
                return n.forEach(function(e) {
                    var t = e.metadata || {};
                    "Namespace" != e.kind && "Project" != e.kind || t.name !== s || (p = !0);
                    var n = m[e.kind] || m[""];
                    n.global || (g = !0);
                }), n = n.slice(), s && g && !p && n.unshift({
                    apiVersion: "v1",
                    kind: "Namespace",
                    metadata: {
                        name: s
                    }
                }), n.sort(i), l(), d.cancel = function() {
                    f && f.cancel();
                }, d;
            }
            function l() {
                var n = o(arguments), i = r.objects[n];
                n += "?timeout=" + h;
                var s = new a("DELETE", n);
                return s.then(function() {
                    e("deleted resource:", n, i), i && r.handle(i, !0);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function c(n, i) {
                var s = o([ n ]);
                s += "?timeout=" + h;
                var u = JSON.stringify(i), l = {
                    headers: {
                        "Content-Type": "application/strategic-merge-patch+json"
                    }
                }, c = new a("PATCH", s, u, l);
                return c.then(function(t) {
                    e("patched resource:", s, t.data), t.data.kind && r.handle(t.data);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function d(e, n, r, i) {
                var s = o([ n ]);
                "GET" != e && (s += "?timeout=" + h);
                var u = new a(e, s, JSON.stringify(r), i);
                return u.then(function(e) {
                    var t = e.data;
                    return t || e;
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function g(e, t, n) {
                return d("PUT", e, t, n);
            }
            function _(e, t, n) {
                return d("POST", e, t, n);
            }
            function v(e, n) {
                var a, r = t.defer(), i = [];
                n || (n = {});
                var s = e.metadata;
                if (s) {
                    if (a = null, void 0 !== s.name) {
                        var o = "User" == e.kind ? p : f;
                        s.name ? o.test(s.name) || (a = new Error("The name contains invalid characters")) : a = new Error("The name cannot be empty");
                    }
                    a && (a.target = n["metadata.name"], i.push(a)), a = null, void 0 !== s.namespace && (s.namespace ? f.test(s.namespace) || (a = new Error("The name contains invalid characters")) : a = new Error("The namespace cannot be empty")), 
                    a && (a.target = n["metadata.namespace"], i.push(a));
                }
                return i.length ? r.reject(i) : r.resolve(), r.promise;
            }
            return {
                create: s,
                delete: l,
                check: v,
                patch: c,
                post: _,
                put: g
            };
        } ]).provider("KubeRequest", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeRequest") : e.invoke(t);
            }
            var t = this;
            t.KubeRequestFactory = "MissingKubeRequest", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeRequestFactory);
            } ];
        } ]).factory("MissingKubeRequest", [ function() {
            return function(e, t) {
                throw new Error("no KubeRequestFactory set");
            };
        } ]).provider("KubeSocket", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeSocket") : e.invoke(t);
            }
            var t = this;
            t.KubeSocketFactory = "MissingKubeSocket", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeSocketFactory);
            } ];
        } ]).factory("MissingKubeSocket", [ function() {
            return function(e, t) {
                throw Error("no KubeSocketFactory set");
            };
        } ]).provider("KubeWatch", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeWatch") : e.invoke(t);
            }
            var t = this;
            t.KubeWatchFactory = "MissingKubeWatch", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeWatchFactory);
            } ];
        } ]).factory("MissingKubeWatch", [ function() {
            return function(e, t) {
                throw Error("no KubeWatchFactory set");
            };
        } ]).provider("KubeDiscoverSettings", [ function() {
            function e(e, t) {
                return u.isString(t) ? e.get(t, "KubeDiscoverSettings") : e.invoke(t);
            }
            var t = this;
            t.KubeDiscoverSettingsFactory = "MissingKubeDiscoverSettings", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeDiscoverSettingsFactory);
            } ];
        } ]).factory("MissingKubeDiscoverSettings", [ function() {
            return function(e, t) {
                throw Error("no KubeDiscoverSettingsFactory set");
            };
        } ]);
    }();
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t) {
            var n, a, i, s, o = [], u = e.length;
            for (i = 0; i < u; i++) if (n = e[i].querySelectorAll(t)) for (a = 0, s = n.length; a < s; a++) o.push(n[a]);
            return r.element(o);
        }
        function t(e, t) {
            var n, a = null, i = e.length;
            for (n = 0; !a && n < i; n++) a = e[n].querySelector(t);
            return r.element(a);
        }
        function a(n, a, i, s, o) {
            function u(e) {
                if (!L) return y = e, $ ? void o.cancel() : void (null === y ? (h(), b()) : y === !0 ? (h(), 
                v(), o.result(!0, M)) : y === !1 ? (v(), c(M), o.result(!1, M)) : console.warn("invalid dialog state", y));
            }
            function l() {
                o = null, s = null, h(), v();
            }
            function c(e) {
                h(), r.isArray(e) || (e = [ e ]), e.forEach(function(e) {
                    var a = null;
                    e.target && (a = t(n, e.target)), a && a[0] ? m(a, e) : d(e);
                });
            }
            function d(e) {
                var s = r.element("<div class='alert alert-danger dialog-error'>"), o = e.message || e.toString();
                console.warn(o), s.text(o), s.prepend(r.element("<span class='fa fa-exclamation-triangle'>"));
                var u = t(n, a);
                u.length ? i ? u.append(s) : u.prepend(s) : n.append(s);
            }
            function m(e, t) {
                var n = r.element("<div class='dialog-error help-block'>");
                n.text(t.message || t.toString());
                var a = e.parent();
                a.addClass("has-error"), e.after(n), a.on("keypress change", f);
            }
            function f(e) {
                for (var t = e.target; t !== this; ) p(r.element(t)), t = t.parentNode;
            }
            function p(t) {
                var n = t.parent();
                e(n, ".dialog-error").remove(), n.removeClass("has-error"), n.off("keypress change", f);
            }
            function h() {
                var t = e(n, ".dialog-error");
                r.forEach(t, function(e) {
                    p(r.element(e));
                });
            }
            function g(e) {
                return s.cancel && s.cancel(), $ = !0, e.stopPropagation(), e.preventDefault(), 
                !1;
            }
            function _(e) {
                var t = e.message || e;
                "string" == typeof t || "number" == typeof t ? D.text(t) : t || D.text("");
            }
            function v() {
                for (var e; ;) {
                    if (e = k.pop(), !e) break;
                    e.removeAttr("disabled");
                }
                w.remove(), t(n, ".btn-cancel").off("click", g);
            }
            function b() {
                function i(e) {
                    var t = r.element(e);
                    t.attr("disabled") || s.cancel && t.hasClass("btn-cancel") || (k.push(t), t.attr("disabled", "disabled"));
                }
                v(), t(n, a).prepend(w), r.forEach(e(n, ".form-control"), i), r.forEach(e(n, ".form-checkbox"), i), 
                r.forEach(e(n, ".btn"), i), t(n, ".btn-cancel").on("click", g);
            }
            var y = null, M = null, $ = !1, L = !1, k = [], w = r.element("<div class='dialog-wait-ct pull-left'>");
            w.append(r.element("<div class='spinner spinner-sm'>"));
            var D = r.element("<span>");
            return w.append(D), this.detach = l, s ? (s.then(function(e) {
                M = e, s && u(!0);
            }, function(e) {
                M = e, s && u(!1);
            }, function(e) {
                s && _(e);
            }), void window.setTimeout(function() {
                s && o && null === y && (u(null), o.$digest());
            }, 0)) : void l();
        }
        var r = n(32);
        n(35), r.module("ui.cockpit", [ "ui.bootstrap" ]).directive("modalDialog", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<modal-group><ng-transclude></ng-transclude></modal-group>",
                link: function(e, t, n) {
                    e.cancel = function() {
                        e.$dismiss();
                    }, e.result = function(t, n) {
                        t && e.$close(n);
                    };
                }
            };
        } ]).directive("modalGroup", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<ng-transclude></ng-transclude>",
                link: function(n, r, i) {
                    function s() {
                        u && u.detach(), u = null;
                    }
                    function o() {
                        n.cancel();
                    }
                    var u = null;
                    n.complete = function(t) {
                        var i = n.modalGroupButtonSel || ".modal-footer", o = n.modalGroupErrorAfter || !1;
                        s(), t && t.then || (t = e(t)), u = new a(r, i, o, t, n);
                    }, n.failure = function() {
                        var t, a = arguments.length;
                        if (0 === a ? t = null : 1 === a ? t = arguments[0] : (t = [], t.push.apply(t, arguments)), 
                        !t) return void s();
                        var r = e.defer();
                        r.reject(t), n.complete(r.promise);
                    };
                    var l = t(r, ".btn-cancel");
                    l.on("click", o), n.$on("$routeChangeStart", o), n.$on("$destroy", function() {
                        l.off("click", o), s();
                    });
                }
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(t, n, a) {
            return t && t.classList && t.classList.contains(n) || t && t.tagName === a || t && e(t.parentNode, n, a);
        }
        var t = n(32);
        n(45), n(46), n(47), n(48), n(49), n(50), n(51), n(52), n(53), n(54), n(55), n(56), 
        n(57), n(58), t.module("kubernetes.listing", []).directive("listingTable", [ function() {
            return {
                restrict: "A",
                link: function(e, t, n) {}
            };
        } ]).factory("ListingState", [ function() {
            return function(n) {
                function a(t) {
                    return !(t && e(t.target, "btn", "li"));
                }
                var r = this, i = {};
                r.selected = {}, r.enableActions = !1, r.hasSelected = function(e) {
                    return !t.equals({}, r.selected);
                }, r.expanded = function(e) {
                    if (t.isUndefined(e)) {
                        for (e in i) return !0;
                        return !1;
                    }
                    return e in i;
                }, r.toggle = function(e, t) {
                    var n;
                    return r.enableActions ? void t.stopPropagation() : void (e && (n = !(e in i), n ? r.expand(e, t) : r.collapse(e, t)));
                }, r.expand = function(e, t) {
                    i[e] = !0, t && t.stopPropagation();
                }, r.activate = function(e, t) {
                    a(t) && (r.expanded(e) ? r.collapse(e) : n.$emit("activate", e));
                }, r.collapse = function(e, t) {
                    e ? delete i[e] : Object.keys(i).forEach(function(e) {
                        delete i[e];
                    }), t && t.stopPropagation();
                };
            };
        } ]).directive("listingPanel", [ function() {
            return {
                restrict: "A",
                scope: !0,
                link: function(e, t, n) {
                    var a = "main";
                    e.tab = function(e, t) {
                        return t && (a = e, t.stopPropagation()), a === e;
                    };
                },
                templateUrl: function(e, t) {
                    var n = t.kind;
                    return "views/" + n.toLowerCase() + "-panel.html";
                }
            };
        } ]);
    }();
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Image</a> </li> <li ng-class="{active: tab(\'config\')}"> <a ng-click="tab(\'config\', $event)" translate>Container</a> </li> <li ng-class="{active: tab(\'meta\')}"> <a ng-click="tab(\'meta\', $event)" translate>Metadata</a> </li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <div class="listing-ct-body" ng-show="tab(\'config\')"> <registry-image-config image="image"> </registry-image-config> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeUser(projects(), groups(), user())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyUser(user())"></button> </div> <div class="listing-ct-head"> <h3><i class="pficon pficon-user"></i>{{ user().metadata.name }}</h3> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>User</a></li> <li ng-class="{active: tab(\'membership\')}"> <a ng-click="tab(\'membership\', $event); tabbed = true" translate>Membership</a></li> </ul> </div> <div class="listing-ct-body project-panel"> <div ng-show="tab(\'main\')"> <div class="user-body"> <dl> <dt translate>Identities</dt> <dd>{{ user().identities }}</dd> </dl> </div> </div> <div class="project-panel" ng-show="tab(\'membership\')"> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Membership</th> <th translate></th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="member in getProjectsWithMember(projects(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td> <div ng-if="member.kind == &quot;Project&quot;" class="btn-group bootstrap-select namespace-filter" dropdown> <button class="btn btn-default dropdown-toggle" type="button" dropdown-toggle> <span class="pull-left"> <span ng-if="isRoles(user(), member)"> {{ getRegistryRoles(user(), member).join() }} </span> </span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="roleMp in getRegistryRolesMap() track by roleMp.displayRole" ng-class="{ checked: isRegistryRole(user(), roleMp.displayRole, member) }"> <a ng-click="changeRole(user(), roleMp, getRegistryRoles(user(), member), member)"> {{ roleMp.displayRole }} </a> </li> </ul> </div> </td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeMemberFromParent(user(), member)"></i> </a> </td> </tr> </tbody> <tbody colspan="3" ng-repeat="member in getGroupsWithMember(groups(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td></td> <td><a class="pull-right close-icon" ng-click="removeMemberFromParent(user(), member)"> <i translate class="pficon-close"></i> </a> </td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" ng-click="addMemberToParent(user())"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>Add Membership</span> </a> </td> </tr> </thead> </table> </div></div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/user-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Service</a></li> <li ng-class="{active: tab(\'endpoints\')}"><a ng-click="tab(\'endpoints\', $event)" translate>Endpoints</a></li> </ul> </div> <div class="listing-ct-body" service-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" service-endpoint ng-show="tab(\'endpoints\')"> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/service-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Pod</a></li> <li ng-class="{active: tab(\'containers\')}"><a ng-click="tab(\'containers\', $event)">Containers</a></li> <li ng-class="{active: tab(\'logs\')}"> <a ng-click="tab(\'logs\', $event); tabbed = true">Logs</a></li> <li ng-class="{active: tab(\'shell\')}"> <a ng-click="tab(\'shell\', $event); tabbed = true">Shell</a></li> <li ng-class="{active: tab(\'volumes\')}"> <a ng-click="tab(\'volumes\', $event); tabbed = true">Volumes</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-pod-body ng-init="pod = item"> </kube-pod-body> </div> <div class="listing-ct-body" ng-show="tab(\'containers\')"> <kube-container-body ng-repeat="container in containers(item)"> </kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-if="item.status.phase == \'Running\' && container.status.state.running" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div> </div> <div class="listing-ct-body" ng-show="tab(\'volumes\')"> <div class="container-fluid well" ng-repeat="podVolume in volumesForPod(item)" data-id="{{ podVolume.name }}"> <dl ng-if="!podVolume.persistentVolumeClaim" volume-body volume="podVolume"></dl> <dl ng-if="podVolume.persistentVolumeClaim" pvc-body settings="settings" item="claimFromVolumeSource(podVolume.persistentVolumeClaim, item.metadata.namespace)"></dl> <dl> <dt translate>Mount Location</dt> <dd> <span ng-if="!podVolume.mounts" translate>None</span> <dl class="full-width" ng-if="podVolume.mounts"> <dt ng-repeat-start="(name, data) in podVolume.mounts">{{ name }}</dt> <dd ng-repeat-end>{{ data.mountPath }}</dd> </dl> </dd> </dl> </div> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/pod-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Adjust" class="btn btn-default pficon pficon-edit" ng-click="modifyRoute(item)"></button>\n<button title="Delete" class="route-delete btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"> </button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Route</a></li> </ul> </div> <div class="listing-ct-body" route-body ng-show="tab(\'main\')"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/route-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deletePV(item)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-if="canEdit(item)" ng-click="modifyPV(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Volume</a> </li> <li ng-class="{active: tab(\'claim\')}"> <a ng-click="tab(\'claim\', $event)" translate>Claim</a> </li> </ul> </div> <div pv-body class="listing-ct-body" ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" ng-show="tab(\'claim\')" pv-claim></div> </div> ';
    n.run([ "$templateCache", function(e) {
        e.put("views/pv-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Image stream</a></li> <li ng-class="{active: tab(\'meta\')}" ng-if="stream.metadata.annotations"> <a ng-click="tab(\'meta\', $event)">Metadata</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push imagestream="stream" settings="settings"> </registry-imagestream-push> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-body"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/default-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteNode(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Node</a></li> <li ng-class="{active: tab(\'capacity\')}"><a ng-click="tab(\'capacity\', $event)">Capacity</a></li> </ul> </div> <div node-alerts></div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <div class="row" node-body></div> </div> <div class="listing-ct-body" ng-show="tab(\'capacity\')"> <div class="row" node-capacity></div> <div class="row" node-stats></div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/node-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeProject(project())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyProject(project())"></button> </div> <div class="listing-ct-body project-panel"> <p class="project-description" ng-if="project().metadata.annotations[\'openshift.io/description\']"> {{ project().metadata.annotations[\'openshift.io/description\'] }} </p> <div project-body> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/project-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Container</a></li> <li ng-class="{active: tab(\'logs\')}"> <a class="logs" ng-click="tab(\'logs\', $event); tabbed = true" translate>Logs</a></li> <li ng-class="{active: tab(\'shell\')}" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <a class="shell" ng-click="tab(\'shell\', $event); tabbed = true" translate>Shell</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-container-body></kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/container-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="deployment-delete btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Deployment Config</a></li> <li ng-class="{active: tab(\'template\')}" ng-if="item.spec.template"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" deploymentconfig-body ng-show="tab(\'main\')"></div> <div class="listing-ct-body" ng-show="tab(\'template\')" ng-if="item.spec.template"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/deploymentconfig-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeGroup(projects(), group())"></button> </div> <h3><i class="pficon pficon-users"></i>{{ group().metadata.name }}</h3> </div> <div class="listing-ct-body project-panel" ng-show="tab(\'main\')"> <div> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Group Members</th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="user in group().users"> <tr class="listing-ct-item inner-project-listing"> <td><i class="pficon-user"></i> {{ user }}</td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeUserFromGroup(user, group())"></i> </a></td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" disabled="disabled"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate ng-click="addUserToGroup(group())">Add Member</span> </a> </td> </tr> </thead> </table> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/group-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-entity btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button>\n<button title="Adjust" class="adjust-entity btn btn-default pficon pficon-edit" ng-click="modifyRC(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Replication Controller</a></li> <li ng-class="{active: tab(\'pods\')}"> <a ng-click="tab(\'pods\', $event)" translate>Pods</a></li> <li ng-class="{active: tab(\'template\')}"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" replicationcontroller-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" replicationcontroller-pods ng-show="tab(\'pods\')"> </div> <div class="listing-ct-body" ng-show="tab(\'template\')"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/replicationcontroller-panel.html", r);
    } ]), e.exports = r;
}, , , function(e, t, n) {
    "use strict";
    !function() {
        var e = n(32), t = n(62);
        n(39), e.module("kubernetes.date", [ "kubeClient" ]).factory("refreshEveryMin", [ "$rootScope", "$window", "kubeLoader", function(e, t, n) {
            var a = 0, r = 6e4, i = 500;
            return n.listen(function() {
                a = new Date().getTime();
            }), t.setInterval(function() {
                var t = new Date().getTime();
                t - a + i >= r && e.$applyAsync(), a = t;
            }, r), {};
        } ]).filter("dateRelative", [ "refreshEveryMin", function() {
            function e(e) {
                return e ? t(e).fromNow() : e;
            }
            return e.$stateful = !0, e;
        } ]);
    }();
}, function(e, t, n) {
    (function(e) {
        //! moment.js
        //! version : 2.10.6
        //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
        //! license : MIT
        //! momentjs.com
        !function(t, n) {
            e.exports = n();
        }(this, function() {
            "use strict";
            function t() {
                return On.apply(null, arguments);
            }
            function a(e) {
                On = e;
            }
            function r(e) {
                return "[object Array]" === Object.prototype.toString.call(e);
            }
            function i(e) {
                return e instanceof Date || "[object Date]" === Object.prototype.toString.call(e);
            }
            function s(e, t) {
                var n, a = [];
                for (n = 0; n < e.length; ++n) a.push(t(e[n], n));
                return a;
            }
            function o(e, t) {
                return Object.prototype.hasOwnProperty.call(e, t);
            }
            function u(e, t) {
                for (var n in t) o(t, n) && (e[n] = t[n]);
                return o(t, "toString") && (e.toString = t.toString), o(t, "valueOf") && (e.valueOf = t.valueOf), 
                e;
            }
            function l(e, t, n, a) {
                return xe(e, t, n, a, !0).utc();
            }
            function c() {
                return {
                    empty: !1,
                    unusedTokens: [],
                    unusedInput: [],
                    overflow: -2,
                    charsLeftOver: 0,
                    nullInput: !1,
                    invalidMonth: null,
                    invalidFormat: !1,
                    userInvalidated: !1,
                    iso: !1
                };
            }
            function d(e) {
                return null == e._pf && (e._pf = c()), e._pf;
            }
            function m(e) {
                if (null == e._isValid) {
                    var t = d(e);
                    e._isValid = !(isNaN(e._d.getTime()) || !(t.overflow < 0) || t.empty || t.invalidMonth || t.invalidWeekday || t.nullInput || t.invalidFormat || t.userInvalidated), 
                    e._strict && (e._isValid = e._isValid && 0 === t.charsLeftOver && 0 === t.unusedTokens.length && void 0 === t.bigHour);
                }
                return e._isValid;
            }
            function f(e) {
                var t = l(NaN);
                return null != e ? u(d(t), e) : d(t).userInvalidated = !0, t;
            }
            function p(e, t) {
                var n, a, r;
                if ("undefined" != typeof t._isAMomentObject && (e._isAMomentObject = t._isAMomentObject), 
                "undefined" != typeof t._i && (e._i = t._i), "undefined" != typeof t._f && (e._f = t._f), 
                "undefined" != typeof t._l && (e._l = t._l), "undefined" != typeof t._strict && (e._strict = t._strict), 
                "undefined" != typeof t._tzm && (e._tzm = t._tzm), "undefined" != typeof t._isUTC && (e._isUTC = t._isUTC), 
                "undefined" != typeof t._offset && (e._offset = t._offset), "undefined" != typeof t._pf && (e._pf = d(t)), 
                "undefined" != typeof t._locale && (e._locale = t._locale), In.length > 0) for (n in In) a = In[n], 
                r = t[a], "undefined" != typeof r && (e[a] = r);
                return e;
            }
            function h(e) {
                p(this, e), this._d = new Date(null != e._d ? e._d.getTime() : NaN), Fn === !1 && (Fn = !0, 
                t.updateOffset(this), Fn = !1);
            }
            function g(e) {
                return e instanceof h || null != e && null != e._isAMomentObject;
            }
            function _(e) {
                return e < 0 ? Math.ceil(e) : Math.floor(e);
            }
            function v(e) {
                var t = +e, n = 0;
                return 0 !== t && isFinite(t) && (n = _(t)), n;
            }
            function b(e, t, n) {
                var a, r = Math.min(e.length, t.length), i = Math.abs(e.length - t.length), s = 0;
                for (a = 0; a < r; a++) (n && e[a] !== t[a] || !n && v(e[a]) !== v(t[a])) && s++;
                return s + i;
            }
            function y() {}
            function M(e) {
                return e ? e.toLowerCase().replace("_", "-") : e;
            }
            function $(e) {
                for (var t, n, a, r, i = 0; i < e.length; ) {
                    for (r = M(e[i]).split("-"), t = r.length, n = M(e[i + 1]), n = n ? n.split("-") : null; t > 0; ) {
                        if (a = L(r.slice(0, t).join("-"))) return a;
                        if (n && n.length >= t && b(r, n, !0) >= t - 1) break;
                        t--;
                    }
                    i++;
                }
                return null;
            }
            function L(t) {
                var a = null;
                if (!Nn[t] && "undefined" != typeof e && e && e.exports) try {
                    a = Pn._abbr, n(64)("./" + t), k(a);
                } catch (e) {}
                return Nn[t];
            }
            function k(e, t) {
                var n;
                return e && (n = "undefined" == typeof t ? D(e) : w(e, t), n && (Pn = n)), Pn._abbr;
            }
            function w(e, t) {
                return null !== t ? (t.abbr = e, Nn[e] = Nn[e] || new y(), Nn[e].set(t), k(e), Nn[e]) : (delete Nn[e], 
                null);
            }
            function D(e) {
                var t;
                if (e && e._locale && e._locale._abbr && (e = e._locale._abbr), !e) return Pn;
                if (!r(e)) {
                    if (t = L(e)) return t;
                    e = [ e ];
                }
                return $(e);
            }
            function Y(e, t) {
                var n = e.toLowerCase();
                Un[n] = Un[n + "s"] = Un[t] = e;
            }
            function T(e) {
                return "string" == typeof e ? Un[e] || Un[e.toLowerCase()] : void 0;
            }
            function S(e) {
                var t, n, a = {};
                for (n in e) o(e, n) && (t = T(n), t && (a[t] = e[n]));
                return a;
            }
            function x(e, n) {
                return function(a) {
                    return null != a ? (E(this, e, a), t.updateOffset(this, n), this) : C(this, e);
                };
            }
            function C(e, t) {
                return e._d["get" + (e._isUTC ? "UTC" : "") + t]();
            }
            function E(e, t, n) {
                return e._d["set" + (e._isUTC ? "UTC" : "") + t](n);
            }
            function H(e, t) {
                var n;
                if ("object" == typeof e) for (n in e) this.set(n, e[n]); else if (e = T(e), "function" == typeof this[e]) return this[e](t);
                return this;
            }
            function j(e, t, n) {
                var a = "" + Math.abs(e), r = t - a.length, i = e >= 0;
                return (i ? n ? "+" : "" : "-") + Math.pow(10, Math.max(0, r)).toString().substr(1) + a;
            }
            function A(e, t, n, a) {
                var r = a;
                "string" == typeof a && (r = function() {
                    return this[a]();
                }), e && (Rn[e] = r), t && (Rn[t[0]] = function() {
                    return j(r.apply(this, arguments), t[1], t[2]);
                }), n && (Rn[n] = function() {
                    return this.localeData().ordinal(r.apply(this, arguments), e);
                });
            }
            function O(e) {
                return e.match(/\[[\s\S]/) ? e.replace(/^\[|\]$/g, "") : e.replace(/\\/g, "");
            }
            function P(e) {
                var t, n, a = e.match(Vn);
                for (t = 0, n = a.length; t < n; t++) Rn[a[t]] ? a[t] = Rn[a[t]] : a[t] = O(a[t]);
                return function(r) {
                    var i = "";
                    for (t = 0; t < n; t++) i += a[t] instanceof Function ? a[t].call(r, e) : a[t];
                    return i;
                };
            }
            function I(e, t) {
                return e.isValid() ? (t = F(t, e.localeData()), qn[t] = qn[t] || P(t), qn[t](e)) : e.localeData().invalidDate();
            }
            function F(e, t) {
                function n(e) {
                    return t.longDateFormat(e) || e;
                }
                var a = 5;
                for (Wn.lastIndex = 0; a >= 0 && Wn.test(e); ) e = e.replace(Wn, n), Wn.lastIndex = 0, 
                a -= 1;
                return e;
            }
            function N(e) {
                return "function" == typeof e && "[object Function]" === Object.prototype.toString.call(e);
            }
            function U(e, t, n) {
                sa[e] = N(t) ? t : function(e) {
                    return e && n ? n : t;
                };
            }
            function V(e, t) {
                return o(sa, e) ? sa[e](t._strict, t._locale) : new RegExp(W(e));
            }
            function W(e) {
                return e.replace("\\", "").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function(e, t, n, a, r) {
                    return t || n || a || r;
                }).replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
            }
            function q(e, t) {
                var n, a = t;
                for ("string" == typeof e && (e = [ e ]), "number" == typeof t && (a = function(e, n) {
                    n[t] = v(e);
                }), n = 0; n < e.length; n++) oa[e[n]] = a;
            }
            function R(e, t) {
                q(e, function(e, n, a, r) {
                    a._w = a._w || {}, t(e, a._w, a, r);
                });
            }
            function z(e, t, n) {
                null != t && o(oa, e) && oa[e](t, n._a, n, e);
            }
            function B(e, t) {
                return new Date(Date.UTC(e, t + 1, 0)).getUTCDate();
            }
            function G(e) {
                return this._months[e.month()];
            }
            function J(e) {
                return this._monthsShort[e.month()];
            }
            function K(e, t, n) {
                var a, r, i;
                for (this._monthsParse || (this._monthsParse = [], this._longMonthsParse = [], this._shortMonthsParse = []), 
                a = 0; a < 12; a++) {
                    if (r = l([ 2e3, a ]), n && !this._longMonthsParse[a] && (this._longMonthsParse[a] = new RegExp("^" + this.months(r, "").replace(".", "") + "$", "i"), 
                    this._shortMonthsParse[a] = new RegExp("^" + this.monthsShort(r, "").replace(".", "") + "$", "i")), 
                    n || this._monthsParse[a] || (i = "^" + this.months(r, "") + "|^" + this.monthsShort(r, ""), 
                    this._monthsParse[a] = new RegExp(i.replace(".", ""), "i")), n && "MMMM" === t && this._longMonthsParse[a].test(e)) return a;
                    if (n && "MMM" === t && this._shortMonthsParse[a].test(e)) return a;
                    if (!n && this._monthsParse[a].test(e)) return a;
                }
            }
            function Z(e, t) {
                var n;
                return "string" == typeof t && (t = e.localeData().monthsParse(t), "number" != typeof t) ? e : (n = Math.min(e.date(), B(e.year(), t)), 
                e._d["set" + (e._isUTC ? "UTC" : "") + "Month"](t, n), e);
            }
            function Q(e) {
                return null != e ? (Z(this, e), t.updateOffset(this, !0), this) : C(this, "Month");
            }
            function X() {
                return B(this.year(), this.month());
            }
            function ee(e) {
                var t, n = e._a;
                return n && d(e).overflow === -2 && (t = n[la] < 0 || n[la] > 11 ? la : n[ca] < 1 || n[ca] > B(n[ua], n[la]) ? ca : n[da] < 0 || n[da] > 24 || 24 === n[da] && (0 !== n[ma] || 0 !== n[fa] || 0 !== n[pa]) ? da : n[ma] < 0 || n[ma] > 59 ? ma : n[fa] < 0 || n[fa] > 59 ? fa : n[pa] < 0 || n[pa] > 999 ? pa : -1, 
                d(e)._overflowDayOfYear && (t < ua || t > ca) && (t = ca), d(e).overflow = t), e;
            }
            function te(e) {
                t.suppressDeprecationWarnings === !1 && "undefined" != typeof console && console.warn && console.warn("Deprecation warning: " + e);
            }
            function ne(e, t) {
                var n = !0;
                return u(function() {
                    return n && (te(e + "\n" + new Error().stack), n = !1), t.apply(this, arguments);
                }, t);
            }
            function ae(e, t) {
                _a[e] || (te(t), _a[e] = !0);
            }
            function re(e) {
                var t, n, a = e._i, r = va.exec(a);
                if (r) {
                    for (d(e).iso = !0, t = 0, n = ba.length; t < n; t++) if (ba[t][1].exec(a)) {
                        e._f = ba[t][0];
                        break;
                    }
                    for (t = 0, n = ya.length; t < n; t++) if (ya[t][1].exec(a)) {
                        e._f += (r[6] || " ") + ya[t][0];
                        break;
                    }
                    a.match(aa) && (e._f += "Z"), Le(e);
                } else e._isValid = !1;
            }
            function ie(e) {
                var n = Ma.exec(e._i);
                return null !== n ? void (e._d = new Date(+n[1])) : (re(e), void (e._isValid === !1 && (delete e._isValid, 
                t.createFromInputFallback(e))));
            }
            function se(e, t, n, a, r, i, s) {
                var o = new Date(e, t, n, a, r, i, s);
                return e < 1970 && o.setFullYear(e), o;
            }
            function oe(e) {
                var t = new Date(Date.UTC.apply(null, arguments));
                return e < 1970 && t.setUTCFullYear(e), t;
            }
            function ue(e) {
                return le(e) ? 366 : 365;
            }
            function le(e) {
                return e % 4 === 0 && e % 100 !== 0 || e % 400 === 0;
            }
            function ce() {
                return le(this.year());
            }
            function de(e, t, n) {
                var a, r = n - t, i = n - e.day();
                return i > r && (i -= 7), i < r - 7 && (i += 7), a = Ce(e).add(i, "d"), {
                    week: Math.ceil(a.dayOfYear() / 7),
                    year: a.year()
                };
            }
            function me(e) {
                return de(e, this._week.dow, this._week.doy).week;
            }
            function fe() {
                return this._week.dow;
            }
            function pe() {
                return this._week.doy;
            }
            function he(e) {
                var t = this.localeData().week(this);
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function ge(e) {
                var t = de(this, 1, 4).week;
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function _e(e, t, n, a, r) {
                var i, s = 6 + r - a, o = oe(e, 0, 1 + s), u = o.getUTCDay();
                return u < r && (u += 7), n = null != n ? 1 * n : r, i = 1 + s + 7 * (t - 1) - u + n, 
                {
                    year: i > 0 ? e : e - 1,
                    dayOfYear: i > 0 ? i : ue(e - 1) + i
                };
            }
            function ve(e) {
                var t = Math.round((this.clone().startOf("day") - this.clone().startOf("year")) / 864e5) + 1;
                return null == e ? t : this.add(e - t, "d");
            }
            function be(e, t, n) {
                return null != e ? e : null != t ? t : n;
            }
            function ye(e) {
                var t = new Date();
                return e._useUTC ? [ t.getUTCFullYear(), t.getUTCMonth(), t.getUTCDate() ] : [ t.getFullYear(), t.getMonth(), t.getDate() ];
            }
            function Me(e) {
                var t, n, a, r, i = [];
                if (!e._d) {
                    for (a = ye(e), e._w && null == e._a[ca] && null == e._a[la] && $e(e), e._dayOfYear && (r = be(e._a[ua], a[ua]), 
                    e._dayOfYear > ue(r) && (d(e)._overflowDayOfYear = !0), n = oe(r, 0, e._dayOfYear), 
                    e._a[la] = n.getUTCMonth(), e._a[ca] = n.getUTCDate()), t = 0; t < 3 && null == e._a[t]; ++t) e._a[t] = i[t] = a[t];
                    for (;t < 7; t++) e._a[t] = i[t] = null == e._a[t] ? 2 === t ? 1 : 0 : e._a[t];
                    24 === e._a[da] && 0 === e._a[ma] && 0 === e._a[fa] && 0 === e._a[pa] && (e._nextDay = !0, 
                    e._a[da] = 0), e._d = (e._useUTC ? oe : se).apply(null, i), null != e._tzm && e._d.setUTCMinutes(e._d.getUTCMinutes() - e._tzm), 
                    e._nextDay && (e._a[da] = 24);
                }
            }
            function $e(e) {
                var t, n, a, r, i, s, o;
                t = e._w, null != t.GG || null != t.W || null != t.E ? (i = 1, s = 4, n = be(t.GG, e._a[ua], de(Ce(), 1, 4).year), 
                a = be(t.W, 1), r = be(t.E, 1)) : (i = e._locale._week.dow, s = e._locale._week.doy, 
                n = be(t.gg, e._a[ua], de(Ce(), i, s).year), a = be(t.w, 1), null != t.d ? (r = t.d, 
                r < i && ++a) : r = null != t.e ? t.e + i : i), o = _e(n, a, r, s, i), e._a[ua] = o.year, 
                e._dayOfYear = o.dayOfYear;
            }
            function Le(e) {
                if (e._f === t.ISO_8601) return void re(e);
                e._a = [], d(e).empty = !0;
                var n, a, r, i, s, o = "" + e._i, u = o.length, l = 0;
                for (r = F(e._f, e._locale).match(Vn) || [], n = 0; n < r.length; n++) i = r[n], 
                a = (o.match(V(i, e)) || [])[0], a && (s = o.substr(0, o.indexOf(a)), s.length > 0 && d(e).unusedInput.push(s), 
                o = o.slice(o.indexOf(a) + a.length), l += a.length), Rn[i] ? (a ? d(e).empty = !1 : d(e).unusedTokens.push(i), 
                z(i, a, e)) : e._strict && !a && d(e).unusedTokens.push(i);
                d(e).charsLeftOver = u - l, o.length > 0 && d(e).unusedInput.push(o), d(e).bigHour === !0 && e._a[da] <= 12 && e._a[da] > 0 && (d(e).bigHour = void 0), 
                e._a[da] = ke(e._locale, e._a[da], e._meridiem), Me(e), ee(e);
            }
            function ke(e, t, n) {
                var a;
                return null == n ? t : null != e.meridiemHour ? e.meridiemHour(t, n) : null != e.isPM ? (a = e.isPM(n), 
                a && t < 12 && (t += 12), a || 12 !== t || (t = 0), t) : t;
            }
            function we(e) {
                var t, n, a, r, i;
                if (0 === e._f.length) return d(e).invalidFormat = !0, void (e._d = new Date(NaN));
                for (r = 0; r < e._f.length; r++) i = 0, t = p({}, e), null != e._useUTC && (t._useUTC = e._useUTC), 
                t._f = e._f[r], Le(t), m(t) && (i += d(t).charsLeftOver, i += 10 * d(t).unusedTokens.length, 
                d(t).score = i, (null == a || i < a) && (a = i, n = t));
                u(e, n || t);
            }
            function De(e) {
                if (!e._d) {
                    var t = S(e._i);
                    e._a = [ t.year, t.month, t.day || t.date, t.hour, t.minute, t.second, t.millisecond ], 
                    Me(e);
                }
            }
            function Ye(e) {
                var t = new h(ee(Te(e)));
                return t._nextDay && (t.add(1, "d"), t._nextDay = void 0), t;
            }
            function Te(e) {
                var t = e._i, n = e._f;
                return e._locale = e._locale || D(e._l), null === t || void 0 === n && "" === t ? f({
                    nullInput: !0
                }) : ("string" == typeof t && (e._i = t = e._locale.preparse(t)), g(t) ? new h(ee(t)) : (r(n) ? we(e) : n ? Le(e) : i(t) ? e._d = t : Se(e), 
                e));
            }
            function Se(e) {
                var n = e._i;
                void 0 === n ? e._d = new Date() : i(n) ? e._d = new Date(+n) : "string" == typeof n ? ie(e) : r(n) ? (e._a = s(n.slice(0), function(e) {
                    return parseInt(e, 10);
                }), Me(e)) : "object" == typeof n ? De(e) : "number" == typeof n ? e._d = new Date(n) : t.createFromInputFallback(e);
            }
            function xe(e, t, n, a, r) {
                var i = {};
                return "boolean" == typeof n && (a = n, n = void 0), i._isAMomentObject = !0, i._useUTC = i._isUTC = r, 
                i._l = n, i._i = e, i._f = t, i._strict = a, Ye(i);
            }
            function Ce(e, t, n, a) {
                return xe(e, t, n, a, !1);
            }
            function Ee(e, t) {
                var n, a;
                if (1 === t.length && r(t[0]) && (t = t[0]), !t.length) return Ce();
                for (n = t[0], a = 1; a < t.length; ++a) t[a].isValid() && !t[a][e](n) || (n = t[a]);
                return n;
            }
            function He() {
                var e = [].slice.call(arguments, 0);
                return Ee("isBefore", e);
            }
            function je() {
                var e = [].slice.call(arguments, 0);
                return Ee("isAfter", e);
            }
            function Ae(e) {
                var t = S(e), n = t.year || 0, a = t.quarter || 0, r = t.month || 0, i = t.week || 0, s = t.day || 0, o = t.hour || 0, u = t.minute || 0, l = t.second || 0, c = t.millisecond || 0;
                this._milliseconds = +c + 1e3 * l + 6e4 * u + 36e5 * o, this._days = +s + 7 * i, 
                this._months = +r + 3 * a + 12 * n, this._data = {}, this._locale = D(), this._bubble();
            }
            function Oe(e) {
                return e instanceof Ae;
            }
            function Pe(e, t) {
                A(e, 0, 0, function() {
                    var e = this.utcOffset(), n = "+";
                    return e < 0 && (e = -e, n = "-"), n + j(~~(e / 60), 2) + t + j(~~e % 60, 2);
                });
            }
            function Ie(e) {
                var t = (e || "").match(aa) || [], n = t[t.length - 1] || [], a = (n + "").match(Da) || [ "-", 0, 0 ], r = +(60 * a[1]) + v(a[2]);
                return "+" === a[0] ? r : -r;
            }
            function Fe(e, n) {
                var a, r;
                return n._isUTC ? (a = n.clone(), r = (g(e) || i(e) ? +e : +Ce(e)) - +a, a._d.setTime(+a._d + r), 
                t.updateOffset(a, !1), a) : Ce(e).local();
            }
            function Ne(e) {
                return 15 * -Math.round(e._d.getTimezoneOffset() / 15);
            }
            function Ue(e, n) {
                var a, r = this._offset || 0;
                return null != e ? ("string" == typeof e && (e = Ie(e)), Math.abs(e) < 16 && (e *= 60), 
                !this._isUTC && n && (a = Ne(this)), this._offset = e, this._isUTC = !0, null != a && this.add(a, "m"), 
                r !== e && (!n || this._changeInProgress ? at(this, Qe(e - r, "m"), 1, !1) : this._changeInProgress || (this._changeInProgress = !0, 
                t.updateOffset(this, !0), this._changeInProgress = null)), this) : this._isUTC ? r : Ne(this);
            }
            function Ve(e, t) {
                return null != e ? ("string" != typeof e && (e = -e), this.utcOffset(e, t), this) : -this.utcOffset();
            }
            function We(e) {
                return this.utcOffset(0, e);
            }
            function qe(e) {
                return this._isUTC && (this.utcOffset(0, e), this._isUTC = !1, e && this.subtract(Ne(this), "m")), 
                this;
            }
            function Re() {
                return this._tzm ? this.utcOffset(this._tzm) : "string" == typeof this._i && this.utcOffset(Ie(this._i)), 
                this;
            }
            function ze(e) {
                return e = e ? Ce(e).utcOffset() : 0, (this.utcOffset() - e) % 60 === 0;
            }
            function Be() {
                return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
            }
            function Ge() {
                if ("undefined" != typeof this._isDSTShifted) return this._isDSTShifted;
                var e = {};
                if (p(e, this), e = Te(e), e._a) {
                    var t = e._isUTC ? l(e._a) : Ce(e._a);
                    this._isDSTShifted = this.isValid() && b(e._a, t.toArray()) > 0;
                } else this._isDSTShifted = !1;
                return this._isDSTShifted;
            }
            function Je() {
                return !this._isUTC;
            }
            function Ke() {
                return this._isUTC;
            }
            function Ze() {
                return this._isUTC && 0 === this._offset;
            }
            function Qe(e, t) {
                var n, a, r, i = e, s = null;
                return Oe(e) ? i = {
                    ms: e._milliseconds,
                    d: e._days,
                    M: e._months
                } : "number" == typeof e ? (i = {}, t ? i[t] = e : i.milliseconds = e) : (s = Ya.exec(e)) ? (n = "-" === s[1] ? -1 : 1, 
                i = {
                    y: 0,
                    d: v(s[ca]) * n,
                    h: v(s[da]) * n,
                    m: v(s[ma]) * n,
                    s: v(s[fa]) * n,
                    ms: v(s[pa]) * n
                }) : (s = Ta.exec(e)) ? (n = "-" === s[1] ? -1 : 1, i = {
                    y: Xe(s[2], n),
                    M: Xe(s[3], n),
                    d: Xe(s[4], n),
                    h: Xe(s[5], n),
                    m: Xe(s[6], n),
                    s: Xe(s[7], n),
                    w: Xe(s[8], n)
                }) : null == i ? i = {} : "object" == typeof i && ("from" in i || "to" in i) && (r = tt(Ce(i.from), Ce(i.to)), 
                i = {}, i.ms = r.milliseconds, i.M = r.months), a = new Ae(i), Oe(e) && o(e, "_locale") && (a._locale = e._locale), 
                a;
            }
            function Xe(e, t) {
                var n = e && parseFloat(e.replace(",", "."));
                return (isNaN(n) ? 0 : n) * t;
            }
            function et(e, t) {
                var n = {
                    milliseconds: 0,
                    months: 0
                };
                return n.months = t.month() - e.month() + 12 * (t.year() - e.year()), e.clone().add(n.months, "M").isAfter(t) && --n.months, 
                n.milliseconds = +t - +e.clone().add(n.months, "M"), n;
            }
            function tt(e, t) {
                var n;
                return t = Fe(t, e), e.isBefore(t) ? n = et(e, t) : (n = et(t, e), n.milliseconds = -n.milliseconds, 
                n.months = -n.months), n;
            }
            function nt(e, t) {
                return function(n, a) {
                    var r, i;
                    return null === a || isNaN(+a) || (ae(t, "moment()." + t + "(period, number) is deprecated. Please use moment()." + t + "(number, period)."), 
                    i = n, n = a, a = i), n = "string" == typeof n ? +n : n, r = Qe(n, a), at(this, r, e), 
                    this;
                };
            }
            function at(e, n, a, r) {
                var i = n._milliseconds, s = n._days, o = n._months;
                r = null == r || r, i && e._d.setTime(+e._d + i * a), s && E(e, "Date", C(e, "Date") + s * a), 
                o && Z(e, C(e, "Month") + o * a), r && t.updateOffset(e, s || o);
            }
            function rt(e, t) {
                var n = e || Ce(), a = Fe(n, this).startOf("day"), r = this.diff(a, "days", !0), i = r < -6 ? "sameElse" : r < -1 ? "lastWeek" : r < 0 ? "lastDay" : r < 1 ? "sameDay" : r < 2 ? "nextDay" : r < 7 ? "nextWeek" : "sameElse";
                return this.format(t && t[i] || this.localeData().calendar(i, this, Ce(n)));
            }
            function it() {
                return new h(this);
            }
            function st(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this > +e) : (n = g(e) ? +e : +Ce(e), n < +this.clone().startOf(t));
            }
            function ot(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this < +e) : (n = g(e) ? +e : +Ce(e), +this.clone().endOf(t) < n);
            }
            function ut(e, t, n) {
                return this.isAfter(e, n) && this.isBefore(t, n);
            }
            function lt(e, t) {
                var n;
                return t = T(t || "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), +this === +e) : (n = +Ce(e), 
                +this.clone().startOf(t) <= n && n <= +this.clone().endOf(t));
            }
            function ct(e, t, n) {
                var a, r, i = Fe(e, this), s = 6e4 * (i.utcOffset() - this.utcOffset());
                return t = T(t), "year" === t || "month" === t || "quarter" === t ? (r = dt(this, i), 
                "quarter" === t ? r /= 3 : "year" === t && (r /= 12)) : (a = this - i, r = "second" === t ? a / 1e3 : "minute" === t ? a / 6e4 : "hour" === t ? a / 36e5 : "day" === t ? (a - s) / 864e5 : "week" === t ? (a - s) / 6048e5 : a), 
                n ? r : _(r);
            }
            function dt(e, t) {
                var n, a, r = 12 * (t.year() - e.year()) + (t.month() - e.month()), i = e.clone().add(r, "months");
                return t - i < 0 ? (n = e.clone().add(r - 1, "months"), a = (t - i) / (i - n)) : (n = e.clone().add(r + 1, "months"), 
                a = (t - i) / (n - i)), -(r + a);
            }
            function mt() {
                return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
            }
            function ft() {
                var e = this.clone().utc();
                return 0 < e.year() && e.year() <= 9999 ? "function" == typeof Date.prototype.toISOString ? this.toDate().toISOString() : I(e, "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]") : I(e, "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]");
            }
            function pt(e) {
                var n = I(this, e || t.defaultFormat);
                return this.localeData().postformat(n);
            }
            function ht(e, t) {
                return this.isValid() ? Qe({
                    to: this,
                    from: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function gt(e) {
                return this.from(Ce(), e);
            }
            function _t(e, t) {
                return this.isValid() ? Qe({
                    from: this,
                    to: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function vt(e) {
                return this.to(Ce(), e);
            }
            function bt(e) {
                var t;
                return void 0 === e ? this._locale._abbr : (t = D(e), null != t && (this._locale = t), 
                this);
            }
            function yt() {
                return this._locale;
            }
            function Mt(e) {
                switch (e = T(e)) {
                  case "year":
                    this.month(0);

                  case "quarter":
                  case "month":
                    this.date(1);

                  case "week":
                  case "isoWeek":
                  case "day":
                    this.hours(0);

                  case "hour":
                    this.minutes(0);

                  case "minute":
                    this.seconds(0);

                  case "second":
                    this.milliseconds(0);
                }
                return "week" === e && this.weekday(0), "isoWeek" === e && this.isoWeekday(1), "quarter" === e && this.month(3 * Math.floor(this.month() / 3)), 
                this;
            }
            function $t(e) {
                return e = T(e), void 0 === e || "millisecond" === e ? this : this.startOf(e).add(1, "isoWeek" === e ? "week" : e).subtract(1, "ms");
            }
            function Lt() {
                return +this._d - 6e4 * (this._offset || 0);
            }
            function kt() {
                return Math.floor(+this / 1e3);
            }
            function wt() {
                return this._offset ? new Date(+this) : this._d;
            }
            function Dt() {
                var e = this;
                return [ e.year(), e.month(), e.date(), e.hour(), e.minute(), e.second(), e.millisecond() ];
            }
            function Yt() {
                var e = this;
                return {
                    years: e.year(),
                    months: e.month(),
                    date: e.date(),
                    hours: e.hours(),
                    minutes: e.minutes(),
                    seconds: e.seconds(),
                    milliseconds: e.milliseconds()
                };
            }
            function Tt() {
                return m(this);
            }
            function St() {
                return u({}, d(this));
            }
            function xt() {
                return d(this).overflow;
            }
            function Ct(e, t) {
                A(0, [ e, e.length ], 0, t);
            }
            function Et(e, t, n) {
                return de(Ce([ e, 11, 31 + t - n ]), t, n).week;
            }
            function Ht(e) {
                var t = de(this, this.localeData()._week.dow, this.localeData()._week.doy).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function jt(e) {
                var t = de(this, 1, 4).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function At() {
                return Et(this.year(), 1, 4);
            }
            function Ot() {
                var e = this.localeData()._week;
                return Et(this.year(), e.dow, e.doy);
            }
            function Pt(e) {
                return null == e ? Math.ceil((this.month() + 1) / 3) : this.month(3 * (e - 1) + this.month() % 3);
            }
            function It(e, t) {
                return "string" != typeof e ? e : isNaN(e) ? (e = t.weekdaysParse(e), "number" == typeof e ? e : null) : parseInt(e, 10);
            }
            function Ft(e) {
                return this._weekdays[e.day()];
            }
            function Nt(e) {
                return this._weekdaysShort[e.day()];
            }
            function Ut(e) {
                return this._weekdaysMin[e.day()];
            }
            function Vt(e) {
                var t, n, a;
                for (this._weekdaysParse = this._weekdaysParse || [], t = 0; t < 7; t++) if (this._weekdaysParse[t] || (n = Ce([ 2e3, 1 ]).day(t), 
                a = "^" + this.weekdays(n, "") + "|^" + this.weekdaysShort(n, "") + "|^" + this.weekdaysMin(n, ""), 
                this._weekdaysParse[t] = new RegExp(a.replace(".", ""), "i")), this._weekdaysParse[t].test(e)) return t;
            }
            function Wt(e) {
                var t = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
                return null != e ? (e = It(e, this.localeData()), this.add(e - t, "d")) : t;
            }
            function qt(e) {
                var t = (this.day() + 7 - this.localeData()._week.dow) % 7;
                return null == e ? t : this.add(e - t, "d");
            }
            function Rt(e) {
                return null == e ? this.day() || 7 : this.day(this.day() % 7 ? e : e - 7);
            }
            function zt(e, t) {
                A(e, 0, 0, function() {
                    return this.localeData().meridiem(this.hours(), this.minutes(), t);
                });
            }
            function Bt(e, t) {
                return t._meridiemParse;
            }
            function Gt(e) {
                return "p" === (e + "").toLowerCase().charAt(0);
            }
            function Jt(e, t, n) {
                return e > 11 ? n ? "pm" : "PM" : n ? "am" : "AM";
            }
            function Kt(e, t) {
                t[pa] = v(1e3 * ("0." + e));
            }
            function Zt() {
                return this._isUTC ? "UTC" : "";
            }
            function Qt() {
                return this._isUTC ? "Coordinated Universal Time" : "";
            }
            function Xt(e) {
                return Ce(1e3 * e);
            }
            function en() {
                return Ce.apply(null, arguments).parseZone();
            }
            function tn(e, t, n) {
                var a = this._calendar[e];
                return "function" == typeof a ? a.call(t, n) : a;
            }
            function nn(e) {
                var t = this._longDateFormat[e], n = this._longDateFormat[e.toUpperCase()];
                return t || !n ? t : (this._longDateFormat[e] = n.replace(/MMMM|MM|DD|dddd/g, function(e) {
                    return e.slice(1);
                }), this._longDateFormat[e]);
            }
            function an() {
                return this._invalidDate;
            }
            function rn(e) {
                return this._ordinal.replace("%d", e);
            }
            function sn(e) {
                return e;
            }
            function on(e, t, n, a) {
                var r = this._relativeTime[n];
                return "function" == typeof r ? r(e, t, n, a) : r.replace(/%d/i, e);
            }
            function un(e, t) {
                var n = this._relativeTime[e > 0 ? "future" : "past"];
                return "function" == typeof n ? n(t) : n.replace(/%s/i, t);
            }
            function ln(e) {
                var t, n;
                for (n in e) t = e[n], "function" == typeof t ? this[n] = t : this["_" + n] = t;
                this._ordinalParseLenient = new RegExp(this._ordinalParse.source + "|" + /\d{1,2}/.source);
            }
            function cn(e, t, n, a) {
                var r = D(), i = l().set(a, t);
                return r[n](i, e);
            }
            function dn(e, t, n, a, r) {
                if ("number" == typeof e && (t = e, e = void 0), e = e || "", null != t) return cn(e, t, n, r);
                var i, s = [];
                for (i = 0; i < a; i++) s[i] = cn(e, i, n, r);
                return s;
            }
            function mn(e, t) {
                return dn(e, t, "months", 12, "month");
            }
            function fn(e, t) {
                return dn(e, t, "monthsShort", 12, "month");
            }
            function pn(e, t) {
                return dn(e, t, "weekdays", 7, "day");
            }
            function hn(e, t) {
                return dn(e, t, "weekdaysShort", 7, "day");
            }
            function gn(e, t) {
                return dn(e, t, "weekdaysMin", 7, "day");
            }
            function _n() {
                var e = this._data;
                return this._milliseconds = Za(this._milliseconds), this._days = Za(this._days), 
                this._months = Za(this._months), e.milliseconds = Za(e.milliseconds), e.seconds = Za(e.seconds), 
                e.minutes = Za(e.minutes), e.hours = Za(e.hours), e.months = Za(e.months), e.years = Za(e.years), 
                this;
            }
            function vn(e, t, n, a) {
                var r = Qe(t, n);
                return e._milliseconds += a * r._milliseconds, e._days += a * r._days, e._months += a * r._months, 
                e._bubble();
            }
            function bn(e, t) {
                return vn(this, e, t, 1);
            }
            function yn(e, t) {
                return vn(this, e, t, -1);
            }
            function Mn(e) {
                return e < 0 ? Math.floor(e) : Math.ceil(e);
            }
            function $n() {
                var e, t, n, a, r, i = this._milliseconds, s = this._days, o = this._months, u = this._data;
                return i >= 0 && s >= 0 && o >= 0 || i <= 0 && s <= 0 && o <= 0 || (i += 864e5 * Mn(kn(o) + s), 
                s = 0, o = 0), u.milliseconds = i % 1e3, e = _(i / 1e3), u.seconds = e % 60, t = _(e / 60), 
                u.minutes = t % 60, n = _(t / 60), u.hours = n % 24, s += _(n / 24), r = _(Ln(s)), 
                o += r, s -= Mn(kn(r)), a = _(o / 12), o %= 12, u.days = s, u.months = o, u.years = a, 
                this;
            }
            function Ln(e) {
                return 4800 * e / 146097;
            }
            function kn(e) {
                return 146097 * e / 4800;
            }
            function wn(e) {
                var t, n, a = this._milliseconds;
                if (e = T(e), "month" === e || "year" === e) return t = this._days + a / 864e5, 
                n = this._months + Ln(t), "month" === e ? n : n / 12;
                switch (t = this._days + Math.round(kn(this._months)), e) {
                  case "week":
                    return t / 7 + a / 6048e5;

                  case "day":
                    return t + a / 864e5;

                  case "hour":
                    return 24 * t + a / 36e5;

                  case "minute":
                    return 1440 * t + a / 6e4;

                  case "second":
                    return 86400 * t + a / 1e3;

                  case "millisecond":
                    return Math.floor(864e5 * t) + a;

                  default:
                    throw new Error("Unknown unit " + e);
                }
            }
            function Dn() {
                return this._milliseconds + 864e5 * this._days + this._months % 12 * 2592e6 + 31536e6 * v(this._months / 12);
            }
            function Yn(e) {
                return function() {
                    return this.as(e);
                };
            }
            function Tn(e) {
                return e = T(e), this[e + "s"]();
            }
            function Sn(e) {
                return function() {
                    return this._data[e];
                };
            }
            function xn() {
                return _(this.days() / 7);
            }
            function Cn(e, t, n, a, r) {
                return r.relativeTime(t || 1, !!n, e, a);
            }
            function En(e, t, n) {
                var a = Qe(e).abs(), r = fr(a.as("s")), i = fr(a.as("m")), s = fr(a.as("h")), o = fr(a.as("d")), u = fr(a.as("M")), l = fr(a.as("y")), c = r < pr.s && [ "s", r ] || 1 === i && [ "m" ] || i < pr.m && [ "mm", i ] || 1 === s && [ "h" ] || s < pr.h && [ "hh", s ] || 1 === o && [ "d" ] || o < pr.d && [ "dd", o ] || 1 === u && [ "M" ] || u < pr.M && [ "MM", u ] || 1 === l && [ "y" ] || [ "yy", l ];
                return c[2] = t, c[3] = +e > 0, c[4] = n, Cn.apply(null, c);
            }
            function Hn(e, t) {
                return void 0 !== pr[e] && (void 0 === t ? pr[e] : (pr[e] = t, !0));
            }
            function jn(e) {
                var t = this.localeData(), n = En(this, !e, t);
                return e && (n = t.pastFuture(+this, n)), t.postformat(n);
            }
            function An() {
                var e, t, n, a = hr(this._milliseconds) / 1e3, r = hr(this._days), i = hr(this._months);
                e = _(a / 60), t = _(e / 60), a %= 60, e %= 60, n = _(i / 12), i %= 12;
                var s = n, o = i, u = r, l = t, c = e, d = a, m = this.asSeconds();
                return m ? (m < 0 ? "-" : "") + "P" + (s ? s + "Y" : "") + (o ? o + "M" : "") + (u ? u + "D" : "") + (l || c || d ? "T" : "") + (l ? l + "H" : "") + (c ? c + "M" : "") + (d ? d + "S" : "") : "P0D";
            }
            var On, Pn, In = t.momentProperties = [], Fn = !1, Nn = {}, Un = {}, Vn = /(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Q|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g, Wn = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, qn = {}, Rn = {}, zn = /\d/, Bn = /\d\d/, Gn = /\d{3}/, Jn = /\d{4}/, Kn = /[+-]?\d{6}/, Zn = /\d\d?/, Qn = /\d{1,3}/, Xn = /\d{1,4}/, ea = /[+-]?\d{1,6}/, ta = /\d+/, na = /[+-]?\d+/, aa = /Z|[+-]\d\d:?\d\d/gi, ra = /[+-]?\d+(\.\d{1,3})?/, ia = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i, sa = {}, oa = {}, ua = 0, la = 1, ca = 2, da = 3, ma = 4, fa = 5, pa = 6;
            A("M", [ "MM", 2 ], "Mo", function() {
                return this.month() + 1;
            }), A("MMM", 0, 0, function(e) {
                return this.localeData().monthsShort(this, e);
            }), A("MMMM", 0, 0, function(e) {
                return this.localeData().months(this, e);
            }), Y("month", "M"), U("M", Zn), U("MM", Zn, Bn), U("MMM", ia), U("MMMM", ia), q([ "M", "MM" ], function(e, t) {
                t[la] = v(e) - 1;
            }), q([ "MMM", "MMMM" ], function(e, t, n, a) {
                var r = n._locale.monthsParse(e, a, n._strict);
                null != r ? t[la] = r : d(n).invalidMonth = e;
            });
            var ha = "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ga = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"), _a = {};
            t.suppressDeprecationWarnings = !1;
            var va = /^\s*(?:[+-]\d{6}|\d{4})-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/, ba = [ [ "YYYYYY-MM-DD", /[+-]\d{6}-\d{2}-\d{2}/ ], [ "YYYY-MM-DD", /\d{4}-\d{2}-\d{2}/ ], [ "GGGG-[W]WW-E", /\d{4}-W\d{2}-\d/ ], [ "GGGG-[W]WW", /\d{4}-W\d{2}/ ], [ "YYYY-DDD", /\d{4}-\d{3}/ ] ], ya = [ [ "HH:mm:ss.SSSS", /(T| )\d\d:\d\d:\d\d\.\d+/ ], [ "HH:mm:ss", /(T| )\d\d:\d\d:\d\d/ ], [ "HH:mm", /(T| )\d\d:\d\d/ ], [ "HH", /(T| )\d\d/ ] ], Ma = /^\/?Date\((\-?\d+)/i;
            t.createFromInputFallback = ne("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to https://github.com/moment/moment/issues/1407 for more info.", function(e) {
                e._d = new Date(e._i + (e._useUTC ? " UTC" : ""));
            }), A(0, [ "YY", 2 ], 0, function() {
                return this.year() % 100;
            }), A(0, [ "YYYY", 4 ], 0, "year"), A(0, [ "YYYYY", 5 ], 0, "year"), A(0, [ "YYYYYY", 6, !0 ], 0, "year"), 
            Y("year", "y"), U("Y", na), U("YY", Zn, Bn), U("YYYY", Xn, Jn), U("YYYYY", ea, Kn), 
            U("YYYYYY", ea, Kn), q([ "YYYYY", "YYYYYY" ], ua), q("YYYY", function(e, n) {
                n[ua] = 2 === e.length ? t.parseTwoDigitYear(e) : v(e);
            }), q("YY", function(e, n) {
                n[ua] = t.parseTwoDigitYear(e);
            }), t.parseTwoDigitYear = function(e) {
                return v(e) + (v(e) > 68 ? 1900 : 2e3);
            };
            var $a = x("FullYear", !1);
            A("w", [ "ww", 2 ], "wo", "week"), A("W", [ "WW", 2 ], "Wo", "isoWeek"), Y("week", "w"), 
            Y("isoWeek", "W"), U("w", Zn), U("ww", Zn, Bn), U("W", Zn), U("WW", Zn, Bn), R([ "w", "ww", "W", "WW" ], function(e, t, n, a) {
                t[a.substr(0, 1)] = v(e);
            });
            var La = {
                dow: 0,
                doy: 6
            };
            A("DDD", [ "DDDD", 3 ], "DDDo", "dayOfYear"), Y("dayOfYear", "DDD"), U("DDD", Qn), 
            U("DDDD", Gn), q([ "DDD", "DDDD" ], function(e, t, n) {
                n._dayOfYear = v(e);
            }), t.ISO_8601 = function() {};
            var ka = ne("moment().min is deprecated, use moment.min instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e < this ? this : e;
            }), wa = ne("moment().max is deprecated, use moment.max instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e > this ? this : e;
            });
            Pe("Z", ":"), Pe("ZZ", ""), U("Z", aa), U("ZZ", aa), q([ "Z", "ZZ" ], function(e, t, n) {
                n._useUTC = !0, n._tzm = Ie(e);
            });
            var Da = /([\+\-]|\d\d)/gi;
            t.updateOffset = function() {};
            var Ya = /(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/, Ta = /^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/;
            Qe.fn = Ae.prototype;
            var Sa = nt(1, "add"), xa = nt(-1, "subtract");
            t.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
            var Ca = ne("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.", function(e) {
                return void 0 === e ? this.localeData() : this.locale(e);
            });
            A(0, [ "gg", 2 ], 0, function() {
                return this.weekYear() % 100;
            }), A(0, [ "GG", 2 ], 0, function() {
                return this.isoWeekYear() % 100;
            }), Ct("gggg", "weekYear"), Ct("ggggg", "weekYear"), Ct("GGGG", "isoWeekYear"), 
            Ct("GGGGG", "isoWeekYear"), Y("weekYear", "gg"), Y("isoWeekYear", "GG"), U("G", na), 
            U("g", na), U("GG", Zn, Bn), U("gg", Zn, Bn), U("GGGG", Xn, Jn), U("gggg", Xn, Jn), 
            U("GGGGG", ea, Kn), U("ggggg", ea, Kn), R([ "gggg", "ggggg", "GGGG", "GGGGG" ], function(e, t, n, a) {
                t[a.substr(0, 2)] = v(e);
            }), R([ "gg", "GG" ], function(e, n, a, r) {
                n[r] = t.parseTwoDigitYear(e);
            }), A("Q", 0, 0, "quarter"), Y("quarter", "Q"), U("Q", zn), q("Q", function(e, t) {
                t[la] = 3 * (v(e) - 1);
            }), A("D", [ "DD", 2 ], "Do", "date"), Y("date", "D"), U("D", Zn), U("DD", Zn, Bn), 
            U("Do", function(e, t) {
                return e ? t._ordinalParse : t._ordinalParseLenient;
            }), q([ "D", "DD" ], ca), q("Do", function(e, t) {
                t[ca] = v(e.match(Zn)[0], 10);
            });
            var Ea = x("Date", !0);
            A("d", 0, "do", "day"), A("dd", 0, 0, function(e) {
                return this.localeData().weekdaysMin(this, e);
            }), A("ddd", 0, 0, function(e) {
                return this.localeData().weekdaysShort(this, e);
            }), A("dddd", 0, 0, function(e) {
                return this.localeData().weekdays(this, e);
            }), A("e", 0, 0, "weekday"), A("E", 0, 0, "isoWeekday"), Y("day", "d"), Y("weekday", "e"), 
            Y("isoWeekday", "E"), U("d", Zn), U("e", Zn), U("E", Zn), U("dd", ia), U("ddd", ia), 
            U("dddd", ia), R([ "dd", "ddd", "dddd" ], function(e, t, n) {
                var a = n._locale.weekdaysParse(e);
                null != a ? t.d = a : d(n).invalidWeekday = e;
            }), R([ "d", "e", "E" ], function(e, t, n, a) {
                t[a] = v(e);
            });
            var Ha = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), ja = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"), Aa = "Su_Mo_Tu_We_Th_Fr_Sa".split("_");
            A("H", [ "HH", 2 ], 0, "hour"), A("h", [ "hh", 2 ], 0, function() {
                return this.hours() % 12 || 12;
            }), zt("a", !0), zt("A", !1), Y("hour", "h"), U("a", Bt), U("A", Bt), U("H", Zn), 
            U("h", Zn), U("HH", Zn, Bn), U("hh", Zn, Bn), q([ "H", "HH" ], da), q([ "a", "A" ], function(e, t, n) {
                n._isPm = n._locale.isPM(e), n._meridiem = e;
            }), q([ "h", "hh" ], function(e, t, n) {
                t[da] = v(e), d(n).bigHour = !0;
            });
            var Oa = /[ap]\.?m?\.?/i, Pa = x("Hours", !0);
            A("m", [ "mm", 2 ], 0, "minute"), Y("minute", "m"), U("m", Zn), U("mm", Zn, Bn), 
            q([ "m", "mm" ], ma);
            var Ia = x("Minutes", !1);
            A("s", [ "ss", 2 ], 0, "second"), Y("second", "s"), U("s", Zn), U("ss", Zn, Bn), 
            q([ "s", "ss" ], fa);
            var Fa = x("Seconds", !1);
            A("S", 0, 0, function() {
                return ~~(this.millisecond() / 100);
            }), A(0, [ "SS", 2 ], 0, function() {
                return ~~(this.millisecond() / 10);
            }), A(0, [ "SSS", 3 ], 0, "millisecond"), A(0, [ "SSSS", 4 ], 0, function() {
                return 10 * this.millisecond();
            }), A(0, [ "SSSSS", 5 ], 0, function() {
                return 100 * this.millisecond();
            }), A(0, [ "SSSSSS", 6 ], 0, function() {
                return 1e3 * this.millisecond();
            }), A(0, [ "SSSSSSS", 7 ], 0, function() {
                return 1e4 * this.millisecond();
            }), A(0, [ "SSSSSSSS", 8 ], 0, function() {
                return 1e5 * this.millisecond();
            }), A(0, [ "SSSSSSSSS", 9 ], 0, function() {
                return 1e6 * this.millisecond();
            }), Y("millisecond", "ms"), U("S", Qn, zn), U("SS", Qn, Bn), U("SSS", Qn, Gn);
            var Na;
            for (Na = "SSSS"; Na.length <= 9; Na += "S") U(Na, ta);
            for (Na = "S"; Na.length <= 9; Na += "S") q(Na, Kt);
            var Ua = x("Milliseconds", !1);
            A("z", 0, 0, "zoneAbbr"), A("zz", 0, 0, "zoneName");
            var Va = h.prototype;
            Va.add = Sa, Va.calendar = rt, Va.clone = it, Va.diff = ct, Va.endOf = $t, Va.format = pt, 
            Va.from = ht, Va.fromNow = gt, Va.to = _t, Va.toNow = vt, Va.get = H, Va.invalidAt = xt, 
            Va.isAfter = st, Va.isBefore = ot, Va.isBetween = ut, Va.isSame = lt, Va.isValid = Tt, 
            Va.lang = Ca, Va.locale = bt, Va.localeData = yt, Va.max = wa, Va.min = ka, Va.parsingFlags = St, 
            Va.set = H, Va.startOf = Mt, Va.subtract = xa, Va.toArray = Dt, Va.toObject = Yt, 
            Va.toDate = wt, Va.toISOString = ft, Va.toJSON = ft, Va.toString = mt, Va.unix = kt, 
            Va.valueOf = Lt, Va.year = $a, Va.isLeapYear = ce, Va.weekYear = Ht, Va.isoWeekYear = jt, 
            Va.quarter = Va.quarters = Pt, Va.month = Q, Va.daysInMonth = X, Va.week = Va.weeks = he, 
            Va.isoWeek = Va.isoWeeks = ge, Va.weeksInYear = Ot, Va.isoWeeksInYear = At, Va.date = Ea, 
            Va.day = Va.days = Wt, Va.weekday = qt, Va.isoWeekday = Rt, Va.dayOfYear = ve, Va.hour = Va.hours = Pa, 
            Va.minute = Va.minutes = Ia, Va.second = Va.seconds = Fa, Va.millisecond = Va.milliseconds = Ua, 
            Va.utcOffset = Ue, Va.utc = We, Va.local = qe, Va.parseZone = Re, Va.hasAlignedHourOffset = ze, 
            Va.isDST = Be, Va.isDSTShifted = Ge, Va.isLocal = Je, Va.isUtcOffset = Ke, Va.isUtc = Ze, 
            Va.isUTC = Ze, Va.zoneAbbr = Zt, Va.zoneName = Qt, Va.dates = ne("dates accessor is deprecated. Use date instead.", Ea), 
            Va.months = ne("months accessor is deprecated. Use month instead", Q), Va.years = ne("years accessor is deprecated. Use year instead", $a), 
            Va.zone = ne("moment().zone is deprecated, use moment().utcOffset instead. https://github.com/moment/moment/issues/1779", Ve);
            var Wa = Va, qa = {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            }, Ra = {
                LTS: "h:mm:ss A",
                LT: "h:mm A",
                L: "MM/DD/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY h:mm A",
                LLLL: "dddd, MMMM D, YYYY h:mm A"
            }, za = "Invalid date", Ba = "%d", Ga = /\d{1,2}/, Ja = {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            }, Ka = y.prototype;
            Ka._calendar = qa, Ka.calendar = tn, Ka._longDateFormat = Ra, Ka.longDateFormat = nn, 
            Ka._invalidDate = za, Ka.invalidDate = an, Ka._ordinal = Ba, Ka.ordinal = rn, Ka._ordinalParse = Ga, 
            Ka.preparse = sn, Ka.postformat = sn, Ka._relativeTime = Ja, Ka.relativeTime = on, 
            Ka.pastFuture = un, Ka.set = ln, Ka.months = G, Ka._months = ha, Ka.monthsShort = J, 
            Ka._monthsShort = ga, Ka.monthsParse = K, Ka.week = me, Ka._week = La, Ka.firstDayOfYear = pe, 
            Ka.firstDayOfWeek = fe, Ka.weekdays = Ft, Ka._weekdays = Ha, Ka.weekdaysMin = Ut, 
            Ka._weekdaysMin = Aa, Ka.weekdaysShort = Nt, Ka._weekdaysShort = ja, Ka.weekdaysParse = Vt, 
            Ka.isPM = Gt, Ka._meridiemParse = Oa, Ka.meridiem = Jt, k("en", {
                ordinalParse: /\d{1,2}(th|st|nd|rd)/,
                ordinal: function(e) {
                    var t = e % 10, n = 1 === v(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                    return e + n;
                }
            }), t.lang = ne("moment.lang is deprecated. Use moment.locale instead.", k), t.langData = ne("moment.langData is deprecated. Use moment.localeData instead.", D);
            var Za = Math.abs, Qa = Yn("ms"), Xa = Yn("s"), er = Yn("m"), tr = Yn("h"), nr = Yn("d"), ar = Yn("w"), rr = Yn("M"), ir = Yn("y"), sr = Sn("milliseconds"), or = Sn("seconds"), ur = Sn("minutes"), lr = Sn("hours"), cr = Sn("days"), dr = Sn("months"), mr = Sn("years"), fr = Math.round, pr = {
                s: 45,
                m: 45,
                h: 22,
                d: 26,
                M: 11
            }, hr = Math.abs, gr = Ae.prototype;
            gr.abs = _n, gr.add = bn, gr.subtract = yn, gr.as = wn, gr.asMilliseconds = Qa, 
            gr.asSeconds = Xa, gr.asMinutes = er, gr.asHours = tr, gr.asDays = nr, gr.asWeeks = ar, 
            gr.asMonths = rr, gr.asYears = ir, gr.valueOf = Dn, gr._bubble = $n, gr.get = Tn, 
            gr.milliseconds = sr, gr.seconds = or, gr.minutes = ur, gr.hours = lr, gr.days = cr, 
            gr.weeks = xn, gr.months = dr, gr.years = mr, gr.humanize = jn, gr.toISOString = An, 
            gr.toString = An, gr.toJSON = An, gr.locale = bt, gr.localeData = yt, gr.toIsoString = ne("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)", An), 
            gr.lang = Ca, A("X", 0, 0, "unix"), A("x", 0, 0, "valueOf"), U("x", na), U("X", ra), 
            q("X", function(e, t, n) {
                n._d = new Date(1e3 * parseFloat(e, 10));
            }), q("x", function(e, t, n) {
                n._d = new Date(v(e));
            }), t.version = "2.10.6", a(Ce), t.fn = Wa, t.min = He, t.max = je, t.utc = l, t.unix = Xt, 
            t.months = mn, t.isDate = i, t.locale = k, t.invalid = f, t.duration = Qe, t.isMoment = g, 
            t.weekdays = pn, t.parseZone = en, t.localeData = D, t.isDuration = Oe, t.monthsShort = fn, 
            t.weekdaysMin = gn, t.defineLocale = w, t.weekdaysShort = hn, t.normalizeUnits = T, 
            t.relativeTimeThreshold = Hn;
            var _r = t;
            return _r;
        });
    }).call(t, n(63)(e));
}, function(e, t) {
    e.exports = function(e) {
        return e.webpackPolyfill || (e.deprecate = function() {}, e.paths = [], e.children = [], 
        e.webpackPolyfill = 1), e;
    };
}, function(e, t, n) {
    function a(e) {
        return n(r(e));
    }
    function r(e) {
        return i[e] || function() {
            throw new Error("Cannot find module '" + e + "'.");
        }();
    }
    var i = {
        "./af": 65,
        "./af.js": 65,
        "./ar": 66,
        "./ar-ma": 67,
        "./ar-ma.js": 67,
        "./ar-sa": 68,
        "./ar-sa.js": 68,
        "./ar-tn": 69,
        "./ar-tn.js": 69,
        "./ar.js": 66,
        "./az": 70,
        "./az.js": 70,
        "./be": 71,
        "./be.js": 71,
        "./bg": 72,
        "./bg.js": 72,
        "./bn": 73,
        "./bn.js": 73,
        "./bo": 74,
        "./bo.js": 74,
        "./br": 75,
        "./br.js": 75,
        "./bs": 76,
        "./bs.js": 76,
        "./ca": 77,
        "./ca.js": 77,
        "./cs": 78,
        "./cs.js": 78,
        "./cv": 79,
        "./cv.js": 79,
        "./cy": 80,
        "./cy.js": 80,
        "./da": 81,
        "./da.js": 81,
        "./de": 82,
        "./de-at": 83,
        "./de-at.js": 83,
        "./de.js": 82,
        "./el": 84,
        "./el.js": 84,
        "./en-au": 85,
        "./en-au.js": 85,
        "./en-ca": 86,
        "./en-ca.js": 86,
        "./en-gb": 87,
        "./en-gb.js": 87,
        "./eo": 88,
        "./eo.js": 88,
        "./es": 89,
        "./es.js": 89,
        "./et": 90,
        "./et.js": 90,
        "./eu": 91,
        "./eu.js": 91,
        "./fa": 92,
        "./fa.js": 92,
        "./fi": 93,
        "./fi.js": 93,
        "./fo": 94,
        "./fo.js": 94,
        "./fr": 95,
        "./fr-ca": 96,
        "./fr-ca.js": 96,
        "./fr.js": 95,
        "./fy": 97,
        "./fy.js": 97,
        "./gl": 98,
        "./gl.js": 98,
        "./he": 99,
        "./he.js": 99,
        "./hi": 100,
        "./hi.js": 100,
        "./hr": 101,
        "./hr.js": 101,
        "./hu": 102,
        "./hu.js": 102,
        "./hy-am": 103,
        "./hy-am.js": 103,
        "./id": 104,
        "./id.js": 104,
        "./is": 105,
        "./is.js": 105,
        "./it": 106,
        "./it.js": 106,
        "./ja": 107,
        "./ja.js": 107,
        "./jv": 108,
        "./jv.js": 108,
        "./ka": 109,
        "./ka.js": 109,
        "./km": 110,
        "./km.js": 110,
        "./ko": 111,
        "./ko.js": 111,
        "./lb": 112,
        "./lb.js": 112,
        "./lt": 113,
        "./lt.js": 113,
        "./lv": 114,
        "./lv.js": 114,
        "./me": 115,
        "./me.js": 115,
        "./mk": 116,
        "./mk.js": 116,
        "./ml": 117,
        "./ml.js": 117,
        "./mr": 118,
        "./mr.js": 118,
        "./ms": 119,
        "./ms-my": 120,
        "./ms-my.js": 120,
        "./ms.js": 119,
        "./my": 121,
        "./my.js": 121,
        "./nb": 122,
        "./nb.js": 122,
        "./ne": 123,
        "./ne.js": 123,
        "./nl": 124,
        "./nl.js": 124,
        "./nn": 125,
        "./nn.js": 125,
        "./pl": 126,
        "./pl.js": 126,
        "./pt": 127,
        "./pt-br": 128,
        "./pt-br.js": 128,
        "./pt.js": 127,
        "./ro": 129,
        "./ro.js": 129,
        "./ru": 130,
        "./ru.js": 130,
        "./si": 131,
        "./si.js": 131,
        "./sk": 132,
        "./sk.js": 132,
        "./sl": 133,
        "./sl.js": 133,
        "./sq": 134,
        "./sq.js": 134,
        "./sr": 135,
        "./sr-cyrl": 136,
        "./sr-cyrl.js": 136,
        "./sr.js": 135,
        "./sv": 137,
        "./sv.js": 137,
        "./ta": 138,
        "./ta.js": 138,
        "./th": 139,
        "./th.js": 139,
        "./tl-ph": 140,
        "./tl-ph.js": 140,
        "./tr": 141,
        "./tr.js": 141,
        "./tzl": 142,
        "./tzl.js": 142,
        "./tzm": 143,
        "./tzm-latn": 144,
        "./tzm-latn.js": 144,
        "./tzm.js": 143,
        "./uk": 145,
        "./uk.js": 145,
        "./uz": 146,
        "./uz.js": 146,
        "./vi": 147,
        "./vi.js": 147,
        "./zh-cn": 148,
        "./zh-cn.js": 148,
        "./zh-tw": 149,
        "./zh-tw.js": 149
    };
    a.keys = function() {
        return Object.keys(i);
    }, a.resolve = r, e.exports = a, a.id = 64;
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : afrikaans (af)
    //! author : Werner Mollentze : https://github.com/wernerm
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("af", {
            months: "Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),
            weekdaysShort: "Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),
            weekdaysMin: "So_Ma_Di_Wo_Do_Vr_Sa".split("_"),
            meridiemParse: /vm|nm/i,
            isPM: function(e) {
                return /^nm$/i.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n ? "vm" : "VM" : n ? "nm" : "NM";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Vandag om] LT",
                nextDay: "[Môre om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[Gister om] LT",
                lastWeek: "[Laas] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oor %s",
                past: "%s gelede",
                s: "'n paar sekondes",
                m: "'n minuut",
                mm: "%d minute",
                h: "'n uur",
                hh: "%d ure",
                d: "'n dag",
                dd: "%d dae",
                M: "'n maand",
                MM: "%d maande",
                y: "'n jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! Locale: Arabic (ar)
    //! Author: Abdel Said: https://github.com/abdelsaid
    //! Changes in months, weekdays: Ahmed Elkhatib
    //! Native plural forms: forabi https://github.com/forabi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = function(e) {
            return 0 === e ? 0 : 1 === e ? 1 : 2 === e ? 2 : e % 100 >= 3 && e % 100 <= 10 ? 3 : e % 100 >= 11 ? 4 : 5;
        }, r = {
            s: [ "أقل من ثانية", "ثانية واحدة", [ "ثانيتان", "ثانيتين" ], "%d ثوان", "%d ثانية", "%d ثانية" ],
            m: [ "أقل من دقيقة", "دقيقة واحدة", [ "دقيقتان", "دقيقتين" ], "%d دقائق", "%d دقيقة", "%d دقيقة" ],
            h: [ "أقل من ساعة", "ساعة واحدة", [ "ساعتان", "ساعتين" ], "%d ساعات", "%d ساعة", "%d ساعة" ],
            d: [ "أقل من يوم", "يوم واحد", [ "يومان", "يومين" ], "%d أيام", "%d يومًا", "%d يوم" ],
            M: [ "أقل من شهر", "شهر واحد", [ "شهران", "شهرين" ], "%d أشهر", "%d شهرا", "%d شهر" ],
            y: [ "أقل من عام", "عام واحد", [ "عامان", "عامين" ], "%d أعوام", "%d عامًا", "%d عام" ]
        }, i = function(e) {
            return function(t, n, i, s) {
                var o = a(t), u = r[e][a(t)];
                return 2 === o && (u = u[n ? 0 : 1]), u.replace(/%d/i, t);
            };
        }, s = [ "كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر" ], o = e.defineLocale("ar", {
            months: s,
            monthsShort: s,
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "D/‏M/‏YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم عند الساعة] LT",
                nextDay: "[غدًا عند الساعة] LT",
                nextWeek: "dddd [عند الساعة] LT",
                lastDay: "[أمس عند الساعة] LT",
                lastWeek: "dddd [عند الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "بعد %s",
                past: "منذ %s",
                s: i("s"),
                m: i("m"),
                mm: i("m"),
                h: i("h"),
                hh: i("h"),
                d: i("d"),
                dd: i("d"),
                M: i("M"),
                MM: i("M"),
                y: i("y"),
                yy: i("y")
            },
            preparse: function(e) {
                return e.replace(/\u200f/g, "").replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return o;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Moroccan Arabic (ar-ma)
    //! author : ElFadili Yassine : https://github.com/ElFadiliY
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-ma", {
            months: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            weekdays: "الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Arabic Saudi Arabia (ar-sa)
    //! author : Suhail Alkowaileet : https://github.com/xsoh
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = e.defineLocale("ar-sa", {
            months: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            preparse: function(e) {
                return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale  : Tunisian Arabic (ar-tn)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-tn", {
            months: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : azerbaijani (az)
    //! author : topchiyev : https://github.com/topchiyev
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "-inci",
            5: "-inci",
            8: "-inci",
            70: "-inci",
            80: "-inci",
            2: "-nci",
            7: "-nci",
            20: "-nci",
            50: "-nci",
            3: "-üncü",
            4: "-üncü",
            100: "-üncü",
            6: "-ncı",
            9: "-uncu",
            10: "-uncu",
            30: "-uncu",
            60: "-ıncı",
            90: "-ıncı"
        }, n = e.defineLocale("az", {
            months: "yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),
            monthsShort: "yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),
            weekdays: "Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə".split("_"),
            weekdaysShort: "Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən".split("_"),
            weekdaysMin: "Bz_BE_ÇA_Çə_CA_Cü_Şə".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[sabah saat] LT",
                nextWeek: "[gələn həftə] dddd [saat] LT",
                lastDay: "[dünən] LT",
                lastWeek: "[keçən həftə] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s əvvəl",
                s: "birneçə saniyyə",
                m: "bir dəqiqə",
                mm: "%d dəqiqə",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir il",
                yy: "%d il"
            },
            meridiemParse: /gecə|səhər|gündüz|axşam/,
            isPM: function(e) {
                return /^(gündüz|axşam)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "gecə" : e < 12 ? "səhər" : e < 17 ? "gündüz" : "axşam";
            },
            ordinalParse: /\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,
            ordinal: function(e) {
                if (0 === e) return e + "-ıncı";
                var n = e % 10, a = e % 100 - n, r = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[r]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : belarusian (be)
    //! author : Dmitry Demidov : https://github.com/demidov91
    //! author: Praleska: http://praleska.pro/
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: n ? "хвіліна_хвіліны_хвілін" : "хвіліну_хвіліны_хвілін",
                hh: n ? "гадзіна_гадзіны_гадзін" : "гадзіну_гадзіны_гадзін",
                dd: "дзень_дні_дзён",
                MM: "месяц_месяцы_месяцаў",
                yy: "год_гады_гадоў"
            };
            return "m" === a ? n ? "хвіліна" : "хвіліну" : "h" === a ? n ? "гадзіна" : "гадзіну" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань".split("_"),
                accusative: "студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота".split("_"),
                accusative: "нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу".split("_")
            }, a = /\[ ?[Вв] ?(?:мінулую|наступную)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var i = e.defineLocale("be", {
            months: a,
            monthsShort: "студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж".split("_"),
            weekdays: r,
            weekdaysShort: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            weekdaysMin: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сёння ў] LT",
                nextDay: "[Заўтра ў] LT",
                lastDay: "[Учора ў] LT",
                nextWeek: function() {
                    return "[У] dddd [ў] LT";
                },
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return "[У мінулую] dddd [ў] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[У мінулы] dddd [ў] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "праз %s",
                past: "%s таму",
                s: "некалькі секунд",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "дзень",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночы|раніцы|дня|вечара/,
            isPM: function(e) {
                return /^(дня|вечара)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночы" : e < 12 ? "раніцы" : e < 17 ? "дня" : "вечара";
            },
            ordinalParse: /\d{1,2}-(і|ы|га)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e % 10 !== 2 && e % 10 !== 3 || e % 100 === 12 || e % 100 === 13 ? e + "-ы" : e + "-і";

                  case "D":
                    return e + "-га";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bulgarian (bg)
    //! author : Krasen Borisov : https://github.com/kraz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("bg", {
            months: "януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "янр_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "неделя_понеделник_вторник_сряда_четвъртък_петък_събота".split("_"),
            weekdaysShort: "нед_пон_вто_сря_чет_пет_съб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Днес в] LT",
                nextDay: "[Утре в] LT",
                nextWeek: "dddd [в] LT",
                lastDay: "[Вчера в] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[В изминалата] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[В изминалия] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "след %s",
                past: "преди %s",
                s: "няколко секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дни",
                M: "месец",
                MM: "%d месеца",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bengali (bn)
    //! author : Kaushik Gandhi : https://github.com/kaushikgandhi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "১",
            "2": "২",
            "3": "৩",
            "4": "৪",
            "5": "৫",
            "6": "৬",
            "7": "৭",
            "8": "৮",
            "9": "৯",
            "0": "০"
        }, n = {
            "১": "1",
            "২": "2",
            "৩": "3",
            "৪": "4",
            "৫": "5",
            "৬": "6",
            "৭": "7",
            "৮": "8",
            "৯": "9",
            "০": "0"
        }, a = e.defineLocale("bn", {
            months: "জানুয়ারী_ফেবুয়ারী_মার্চ_এপ্রিল_মে_জুন_জুলাই_অগাস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),
            monthsShort: "জানু_ফেব_মার্চ_এপর_মে_জুন_জুল_অগ_সেপ্ট_অক্টো_নভ_ডিসেম্".split("_"),
            weekdays: "রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পত্তিবার_শুক্রুবার_শনিবার".split("_"),
            weekdaysShort: "রবি_সোম_মঙ্গল_বুধ_বৃহস্পত্তি_শুক্রু_শনি".split("_"),
            weekdaysMin: "রব_সম_মঙ্গ_বু_ব্রিহ_শু_শনি".split("_"),
            longDateFormat: {
                LT: "A h:mm সময়",
                LTS: "A h:mm:ss সময়",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm সময়",
                LLLL: "dddd, D MMMM YYYY, A h:mm সময়"
            },
            calendar: {
                sameDay: "[আজ] LT",
                nextDay: "[আগামীকাল] LT",
                nextWeek: "dddd, LT",
                lastDay: "[গতকাল] LT",
                lastWeek: "[গত] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s পরে",
                past: "%s আগে",
                s: "কএক সেকেন্ড",
                m: "এক মিনিট",
                mm: "%d মিনিট",
                h: "এক ঘন্টা",
                hh: "%d ঘন্টা",
                d: "এক দিন",
                dd: "%d দিন",
                M: "এক মাস",
                MM: "%d মাস",
                y: "এক বছর",
                yy: "%d বছর"
            },
            preparse: function(e) {
                return e.replace(/[১২৩৪৫৬৭৮৯০]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /রাত|সকাল|দুপুর|বিকেল|রাত/,
            isPM: function(e) {
                return /^(দুপুর|বিকেল|রাত)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "রাত" : e < 10 ? "সকাল" : e < 17 ? "দুপুর" : e < 20 ? "বিকেল" : "রাত";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tibetan (bo)
    //! author : Thupten N. Chakrishar : https://github.com/vajradog
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "༡",
            "2": "༢",
            "3": "༣",
            "4": "༤",
            "5": "༥",
            "6": "༦",
            "7": "༧",
            "8": "༨",
            "9": "༩",
            "0": "༠"
        }, n = {
            "༡": "1",
            "༢": "2",
            "༣": "3",
            "༤": "4",
            "༥": "5",
            "༦": "6",
            "༧": "7",
            "༨": "8",
            "༩": "9",
            "༠": "0"
        }, a = e.defineLocale("bo", {
            months: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            monthsShort: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            weekdays: "གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་".split("_"),
            weekdaysShort: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            weekdaysMin: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            longDateFormat: {
                LT: "A h:mm",
                LTS: "A h:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm",
                LLLL: "dddd, D MMMM YYYY, A h:mm"
            },
            calendar: {
                sameDay: "[དི་རིང] LT",
                nextDay: "[སང་ཉིན] LT",
                nextWeek: "[བདུན་ཕྲག་རྗེས་མ], LT",
                lastDay: "[ཁ་སང] LT",
                lastWeek: "[བདུན་ཕྲག་མཐའ་མ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s ལ་",
                past: "%s སྔན་ལ",
                s: "ལམ་སང",
                m: "སྐར་མ་གཅིག",
                mm: "%d སྐར་མ",
                h: "ཆུ་ཚོད་གཅིག",
                hh: "%d ཆུ་ཚོད",
                d: "ཉིན་གཅིག",
                dd: "%d ཉིན་",
                M: "ཟླ་བ་གཅིག",
                MM: "%d ཟླ་བ",
                y: "ལོ་གཅིག",
                yy: "%d ལོ"
            },
            preparse: function(e) {
                return e.replace(/[༡༢༣༤༥༦༧༨༩༠]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,
            isPM: function(e) {
                return /^(ཉིན་གུང|དགོང་དག|མཚན་མོ)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "མཚན་མོ" : e < 10 ? "ཞོགས་ཀས" : e < 17 ? "ཉིན་གུང" : e < 20 ? "དགོང་དག" : "མཚན་མོ";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : breton (br)
    //! author : Jean-Baptiste Le Duigou : https://github.com/jbleduigou
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "munutenn",
                MM: "miz",
                dd: "devezh"
            };
            return e + " " + r(a[n], e);
        }
        function n(e) {
            switch (a(e)) {
              case 1:
              case 3:
              case 4:
              case 5:
              case 9:
                return e + " bloaz";

              default:
                return e + " vloaz";
            }
        }
        function a(e) {
            return e > 9 ? a(e % 10) : e;
        }
        function r(e, t) {
            return 2 === t ? i(e) : e;
        }
        function i(e) {
            var t = {
                m: "v",
                b: "v",
                d: "z"
            };
            return void 0 === t[e.charAt(0)] ? e : t[e.charAt(0)] + e.substring(1);
        }
        var s = e.defineLocale("br", {
            months: "Genver_C'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),
            monthsShort: "Gen_C'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),
            weekdays: "Sul_Lun_Meurzh_Merc'her_Yaou_Gwener_Sadorn".split("_"),
            weekdaysShort: "Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "h[e]mm A",
                LTS: "h[e]mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D [a viz] MMMM YYYY",
                LLL: "D [a viz] MMMM YYYY h[e]mm A",
                LLLL: "dddd, D [a viz] MMMM YYYY h[e]mm A"
            },
            calendar: {
                sameDay: "[Hiziv da] LT",
                nextDay: "[Warc'hoazh da] LT",
                nextWeek: "dddd [da] LT",
                lastDay: "[Dec'h da] LT",
                lastWeek: "dddd [paset da] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "a-benn %s",
                past: "%s 'zo",
                s: "un nebeud segondennoù",
                m: "ur vunutenn",
                mm: t,
                h: "un eur",
                hh: "%d eur",
                d: "un devezh",
                dd: t,
                M: "ur miz",
                MM: t,
                y: "ur bloaz",
                yy: n
            },
            ordinalParse: /\d{1,2}(añ|vet)/,
            ordinal: function(e) {
                var t = 1 === e ? "añ" : "vet";
                return e + t;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bosnian (bs)
    //! author : Nedim Cholich : https://github.com/frontyard
    //! based on (hr) translation by Bojan Marković
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("bs", {
            months: "januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : catalan (ca)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ca", {
            months: "gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),
            monthsShort: "gen._febr._mar._abr._mai._jun._jul._ag._set._oct._nov._des.".split("_"),
            weekdays: "diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),
            weekdaysShort: "dg._dl._dt._dc._dj._dv._ds.".split("_"),
            weekdaysMin: "Dg_Dl_Dt_Dc_Dj_Dv_Ds".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "LT:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[avui a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextDay: function() {
                    return "[demà a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastDay: function() {
                    return "[ahir a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [passat a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "fa %s",
                s: "uns segons",
                m: "un minut",
                mm: "%d minuts",
                h: "una hora",
                hh: "%d hores",
                d: "un dia",
                dd: "%d dies",
                M: "un mes",
                MM: "%d mesos",
                y: "un any",
                yy: "%d anys"
            },
            ordinalParse: /\d{1,2}(r|n|t|è|a)/,
            ordinal: function(e, t) {
                var n = 1 === e ? "r" : 2 === e ? "n" : 3 === e ? "r" : 4 === e ? "t" : "è";
                return "w" !== t && "W" !== t || (n = "a"), e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : czech (cs)
    //! author : petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5 && 1 !== ~~(e / 10);
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "pár sekund" : "pár sekundami";

              case "m":
                return n ? "minuta" : r ? "minutu" : "minutou";

              case "mm":
                return n || r ? i + (t(e) ? "minuty" : "minut") : i + "minutami";

              case "h":
                return n ? "hodina" : r ? "hodinu" : "hodinou";

              case "hh":
                return n || r ? i + (t(e) ? "hodiny" : "hodin") : i + "hodinami";

              case "d":
                return n || r ? "den" : "dnem";

              case "dd":
                return n || r ? i + (t(e) ? "dny" : "dní") : i + "dny";

              case "M":
                return n || r ? "měsíc" : "měsícem";

              case "MM":
                return n || r ? i + (t(e) ? "měsíce" : "měsíců") : i + "měsíci";

              case "y":
                return n || r ? "rok" : "rokem";

              case "yy":
                return n || r ? i + (t(e) ? "roky" : "let") : i + "lety";
            }
        }
        var a = "leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec".split("_"), r = "led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro".split("_"), i = e.defineLocale("cs", {
            months: a,
            monthsShort: r,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, r),
            weekdays: "neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota".split("_"),
            weekdaysShort: "ne_po_út_st_čt_pá_so".split("_"),
            weekdaysMin: "ne_po_út_st_čt_pá_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes v] LT",
                nextDay: "[zítra v] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v neděli v] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [v] LT";

                      case 3:
                        return "[ve středu v] LT";

                      case 4:
                        return "[ve čtvrtek v] LT";

                      case 5:
                        return "[v pátek v] LT";

                      case 6:
                        return "[v sobotu v] LT";
                    }
                },
                lastDay: "[včera v] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulou neděli v] LT";

                      case 1:
                      case 2:
                        return "[minulé] dddd [v] LT";

                      case 3:
                        return "[minulou středu v] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [v] LT";

                      case 6:
                        return "[minulou sobotu v] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "před %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chuvash (cv)
    //! author : Anatoly Mironov : https://github.com/mirontoli
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cv", {
            months: "кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав".split("_"),
            monthsShort: "кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш".split("_"),
            weekdays: "вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун".split("_"),
            weekdaysShort: "выр_тун_ытл_юн_кӗҫ_эрн_шӑм".split("_"),
            weekdaysMin: "вр_тн_ыт_юн_кҫ_эр_шм".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]",
                LLL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm",
                LLLL: "dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm"
            },
            calendar: {
                sameDay: "[Паян] LT [сехетре]",
                nextDay: "[Ыран] LT [сехетре]",
                lastDay: "[Ӗнер] LT [сехетре]",
                nextWeek: "[Ҫитес] dddd LT [сехетре]",
                lastWeek: "[Иртнӗ] dddd LT [сехетре]",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    var t = /сехет$/i.exec(e) ? "рен" : /ҫул$/i.exec(e) ? "тан" : "ран";
                    return e + t;
                },
                past: "%s каялла",
                s: "пӗр-ик ҫеккунт",
                m: "пӗр минут",
                mm: "%d минут",
                h: "пӗр сехет",
                hh: "%d сехет",
                d: "пӗр кун",
                dd: "%d кун",
                M: "пӗр уйӑх",
                MM: "%d уйӑх",
                y: "пӗр ҫул",
                yy: "%d ҫул"
            },
            ordinalParse: /\d{1,2}-мӗш/,
            ordinal: "%d-мӗш",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Welsh (cy)
    //! author : Robert Allen
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cy", {
            months: "Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),
            monthsShort: "Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),
            weekdays: "Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),
            weekdaysShort: "Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heddiw am] LT",
                nextDay: "[Yfory am] LT",
                nextWeek: "dddd [am] LT",
                lastDay: "[Ddoe am] LT",
                lastWeek: "dddd [diwethaf am] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "mewn %s",
                past: "%s yn ôl",
                s: "ychydig eiliadau",
                m: "munud",
                mm: "%d munud",
                h: "awr",
                hh: "%d awr",
                d: "diwrnod",
                dd: "%d diwrnod",
                M: "mis",
                MM: "%d mis",
                y: "blwyddyn",
                yy: "%d flynedd"
            },
            ordinalParse: /\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,
            ordinal: function(e) {
                var t = e, n = "", a = [ "", "af", "il", "ydd", "ydd", "ed", "ed", "ed", "fed", "fed", "fed", "eg", "fed", "eg", "eg", "fed", "eg", "eg", "fed", "eg", "fed" ];
                return t > 20 ? n = 40 === t || 50 === t || 60 === t || 80 === t || 100 === t ? "fed" : "ain" : t > 0 && (n = a[t]), 
                e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : danish (da)
    //! author : Ulrik Nielsen : https://github.com/mrbase
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("da", {
            months: "januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tir_ons_tor_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd [d.] D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag kl.] LT",
                nextDay: "[I morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[I går kl.] LT",
                lastWeek: "[sidste] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "%s siden",
                s: "få sekunder",
                m: "et minut",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dage",
                M: "en måned",
                MM: "%d måneder",
                y: "et år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : german (de)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("de", {
            months: "Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : austrian german (de-at)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    //! author : Martin Groller : https://github.com/MadMG
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("de-at", {
            months: "Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : modern greek (el)
    //! author : Aggelos Karalias : https://github.com/mehiel
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("el", {
            monthsNominativeEl: "Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος".split("_"),
            monthsGenitiveEl: "Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου".split("_"),
            months: function(e, t) {
                return /D/.test(t.substring(0, t.indexOf("MMMM"))) ? this._monthsGenitiveEl[e.month()] : this._monthsNominativeEl[e.month()];
            },
            monthsShort: "Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ".split("_"),
            weekdays: "Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο".split("_"),
            weekdaysShort: "Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ".split("_"),
            weekdaysMin: "Κυ_Δε_Τρ_Τε_Πε_Πα_Σα".split("_"),
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "μμ" : "ΜΜ" : n ? "πμ" : "ΠΜ";
            },
            isPM: function(e) {
                return "μ" === (e + "").toLowerCase()[0];
            },
            meridiemParse: /[ΠΜ]\.?Μ?\.?/i,
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendarEl: {
                sameDay: "[Σήμερα {}] LT",
                nextDay: "[Αύριο {}] LT",
                nextWeek: "dddd [{}] LT",
                lastDay: "[Χθες {}] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 6:
                        return "[το προηγούμενο] dddd [{}] LT";

                      default:
                        return "[την προηγούμενη] dddd [{}] LT";
                    }
                },
                sameElse: "L"
            },
            calendar: function(e, t) {
                var n = this._calendarEl[e], a = t && t.hours();
                return "function" == typeof n && (n = n.apply(t)), n.replace("{}", a % 12 === 1 ? "στη" : "στις");
            },
            relativeTime: {
                future: "σε %s",
                past: "%s πριν",
                s: "λίγα δευτερόλεπτα",
                m: "ένα λεπτό",
                mm: "%d λεπτά",
                h: "μία ώρα",
                hh: "%d ώρες",
                d: "μία μέρα",
                dd: "%d μέρες",
                M: "ένας μήνας",
                MM: "%d μήνες",
                y: "ένας χρόνος",
                yy: "%d χρόνια"
            },
            ordinalParse: /\d{1,2}η/,
            ordinal: "%dη",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : australian english (en-au)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-au", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian english (en-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-ca", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "YYYY-MM-DD",
                LL: "D MMMM, YYYY",
                LLL: "D MMMM, YYYY h:mm A",
                LLLL: "dddd, D MMMM, YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : great britain english (en-gb)
    //! author : Chris Gedrim : https://github.com/chrisgedrim
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-gb", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : esperanto (eo)
    //! author : Colin Dean : https://github.com/colindean
    //! komento: Mi estas malcerta se mi korekte traktis akuzativojn en tiu traduko.
    //!          Se ne, bonvolu korekti kaj avizi min por ke mi povas lerni!
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eo", {
            months: "januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aŭg_sep_okt_nov_dec".split("_"),
            weekdays: "Dimanĉo_Lundo_Mardo_Merkredo_Ĵaŭdo_Vendredo_Sabato".split("_"),
            weekdaysShort: "Dim_Lun_Mard_Merk_Ĵaŭ_Ven_Sab".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Ĵa_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D[-an de] MMMM, YYYY",
                LLL: "D[-an de] MMMM, YYYY HH:mm",
                LLLL: "dddd, [la] D[-an de] MMMM, YYYY HH:mm"
            },
            meridiemParse: /[ap]\.t\.m/i,
            isPM: function(e) {
                return "p" === e.charAt(0).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "p.t.m." : "P.T.M." : n ? "a.t.m." : "A.T.M.";
            },
            calendar: {
                sameDay: "[Hodiaŭ je] LT",
                nextDay: "[Morgaŭ je] LT",
                nextWeek: "dddd [je] LT",
                lastDay: "[Hieraŭ je] LT",
                lastWeek: "[pasinta] dddd [je] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "je %s",
                past: "antaŭ %s",
                s: "sekundoj",
                m: "minuto",
                mm: "%d minutoj",
                h: "horo",
                hh: "%d horoj",
                d: "tago",
                dd: "%d tagoj",
                M: "monato",
                MM: "%d monatoj",
                y: "jaro",
                yy: "%d jaroj"
            },
            ordinalParse: /\d{1,2}a/,
            ordinal: "%da",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : spanish (es)
    //! author : Julio Napurí : https://github.com/julionc
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "Ene._Feb._Mar._Abr._May._Jun._Jul._Ago._Sep._Oct._Nov._Dic.".split("_"), n = "Ene_Feb_Mar_Abr_May_Jun_Jul_Ago_Sep_Oct_Nov_Dic".split("_"), a = e.defineLocale("es", {
            months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "Domingo_Lunes_Martes_Miércoles_Jueves_Viernes_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mié._Jue._Vie._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY H:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoy a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextDay: function() {
                    return "[mañana a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastDay: function() {
                    return "[ayer a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [pasado a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "hace %s",
                s: "unos segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "una hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un año",
                yy: "%d años"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : estonian (et)
    //! author : Henry Kehlmann : https://github.com/madhenry
    //! improvements : Illimar Tambek : https://github.com/ragulka
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                s: [ "mõne sekundi", "mõni sekund", "paar sekundit" ],
                m: [ "ühe minuti", "üks minut" ],
                mm: [ e + " minuti", e + " minutit" ],
                h: [ "ühe tunni", "tund aega", "üks tund" ],
                hh: [ e + " tunni", e + " tundi" ],
                d: [ "ühe päeva", "üks päev" ],
                M: [ "kuu aja", "kuu aega", "üks kuu" ],
                MM: [ e + " kuu", e + " kuud" ],
                y: [ "ühe aasta", "aasta", "üks aasta" ],
                yy: [ e + " aasta", e + " aastat" ]
            };
            return t ? r[n][2] ? r[n][2] : r[n][1] : a ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("et", {
            months: "jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),
            monthsShort: "jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),
            weekdays: "pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev".split("_"),
            weekdaysShort: "P_E_T_K_N_R_L".split("_"),
            weekdaysMin: "P_E_T_K_N_R_L".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Täna,] LT",
                nextDay: "[Homme,] LT",
                nextWeek: "[Järgmine] dddd LT",
                lastDay: "[Eile,] LT",
                lastWeek: "[Eelmine] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s pärast",
                past: "%s tagasi",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: "%d päeva",
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : euskara (eu)
    //! author : Eneko Illarramendi : https://github.com/eillarra
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eu", {
            months: "urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),
            monthsShort: "urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),
            weekdays: "igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),
            weekdaysShort: "ig._al._ar._az._og._ol._lr.".split("_"),
            weekdaysMin: "ig_al_ar_az_og_ol_lr".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY[ko] MMMM[ren] D[a]",
                LLL: "YYYY[ko] MMMM[ren] D[a] HH:mm",
                LLLL: "dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",
                l: "YYYY-M-D",
                ll: "YYYY[ko] MMM D[a]",
                lll: "YYYY[ko] MMM D[a] HH:mm",
                llll: "ddd, YYYY[ko] MMM D[a] HH:mm"
            },
            calendar: {
                sameDay: "[gaur] LT[etan]",
                nextDay: "[bihar] LT[etan]",
                nextWeek: "dddd LT[etan]",
                lastDay: "[atzo] LT[etan]",
                lastWeek: "[aurreko] dddd LT[etan]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s barru",
                past: "duela %s",
                s: "segundo batzuk",
                m: "minutu bat",
                mm: "%d minutu",
                h: "ordu bat",
                hh: "%d ordu",
                d: "egun bat",
                dd: "%d egun",
                M: "hilabete bat",
                MM: "%d hilabete",
                y: "urte bat",
                yy: "%d urte"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Persian (fa)
    //! author : Ebrahim Byagowi : https://github.com/ebraminio
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "۱",
            "2": "۲",
            "3": "۳",
            "4": "۴",
            "5": "۵",
            "6": "۶",
            "7": "۷",
            "8": "۸",
            "9": "۹",
            "0": "۰"
        }, n = {
            "۱": "1",
            "۲": "2",
            "۳": "3",
            "۴": "4",
            "۵": "5",
            "۶": "6",
            "۷": "7",
            "۸": "8",
            "۹": "9",
            "۰": "0"
        }, a = e.defineLocale("fa", {
            months: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            monthsShort: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            weekdays: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysShort: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysMin: "ی_د_س_چ_پ_ج_ش".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            meridiemParse: /قبل از ظهر|بعد از ظهر/,
            isPM: function(e) {
                return /بعد از ظهر/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "قبل از ظهر" : "بعد از ظهر";
            },
            calendar: {
                sameDay: "[امروز ساعت] LT",
                nextDay: "[فردا ساعت] LT",
                nextWeek: "dddd [ساعت] LT",
                lastDay: "[دیروز ساعت] LT",
                lastWeek: "dddd [پیش] [ساعت] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "در %s",
                past: "%s پیش",
                s: "چندین ثانیه",
                m: "یک دقیقه",
                mm: "%d دقیقه",
                h: "یک ساعت",
                hh: "%d ساعت",
                d: "یک روز",
                dd: "%d روز",
                M: "یک ماه",
                MM: "%d ماه",
                y: "یک سال",
                yy: "%d سال"
            },
            preparse: function(e) {
                return e.replace(/[۰-۹]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            ordinalParse: /\d{1,2}م/,
            ordinal: "%dم",
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : finnish (fi)
    //! author : Tarmo Aidantausta : https://github.com/bleadof
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, a, r) {
            var i = "";
            switch (a) {
              case "s":
                return r ? "muutaman sekunnin" : "muutama sekunti";

              case "m":
                return r ? "minuutin" : "minuutti";

              case "mm":
                i = r ? "minuutin" : "minuuttia";
                break;

              case "h":
                return r ? "tunnin" : "tunti";

              case "hh":
                i = r ? "tunnin" : "tuntia";
                break;

              case "d":
                return r ? "päivän" : "päivä";

              case "dd":
                i = r ? "päivän" : "päivää";
                break;

              case "M":
                return r ? "kuukauden" : "kuukausi";

              case "MM":
                i = r ? "kuukauden" : "kuukautta";
                break;

              case "y":
                return r ? "vuoden" : "vuosi";

              case "yy":
                i = r ? "vuoden" : "vuotta";
            }
            return i = n(e, r) + " " + i;
        }
        function n(e, t) {
            return e < 10 ? t ? r[e] : a[e] : e;
        }
        var a = "nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän".split(" "), r = [ "nolla", "yhden", "kahden", "kolmen", "neljän", "viiden", "kuuden", a[7], a[8], a[9] ], i = e.defineLocale("fi", {
            months: "tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),
            monthsShort: "tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu".split("_"),
            weekdays: "sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),
            weekdaysShort: "su_ma_ti_ke_to_pe_la".split("_"),
            weekdaysMin: "su_ma_ti_ke_to_pe_la".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD.MM.YYYY",
                LL: "Do MMMM[ta] YYYY",
                LLL: "Do MMMM[ta] YYYY, [klo] HH.mm",
                LLLL: "dddd, Do MMMM[ta] YYYY, [klo] HH.mm",
                l: "D.M.YYYY",
                ll: "Do MMM YYYY",
                lll: "Do MMM YYYY, [klo] HH.mm",
                llll: "ddd, Do MMM YYYY, [klo] HH.mm"
            },
            calendar: {
                sameDay: "[tänään] [klo] LT",
                nextDay: "[huomenna] [klo] LT",
                nextWeek: "dddd [klo] LT",
                lastDay: "[eilen] [klo] LT",
                lastWeek: "[viime] dddd[na] [klo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s päästä",
                past: "%s sitten",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : faroese (fo)
    //! author : Ragnar Johannesen : https://github.com/ragnar123
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fo", {
            months: "januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur".split("_"),
            weekdaysShort: "sun_mán_týs_mik_hós_frí_ley".split("_"),
            weekdaysMin: "su_má_tý_mi_hó_fr_le".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D. MMMM, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Í dag kl.] LT",
                nextDay: "[Í morgin kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[Í gjár kl.] LT",
                lastWeek: "[síðstu] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "um %s",
                past: "%s síðani",
                s: "fá sekund",
                m: "ein minutt",
                mm: "%d minuttir",
                h: "ein tími",
                hh: "%d tímar",
                d: "ein dagur",
                dd: "%d dagar",
                M: "ein mánaði",
                MM: "%d mánaðir",
                y: "eitt ár",
                yy: "%d ár"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : french (fr)
    //! author : John Fischer : https://github.com/jfroffice
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian french (fr-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr-ca", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|e)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "e");
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : frisian (fy)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_"), n = "jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"), a = e.defineLocale("fy", {
            months: "jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),
            weekdaysShort: "si._mo._ti._wo._to._fr._so.".split("_"),
            weekdaysMin: "Si_Mo_Ti_Wo_To_Fr_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[hjoed om] LT",
                nextDay: "[moarn om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[juster om] LT",
                lastWeek: "[ôfrûne] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oer %s",
                past: "%s lyn",
                s: "in pear sekonden",
                m: "ien minút",
                mm: "%d minuten",
                h: "ien oere",
                hh: "%d oeren",
                d: "ien dei",
                dd: "%d dagen",
                M: "ien moanne",
                MM: "%d moannen",
                y: "ien jier",
                yy: "%d jierren"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : galician (gl)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("gl", {
            months: "Xaneiro_Febreiro_Marzo_Abril_Maio_Xuño_Xullo_Agosto_Setembro_Outubro_Novembro_Decembro".split("_"),
            monthsShort: "Xan._Feb._Mar._Abr._Mai._Xuñ._Xul._Ago._Set._Out._Nov._Dec.".split("_"),
            weekdays: "Domingo_Luns_Martes_Mércores_Xoves_Venres_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mér._Xov._Ven._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mé_Xo_Ve_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoxe " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextDay: function() {
                    return "[mañá " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [" + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                lastDay: function() {
                    return "[onte " + (1 !== this.hours() ? "á" : "a") + "] LT";
                },
                lastWeek: function() {
                    return "[o] dddd [pasado " + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return "uns segundos" === e ? "nuns segundos" : "en " + e;
                },
                past: "hai %s",
                s: "uns segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "unha hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Hebrew (he)
    //! author : Tomer Cohen : https://github.com/tomer
    //! author : Moshe Simantov : https://github.com/DevelopmentIL
    //! author : Tal Ater : https://github.com/TalAter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("he", {
            months: "ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר".split("_"),
            monthsShort: "ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳".split("_"),
            weekdays: "ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת".split("_"),
            weekdaysShort: "א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳".split("_"),
            weekdaysMin: "א_ב_ג_ד_ה_ו_ש".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [ב]MMMM YYYY",
                LLL: "D [ב]MMMM YYYY HH:mm",
                LLLL: "dddd, D [ב]MMMM YYYY HH:mm",
                l: "D/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[היום ב־]LT",
                nextDay: "[מחר ב־]LT",
                nextWeek: "dddd [בשעה] LT",
                lastDay: "[אתמול ב־]LT",
                lastWeek: "[ביום] dddd [האחרון בשעה] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "בעוד %s",
                past: "לפני %s",
                s: "מספר שניות",
                m: "דקה",
                mm: "%d דקות",
                h: "שעה",
                hh: function(e) {
                    return 2 === e ? "שעתיים" : e + " שעות";
                },
                d: "יום",
                dd: function(e) {
                    return 2 === e ? "יומיים" : e + " ימים";
                },
                M: "חודש",
                MM: function(e) {
                    return 2 === e ? "חודשיים" : e + " חודשים";
                },
                y: "שנה",
                yy: function(e) {
                    return 2 === e ? "שנתיים" : e % 10 === 0 && 10 !== e ? e + " שנה" : e + " שנים";
                }
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hindi (hi)
    //! author : Mayank Singhal : https://github.com/mayanksinghal
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("hi", {
            months: "जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर".split("_"),
            monthsShort: "जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.".split("_"),
            weekdays: "रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm बजे",
                LTS: "A h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, A h:mm बजे"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[कल] LT",
                nextWeek: "dddd, LT",
                lastDay: "[कल] LT",
                lastWeek: "[पिछले] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s में",
                past: "%s पहले",
                s: "कुछ ही क्षण",
                m: "एक मिनट",
                mm: "%d मिनट",
                h: "एक घंटा",
                hh: "%d घंटे",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महीने",
                MM: "%d महीने",
                y: "एक वर्ष",
                yy: "%d वर्ष"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात|सुबह|दोपहर|शाम/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात" === t ? e < 4 ? e : e + 12 : "सुबह" === t ? e : "दोपहर" === t ? e >= 10 ? e : e + 12 : "शाम" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात" : e < 10 ? "सुबह" : e < 17 ? "दोपहर" : e < 20 ? "शाम" : "रात";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hrvatski (hr)
    //! author : Bojan Marković : https://github.com/bmarkovic
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("hr", {
            months: "siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_"),
            monthsShort: "sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hungarian (hu)
    //! author : Adam Brunner : https://github.com/adambrunner
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = e;
            switch (n) {
              case "s":
                return a || t ? "néhány másodperc" : "néhány másodperce";

              case "m":
                return "egy" + (a || t ? " perc" : " perce");

              case "mm":
                return r + (a || t ? " perc" : " perce");

              case "h":
                return "egy" + (a || t ? " óra" : " órája");

              case "hh":
                return r + (a || t ? " óra" : " órája");

              case "d":
                return "egy" + (a || t ? " nap" : " napja");

              case "dd":
                return r + (a || t ? " nap" : " napja");

              case "M":
                return "egy" + (a || t ? " hónap" : " hónapja");

              case "MM":
                return r + (a || t ? " hónap" : " hónapja");

              case "y":
                return "egy" + (a || t ? " év" : " éve");

              case "yy":
                return r + (a || t ? " év" : " éve");
            }
            return "";
        }
        function n(e) {
            return (e ? "" : "[múlt] ") + "[" + a[this.day()] + "] LT[-kor]";
        }
        var a = "vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton".split(" "), r = e.defineLocale("hu", {
            months: "január_február_március_április_május_június_július_augusztus_szeptember_október_november_december".split("_"),
            monthsShort: "jan_feb_márc_ápr_máj_jún_júl_aug_szept_okt_nov_dec".split("_"),
            weekdays: "vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat".split("_"),
            weekdaysShort: "vas_hét_kedd_sze_csüt_pén_szo".split("_"),
            weekdaysMin: "v_h_k_sze_cs_p_szo".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "YYYY.MM.DD.",
                LL: "YYYY. MMMM D.",
                LLL: "YYYY. MMMM D. H:mm",
                LLLL: "YYYY. MMMM D., dddd H:mm"
            },
            meridiemParse: /de|du/i,
            isPM: function(e) {
                return "u" === e.charAt(1).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n === !0 ? "de" : "DE" : n === !0 ? "du" : "DU";
            },
            calendar: {
                sameDay: "[ma] LT[-kor]",
                nextDay: "[holnap] LT[-kor]",
                nextWeek: function() {
                    return n.call(this, !0);
                },
                lastDay: "[tegnap] LT[-kor]",
                lastWeek: function() {
                    return n.call(this, !1);
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s múlva",
                past: "%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Armenian (hy-am)
    //! author : Armendarabyan : https://github.com/armendarabyan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր".split("_"),
                accusative: "հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = "հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ".split("_");
            return n[e.month()];
        }
        function a(e, t) {
            var n = "կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ".split("_");
            return n[e.day()];
        }
        var r = e.defineLocale("hy-am", {
            months: t,
            monthsShort: n,
            weekdays: a,
            weekdaysShort: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            weekdaysMin: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY թ.",
                LLL: "D MMMM YYYY թ., HH:mm",
                LLLL: "dddd, D MMMM YYYY թ., HH:mm"
            },
            calendar: {
                sameDay: "[այսօր] LT",
                nextDay: "[վաղը] LT",
                lastDay: "[երեկ] LT",
                nextWeek: function() {
                    return "dddd [օրը ժամը] LT";
                },
                lastWeek: function() {
                    return "[անցած] dddd [օրը ժամը] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s հետո",
                past: "%s առաջ",
                s: "մի քանի վայրկյան",
                m: "րոպե",
                mm: "%d րոպե",
                h: "ժամ",
                hh: "%d ժամ",
                d: "օր",
                dd: "%d օր",
                M: "ամիս",
                MM: "%d ամիս",
                y: "տարի",
                yy: "%d տարի"
            },
            meridiemParse: /գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,
            isPM: function(e) {
                return /^(ցերեկվա|երեկոյան)$/.test(e);
            },
            meridiem: function(e) {
                return e < 4 ? "գիշերվա" : e < 12 ? "առավոտվա" : e < 17 ? "ցերեկվա" : "երեկոյան";
            },
            ordinalParse: /\d{1,2}|\d{1,2}-(ին|րդ)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "DDD":
                  case "w":
                  case "W":
                  case "DDDo":
                    return 1 === e ? e + "-ին" : e + "-րդ";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Indonesia (id)
    //! author : Mohammad Satrio Utomo : https://github.com/tyok
    //! reference: http://id.wikisource.org/wiki/Pedoman_Umum_Ejaan_Bahasa_Indonesia_yang_Disempurnakan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("id", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|siang|sore|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "siang" === t ? e >= 11 ? e : e + 12 : "sore" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "siang" : e < 19 ? "sore" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Besok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kemarin pukul] LT",
                lastWeek: "dddd [lalu pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lalu",
                s: "beberapa detik",
                m: "semenit",
                mm: "%d menit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : icelandic (is)
    //! author : Hinrik Örn Sigurðsson : https://github.com/hinrik
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 100 === 11 || e % 10 !== 1;
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "nokkrar sekúndur" : "nokkrum sekúndum";

              case "m":
                return n ? "mínúta" : "mínútu";

              case "mm":
                return t(e) ? i + (n || r ? "mínútur" : "mínútum") : n ? i + "mínúta" : i + "mínútu";

              case "hh":
                return t(e) ? i + (n || r ? "klukkustundir" : "klukkustundum") : i + "klukkustund";

              case "d":
                return n ? "dagur" : r ? "dag" : "degi";

              case "dd":
                return t(e) ? n ? i + "dagar" : i + (r ? "daga" : "dögum") : n ? i + "dagur" : i + (r ? "dag" : "degi");

              case "M":
                return n ? "mánuður" : r ? "mánuð" : "mánuði";

              case "MM":
                return t(e) ? n ? i + "mánuðir" : i + (r ? "mánuði" : "mánuðum") : n ? i + "mánuður" : i + (r ? "mánuð" : "mánuði");

              case "y":
                return n || r ? "ár" : "ári";

              case "yy":
                return t(e) ? i + (n || r ? "ár" : "árum") : i + (n || r ? "ár" : "ári");
            }
        }
        var a = e.defineLocale("is", {
            months: "janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des".split("_"),
            weekdays: "sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur".split("_"),
            weekdaysShort: "sun_mán_þri_mið_fim_fös_lau".split("_"),
            weekdaysMin: "Su_Má_Þr_Mi_Fi_Fö_La".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H:mm",
                LLLL: "dddd, D. MMMM YYYY [kl.] H:mm"
            },
            calendar: {
                sameDay: "[í dag kl.] LT",
                nextDay: "[á morgun kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[í gær kl.] LT",
                lastWeek: "[síðasta] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "eftir %s",
                past: "fyrir %s síðan",
                s: n,
                m: n,
                mm: n,
                h: "klukkustund",
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : italian (it)
    //! author : Lorenzo : https://github.com/aliem
    //! author: Mattia Larentis: https://github.com/nostalgiaz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("it", {
            months: "gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),
            monthsShort: "gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),
            weekdays: "Domenica_Lunedì_Martedì_Mercoledì_Giovedì_Venerdì_Sabato".split("_"),
            weekdaysShort: "Dom_Lun_Mar_Mer_Gio_Ven_Sab".split("_"),
            weekdaysMin: "D_L_Ma_Me_G_V_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Oggi alle] LT",
                nextDay: "[Domani alle] LT",
                nextWeek: "dddd [alle] LT",
                lastDay: "[Ieri alle] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[la scorsa] dddd [alle] LT";

                      default:
                        return "[lo scorso] dddd [alle] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return (/^[0-9].+$/.test(e) ? "tra" : "in") + " " + e;
                },
                past: "%s fa",
                s: "alcuni secondi",
                m: "un minuto",
                mm: "%d minuti",
                h: "un'ora",
                hh: "%d ore",
                d: "un giorno",
                dd: "%d giorni",
                M: "un mese",
                MM: "%d mesi",
                y: "un anno",
                yy: "%d anni"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : japanese (ja)
    //! author : LI Long : https://github.com/baryon
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ja", {
            months: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),
            weekdaysShort: "日_月_火_水_木_金_土".split("_"),
            weekdaysMin: "日_月_火_水_木_金_土".split("_"),
            longDateFormat: {
                LT: "Ah時m分",
                LTS: "Ah時m分s秒",
                L: "YYYY/MM/DD",
                LL: "YYYY年M月D日",
                LLL: "YYYY年M月D日Ah時m分",
                LLLL: "YYYY年M月D日Ah時m分 dddd"
            },
            meridiemParse: /午前|午後/i,
            isPM: function(e) {
                return "午後" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "午前" : "午後";
            },
            calendar: {
                sameDay: "[今日] LT",
                nextDay: "[明日] LT",
                nextWeek: "[来週]dddd LT",
                lastDay: "[昨日] LT",
                lastWeek: "[前週]dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s後",
                past: "%s前",
                s: "数秒",
                m: "1分",
                mm: "%d分",
                h: "1時間",
                hh: "%d時間",
                d: "1日",
                dd: "%d日",
                M: "1ヶ月",
                MM: "%dヶ月",
                y: "1年",
                yy: "%d年"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Boso Jowo (jv)
    //! author : Rony Lantip : https://github.com/lantip
    //! reference: http://jv.wikipedia.org/wiki/Basa_Jawa
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("jv", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),
            weekdays: "Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /enjing|siyang|sonten|ndalu/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "enjing" === t ? e : "siyang" === t ? e >= 11 ? e : e + 12 : "sonten" === t || "ndalu" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "enjing" : e < 15 ? "siyang" : e < 19 ? "sonten" : "ndalu";
            },
            calendar: {
                sameDay: "[Dinten puniko pukul] LT",
                nextDay: "[Mbenjang pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kala wingi pukul] LT",
                lastWeek: "dddd [kepengker pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "wonten ing %s",
                past: "%s ingkang kepengker",
                s: "sawetawis detik",
                m: "setunggal menit",
                mm: "%d menit",
                h: "setunggal jam",
                hh: "%d jam",
                d: "sedinten",
                dd: "%d dinten",
                M: "sewulan",
                MM: "%d wulan",
                y: "setaun",
                yy: "%d taun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Georgian (ka)
    //! author : Irakli Janiashvili : https://github.com/irakli-janiashvili
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი".split("_"),
                accusative: "იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს".split("_")
            }, a = /D[oD] *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = {
                nominative: "კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი".split("_"),
                accusative: "კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს".split("_")
            }, a = /(წინა|შემდეგ)/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var a = e.defineLocale("ka", {
            months: t,
            monthsShort: "იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),
            weekdays: n,
            weekdaysShort: "კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),
            weekdaysMin: "კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[დღეს] LT[-ზე]",
                nextDay: "[ხვალ] LT[-ზე]",
                lastDay: "[გუშინ] LT[-ზე]",
                nextWeek: "[შემდეგ] dddd LT[-ზე]",
                lastWeek: "[წინა] dddd LT-ზე",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return /(წამი|წუთი|საათი|წელი)/.test(e) ? e.replace(/ი$/, "ში") : e + "ში";
                },
                past: function(e) {
                    return /(წამი|წუთი|საათი|დღე|თვე)/.test(e) ? e.replace(/(ი|ე)$/, "ის წინ") : /წელი/.test(e) ? e.replace(/წელი$/, "წლის წინ") : void 0;
                },
                s: "რამდენიმე წამი",
                m: "წუთი",
                mm: "%d წუთი",
                h: "საათი",
                hh: "%d საათი",
                d: "დღე",
                dd: "%d დღე",
                M: "თვე",
                MM: "%d თვე",
                y: "წელი",
                yy: "%d წელი"
            },
            ordinalParse: /0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,
            ordinal: function(e) {
                return 0 === e ? e : 1 === e ? e + "-ლი" : e < 20 || e <= 100 && e % 20 === 0 || e % 100 === 0 ? "მე-" + e : e + "-ე";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : khmer (km)
    //! author : Kruy Vanna : https://github.com/kruyvanna
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("km", {
            months: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            monthsShort: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            weekdays: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysShort: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysMin: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ថ្ងៃនៈ ម៉ោង] LT",
                nextDay: "[ស្អែក ម៉ោង] LT",
                nextWeek: "dddd [ម៉ោង] LT",
                lastDay: "[ម្សិលមិញ ម៉ោង] LT",
                lastWeek: "dddd [សប្តាហ៍មុន] [ម៉ោង] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sទៀត",
                past: "%sមុន",
                s: "ប៉ុន្មានវិនាទី",
                m: "មួយនាទី",
                mm: "%d នាទី",
                h: "មួយម៉ោង",
                hh: "%d ម៉ោង",
                d: "មួយថ្ងៃ",
                dd: "%d ថ្ងៃ",
                M: "មួយខែ",
                MM: "%d ខែ",
                y: "មួយឆ្នាំ",
                yy: "%d ឆ្នាំ"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : korean (ko)
    //!
    //! authors
    //!
    //! - Kyungwook, Park : https://github.com/kyungw00k
    //! - Jeeeyul Lee <jeeeyul@gmail.com>
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ko", {
            months: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            monthsShort: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            weekdays: "일요일_월요일_화요일_수요일_목요일_금요일_토요일".split("_"),
            weekdaysShort: "일_월_화_수_목_금_토".split("_"),
            weekdaysMin: "일_월_화_수_목_금_토".split("_"),
            longDateFormat: {
                LT: "A h시 m분",
                LTS: "A h시 m분 s초",
                L: "YYYY.MM.DD",
                LL: "YYYY년 MMMM D일",
                LLL: "YYYY년 MMMM D일 A h시 m분",
                LLLL: "YYYY년 MMMM D일 dddd A h시 m분"
            },
            calendar: {
                sameDay: "오늘 LT",
                nextDay: "내일 LT",
                nextWeek: "dddd LT",
                lastDay: "어제 LT",
                lastWeek: "지난주 dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s 후",
                past: "%s 전",
                s: "몇초",
                ss: "%d초",
                m: "일분",
                mm: "%d분",
                h: "한시간",
                hh: "%d시간",
                d: "하루",
                dd: "%d일",
                M: "한달",
                MM: "%d달",
                y: "일년",
                yy: "%d년"
            },
            ordinalParse: /\d{1,2}일/,
            ordinal: "%d일",
            meridiemParse: /오전|오후/,
            isPM: function(e) {
                return "오후" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "오전" : "오후";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Luxembourgish (lb)
    //! author : mweimerskirch : https://github.com/mweimerskirch, David Raison : https://github.com/kwisatz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eng Minutt", "enger Minutt" ],
                h: [ "eng Stonn", "enger Stonn" ],
                d: [ "een Dag", "engem Dag" ],
                M: [ "ee Mount", "engem Mount" ],
                y: [ "ee Joer", "engem Joer" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        function n(e) {
            var t = e.substr(0, e.indexOf(" "));
            return r(t) ? "a " + e : "an " + e;
        }
        function a(e) {
            var t = e.substr(0, e.indexOf(" "));
            return r(t) ? "viru " + e : "virun " + e;
        }
        function r(e) {
            if (e = parseInt(e, 10), isNaN(e)) return !1;
            if (e < 0) return !0;
            if (e < 10) return 4 <= e && e <= 7;
            if (e < 100) {
                var t = e % 10, n = e / 10;
                return r(0 === t ? n : t);
            }
            if (e < 1e4) {
                for (;e >= 10; ) e /= 10;
                return r(e);
            }
            return e /= 1e3, r(e);
        }
        var i = e.defineLocale("lb", {
            months: "Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),
            weekdaysShort: "So._Mé._Dë._Më._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mé_Dë_Më_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "H:mm [Auer]",
                LTS: "H:mm:ss [Auer]",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm [Auer]",
                LLLL: "dddd, D. MMMM YYYY H:mm [Auer]"
            },
            calendar: {
                sameDay: "[Haut um] LT",
                sameElse: "L",
                nextDay: "[Muer um] LT",
                nextWeek: "dddd [um] LT",
                lastDay: "[Gëschter um] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 2:
                      case 4:
                        return "[Leschten] dddd [um] LT";

                      default:
                        return "[Leschte] dddd [um] LT";
                    }
                }
            },
            relativeTime: {
                future: n,
                past: a,
                s: "e puer Sekonnen",
                m: t,
                mm: "%d Minutten",
                h: t,
                hh: "%d Stonnen",
                d: t,
                dd: "%d Deeg",
                M: t,
                MM: "%d Méint",
                y: t,
                yy: "%d Joer"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Lithuanian (lt)
    //! author : Mindaugas Mozūras : https://github.com/mmozuras
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            return t ? "kelios sekundės" : a ? "kelių sekundžių" : "kelias sekundes";
        }
        function n(e, t) {
            var n = {
                nominative: "sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis".split("_"),
                accusative: "sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function a(e, t, n, a) {
            return t ? i(n)[0] : a ? i(n)[1] : i(n)[2];
        }
        function r(e) {
            return e % 10 === 0 || e > 10 && e < 20;
        }
        function i(e) {
            return u[e].split("_");
        }
        function s(e, t, n, s) {
            var o = e + " ";
            return 1 === e ? o + a(e, t, n[0], s) : t ? o + (r(e) ? i(n)[1] : i(n)[0]) : s ? o + i(n)[1] : o + (r(e) ? i(n)[1] : i(n)[2]);
        }
        function o(e, t) {
            var n = t.indexOf("dddd HH:mm") === -1, a = l[e.day()];
            return n ? a : a.substring(0, a.length - 2) + "į";
        }
        var u = {
            m: "minutė_minutės_minutę",
            mm: "minutės_minučių_minutes",
            h: "valanda_valandos_valandą",
            hh: "valandos_valandų_valandas",
            d: "diena_dienos_dieną",
            dd: "dienos_dienų_dienas",
            M: "mėnuo_mėnesio_mėnesį",
            MM: "mėnesiai_mėnesių_mėnesius",
            y: "metai_metų_metus",
            yy: "metai_metų_metus"
        }, l = "sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis".split("_"), c = e.defineLocale("lt", {
            months: n,
            monthsShort: "sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),
            weekdays: o,
            weekdaysShort: "Sek_Pir_Ant_Tre_Ket_Pen_Šeš".split("_"),
            weekdaysMin: "S_P_A_T_K_Pn_Š".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY [m.] MMMM D [d.]",
                LLL: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                LLLL: "YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",
                l: "YYYY-MM-DD",
                ll: "YYYY [m.] MMMM D [d.]",
                lll: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                llll: "YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"
            },
            calendar: {
                sameDay: "[Šiandien] LT",
                nextDay: "[Rytoj] LT",
                nextWeek: "dddd LT",
                lastDay: "[Vakar] LT",
                lastWeek: "[Praėjusį] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "po %s",
                past: "prieš %s",
                s: t,
                m: a,
                mm: s,
                h: a,
                hh: s,
                d: a,
                dd: s,
                M: a,
                MM: s,
                y: a,
                yy: s
            },
            ordinalParse: /\d{1,2}-oji/,
            ordinal: function(e) {
                return e + "-oji";
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return c;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : latvian (lv)
    //! author : Kristaps Karlsons : https://github.com/skakri
    //! author : Jānis Elmeris : https://github.com/JanisE
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            return n ? t % 10 === 1 && 11 !== t ? e[2] : e[3] : t % 10 === 1 && 11 !== t ? e[0] : e[1];
        }
        function n(e, n, a) {
            return e + " " + t(i[a], e, n);
        }
        function a(e, n, a) {
            return t(i[a], e, n);
        }
        function r(e, t) {
            return t ? "dažas sekundes" : "dažām sekundēm";
        }
        var i = {
            m: "minūtes_minūtēm_minūte_minūtes".split("_"),
            mm: "minūtes_minūtēm_minūte_minūtes".split("_"),
            h: "stundas_stundām_stunda_stundas".split("_"),
            hh: "stundas_stundām_stunda_stundas".split("_"),
            d: "dienas_dienām_diena_dienas".split("_"),
            dd: "dienas_dienām_diena_dienas".split("_"),
            M: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            MM: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            y: "gada_gadiem_gads_gadi".split("_"),
            yy: "gada_gadiem_gads_gadi".split("_")
        }, s = e.defineLocale("lv", {
            months: "janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec".split("_"),
            weekdays: "svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena".split("_"),
            weekdaysShort: "Sv_P_O_T_C_Pk_S".split("_"),
            weekdaysMin: "Sv_P_O_T_C_Pk_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY.",
                LL: "YYYY. [gada] D. MMMM",
                LLL: "YYYY. [gada] D. MMMM, HH:mm",
                LLLL: "YYYY. [gada] D. MMMM, dddd, HH:mm"
            },
            calendar: {
                sameDay: "[Šodien pulksten] LT",
                nextDay: "[Rīt pulksten] LT",
                nextWeek: "dddd [pulksten] LT",
                lastDay: "[Vakar pulksten] LT",
                lastWeek: "[Pagājušā] dddd [pulksten] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "pēc %s",
                past: "pirms %s",
                s: r,
                m: a,
                mm: n,
                h: a,
                hh: n,
                d: a,
                dd: n,
                M: a,
                MM: n,
                y: a,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Montenegrin (me)
    //! author : Miodrag Nikač <miodrag@restartit.me> : https://github.com/miodragnikac
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jednog minuta" ],
                mm: [ "minut", "minuta", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mjesec", "mjeseca", "mjeseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("me", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sri.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sjutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedjelje] [u] LT", "[prošlog] [ponedjeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srijede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mjesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : macedonian (mk)
    //! author : Borislav Mickov : https://github.com/B0k0
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("mk", {
            months: "јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "недела_понеделник_вторник_среда_четврток_петок_сабота".split("_"),
            weekdaysShort: "нед_пон_вто_сре_чет_пет_саб".split("_"),
            weekdaysMin: "нe_пo_вт_ср_че_пе_сa".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Денес во] LT",
                nextDay: "[Утре во] LT",
                nextWeek: "dddd [во] LT",
                lastDay: "[Вчера во] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[Во изминатата] dddd [во] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[Во изминатиот] dddd [во] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "после %s",
                past: "пред %s",
                s: "неколку секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дена",
                M: "месец",
                MM: "%d месеци",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : malayalam (ml)
    //! author : Floyd Pink : https://github.com/floydpink
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ml", {
            months: "ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ".split("_"),
            monthsShort: "ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.".split("_"),
            weekdays: "ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച".split("_"),
            weekdaysShort: "ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി".split("_"),
            weekdaysMin: "ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ".split("_"),
            longDateFormat: {
                LT: "A h:mm -നു",
                LTS: "A h:mm:ss -നു",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm -നു",
                LLLL: "dddd, D MMMM YYYY, A h:mm -നു"
            },
            calendar: {
                sameDay: "[ഇന്ന്] LT",
                nextDay: "[നാളെ] LT",
                nextWeek: "dddd, LT",
                lastDay: "[ഇന്നലെ] LT",
                lastWeek: "[കഴിഞ്ഞ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s കഴിഞ്ഞ്",
                past: "%s മുൻപ്",
                s: "അൽപ നിമിഷങ്ങൾ",
                m: "ഒരു മിനിറ്റ്",
                mm: "%d മിനിറ്റ്",
                h: "ഒരു മണിക്കൂർ",
                hh: "%d മണിക്കൂർ",
                d: "ഒരു ദിവസം",
                dd: "%d ദിവസം",
                M: "ഒരു മാസം",
                MM: "%d മാസം",
                y: "ഒരു വർഷം",
                yy: "%d വർഷം"
            },
            meridiemParse: /രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,
            isPM: function(e) {
                return /^(ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "രാത്രി" : e < 12 ? "രാവിലെ" : e < 17 ? "ഉച്ച കഴിഞ്ഞ്" : e < 20 ? "വൈകുന്നേരം" : "രാത്രി";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Marathi (mr)
    //! author : Harshad Kale : https://github.com/kalehv
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("mr", {
            months: "जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),
            monthsShort: "जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),
            weekdays: "रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm वाजता",
                LTS: "A h:mm:ss वाजता",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm वाजता",
                LLLL: "dddd, D MMMM YYYY, A h:mm वाजता"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[उद्या] LT",
                nextWeek: "dddd, LT",
                lastDay: "[काल] LT",
                lastWeek: "[मागील] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s नंतर",
                past: "%s पूर्वी",
                s: "सेकंद",
                m: "एक मिनिट",
                mm: "%d मिनिटे",
                h: "एक तास",
                hh: "%d तास",
                d: "एक दिवस",
                dd: "%d दिवस",
                M: "एक महिना",
                MM: "%d महिने",
                y: "एक वर्ष",
                yy: "%d वर्षे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात्री|सकाळी|दुपारी|सायंकाळी/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात्री" === t ? e < 4 ? e : e + 12 : "सकाळी" === t ? e : "दुपारी" === t ? e >= 10 ? e : e + 12 : "सायंकाळी" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात्री" : e < 10 ? "सकाळी" : e < 17 ? "दुपारी" : e < 20 ? "सायंकाळी" : "रात्री";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms-my", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Burmese (my)
    //! author : Squar team, mysquar.com
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "၁",
            "2": "၂",
            "3": "၃",
            "4": "၄",
            "5": "၅",
            "6": "၆",
            "7": "၇",
            "8": "၈",
            "9": "၉",
            "0": "၀"
        }, n = {
            "၁": "1",
            "၂": "2",
            "၃": "3",
            "၄": "4",
            "၅": "5",
            "၆": "6",
            "၇": "7",
            "၈": "8",
            "၉": "9",
            "၀": "0"
        }, a = e.defineLocale("my", {
            months: "ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ".split("_"),
            monthsShort: "ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ".split("_"),
            weekdays: "တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ".split("_"),
            weekdaysShort: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            weekdaysMin: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ယနေ.] LT [မှာ]",
                nextDay: "[မနက်ဖြန်] LT [မှာ]",
                nextWeek: "dddd LT [မှာ]",
                lastDay: "[မနေ.က] LT [မှာ]",
                lastWeek: "[ပြီးခဲ့သော] dddd LT [မှာ]",
                sameElse: "L"
            },
            relativeTime: {
                future: "လာမည့် %s မှာ",
                past: "လွန်ခဲ့သော %s က",
                s: "စက္ကန်.အနည်းငယ်",
                m: "တစ်မိနစ်",
                mm: "%d မိနစ်",
                h: "တစ်နာရီ",
                hh: "%d နာရီ",
                d: "တစ်ရက်",
                dd: "%d ရက်",
                M: "တစ်လ",
                MM: "%d လ",
                y: "တစ်နှစ်",
                yy: "%d နှစ်"
            },
            preparse: function(e) {
                return e.replace(/[၁၂၃၄၅၆၇၈၉၀]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian bokmål (nb)
    //! authors : Espen Hovlandsdal : https://github.com/rexxars
    //!           Sigurd Gartmann : https://github.com/sigurdga
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nb", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tirs_ons_tors_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "H.mm",
                LTS: "H.mm.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H.mm",
                LLLL: "dddd D. MMMM YYYY [kl.] H.mm"
            },
            calendar: {
                sameDay: "[i dag kl.] LT",
                nextDay: "[i morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[i går kl.] LT",
                lastWeek: "[forrige] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s siden",
                s: "noen sekunder",
                m: "ett minutt",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dager",
                M: "en måned",
                MM: "%d måneder",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : nepali/nepalese
    //! author : suvash : https://github.com/suvash
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("ne", {
            months: "जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर".split("_"),
            monthsShort: "जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.".split("_"),
            weekdays: "आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार".split("_"),
            weekdaysShort: "आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.".split("_"),
            weekdaysMin: "आइ._सो._मङ्_बु._बि._शु._श.".split("_"),
            longDateFormat: {
                LT: "Aको h:mm बजे",
                LTS: "Aको h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, Aको h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, Aको h:mm बजे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /राती|बिहान|दिउँसो|बेलुका|साँझ|राती/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "राती" === t ? e < 3 ? e : e + 12 : "बिहान" === t ? e : "दिउँसो" === t ? e >= 10 ? e : e + 12 : "बेलुका" === t || "साँझ" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 3 ? "राती" : e < 10 ? "बिहान" : e < 15 ? "दिउँसो" : e < 18 ? "बेलुका" : e < 20 ? "साँझ" : "राती";
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[भोली] LT",
                nextWeek: "[आउँदो] dddd[,] LT",
                lastDay: "[हिजो] LT",
                lastWeek: "[गएको] dddd[,] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sमा",
                past: "%s अगाडी",
                s: "केही समय",
                m: "एक मिनेट",
                mm: "%d मिनेट",
                h: "एक घण्टा",
                hh: "%d घण्टा",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महिना",
                MM: "%d महिना",
                y: "एक बर्ष",
                yy: "%d बर्ष"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : dutch (nl)
    //! author : Joris Röling : https://github.com/jjupiter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"), n = "jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"), a = e.defineLocale("nl", {
            months: "januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),
            weekdaysShort: "zo._ma._di._wo._do._vr._za.".split("_"),
            weekdaysMin: "Zo_Ma_Di_Wo_Do_Vr_Za".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[vandaag om] LT",
                nextDay: "[morgen om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[gisteren om] LT",
                lastWeek: "[afgelopen] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "over %s",
                past: "%s geleden",
                s: "een paar seconden",
                m: "één minuut",
                mm: "%d minuten",
                h: "één uur",
                hh: "%d uur",
                d: "één dag",
                dd: "%d dagen",
                M: "één maand",
                MM: "%d maanden",
                y: "één jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian nynorsk (nn)
    //! author : https://github.com/mechuwind
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nn", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),
            weekdaysShort: "sun_mån_tys_ons_tor_fre_lau".split("_"),
            weekdaysMin: "su_må_ty_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag klokka] LT",
                nextDay: "[I morgon klokka] LT",
                nextWeek: "dddd [klokka] LT",
                lastDay: "[I går klokka] LT",
                lastWeek: "[Føregåande] dddd [klokka] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s sidan",
                s: "nokre sekund",
                m: "eit minutt",
                mm: "%d minutt",
                h: "ein time",
                hh: "%d timar",
                d: "ein dag",
                dd: "%d dagar",
                M: "ein månad",
                MM: "%d månader",
                y: "eit år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : polish (pl)
    //! author : Rafal Hirsz : https://github.com/evoL
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 10 < 5 && e % 10 > 1 && ~~(e / 10) % 10 !== 1;
        }
        function n(e, n, a) {
            var r = e + " ";
            switch (a) {
              case "m":
                return n ? "minuta" : "minutę";

              case "mm":
                return r + (t(e) ? "minuty" : "minut");

              case "h":
                return n ? "godzina" : "godzinę";

              case "hh":
                return r + (t(e) ? "godziny" : "godzin");

              case "MM":
                return r + (t(e) ? "miesiące" : "miesięcy");

              case "yy":
                return r + (t(e) ? "lata" : "lat");
            }
        }
        var a = "styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"), r = "stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"), i = e.defineLocale("pl", {
            months: function(e, t) {
                return "" === t ? "(" + r[e.month()] + "|" + a[e.month()] + ")" : /D MMMM/.test(t) ? r[e.month()] : a[e.month()];
            },
            monthsShort: "sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),
            weekdays: "niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),
            weekdaysShort: "nie_pon_wt_śr_czw_pt_sb".split("_"),
            weekdaysMin: "N_Pn_Wt_Śr_Cz_Pt_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Dziś o] LT",
                nextDay: "[Jutro o] LT",
                nextWeek: "[W] dddd [o] LT",
                lastDay: "[Wczoraj o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[W zeszłą niedzielę o] LT";

                      case 3:
                        return "[W zeszłą środę o] LT";

                      case 6:
                        return "[W zeszłą sobotę o] LT";

                      default:
                        return "[W zeszły] dddd [o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "%s temu",
                s: "kilka sekund",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "1 dzień",
                dd: "%d dni",
                M: "miesiąc",
                MM: n,
                y: "rok",
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : portuguese (pt)
    //! author : Jefferson : https://github.com/jalex79
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "há %s",
                s: "segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : brazilian portuguese (pt-br)
    //! author : Caio Ribeiro Pereira : https://github.com/caio-ribeiro-pereira
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt-br", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY [às] HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY [às] HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "%s atrás",
                s: "poucos segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº"
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : romanian (ro)
    //! author : Vlad Gurdiga : https://github.com/gurdiga
    //! author : Valentin Agachi : https://github.com/avaly
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "minute",
                hh: "ore",
                dd: "zile",
                MM: "luni",
                yy: "ani"
            }, r = " ";
            return (e % 100 >= 20 || e >= 100 && e % 100 === 0) && (r = " de "), e + r + a[n];
        }
        var n = e.defineLocale("ro", {
            months: "ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),
            monthsShort: "ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),
            weekdays: "duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),
            weekdaysShort: "Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),
            weekdaysMin: "Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[azi la] LT",
                nextDay: "[mâine la] LT",
                nextWeek: "dddd [la] LT",
                lastDay: "[ieri la] LT",
                lastWeek: "[fosta] dddd [la] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "peste %s",
                past: "%s în urmă",
                s: "câteva secunde",
                m: "un minut",
                mm: t,
                h: "o oră",
                hh: t,
                d: "o zi",
                dd: t,
                M: "o lună",
                MM: t,
                y: "un an",
                yy: t
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : russian (ru)
    //! author : Viktorminator : https://github.com/Viktorminator
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: n ? "минута_минуты_минут" : "минуту_минуты_минут",
                hh: "час_часа_часов",
                dd: "день_дня_дней",
                MM: "месяц_месяца_месяцев",
                yy: "год_года_лет"
            };
            return "m" === a ? n ? "минута" : "минуту" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
                accusative: "января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек".split("_"),
                accusative: "янв_фев_мар_апр_мая_июня_июля_авг_сен_окт_ноя_дек".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function i(e, t) {
            var n = {
                nominative: "воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),
                accusative: "воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_")
            }, a = /\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var s = e.defineLocale("ru", {
            months: a,
            monthsShort: r,
            weekdays: i,
            weekdaysShort: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            monthsParse: [ /^янв/i, /^фев/i, /^мар/i, /^апр/i, /^ма[й|я]/i, /^июн/i, /^июл/i, /^авг/i, /^сен/i, /^окт/i, /^ноя/i, /^дек/i ],
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сегодня в] LT",
                nextDay: "[Завтра в] LT",
                lastDay: "[Вчера в] LT",
                nextWeek: function() {
                    return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                },
                lastWeek: function(e) {
                    if (e.week() === this.week()) return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                    switch (this.day()) {
                      case 0:
                        return "[В прошлое] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[В прошлый] dddd [в] LT";

                      case 3:
                      case 5:
                      case 6:
                        return "[В прошлую] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "через %s",
                past: "%s назад",
                s: "несколько секунд",
                m: n,
                mm: n,
                h: "час",
                hh: n,
                d: "день",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночи|утра|дня|вечера/i,
            isPM: function(e) {
                return /^(дня|вечера)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночи" : e < 12 ? "утра" : e < 17 ? "дня" : "вечера";
            },
            ordinalParse: /\d{1,2}-(й|го|я)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  case "w":
                  case "W":
                    return e + "-я";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Sinhalese (si)
    //! author : Sampath Sitinamaluwa : https://github.com/sampathsris
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("si", {
            months: "ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්".split("_"),
            monthsShort: "ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ".split("_"),
            weekdays: "ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා".split("_"),
            weekdaysShort: "ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන".split("_"),
            weekdaysMin: "ඉ_ස_අ_බ_බ්‍ර_සි_සෙ".split("_"),
            longDateFormat: {
                LT: "a h:mm",
                LTS: "a h:mm:ss",
                L: "YYYY/MM/DD",
                LL: "YYYY MMMM D",
                LLL: "YYYY MMMM D, a h:mm",
                LLLL: "YYYY MMMM D [වැනි] dddd, a h:mm:ss"
            },
            calendar: {
                sameDay: "[අද] LT[ට]",
                nextDay: "[හෙට] LT[ට]",
                nextWeek: "dddd LT[ට]",
                lastDay: "[ඊයේ] LT[ට]",
                lastWeek: "[පසුගිය] dddd LT[ට]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sකින්",
                past: "%sකට පෙර",
                s: "තත්පර කිහිපය",
                m: "මිනිත්තුව",
                mm: "මිනිත්තු %d",
                h: "පැය",
                hh: "පැය %d",
                d: "දිනය",
                dd: "දින %d",
                M: "මාසය",
                MM: "මාස %d",
                y: "වසර",
                yy: "වසර %d"
            },
            ordinalParse: /\d{1,2} වැනි/,
            ordinal: function(e) {
                return e + " වැනි";
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "ප.ව." : "පස් වරු" : n ? "පෙ.ව." : "පෙර වරු";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovak (sk)
    //! author : Martin Minka : https://github.com/k2s
    //! based on work of petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5;
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "pár sekúnd" : "pár sekundami";

              case "m":
                return n ? "minúta" : r ? "minútu" : "minútou";

              case "mm":
                return n || r ? i + (t(e) ? "minúty" : "minút") : i + "minútami";

              case "h":
                return n ? "hodina" : r ? "hodinu" : "hodinou";

              case "hh":
                return n || r ? i + (t(e) ? "hodiny" : "hodín") : i + "hodinami";

              case "d":
                return n || r ? "deň" : "dňom";

              case "dd":
                return n || r ? i + (t(e) ? "dni" : "dní") : i + "dňami";

              case "M":
                return n || r ? "mesiac" : "mesiacom";

              case "MM":
                return n || r ? i + (t(e) ? "mesiace" : "mesiacov") : i + "mesiacmi";

              case "y":
                return n || r ? "rok" : "rokom";

              case "yy":
                return n || r ? i + (t(e) ? "roky" : "rokov") : i + "rokmi";
            }
        }
        var a = "január_február_marec_apríl_máj_jún_júl_august_september_október_november_december".split("_"), r = "jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec".split("_"), i = e.defineLocale("sk", {
            months: a,
            monthsShort: r,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, r),
            weekdays: "nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota".split("_"),
            weekdaysShort: "ne_po_ut_st_št_pi_so".split("_"),
            weekdaysMin: "ne_po_ut_st_št_pi_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes o] LT",
                nextDay: "[zajtra o] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [o] LT";

                      case 3:
                        return "[v stredu o] LT";

                      case 4:
                        return "[vo štvrtok o] LT";

                      case 5:
                        return "[v piatok o] LT";

                      case 6:
                        return "[v sobotu o] LT";
                    }
                },
                lastDay: "[včera o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulú nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[minulý] dddd [o] LT";

                      case 3:
                        return "[minulú stredu o] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [o] LT";

                      case 6:
                        return "[minulú sobotu o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pred %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovenian (sl)
    //! author : Robert Sedovšek : https://github.com/sedovsek
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = e + " ";
            switch (n) {
              case "s":
                return t || a ? "nekaj sekund" : "nekaj sekundami";

              case "m":
                return t ? "ena minuta" : "eno minuto";

              case "mm":
                return r += 1 === e ? t ? "minuta" : "minuto" : 2 === e ? t || a ? "minuti" : "minutama" : e < 5 ? t || a ? "minute" : "minutami" : t || a ? "minut" : "minutami";

              case "h":
                return t ? "ena ura" : "eno uro";

              case "hh":
                return r += 1 === e ? t ? "ura" : "uro" : 2 === e ? t || a ? "uri" : "urama" : e < 5 ? t || a ? "ure" : "urami" : t || a ? "ur" : "urami";

              case "d":
                return t || a ? "en dan" : "enim dnem";

              case "dd":
                return r += 1 === e ? t || a ? "dan" : "dnem" : 2 === e ? t || a ? "dni" : "dnevoma" : t || a ? "dni" : "dnevi";

              case "M":
                return t || a ? "en mesec" : "enim mesecem";

              case "MM":
                return r += 1 === e ? t || a ? "mesec" : "mesecem" : 2 === e ? t || a ? "meseca" : "mesecema" : e < 5 ? t || a ? "mesece" : "meseci" : t || a ? "mesecev" : "meseci";

              case "y":
                return t || a ? "eno leto" : "enim letom";

              case "yy":
                return r += 1 === e ? t || a ? "leto" : "letom" : 2 === e ? t || a ? "leti" : "letoma" : e < 5 ? t || a ? "leta" : "leti" : t || a ? "let" : "leti";
            }
        }
        var n = e.defineLocale("sl", {
            months: "januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),
            weekdays: "nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota".split("_"),
            weekdaysShort: "ned._pon._tor._sre._čet._pet._sob.".split("_"),
            weekdaysMin: "ne_po_to_sr_če_pe_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danes ob] LT",
                nextDay: "[jutri ob] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v] [nedeljo] [ob] LT";

                      case 3:
                        return "[v] [sredo] [ob] LT";

                      case 6:
                        return "[v] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[v] dddd [ob] LT";
                    }
                },
                lastDay: "[včeraj ob] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[prejšnjo] [nedeljo] [ob] LT";

                      case 3:
                        return "[prejšnjo] [sredo] [ob] LT";

                      case 6:
                        return "[prejšnjo] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prejšnji] dddd [ob] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "čez %s",
                past: "pred %s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Albanian (sq)
    //! author : Flakërim Ismani : https://github.com/flakerimi
    //! author: Menelion Elensúle: https://github.com/Oire (tests)
    //! author : Oerd Cukalla : https://github.com/oerd (fixes)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sq", {
            months: "Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor".split("_"),
            monthsShort: "Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj".split("_"),
            weekdays: "E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë".split("_"),
            weekdaysShort: "Die_Hën_Mar_Mër_Enj_Pre_Sht".split("_"),
            weekdaysMin: "D_H_Ma_Më_E_P_Sh".split("_"),
            meridiemParse: /PD|MD/,
            isPM: function(e) {
                return "M" === e.charAt(0);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "PD" : "MD";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Sot në] LT",
                nextDay: "[Nesër në] LT",
                nextWeek: "dddd [në] LT",
                lastDay: "[Dje në] LT",
                lastWeek: "dddd [e kaluar në] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "në %s",
                past: "%s më parë",
                s: "disa sekonda",
                m: "një minutë",
                mm: "%d minuta",
                h: "një orë",
                hh: "%d orë",
                d: "një ditë",
                dd: "%d ditë",
                M: "një muaj",
                MM: "%d muaj",
                y: "një vit",
                yy: "%d vite"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-latin (sr)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jedne minute" ],
                mm: [ "minut", "minute", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mesec", "meseca", "meseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("sr", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedelja", "ponedeljak", "utorak", "sreda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sre.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedelju] [u] LT";

                      case 3:
                        return "[u] [sredu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedelje] [u] LT", "[prošlog] [ponedeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pre %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-cyrillic (sr-cyrl)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "један минут", "једне минуте" ],
                mm: [ "минут", "минуте", "минута" ],
                h: [ "један сат", "једног сата" ],
                hh: [ "сат", "сата", "сати" ],
                dd: [ "дан", "дана", "дана" ],
                MM: [ "месец", "месеца", "месеци" ],
                yy: [ "година", "године", "година" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("sr-cyrl", {
            months: [ "јануар", "фебруар", "март", "април", "мај", "јун", "јул", "август", "септембар", "октобар", "новембар", "децембар" ],
            monthsShort: [ "јан.", "феб.", "мар.", "апр.", "мај", "јун", "јул", "авг.", "сеп.", "окт.", "нов.", "дец." ],
            weekdays: [ "недеља", "понедељак", "уторак", "среда", "четвртак", "петак", "субота" ],
            weekdaysShort: [ "нед.", "пон.", "уто.", "сре.", "чет.", "пет.", "суб." ],
            weekdaysMin: [ "не", "по", "ут", "ср", "че", "пе", "су" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[данас у] LT",
                nextDay: "[сутра у] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[у] [недељу] [у] LT";

                      case 3:
                        return "[у] [среду] [у] LT";

                      case 6:
                        return "[у] [суботу] [у] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[у] dddd [у] LT";
                    }
                },
                lastDay: "[јуче у] LT",
                lastWeek: function() {
                    var e = [ "[прошле] [недеље] [у] LT", "[прошлог] [понедељка] [у] LT", "[прошлог] [уторка] [у] LT", "[прошле] [среде] [у] LT", "[прошлог] [четвртка] [у] LT", "[прошлог] [петка] [у] LT", "[прошле] [суботе] [у] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "пре %s",
                s: "неколико секунди",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "дан",
                dd: t.translate,
                M: "месец",
                MM: t.translate,
                y: "годину",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : swedish (sv)
    //! author : Jens Alm : https://github.com/ulmus
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sv", {
            months: "januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag".split("_"),
            weekdaysShort: "sön_mån_tis_ons_tor_fre_lör".split("_"),
            weekdaysMin: "sö_må_ti_on_to_fr_lö".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Idag] LT",
                nextDay: "[Imorgon] LT",
                lastDay: "[Igår] LT",
                nextWeek: "[På] dddd LT",
                lastWeek: "[I] dddd[s] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "för %s sedan",
                s: "några sekunder",
                m: "en minut",
                mm: "%d minuter",
                h: "en timme",
                hh: "%d timmar",
                d: "en dag",
                dd: "%d dagar",
                M: "en månad",
                MM: "%d månader",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}(e|a)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "e" : 1 === t ? "a" : 2 === t ? "a" : "e";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tamil (ta)
    //! author : Arjunkumar Krishnamoorthy : https://github.com/tk120404
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ta", {
            months: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            monthsShort: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            weekdays: "ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை".split("_"),
            weekdaysShort: "ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி".split("_"),
            weekdaysMin: "ஞா_தி_செ_பு_வி_வெ_ச".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, HH:mm",
                LLLL: "dddd, D MMMM YYYY, HH:mm"
            },
            calendar: {
                sameDay: "[இன்று] LT",
                nextDay: "[நாளை] LT",
                nextWeek: "dddd, LT",
                lastDay: "[நேற்று] LT",
                lastWeek: "[கடந்த வாரம்] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s இல்",
                past: "%s முன்",
                s: "ஒரு சில விநாடிகள்",
                m: "ஒரு நிமிடம்",
                mm: "%d நிமிடங்கள்",
                h: "ஒரு மணி நேரம்",
                hh: "%d மணி நேரம்",
                d: "ஒரு நாள்",
                dd: "%d நாட்கள்",
                M: "ஒரு மாதம்",
                MM: "%d மாதங்கள்",
                y: "ஒரு வருடம்",
                yy: "%d ஆண்டுகள்"
            },
            ordinalParse: /\d{1,2}வது/,
            ordinal: function(e) {
                return e + "வது";
            },
            meridiemParse: /யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,
            meridiem: function(e, t, n) {
                return e < 2 ? " யாமம்" : e < 6 ? " வைகறை" : e < 10 ? " காலை" : e < 14 ? " நண்பகல்" : e < 18 ? " எற்பாடு" : e < 22 ? " மாலை" : " யாமம்";
            },
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "யாமம்" === t ? e < 2 ? e : e + 12 : "வைகறை" === t || "காலை" === t ? e : "நண்பகல்" === t && e >= 10 ? e : e + 12;
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : thai (th)
    //! author : Kridsada Thanabulpong : https://github.com/sirn
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("th", {
            months: "มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม".split("_"),
            monthsShort: "มกรา_กุมภา_มีนา_เมษา_พฤษภา_มิถุนา_กรกฎา_สิงหา_กันยา_ตุลา_พฤศจิกา_ธันวา".split("_"),
            weekdays: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์".split("_"),
            weekdaysShort: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์".split("_"),
            weekdaysMin: "อา._จ._อ._พ._พฤ._ศ._ส.".split("_"),
            longDateFormat: {
                LT: "H นาฬิกา m นาที",
                LTS: "H นาฬิกา m นาที s วินาที",
                L: "YYYY/MM/DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY เวลา H นาฬิกา m นาที",
                LLLL: "วันddddที่ D MMMM YYYY เวลา H นาฬิกา m นาที"
            },
            meridiemParse: /ก่อนเที่ยง|หลังเที่ยง/,
            isPM: function(e) {
                return "หลังเที่ยง" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ก่อนเที่ยง" : "หลังเที่ยง";
            },
            calendar: {
                sameDay: "[วันนี้ เวลา] LT",
                nextDay: "[พรุ่งนี้ เวลา] LT",
                nextWeek: "dddd[หน้า เวลา] LT",
                lastDay: "[เมื่อวานนี้ เวลา] LT",
                lastWeek: "[วัน]dddd[ที่แล้ว เวลา] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "อีก %s",
                past: "%sที่แล้ว",
                s: "ไม่กี่วินาที",
                m: "1 นาที",
                mm: "%d นาที",
                h: "1 ชั่วโมง",
                hh: "%d ชั่วโมง",
                d: "1 วัน",
                dd: "%d วัน",
                M: "1 เดือน",
                MM: "%d เดือน",
                y: "1 ปี",
                yy: "%d ปี"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Tagalog/Filipino (tl-ph)
    //! author : Dan Hagman
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tl-ph", {
            months: "Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),
            monthsShort: "Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),
            weekdays: "Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),
            weekdaysShort: "Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),
            weekdaysMin: "Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "MM/D/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY HH:mm",
                LLLL: "dddd, MMMM DD, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Ngayon sa] LT",
                nextDay: "[Bukas sa] LT",
                nextWeek: "dddd [sa] LT",
                lastDay: "[Kahapon sa] LT",
                lastWeek: "dddd [huling linggo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "sa loob ng %s",
                past: "%s ang nakalipas",
                s: "ilang segundo",
                m: "isang minuto",
                mm: "%d minuto",
                h: "isang oras",
                hh: "%d oras",
                d: "isang araw",
                dd: "%d araw",
                M: "isang buwan",
                MM: "%d buwan",
                y: "isang taon",
                yy: "%d taon"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : turkish (tr)
    //! authors : Erhan Gundogan : https://github.com/erhangundogan,
    //!           Burak Yiğit Kaya: https://github.com/BYK
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "'inci",
            5: "'inci",
            8: "'inci",
            70: "'inci",
            80: "'inci",
            2: "'nci",
            7: "'nci",
            20: "'nci",
            50: "'nci",
            3: "'üncü",
            4: "'üncü",
            100: "'üncü",
            6: "'ncı",
            9: "'uncu",
            10: "'uncu",
            30: "'uncu",
            60: "'ıncı",
            90: "'ıncı"
        }, n = e.defineLocale("tr", {
            months: "Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık".split("_"),
            monthsShort: "Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara".split("_"),
            weekdays: "Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi".split("_"),
            weekdaysShort: "Paz_Pts_Sal_Çar_Per_Cum_Cts".split("_"),
            weekdaysMin: "Pz_Pt_Sa_Ça_Pe_Cu_Ct".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[yarın saat] LT",
                nextWeek: "[haftaya] dddd [saat] LT",
                lastDay: "[dün] LT",
                lastWeek: "[geçen hafta] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s önce",
                s: "birkaç saniye",
                m: "bir dakika",
                mm: "%d dakika",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir yıl",
                yy: "%d yıl"
            },
            ordinalParse: /\d{1,2}'(inci|nci|üncü|ncı|uncu|ıncı)/,
            ordinal: function(e) {
                if (0 === e) return e + "'ıncı";
                var n = e % 10, a = e % 100 - n, r = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[r]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : talossan (tzl)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v with the help of Iustì Canun
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                s: [ "viensas secunds", "'iensas secunds" ],
                m: [ "'n míut", "'iens míut" ],
                mm: [ e + " míuts", " " + e + " míuts" ],
                h: [ "'n þora", "'iensa þora" ],
                hh: [ e + " þoras", " " + e + " þoras" ],
                d: [ "'n ziua", "'iensa ziua" ],
                dd: [ e + " ziuas", " " + e + " ziuas" ],
                M: [ "'n mes", "'iens mes" ],
                MM: [ e + " mesen", " " + e + " mesen" ],
                y: [ "'n ar", "'iens ar" ],
                yy: [ e + " ars", " " + e + " ars" ]
            };
            return a ? r[n][0] : t ? r[n][0] : r[n][1].trim();
        }
        var n = e.defineLocale("tzl", {
            months: "Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar".split("_"),
            monthsShort: "Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec".split("_"),
            weekdays: "Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi".split("_"),
            weekdaysShort: "Súl_Lún_Mai_Már_Xhú_Vié_Sát".split("_"),
            weekdaysMin: "Sú_Lú_Ma_Má_Xh_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "LT.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM [dallas] YYYY",
                LLL: "D. MMMM [dallas] YYYY LT",
                LLLL: "dddd, [li] D. MMMM [dallas] YYYY LT"
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "d'o" : "D'O" : n ? "d'a" : "D'A";
            },
            calendar: {
                sameDay: "[oxhi à] LT",
                nextDay: "[demà à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[ieiri à] LT",
                lastWeek: "[sür el] dddd [lasteu à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "osprei %s",
                past: "ja%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt (tzm)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm", {
            months: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            monthsShort: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            weekdays: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysShort: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysMin: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ⴰⵙⴷⵅ ⴴ] LT",
                nextDay: "[ⴰⵙⴽⴰ ⴴ] LT",
                nextWeek: "dddd [ⴴ] LT",
                lastDay: "[ⴰⵚⴰⵏⵜ ⴴ] LT",
                lastWeek: "dddd [ⴴ] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s",
                past: "ⵢⴰⵏ %s",
                s: "ⵉⵎⵉⴽ",
                m: "ⵎⵉⵏⵓⴺ",
                mm: "%d ⵎⵉⵏⵓⴺ",
                h: "ⵙⴰⵄⴰ",
                hh: "%d ⵜⴰⵙⵙⴰⵄⵉⵏ",
                d: "ⴰⵙⵙ",
                dd: "%d oⵙⵙⴰⵏ",
                M: "ⴰⵢoⵓⵔ",
                MM: "%d ⵉⵢⵢⵉⵔⵏ",
                y: "ⴰⵙⴳⴰⵙ",
                yy: "%d ⵉⵙⴳⴰⵙⵏ"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt in Latin (tzm-latn)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm-latn", {
            months: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            monthsShort: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            weekdays: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysShort: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysMin: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[asdkh g] LT",
                nextDay: "[aska g] LT",
                nextWeek: "dddd [g] LT",
                lastDay: "[assant g] LT",
                lastWeek: "dddd [g] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dadkh s yan %s",
                past: "yan %s",
                s: "imik",
                m: "minuḍ",
                mm: "%d minuḍ",
                h: "saɛa",
                hh: "%d tassaɛin",
                d: "ass",
                dd: "%d ossan",
                M: "ayowr",
                MM: "%d iyyirn",
                y: "asgas",
                yy: "%d isgasn"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : ukrainian (uk)
    //! author : zemlanin : https://github.com/zemlanin
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: "хвилина_хвилини_хвилин",
                hh: "година_години_годин",
                dd: "день_дні_днів",
                MM: "місяць_місяці_місяців",
                yy: "рік_роки_років"
            };
            return "m" === a ? n ? "хвилина" : "хвилину" : "h" === a ? n ? "година" : "годину" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_"),
                accusative: "січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_")
            }, a = /D[oD]? *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),
                accusative: "неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),
                genitive: "неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")
            }, a = /(\[[ВвУу]\]) ?dddd/.test(t) ? "accusative" : /\[?(?:минулої|наступної)? ?\] ?dddd/.test(t) ? "genitive" : "nominative";
            return n[a][e.day()];
        }
        function i(e) {
            return function() {
                return e + "о" + (11 === this.hours() ? "б" : "") + "] LT";
            };
        }
        var s = e.defineLocale("uk", {
            months: a,
            monthsShort: "січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),
            weekdays: r,
            weekdaysShort: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY р.",
                LLL: "D MMMM YYYY р., HH:mm",
                LLLL: "dddd, D MMMM YYYY р., HH:mm"
            },
            calendar: {
                sameDay: i("[Сьогодні "),
                nextDay: i("[Завтра "),
                lastDay: i("[Вчора "),
                nextWeek: i("[У] dddd ["),
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return i("[Минулої] dddd [").call(this);

                      case 1:
                      case 2:
                      case 4:
                        return i("[Минулого] dddd [").call(this);
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "%s тому",
                s: "декілька секунд",
                m: n,
                mm: n,
                h: "годину",
                hh: n,
                d: "день",
                dd: n,
                M: "місяць",
                MM: n,
                y: "рік",
                yy: n
            },
            meridiemParse: /ночі|ранку|дня|вечора/,
            isPM: function(e) {
                return /^(дня|вечора)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночі" : e < 12 ? "ранку" : e < 17 ? "дня" : "вечора";
            },
            ordinalParse: /\d{1,2}-(й|го)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : uzbek (uz)
    //! author : Sardor Muminov : https://github.com/muminoff
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("uz", {
            months: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
            monthsShort: "янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),
            weekdays: "Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба".split("_"),
            weekdaysShort: "Якш_Душ_Сеш_Чор_Пай_Жум_Шан".split("_"),
            weekdaysMin: "Як_Ду_Се_Чо_Па_Жу_Ша".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "D MMMM YYYY, dddd HH:mm"
            },
            calendar: {
                sameDay: "[Бугун соат] LT [да]",
                nextDay: "[Эртага] LT [да]",
                nextWeek: "dddd [куни соат] LT [да]",
                lastDay: "[Кеча соат] LT [да]",
                lastWeek: "[Утган] dddd [куни соат] LT [да]",
                sameElse: "L"
            },
            relativeTime: {
                future: "Якин %s ичида",
                past: "Бир неча %s олдин",
                s: "фурсат",
                m: "бир дакика",
                mm: "%d дакика",
                h: "бир соат",
                hh: "%d соат",
                d: "бир кун",
                dd: "%d кун",
                M: "бир ой",
                MM: "%d ой",
                y: "бир йил",
                yy: "%d йил"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : vietnamese (vi)
    //! author : Bang Nguyen : https://github.com/bangnk
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("vi", {
            months: "tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12".split("_"),
            monthsShort: "Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12".split("_"),
            weekdays: "chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy".split("_"),
            weekdaysShort: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            weekdaysMin: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM [năm] YYYY",
                LLL: "D MMMM [năm] YYYY HH:mm",
                LLLL: "dddd, D MMMM [năm] YYYY HH:mm",
                l: "DD/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hôm nay lúc] LT",
                nextDay: "[Ngày mai lúc] LT",
                nextWeek: "dddd [tuần tới lúc] LT",
                lastDay: "[Hôm qua lúc] LT",
                lastWeek: "dddd [tuần rồi lúc] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s tới",
                past: "%s trước",
                s: "vài giây",
                m: "một phút",
                mm: "%d phút",
                h: "một giờ",
                hh: "%d giờ",
                d: "một ngày",
                dd: "%d ngày",
                M: "một tháng",
                MM: "%d tháng",
                y: "một năm",
                yy: "%d năm"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chinese (zh-cn)
    //! author : suupic : https://github.com/suupic
    //! author : Zeno Zeng : https://github.com/zenozeng
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-cn", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "周日_周一_周二_周三_周四_周五_周六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah点mm分",
                LTS: "Ah点m分s秒",
                L: "YYYY-MM-DD",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah点mm分",
                LLLL: "YYYY年MMMD日ddddAh点mm分",
                l: "YYYY-MM-DD",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah点mm分",
                llll: "YYYY年MMMD日ddddAh点mm分"
            },
            meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "凌晨" === t || "早上" === t || "上午" === t ? e : "下午" === t || "晚上" === t ? e + 12 : e >= 11 ? e : e + 12;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 600 ? "凌晨" : a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: function() {
                    return 0 === this.minutes() ? "[今天]Ah[点整]" : "[今天]LT";
                },
                nextDay: function() {
                    return 0 === this.minutes() ? "[明天]Ah[点整]" : "[明天]LT";
                },
                lastDay: function() {
                    return 0 === this.minutes() ? "[昨天]Ah[点整]" : "[昨天]LT";
                },
                nextWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() - t.unix() >= 604800 ? "[下]" : "[本]", 
                    0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                lastWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() < t.unix() ? "[上]" : "[本]", 0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                sameElse: "LL"
            },
            ordinalParse: /\d{1,2}(日|月|周)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "周";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s内",
                past: "%s前",
                s: "几秒",
                m: "1 分钟",
                mm: "%d 分钟",
                h: "1 小时",
                hh: "%d 小时",
                d: "1 天",
                dd: "%d 天",
                M: "1 个月",
                MM: "%d 个月",
                y: "1 年",
                yy: "%d 年"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : traditional chinese (zh-tw)
    //! author : Ben : https://github.com/ben-lin
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-tw", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "週日_週一_週二_週三_週四_週五_週六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah點mm分",
                LTS: "Ah點m分s秒",
                L: "YYYY年MMMD日",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah點mm分",
                LLLL: "YYYY年MMMD日ddddAh點mm分",
                l: "YYYY年MMMD日",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah點mm分",
                llll: "YYYY年MMMD日ddddAh點mm分"
            },
            meridiemParse: /早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "早上" === t || "上午" === t ? e : "中午" === t ? e >= 11 ? e : e + 12 : "下午" === t || "晚上" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: "[今天]LT",
                nextDay: "[明天]LT",
                nextWeek: "[下]ddddLT",
                lastDay: "[昨天]LT",
                lastWeek: "[上]ddddLT",
                sameElse: "L"
            },
            ordinalParse: /\d{1,2}(日|月|週)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "週";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s內",
                past: "%s前",
                s: "幾秒",
                m: "一分鐘",
                mm: "%d分鐘",
                h: "一小時",
                hh: "%d小時",
                d: "一天",
                dd: "%d天",
                M: "一個月",
                MM: "%d個月",
                y: "一年",
                yy: "%d年"
            }
        });
        return t;
    });
}, , , , , , , , , , , , , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <h3> <i class="pficon pficon-image"></i>\n<span ng-if="labels.name">{{ labels.name }}</span>\n<span ng-if="!labels.name">{{ names[0] }}</span> </h3> <a ng-href="#/images/{{ stream.metadata.namespace }}/{{ stream.metadata.name }}" translate class="hidden-xs">Show all images</a> </div> <div class="listing-ct-inline"> <h3 translate>Image</h3> <div class="listing-ct-body"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <h3 translate>Container</h3> <div class="listing-ct-body"> <registry-image-config image="image"> </registry-image-config> </div> <h3 translate>Metadata</h3> <div class="listing-ct-body"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-page.html", r);
    } ]), e.exports = r;
}, , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<filter-bar class="content-filter"> </filter-bar> <div image-listing> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/images-page.html", r);
    } ]), e.exports = r;
}, , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <h3> <i class="fa fa-folder"></i>\n{{ stream.metadata.namespace }}/{{ stream.metadata.name}} </h3> <a ng-href="#{{ viewUrl(\'images\') }}" translate>Show all image streams</a> </div> <div class="listing-ct-inline"> <h3 translate>Image Stream</h3> <div class="listing-ct-body"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push settings="settings" imagestream="stream"> </registry-imagestream-push> </div> <h3 translate>Images</h3> <div image-listing> </div> <h3 translate ng-if="stream.metadata.annotations">Metadata</h3> <div class="listing-ct-body" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-page.html", r);
    } ]), e.exports = r;
}, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t, n) {
            var a, r, i, s, o, u = (e.status || {}).tags || [];
            for (s = 0, o = u.length; s < o; s++) for (i = u[s].items || [], a = 0, r = i.length; a < r; a++) t.call(n || null, u[s], i[a]);
        }
        var t = n(32);
        n(33), n(43), n(39), n(61), n(44), n(236), n(237), n(188), n(191), n(174), n(45), 
        n(238), n(239), n(240), n(240), n(241), t.module("registry.images", [ "ngRoute", "ui.cockpit", "kubeClient", "kubernetes.date", "kubernetes.listing", "registry.tags", "registryUI.images" ]).config([ "$routeProvider", function(e) {
            e.when("/images/:namespace?", {
                templateUrl: "views/images-page.html",
                controller: "ImagesCtrl"
            }).when("/images/:namespace/:target", {
                controller: "ImageCtrl",
                templateUrl: function(e) {
                    var t = e.target || "";
                    return t.indexOf(":") === -1 ? "views/imagestream-page.html" : "views/image-page.html";
                }
            });
        } ]).controller("ImagesCtrl", [ "$scope", "$location", "imageData", "imageActions", "ListingState", "projectData", "filterService", function(e, n, a, r, i, s) {
            e.imagestreams = a.allStreams, e.sharedImages = s.sharedImages, t.extend(e, a), 
            e.listing = new i(e), a.watchImages(), e.$on("activate", function(e, t) {
                e.preventDefault(), n.path("/images/" + t);
            }), t.extend(e, r);
        } ]).controller("ImageCtrl", [ "$scope", "$location", "$routeParams", "kubeSelect", "kubeLoader", "imageData", "imageActions", "ListingState", "projectData", function(n, a, r, i, s, o, u, l, c) {
            var d, m, f = r.target || "", p = f.indexOf(":"), h = r.namespace || "";
            p === -1 ? (n.kind = "ImageStream", d = f, m = null) : (n.kind = "Image", d = f.substr(0, p), 
            m = f.substr(p + 1)), o.watchImages(n), s.listen(function() {
                n.stream = i().kind("ImageStream").namespace(h).name(d).one(), n.image = n.config = n.layers = n.labels = n.tag = null, 
                e(n.stream || {}, function(e, t) {
                    e.tag === m && (n.tag = e);
                }), n.tag && (n.image = i().kind("Image").taggedFirst(n.tag).one()), n.image && (n.names = o.imageTagNames(n.image), 
                n.config = o.imageConfig(n.image), n.layers = o.imageLayers(n.image), n.labels = o.imageLabels(n.image));
            }, n), n.listing = new l(n), n.listing.inline = !0, n.imagestreams = function() {
                return n.stream ? {
                    "/": n.stream
                } : {};
            }, t.extend(n, o), t.extend(n, u), n.sharedImages = c.sharedImages, n.deleteImageStream = function(e) {
                var t = u.deleteImageStream(e);
                return t.then(function() {
                    a.path(n.viewUrl("images"));
                }), t;
            }, n.$on("activate", function(e, t) {
                e.preventDefault(), a.path("/images/" + t);
            }), n.deleteTag = function(e, t) {
                var n = u.deleteTag(e, t);
                return n.then(function() {
                    var t = [ "images", e.metadata.namespace, e.metadata.name ];
                    a.path("/" + t.map(encodeURIComponent).join("/"));
                }), n;
            };
        } ]).directive("imagePanel", [ "kubeLoader", "imageData", function(e, t) {
            return {
                restrict: "A",
                scope: !0,
                link: function(n, a, r) {
                    var i = "main";
                    n.tab = function(e, t) {
                        return t && (i = e, t.stopPropagation()), i === e;
                    }, e.listen(function() {
                        n.names = n.config = n.layers = n.labels = null, n.image && (n.names = t.imageTagNames(n.image), 
                        n.config = t.imageConfig(n.image), n.layers = t.imageLayers(n.image), n.labels = t.imageLabels(n.image));
                    }, n);
                },
                templateUrl: "views/image-panel.html"
            };
        } ]).directive("imageListing", function() {
            return {
                restrict: "A",
                templateUrl: "views/image-listing.html"
            };
        }).factory("imageData", [ "kubeSelect", "kubeLoader", function(n, a) {
            function r(e) {
                var n = e.metadata || {}, r = e.status || {};
                t.forEach(r.tags || [], function(e) {
                    t.forEach(e.items || [], function(e) {
                        var t = a.resolve("Image", e.image);
                        if (!(t in a.objects)) {
                            var r = {
                                kind: "Image",
                                apiVersion: "v1",
                                metadata: {
                                    name: e.image
                                }
                            };
                            if (a.handle(r), l) {
                                var s = n.name + "@" + e.image;
                                a.load("ImageStreamImage", s, n.namespace).then(function(e) {
                                    var t = e.image;
                                    t && (t.kind = "Image", a.handle(t), i(t));
                                }, function(e) {
                                    var t = e.statusText || e.message || String(e);
                                    console.warn("couldn't load image: " + t), r.metadata.resourceVersion = "invalid";
                                });
                            }
                        }
                    });
                });
            }
            function i(e) {
                var n, r = e.dockerImageManifest;
                r && (r = JSON.parse(r), t.forEach(r.history || [], function(e) {
                    "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                }), n = {
                    kind: "DockerImageManifest",
                    metadata: {
                        name: e.metadata.name,
                        selfLink: "/internal/manifests/" + e.metadata.name
                    },
                    manifest: r
                }, a.handle(n));
            }
            function s(e) {
                l = !0;
                var t = a.watch("images", e), n = a.watch("imagestreams", e);
                return {
                    cancel: function() {
                        t.cancel(), n.cancel();
                    }
                };
            }
            function o(e) {
                if (!e) return null;
                var t = n().kind("DockerImageManifest").name(e.metadata.name).one();
                return t && t.manifest && 1 === t.manifest.schemaVersion ? t.manifest.history : e.dockerImageLayers ? e.dockerImageLayers : null;
            }
            function u(e) {
                var t = [];
                if (!e) return "";
                e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                var n = t.join(" ");
                return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
            }
            var l = !1;
            return a.listen(function(e) {
                for (var t in e) "ImageStream" === e[t].kind && r(e[t]), "Image" === e[t].kind && i(e[t]);
            }), n.register("taggedBy", function(e) {
                var t, a, r = {};
                if (!e.items) return n(null);
                for (t = 0, a = e.items.length; t < a; t++) this.name(e.items[t].image).extend(r);
                return n(r);
            }), n.register("taggedFirst", function(e) {
                var t = {};
                return e.items ? (e.items.length && this.name(e.items[0].image).extend(t), n(t)) : n(null);
            }), n.register({
                name: "containsTagImage",
                digests: function(t) {
                    var n = [];
                    return "string" == typeof t ? n.push(t) : e(t, function(e, t) {
                        n.push(t.image + "");
                    }), n;
                }
            }), n.register("listTagNames", function(n) {
                var a = [];
                return t.forEach(this.containsTagImage(n), function(t) {
                    e(t, function(e, r) {
                        n && r.image != n || a.push(t.metadata.namespace + "/" + t.metadata.name + ":" + e.tag);
                    });
                }), a;
            }), n.register("dockerImageConfig", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a, r = o(t) || {};
                    if (r[0] && (a = r[0].v1Compatibility, a && a.config)) return void (e[n] = a.config);
                    var i = t.dockerImageMetadata || {};
                    i.Config && (e[n] = i.Config);
                }), n(e);
            }), n.register("dockerConfigLabels", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a;
                    t && (a = t.Labels), a && (e[n] = a);
                }), n(e);
            }), {
                watchImages: s,
                allStreams: function() {
                    return n().kind("ImageStream");
                },
                imageByTag: function(e) {
                    return n().kind("Image").taggedFirst(e);
                },
                imageLayers: o,
                imageConfig: function(e) {
                    return n(e).dockerImageConfig().one() || {};
                },
                imageTagNames: function(e) {
                    return n().kind("ImageStream").listTagNames(e.metadata.name);
                },
                imageLabels: function(e) {
                    var a = n(e).dockerImageConfig().dockerConfigLabels().one();
                    return a && t.equals({}, a) && (a = null), a;
                },
                configCommand: u
            };
        } ]).factory("imageActions", [ "$modal", "$location", function(e, t) {
            function n(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamDeleteCtrl",
                    templateUrl: "views/imagestream-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function a() {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {};
                        }
                    }
                }).result;
            }
            function r(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function i(t, n) {
                var a = e.open({
                    animation: !1,
                    controller: "ImageDeleteCtrl",
                    templateUrl: "views/image-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t,
                                tag: n
                            };
                        }
                    }
                });
                return a.result;
            }
            function s(e) {
                return t.path("/projects/" + e), !1;
            }
            return {
                createImageStream: a,
                modifyImageStream: r,
                deleteImageStream: n,
                deleteTag: i,
                modifyProject: s
            };
        } ]).controller("ImageStreamDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, r) {
            t.extend(e, a), e.performDelete = function() {
                return r.delete(e.stream);
            };
        } ]).controller("ImageStreamModifyCtrl", [ "$scope", "$modalInstance", "dialogData", "imageTagData", "kubeMethods", "filterService", "gettextCatalog", function(e, n, a, r, i, s, o) {
            function u() {
                var e = {
                    spec: {
                        dockerImageRepository: null,
                        tags: null
                    }
                };
                return "none" != g.populate && (e.spec.dockerImageRepository = g.pull.trim()), "tags" == g.populate && r.buildSpec(g.tags, e.spec, g.insecure), 
                i.patch(d, e);
            }
            function l() {
                var e = {
                    kind: "ImageStream",
                    metadata: {
                        name: g.name.trim(),
                        namespace: g.project.trim()
                    }
                };
                return "none" != g.populate && (e.spec = {
                    dockerImageRepository: g.pull.trim()
                }), "tags" == g.populate && (e.spec = r.buildSpec(g.tags, e.spec, g.insecure)), 
                i.check(e, {
                    "metadata.name": "#imagestream-modify-name",
                    "metadata.namespace": "#imagestream-modify-project"
                }).then(function() {
                    return i.create(e, g.project);
                });
            }
            function c(e) {
                var t;
                if (e) for (var n in e.tags) if (e.tags[n].importPolicy.insecure) {
                    t = e.tags[n].importPolicy.insecure;
                    break;
                }
                return t;
            }
            var d = a.stream || {}, m = d.metadata || {}, f = d.spec || {}, p = o.getString.bind(o), h = "none";
            f.dockerImageRepository && (h = "pull"), f.tags && (h = "tags");
            var g = {
                name: m.name || "",
                project: m.namespace || s.namespace() || "",
                populate: h,
                pull: f.dockerImageRepository || "",
                tags: r.parseSpec(f),
                insecure: c(f)
            };
            e.fields = g, e.labels = {
                populate: {
                    none: p("Don't pull images automatically"),
                    pull: p("Sync all tags from a remote image repository"),
                    tags: p("Pull specific tags from another image repository")
                }
            }, e.placeholder = p("eg: my-image-stream"), a.stream || (e.labels.populate.none = p("Create empty image stream")), 
            e.performCreate = l, e.performModify = u, e.hasInsecureTag = c, e.projects = s.namespaces, 
            t.extend(e, a);
        } ]).controller("ImageDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, r) {
            t.extend(e, a), e.performDelete = function() {
                var t = e.stream.metadata.name + ":" + e.tag.tag;
                return r.delete("ImageStreamTag", t, e.stream.metadata.namespace);
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(e) {
            function t(e) {
                e && r.push(e);
            }
            var n, a, r = [];
            for (n = e.firstChild; n; n = n.nextSibling) a = "", 3 == n.nodeType ? a = n.nodeValue.trim() : 1 == n.nodeType && n.hasAttribute("value") && (a = n.getAttribute("value")), 
            a.split(s).forEach(t);
            return r;
        }
        function t(e) {
            var t = [ document.createTextNode("​") ];
            return i.forEach(e, function(e) {
                var n = document.createElement("span");
                n.setAttribute("contenteditable", "false"), n.setAttribute("class", "image-tag"), 
                n.setAttribute("value", e), n.appendChild(document.createTextNode(e));
                var a = document.createElement("a");
                a.setAttribute("class", "pficon pficon-close"), n.appendChild(a), t.push(n), t.push(document.createTextNode(" "));
            }), t;
        }
        function a(e) {
            var t = [];
            return i.forEach(e.tags || [], function(e) {
                t.push(e.name);
            }), t;
        }
        function r(e, t, n) {
            var a = {};
            t || (t = {}), i.forEach(t.tags || [], function(e) {
                a[e.name] = e;
            });
            var r = [];
            return i.forEach(e, function(e) {
                e in a ? (a[e].importPolicy = {
                    insecure: n
                }, r.push(a[e])) : r.push({
                    name: e,
                    importPolicy: {
                        insecure: n
                    }
                });
            }), t.tags = r, t;
        }
        var i = n(32), s = /[\u200B\s,]+/;
        i.module("registry.tags", []).directive("imageTagEditor", [ function() {
            return {
                restrict: "A",
                transclude: !0,
                scope: {
                    tags: "="
                },
                link: function(n, a, r) {
                    a.addClass("image-tag-editor"), a.attr("tabindex", "0"), a.attr("contenteditable", "true");
                    var i = t(n.tags);
                    a.append(i);
                    var s = document.createRange();
                    s.selectNodeContents(i[i.length - 1]), s.collapse(!1);
                    var o = window.getSelection();
                    o.removeAllRanges(), o.addRange(s), a.on("click", function(e) {
                        var t = e.target, n = t.parentNode;
                        "a" == t.nodeName.toLowerCase() && "span" == n.nodeName.toLowerCase() && n.parentNode.removeChild(n);
                    }), a.on("blur keyup paste copy cut mouseup", function() {
                        for (var t = e(a[0]); n.tags.length > 0; ) n.tags.pop();
                        t.forEach(function(e) {
                            n.tags.push(e);
                        });
                    });
                }
            };
        } ]).factory("imageTagData", [ function() {
            return {
                parseSpec: a,
                buildSpec: r,
                buildNodes: t,
                parseNodes: e
            };
        } ]);
    }();
}, function(e, t) {
    !function(e) {
        function t(a) {
            if (n[a]) return n[a].exports;
            var r = n[a] = {
                exports: {},
                id: a,
                loaded: !1
            };
            return e[a].call(r.exports, r, r.exports, t), r.loaded = !0, r.exports;
        }
        var n = {};
        return t.m = e, t.c = n, t.p = "", t(0);
    }([ function(e, t, n) {
        n(4), n(5), n(6), n(7), n(8), n(10), n(11), n(12), n(13), n(14), n(15), n(16), n(17), 
        e.exports = n(18);
    }, , , , function(e, t) {
        !function() {
            "use strict";
            angular.module("registryUI.images", [ "registryUI.client", "registryUI.date" ]).factory("imageDockerManifest", [ "WeakMap", function(e) {
                var t = new e();
                return function(e) {
                    if (!e) return {};
                    var n = t.get(e);
                    return n || (n = JSON.parse(e.dockerImageManifest || "{ }"), angular.forEach(n.history || [], function(e) {
                        "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                    }), t.set(e, n)), n;
                };
            } ]).factory("imageDockerConfig", [ "WeakMap", "imageLayers", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return {};
                    var a, r, i, s = n.get(e);
                    return s || (r = t(e), r.length && (i = r[0].v1Compatibility), i && i.config ? s = i.config : (a = e.dockerImageMetadata || {}, 
                    a.Config && (s = a.Config)), n.set(e, s)), s || {};
                };
            } ]).factory("imageLayers", [ "WeakMap", "imageDockerManifest", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return [];
                    var a, r = n.get(e);
                    return r || (a = t(e), r = a.history ? a.history : e.dockerImageLayers ? e.dockerImageLayers : [], 
                    n.set(e, r)), r;
                };
            } ]).directive("registryImageBody", [ "imageLayers", "imageDockerConfig", function(e, t) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-body.html",
                    link: function(n, a, r) {
                        n.$watch("image", function(a) {
                            n.layers = e(a), n.config = t(a), n.labels = n.config.Labels, angular.equals({}, n.labels) && (n.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagePull", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        settings: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-pull.html"
                };
            } ]).directive("registryImageConfig", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-config.html",
                    link: function(t, n, a) {
                        t.configCommand = function(e) {
                            var t = [];
                            if (!e) return "";
                            e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                            var n = t.join(" ");
                            return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
                        }, t.$watch("image", function(n) {
                            t.config = e(n);
                        });
                    }
                };
            } ]).directive("registryImageMeta", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-meta.html",
                    link: function(t, n, a) {
                        t.$watch("image", function(n) {
                            t.config = e(n), t.labels = t.config.Labels, angular.equals({}, t.labels) && (t.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagestreamBody", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        imagestreamFunc: "&imagestreamModify",
                        projectFunc: "&projectModify",
                        sharingFunc: "&projectSharing"
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-body.html",
                    link: function(e, t, n) {
                        e.projectModify = e.projectFunc(), e.projectSharing = e.sharingFunc(), e.imagestreamModify = e.imagestreamFunc();
                    }
                };
            } ]).directive("registryImagestreamPush", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        settings: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-push.html"
                };
            } ]).directive("registryImagestreamMeta", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-meta.html"
                };
            } ]);
        }();
    }, function(e, t) {
        angular.module("registryUI.client", []).factory("WeakMap", function() {
            function e() {
                var e = "weakmap" + n;
                n += 1, t || (t = Math.random().toString(36).slice(2));
                var a = this;
                a.delete = function(n) {
                    var a = n[t];
                    a && delete a[e];
                }, a.has = function(n) {
                    var a = n[t];
                    return a && e in a;
                }, a.get = function(n) {
                    var a = n[t];
                    if (a) return a[e];
                }, a.set = function(n, a) {
                    var r = n[t];
                    r || (r = function() {}, Object.defineProperty(n, t, {
                        enumerable: !1,
                        configurable: !1,
                        writable: !1,
                        value: r
                    })), r[e] = a;
                };
            }
            if ("function" == typeof window.WeakMap) return window.WeakMap;
            var t, n = 1;
            return e;
        });
    }, function(e, t) {
        !function() {
            angular.module("registryUI.date", []).factory("dateRefreshMinute", [ "$rootScope", function(e) {
                var t = null;
                return {
                    enable: function() {
                        null === t && (t = window.setInterval(function() {
                            e.$applyAsync();
                        }, 6e4));
                    },
                    disable: function() {
                        null !== t && (window.clearInterval(t), t = null);
                    }
                };
            } ]).filter("dateRelative", [ "dateRefreshMinute", function() {
                function e(e) {
                    return e ? moment(e).fromNow() : e;
                }
                function t(e) {
                    return e;
                }
                return e.$stateful = !0, "function" == typeof moment ? e : t;
            } ]);
        }();
    }, function(e, t) {
        !function() {
            "use strict";
            function e(e, t) {
                var n, a;
                return e.v1Compatibility.container_config && (n = e.v1Compatibility.container_config.Cmd) ? (a = n[n.length - 1], 
                0 === a.indexOf("#(nop)") ? a.substring(6).trim() : 1 == n.length && 0 === n[0].indexOf("/bin/sh -c #(nop)") ? n[0].substring(17).trim() : n.join(" ")) : e.v1Compatibility.id;
            }
            angular.module("registryUI.images").factory("prepareLayer", [ "gettextCatalog", function(t) {
                return function(n, a, r) {
                    var i;
                    return i = n.v1Compatibility ? {
                        id: n.v1Compatibility.id,
                        size: n.v1Compatibility.Size || 0,
                        label: e(n, r[a + 1])
                    } : n.name && n.size ? {
                        id: n.name,
                        size: n.size || 0,
                        label: n.name
                    } : {
                        size: 0,
                        id: a,
                        label: t.getString("Unknown layer")
                    }, 0 === i.label.indexOf("RUN ") ? i.hint = "run" : 0 === i.label.indexOf("ADD ") || i.size > 8192 ? i.hint = "add" : i.hint = "other", 
                    i;
                };
            } ]).directive("registryImageLayers", [ "imageLayers", "prepareLayer", "gettextCatalog", function(e, t, n) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        data: "=?layers"
                    },
                    templateUrl: "registry-image-widgets/views/image-layers.html",
                    link: function(a, r, i) {
                        a.formatSize = function(e) {
                            var t;
                            return e ? e > 1024 && "undefined" != typeof cockpit ? cockpit.format_bytes(e) : e > 1048576 ? (t = (e / 1048576).toFixed(1), 
                            n.getPlural(t, a, "{0} MB", "{0} MB").replace("{0}", t)) : n.getPlural(t, a, "{0} byte", "{0} bytes").replace("{0}", e) : "";
                        }, a.$watch("data", function(e) {
                            e && e.length && (e = e.map(t).reverse()), a.layers = e;
                        }), a.$watch("image", function(t) {
                            angular.isUndefined(t) || (a.data = e(t));
                        });
                    }
                };
            } ]);
        }();
    }, function(e, t) {}, , function(e, t) {}, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal left"> <dt ng-if="labels.name" translate>Name</dt> <dd ng-if="labels.name">{{ labels.name }}</dd> <dt ng-if="labels.summary" translate>Summary</dt> <dd ng-if="labels.summary">{{ labels.summary }}</dd> <dt ng-if="labels.description" translate>Description</dt> <dd ng-if="labels.description">{{ labels.description }}</dd> <dt ng-if="labels.url" translate>Source URL</dt> <dd ng-if="labels.url"> <a href="labels.url"><i class="fa fa-external-link"></i> {{ labels.url }}</a> </dd> <dt translate>Author</dt> <dd ng-if="config.author">{{config.author}}</dd> <dd ng-if="!config.author && image.dockerImageMetadata.Author">{{image.dockerImageMetadata.Author}}</dd> <dd ng-if="!config.author && !image.dockerImageMetadata.Author"><em translate>Unknown</em></dd> <dt ng-if="labels[\'build-date\'] || layers[0].v1Compatibility.created || image.dockerImageMetadata.Created" translate>Built</dt> <dd ng-if="labels[\'build-date\']" title="{{labels[\'build-date\']}}">{{ labels[\'build-date\'] | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && layers[0].v1Compatibility.created" title="{{layers[0].v1Compatibility.created}}">{{ layers[0].v1Compatibility.created | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && !layers[0].v1Compatibility.created && image.dockerImageMetadata.Created" title="{{image.dockerImageMetadata.Created}}">{{image.dockerImageMetadata.Created | dateRelative}}</dd> <dt translate>Digest</dt> <dd><tt>{{ image.metadata.name }}</tt></dd> <dt translate>Identifier</dt> <dd><tt>{{ config.Image }}</tt></dd> </dl> <dl class="registry-image-tags" ng-if="names"> <dt translate>Tags</dt> <dd><span class="registry-image-tag" ng-repeat="name in names">{{name}}</span></dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-body.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal"> <dt translate>Command:</dt> <dd><code>{{ configCommand(config) }}</code></dd> </dl> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Run as</dt> <dd ng-if="config.User">{{config.User}}</dd> <dd ng-if="!config.User"><em translate>Default</em></dd> <dt translate>Directory</dt> <dd ng-if="config.WorkingDir">{{config.WorkingDir}}</dd> <dd ng-if="!config.WorkingDir">/</dd> <dt ng-if="config.StopSignal" translate>Stop with</dt> <dd ng-if="config.StopSignal">{{config.StopSignal}}</dd> <dt translate>Architecture</dt> <dd ng-if="config.architecture">{{config.architecture}}</dd> <dd ng-if="!config.architecture">{{image.dockerImageMetadata.Architecture}}</dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Env.length" translate>Environment</dt> <dd ng-repeat="env in config.Env"><tt>{{env}}</tt></dd> </dl> </div> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Ports</dt> <dd ng-repeat="(port, data) in config.ExposedPorts">{{port}}</dd> <dd ng-if="!config.ExposedPorts"><em translate>None</em></dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Volumes" translate>Volumes</dt> <dd ng-repeat="(volume, data) in config.Volumes">{{volume}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-config.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div> <dl class="dl-horizontal left"> <dt ng-if="labels" translate>Labels</dt> <dd ng-repeat="(name, value) in labels" ng-show="name != \'description\' && name != \'name\'"> <tt>{{name}}={{value}}</tt> </dd> <dt ng-if="config.OnBuild.length" translate>On Build</dt> <dd ng-repeat="line in config.OnBuild"><tt>{{line}}</tt></dd> <dt ng-if="image.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in image.metadata.annotations">{{name}}: {{value}}</dd> <dt translate>Docker Version</dt> <dd>{{image.dockerImageMetadata.DockerVersion}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-meta.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<ul class="registry-image-layers"> <li ng-repeat="layer in layers" class="hint-{{ layer.hint }}"> <span title="{{ layer.size }}">{{ formatSize(layer.size) }}</span> <p>{{ layer.label}}</p> </li> </ul>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-layers.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div ng-if="names" class="registry-image-pull"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To pull this image:</span> </p> <code ng-if="!settings.registry.host">$ sudo docker pull <span class="placeholder">registry</span>/{{names[0]}}</code>\n<code ng-if="settings.registry.host">$ sudo docker pull <span>{{settings.registry.host}}</span>/{{names[0]}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-pull.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div ng-repeat="statustags in imagestream.status.tags"> <div ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="alert alert-danger"> <span class="pficon pficon-error-circle-o"></span>\n<span translate>{{ condition.message }}. Timestamp: {{ condition.lastTransitionTime }} Error count: {{ condition.generation }}</span>\n<a translate ng-if="imagestreamModify" ng-click="imagestreamModify(imagestream)" class="alert-link">Edit image stream</a> </div> </div> <dl class="dl-horizontal left"> <dt translate>Access Policy</dt> <dd ng-switch="projectSharing(imagestream.metadata.namespace)"> <div ng-switch-when="anonymous"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by anonymous users</a>\n<i title="Images accessible to anonymous users" class="fa fa-unlock registry-imagestream-lock"></i> </div> <div ng-switch-when="shared"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by any authenticated user or group</a>\n<i title="Images accessible to authenticated users" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-when="private"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may only be pulled by specific users or groups</a>\n<i title="Images only accessible to members" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-default> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Unknown</a>\n<i title="Unknown or invalid image access policy" class="fa fa-lock registry-imagestream-lock"></i> </div> </dd> <dt translate>Pull repository</dt> <dd ng-if="imagestream.spec.dockerImageRepository"><tt>{{imagestream.spec.dockerImageRepository}}</tt></dd> <dd ng-if="!imagestream.spec.dockerImageRepository"><em translate>None</em></dd> <dt translate>Image count</dt> <dd>{{imagestream.status.tags.length}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-body.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal left"> <dt ng-if="imagestream.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in imagestream.metadata.annotations">{{name}}: {{value}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-meta.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div class="registry-imagestream-push"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To push to an image to this image stream:</span> </p> <code ng-if="settings.registry.host">$ sudo docker tag <em>myimage</em> <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code>\n<code ng-if="!settings.registry.host">$ sudo docker tag <em>myimage</em> <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-push.html", r);
        } ]), e.exports = r;
    } ]);
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<table listing-table class="listing-ct images-listing"> <thead> <tr ng-if="!listing.inline"> <td colspan="4"> <a class="pull-right" ng-click="createImageStream()"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>New image stream</span> </a> <h3 translate>Images</h3> </td> </tr> <tr> <th class="listing-ct-toggle"></th> <th translate>Tags</th> <th translate>Author</th> <th translate>Last Updated</th> </tr> </thead> <tbody ng-repeat-start="(link, stream) in imagestreams() track by link" ng-init="sid = stream.metadata.namespace + \'/\' + stream.metadata.name" data-id="{{ sid }}" class="active" ng-class="{open: listing.expanded(sid)}"> <tr ng-if="!listing.inline" ng-click="listing.activate(sid)" class="listing-ct-item imagestream-item"> <td ng-click="listing.toggle(sid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <th colspan="4"> {{ sid }} <div class="listing-status" ng-repeat="statustags in stream.status.tags"> <span ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="pficon pficon-warning-triangle-o"></span> </div>  </th> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(sid)" ng-init="id = sid"> <td listing-panel kind="ImageStream" colspan="4"></td> </tr> </tbody> <tbody ng-repeat="tag in stream.status.tags track by tag.tag" ng-init="iid = sid + \':\' + tag.tag" data-id="{{ iid }}" ng-class="{open: listing.expanded(iid), last: $last, first: $first}"> <tr ng-click="listing.activate(iid)" class="listing-ct-item tag-item" ng-repeat-start="image in imageByTag(tag)"> <td ng-click="listing.toggle(iid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <td class="tag-label"><span class="image-tag">:{{ tag.tag }}</span></td> <td colspan="3" class="container"> <div class="row"> <div class="col col-xs-12"><tt>{{ image.metadata.name }}</tt></div> </div> <div class="row"> <div class="col col-xs-6 text-left" ng-if="conf.author">{{ conf.author }}</div> <div class="col col-xs-6 text-left" ng-if="!conf.author">{{ image.dockerImageMetadata.Author }}</div> <div class="col col-xs-6" title="{{ tag.items[0].created }}">{{ tag.items[0].created | dateRelative }}</div> </div> </td> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(iid)" ng-init="id = iid" ng-repeat-end=""> <td image-panel colspan="4"></td> </tr> </tbody> <tbody data-ng-rubbish="" ng-if="0" ng-repeat-end> </tbody> <thead class="listing-ct-empty" ng-if="!quiet"> <tr> <td colspan="4" ng-if="!failure" translate>No image streams are present.</td> <td colspan="4" ng-if="failure">{{failure}}</td> </tr> </thead> </table>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-listing.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Delete image stream</h3> </div> <div class="modal-body" translate>Do you want to delete the \'{{stream.metadata.namespace}}/{{stream.metadata.name}}\' image stream?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-delete.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" ng-if="!stream" translate>Create image stream</h3> <h3 class="modal-title" ng-if="stream" translate>Change image stream</h3> </div> <div class="modal-body"> <table class="form-table-ct"> <tr> <td> <label class="control-label" for="imagestream-modify-name" translate>Name</label> </td> <td> <input id="imagestream-modify-name" class="form-control" type="text" ng-if="!stream" ng-model="fields.name" placeholder="{{ placeholder }}" autofocus>\n<span id="imagestream-modify-name" ng-if="stream">{{ fields.name }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-project-text" translate>Project</label> </td> <td> <div ng-if="!stream" id="imagestream-modify-project" class="input-group input-combo"> <input class="form-control" id="imagestream-modify-project-text" type="text" ng-model="fields.project">\n<span class="input-group-btn" dropdown> <button class="btn btn-default dropdown-toggle" dropdown-toggle type="button"> <span class="caret"></span> </button> <ul dropdown-menu class="dropdown-menu" role="menu"> <li ng-repeat="name in projects() track by name" ng-class="{ checked: name == fields.project }"> <a ng-click="fields.project = name" value="{{name}}">{{ name }}</a> </li> </ul> </span> </div> <span id="imagestream-modify-project" ng-if="stream">{{ fields.project }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-populate" translate>Populate</label> </td> <td> <div class="btn-group bootstrap-select form-control" dropdown id="imagestream-modify-populate"> <button class="btn btn-default dropdown-toggle" dropdown-toggle> <span class="pull-left">{{ labels.populate[fields.populate] }}</span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="(value, label) in labels.populate" ng-class="{checked: value == fields.populate}"> <a ng-click="fields.populate = value" value="{{value}}">{{ label }}</a> </li> </ul> </div> </td> </tr> <tr ng-show="fields.populate != \'none\'"> <td class="top"> <label class="control-label" for="imagestream-modify-pull" translate>Pull from</label> </td> <td> <input id="imagestream-modify-pull" class="form-control" type="text" ng-model="fields.pull" placeholder="eg: docker.io/library/fedora"> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td class="top"> <label class="control-label" for="imagestream-modify-tags" translate>Tags</label> </td> <td> <div image-tag-editor id="imagestream-modify-tags" tags="fields.tags"> </div> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td></td> <td> <label> <input type="checkbox" ng-checked="hasInsecureTag(stream.spec)" ng-model="fields.insecure">\n<span translate>Remote registry is insecure</span> </label> </td> </tr> </table> </div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-primary" ng-if="stream" ng-click="complete(performModify())">Change</button>\n<button class="btn btn-primary" ng-if="!stream" ng-click="complete(performCreate())">Create</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-modify.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Remove image tag</h3> </div> <div class="modal-body" translate>Do you want to remove the image tagged as \'{{stream.metadata.namespace}}/{{stream.metadata.name}}:{{tag.tag}}\'?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-delete.html", r);
    } ]), e.exports = r;
}, , , , , function(e, t, n) {
    "use strict";
    !function() {
        window.QUnit = n(247), window.qunitTap = n(249), n(250), n(251), e.exports = window.QUnit;
    }();
}, function(e, t, n) {
    (function(t) {
        /*!
	 * QUnit 1.14.0
	 * http://qunitjs.com/
	 *
	 * Copyright 2013 jQuery Foundation and other contributors
	 * Released under the MIT license
	 * http://jquery.org/license
	 *
	 * Date: 2014-01-31T16:40Z
	 */
        !function(t) {
            function n() {
                w.autorun = !0, w.previousModule && y("moduleDone", L, {
                    name: w.previousModule,
                    failed: w.moduleStats.bad,
                    passed: w.moduleStats.all - w.moduleStats.bad,
                    total: w.moduleStats.all
                }), delete w.previousModule;
                var e, n, a = v("qunit-banner"), r = v("qunit-tests"), i = +new C() - w.started, s = w.stats.all - w.stats.bad, o = [ "Tests completed in ", i, " milliseconds.<br/>", "<span class='passed'>", s, "</span> assertions of <span class='total'>", w.stats.all, "</span> passed, <span class='failed'>", w.stats.bad, "</span> failed." ].join("");
                if (a && (a.className = w.stats.bad ? "qunit-fail" : "qunit-pass"), r && (v("qunit-testresult").innerHTML = o), 
                w.altertitle && j.document && document.title && (document.title = [ w.stats.bad ? "✖" : "✔", document.title.replace(/^[\u2714\u2716] /i, "") ].join(" ")), 
                w.reorder && j.sessionStorage && 0 === w.stats.bad) for (e = 0; e < sessionStorage.length; e++) n = sessionStorage.key(e++), 
                0 === n.indexOf("qunit-test-") && sessionStorage.removeItem(n);
                w.scrolltop && t.scrollTo && t.scrollTo(0, 0), y("done", L, {
                    failed: w.stats.bad,
                    passed: s,
                    total: w.stats.all,
                    runtime: i
                });
            }
            function a(e) {
                var t, n = w.filter && w.filter.toLowerCase(), r = w.module && w.module.toLowerCase(), i = (e.module + ": " + e.testName).toLowerCase();
                return e.callback && e.callback.validTest === a ? (delete e.callback.validTest, 
                !0) : !(w.testNumber.length > 0 && M(e.testNumber, w.testNumber) < 0) && (!(r && (!e.module || e.module.toLowerCase() !== r)) && (!n || (t = "!" !== n.charAt(0), 
                t || (n = n.slice(1)), i.indexOf(n) !== -1 ? t : !t)));
            }
            function r(e, t) {
                t = void 0 === t ? 3 : t;
                var n, a, r;
                if (e.stacktrace) return e.stacktrace.split("\n")[t + 3];
                if (e.stack) {
                    if (n = e.stack.split("\n"), /^error$/i.test(n[0]) && n.shift(), T) {
                        for (a = [], r = t; r < n.length && n[r].indexOf(T) === -1; r++) a.push(n[r]);
                        if (a.length) return a.join("\n");
                    }
                    return n[t];
                }
                if (e.sourceURL) {
                    if (/qunit.js$/.test(e.sourceURL)) return;
                    return e.sourceURL + ":" + e.line;
                }
            }
            function i(e) {
                try {
                    throw new Error();
                } catch (t) {
                    return r(t, e);
                }
            }
            function s(e) {
                return e ? (e += "", e.replace(/['"<>&]/g, function(e) {
                    switch (e) {
                      case "'":
                        return "&#039;";

                      case '"':
                        return "&quot;";

                      case "<":
                        return "&lt;";

                      case ">":
                        return "&gt;";

                      case "&":
                        return "&amp;";
                    }
                })) : "";
            }
            function o(e, t) {
                w.queue.push(e), w.autorun && !w.blocking && u(t);
            }
            function u(e) {
                function t() {
                    u(e);
                }
                var a = new C().getTime();
                for (w.depth = w.depth ? w.depth + 1 : 1; w.queue.length && !w.blocking; ) {
                    if (!(!j.setTimeout || w.updateRate <= 0 || new C().getTime() - a < w.updateRate)) {
                        E(t, 13);
                        break;
                    }
                    w.queue.shift()();
                }
                w.depth--, !e || w.blocking || w.queue.length || 0 !== w.depth || n();
            }
            function l() {
                if (w.pollution = [], w.noglobals) for (var e in t) if (x.call(t, e)) {
                    if (/^qunit-test-output/.test(e)) continue;
                    w.pollution.push(e);
                }
            }
            function c() {
                var e, t, n = w.pollution;
                l(), e = d(w.pollution, n), e.length > 0 && L.pushFailure("Introduced global variable(s): " + e.join(", ")), 
                t = d(n, w.pollution), t.length > 0 && L.pushFailure("Deleted global variable(s): " + t.join(", "));
            }
            function d(e, t) {
                var n, a, r = e.slice();
                for (n = 0; n < r.length; n++) for (a = 0; a < t.length; a++) if (r[n] === t[a]) {
                    r.splice(n, 1), n--;
                    break;
                }
                return r;
            }
            function m(e, n) {
                for (var a in n) x.call(n, a) && ("constructor" === a && e === t || (void 0 === n[a] ? delete e[a] : e[a] = n[a]));
                return e;
            }
            function f(e, t, n) {
                if (e.addEventListener) e.addEventListener(t, n, !1); else {
                    if (!e.attachEvent) throw new Error("addEvent() was called in a context without event listener support");
                    e.attachEvent("on" + t, n);
                }
            }
            function p(e, t, n) {
                for (var a = e.length; a--; ) f(e[a], t, n);
            }
            function h(e, t) {
                return (" " + e.className + " ").indexOf(" " + t + " ") > -1;
            }
            function g(e, t) {
                h(e, t) || (e.className += (e.className ? " " : "") + t);
            }
            function _(e, t) {
                for (var n = " " + e.className + " "; n.indexOf(" " + t + " ") > -1; ) n = n.replace(" " + t + " ", " ");
                e.className = "function" == typeof n.trim ? n.trim() : n.replace(/^\s+|\s+$/g, "");
            }
            function v(e) {
                return j.document && document.getElementById && document.getElementById(e);
            }
            function b(e) {
                return function(t) {
                    w[e].push(t);
                };
            }
            function y(e, t, n) {
                var a, r;
                if (L.hasOwnProperty(e)) L[e].call(t, n); else for (r = w[e], a = 0; a < r.length; a++) r[a].call(t, n);
            }
            function M(e, t) {
                if (t.indexOf) return t.indexOf(e);
                for (var n = 0, a = t.length; n < a; n++) if (t[n] === e) return n;
                return -1;
            }
            function $(e) {
                m(this, e), this.assertions = [], this.testNumber = ++$.count;
            }
            var L, k, w, D, Y = 0, T = (i(0) || "").replace(/(:\d+)+\)?/, "").replace(/.+\//, ""), S = Object.prototype.toString, x = Object.prototype.hasOwnProperty, C = t.Date, E = t.setTimeout, H = t.clearTimeout, j = {
                document: "undefined" != typeof t.document,
                setTimeout: "undefined" != typeof t.setTimeout,
                sessionStorage: function() {
                    var e = "qunit-test-string";
                    try {
                        return sessionStorage.setItem(e, e), sessionStorage.removeItem(e), !0;
                    } catch (e) {
                        return !1;
                    }
                }()
            }, A = function(e) {
                var t, n, a = e.toString();
                return "[object" === a.substring(0, 7) ? (t = e.name ? e.name.toString() : "Error", 
                n = e.message ? e.message.toString() : "", t && n ? t + ": " + n : t ? t : n ? n : "Error") : a;
            }, O = function(e) {
                var t, n, a = L.is("array", e) ? [] : {};
                for (t in e) x.call(e, t) && (n = e[t], a[t] = n === Object(n) ? O(n) : n);
                return a;
            };
            L = {
                module: function(e, t) {
                    w.currentModule = e, w.currentModuleTestEnvironment = t, w.modules[e] = !0;
                },
                asyncTest: function(e, t, n) {
                    2 === arguments.length && (n = t, t = null), L.test(e, t, n, !0);
                },
                test: function(e, t, n, r) {
                    var o, u = "<span class='test-name'>" + s(e) + "</span>";
                    2 === arguments.length && (n = t, t = null), w.currentModule && (u = "<span class='module-name'>" + s(w.currentModule) + "</span>: " + u), 
                    o = new $({
                        nameHtml: u,
                        testName: e,
                        expected: t,
                        async: r,
                        callback: n,
                        module: w.currentModule,
                        moduleTestEnvironment: w.currentModuleTestEnvironment,
                        stack: i(2)
                    }), a(o) && o.queue();
                },
                expect: function(e) {
                    return 1 !== arguments.length ? w.current.expected : void (w.current.expected = e);
                },
                start: function(e) {
                    return void 0 === w.semaphore ? void L.begin(function() {
                        E(function() {
                            L.start(e);
                        });
                    }) : (w.semaphore -= e || 1, w.semaphore > 0 ? void 0 : w.semaphore < 0 ? (w.semaphore = 0, 
                    void L.pushFailure("Called start() while already started (QUnit.config.semaphore was 0 already)", null, i(2))) : void (j.setTimeout ? E(function() {
                        w.semaphore > 0 || (w.timeout && H(w.timeout), w.blocking = !1, u(!0));
                    }, 13) : (w.blocking = !1, u(!0))));
                },
                stop: function(e) {
                    w.semaphore += e || 1, w.blocking = !0, w.testTimeout && j.setTimeout && (H(w.timeout), 
                    w.timeout = E(function() {
                        L.ok(!1, "Test timed out"), w.semaphore = 1, L.start();
                    }, w.testTimeout));
                }
            }, function() {
                function e() {}
                e.prototype = L, L = new e(), L.constructor = e;
            }(), w = {
                queue: [],
                blocking: !0,
                hidepassed: !1,
                reorder: !0,
                altertitle: !0,
                scrolltop: !0,
                requireExpects: !1,
                urlConfig: [ {
                    id: "noglobals",
                    label: "Check for Globals",
                    tooltip: "Enabling this will test if any test introduces new properties on the `window` object. Stored as query-strings."
                }, {
                    id: "notrycatch",
                    label: "No try-catch",
                    tooltip: "Enabling this will run tests outside of a try-catch block. Makes debugging exceptions in IE reasonable. Stored as query-strings."
                } ],
                modules: {},
                begin: [],
                done: [],
                log: [],
                testStart: [],
                testDone: [],
                moduleStart: [],
                moduleDone: []
            }, function() {
                var e, n, a = t.location || {
                    search: "",
                    protocol: "file:"
                }, r = a.search.slice(1).split("&"), i = r.length, s = {};
                if (r[0]) for (e = 0; e < i; e++) n = r[e].split("="), n[0] = decodeURIComponent(n[0]), 
                n[1] = !n[1] || decodeURIComponent(n[1]), s[n[0]] ? s[n[0]] = [].concat(s[n[0]], n[1]) : s[n[0]] = n[1];
                if (L.urlParams = s, w.filter = s.filter, w.module = s.module, w.testNumber = [], 
                s.testNumber) for (s.testNumber = [].concat(s.testNumber), e = 0; e < s.testNumber.length; e++) n = s.testNumber[e], 
                w.testNumber.push(parseInt(n, 10));
                L.isLocal = "file:" === a.protocol;
            }(), m(L, {
                config: w,
                init: function() {
                    m(w, {
                        stats: {
                            all: 0,
                            bad: 0
                        },
                        moduleStats: {
                            all: 0,
                            bad: 0
                        },
                        started: +new C(),
                        updateRate: 1e3,
                        blocking: !1,
                        autostart: !0,
                        autorun: !1,
                        filter: "",
                        queue: [],
                        semaphore: 1
                    });
                    var e, t, n, a = v("qunit");
                    a && (a.innerHTML = "<h1 id='qunit-header'>" + s(document.title) + "</h1><h2 id='qunit-banner'></h2><div id='qunit-testrunner-toolbar'></div><h2 id='qunit-userAgent'></h2><ol id='qunit-tests'></ol>"), 
                    e = v("qunit-tests"), t = v("qunit-banner"), n = v("qunit-testresult"), e && (e.innerHTML = ""), 
                    t && (t.className = ""), n && n.parentNode.removeChild(n), e && (n = document.createElement("p"), 
                    n.id = "qunit-testresult", n.className = "result", e.parentNode.insertBefore(n, e), 
                    n.innerHTML = "Running...<br/>&nbsp;");
                },
                reset: function() {
                    var e = v("qunit-fixture");
                    e && (e.innerHTML = w.fixture);
                },
                is: function(e, t) {
                    return L.objectType(t) === e;
                },
                objectType: function(e) {
                    if ("undefined" == typeof e) return "undefined";
                    if (null === e) return "null";
                    var t = S.call(e).match(/^\[object\s(.*)\]$/), n = t && t[1] || "";
                    switch (n) {
                      case "Number":
                        return isNaN(e) ? "nan" : "number";

                      case "String":
                      case "Boolean":
                      case "Array":
                      case "Date":
                      case "RegExp":
                      case "Function":
                        return n.toLowerCase();
                    }
                    return "object" == typeof e ? "object" : void 0;
                },
                push: function(e, t, n, a) {
                    if (!w.current) throw new Error("assertion outside test context, was " + i());
                    var r, o, u = {
                        module: w.current.module,
                        name: w.current.testName,
                        result: e,
                        message: a,
                        actual: t,
                        expected: n
                    };
                    a = s(a) || (e ? "okay" : "failed"), a = "<span class='test-message'>" + a + "</span>", 
                    r = a, e || (n = s(L.jsDump.parse(n)), t = s(L.jsDump.parse(t)), r += "<table><tr class='test-expected'><th>Expected: </th><td><pre>" + n + "</pre></td></tr>", 
                    t !== n && (r += "<tr class='test-actual'><th>Result: </th><td><pre>" + t + "</pre></td></tr>", 
                    r += "<tr class='test-diff'><th>Diff: </th><td><pre>" + L.diff(n, t) + "</pre></td></tr>"), 
                    o = i(), o && (u.source = o, r += "<tr class='test-source'><th>Source: </th><td><pre>" + s(o) + "</pre></td></tr>"), 
                    r += "</table>"), y("log", L, u), w.current.assertions.push({
                        result: !!e,
                        message: r
                    });
                },
                pushFailure: function(e, t, n) {
                    if (!w.current) throw new Error("pushFailure() assertion outside test context, was " + i(2));
                    var a, r = {
                        module: w.current.module,
                        name: w.current.testName,
                        result: !1,
                        message: e
                    };
                    e = s(e) || "error", e = "<span class='test-message'>" + e + "</span>", a = e, a += "<table>", 
                    n && (a += "<tr class='test-actual'><th>Result: </th><td><pre>" + s(n) + "</pre></td></tr>"), 
                    t && (r.source = t, a += "<tr class='test-source'><th>Source: </th><td><pre>" + s(t) + "</pre></td></tr>"), 
                    a += "</table>", y("log", L, r), w.current.assertions.push({
                        result: !1,
                        message: a
                    });
                },
                url: function(e) {
                    e = m(m({}, L.urlParams), e);
                    var n, a = "?";
                    for (n in e) x.call(e, n) && (a += encodeURIComponent(n) + "=" + encodeURIComponent(e[n]) + "&");
                    return t.location.protocol + "//" + t.location.host + t.location.pathname + a.slice(0, -1);
                },
                extend: m,
                id: v,
                addEvent: f,
                addClass: g,
                hasClass: h,
                removeClass: _
            }), m(L.constructor.prototype, {
                begin: b("begin"),
                done: b("done"),
                log: b("log"),
                testStart: b("testStart"),
                testDone: b("testDone"),
                moduleStart: b("moduleStart"),
                moduleDone: b("moduleDone")
            }), j.document && "complete" !== document.readyState || (w.autorun = !0), L.load = function() {
                y("begin", L, {});
                var e, n, a, r, i, o, u, l, c, d, h, g, _, b, M = 0, $ = [], k = "", D = "", Y = m({}, w);
                for (L.init(), m(w, Y), w.blocking = !1, o = w.urlConfig.length, a = 0; a < o; a++) if (d = w.urlConfig[a], 
                "string" == typeof d && (d = {
                    id: d,
                    label: d
                }), w[d.id] = L.urlParams[d.id], d.value && "string" != typeof d.value) {
                    if (D += "<label for='qunit-urlconfig-" + s(d.id) + "' title='" + s(d.tooltip) + "'>" + d.label + ": </label><select id='qunit-urlconfig-" + s(d.id) + "' name='" + s(d.id) + "' title='" + s(d.tooltip) + "'><option></option>", 
                    h = !1, L.is("array", d.value)) for (r = 0; r < d.value.length; r++) D += "<option value='" + s(d.value[r]) + "'" + (w[d.id] === d.value[r] ? (h = !0) && " selected='selected'" : "") + ">" + s(d.value[r]) + "</option>"; else for (r in d.value) x.call(d.value, r) && (D += "<option value='" + s(r) + "'" + (w[d.id] === r ? (h = !0) && " selected='selected'" : "") + ">" + s(d.value[r]) + "</option>");
                    w[d.id] && !h && (D += "<option value='" + s(w[d.id]) + "' selected='selected' disabled='disabled'>" + s(w[d.id]) + "</option>"), 
                    D += "</select>";
                } else D += "<input id='qunit-urlconfig-" + s(d.id) + "' name='" + s(d.id) + "' type='checkbox'" + (d.value ? " value='" + s(d.value) + "'" : "") + (w[d.id] ? " checked='checked'" : "") + " title='" + s(d.tooltip) + "'><label for='qunit-urlconfig-" + s(d.id) + "' title='" + s(d.tooltip) + "'>" + d.label + "</label>";
                for (a in w.modules) w.modules.hasOwnProperty(a) && $.push(a);
                for (M = $.length, $.sort(function(e, t) {
                    return e.localeCompare(t);
                }), k += "<label for='qunit-modulefilter'>Module: </label><select id='qunit-modulefilter' name='modulefilter'><option value='' " + (void 0 === w.module ? "selected='selected'" : "") + ">< All Modules ></option>", 
                a = 0; a < M; a++) k += "<option value='" + s(encodeURIComponent($[a])) + "' " + (w.module === $[a] ? "selected='selected'" : "") + ">" + s($[a]) + "</option>";
                k += "</select>", b = v("qunit-userAgent"), b && (b.innerHTML = navigator.userAgent), 
                e = v("qunit-header"), e && (e.innerHTML = "<a href='" + L.url({
                    filter: void 0,
                    module: void 0,
                    testNumber: void 0
                }) + "'>" + e.innerHTML + "</a> "), c = v("qunit-testrunner-toolbar"), c && (n = document.createElement("input"), 
                n.type = "checkbox", n.id = "qunit-filter-pass", f(n, "click", function() {
                    var e, t = v("qunit-tests");
                    n.checked ? t.className = t.className + " hidepass" : (e = " " + t.className.replace(/[\n\t\r]/g, " ") + " ", 
                    t.className = e.replace(/ hidepass /, " ")), j.sessionStorage && (n.checked ? sessionStorage.setItem("qunit-filter-passed-tests", "true") : sessionStorage.removeItem("qunit-filter-passed-tests"));
                }), (w.hidepassed || j.sessionStorage && sessionStorage.getItem("qunit-filter-passed-tests")) && (n.checked = !0, 
                l = v("qunit-tests"), l.className = l.className + " hidepass"), c.appendChild(n), 
                i = document.createElement("label"), i.setAttribute("for", "qunit-filter-pass"), 
                i.setAttribute("title", "Only show tests and assertions that fail. Stored in sessionStorage."), 
                i.innerHTML = "Hide passed tests", c.appendChild(i), g = document.createElement("span"), 
                g.innerHTML = D, p(g.getElementsByTagName("input"), "click", function(e) {
                    var n = {}, a = e.target || e.srcElement;
                    n[a.name] = a.checked ? a.defaultValue || !0 : void 0, t.location = L.url(n);
                }), p(g.getElementsByTagName("select"), "change", function(e) {
                    var n = {}, a = e.target || e.srcElement;
                    n[a.name] = a.options[a.selectedIndex].value || void 0, t.location = L.url(n);
                }), c.appendChild(g), M > 1 && (_ = document.createElement("span"), _.setAttribute("id", "qunit-modulefilter-container"), 
                _.innerHTML = k, f(_.lastChild, "change", function() {
                    var e = _.getElementsByTagName("select")[0], n = decodeURIComponent(e.options[e.selectedIndex].value);
                    t.location = L.url({
                        module: "" === n ? void 0 : n,
                        filter: void 0,
                        testNumber: void 0
                    });
                }), c.appendChild(_))), u = v("qunit-fixture"), u && (w.fixture = u.innerHTML), 
                w.autostart && L.start();
            }, j.document && f(t, "load", L.load), D = t.onerror, t.onerror = function(e, t, n) {
                var r = !1;
                if (D && (r = D(e, t, n)), r !== !0) {
                    if (L.config.current) {
                        if (L.config.current.ignoreGlobalErrors) return !0;
                        L.pushFailure(e, t + ":" + n);
                    } else L.test("global failure", m(function() {
                        L.pushFailure(e, t + ":" + n);
                    }, {
                        validTest: a
                    }));
                    return !1;
                }
                return r;
            }, $.count = 0, $.prototype = {
                init: function() {
                    var e, t, n, a = v("qunit-tests");
                    a && (t = document.createElement("strong"), t.innerHTML = this.nameHtml, e = document.createElement("a"), 
                    e.innerHTML = "Rerun", e.href = L.url({
                        testNumber: this.testNumber
                    }), n = document.createElement("li"), n.appendChild(t), n.appendChild(e), n.className = "running", 
                    n.id = this.id = "qunit-test-output" + Y++, a.appendChild(n));
                },
                setup: function() {
                    if (this.module === w.previousModule && x.call(w, "previousModule") || (x.call(w, "previousModule") && y("moduleDone", L, {
                        name: w.previousModule,
                        failed: w.moduleStats.bad,
                        passed: w.moduleStats.all - w.moduleStats.bad,
                        total: w.moduleStats.all
                    }), w.previousModule = this.module, w.moduleStats = {
                        all: 0,
                        bad: 0
                    }, y("moduleStart", L, {
                        name: this.module
                    })), w.current = this, this.testEnvironment = m({
                        setup: function() {},
                        teardown: function() {}
                    }, this.moduleTestEnvironment), this.started = +new C(), y("testStart", L, {
                        name: this.testName,
                        module: this.module
                    }), L.current_testEnvironment = this.testEnvironment, w.pollution || l(), w.notrycatch) return void this.testEnvironment.setup.call(this.testEnvironment, L.assert);
                    try {
                        this.testEnvironment.setup.call(this.testEnvironment, L.assert);
                    } catch (e) {
                        L.pushFailure("Setup failed on " + this.testName + ": " + (e.message || e), r(e, 1));
                    }
                },
                run: function() {
                    w.current = this;
                    var e = v("qunit-testresult");
                    if (e && (e.innerHTML = "Running: <br/>" + this.nameHtml), this.async && L.stop(), 
                    this.callbackStarted = +new C(), w.notrycatch) return this.callback.call(this.testEnvironment, L.assert), 
                    void (this.callbackRuntime = +new C() - this.callbackStarted);
                    try {
                        this.callback.call(this.testEnvironment, L.assert), this.callbackRuntime = +new C() - this.callbackStarted;
                    } catch (e) {
                        this.callbackRuntime = +new C() - this.callbackStarted, L.pushFailure("Died on test #" + (this.assertions.length + 1) + " " + this.stack + ": " + (e.message || e), r(e, 0)), 
                        l(), w.blocking && L.start();
                    }
                },
                teardown: function() {
                    if (w.current = this, w.notrycatch) return "undefined" == typeof this.callbackRuntime && (this.callbackRuntime = +new C() - this.callbackStarted), 
                    void this.testEnvironment.teardown.call(this.testEnvironment, L.assert);
                    try {
                        this.testEnvironment.teardown.call(this.testEnvironment, L.assert);
                    } catch (e) {
                        L.pushFailure("Teardown failed on " + this.testName + ": " + (e.message || e), r(e, 1));
                    }
                    c();
                },
                finish: function() {
                    w.current = this, w.requireExpects && null === this.expected ? L.pushFailure("Expected number of assertions to be defined, but expect() was not called.", this.stack) : null !== this.expected && this.expected !== this.assertions.length ? L.pushFailure("Expected " + this.expected + " assertions, but " + this.assertions.length + " were run", this.stack) : null !== this.expected || this.assertions.length || L.pushFailure("Expected at least one assertion, but none were run - call expect(0) to accept zero assertions.", this.stack);
                    var e, n, a, r, i, s, o, u = this, l = 0, c = 0, d = v("qunit-tests");
                    if (this.runtime = +new C() - this.started, w.stats.all += this.assertions.length, 
                    w.moduleStats.all += this.assertions.length, d) {
                        for (o = document.createElement("ol"), o.className = "qunit-assert-list", e = 0; e < this.assertions.length; e++) n = this.assertions[e], 
                        s = document.createElement("li"), s.className = n.result ? "pass" : "fail", s.innerHTML = n.message || (n.result ? "okay" : "failed"), 
                        o.appendChild(s), n.result ? l++ : (c++, w.stats.bad++, w.moduleStats.bad++);
                        L.config.reorder && j.sessionStorage && (c ? sessionStorage.setItem("qunit-test-" + this.module + "-" + this.testName, c) : sessionStorage.removeItem("qunit-test-" + this.module + "-" + this.testName)), 
                        0 === c && g(o, "qunit-collapsed"), r = document.createElement("strong"), r.innerHTML = this.nameHtml + " <b class='counts'>(<b class='failed'>" + c + "</b>, <b class='passed'>" + l + "</b>, " + this.assertions.length + ")</b>", 
                        f(r, "click", function() {
                            var e = r.parentNode.lastChild, t = h(e, "qunit-collapsed");
                            (t ? _ : g)(e, "qunit-collapsed");
                        }), f(r, "dblclick", function(e) {
                            var n = e && e.target ? e.target : t.event.srcElement;
                            "span" !== n.nodeName.toLowerCase() && "b" !== n.nodeName.toLowerCase() || (n = n.parentNode), 
                            t.location && "strong" === n.nodeName.toLowerCase() && (t.location = L.url({
                                testNumber: u.testNumber
                            }));
                        }), i = document.createElement("span"), i.className = "runtime", i.innerHTML = this.runtime + " ms", 
                        s = v(this.id), s.className = c ? "fail" : "pass", s.removeChild(s.firstChild), 
                        a = s.firstChild, s.appendChild(r), s.appendChild(a), s.appendChild(i), s.appendChild(o);
                    } else for (e = 0; e < this.assertions.length; e++) this.assertions[e].result || (c++, 
                    w.stats.bad++, w.moduleStats.bad++);
                    y("testDone", L, {
                        name: this.testName,
                        module: this.module,
                        failed: c,
                        passed: this.assertions.length - c,
                        total: this.assertions.length,
                        runtime: this.runtime,
                        duration: this.runtime
                    }), L.reset(), w.current = void 0;
                },
                queue: function() {
                    function e() {
                        o(function() {
                            n.setup();
                        }), o(function() {
                            n.run();
                        }), o(function() {
                            n.teardown();
                        }), o(function() {
                            n.finish();
                        });
                    }
                    var t, n = this;
                    o(function() {
                        n.init();
                    }), t = L.config.reorder && j.sessionStorage && +sessionStorage.getItem("qunit-test-" + this.module + "-" + this.testName), 
                    t ? e() : o(e, !0);
                }
            }, k = L.assert = {
                ok: function(e, t) {
                    if (!w.current) throw new Error("ok() assertion outside test context, was " + i(2));
                    e = !!e, t = t || (e ? "okay" : "failed");
                    var n, a = {
                        module: w.current.module,
                        name: w.current.testName,
                        result: e,
                        message: t
                    };
                    t = "<span class='test-message'>" + s(t) + "</span>", e || (n = i(2), n && (a.source = n, 
                    t += "<table><tr class='test-source'><th>Source: </th><td><pre>" + s(n) + "</pre></td></tr></table>")), 
                    y("log", L, a), w.current.assertions.push({
                        result: e,
                        message: t
                    });
                },
                equal: function(e, t, n) {
                    L.push(t == e, e, t, n);
                },
                notEqual: function(e, t, n) {
                    L.push(t != e, e, t, n);
                },
                propEqual: function(e, t, n) {
                    e = O(e), t = O(t), L.push(L.equiv(e, t), e, t, n);
                },
                notPropEqual: function(e, t, n) {
                    e = O(e), t = O(t), L.push(!L.equiv(e, t), e, t, n);
                },
                deepEqual: function(e, t, n) {
                    L.push(L.equiv(e, t), e, t, n);
                },
                notDeepEqual: function(e, t, n) {
                    L.push(!L.equiv(e, t), e, t, n);
                },
                strictEqual: function(e, t, n) {
                    L.push(t === e, e, t, n);
                },
                notStrictEqual: function(e, t, n) {
                    L.push(t !== e, e, t, n);
                },
                throws: function(e, t, n) {
                    var a, r = t, i = !1;
                    n || "string" != typeof t || (n = t, t = null), w.current.ignoreGlobalErrors = !0;
                    try {
                        e.call(w.current.testEnvironment);
                    } catch (e) {
                        a = e;
                    }
                    w.current.ignoreGlobalErrors = !1, a ? (t ? t instanceof Error ? i = a instanceof Error && a.name === t.name && a.message === t.message : "regexp" === L.objectType(t) ? i = t.test(A(a)) : "string" === L.objectType(t) ? i = t === A(a) : a instanceof t ? i = !0 : t.call({}, a) === !0 && (r = null, 
                    i = !0) : (i = !0, r = null), L.push(i, a, r, n)) : L.pushFailure(n, null, "No exception was thrown.");
                }
            }, m(L.constructor.prototype, k), L.constructor.prototype.raises = function() {
                L.push(!1, !1, !1, "QUnit.raises has been deprecated since 2012 (fad3c1ea), use QUnit.throws instead");
            }, L.constructor.prototype.equals = function() {
                L.push(!1, !1, !1, "QUnit.equals has been deprecated since 2009 (e88049a0), use QUnit.equal instead");
            }, L.constructor.prototype.same = function() {
                L.push(!1, !1, !1, "QUnit.same has been deprecated since 2009 (e88049a0), use QUnit.deepEqual instead");
            }, L.equiv = function() {
                function e(e, t, n) {
                    var a = L.objectType(e);
                    if (a) return "function" === L.objectType(t[a]) ? t[a].apply(t, n) : t[a];
                }
                var t, n = [], a = [], r = [], i = Object.getPrototypeOf || function(e) {
                    return e.__proto__;
                }, s = function() {
                    function e(e, t) {
                        return e instanceof t.constructor || t instanceof e.constructor ? t == e : t === e;
                    }
                    return {
                        string: e,
                        boolean: e,
                        number: e,
                        null: e,
                        undefined: e,
                        nan: function(e) {
                            return isNaN(e);
                        },
                        date: function(e, t) {
                            return "date" === L.objectType(e) && t.valueOf() === e.valueOf();
                        },
                        regexp: function(e, t) {
                            return "regexp" === L.objectType(e) && t.source === e.source && t.global === e.global && t.ignoreCase === e.ignoreCase && t.multiline === e.multiline && t.sticky === e.sticky;
                        },
                        function: function() {
                            var e = n[n.length - 1];
                            return e !== Object && "undefined" != typeof e;
                        },
                        array: function(e, n) {
                            var i, s, o, u, l, c;
                            if ("array" !== L.objectType(e)) return !1;
                            if (o = n.length, o !== e.length) return !1;
                            for (a.push(n), r.push(e), i = 0; i < o; i++) {
                                for (u = !1, s = 0; s < a.length; s++) if (l = a[s] === n[i], c = r[s] === e[i], 
                                l || c) {
                                    if (!(n[i] === e[i] || l && c)) return a.pop(), r.pop(), !1;
                                    u = !0;
                                }
                                if (!u && !t(n[i], e[i])) return a.pop(), r.pop(), !1;
                            }
                            return a.pop(), r.pop(), !0;
                        },
                        object: function(e, s) {
                            var o, u, l, c, d, m = !0, f = [], p = [];
                            if (s.constructor !== e.constructor && !(null === i(s) && i(e) === Object.prototype || null === i(e) && i(s) === Object.prototype)) return !1;
                            n.push(s.constructor), a.push(s), r.push(e);
                            for (o in s) {
                                for (l = !1, u = 0; u < a.length; u++) if (c = a[u] === s[o], d = r[u] === e[o], 
                                c || d) {
                                    if (!(s[o] === e[o] || c && d)) {
                                        m = !1;
                                        break;
                                    }
                                    l = !0;
                                }
                                if (f.push(o), !l && !t(s[o], e[o])) {
                                    m = !1;
                                    break;
                                }
                            }
                            a.pop(), r.pop(), n.pop();
                            for (o in e) p.push(o);
                            return m && t(f.sort(), p.sort());
                        }
                    };
                }();
                return t = function() {
                    var n = [].slice.apply(arguments);
                    return n.length < 2 || function(t, n) {
                        return t === n || null !== t && null !== n && "undefined" != typeof t && "undefined" != typeof n && L.objectType(t) === L.objectType(n) && e(t, s, [ n, t ]);
                    }(n[0], n[1]) && t.apply(this, n.splice(1, n.length - 1));
                };
            }(), L.jsDump = function() {
                function e(e) {
                    return '"' + e.toString().replace(/"/g, '\\"') + '"';
                }
                function t(e) {
                    return e + "";
                }
                function n(e, t, n) {
                    var a = i.separator(), r = i.indent(), s = i.indent(1);
                    return t.join && (t = t.join("," + a + s)), t ? [ e, s + t, r + n ].join(a) : e + n;
                }
                function a(e, t) {
                    var a = e.length, r = new Array(a);
                    for (this.up(); a--; ) r[a] = this.parse(e[a], void 0, t);
                    return this.down(), n("[", r, "]");
                }
                var r = /^function (\w+)/, i = {
                    parse: function(e, t, n) {
                        n = n || [];
                        var a, r, i = this.parsers[t || this.typeOf(e)];
                        return t = typeof i, a = M(e, n), a !== -1 ? "recursion(" + (a - n.length) + ")" : "function" === t ? (n.push(e), 
                        r = i.call(this, e, n), n.pop(), r) : "string" === t ? i : this.parsers.error;
                    },
                    typeOf: function(e) {
                        var t;
                        return t = null === e ? "null" : "undefined" == typeof e ? "undefined" : L.is("regexp", e) ? "regexp" : L.is("date", e) ? "date" : L.is("function", e) ? "function" : void 0 !== typeof e.setInterval && "undefined" != typeof e.document && "undefined" == typeof e.nodeType ? "window" : 9 === e.nodeType ? "document" : e.nodeType ? "node" : "[object Array]" === S.call(e) || "number" == typeof e.length && "undefined" != typeof e.item && (e.length ? e.item(0) === e[0] : null === e.item(0) && "undefined" == typeof e[0]) ? "array" : e.constructor === Error.prototype.constructor ? "error" : typeof e;
                    },
                    separator: function() {
                        return this.multiline ? this.HTML ? "<br />" : "\n" : this.HTML ? "&nbsp;" : " ";
                    },
                    indent: function(e) {
                        if (!this.multiline) return "";
                        var t = this.indentChar;
                        return this.HTML && (t = t.replace(/\t/g, "   ").replace(/ /g, "&nbsp;")), new Array(this.depth + (e || 0)).join(t);
                    },
                    up: function(e) {
                        this.depth += e || 1;
                    },
                    down: function(e) {
                        this.depth -= e || 1;
                    },
                    setParser: function(e, t) {
                        this.parsers[e] = t;
                    },
                    quote: e,
                    literal: t,
                    join: n,
                    depth: 1,
                    parsers: {
                        window: "[Window]",
                        document: "[Document]",
                        error: function(e) {
                            return 'Error("' + e.message + '")';
                        },
                        unknown: "[Unknown]",
                        null: "null",
                        undefined: "undefined",
                        function: function(e) {
                            var t = "function", a = "name" in e ? e.name : (r.exec(e) || [])[1];
                            return a && (t += " " + a), t += "( ", t = [ t, L.jsDump.parse(e, "functionArgs"), "){" ].join(""), 
                            n(t, L.jsDump.parse(e, "functionCode"), "}");
                        },
                        array: a,
                        nodelist: a,
                        arguments: a,
                        object: function(e, t) {
                            var a, r, i, s, o = [];
                            L.jsDump.up(), a = [];
                            for (r in e) a.push(r);
                            for (a.sort(), s = 0; s < a.length; s++) r = a[s], i = e[r], o.push(L.jsDump.parse(r, "key") + ": " + L.jsDump.parse(i, void 0, t));
                            return L.jsDump.down(), n("{", o, "}");
                        },
                        node: function(e) {
                            var t, n, a, r = L.jsDump.HTML ? "&lt;" : "<", i = L.jsDump.HTML ? "&gt;" : ">", s = e.nodeName.toLowerCase(), o = r + s, u = e.attributes;
                            if (u) for (n = 0, t = u.length; n < t; n++) a = u[n].nodeValue, a && "inherit" !== a && (o += " " + u[n].nodeName + "=" + L.jsDump.parse(a, "attribute"));
                            return o += i, 3 !== e.nodeType && 4 !== e.nodeType || (o += e.nodeValue), o + r + "/" + s + i;
                        },
                        functionArgs: function(e) {
                            var t, n = e.length;
                            if (!n) return "";
                            for (t = new Array(n); n--; ) t[n] = String.fromCharCode(97 + n);
                            return " " + t.join(", ") + " ";
                        },
                        key: e,
                        functionCode: "[code]",
                        attribute: e,
                        string: e,
                        date: e,
                        regexp: t,
                        number: t,
                        boolean: t
                    },
                    HTML: !1,
                    indentChar: "  ",
                    multiline: !0
                };
                return i;
            }(), L.diff = function() {
                function e(e, t) {
                    var n, a = {}, r = {};
                    for (n = 0; n < t.length; n++) x.call(a, t[n]) || (a[t[n]] = {
                        rows: [],
                        o: null
                    }), a[t[n]].rows.push(n);
                    for (n = 0; n < e.length; n++) x.call(r, e[n]) || (r[e[n]] = {
                        rows: [],
                        n: null
                    }), r[e[n]].rows.push(n);
                    for (n in a) x.call(a, n) && 1 === a[n].rows.length && x.call(r, n) && 1 === r[n].rows.length && (t[a[n].rows[0]] = {
                        text: t[a[n].rows[0]],
                        row: r[n].rows[0]
                    }, e[r[n].rows[0]] = {
                        text: e[r[n].rows[0]],
                        row: a[n].rows[0]
                    });
                    for (n = 0; n < t.length - 1; n++) null != t[n].text && null == t[n + 1].text && t[n].row + 1 < e.length && null == e[t[n].row + 1].text && t[n + 1] == e[t[n].row + 1] && (t[n + 1] = {
                        text: t[n + 1],
                        row: t[n].row + 1
                    }, e[t[n].row + 1] = {
                        text: e[t[n].row + 1],
                        row: n + 1
                    });
                    for (n = t.length - 1; n > 0; n--) null != t[n].text && null == t[n - 1].text && t[n].row > 0 && null == e[t[n].row - 1].text && t[n - 1] == e[t[n].row - 1] && (t[n - 1] = {
                        text: t[n - 1],
                        row: t[n].row - 1
                    }, e[t[n].row - 1] = {
                        text: e[t[n].row - 1],
                        row: n - 1
                    });
                    return {
                        o: e,
                        n: t
                    };
                }
                return function(t, n) {
                    t = t.replace(/\s+$/, ""), n = n.replace(/\s+$/, "");
                    var a, r, i = "", s = e("" === t ? [] : t.split(/\s+/), "" === n ? [] : n.split(/\s+/)), o = t.match(/\s+/g), u = n.match(/\s+/g);
                    if (null == o ? o = [ " " ] : o.push(" "), null == u ? u = [ " " ] : u.push(" "), 
                    0 === s.n.length) for (a = 0; a < s.o.length; a++) i += "<del>" + s.o[a] + o[a] + "</del>"; else {
                        if (null == s.n[0].text) for (n = 0; n < s.o.length && null == s.o[n].text; n++) i += "<del>" + s.o[n] + o[n] + "</del>";
                        for (a = 0; a < s.n.length; a++) if (null == s.n[a].text) i += "<ins>" + s.n[a] + u[a] + "</ins>"; else {
                            for (r = "", n = s.n[a].row + 1; n < s.o.length && null == s.o[n].text; n++) r += "<del>" + s.o[n] + o[n] + "</del>";
                            i += " " + s.n[a].text + u[a] + r;
                        }
                    }
                    return i;
                };
            }(), "undefined" != typeof t && (m(t, L.constructor.prototype), t.QUnit = L), "undefined" != typeof e && e.exports && (e.exports = L);
        }(function() {
            return this;
        }());
    }).call(t, n(248));
}, function(e, t) {
    function n() {
        throw new Error("setTimeout has not been defined");
    }
    function a() {
        throw new Error("clearTimeout has not been defined");
    }
    function r(e) {
        if (c === setTimeout) return setTimeout(e, 0);
        if ((c === n || !c) && setTimeout) return c = setTimeout, setTimeout(e, 0);
        try {
            return c(e, 0);
        } catch (t) {
            try {
                return c.call(null, e, 0);
            } catch (t) {
                return c.call(this, e, 0);
            }
        }
    }
    function i(e) {
        if (d === clearTimeout) return clearTimeout(e);
        if ((d === a || !d) && clearTimeout) return d = clearTimeout, clearTimeout(e);
        try {
            return d(e);
        } catch (t) {
            try {
                return d.call(null, e);
            } catch (t) {
                return d.call(this, e);
            }
        }
    }
    function s() {
        h && f && (h = !1, f.length ? p = f.concat(p) : g = -1, p.length && o());
    }
    function o() {
        if (!h) {
            var e = r(s);
            h = !0;
            for (var t = p.length; t; ) {
                for (f = p, p = []; ++g < t; ) f && f[g].run();
                g = -1, t = p.length;
            }
            f = null, h = !1, i(e);
        }
    }
    function u(e, t) {
        this.fun = e, this.array = t;
    }
    function l() {}
    var c, d, m = e.exports = {};
    !function() {
        try {
            c = "function" == typeof setTimeout ? setTimeout : n;
        } catch (e) {
            c = n;
        }
        try {
            d = "function" == typeof clearTimeout ? clearTimeout : a;
        } catch (e) {
            d = a;
        }
    }();
    var f, p = [], h = !1, g = -1;
    m.nextTick = function(e) {
        var t = new Array(arguments.length - 1);
        if (arguments.length > 1) for (var n = 1; n < arguments.length; n++) t[n - 1] = arguments[n];
        p.push(new u(e, t)), 1 !== p.length || h || r(o);
    }, u.prototype.run = function() {
        this.fun.apply(null, this.array);
    }, m.title = "browser", m.browser = !0, m.env = {}, m.argv = [], m.version = "", 
    m.versions = {}, m.on = l, m.addListener = l, m.once = l, m.off = l, m.removeListener = l, 
    m.removeAllListeners = l, m.emit = l, m.binding = function(e) {
        throw new Error("process.binding is not supported");
    }, m.cwd = function() {
        return "/";
    }, m.chdir = function(e) {
        throw new Error("process.chdir is not supported");
    }, m.umask = function() {
        return 0;
    };
}, function(e, t, n) {
    var a, r;
    !function(i, s) {
        "use strict";
        a = s, r = "function" == typeof a ? a.call(t, n, t, e) : a, !(void 0 !== r && (e.exports = r));
    }(this, function() {
        "use strict";
        function e(e, t) {
            var n;
            for (n in t) t.hasOwnProperty(n) && ("undefined" == typeof t[n] ? delete e[n] : e[n] = t[n]);
            return e;
        }
        function t(e, t) {
            var n;
            for (n = 0; n < e.length; n += 1) if (e[n] === t) return n;
            return -1;
        }
        function n(e, n) {
            var a = t(e, n);
            return a !== -1 ? e.splice(a, 1) : [];
        }
        function a(e) {
            return "undefined" != typeof e && "undefined" != typeof e.requireExpects && e.requireExpects;
        }
        function r(e) {
            return !!e.result;
        }
        function i(e) {
            return !r(e);
        }
        function s(e) {
            return i(e) && "undefined" == typeof e.expected && "undefined" == typeof e.actual;
        }
        function o(e) {
            return e.replace(/(\r?\n)/g, "$&# ");
        }
        function u(e) {
            return e.replace(/^\s+/, "");
        }
        function l(e) {
            return e;
        }
        function c(e, t, n, a) {
            e.push(t + ": " + a(n));
        }
        function d(e, t, n, a, r) {
            e && "undefined" != typeof a && c(t, n, a, r);
        }
        function m(e, t) {
            return t ? e + " - " + o(t) : e;
        }
        function f(f, _, v) {
            function b(e) {
                return w.config[e];
            }
            function y(e) {
                if (r(e)) return e.message;
                var t = [];
                return e.message && t.push(e.message), b("showExpectationOnFailure") && !s(e) && (c(t, "expected", e.expected, Y), 
                c(t, "got", e.actual, Y)), d(b("showTestNameOnFailure"), t, "test", e.name, l), 
                d(b("showModuleNameOnFailure"), t, "module", e.module, l), d(b("showSourceOnFailure"), t, "source", e.source, u), 
                t.join(", ");
            }
            function M(e) {
                w.puts(w.config.initialCount + ".." + e);
            }
            function $(e) {
                var a;
                t(S, e) !== -1 && (a = k.config[e], "undefined" != typeof a && n(a, x[e]));
            }
            function L(e) {
                var t;
                for (t = 0; t < e.length; t += 1) $(e[t]);
            }
            if (!f) throw new Error('should pass QUnit object reference. Please check QUnit\'s "require" path if you are using Node.js (or any CommonJS env).');
            if ("function" != typeof _) throw new Error("should pass print-like function");
            var k = f, w = {}, D = "undefined" != typeof k.jsDump && "function" == typeof k.jsDump.parse, Y = D ? function(e) {
                return k.jsDump.parse(e);
            } : l, T = function(e, t) {
                v && "object" == typeof v && "undefined" != typeof v[e] && (_('# WARNING: Option "' + e + '" is deprecated and will be removed in future version.'), 
                t(v[e]));
            }, S = [ "moduleStart", "testStart", "log", "testDone", "done" ], x = {};
            return w.config = e({
                initialCount: 1,
                showModuleNameOnFailure: !0,
                showTestNameOnFailure: !0,
                showExpectationOnFailure: !0,
                showSourceOnFailure: !0
            }, v), T("noPlan", function(e) {
                _('# Now QUnit-TAP works as with "noPlan: true" by default. If you want to delare plan explicitly, please use "QUnit.config.requireExpects" option instead.'), 
                w.config.noPlan = e;
            }), T("count", function(e) {
                w.config.initialCount = e + 1;
            }), T("showDetailsOnFailure", function(e) {
                w.config.showModuleNameOnFailure = e, w.config.showTestNameOnFailure = e, w.config.showExpectationOnFailure = e, 
                w.config.showSourceOnFailure = e;
            }), w.VERSION = p, w.puts = _, w.count = w.config.initialCount - 1, w.expectedCount = w.config.initialCount - 1, 
            w.explain = Y, w.note = function(e) {
                w.puts(o("# " + e));
            }, w.diag = function(e) {
                return w.note(e), !1;
            }, w.moduleStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                w.note("module: " + t);
            }, w.testStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                w.note("test: " + t);
            }, w.log = function(e) {
                var t = "";
                w.count += 1, i(e) && (t += "not "), t += "ok " + w.count, w.puts(m(t, y(e)));
            }, w.testDone = function() {
                a(k.config) && (w.expectedCount += k.config.current.expected);
            }, w.done = function() {
                ("undefined" == typeof w.config.noPlan || w.config.noPlan) && M(a(k.config) ? w.expectedCount : w.count);
            }, w.unsubscribe = function() {
                "undefined" != typeof k.config && L(0 === arguments.length ? S : h.apply(arguments));
            }, function() {
                var e, t, n, a = g(k);
                for (t = 0; t < S.length; t += 1) e = S[t], n = a(k, w, e), x[e] = n;
            }(), w;
        }
        var p = "1.5.0", h = Array.prototype.slice, g = function(e) {
            return function(e, t, n) {
                var a = e[n], r = function() {
                    t[n].apply(t, h.apply(arguments));
                };
                return a(r), r;
            };
        };
        return f.qunitTap = function() {
            throw new Error('[BC BREAK] Since 1.4.0, QUnit-TAP exports single qunitTap function as module.exports. Therefore, require("qunit-tap") returns qunitTap function itself. Please fix your code if you are using Node.js (or any CommonJS env).');
        }, f;
    });
}, function(e, t, n) {
    (function(e) {
        "use strict";
        var t = !1;
        QUnit.config.autostart = !1;
        var n = window.onerror;
        window.onerror = null, QUnit.begin(function() {
            window.onerror = function(e, t, a) {
                var r = !1;
                return n && (r = n(e, t, a)), QUnit.config.current && QUnit.config.current.async && QUnit.start(), 
                r;
            };
        }), QUnit.moduleStart(function() {
            t = !0;
        }), QUnit.done(function() {
            console.log("phantom-tap-done"), window.onerror = null;
        });
        var a = /^((not )?ok [0-9]+ (- )?)(.*)$/;
        qunitTap(QUnit, function() {
            if (1 == arguments.length && QUnit.config.current) {
                var e = a.exec(arguments[0]);
                if (e) return void console.log(e[1] + QUnit.config.current.testName + ": " + e[4]);
            }
            console.log.apply(console, arguments);
        }), window.setTimeout(function() {
            t || (console.log("QUnit not started by test"), console.log("phantom-tap-error"));
        }, 2e4), window.tests_included = !0, e && e.exports && (e.exports = QUnit);
    }).call(t, n(63)(e));
}, function(e, t) {} ]);
//# sourceMappingURL=test-images.min.js.map