#
# Copyright (C) 2021 Red Hat, Inc.
#
# Cockpit is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation; either version 2.1 of the License, or
# (at your option) any later version.
#
# Cockpit is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Cockpit; If not, see <http://www.gnu.org/licenses/>.
#

Name:           cockpit-machines
Version:        314
Release:        1%{?dist}
Summary:        Cockpit user interface for virtual machines
License:        LGPL-2.1-or-later AND MIT
URL:            https://github.com/cockpit-project/cockpit-machines

Source0:        https://github.com/cockpit-project/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz
BuildArch:      noarch
%if 0%{?suse_version}
BuildRequires:  appstream-glib
%else
BuildRequires:  libappstream-glib
%endif
BuildRequires:  make
BuildRequires: gettext
%if 0%{?rhel} && 0%{?rhel} <= 8
BuildRequires: libappstream-glib-devel
%endif

Requires: cockpit-bridge >= 215
%if 0%{?suse_version}
Requires: libvirt-daemon-qemu
%else
Requires: libvirt-daemon-driver-qemu
Requires: libvirt-daemon-driver-network
Requires: libvirt-daemon-driver-nodedev
Requires: libvirt-daemon-driver-storage-core
Requires: (libvirt-daemon-driver-interface if virt-install)
Requires: (libvirt-daemon-config-network if virt-install)
Recommends: libvirt-daemon-driver-storage-disk
%if 0%{?rhel}
Requires: qemu-kvm
%else
# smaller footprint on Fedora, as qemu-kvm is really expensive on a server
Requires: qemu-kvm-core
Recommends: qemu-block-curl
Recommends: qemu-char-spice
Recommends: qemu-device-usb-host
Recommends: qemu-device-usb-redirect
# HACK: https://bugzilla.redhat.com/show_bug.cgi?id=2170110
%if 0%{?fedora} >= 38
Requires: (qemu-audio-spice if qemu-char-spice)
%endif
%endif
%endif
Requires: libvirt-client
Requires: libvirt-dbus >= 1.2.0
# Optional components
Recommends: virt-install >= 3.0.0
Recommends: libosinfo
Recommends: python3-gobject-base
Suggests: (qemu-virtiofsd or virtiofsd)

Provides: bundled(npm(@novnc/novnc)) = 1.4.0
Provides: bundled(npm(@patternfly/patternfly)) = 5.3.1
Provides: bundled(npm(@patternfly/react-console)) = 5.0.0
Provides: bundled(npm(@patternfly/react-core)) = 5.3.3
Provides: bundled(npm(@patternfly/react-icons)) = 5.3.2
Provides: bundled(npm(@patternfly/react-styles)) = 5.3.1
Provides: bundled(npm(@patternfly/react-table)) = 5.3.3
Provides: bundled(npm(@patternfly/react-tokens)) = 5.3.1
Provides: bundled(npm(@spice-project/spice-html5)) = 0.2.1
Provides: bundled(npm(array-buffer-byte-length)) = 1.0.1
Provides: bundled(npm(attr-accept)) = 2.2.2
Provides: bundled(npm(available-typed-arrays)) = 1.0.7
Provides: bundled(npm(call-bind)) = 1.0.7
Provides: bundled(npm(date-fns)) = 3.6.0
Provides: bundled(npm(deep-equal)) = 2.2.3
Provides: bundled(npm(define-data-property)) = 1.1.4
Provides: bundled(npm(define-properties)) = 1.2.1
Provides: bundled(npm(es-define-property)) = 1.0.0
Provides: bundled(npm(es-errors)) = 1.3.0
Provides: bundled(npm(es-get-iterator)) = 1.1.3
Provides: bundled(npm(file-saver)) = 1.3.8
Provides: bundled(npm(file-selector)) = 0.6.0
Provides: bundled(npm(focus-trap)) = 7.5.2
Provides: bundled(npm(for-each)) = 0.3.3
Provides: bundled(npm(function-bind)) = 1.1.2
Provides: bundled(npm(functions-have-names)) = 1.2.3
Provides: bundled(npm(get-intrinsic)) = 1.2.4
Provides: bundled(npm(gopd)) = 1.0.1
Provides: bundled(npm(has-bigints)) = 1.0.2
Provides: bundled(npm(has-property-descriptors)) = 1.0.2
Provides: bundled(npm(has-proto)) = 1.0.3
Provides: bundled(npm(has-symbols)) = 1.0.3
Provides: bundled(npm(has-tostringtag)) = 1.0.2
Provides: bundled(npm(hasown)) = 2.0.2
Provides: bundled(npm(internal-slot)) = 1.0.7
Provides: bundled(npm(is-arguments)) = 1.1.1
Provides: bundled(npm(is-array-buffer)) = 3.0.4
Provides: bundled(npm(is-bigint)) = 1.0.4
Provides: bundled(npm(is-boolean-object)) = 1.1.2
Provides: bundled(npm(is-callable)) = 1.2.7
Provides: bundled(npm(is-date-object)) = 1.0.5
Provides: bundled(npm(is-map)) = 2.0.3
Provides: bundled(npm(is-number-object)) = 1.0.7
Provides: bundled(npm(is-regex)) = 1.1.4
Provides: bundled(npm(is-set)) = 2.0.3
Provides: bundled(npm(is-shared-array-buffer)) = 1.0.3
Provides: bundled(npm(is-string)) = 1.0.7
Provides: bundled(npm(is-symbol)) = 1.0.4
Provides: bundled(npm(is-weakmap)) = 2.0.2
Provides: bundled(npm(is-weakset)) = 2.0.3
Provides: bundled(npm(isarray)) = 2.0.5
Provides: bundled(npm(js-tokens)) = 4.0.0
Provides: bundled(npm(lodash)) = 4.17.21
Provides: bundled(npm(loose-envify)) = 1.4.0
Provides: bundled(npm(object-assign)) = 4.1.1
Provides: bundled(npm(object-inspect)) = 1.13.1
Provides: bundled(npm(object-is)) = 1.1.6
Provides: bundled(npm(object-keys)) = 1.1.1
Provides: bundled(npm(object.assign)) = 4.1.5
Provides: bundled(npm(possible-typed-array-names)) = 1.0.0
Provides: bundled(npm(prop-types)) = 15.8.1
Provides: bundled(npm(react-dom)) = 18.3.1
Provides: bundled(npm(react-dropzone)) = 14.2.3
Provides: bundled(npm(react-is)) = 16.13.1
Provides: bundled(npm(react)) = 18.3.1
Provides: bundled(npm(redux-thunk)) = 3.1.0
Provides: bundled(npm(redux)) = 5.0.1
Provides: bundled(npm(regexp.prototype.flags)) = 1.5.2
Provides: bundled(npm(scheduler)) = 0.23.2
Provides: bundled(npm(set-function-length)) = 1.2.2
Provides: bundled(npm(set-function-name)) = 2.0.2
Provides: bundled(npm(side-channel)) = 1.0.6
Provides: bundled(npm(stop-iteration-iterator)) = 1.0.0
Provides: bundled(npm(tabbable)) = 6.2.0
Provides: bundled(npm(throttle-debounce)) = 5.0.0
Provides: bundled(npm(tslib)) = 2.6.2
Provides: bundled(npm(which-boxed-primitive)) = 1.0.2
Provides: bundled(npm(which-collection)) = 1.0.2
Provides: bundled(npm(which-typed-array)) = 1.1.15
Provides: bundled(npm(xterm-addon-canvas)) = 0.5.0
Provides: bundled(npm(xterm-addon-fit)) = 0.2.1
Provides: bundled(npm(xterm)) = 4.19.0
Provides: bundled(npm(xterm)) = 5.1.0

%description
Cockpit component for managing virtual machines.

If "virt-install" is installed, you can also create new virtual machines.

%prep
%setup -q -n %{name}

%build
# Nothing to build

%install
%make_install PREFIX=/usr
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/metainfo/*

%files
%doc README.md
%license LICENSE dist/index.js.LEGAL.txt dist/index.css.LEGAL.txt
%{_datadir}/cockpit/*
%{_datadir}/metainfo/*

# The changelog is automatically generated and merged
%changelog
