/*
*
* cobex_defs.h - definitions for my little OBEX over cable hack.
*
* Copyright (c) 2003,2004,2005,2006 Fredrik Srensson
*
* History:
* v1.0 - fsn - 03-08-24 - First version
*
* Source:
* OBEX13.pdf from www.irda.org
*
*/

#ifndef __COBEX_DEFS_H
#define __COBEX_DEFS_H

#define	OBEX_RESPONSE_CONTINUE		0x10

#define	OBEX_RESPONSE_OK		0x20
#define	OBEX_RESPONSE_CREATED		0x21
#define	OBEX_RESPONSE_ACCEPTED		0x22
#define	OBEX_RESPONSE_NONAUTH_INF	0x23
#define	OBEX_RESPONSE_NO_CONTENT	0x24
#define	OBEX_RESPONSE_RESET_CONTENT	0x25
#define	OBEX_RESPONSE_PARTIAL_CONTENT	0x26

#define	OBEX_RESPONSE_MULTIPLE_CHOICES	0x30
#define	OBEX_RESPONSE_MOVED_PERMANENTLY	0x31
#define	OBEX_RESPONSE_MOVED_TEMPORARILY	0x32
#define	OBEX_RESPONSE_SEE_OTHER		0x33
#define OBEX_RESPONSE_NOT_MODIFIED	0x34
#define OBEX_RESPONSE_USE_PROXY		0x35

#define OBEX_RESPONSE_BAD_REQUEST	0x40
#define OBEX_RESPONSE_UNAUTHORIZED	0x41
#define OBEX_RESPONSE_PAYMENT_REQUIRED	0x42
#define OBEX_RESPONSE_FORBIDDEN		0x43
#define OBEX_RESPONSE_NOT_FOUND		0x44
#define OBEX_RESPONSE_METHOD_NOT_ALLOWED	0x45
#define OBEX_RESPONSE_NOT_ACCEPTABLE	0x46
#define OBEX_RESPONSE_PROXY_AUTH_REQ	0x47
#define OBEX_RESPONSE_REQUEST_TIMED_OUT	0x48
#define OBEX_RESPONSE_CONFLICT		0x49
#define OBEX_RESPONSE_GONE		0x4a
#define OBEX_RESPONSE_LENGTH_REQUIRED	0x4b
#define OBEX_RESPONSE_PRECONDITION_DAILED	0x4c
#define OBEX_RESPONSE_REQ_ENT_TOO_LARGE	0x4d
#define OBEX_RESPONSE_REQ_URL_TOO_LARGE	0x4e
#define OBEX_RESPONSE_UNSUPPORTED_MEDIA_TYPE	0x4f

#define OBEX_RESPONSE_INTERNAL_SERVER_ERROR	0x50
#define OBEX_RESPONSE_NOT_IMPLEMENTED	0x51
#define OBEX_RESPONSE_BAD_GATEWAY	0x52
#define OBEX_RESPONSE_SERVICE_UNAVAILABLE	0x53
#define OBEX_RESPONSE_GATEWAY_TIMEOUT	0x54
#define OBEX_RESPONSE_HTTP_VERSION_NOT_SUPPORTED	0x55

#define OBEX_RESPONSE_DATABASE_FULL	0x60
#define OBEX_RESPONSE_DATABASE_LOCKED	0x61

#define OBEX_FINAL_BIT			0x80

#define OBEX_OPCODE_CONNECT		0x80
#define OBEX_OPCODE_DISCONNECT		0x81
#define OBEX_OPCODE_PUT			0x02
#define OBEX_OPCODE_GET			0x03
#define OBEX_OPCODE_SETPATH		0x85
#define OBEX_OPCODE_SESSION		0x87
#define OBEX_OPCODE_ABORT		0xff

#define OBEX_SETPATH_UP			0x01
#define OBEX_SETPATH_DONTCREATE		0x02

#define OBEX_HI_COUNT			0xc0
#define OBEX_HI_NAME			0x01
#define OBEX_HI_TYPE			0x42
#define OBEX_HI_LENGTH			0xC3
#define OBEX_HI_TIME_ISO8601		0x44
#define OBEX_HI_TIME_COMP		0xc4
#define OBEX_HI_DESCRIPTION		0x05
#define OBEX_HI_TARGET			0x46
#define OBEX_HI_HTTP			0x47
#define OBEX_HI_BODY			0x48
#define OBEX_HI_END_OF_BODY		0x49
#define OBEX_HI_WHO			0x4a
#define OBEX_HI_CONNECTION_ID		0xcb
#define OBEX_HI_APP_PARAMETERS		0x4c
#define OBEX_HI_AUTH_CHALLANGE		0x4d
#define OBEX_HI_AUTH_RESPONSE		0x4e
#define OBEX_HI_CREATOR_ID		0xcf
#define OBEX_HI_WAN_UUID		0x50
#define OBEX_HI_OBJECT_CLASS		0x51
#define OBEX_HI_SESSION_PARAMS		0x52
#define OBEX_HI_SESSION_SEQ_NUM		0x93

#define OBEX_VERSION			0x10

#endif
