/****************************************************************************
 *    lib/c/Fluent.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef FLUENTACTION_H
#define FLUENTACTION_H
#include "Formula.h"
#include "Identifier.h"
#include "Printer.h"

#include <string>

namespace C {

class Formula;

class FluentAction : public Identifier, public Formula
{
public:
	FluentAction(string* name, Arguments* args);
	FluentAction(string* name);
	
	virtual ~FluentAction();
	
	string print(Printer* p, string T);
	string print(Printer* p);
	
	string getNameWithArgs();
	void setClass(string);
	string getClass();
	
private:
	string class_;

};
}; // end of package namespace

#endif // FLUENTACTION_H
