/****************************************************************************
 *    lib/b/DynamicRule.cpp - This file is part of coala					*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "DynamicRule.h"

using namespace B;

B::DynamicRule::DynamicRule(int line, Formula* F, Formula* G, Formula* H, Types* types) : Statement(line, types), C::DynamicRule(line, F, G, H, types) {

}

B::DynamicRule::~DynamicRule () {
	delete H_;
}

void B::DynamicRule::print(Printer* p) {
	printNonDirect(p);
}

void B::DynamicRule::printNonDirect(Printer* p) {
	p->setSection('c');

	FluentAction* f;
	FluentAction* a;
	FluentAction* g;
	string neg_f = p->neg;
	string neg_a = p->neg;
	string neg_g = p->neg;

	// holds(f, T) :- occ(a, T-1), possible(a, T-1), holds(g, T-1).
	for(vector<Formula*>::iterator fluent_f = F_->begin(); fluent_f != F_->end(); ++fluent_f) {
		set<Variable*>* vars;

		if(!(*fluent_f)->isFalse()) {
			// check for negation
			if((*fluent_f)->getType() == 'n') {
				f = (FluentAction*) (*fluent_f)->getFirstFormula();
				neg_f = p->neg;
			}
			else {
				f = (FluentAction*) *fluent_f;
				neg_f = "";
			}

			p->add("holds(" + neg_f + f->print(p) + ", " + p->T + ") :- ");

			vars = f->getVariables();
		}
		else {
			vars = new set<Variable*>();
			p->add(":- ");
		}

		// print A part
		for(vector<Formula*>::iterator action_a = H_->begin(); action_a != H_->end(); ++action_a) {
			// check for negation
			if((*action_a)->getType() == 'n') {
				a = (FluentAction*) (*action_a)->getFirstFormula();
				neg_a = p->neg;
			}
			else {
				a = (FluentAction*) *action_a;
				neg_a = "";
			}

			p->add("occ(" + neg_a + a->print(p) + ", " + p->T + "-1), ");
			p->add("possible(" + neg_a + a->print(p) + ", " + p->T + "-1)");
			if(action_a != H_->end()-1) p->add(", ");


			// get the vars
			set<Variable*>* tmp_vars = a->getVariables();
			if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
			delete tmp_vars;
		}

		// print G part
		if(G_ && !G_->isTrue()) {
			p->add(", ");

			for(vector<Formula*>::iterator fluent_g = G_->begin(); fluent_g != G_->end(); ++fluent_g) {
				// check for negation
				if((*fluent_g)->getType() == 'n') {
					g = (FluentAction*) (*fluent_g)->getFirstFormula();
					neg_g = p->neg;
				}
				else {
					g = (FluentAction*) *fluent_g;
					neg_g = "";
				}

				p->add("holds(" + neg_g + g->print(p) + ", " + p->T + "-1)");
				if(fluent_g != G_->end()-1) p->add(", ");

				// get the vars
				set<Variable*>* tmp_vars = g->getVariables();
				if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
				delete tmp_vars;
			}
		}

		if(!vars->empty()) {
			p->add(", ");
			types_.print(p, vars, line_);
		}
		p->add(".\n");
		delete vars;
	}
}
